# Add support for admission webhooks in OLM

Status: Pending

Version: v1alpha1

Implementation owner: TBD

## Abstract

Proposal to add the capability for OLM to support admission webhooks.

## Motivation

Operator authors may require an admission webhook for their operator and would like that operator to be supported under OLM.

## Proposal

### Required changes

In order to support webhooks, three new types need to be added to OLM. A complete webhook configuration utilizes a deployment, a service, and the webhook configuration. The service plus the two different webhook types would constitute all the new types that need implementing and configured. The configuring portion of the new resources will be added to the CSV. However, only the minimal portions as outlined below will be required as the rest can be generated by OLM.

The new types can be added to the existing [StrategyDetailsDeployment](https://github.com/operator-framework/operator-lifecycle-manager/blob/4de8dd1a71001df91a5bd9517435a5aeba240920/pkg/controller/install/deployment.go#L33) type given that a webhook requires a deployment for operation.

The [validating webhook](https://github.com/kubernetes/kubernetes/blob/ae3c44d043769305c6add665cd81c16319479ba7/pkg/apis/admissionregistration/types.go#L169) and [mutating webhook](https://github.com/kubernetes/kubernetes/blob/ae3c44d043769305c6add665cd81c16319479ba7/pkg/apis/admissionregistration/types.go#L293) types are extremely similar. Because of this similarity and due to the user not needing to provide service details new OLM specific types are to be created that include the critical fields.

### CSV webhook configuration example

(The following example has standard unaffected parts of configuration abbreviated.)

```yaml
...
  install:
    strategy: deployment
    spec:
      clusterPermissions:
        - serviceAccountName: my-operator
          rules:
          - apiGroups:
            - "*"
            ...
      permissions:
        - serviceAccountName: my-operator
          rules:
          - apiGroups:
            - ""
            ...
      deployments:
        - name: webhook-deployment
          spec:
            replicas: 1
            selector:
              matchLabels:
                name: mywebhook
            template:
              metadata:
                labels:
                  name: mywebhook
              spec:
                serviceAccountName: my-operator
                containers:
                - name: webhook
                  image: operator-framework/fake-webhook-image:latest
                  imagePullPolicy: IfNotPresent
                  ports:
                  - containerPort: 443
                  env:
                  - name: NAMESPACE
                    valueFrom:
                      fieldRef:
                        fieldPath: metadata.annotations['olm.targetNamespaces']
                - name: operator
                  image: operator-framework/fake-operator:latest
                  imagePullPolicy: IfNotPresent
                  env:
                  - name: NAMESPACE
                    valueFrom:
                      fieldRef:
                        fieldPath: metadata.annotations['olm.targetNamespaces']
                  - name: MY_POD_NAME
                    valueFrom:
                      fieldRef:
                        fieldPath: metadata.name
      webhooks:
      - name: olm-validation
        type: ValidatingAdmissionWebhook
        spec:
          rules:
          - apiGroups:
            - "operators.olm.com"
            apiVersions:
            - v1alpha1
            operations:
            - create
            resources:
            - clusterserviceversions
          selector:
            name: mywebhook
          webhookPath: "/admit"
      - name: olm-mutation
        type: MutatingAdmissionWebhook
        spec:
        ...
```

Notable omissions in the above example include:

- volume and volumeMounts in the deployment for the certificates
- services
- clientConfig in the webhooks section (path was retained via webhookPath)

### Securing webhook via certificates

The certificate creation and lifecycle management is planned to utilize the same certs package that is already in OLM managing the certificates for api services.
