package managementgroups

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// ChildType enumerates the values for child type.
type ChildType string

const (
	// ChildTypeManagementGroup ...
	ChildTypeManagementGroup ChildType = "ManagementGroup"
	// ChildTypeSubscription ...
	ChildTypeSubscription ChildType = "Subscription"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// PossibleChildTypeValues returns an array of possible values for the ChildType const type.
func PossibleChildTypeValues() []ChildType {
	return []ChildType{ChildTypeManagementGroup, ChildTypeSubscription}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// ChildInfo the child information of a management group.
type ChildInfo struct {
	// ChildType - Possible values include: 'ChildTypeManagementGroup', 'ChildTypeSubscription'
	ChildType ChildType `json:"childType,omitempty"`
	// ChildID - The fully qualified ID for the child resource (management group or subscription).  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ChildID *string `json:"childId,omitempty"`
	// DisplayName - The friendly name of the child resource.
	DisplayName *string `json:"displayName,omitempty"`
	// Children - The list of children.
	Children *[]ChildInfo `json:"children,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// CreateManagementGroupRequest management group creation parameters.
type CreateManagementGroupRequest struct {
	// DisplayName - The friendly name of the management group.
	DisplayName *string `json:"displayName,omitempty"`
	// ParentID - (Optional) The fully qualified ID for the parent management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ParentID *string `json:"parentId,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// Details the details of a management group.
type Details struct {
	// Version - The version number of the object.
	Version *float64 `json:"version,omitempty"`
	// UpdatedTime - The date and time when this object was last updated.
	UpdatedTime *date.Time `json:"updatedTime,omitempty"`
	// UpdatedBy - The identity of the principal or process that updated the object.
	UpdatedBy *string          `json:"updatedBy,omitempty"`
	Parent    *ParentGroupInfo `json:"parent,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// ErrorDetails the details of the error.
type ErrorDetails struct {
	// Code - One of a server-defined set of error codes.
	Code *string `json:"code,omitempty"`
	// Message - A human-readable representation of the error.
	Message *string `json:"message,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// ErrorResponse the error object.
type ErrorResponse struct {
	Error *ErrorDetails `json:"error,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// Info the management group resource.
type Info struct {
	// ID - The fully qualified ID for the management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ID *string `json:"id,omitempty"`
	// Type - The type of the resource. For example, /providers/Microsoft.Management/managementGroups
	Type *string `json:"type,omitempty"`
	// Name - The name of the management group. For example, 00000000-0000-0000-0000-000000000000
	Name            *string `json:"name,omitempty"`
	*InfoProperties `json:"properties,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// MarshalJSON is the custom marshaler for Info.
func (i Info) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.ID != nil {
		objectMap["id"] = i.ID
	}
	if i.Type != nil {
		objectMap["type"] = i.Type
	}
	if i.Name != nil {
		objectMap["name"] = i.Name
	}
	if i.InfoProperties != nil {
		objectMap["properties"] = i.InfoProperties
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// UnmarshalJSON is the custom unmarshaler for Info struct.
func (i *Info) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "properties":
			if v != nil {
				var infoProperties InfoProperties
				err = json.Unmarshal(*v, &infoProperties)
				if err != nil {
					return err
				}
				i.InfoProperties = &infoProperties
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// InfoProperties the generic properties of a management group.
type InfoProperties struct {
	// TenantID - The AAD Tenant ID associated with the management group. For example, 00000000-0000-0000-0000-000000000000
	TenantID *string `json:"tenantId,omitempty"`
	// DisplayName - The friendly name of the management group.
	DisplayName *string `json:"displayName,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// ListResult describes the result of the request to list management groups.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of management groups.
	Value *[]Info `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// ListResultIterator provides access to a complete listing of Info values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() Info {
	if !iter.page.NotDone() {
		return Info{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer() (*http.Request, error) {
	if lr.NextLink == nil || len(to.String(lr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// ListResultPage contains a page of Info values.
type ListResultPage struct {
	fn func(ListResult) (ListResult, error)
	lr ListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) Next() error {
	next, err := page.fn(page.lr)
	if err != nil {
		return err
	}
	page.lr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []Info {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// ManagementGroup the management group details.
type ManagementGroup struct {
	autorest.Response `json:"-"`
	// ID - The fully qualified ID for the management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ID *string `json:"id,omitempty"`
	// Type - The type of the resource.  For example, /providers/Microsoft.Management/managementGroups
	Type *string `json:"type,omitempty"`
	// Name - The name of the management group. For example, 00000000-0000-0000-0000-000000000000
	Name        *string `json:"name,omitempty"`
	*Properties `json:"properties,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// MarshalJSON is the custom marshaler for ManagementGroup.
func (mg ManagementGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mg.ID != nil {
		objectMap["id"] = mg.ID
	}
	if mg.Type != nil {
		objectMap["type"] = mg.Type
	}
	if mg.Name != nil {
		objectMap["name"] = mg.Name
	}
	if mg.Properties != nil {
		objectMap["properties"] = mg.Properties
	}
	return json.Marshal(objectMap)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// UnmarshalJSON is the custom unmarshaler for ManagementGroup struct.
func (mg *ManagementGroup) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mg.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mg.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mg.Name = &name
			}
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				mg.Properties = &properties
			}
		}
	}

	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// Operation operation supported by the Microsoft.Management resource provider.
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - The name of the provider.
	Provider *string `json:"provider,omitempty"`
	// Resource - The resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation that can be performed.
	Operation *string `json:"operation,omitempty"`
	// Description - Operation description.
	Description *string `json:"description,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// OperationListResult describes the result of the request to list Microsoft.Management operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the Microsoft.Management resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer() (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) Next() error {
	next, err := page.fn(page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// ParentGroupInfo (Optional) The ID of the parent management group.
type ParentGroupInfo struct {
	// ParentID - The fully qualified ID for the parent management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ParentID *string `json:"parentId,omitempty"`
	// DisplayName - The friendly name of the parent management group.
	DisplayName *string `json:"displayName,omitempty"`
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2017-11-01-preview/management instead.
// Properties the generic properties of a management group.
type Properties struct {
	// TenantID - The AAD Tenant ID associated with the management group. For example, 00000000-0000-0000-0000-000000000000
	TenantID *string `json:"tenantId,omitempty"`
	// DisplayName - The friendly name of the management group.
	DisplayName *string  `json:"displayName,omitempty"`
	Details     *Details `json:"details,omitempty"`
	// Children - The list of children.
	Children *[]ChildInfo `json:"children,omitempty"`
}
