// Package spellcheck implements the Azure ARM Spellcheck service API version 1.0.
//
// The Spell Check API - V7 lets you check a text string for spelling and grammar errors.
package spellcheck

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

const (
	// DefaultBaseURI is the default URI used for the service Spellcheck
	DefaultBaseURI = "https://api.cognitive.microsoft.com/bing/v7.0"
)

// BaseClient is the base client for Spellcheck.
type BaseClient struct {
	autorest.Client
	BaseURI string
}

// New creates an instance of the BaseClient client.
func New() BaseClient {
	return NewWithBaseURI(DefaultBaseURI)
}

// NewWithBaseURI creates an instance of the BaseClient client.
func NewWithBaseURI(baseURI string) BaseClient {
	return BaseClient{
		Client:  autorest.NewClientWithUserAgent(UserAgent()),
		BaseURI: baseURI,
	}
}

// SpellCheckerMethod sends the spell checker request.
// Parameters:
// textParameter - the text string to check for spelling and grammar errors. The combined length of the text
// string, preContextText string, and postContextText string may not exceed 10,000 characters. You may specify
// this parameter in the query string of a GET request or in the body of a POST request. Because of the query
// string length limit, you'll typically use a POST request unless you're checking only short strings.
// acceptLanguage - a comma-delimited list of one or more languages to use for user interface strings. The list
// is in decreasing order of preference. For additional information, including expected format, see
// [RFC2616](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html). This header and the setLang query
// parameter are mutually exclusive; do not specify both. If you set this header, you must also specify the cc
// query parameter. Bing will use the first supported language it finds from the list, and combine that
// language with the cc parameter value to determine the market to return results for. If the list does not
// include a supported language, Bing will find the closest language and market that supports the request, and
// may use an aggregated or default market for the results instead of a specified one. You should use this
// header and the cc query parameter only if you specify multiple languages; otherwise, you should use the mkt
// and setLang query parameters. A user interface string is a string that's used as a label in a user
// interface. There are very few user interface strings in the JSON response objects. Any links in the response
// objects to Bing.com properties will apply the specified language.
// pragma - by default, Bing returns cached content, if available. To prevent Bing from returning cached
// content, set the Pragma header to no-cache (for example, Pragma: no-cache).
// userAgent - the user agent originating the request. Bing uses the user agent to provide mobile users with an
// optimized experience. Although optional, you are strongly encouraged to always specify this header. The
// user-agent should be the same string that any commonly used browser would send. For information about user
// agents, see [RFC 2616](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
// clientID - bing uses this header to provide users with consistent behavior across Bing API calls. Bing often
// flights new features and improvements, and it uses the client ID as a key for assigning traffic on different
// flights. If you do not use the same client ID for a user across multiple requests, then Bing may assign the
// user to multiple conflicting flights. Being assigned to multiple conflicting flights can lead to an
// inconsistent user experience. For example, if the second request has a different flight assignment than the
// first, the experience may be unexpected. Also, Bing can use the client ID to tailor web results to that
// client ID’s search history, providing a richer experience for the user. Bing also uses this header to help
// improve result rankings by analyzing the activity generated by a client ID. The relevance improvements help
// with better quality of results delivered by Bing APIs and in turn enables higher click-through rates for the
// API consumer. IMPORTANT: Although optional, you should consider this header required. Persisting the client
// ID across multiple requests for the same end user and device combination enables 1) the API consumer to
// receive a consistent user experience, and 2) higher click-through rates via better quality of results from
// the Bing APIs. Each user that uses your application on the device must have a unique, Bing generated client
// ID. If you do not include this header in the request, Bing generates an ID and returns it in the
// X-MSEdge-ClientID response header. The only time that you should NOT include this header in a request is the
// first time the user uses your app on that device. Use the client ID for each Bing API request that your app
// makes for this user on the device. Persist the client ID. To persist the ID in a browser app, use a
// persistent HTTP cookie to ensure the ID is used across all sessions. Do not use a session cookie. For other
// apps such as mobile apps, use the device's persistent storage to persist the ID. The next time the user uses
// your app on that device, get the client ID that you persisted. Bing responses may or may not include this
// header. If the response includes this header, capture the client ID and use it for all subsequent Bing
// requests for the user on that device. If you include the X-MSEdge-ClientID, you must not include cookies in
// the request.
// clientIP - the IPv4 or IPv6 address of the client device. The IP address is used to discover the user's
// location. Bing uses the location information to determine safe search behavior. Although optional, you are
// encouraged to always specify this header and the X-Search-Location header. Do not obfuscate the address (for
// example, by changing the last octet to 0). Obfuscating the address results in the location not being
// anywhere near the device's actual location, which may result in Bing serving erroneous results.
// location - a semicolon-delimited list of key/value pairs that describe the client's geographical location.
// Bing uses the location information to determine safe search behavior and to return relevant local content.
// Specify the key/value pair as <key>:<value>. The following are the keys that you use to specify the user's
// location. lat (required): The latitude of the client's location, in degrees. The latitude must be greater
// than or equal to -90.0 and less than or equal to +90.0. Negative values indicate southern latitudes and
// positive values indicate northern latitudes. long (required): The longitude of the client's location, in
// degrees. The longitude must be greater than or equal to -180.0 and less than or equal to +180.0. Negative
// values indicate western longitudes and positive values indicate eastern longitudes. re (required): The
// radius, in meters, which specifies the horizontal accuracy of the coordinates. Pass the value returned by
// the device's location service. Typical values might be 22m for GPS/Wi-Fi, 380m for cell tower triangulation,
// and 18,000m for reverse IP lookup. ts (optional): The UTC UNIX timestamp of when the client was at the
// location. (The UNIX timestamp is the number of seconds since January 1, 1970.) head (optional): The client's
// relative heading or direction of travel. Specify the direction of travel as degrees from 0 through 360,
// counting clockwise relative to true north. Specify this key only if the sp key is nonzero. sp (optional):
// The horizontal velocity (speed), in meters per second, that the client device is traveling. alt (optional):
// The altitude of the client device, in meters. are (optional): The radius, in meters, that specifies the
// vertical accuracy of the coordinates. Specify this key only if you specify the alt key. Although many of the
// keys are optional, the more information that you provide, the more accurate the location results are.
// Although optional, you are encouraged to always specify the user's geographical location. Providing the
// location is especially important if the client's IP address does not accurately reflect the user's physical
// location (for example, if the client uses VPN). For optimal results, you should include this header and the
// X-Search-ClientIP header, but at a minimum, you should include this header.
// actionType - a string that's used by logging to determine whether the request is coming from an interactive
// session or a page load. The following are the possible values. 1) Edit—The request is from an interactive
// session 2) Load—The request is from a page load
// appName - the unique name of your app. The name must be known by Bing. Do not include this parameter unless
// you have previously contacted Bing to get a unique app name. To get a unique name, contact your Bing
// Business Development manager.
// countryCode - a 2-character country code of the country where the results come from. This API supports only
// the United States market. If you specify this query parameter, it must be set to us. If you set this
// parameter, you must also specify the Accept-Language header. Bing uses the first supported language it finds
// from the languages list, and combine that language with the country code that you specify to determine the
// market to return results for. If the languages list does not include a supported language, Bing finds the
// closest language and market that supports the request, or it may use an aggregated or default market for the
// results instead of a specified one. You should use this query parameter and the Accept-Language query
// parameter only if you specify multiple languages; otherwise, you should use the mkt and setLang query
// parameters. This parameter and the mkt query parameter are mutually exclusive—do not specify both.
// clientMachineName - a unique name of the device that the request is being made from. Generate a unique value
// for each device (the value is unimportant). The service uses the ID to help debug issues and improve the
// quality of corrections.
// docID - a unique ID that identifies the document that the text belongs to. Generate a unique value for each
// document (the value is unimportant). The service uses the ID to help debug issues and improve the quality of
// corrections.
// market - the market where the results come from. You are strongly encouraged to always specify the market,
// if known. Specifying the market helps Bing route the request and return an appropriate and optimal response.
// This parameter and the cc query parameter are mutually exclusive—do not specify both.
// sessionID - a unique ID that identifies this user session. Generate a unique value for each user session
// (the value is unimportant). The service uses the ID to help debug issues and improve the quality of
// corrections
// setLang - the language to use for user interface strings. Specify the language using the ISO 639-1 2-letter
// language code. For example, the language code for English is EN. The default is EN (English). Although
// optional, you should always specify the language. Typically, you set setLang to the same language specified
// by mkt unless the user wants the user interface strings displayed in a different language. This parameter
// and the Accept-Language header are mutually exclusive—do not specify both. A user interface string is a
// string that's used as a label in a user interface. There are few user interface strings in the JSON response
// objects. Also, any links to Bing.com properties in the response objects apply the specified language.
// userID - a unique ID that identifies the user. Generate a unique value for each user (the value is
// unimportant). The service uses the ID to help debug issues and improve the quality of corrections.
// mode - the type of spelling and grammar checks to perform. The following are the possible values (the values
// are case insensitive). The default is Proof. 1) Proof—Finds most spelling and grammar mistakes. 2)
// Spell—Finds most spelling mistakes but does not find some of the grammar errors that Proof catches (for
// example, capitalization and repeated words)
// preContextText - a string that gives context to the text string. For example, the text string petal is
// valid. However, if you set preContextText to bike, the context changes and the text string becomes not
// valid. In this case, the API suggests that you change petal to pedal (as in bike pedal). This text is not
// checked for grammar or spelling errors. The combined length of the text string, preContextText string, and
// postContextText string may not exceed 10,000 characters. You may specify this parameter in the query string
// of a GET request or in the body of a POST request.
// postContextText - a string that gives context to the text string. For example, the text string read is
// valid. However, if you set postContextText to carpet, the context changes and the text string becomes not
// valid. In this case, the API suggests that you change read to red (as in red carpet). This text is not
// checked for grammar or spelling errors. The combined length of the text string, preContextText string, and
// postContextText string may not exceed 10,000 characters. You may specify this parameter in the query string
// of a GET request or in the body of a POST request.
func (client BaseClient) SpellCheckerMethod(ctx context.Context, textParameter string, acceptLanguage string, pragma string, userAgent string, clientID string, clientIP string, location string, actionType ActionType, appName string, countryCode string, clientMachineName string, docID string, market string, sessionID string, setLang string, userID string, mode string, preContextText string, postContextText string) (result SpellCheck, err error) {
	req, err := client.SpellCheckerMethodPreparer(ctx, textParameter, acceptLanguage, pragma, userAgent, clientID, clientIP, location, actionType, appName, countryCode, clientMachineName, docID, market, sessionID, setLang, userID, mode, preContextText, postContextText)
	if err != nil {
		err = autorest.NewErrorWithError(err, "spellcheck.BaseClient", "SpellCheckerMethod", nil, "Failure preparing request")
		return
	}

	resp, err := client.SpellCheckerMethodSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "spellcheck.BaseClient", "SpellCheckerMethod", resp, "Failure sending request")
		return
	}

	result, err = client.SpellCheckerMethodResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "spellcheck.BaseClient", "SpellCheckerMethod", resp, "Failure responding to request")
	}

	return
}

// SpellCheckerMethodPreparer prepares the SpellCheckerMethod request.
func (client BaseClient) SpellCheckerMethodPreparer(ctx context.Context, textParameter string, acceptLanguage string, pragma string, userAgent string, clientID string, clientIP string, location string, actionType ActionType, appName string, countryCode string, clientMachineName string, docID string, market string, sessionID string, setLang string, userID string, mode string, preContextText string, postContextText string) (*http.Request, error) {
	queryParameters := map[string]interface{}{}
	if len(string(actionType)) > 0 {
		queryParameters["ActionType"] = autorest.Encode("query", actionType)
	}
	if len(appName) > 0 {
		queryParameters["AppName"] = autorest.Encode("query", appName)
	}
	if len(countryCode) > 0 {
		queryParameters["cc"] = autorest.Encode("query", countryCode)
	}
	if len(clientMachineName) > 0 {
		queryParameters["ClientMachineName"] = autorest.Encode("query", clientMachineName)
	}
	if len(docID) > 0 {
		queryParameters["DocId"] = autorest.Encode("query", docID)
	}
	if len(market) > 0 {
		queryParameters["mkt"] = autorest.Encode("query", market)
	}
	if len(sessionID) > 0 {
		queryParameters["SessionId"] = autorest.Encode("query", sessionID)
	}
	if len(setLang) > 0 {
		queryParameters["SetLang"] = autorest.Encode("query", setLang)
	}
	if len(userID) > 0 {
		queryParameters["UserId"] = autorest.Encode("query", userID)
	}

	formDataParameters := map[string]interface{}{
		"Text": textParameter,
	}
	if len(string(mode)) > 0 {
		formDataParameters["Mode"] = mode
	}
	if len(preContextText) > 0 {
		formDataParameters["PreContextText"] = preContextText
	}
	if len(postContextText) > 0 {
		formDataParameters["PostContextText"] = postContextText
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/spellcheck"),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithFormData(autorest.MapToValues(formDataParameters)),
		autorest.WithHeader("X-BingApis-SDK", "true"))
	if len(acceptLanguage) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("Accept-Language", autorest.String(acceptLanguage)))
	}
	if len(pragma) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("Pragma", autorest.String(pragma)))
	}
	if len(userAgent) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("User-Agent", autorest.String(userAgent)))
	}
	if len(clientID) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("X-MSEdge-ClientID", autorest.String(clientID)))
	}
	if len(clientIP) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("X-MSEdge-ClientIP", autorest.String(clientIP)))
	}
	if len(location) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("X-Search-Location", autorest.String(location)))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SpellCheckerMethodSender sends the SpellCheckerMethod request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) SpellCheckerMethodSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// SpellCheckerMethodResponder handles the response to the SpellCheckerMethod request. The method always
// closes the http.Response Body.
func (client BaseClient) SpellCheckerMethodResponder(resp *http.Response) (result SpellCheck, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
