package validation

import (
	"k8s.io/apimachinery/pkg/util/validation/field"

	"github.com/openshift/origin/pkg/autoscaling/admission/apis/clusterresourceoverride"
)

func Validate(config *clusterresourceoverride.ClusterResourceOverrideConfig) field.ErrorList {
	allErrs := field.ErrorList{}
	if config == nil {
		return allErrs
	}
	if config.LimitCPUToMemoryPercent == 0 && config.CPURequestToLimitPercent == 0 && config.MemoryRequestToLimitPercent == 0 {
		allErrs = append(allErrs, field.Forbidden(field.NewPath(clusterresourceoverride.PluginName), "plugin enabled but no percentages were specified"))
	}
	if config.LimitCPUToMemoryPercent < 0 {
		allErrs = append(allErrs, field.Invalid(field.NewPath(clusterresourceoverride.PluginName, "LimitCPUToMemoryPercent"), config.LimitCPUToMemoryPercent, "must be positive"))
	}
	if config.CPURequestToLimitPercent < 0 || config.CPURequestToLimitPercent > 100 {
		allErrs = append(allErrs, field.Invalid(field.NewPath(clusterresourceoverride.PluginName, "CPURequestToLimitPercent"), config.CPURequestToLimitPercent, "must be between 0 and 100"))
	}
	if config.MemoryRequestToLimitPercent < 0 || config.MemoryRequestToLimitPercent > 100 {
		allErrs = append(allErrs, field.Invalid(field.NewPath(clusterresourceoverride.PluginName, "MemoryRequestToLimitPercent"), config.MemoryRequestToLimitPercent, "must be between 0 and 100"))
	}
	return allErrs
}
