package graphrbac

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// ObjectType enumerates the values for object type.
type ObjectType string

const (
	// ObjectTypeApplication ...
	ObjectTypeApplication ObjectType = "Application"
	// ObjectTypeDirectoryObject ...
	ObjectTypeDirectoryObject ObjectType = "DirectoryObject"
	// ObjectTypeGroup ...
	ObjectTypeGroup ObjectType = "Group"
	// ObjectTypeServicePrincipal ...
	ObjectTypeServicePrincipal ObjectType = "ServicePrincipal"
	// ObjectTypeUser ...
	ObjectTypeUser ObjectType = "User"
)

// UserType enumerates the values for user type.
type UserType string

const (
	// Guest ...
	Guest UserType = "Guest"
	// Member ...
	Member UserType = "Member"
)

// AADObject the properties of an Active Directory object.
type AADObject struct {
	autorest.Response `json:"-"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ObjectID - The ID of the object.
	ObjectID *string `json:"objectId,omitempty"`
	// ObjectType - The type of AAD object.
	ObjectType *string `json:"objectType,omitempty"`
	// DisplayName - The display name of the object.
	DisplayName *string `json:"displayName,omitempty"`
	// UserPrincipalName - The principal name of the object.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// Mail - The primary email address of the object.
	Mail *string `json:"mail,omitempty"`
	// MailEnabled - Whether the AAD object is mail-enabled.
	MailEnabled *bool `json:"mailEnabled,omitempty"`
	// MailNickname - The mail alias for the user.
	MailNickname *string `json:"mailNickname,omitempty"`
	// SecurityEnabled - Whether the AAD object is security-enabled.
	SecurityEnabled *bool `json:"securityEnabled,omitempty"`
	// SignInName - The sign-in name of the object.
	SignInName *string `json:"signInName,omitempty"`
	// ServicePrincipalNames - A collection of service principal names associated with the object.
	ServicePrincipalNames *[]string `json:"servicePrincipalNames,omitempty"`
	// UserType - The user type of the object.
	UserType *string `json:"userType,omitempty"`
	// UsageLocation - A two letter country code (ISO standard 3166). Required for users that will be assigned licenses due to legal requirement to check for availability of services in countries. Examples include: "US", "JP", and "GB".
	UsageLocation *string `json:"usageLocation,omitempty"`
	// AppID - The application ID.
	AppID *string `json:"appId,omitempty"`
	// AppPermissions - The application permissions.
	AppPermissions *[]string `json:"appPermissions,omitempty"`
	// AvailableToOtherTenants - Whether the application is be available to other tenants.
	AvailableToOtherTenants *bool `json:"availableToOtherTenants,omitempty"`
	// IdentifierUris - A collection of URIs for the application.
	IdentifierUris *[]string `json:"identifierUris,omitempty"`
	// ReplyUrls - A collection of reply URLs for the application.
	ReplyUrls *[]string `json:"replyUrls,omitempty"`
	// Homepage - The home page of the application.
	Homepage *string `json:"homepage,omitempty"`
}

// MarshalJSON is the custom marshaler for AADObject.
func (ao AADObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ao.ObjectID != nil {
		objectMap["objectId"] = ao.ObjectID
	}
	if ao.ObjectType != nil {
		objectMap["objectType"] = ao.ObjectType
	}
	if ao.DisplayName != nil {
		objectMap["displayName"] = ao.DisplayName
	}
	if ao.UserPrincipalName != nil {
		objectMap["userPrincipalName"] = ao.UserPrincipalName
	}
	if ao.Mail != nil {
		objectMap["mail"] = ao.Mail
	}
	if ao.MailEnabled != nil {
		objectMap["mailEnabled"] = ao.MailEnabled
	}
	if ao.MailNickname != nil {
		objectMap["mailNickname"] = ao.MailNickname
	}
	if ao.SecurityEnabled != nil {
		objectMap["securityEnabled"] = ao.SecurityEnabled
	}
	if ao.SignInName != nil {
		objectMap["signInName"] = ao.SignInName
	}
	if ao.ServicePrincipalNames != nil {
		objectMap["servicePrincipalNames"] = ao.ServicePrincipalNames
	}
	if ao.UserType != nil {
		objectMap["userType"] = ao.UserType
	}
	if ao.UsageLocation != nil {
		objectMap["usageLocation"] = ao.UsageLocation
	}
	if ao.AppID != nil {
		objectMap["appId"] = ao.AppID
	}
	if ao.AppPermissions != nil {
		objectMap["appPermissions"] = ao.AppPermissions
	}
	if ao.AvailableToOtherTenants != nil {
		objectMap["availableToOtherTenants"] = ao.AvailableToOtherTenants
	}
	if ao.IdentifierUris != nil {
		objectMap["identifierUris"] = ao.IdentifierUris
	}
	if ao.ReplyUrls != nil {
		objectMap["replyUrls"] = ao.ReplyUrls
	}
	if ao.Homepage != nil {
		objectMap["homepage"] = ao.Homepage
	}
	for k, v := range ao.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// ADGroup active Directory group information.
type ADGroup struct {
	autorest.Response `json:"-"`
	// DisplayName - The display name of the group.
	DisplayName *string `json:"displayName,omitempty"`
	// SecurityEnabled - Whether the group is security-enable.
	SecurityEnabled *bool `json:"securityEnabled,omitempty"`
	// Mail - The primary email address of the group.
	Mail *string `json:"mail,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ObjectID - The object ID.
	ObjectID *string `json:"objectId,omitempty"`
	// DeletionTimestamp - The time at which the directory object was deleted.
	DeletionTimestamp *date.Time `json:"deletionTimestamp,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeDirectoryObject', 'ObjectTypeApplication', 'ObjectTypeGroup', 'ObjectTypeServicePrincipal', 'ObjectTypeUser'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for ADGroup.
func (ag ADGroup) MarshalJSON() ([]byte, error) {
	ag.ObjectType = ObjectTypeGroup
	objectMap := make(map[string]interface{})
	if ag.DisplayName != nil {
		objectMap["displayName"] = ag.DisplayName
	}
	if ag.SecurityEnabled != nil {
		objectMap["securityEnabled"] = ag.SecurityEnabled
	}
	if ag.Mail != nil {
		objectMap["mail"] = ag.Mail
	}
	if ag.ObjectID != nil {
		objectMap["objectId"] = ag.ObjectID
	}
	if ag.DeletionTimestamp != nil {
		objectMap["deletionTimestamp"] = ag.DeletionTimestamp
	}
	objectMap["objectType"] = ag.ObjectType
	for k, v := range ag.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsApplication is the BasicDirectoryObject implementation for ADGroup.
func (ag ADGroup) AsApplication() (*Application, bool) {
	return nil, false
}

// AsADGroup is the BasicDirectoryObject implementation for ADGroup.
func (ag ADGroup) AsADGroup() (*ADGroup, bool) {
	return &ag, true
}

// AsServicePrincipal is the BasicDirectoryObject implementation for ADGroup.
func (ag ADGroup) AsServicePrincipal() (*ServicePrincipal, bool) {
	return nil, false
}

// AsUser is the BasicDirectoryObject implementation for ADGroup.
func (ag ADGroup) AsUser() (*User, bool) {
	return nil, false
}

// AsDirectoryObject is the BasicDirectoryObject implementation for ADGroup.
func (ag ADGroup) AsDirectoryObject() (*DirectoryObject, bool) {
	return nil, false
}

// AsBasicDirectoryObject is the BasicDirectoryObject implementation for ADGroup.
func (ag ADGroup) AsBasicDirectoryObject() (BasicDirectoryObject, bool) {
	return &ag, true
}

// Application active Directory application information.
type Application struct {
	autorest.Response `json:"-"`
	// AppID - The application ID.
	AppID *string `json:"appId,omitempty"`
	// AppPermissions - The application permissions.
	AppPermissions *[]string `json:"appPermissions,omitempty"`
	// AvailableToOtherTenants - Whether the application is be available to other tenants.
	AvailableToOtherTenants *bool `json:"availableToOtherTenants,omitempty"`
	// DisplayName - The display name of the application.
	DisplayName *string `json:"displayName,omitempty"`
	// IdentifierUris - A collection of URIs for the application.
	IdentifierUris *[]string `json:"identifierUris,omitempty"`
	// ReplyUrls - A collection of reply URLs for the application.
	ReplyUrls *[]string `json:"replyUrls,omitempty"`
	// Homepage - The home page of the application.
	Homepage *string `json:"homepage,omitempty"`
	// Oauth2AllowImplicitFlow - Whether to allow implicit grant flow for OAuth2
	Oauth2AllowImplicitFlow *bool `json:"oauth2AllowImplicitFlow,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ObjectID - The object ID.
	ObjectID *string `json:"objectId,omitempty"`
	// DeletionTimestamp - The time at which the directory object was deleted.
	DeletionTimestamp *date.Time `json:"deletionTimestamp,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeDirectoryObject', 'ObjectTypeApplication', 'ObjectTypeGroup', 'ObjectTypeServicePrincipal', 'ObjectTypeUser'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for Application.
func (a Application) MarshalJSON() ([]byte, error) {
	a.ObjectType = ObjectTypeApplication
	objectMap := make(map[string]interface{})
	if a.AppID != nil {
		objectMap["appId"] = a.AppID
	}
	if a.AppPermissions != nil {
		objectMap["appPermissions"] = a.AppPermissions
	}
	if a.AvailableToOtherTenants != nil {
		objectMap["availableToOtherTenants"] = a.AvailableToOtherTenants
	}
	if a.DisplayName != nil {
		objectMap["displayName"] = a.DisplayName
	}
	if a.IdentifierUris != nil {
		objectMap["identifierUris"] = a.IdentifierUris
	}
	if a.ReplyUrls != nil {
		objectMap["replyUrls"] = a.ReplyUrls
	}
	if a.Homepage != nil {
		objectMap["homepage"] = a.Homepage
	}
	if a.Oauth2AllowImplicitFlow != nil {
		objectMap["oauth2AllowImplicitFlow"] = a.Oauth2AllowImplicitFlow
	}
	if a.ObjectID != nil {
		objectMap["objectId"] = a.ObjectID
	}
	if a.DeletionTimestamp != nil {
		objectMap["deletionTimestamp"] = a.DeletionTimestamp
	}
	objectMap["objectType"] = a.ObjectType
	for k, v := range a.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsApplication is the BasicDirectoryObject implementation for Application.
func (a Application) AsApplication() (*Application, bool) {
	return &a, true
}

// AsADGroup is the BasicDirectoryObject implementation for Application.
func (a Application) AsADGroup() (*ADGroup, bool) {
	return nil, false
}

// AsServicePrincipal is the BasicDirectoryObject implementation for Application.
func (a Application) AsServicePrincipal() (*ServicePrincipal, bool) {
	return nil, false
}

// AsUser is the BasicDirectoryObject implementation for Application.
func (a Application) AsUser() (*User, bool) {
	return nil, false
}

// AsDirectoryObject is the BasicDirectoryObject implementation for Application.
func (a Application) AsDirectoryObject() (*DirectoryObject, bool) {
	return nil, false
}

// AsBasicDirectoryObject is the BasicDirectoryObject implementation for Application.
func (a Application) AsBasicDirectoryObject() (BasicDirectoryObject, bool) {
	return &a, true
}

// ApplicationAddOwnerParameters request parameters for adding a owner to an application.
type ApplicationAddOwnerParameters struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// URL - A owner object URL, such as "https://graph.windows.net/0b1f9851-1bf0-433f-aec3-cb9272f093dc/directoryObjects/f260bbc4-c254-447b-94cf-293b5ec434dd", where "0b1f9851-1bf0-433f-aec3-cb9272f093dc" is the tenantId and "f260bbc4-c254-447b-94cf-293b5ec434dd" is the objectId of the owner (user, application, servicePrincipal, group) to be added.
	URL *string `json:"url,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationAddOwnerParameters.
func (aaop ApplicationAddOwnerParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aaop.URL != nil {
		objectMap["url"] = aaop.URL
	}
	for k, v := range aaop.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// ApplicationCreateParameters request parameters for creating a new application.
type ApplicationCreateParameters struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// AvailableToOtherTenants - Whether the application is available to other tenants.
	AvailableToOtherTenants *bool `json:"availableToOtherTenants,omitempty"`
	// DisplayName - The display name of the application.
	DisplayName *string `json:"displayName,omitempty"`
	// Homepage - The home page of the application.
	Homepage *string `json:"homepage,omitempty"`
	// IdentifierUris - A collection of URIs for the application.
	IdentifierUris *[]string `json:"identifierUris,omitempty"`
	// ReplyUrls - A collection of reply URLs for the application.
	ReplyUrls *[]string `json:"replyUrls,omitempty"`
	// KeyCredentials - The list of KeyCredential objects.
	KeyCredentials *[]KeyCredential `json:"keyCredentials,omitempty"`
	// PasswordCredentials - The list of PasswordCredential objects.
	PasswordCredentials *[]PasswordCredential `json:"passwordCredentials,omitempty"`
	// Oauth2AllowImplicitFlow - Whether to allow implicit grant flow for OAuth2
	Oauth2AllowImplicitFlow *bool `json:"oauth2AllowImplicitFlow,omitempty"`
	// RequiredResourceAccess - Specifies resources that this application requires access to and the set of OAuth permission scopes and application roles that it needs under each of those resources. This pre-configuration of required resource access drives the consent experience.
	RequiredResourceAccess *[]RequiredResourceAccess `json:"requiredResourceAccess,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationCreateParameters.
func (acp ApplicationCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if acp.AvailableToOtherTenants != nil {
		objectMap["availableToOtherTenants"] = acp.AvailableToOtherTenants
	}
	if acp.DisplayName != nil {
		objectMap["displayName"] = acp.DisplayName
	}
	if acp.Homepage != nil {
		objectMap["homepage"] = acp.Homepage
	}
	if acp.IdentifierUris != nil {
		objectMap["identifierUris"] = acp.IdentifierUris
	}
	if acp.ReplyUrls != nil {
		objectMap["replyUrls"] = acp.ReplyUrls
	}
	if acp.KeyCredentials != nil {
		objectMap["keyCredentials"] = acp.KeyCredentials
	}
	if acp.PasswordCredentials != nil {
		objectMap["passwordCredentials"] = acp.PasswordCredentials
	}
	if acp.Oauth2AllowImplicitFlow != nil {
		objectMap["oauth2AllowImplicitFlow"] = acp.Oauth2AllowImplicitFlow
	}
	if acp.RequiredResourceAccess != nil {
		objectMap["requiredResourceAccess"] = acp.RequiredResourceAccess
	}
	for k, v := range acp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// ApplicationListResult application list operation result.
type ApplicationListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of applications.
	Value *[]Application `json:"value,omitempty"`
	// OdataNextLink - The URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// ApplicationListResultIterator provides access to a complete listing of Application values.
type ApplicationListResultIterator struct {
	i    int
	page ApplicationListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationListResultIterator) Response() ApplicationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationListResultIterator) Value() Application {
	if !iter.page.NotDone() {
		return Application{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (alr ApplicationListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// ApplicationListResultPage contains a page of Application values.
type ApplicationListResultPage struct {
	fn  func(ApplicationListResult) (ApplicationListResult, error)
	alr ApplicationListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationListResultPage) Next() error {
	next, err := page.fn(page.alr)
	if err != nil {
		return err
	}
	page.alr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationListResultPage) Response() ApplicationListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationListResultPage) Values() []Application {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// ApplicationUpdateParameters request parameters for updating an existing application.
type ApplicationUpdateParameters struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// AvailableToOtherTenants - Whether the application is available to other tenants
	AvailableToOtherTenants *bool `json:"availableToOtherTenants,omitempty"`
	// DisplayName - The display name of the application.
	DisplayName *string `json:"displayName,omitempty"`
	// Homepage - The home page of the application.
	Homepage *string `json:"homepage,omitempty"`
	// IdentifierUris - A collection of URIs for the application.
	IdentifierUris *[]string `json:"identifierUris,omitempty"`
	// ReplyUrls - A collection of reply URLs for the application.
	ReplyUrls *[]string `json:"replyUrls,omitempty"`
	// KeyCredentials - The list of KeyCredential objects.
	KeyCredentials *[]KeyCredential `json:"keyCredentials,omitempty"`
	// PasswordCredentials - The list of PasswordCredential objects.
	PasswordCredentials *[]PasswordCredential `json:"passwordCredentials,omitempty"`
	// Oauth2AllowImplicitFlow - Whether to allow implicit grant flow for OAuth2
	Oauth2AllowImplicitFlow *bool `json:"oauth2AllowImplicitFlow,omitempty"`
	// RequiredResourceAccess - Specifies resources that this application requires access to and the set of OAuth permission scopes and application roles that it needs under each of those resources. This pre-configuration of required resource access drives the consent experience.
	RequiredResourceAccess *[]RequiredResourceAccess `json:"requiredResourceAccess,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationUpdateParameters.
func (aup ApplicationUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aup.AvailableToOtherTenants != nil {
		objectMap["availableToOtherTenants"] = aup.AvailableToOtherTenants
	}
	if aup.DisplayName != nil {
		objectMap["displayName"] = aup.DisplayName
	}
	if aup.Homepage != nil {
		objectMap["homepage"] = aup.Homepage
	}
	if aup.IdentifierUris != nil {
		objectMap["identifierUris"] = aup.IdentifierUris
	}
	if aup.ReplyUrls != nil {
		objectMap["replyUrls"] = aup.ReplyUrls
	}
	if aup.KeyCredentials != nil {
		objectMap["keyCredentials"] = aup.KeyCredentials
	}
	if aup.PasswordCredentials != nil {
		objectMap["passwordCredentials"] = aup.PasswordCredentials
	}
	if aup.Oauth2AllowImplicitFlow != nil {
		objectMap["oauth2AllowImplicitFlow"] = aup.Oauth2AllowImplicitFlow
	}
	if aup.RequiredResourceAccess != nil {
		objectMap["requiredResourceAccess"] = aup.RequiredResourceAccess
	}
	for k, v := range aup.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// CheckGroupMembershipParameters request parameters for IsMemberOf API call.
type CheckGroupMembershipParameters struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// GroupID - The object ID of the group to check.
	GroupID *string `json:"groupId,omitempty"`
	// MemberID - The object ID of the contact, group, user, or service principal to check for membership in the specified group.
	MemberID *string `json:"memberId,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckGroupMembershipParameters.
func (cgmp CheckGroupMembershipParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cgmp.GroupID != nil {
		objectMap["groupId"] = cgmp.GroupID
	}
	if cgmp.MemberID != nil {
		objectMap["memberId"] = cgmp.MemberID
	}
	for k, v := range cgmp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// CheckGroupMembershipResult server response for IsMemberOf API call
type CheckGroupMembershipResult struct {
	autorest.Response `json:"-"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Value - True if the specified user, group, contact, or service principal has either direct or transitive membership in the specified group; otherwise, false.
	Value *bool `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for CheckGroupMembershipResult.
func (cgmr CheckGroupMembershipResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cgmr.Value != nil {
		objectMap["value"] = cgmr.Value
	}
	for k, v := range cgmr.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// BasicDirectoryObject represents an Azure Active Directory object.
type BasicDirectoryObject interface {
	AsApplication() (*Application, bool)
	AsADGroup() (*ADGroup, bool)
	AsServicePrincipal() (*ServicePrincipal, bool)
	AsUser() (*User, bool)
	AsDirectoryObject() (*DirectoryObject, bool)
}

// DirectoryObject represents an Azure Active Directory object.
type DirectoryObject struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ObjectID - The object ID.
	ObjectID *string `json:"objectId,omitempty"`
	// DeletionTimestamp - The time at which the directory object was deleted.
	DeletionTimestamp *date.Time `json:"deletionTimestamp,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeDirectoryObject', 'ObjectTypeApplication', 'ObjectTypeGroup', 'ObjectTypeServicePrincipal', 'ObjectTypeUser'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

func unmarshalBasicDirectoryObject(body []byte) (BasicDirectoryObject, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeApplication):
		var a Application
		err := json.Unmarshal(body, &a)
		return a, err
	case string(ObjectTypeGroup):
		var ag ADGroup
		err := json.Unmarshal(body, &ag)
		return ag, err
	case string(ObjectTypeServicePrincipal):
		var sp ServicePrincipal
		err := json.Unmarshal(body, &sp)
		return sp, err
	case string(ObjectTypeUser):
		var u User
		err := json.Unmarshal(body, &u)
		return u, err
	default:
		var do DirectoryObject
		err := json.Unmarshal(body, &do)
		return do, err
	}
}
func unmarshalBasicDirectoryObjectArray(body []byte) ([]BasicDirectoryObject, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	doArray := make([]BasicDirectoryObject, len(rawMessages))

	for index, rawMessage := range rawMessages {
		do, err := unmarshalBasicDirectoryObject(*rawMessage)
		if err != nil {
			return nil, err
		}
		doArray[index] = do
	}
	return doArray, nil
}

// MarshalJSON is the custom marshaler for DirectoryObject.
func (do DirectoryObject) MarshalJSON() ([]byte, error) {
	do.ObjectType = ObjectTypeDirectoryObject
	objectMap := make(map[string]interface{})
	if do.ObjectID != nil {
		objectMap["objectId"] = do.ObjectID
	}
	if do.DeletionTimestamp != nil {
		objectMap["deletionTimestamp"] = do.DeletionTimestamp
	}
	objectMap["objectType"] = do.ObjectType
	for k, v := range do.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsApplication is the BasicDirectoryObject implementation for DirectoryObject.
func (do DirectoryObject) AsApplication() (*Application, bool) {
	return nil, false
}

// AsADGroup is the BasicDirectoryObject implementation for DirectoryObject.
func (do DirectoryObject) AsADGroup() (*ADGroup, bool) {
	return nil, false
}

// AsServicePrincipal is the BasicDirectoryObject implementation for DirectoryObject.
func (do DirectoryObject) AsServicePrincipal() (*ServicePrincipal, bool) {
	return nil, false
}

// AsUser is the BasicDirectoryObject implementation for DirectoryObject.
func (do DirectoryObject) AsUser() (*User, bool) {
	return nil, false
}

// AsDirectoryObject is the BasicDirectoryObject implementation for DirectoryObject.
func (do DirectoryObject) AsDirectoryObject() (*DirectoryObject, bool) {
	return &do, true
}

// AsBasicDirectoryObject is the BasicDirectoryObject implementation for DirectoryObject.
func (do DirectoryObject) AsBasicDirectoryObject() (BasicDirectoryObject, bool) {
	return &do, true
}

// DirectoryObjectListResult directoryObject list operation result.
type DirectoryObjectListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of DirectoryObject.
	Value *[]BasicDirectoryObject `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for DirectoryObjectListResult struct.
func (dolr *DirectoryObjectListResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "value":
			if v != nil {
				value, err := unmarshalBasicDirectoryObjectArray(*v)
				if err != nil {
					return err
				}
				dolr.Value = &value
			}
		}
	}

	return nil
}

// Domain active Directory Domain information.
type Domain struct {
	autorest.Response `json:"-"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// AuthenticationType - the type of the authentication into the domain.
	AuthenticationType *string `json:"authenticationType,omitempty"`
	// IsDefault - if this is the default domain in the tenant.
	IsDefault *bool `json:"isDefault,omitempty"`
	// IsVerified - if this domain's ownership is verified.
	IsVerified *bool `json:"isVerified,omitempty"`
	// Name - the domain name.
	Name *string `json:"name,omitempty"`
}

// MarshalJSON is the custom marshaler for Domain.
func (d Domain) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.AuthenticationType != nil {
		objectMap["authenticationType"] = d.AuthenticationType
	}
	if d.IsDefault != nil {
		objectMap["isDefault"] = d.IsDefault
	}
	if d.IsVerified != nil {
		objectMap["isVerified"] = d.IsVerified
	}
	if d.Name != nil {
		objectMap["name"] = d.Name
	}
	for k, v := range d.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// DomainListResult server response for Get tenant domains API call.
type DomainListResult struct {
	autorest.Response `json:"-"`
	// Value - the list of domains.
	Value *[]Domain `json:"value,omitempty"`
}

// ErrorMessage active Directory error message.
type ErrorMessage struct {
	// Message - Error message value.
	Message *string `json:"value,omitempty"`
}

// GetObjectsParameters request parameters for the GetObjectsByObjectIds API.
type GetObjectsParameters struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ObjectIds - The requested object IDs.
	ObjectIds *[]string `json:"objectIds,omitempty"`
	// Types - The requested object types.
	Types *[]string `json:"types,omitempty"`
	// IncludeDirectoryObjectReferences - If true, also searches for object IDs in the partner tenant.
	IncludeDirectoryObjectReferences *bool `json:"includeDirectoryObjectReferences,omitempty"`
}

// MarshalJSON is the custom marshaler for GetObjectsParameters.
func (gop GetObjectsParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gop.ObjectIds != nil {
		objectMap["objectIds"] = gop.ObjectIds
	}
	if gop.Types != nil {
		objectMap["types"] = gop.Types
	}
	if gop.IncludeDirectoryObjectReferences != nil {
		objectMap["includeDirectoryObjectReferences"] = gop.IncludeDirectoryObjectReferences
	}
	for k, v := range gop.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// GetObjectsResult the response to an Active Directory object inquiry API request.
type GetObjectsResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of Active Directory objects.
	Value *[]AADObject `json:"value,omitempty"`
	// OdataNextLink - The URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// GetObjectsResultIterator provides access to a complete listing of AADObject values.
type GetObjectsResultIterator struct {
	i    int
	page GetObjectsResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GetObjectsResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GetObjectsResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GetObjectsResultIterator) Response() GetObjectsResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GetObjectsResultIterator) Value() AADObject {
	if !iter.page.NotDone() {
		return AADObject{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (gor GetObjectsResult) IsEmpty() bool {
	return gor.Value == nil || len(*gor.Value) == 0
}

// GetObjectsResultPage contains a page of AADObject values.
type GetObjectsResultPage struct {
	fn  func(GetObjectsResult) (GetObjectsResult, error)
	gor GetObjectsResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GetObjectsResultPage) Next() error {
	next, err := page.fn(page.gor)
	if err != nil {
		return err
	}
	page.gor = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GetObjectsResultPage) NotDone() bool {
	return !page.gor.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GetObjectsResultPage) Response() GetObjectsResult {
	return page.gor
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GetObjectsResultPage) Values() []AADObject {
	if page.gor.IsEmpty() {
		return nil
	}
	return *page.gor.Value
}

// GraphError active Directory error information.
type GraphError struct {
	// OdataError - A Graph API error.
	*OdataError `json:"odata.error,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for GraphError struct.
func (ge *GraphError) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "odata.error":
			if v != nil {
				var odataError OdataError
				err = json.Unmarshal(*v, &odataError)
				if err != nil {
					return err
				}
				ge.OdataError = &odataError
			}
		}
	}

	return nil
}

// GroupAddMemberParameters request parameters for adding a member to a group.
type GroupAddMemberParameters struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// URL - A member object URL, such as "https://graph.windows.net/0b1f9851-1bf0-433f-aec3-cb9272f093dc/directoryObjects/f260bbc4-c254-447b-94cf-293b5ec434dd", where "0b1f9851-1bf0-433f-aec3-cb9272f093dc" is the tenantId and "f260bbc4-c254-447b-94cf-293b5ec434dd" is the objectId of the member (user, application, servicePrincipal, group) to be added.
	URL *string `json:"url,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupAddMemberParameters.
func (gamp GroupAddMemberParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gamp.URL != nil {
		objectMap["url"] = gamp.URL
	}
	for k, v := range gamp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// GroupCreateParameters request parameters for creating a new group.
type GroupCreateParameters struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// DisplayName - Group display name
	DisplayName *string `json:"displayName,omitempty"`
	// MailEnabled - Whether the group is mail-enabled. Must be false. This is because only pure security groups can be created using the Graph API.
	MailEnabled *bool `json:"mailEnabled,omitempty"`
	// MailNickname - Mail nickname
	MailNickname *string `json:"mailNickname,omitempty"`
	// SecurityEnabled - Whether the group is a security group. Must be true. This is because only pure security groups can be created using the Graph API.
	SecurityEnabled *bool `json:"securityEnabled,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupCreateParameters.
func (gcp GroupCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gcp.DisplayName != nil {
		objectMap["displayName"] = gcp.DisplayName
	}
	if gcp.MailEnabled != nil {
		objectMap["mailEnabled"] = gcp.MailEnabled
	}
	if gcp.MailNickname != nil {
		objectMap["mailNickname"] = gcp.MailNickname
	}
	if gcp.SecurityEnabled != nil {
		objectMap["securityEnabled"] = gcp.SecurityEnabled
	}
	for k, v := range gcp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// GroupGetMemberGroupsParameters request parameters for GetMemberGroups API call.
type GroupGetMemberGroupsParameters struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SecurityEnabledOnly - If true, only membership in security-enabled groups should be checked. Otherwise, membership in all groups should be checked.
	SecurityEnabledOnly *bool `json:"securityEnabledOnly,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupGetMemberGroupsParameters.
func (ggmgp GroupGetMemberGroupsParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ggmgp.SecurityEnabledOnly != nil {
		objectMap["securityEnabledOnly"] = ggmgp.SecurityEnabledOnly
	}
	for k, v := range ggmgp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// GroupGetMemberGroupsResult server response for GetMemberGroups API call.
type GroupGetMemberGroupsResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of group IDs of which the group is a member.
	Value *[]string `json:"value,omitempty"`
}

// GroupListResult server response for Get tenant groups API call
type GroupListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of Active Directory groups.
	Value *[]ADGroup `json:"value,omitempty"`
	// OdataNextLink - The URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// GroupListResultIterator provides access to a complete listing of ADGroup values.
type GroupListResultIterator struct {
	i    int
	page GroupListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GroupListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GroupListResultIterator) Response() GroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GroupListResultIterator) Value() ADGroup {
	if !iter.page.NotDone() {
		return ADGroup{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (glr GroupListResult) IsEmpty() bool {
	return glr.Value == nil || len(*glr.Value) == 0
}

// GroupListResultPage contains a page of ADGroup values.
type GroupListResultPage struct {
	fn  func(GroupListResult) (GroupListResult, error)
	glr GroupListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GroupListResultPage) Next() error {
	next, err := page.fn(page.glr)
	if err != nil {
		return err
	}
	page.glr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GroupListResultPage) NotDone() bool {
	return !page.glr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GroupListResultPage) Response() GroupListResult {
	return page.glr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GroupListResultPage) Values() []ADGroup {
	if page.glr.IsEmpty() {
		return nil
	}
	return *page.glr.Value
}

// KeyCredential active Directory Key Credential information.
type KeyCredential struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// StartDate - Start date.
	StartDate *date.Time `json:"startDate,omitempty"`
	// EndDate - End date.
	EndDate *date.Time `json:"endDate,omitempty"`
	// Value - Key value.
	Value *string `json:"value,omitempty"`
	// KeyID - Key ID.
	KeyID *string `json:"keyId,omitempty"`
	// Usage - Usage. Acceptable values are 'Verify' and 'Sign'.
	Usage *string `json:"usage,omitempty"`
	// Type - Type. Acceptable values are 'AsymmetricX509Cert' and 'Symmetric'.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for KeyCredential.
func (kc KeyCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if kc.StartDate != nil {
		objectMap["startDate"] = kc.StartDate
	}
	if kc.EndDate != nil {
		objectMap["endDate"] = kc.EndDate
	}
	if kc.Value != nil {
		objectMap["value"] = kc.Value
	}
	if kc.KeyID != nil {
		objectMap["keyId"] = kc.KeyID
	}
	if kc.Usage != nil {
		objectMap["usage"] = kc.Usage
	}
	if kc.Type != nil {
		objectMap["type"] = kc.Type
	}
	for k, v := range kc.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// KeyCredentialListResult keyCredential list operation result.
type KeyCredentialListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of KeyCredentials.
	Value *[]KeyCredential `json:"value,omitempty"`
}

// KeyCredentialsUpdateParameters request parameters for a KeyCredentials update operation
type KeyCredentialsUpdateParameters struct {
	// Value - A collection of KeyCredentials.
	Value *[]KeyCredential `json:"value,omitempty"`
}

// OdataError active Directory OData error information.
type OdataError struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// ErrorMessage - Error Message.
	*ErrorMessage `json:"message,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for OdataError struct.
func (oe *OdataError) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "code":
			if v != nil {
				var code string
				err = json.Unmarshal(*v, &code)
				if err != nil {
					return err
				}
				oe.Code = &code
			}
		case "message":
			if v != nil {
				var errorMessage ErrorMessage
				err = json.Unmarshal(*v, &errorMessage)
				if err != nil {
					return err
				}
				oe.ErrorMessage = &errorMessage
			}
		}
	}

	return nil
}

// PasswordCredential active Directory Password Credential information.
type PasswordCredential struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// StartDate - Start date.
	StartDate *date.Time `json:"startDate,omitempty"`
	// EndDate - End date.
	EndDate *date.Time `json:"endDate,omitempty"`
	// KeyID - Key ID.
	KeyID *string `json:"keyId,omitempty"`
	// Value - Key value.
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for PasswordCredential.
func (pc PasswordCredential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pc.StartDate != nil {
		objectMap["startDate"] = pc.StartDate
	}
	if pc.EndDate != nil {
		objectMap["endDate"] = pc.EndDate
	}
	if pc.KeyID != nil {
		objectMap["keyId"] = pc.KeyID
	}
	if pc.Value != nil {
		objectMap["value"] = pc.Value
	}
	for k, v := range pc.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// PasswordCredentialListResult passwordCredential list operation result.
type PasswordCredentialListResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of PasswordCredentials.
	Value *[]PasswordCredential `json:"value,omitempty"`
}

// PasswordCredentialsUpdateParameters request parameters for a PasswordCredentials update operation.
type PasswordCredentialsUpdateParameters struct {
	// Value - A collection of PasswordCredentials.
	Value *[]PasswordCredential `json:"value,omitempty"`
}

// PasswordProfile the password profile associated with a user.
type PasswordProfile struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Password - Password
	Password *string `json:"password,omitempty"`
	// ForceChangePasswordNextLogin - Whether to force a password change on next login.
	ForceChangePasswordNextLogin *bool `json:"forceChangePasswordNextLogin,omitempty"`
}

// MarshalJSON is the custom marshaler for PasswordProfile.
func (pp PasswordProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pp.Password != nil {
		objectMap["password"] = pp.Password
	}
	if pp.ForceChangePasswordNextLogin != nil {
		objectMap["forceChangePasswordNextLogin"] = pp.ForceChangePasswordNextLogin
	}
	for k, v := range pp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// RequiredResourceAccess specifies the set of OAuth 2.0 permission scopes and app roles under the specified
// resource that an application requires access to. The specified OAuth 2.0 permission scopes may be requested by
// client applications (through the requiredResourceAccess collection) when calling a resource application. The
// requiredResourceAccess property of the Application entity is a collection of ReqiredResourceAccess.
type RequiredResourceAccess struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ResourceAccess - The list of OAuth2.0 permission scopes and app roles that the application requires from the specified resource.
	ResourceAccess *[]ResourceAccess `json:"resourceAccess,omitempty"`
	// ResourceAppID - The unique identifier for the resource that the application requires access to. This should be equal to the appId declared on the target resource application.
	ResourceAppID *string `json:"resourceAppId,omitempty"`
}

// MarshalJSON is the custom marshaler for RequiredResourceAccess.
func (rra RequiredResourceAccess) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rra.ResourceAccess != nil {
		objectMap["resourceAccess"] = rra.ResourceAccess
	}
	if rra.ResourceAppID != nil {
		objectMap["resourceAppId"] = rra.ResourceAppID
	}
	for k, v := range rra.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// ResourceAccess specifies an OAuth 2.0 permission scope or an app role that an application requires. The
// resourceAccess property of the RequiredResourceAccess type is a collection of ResourceAccess.
type ResourceAccess struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ID - The unique identifier for one of the OAuth2Permission or AppRole instances that the resource application exposes.
	ID *string `json:"id,omitempty"`
	// Type - Specifies whether the id property references an OAuth2Permission or an AppRole. Possible values are "scope" or "role".
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ResourceAccess.
func (ra ResourceAccess) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ra.ID != nil {
		objectMap["id"] = ra.ID
	}
	if ra.Type != nil {
		objectMap["type"] = ra.Type
	}
	for k, v := range ra.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// ServicePrincipal active Directory service principal information.
type ServicePrincipal struct {
	autorest.Response `json:"-"`
	// DisplayName - The display name of the service principal.
	DisplayName *string `json:"displayName,omitempty"`
	// AppID - The application ID.
	AppID *string `json:"appId,omitempty"`
	// ServicePrincipalNames - A collection of service principal names.
	ServicePrincipalNames *[]string `json:"servicePrincipalNames,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ObjectID - The object ID.
	ObjectID *string `json:"objectId,omitempty"`
	// DeletionTimestamp - The time at which the directory object was deleted.
	DeletionTimestamp *date.Time `json:"deletionTimestamp,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeDirectoryObject', 'ObjectTypeApplication', 'ObjectTypeGroup', 'ObjectTypeServicePrincipal', 'ObjectTypeUser'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for ServicePrincipal.
func (sp ServicePrincipal) MarshalJSON() ([]byte, error) {
	sp.ObjectType = ObjectTypeServicePrincipal
	objectMap := make(map[string]interface{})
	if sp.DisplayName != nil {
		objectMap["displayName"] = sp.DisplayName
	}
	if sp.AppID != nil {
		objectMap["appId"] = sp.AppID
	}
	if sp.ServicePrincipalNames != nil {
		objectMap["servicePrincipalNames"] = sp.ServicePrincipalNames
	}
	if sp.ObjectID != nil {
		objectMap["objectId"] = sp.ObjectID
	}
	if sp.DeletionTimestamp != nil {
		objectMap["deletionTimestamp"] = sp.DeletionTimestamp
	}
	objectMap["objectType"] = sp.ObjectType
	for k, v := range sp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsApplication is the BasicDirectoryObject implementation for ServicePrincipal.
func (sp ServicePrincipal) AsApplication() (*Application, bool) {
	return nil, false
}

// AsADGroup is the BasicDirectoryObject implementation for ServicePrincipal.
func (sp ServicePrincipal) AsADGroup() (*ADGroup, bool) {
	return nil, false
}

// AsServicePrincipal is the BasicDirectoryObject implementation for ServicePrincipal.
func (sp ServicePrincipal) AsServicePrincipal() (*ServicePrincipal, bool) {
	return &sp, true
}

// AsUser is the BasicDirectoryObject implementation for ServicePrincipal.
func (sp ServicePrincipal) AsUser() (*User, bool) {
	return nil, false
}

// AsDirectoryObject is the BasicDirectoryObject implementation for ServicePrincipal.
func (sp ServicePrincipal) AsDirectoryObject() (*DirectoryObject, bool) {
	return nil, false
}

// AsBasicDirectoryObject is the BasicDirectoryObject implementation for ServicePrincipal.
func (sp ServicePrincipal) AsBasicDirectoryObject() (BasicDirectoryObject, bool) {
	return &sp, true
}

// ServicePrincipalCreateParameters request parameters for creating a new service principal.
type ServicePrincipalCreateParameters struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// AppID - application Id
	AppID *string `json:"appId,omitempty"`
	// AccountEnabled - Whether the account is enabled
	AccountEnabled *bool `json:"accountEnabled,omitempty"`
	// KeyCredentials - A collection of KeyCredential objects.
	KeyCredentials *[]KeyCredential `json:"keyCredentials,omitempty"`
	// PasswordCredentials - A collection of PasswordCredential objects
	PasswordCredentials *[]PasswordCredential `json:"passwordCredentials,omitempty"`
}

// MarshalJSON is the custom marshaler for ServicePrincipalCreateParameters.
func (spcp ServicePrincipalCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spcp.AppID != nil {
		objectMap["appId"] = spcp.AppID
	}
	if spcp.AccountEnabled != nil {
		objectMap["accountEnabled"] = spcp.AccountEnabled
	}
	if spcp.KeyCredentials != nil {
		objectMap["keyCredentials"] = spcp.KeyCredentials
	}
	if spcp.PasswordCredentials != nil {
		objectMap["passwordCredentials"] = spcp.PasswordCredentials
	}
	for k, v := range spcp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// ServicePrincipalListResult server response for get tenant service principals API call.
type ServicePrincipalListResult struct {
	autorest.Response `json:"-"`
	// Value - the list of service principals.
	Value *[]ServicePrincipal `json:"value,omitempty"`
	// OdataNextLink - the URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// ServicePrincipalListResultIterator provides access to a complete listing of ServicePrincipal values.
type ServicePrincipalListResultIterator struct {
	i    int
	page ServicePrincipalListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServicePrincipalListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServicePrincipalListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServicePrincipalListResultIterator) Response() ServicePrincipalListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServicePrincipalListResultIterator) Value() ServicePrincipal {
	if !iter.page.NotDone() {
		return ServicePrincipal{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (splr ServicePrincipalListResult) IsEmpty() bool {
	return splr.Value == nil || len(*splr.Value) == 0
}

// ServicePrincipalListResultPage contains a page of ServicePrincipal values.
type ServicePrincipalListResultPage struct {
	fn   func(ServicePrincipalListResult) (ServicePrincipalListResult, error)
	splr ServicePrincipalListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServicePrincipalListResultPage) Next() error {
	next, err := page.fn(page.splr)
	if err != nil {
		return err
	}
	page.splr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServicePrincipalListResultPage) NotDone() bool {
	return !page.splr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServicePrincipalListResultPage) Response() ServicePrincipalListResult {
	return page.splr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServicePrincipalListResultPage) Values() []ServicePrincipal {
	if page.splr.IsEmpty() {
		return nil
	}
	return *page.splr.Value
}

// SignInName contains information about a sign-in name of a local account user in an Azure Active Directory B2C
// tenant.
type SignInName struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// Type - A string value that can be used to classify user sign-in types in your directory, such as 'emailAddress' or 'userName'.
	Type *string `json:"type,omitempty"`
	// Value - The sign-in used by the local account. Must be unique across the company/tenant. For example, 'johnc@example.com'.
	Value *string `json:"value,omitempty"`
}

// MarshalJSON is the custom marshaler for SignInName.
func (sin SignInName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sin.Type != nil {
		objectMap["type"] = sin.Type
	}
	if sin.Value != nil {
		objectMap["value"] = sin.Value
	}
	for k, v := range sin.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// User active Directory user information.
type User struct {
	autorest.Response `json:"-"`
	// ImmutableID - This must be specified if you are using a federated domain for the user's userPrincipalName (UPN) property when creating a new user account. It is used to associate an on-premises Active Directory user account with their Azure AD user object.
	ImmutableID *string `json:"immutableId,omitempty"`
	// UsageLocation - A two letter country code (ISO standard 3166). Required for users that will be assigned licenses due to legal requirement to check for availability of services in countries. Examples include: "US", "JP", and "GB".
	UsageLocation *string `json:"usageLocation,omitempty"`
	// GivenName - The given name for the user.
	GivenName *string `json:"givenName,omitempty"`
	// Surname - The user's surname (family name or last name).
	Surname *string `json:"surname,omitempty"`
	// UserType - A string value that can be used to classify user types in your directory, such as 'Member' and 'Guest'. Possible values include: 'Member', 'Guest'
	UserType UserType `json:"userType,omitempty"`
	// AccountEnabled - Whether the account is enabled.
	AccountEnabled *bool `json:"accountEnabled,omitempty"`
	// DisplayName - The display name of the user.
	DisplayName *string `json:"displayName,omitempty"`
	// UserPrincipalName - The principal name of the user.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// MailNickname - The mail alias for the user.
	MailNickname *string `json:"mailNickname,omitempty"`
	// Mail - The primary email address of the user.
	Mail *string `json:"mail,omitempty"`
	// SignInNames - The sign-in names of the user.
	SignInNames *[]SignInName `json:"signInNames,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ObjectID - The object ID.
	ObjectID *string `json:"objectId,omitempty"`
	// DeletionTimestamp - The time at which the directory object was deleted.
	DeletionTimestamp *date.Time `json:"deletionTimestamp,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeDirectoryObject', 'ObjectTypeApplication', 'ObjectTypeGroup', 'ObjectTypeServicePrincipal', 'ObjectTypeUser'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for User.
func (u User) MarshalJSON() ([]byte, error) {
	u.ObjectType = ObjectTypeUser
	objectMap := make(map[string]interface{})
	if u.ImmutableID != nil {
		objectMap["immutableId"] = u.ImmutableID
	}
	if u.UsageLocation != nil {
		objectMap["usageLocation"] = u.UsageLocation
	}
	if u.GivenName != nil {
		objectMap["givenName"] = u.GivenName
	}
	if u.Surname != nil {
		objectMap["surname"] = u.Surname
	}
	objectMap["userType"] = u.UserType
	if u.AccountEnabled != nil {
		objectMap["accountEnabled"] = u.AccountEnabled
	}
	if u.DisplayName != nil {
		objectMap["displayName"] = u.DisplayName
	}
	if u.UserPrincipalName != nil {
		objectMap["userPrincipalName"] = u.UserPrincipalName
	}
	if u.MailNickname != nil {
		objectMap["mailNickname"] = u.MailNickname
	}
	if u.Mail != nil {
		objectMap["mail"] = u.Mail
	}
	if u.SignInNames != nil {
		objectMap["signInNames"] = u.SignInNames
	}
	if u.ObjectID != nil {
		objectMap["objectId"] = u.ObjectID
	}
	if u.DeletionTimestamp != nil {
		objectMap["deletionTimestamp"] = u.DeletionTimestamp
	}
	objectMap["objectType"] = u.ObjectType
	for k, v := range u.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// AsApplication is the BasicDirectoryObject implementation for User.
func (u User) AsApplication() (*Application, bool) {
	return nil, false
}

// AsADGroup is the BasicDirectoryObject implementation for User.
func (u User) AsADGroup() (*ADGroup, bool) {
	return nil, false
}

// AsServicePrincipal is the BasicDirectoryObject implementation for User.
func (u User) AsServicePrincipal() (*ServicePrincipal, bool) {
	return nil, false
}

// AsUser is the BasicDirectoryObject implementation for User.
func (u User) AsUser() (*User, bool) {
	return &u, true
}

// AsDirectoryObject is the BasicDirectoryObject implementation for User.
func (u User) AsDirectoryObject() (*DirectoryObject, bool) {
	return nil, false
}

// AsBasicDirectoryObject is the BasicDirectoryObject implementation for User.
func (u User) AsBasicDirectoryObject() (BasicDirectoryObject, bool) {
	return &u, true
}

// UserBase ...
type UserBase struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ImmutableID - This must be specified if you are using a federated domain for the user's userPrincipalName (UPN) property when creating a new user account. It is used to associate an on-premises Active Directory user account with their Azure AD user object.
	ImmutableID *string `json:"immutableId,omitempty"`
	// UsageLocation - A two letter country code (ISO standard 3166). Required for users that will be assigned licenses due to legal requirement to check for availability of services in countries. Examples include: "US", "JP", and "GB".
	UsageLocation *string `json:"usageLocation,omitempty"`
	// GivenName - The given name for the user.
	GivenName *string `json:"givenName,omitempty"`
	// Surname - The user's surname (family name or last name).
	Surname *string `json:"surname,omitempty"`
	// UserType - A string value that can be used to classify user types in your directory, such as 'Member' and 'Guest'. Possible values include: 'Member', 'Guest'
	UserType UserType `json:"userType,omitempty"`
}

// MarshalJSON is the custom marshaler for UserBase.
func (ub UserBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ub.ImmutableID != nil {
		objectMap["immutableId"] = ub.ImmutableID
	}
	if ub.UsageLocation != nil {
		objectMap["usageLocation"] = ub.UsageLocation
	}
	if ub.GivenName != nil {
		objectMap["givenName"] = ub.GivenName
	}
	if ub.Surname != nil {
		objectMap["surname"] = ub.Surname
	}
	objectMap["userType"] = ub.UserType
	for k, v := range ub.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UserCreateParameters request parameters for creating a new work or school account user.
type UserCreateParameters struct {
	// AccountEnabled - Whether the account is enabled.
	AccountEnabled *bool `json:"accountEnabled,omitempty"`
	// DisplayName - The display name of the user.
	DisplayName *string `json:"displayName,omitempty"`
	// PasswordProfile - Password Profile
	PasswordProfile *PasswordProfile `json:"passwordProfile,omitempty"`
	// UserPrincipalName - The user principal name (someuser@contoso.com). It must contain one of the verified domains for the tenant.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// MailNickname - The mail alias for the user.
	MailNickname *string `json:"mailNickname,omitempty"`
	// Mail - The primary email address of the user.
	Mail *string `json:"mail,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ImmutableID - This must be specified if you are using a federated domain for the user's userPrincipalName (UPN) property when creating a new user account. It is used to associate an on-premises Active Directory user account with their Azure AD user object.
	ImmutableID *string `json:"immutableId,omitempty"`
	// UsageLocation - A two letter country code (ISO standard 3166). Required for users that will be assigned licenses due to legal requirement to check for availability of services in countries. Examples include: "US", "JP", and "GB".
	UsageLocation *string `json:"usageLocation,omitempty"`
	// GivenName - The given name for the user.
	GivenName *string `json:"givenName,omitempty"`
	// Surname - The user's surname (family name or last name).
	Surname *string `json:"surname,omitempty"`
	// UserType - A string value that can be used to classify user types in your directory, such as 'Member' and 'Guest'. Possible values include: 'Member', 'Guest'
	UserType UserType `json:"userType,omitempty"`
}

// MarshalJSON is the custom marshaler for UserCreateParameters.
func (ucp UserCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ucp.AccountEnabled != nil {
		objectMap["accountEnabled"] = ucp.AccountEnabled
	}
	if ucp.DisplayName != nil {
		objectMap["displayName"] = ucp.DisplayName
	}
	if ucp.PasswordProfile != nil {
		objectMap["passwordProfile"] = ucp.PasswordProfile
	}
	if ucp.UserPrincipalName != nil {
		objectMap["userPrincipalName"] = ucp.UserPrincipalName
	}
	if ucp.MailNickname != nil {
		objectMap["mailNickname"] = ucp.MailNickname
	}
	if ucp.Mail != nil {
		objectMap["mail"] = ucp.Mail
	}
	if ucp.ImmutableID != nil {
		objectMap["immutableId"] = ucp.ImmutableID
	}
	if ucp.UsageLocation != nil {
		objectMap["usageLocation"] = ucp.UsageLocation
	}
	if ucp.GivenName != nil {
		objectMap["givenName"] = ucp.GivenName
	}
	if ucp.Surname != nil {
		objectMap["surname"] = ucp.Surname
	}
	objectMap["userType"] = ucp.UserType
	for k, v := range ucp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UserGetMemberGroupsParameters request parameters for GetMemberGroups API call.
type UserGetMemberGroupsParameters struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// SecurityEnabledOnly - If true, only membership in security-enabled groups should be checked. Otherwise, membership in all groups should be checked.
	SecurityEnabledOnly *bool `json:"securityEnabledOnly,omitempty"`
}

// MarshalJSON is the custom marshaler for UserGetMemberGroupsParameters.
func (ugmgp UserGetMemberGroupsParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ugmgp.SecurityEnabledOnly != nil {
		objectMap["securityEnabledOnly"] = ugmgp.SecurityEnabledOnly
	}
	for k, v := range ugmgp.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// UserGetMemberGroupsResult server response for GetMemberGroups API call.
type UserGetMemberGroupsResult struct {
	autorest.Response `json:"-"`
	// Value - A collection of group IDs of which the user is a member.
	Value *[]string `json:"value,omitempty"`
}

// UserListResult server response for Get tenant users API call.
type UserListResult struct {
	autorest.Response `json:"-"`
	// Value - the list of users.
	Value *[]User `json:"value,omitempty"`
	// OdataNextLink - The URL to get the next set of results.
	OdataNextLink *string `json:"odata.nextLink,omitempty"`
}

// UserListResultIterator provides access to a complete listing of User values.
type UserListResultIterator struct {
	i    int
	page UserListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *UserListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter UserListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter UserListResultIterator) Response() UserListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter UserListResultIterator) Value() User {
	if !iter.page.NotDone() {
		return User{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (ulr UserListResult) IsEmpty() bool {
	return ulr.Value == nil || len(*ulr.Value) == 0
}

// UserListResultPage contains a page of User values.
type UserListResultPage struct {
	fn  func(UserListResult) (UserListResult, error)
	ulr UserListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *UserListResultPage) Next() error {
	next, err := page.fn(page.ulr)
	if err != nil {
		return err
	}
	page.ulr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page UserListResultPage) NotDone() bool {
	return !page.ulr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page UserListResultPage) Response() UserListResult {
	return page.ulr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page UserListResultPage) Values() []User {
	if page.ulr.IsEmpty() {
		return nil
	}
	return *page.ulr.Value
}

// UserUpdateParameters request parameters for updating an existing work or school account user.
type UserUpdateParameters struct {
	// AccountEnabled - Whether the account is enabled.
	AccountEnabled *bool `json:"accountEnabled,omitempty"`
	// DisplayName - The display name of the user.
	DisplayName *string `json:"displayName,omitempty"`
	// PasswordProfile - The password profile of the user.
	PasswordProfile *PasswordProfile `json:"passwordProfile,omitempty"`
	// UserPrincipalName - The user principal name (someuser@contoso.com). It must contain one of the verified domains for the tenant.
	UserPrincipalName *string `json:"userPrincipalName,omitempty"`
	// MailNickname - The mail alias for the user.
	MailNickname *string `json:"mailNickname,omitempty"`
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]interface{} `json:""`
	// ImmutableID - This must be specified if you are using a federated domain for the user's userPrincipalName (UPN) property when creating a new user account. It is used to associate an on-premises Active Directory user account with their Azure AD user object.
	ImmutableID *string `json:"immutableId,omitempty"`
	// UsageLocation - A two letter country code (ISO standard 3166). Required for users that will be assigned licenses due to legal requirement to check for availability of services in countries. Examples include: "US", "JP", and "GB".
	UsageLocation *string `json:"usageLocation,omitempty"`
	// GivenName - The given name for the user.
	GivenName *string `json:"givenName,omitempty"`
	// Surname - The user's surname (family name or last name).
	Surname *string `json:"surname,omitempty"`
	// UserType - A string value that can be used to classify user types in your directory, such as 'Member' and 'Guest'. Possible values include: 'Member', 'Guest'
	UserType UserType `json:"userType,omitempty"`
}

// MarshalJSON is the custom marshaler for UserUpdateParameters.
func (uup UserUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if uup.AccountEnabled != nil {
		objectMap["accountEnabled"] = uup.AccountEnabled
	}
	if uup.DisplayName != nil {
		objectMap["displayName"] = uup.DisplayName
	}
	if uup.PasswordProfile != nil {
		objectMap["passwordProfile"] = uup.PasswordProfile
	}
	if uup.UserPrincipalName != nil {
		objectMap["userPrincipalName"] = uup.UserPrincipalName
	}
	if uup.MailNickname != nil {
		objectMap["mailNickname"] = uup.MailNickname
	}
	if uup.ImmutableID != nil {
		objectMap["immutableId"] = uup.ImmutableID
	}
	if uup.UsageLocation != nil {
		objectMap["usageLocation"] = uup.UsageLocation
	}
	if uup.GivenName != nil {
		objectMap["givenName"] = uup.GivenName
	}
	if uup.Surname != nil {
		objectMap["surname"] = uup.Surname
	}
	objectMap["userType"] = uup.UserType
	for k, v := range uup.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}
