package fabric

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// ComputeFabricOperationsClient is the fabric Admin Client
type ComputeFabricOperationsClient struct {
	BaseClient
}

// NewComputeFabricOperationsClient creates an instance of the ComputeFabricOperationsClient client.
func NewComputeFabricOperationsClient(subscriptionID string) ComputeFabricOperationsClient {
	return NewComputeFabricOperationsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewComputeFabricOperationsClientWithBaseURI creates an instance of the ComputeFabricOperationsClient client.
func NewComputeFabricOperationsClientWithBaseURI(baseURI string, subscriptionID string) ComputeFabricOperationsClient {
	return ComputeFabricOperationsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get get the status of a compute fabric operation.
//
// location is location of the resource. provider is name of the provider. computeOperationResult is id of a
// compute fabric operation.
func (client ComputeFabricOperationsClient) Get(ctx context.Context, location string, provider string, computeOperationResult string) (result OperationStatus, err error) {
	req, err := client.GetPreparer(ctx, location, provider, computeOperationResult)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ComputeFabricOperationsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "fabric.ComputeFabricOperationsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ComputeFabricOperationsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ComputeFabricOperationsClient) GetPreparer(ctx context.Context, location string, provider string, computeOperationResult string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"computeOperationResult": autorest.Encode("path", computeOperationResult),
		"location":               autorest.Encode("path", location),
		"provider":               autorest.Encode("path", provider),
		"subscriptionId":         autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/System.{location}/providers/{provider}/fabricLocations/{location}/computeOperationResults/{computeOperationResult}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ComputeFabricOperationsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ComputeFabricOperationsClient) GetResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
