// +build go1.9

// Copyright 2018 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package servicefabric

import original "github.com/Azure/azure-sdk-for-go/services/servicefabric/6.1/servicefabric"

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient

func New() BaseClient {
	return original.New()
}
func NewWithBaseURI(baseURI string) BaseClient {
	return original.NewWithBaseURI(baseURI)
}

type ApplicationDefinitionKind = original.ApplicationDefinitionKind

const (
	Compose                             ApplicationDefinitionKind = original.Compose
	Invalid                             ApplicationDefinitionKind = original.Invalid
	ServiceFabricApplicationDescription ApplicationDefinitionKind = original.ServiceFabricApplicationDescription
)

type ApplicationStatus = original.ApplicationStatus

const (
	ApplicationStatusCreating  ApplicationStatus = original.ApplicationStatusCreating
	ApplicationStatusDeleting  ApplicationStatus = original.ApplicationStatusDeleting
	ApplicationStatusFailed    ApplicationStatus = original.ApplicationStatusFailed
	ApplicationStatusInvalid   ApplicationStatus = original.ApplicationStatusInvalid
	ApplicationStatusReady     ApplicationStatus = original.ApplicationStatusReady
	ApplicationStatusUpgrading ApplicationStatus = original.ApplicationStatusUpgrading
)

type ApplicationTypeDefinitionKind = original.ApplicationTypeDefinitionKind

const (
	ApplicationTypeDefinitionKindCompose                         ApplicationTypeDefinitionKind = original.ApplicationTypeDefinitionKindCompose
	ApplicationTypeDefinitionKindInvalid                         ApplicationTypeDefinitionKind = original.ApplicationTypeDefinitionKindInvalid
	ApplicationTypeDefinitionKindServiceFabricApplicationPackage ApplicationTypeDefinitionKind = original.ApplicationTypeDefinitionKindServiceFabricApplicationPackage
)

type ApplicationTypeStatus = original.ApplicationTypeStatus

const (
	ApplicationTypeStatusAvailable      ApplicationTypeStatus = original.ApplicationTypeStatusAvailable
	ApplicationTypeStatusFailed         ApplicationTypeStatus = original.ApplicationTypeStatusFailed
	ApplicationTypeStatusInvalid        ApplicationTypeStatus = original.ApplicationTypeStatusInvalid
	ApplicationTypeStatusProvisioning   ApplicationTypeStatus = original.ApplicationTypeStatusProvisioning
	ApplicationTypeStatusUnprovisioning ApplicationTypeStatus = original.ApplicationTypeStatusUnprovisioning
)

type ChaosEventKind = original.ChaosEventKind

const (
	ChaosEventKindExecutingFaults  ChaosEventKind = original.ChaosEventKindExecutingFaults
	ChaosEventKindInvalid          ChaosEventKind = original.ChaosEventKindInvalid
	ChaosEventKindStarted          ChaosEventKind = original.ChaosEventKindStarted
	ChaosEventKindStopped          ChaosEventKind = original.ChaosEventKindStopped
	ChaosEventKindTestError        ChaosEventKind = original.ChaosEventKindTestError
	ChaosEventKindValidationFailed ChaosEventKind = original.ChaosEventKindValidationFailed
	ChaosEventKindWaiting          ChaosEventKind = original.ChaosEventKindWaiting
)

type Code = original.Code

const (
	EABORT                                    Code = original.EABORT
	FABRICEAPPLICATIONALREADYEXISTS           Code = original.FABRICEAPPLICATIONALREADYEXISTS
	FABRICEAPPLICATIONALREADYINTARGETVERSION  Code = original.FABRICEAPPLICATIONALREADYINTARGETVERSION
	FABRICEAPPLICATIONNOTFOUND                Code = original.FABRICEAPPLICATIONNOTFOUND
	FABRICEAPPLICATIONNOTUPGRADING            Code = original.FABRICEAPPLICATIONNOTUPGRADING
	FABRICEAPPLICATIONTYPEALREADYEXISTS       Code = original.FABRICEAPPLICATIONTYPEALREADYEXISTS
	FABRICEAPPLICATIONTYPEINUSE               Code = original.FABRICEAPPLICATIONTYPEINUSE
	FABRICEAPPLICATIONTYPENOTFOUND            Code = original.FABRICEAPPLICATIONTYPENOTFOUND
	FABRICEAPPLICATIONTYPEPROVISIONINPROGRESS Code = original.FABRICEAPPLICATIONTYPEPROVISIONINPROGRESS
	FABRICEAPPLICATIONUPGRADEINPROGRESS       Code = original.FABRICEAPPLICATIONUPGRADEINPROGRESS
	FABRICEAPPLICATIONUPGRADEVALIDATIONERROR  Code = original.FABRICEAPPLICATIONUPGRADEVALIDATIONERROR
	FABRICECOMMUNICATIONERROR                 Code = original.FABRICECOMMUNICATIONERROR
	FABRICECONFIGURATIONPARAMETERNOTFOUND     Code = original.FABRICECONFIGURATIONPARAMETERNOTFOUND
	FABRICECONFIGURATIONSECTIONNOTFOUND       Code = original.FABRICECONFIGURATIONSECTIONNOTFOUND
	FABRICEDIRECTORYNOTFOUND                  Code = original.FABRICEDIRECTORYNOTFOUND
	FABRICEENUMERATIONCOMPLETED               Code = original.FABRICEENUMERATIONCOMPLETED
	FABRICEFABRICALREADYINTARGETVERSION       Code = original.FABRICEFABRICALREADYINTARGETVERSION
	FABRICEFABRICNOTUPGRADING                 Code = original.FABRICEFABRICNOTUPGRADING
	FABRICEFABRICUPGRADEINPROGRESS            Code = original.FABRICEFABRICUPGRADEINPROGRESS
	FABRICEFABRICUPGRADEVALIDATIONERROR       Code = original.FABRICEFABRICUPGRADEVALIDATIONERROR
	FABRICEFABRICVERSIONALREADYEXISTS         Code = original.FABRICEFABRICVERSIONALREADYEXISTS
	FABRICEFABRICVERSIONINUSE                 Code = original.FABRICEFABRICVERSIONINUSE
	FABRICEFABRICVERSIONNOTFOUND              Code = original.FABRICEFABRICVERSIONNOTFOUND
	FABRICEFILENOTFOUND                       Code = original.FABRICEFILENOTFOUND
	FABRICEHEALTHENTITYNOTFOUND               Code = original.FABRICEHEALTHENTITYNOTFOUND
	FABRICEHEALTHSTALEREPORT                  Code = original.FABRICEHEALTHSTALEREPORT
	FABRICEIMAGEBUILDERVALIDATIONERROR        Code = original.FABRICEIMAGEBUILDERVALIDATIONERROR
	FABRICEINSTANCEIDMISMATCH                 Code = original.FABRICEINSTANCEIDMISMATCH
	FABRICEINVALIDADDRESS                     Code = original.FABRICEINVALIDADDRESS
	FABRICEINVALIDATOMICGROUP                 Code = original.FABRICEINVALIDATOMICGROUP
	FABRICEINVALIDCONFIGURATION               Code = original.FABRICEINVALIDCONFIGURATION
	FABRICEINVALIDNAMEURI                     Code = original.FABRICEINVALIDNAMEURI
	FABRICEINVALIDPARTITIONKEY                Code = original.FABRICEINVALIDPARTITIONKEY
	FABRICEKEYNOTFOUND                        Code = original.FABRICEKEYNOTFOUND
	FABRICEKEYTOOLARGE                        Code = original.FABRICEKEYTOOLARGE
	FABRICENAMEALREADYEXISTS                  Code = original.FABRICENAMEALREADYEXISTS
	FABRICENAMEDOESNOTEXIST                   Code = original.FABRICENAMEDOESNOTEXIST
	FABRICENAMENOTEMPTY                       Code = original.FABRICENAMENOTEMPTY
	FABRICENODEHASNOTSTOPPEDYET               Code = original.FABRICENODEHASNOTSTOPPEDYET
	FABRICENODEISUP                           Code = original.FABRICENODEISUP
	FABRICENODENOTFOUND                       Code = original.FABRICENODENOTFOUND
	FABRICENOTPRIMARY                         Code = original.FABRICENOTPRIMARY
	FABRICENOTREADY                           Code = original.FABRICENOTREADY
	FABRICENOWRITEQUORUM                      Code = original.FABRICENOWRITEQUORUM
	FABRICEOPERATIONNOTCOMPLETE               Code = original.FABRICEOPERATIONNOTCOMPLETE
	FABRICEPARTITIONNOTFOUND                  Code = original.FABRICEPARTITIONNOTFOUND
	FABRICEPATHTOOLONG                        Code = original.FABRICEPATHTOOLONG
	FABRICEPROPERTYCHECKFAILED                Code = original.FABRICEPROPERTYCHECKFAILED
	FABRICEPROPERTYDOESNOTEXIST               Code = original.FABRICEPROPERTYDOESNOTEXIST
	FABRICERECONFIGURATIONPENDING             Code = original.FABRICERECONFIGURATIONPENDING
	FABRICEREPLICADOESNOTEXIST                Code = original.FABRICEREPLICADOESNOTEXIST
	FABRICESEQUENCENUMBERCHECKFAILED          Code = original.FABRICESEQUENCENUMBERCHECKFAILED
	FABRICESERVICEAFFINITYCHAINNOTSUPPORTED   Code = original.FABRICESERVICEAFFINITYCHAINNOTSUPPORTED
	FABRICESERVICEALREADYEXISTS               Code = original.FABRICESERVICEALREADYEXISTS
	FABRICESERVICEDOESNOTEXIST                Code = original.FABRICESERVICEDOESNOTEXIST
	FABRICESERVICEGROUPALREADYEXISTS          Code = original.FABRICESERVICEGROUPALREADYEXISTS
	FABRICESERVICEGROUPDOESNOTEXIST           Code = original.FABRICESERVICEGROUPDOESNOTEXIST
	FABRICESERVICEMANIFESTNOTFOUND            Code = original.FABRICESERVICEMANIFESTNOTFOUND
	FABRICESERVICEMETADATAMISMATCH            Code = original.FABRICESERVICEMETADATAMISMATCH
	FABRICESERVICEOFFLINE                     Code = original.FABRICESERVICEOFFLINE
	FABRICESERVICETYPEMISMATCH                Code = original.FABRICESERVICETYPEMISMATCH
	FABRICESERVICETYPENOTFOUND                Code = original.FABRICESERVICETYPENOTFOUND
	FABRICESERVICETYPETEMPLATENOTFOUND        Code = original.FABRICESERVICETYPETEMPLATENOTFOUND
	FABRICETIMEOUT                            Code = original.FABRICETIMEOUT
	FABRICEVALUEEMPTY                         Code = original.FABRICEVALUEEMPTY
	FABRICEVALUETOOLARGE                      Code = original.FABRICEVALUETOOLARGE
)

type ComposeDeploymentStatus = original.ComposeDeploymentStatus

const (
	ComposeDeploymentStatusCreating       ComposeDeploymentStatus = original.ComposeDeploymentStatusCreating
	ComposeDeploymentStatusDeleting       ComposeDeploymentStatus = original.ComposeDeploymentStatusDeleting
	ComposeDeploymentStatusFailed         ComposeDeploymentStatus = original.ComposeDeploymentStatusFailed
	ComposeDeploymentStatusInvalid        ComposeDeploymentStatus = original.ComposeDeploymentStatusInvalid
	ComposeDeploymentStatusProvisioning   ComposeDeploymentStatus = original.ComposeDeploymentStatusProvisioning
	ComposeDeploymentStatusReady          ComposeDeploymentStatus = original.ComposeDeploymentStatusReady
	ComposeDeploymentStatusUnprovisioning ComposeDeploymentStatus = original.ComposeDeploymentStatusUnprovisioning
	ComposeDeploymentStatusUpgrading      ComposeDeploymentStatus = original.ComposeDeploymentStatusUpgrading
)

type ComposeDeploymentUpgradeState = original.ComposeDeploymentUpgradeState

const (
	ComposeDeploymentUpgradeStateFailed                   ComposeDeploymentUpgradeState = original.ComposeDeploymentUpgradeStateFailed
	ComposeDeploymentUpgradeStateInvalid                  ComposeDeploymentUpgradeState = original.ComposeDeploymentUpgradeStateInvalid
	ComposeDeploymentUpgradeStateProvisioningTarget       ComposeDeploymentUpgradeState = original.ComposeDeploymentUpgradeStateProvisioningTarget
	ComposeDeploymentUpgradeStateRollingBackCompleted     ComposeDeploymentUpgradeState = original.ComposeDeploymentUpgradeStateRollingBackCompleted
	ComposeDeploymentUpgradeStateRollingBackInProgress    ComposeDeploymentUpgradeState = original.ComposeDeploymentUpgradeStateRollingBackInProgress
	ComposeDeploymentUpgradeStateRollingForwardCompleted  ComposeDeploymentUpgradeState = original.ComposeDeploymentUpgradeStateRollingForwardCompleted
	ComposeDeploymentUpgradeStateRollingForwardInProgress ComposeDeploymentUpgradeState = original.ComposeDeploymentUpgradeStateRollingForwardInProgress
	ComposeDeploymentUpgradeStateRollingForwardPending    ComposeDeploymentUpgradeState = original.ComposeDeploymentUpgradeStateRollingForwardPending
	ComposeDeploymentUpgradeStateUnprovisioningCurrent    ComposeDeploymentUpgradeState = original.ComposeDeploymentUpgradeStateUnprovisioningCurrent
	ComposeDeploymentUpgradeStateUnprovisioningTarget     ComposeDeploymentUpgradeState = original.ComposeDeploymentUpgradeStateUnprovisioningTarget
)

type CreateFabricDump = original.CreateFabricDump

const (
	False CreateFabricDump = original.False
	True  CreateFabricDump = original.True
)

type DataLossModeRequiredQueryParam = original.DataLossModeRequiredQueryParam

const (
	DataLossModeRequiredQueryParamFullDataLoss    DataLossModeRequiredQueryParam = original.DataLossModeRequiredQueryParamFullDataLoss
	DataLossModeRequiredQueryParamInvalid         DataLossModeRequiredQueryParam = original.DataLossModeRequiredQueryParamInvalid
	DataLossModeRequiredQueryParamPartialDataLoss DataLossModeRequiredQueryParam = original.DataLossModeRequiredQueryParamPartialDataLoss
)

type DeactivationIntent = original.DeactivationIntent

const (
	Pause      DeactivationIntent = original.Pause
	RemoveData DeactivationIntent = original.RemoveData
	Restart    DeactivationIntent = original.Restart
)

type DeployedApplicationStatus = original.DeployedApplicationStatus

const (
	DeployedApplicationStatusActivating   DeployedApplicationStatus = original.DeployedApplicationStatusActivating
	DeployedApplicationStatusActive       DeployedApplicationStatus = original.DeployedApplicationStatusActive
	DeployedApplicationStatusDeactivating DeployedApplicationStatus = original.DeployedApplicationStatusDeactivating
	DeployedApplicationStatusDownloading  DeployedApplicationStatus = original.DeployedApplicationStatusDownloading
	DeployedApplicationStatusInvalid      DeployedApplicationStatus = original.DeployedApplicationStatusInvalid
	DeployedApplicationStatusUpgrading    DeployedApplicationStatus = original.DeployedApplicationStatusUpgrading
)

type DeploymentStatus = original.DeploymentStatus

const (
	DeploymentStatusActivating   DeploymentStatus = original.DeploymentStatusActivating
	DeploymentStatusActive       DeploymentStatus = original.DeploymentStatusActive
	DeploymentStatusDeactivating DeploymentStatus = original.DeploymentStatusDeactivating
	DeploymentStatusDownloading  DeploymentStatus = original.DeploymentStatusDownloading
	DeploymentStatusInvalid      DeploymentStatus = original.DeploymentStatusInvalid
	DeploymentStatusUpgrading    DeploymentStatus = original.DeploymentStatusUpgrading
)

type EntityKind = original.EntityKind

const (
	EntityKindApplication            EntityKind = original.EntityKindApplication
	EntityKindCluster                EntityKind = original.EntityKindCluster
	EntityKindDeployedApplication    EntityKind = original.EntityKindDeployedApplication
	EntityKindDeployedServicePackage EntityKind = original.EntityKindDeployedServicePackage
	EntityKindInvalid                EntityKind = original.EntityKindInvalid
	EntityKindNode                   EntityKind = original.EntityKindNode
	EntityKindPartition              EntityKind = original.EntityKindPartition
	EntityKindReplica                EntityKind = original.EntityKindReplica
	EntityKindService                EntityKind = original.EntityKindService
)

type EntryPointStatus = original.EntryPointStatus

const (
	EntryPointStatusInvalid  EntryPointStatus = original.EntryPointStatusInvalid
	EntryPointStatusPending  EntryPointStatus = original.EntryPointStatusPending
	EntryPointStatusStarted  EntryPointStatus = original.EntryPointStatusStarted
	EntryPointStatusStarting EntryPointStatus = original.EntryPointStatusStarting
	EntryPointStatusStopped  EntryPointStatus = original.EntryPointStatusStopped
	EntryPointStatusStopping EntryPointStatus = original.EntryPointStatusStopping
)

type FabricReplicaStatus = original.FabricReplicaStatus

const (
	FabricReplicaStatusDown    FabricReplicaStatus = original.FabricReplicaStatusDown
	FabricReplicaStatusInvalid FabricReplicaStatus = original.FabricReplicaStatusInvalid
	FabricReplicaStatusUp      FabricReplicaStatus = original.FabricReplicaStatusUp
)

type FailureAction = original.FailureAction

const (
	FailureActionInvalid  FailureAction = original.FailureActionInvalid
	FailureActionManual   FailureAction = original.FailureActionManual
	FailureActionRollback FailureAction = original.FailureActionRollback
)

type FailureReason = original.FailureReason

const (
	HealthCheck           FailureReason = original.HealthCheck
	Interrupted           FailureReason = original.Interrupted
	None                  FailureReason = original.None
	OverallUpgradeTimeout FailureReason = original.OverallUpgradeTimeout
	UpgradeDomainTimeout  FailureReason = original.UpgradeDomainTimeout
)

type HealthEvaluationKind = original.HealthEvaluationKind

const (
	HealthEvaluationKindApplication                       HealthEvaluationKind = original.HealthEvaluationKindApplication
	HealthEvaluationKindApplications                      HealthEvaluationKind = original.HealthEvaluationKindApplications
	HealthEvaluationKindApplicationTypeApplications       HealthEvaluationKind = original.HealthEvaluationKindApplicationTypeApplications
	HealthEvaluationKindDeltaNodesCheck                   HealthEvaluationKind = original.HealthEvaluationKindDeltaNodesCheck
	HealthEvaluationKindDeployedApplication               HealthEvaluationKind = original.HealthEvaluationKindDeployedApplication
	HealthEvaluationKindDeployedApplications              HealthEvaluationKind = original.HealthEvaluationKindDeployedApplications
	HealthEvaluationKindDeployedServicePackage            HealthEvaluationKind = original.HealthEvaluationKindDeployedServicePackage
	HealthEvaluationKindDeployedServicePackages           HealthEvaluationKind = original.HealthEvaluationKindDeployedServicePackages
	HealthEvaluationKindEvent                             HealthEvaluationKind = original.HealthEvaluationKindEvent
	HealthEvaluationKindInvalid                           HealthEvaluationKind = original.HealthEvaluationKindInvalid
	HealthEvaluationKindNode                              HealthEvaluationKind = original.HealthEvaluationKindNode
	HealthEvaluationKindNodes                             HealthEvaluationKind = original.HealthEvaluationKindNodes
	HealthEvaluationKindPartition                         HealthEvaluationKind = original.HealthEvaluationKindPartition
	HealthEvaluationKindPartitions                        HealthEvaluationKind = original.HealthEvaluationKindPartitions
	HealthEvaluationKindReplica                           HealthEvaluationKind = original.HealthEvaluationKindReplica
	HealthEvaluationKindReplicas                          HealthEvaluationKind = original.HealthEvaluationKindReplicas
	HealthEvaluationKindService                           HealthEvaluationKind = original.HealthEvaluationKindService
	HealthEvaluationKindServices                          HealthEvaluationKind = original.HealthEvaluationKindServices
	HealthEvaluationKindSystemApplication                 HealthEvaluationKind = original.HealthEvaluationKindSystemApplication
	HealthEvaluationKindUpgradeDomainDeltaNodesCheck      HealthEvaluationKind = original.HealthEvaluationKindUpgradeDomainDeltaNodesCheck
	HealthEvaluationKindUpgradeDomainDeployedApplications HealthEvaluationKind = original.HealthEvaluationKindUpgradeDomainDeployedApplications
	HealthEvaluationKindUpgradeDomainNodes                HealthEvaluationKind = original.HealthEvaluationKindUpgradeDomainNodes
)

type HealthState = original.HealthState

const (
	HealthStateError   HealthState = original.HealthStateError
	HealthStateInvalid HealthState = original.HealthStateInvalid
	HealthStateOk      HealthState = original.HealthStateOk
	HealthStateUnknown HealthState = original.HealthStateUnknown
	HealthStateWarning HealthState = original.HealthStateWarning
)

type HostIsolationMode = original.HostIsolationMode

const (
	HostIsolationModeHyperV  HostIsolationMode = original.HostIsolationModeHyperV
	HostIsolationModeNone    HostIsolationMode = original.HostIsolationModeNone
	HostIsolationModeProcess HostIsolationMode = original.HostIsolationModeProcess
)

type HostType = original.HostType

const (
	HostTypeContainerHost HostType = original.HostTypeContainerHost
	HostTypeExeHost       HostType = original.HostTypeExeHost
	HostTypeInvalid       HostType = original.HostTypeInvalid
)

type ImpactLevel = original.ImpactLevel

const (
	ImpactLevelInvalid    ImpactLevel = original.ImpactLevelInvalid
	ImpactLevelNone       ImpactLevel = original.ImpactLevelNone
	ImpactLevelRemoveData ImpactLevel = original.ImpactLevelRemoveData
	ImpactLevelRemoveNode ImpactLevel = original.ImpactLevelRemoveNode
	ImpactLevelRestart    ImpactLevel = original.ImpactLevelRestart
)

type Kind = original.Kind

const (
	KindApplication                  Kind = original.KindApplication
	KindApplications                 Kind = original.KindApplications
	KindApplicationTypeApplications  Kind = original.KindApplicationTypeApplications
	KindDeltaNodesCheck              Kind = original.KindDeltaNodesCheck
	KindDeployedApplication          Kind = original.KindDeployedApplication
	KindDeployedApplications         Kind = original.KindDeployedApplications
	KindDeployedServicePackage       Kind = original.KindDeployedServicePackage
	KindDeployedServicePackages      Kind = original.KindDeployedServicePackages
	KindEvent                        Kind = original.KindEvent
	KindHealthEvaluation             Kind = original.KindHealthEvaluation
	KindNode                         Kind = original.KindNode
	KindNodes                        Kind = original.KindNodes
	KindPartition                    Kind = original.KindPartition
	KindPartitions                   Kind = original.KindPartitions
	KindReplica                      Kind = original.KindReplica
	KindReplicas                     Kind = original.KindReplicas
	KindService                      Kind = original.KindService
	KindServices                     Kind = original.KindServices
	KindSystemApplication            Kind = original.KindSystemApplication
	KindUpgradeDomainDeltaNodesCheck Kind = original.KindUpgradeDomainDeltaNodesCheck
	KindUpgradeDomainNodes           Kind = original.KindUpgradeDomainNodes
)

type KindBasicChaosEvent = original.KindBasicChaosEvent

const (
	KindChaosEvent       KindBasicChaosEvent = original.KindChaosEvent
	KindExecutingFaults  KindBasicChaosEvent = original.KindExecutingFaults
	KindStarted          KindBasicChaosEvent = original.KindStarted
	KindStopped          KindBasicChaosEvent = original.KindStopped
	KindTestError        KindBasicChaosEvent = original.KindTestError
	KindValidationFailed KindBasicChaosEvent = original.KindValidationFailed
	KindWaiting          KindBasicChaosEvent = original.KindWaiting
)

type KindBasicPropertyBatchInfo = original.KindBasicPropertyBatchInfo

const (
	KindFailed            KindBasicPropertyBatchInfo = original.KindFailed
	KindPropertyBatchInfo KindBasicPropertyBatchInfo = original.KindPropertyBatchInfo
	KindSuccessful        KindBasicPropertyBatchInfo = original.KindSuccessful
)

type KindBasicPropertyBatchOperation = original.KindBasicPropertyBatchOperation

const (
	KindCheckExists            KindBasicPropertyBatchOperation = original.KindCheckExists
	KindCheckSequence          KindBasicPropertyBatchOperation = original.KindCheckSequence
	KindCheckValue             KindBasicPropertyBatchOperation = original.KindCheckValue
	KindDelete                 KindBasicPropertyBatchOperation = original.KindDelete
	KindGet                    KindBasicPropertyBatchOperation = original.KindGet
	KindPropertyBatchOperation KindBasicPropertyBatchOperation = original.KindPropertyBatchOperation
	KindPut                    KindBasicPropertyBatchOperation = original.KindPut
)

type KindBasicPropertyValue = original.KindBasicPropertyValue

const (
	KindBinary        KindBasicPropertyValue = original.KindBinary
	KindDouble        KindBasicPropertyValue = original.KindDouble
	KindGUID          KindBasicPropertyValue = original.KindGUID
	KindInt64         KindBasicPropertyValue = original.KindInt64
	KindPropertyValue KindBasicPropertyValue = original.KindPropertyValue
	KindString        KindBasicPropertyValue = original.KindString
)

type KindBasicProvisionApplicationTypeDescriptionBase = original.KindBasicProvisionApplicationTypeDescriptionBase

const (
	KindExternalStore                           KindBasicProvisionApplicationTypeDescriptionBase = original.KindExternalStore
	KindImageStorePath                          KindBasicProvisionApplicationTypeDescriptionBase = original.KindImageStorePath
	KindProvisionApplicationTypeDescriptionBase KindBasicProvisionApplicationTypeDescriptionBase = original.KindProvisionApplicationTypeDescriptionBase
)

type KindBasicRepairImpactDescriptionBase = original.KindBasicRepairImpactDescriptionBase

const (
	KindBasicRepairImpactDescriptionBaseKindNode                        KindBasicRepairImpactDescriptionBase = original.KindBasicRepairImpactDescriptionBaseKindNode
	KindBasicRepairImpactDescriptionBaseKindRepairImpactDescriptionBase KindBasicRepairImpactDescriptionBase = original.KindBasicRepairImpactDescriptionBaseKindRepairImpactDescriptionBase
)

type KindBasicRepairTargetDescriptionBase = original.KindBasicRepairTargetDescriptionBase

const (
	KindBasicRepairTargetDescriptionBaseKindNode                        KindBasicRepairTargetDescriptionBase = original.KindBasicRepairTargetDescriptionBaseKindNode
	KindBasicRepairTargetDescriptionBaseKindRepairTargetDescriptionBase KindBasicRepairTargetDescriptionBase = original.KindBasicRepairTargetDescriptionBaseKindRepairTargetDescriptionBase
)

type KindBasicReplicaStatusBase = original.KindBasicReplicaStatusBase

const (
	KindKeyValueStore     KindBasicReplicaStatusBase = original.KindKeyValueStore
	KindReplicaStatusBase KindBasicReplicaStatusBase = original.KindReplicaStatusBase
)

type KindBasicReplicatorStatus = original.KindBasicReplicatorStatus

const (
	KindActiveSecondary           KindBasicReplicatorStatus = original.KindActiveSecondary
	KindIdleSecondary             KindBasicReplicatorStatus = original.KindIdleSecondary
	KindPrimary                   KindBasicReplicatorStatus = original.KindPrimary
	KindReplicatorStatus          KindBasicReplicatorStatus = original.KindReplicatorStatus
	KindSecondaryReplicatorStatus KindBasicReplicatorStatus = original.KindSecondaryReplicatorStatus
)

type KindBasicSafetyCheck = original.KindBasicSafetyCheck

const (
	KindEnsureAvailability      KindBasicSafetyCheck = original.KindEnsureAvailability
	KindEnsurePartitionQuorum   KindBasicSafetyCheck = original.KindEnsurePartitionQuorum
	KindEnsureSeedNodeQuorum    KindBasicSafetyCheck = original.KindEnsureSeedNodeQuorum
	KindPartitionSafetyCheck    KindBasicSafetyCheck = original.KindPartitionSafetyCheck
	KindSafetyCheck             KindBasicSafetyCheck = original.KindSafetyCheck
	KindWaitForInbuildReplica   KindBasicSafetyCheck = original.KindWaitForInbuildReplica
	KindWaitForPrimaryPlacement KindBasicSafetyCheck = original.KindWaitForPrimaryPlacement
	KindWaitForPrimarySwap      KindBasicSafetyCheck = original.KindWaitForPrimarySwap
	KindWaitForReconfiguration  KindBasicSafetyCheck = original.KindWaitForReconfiguration
)

type KindBasicServiceTypeDescription = original.KindBasicServiceTypeDescription

const (
	KindServiceTypeDescription KindBasicServiceTypeDescription = original.KindServiceTypeDescription
	KindStateful               KindBasicServiceTypeDescription = original.KindStateful
	KindStateless              KindBasicServiceTypeDescription = original.KindStateless
)

type MoveCost = original.MoveCost

const (
	High   MoveCost = original.High
	Low    MoveCost = original.Low
	Medium MoveCost = original.Medium
	Zero   MoveCost = original.Zero
)

type NodeDeactivationIntent = original.NodeDeactivationIntent

const (
	NodeDeactivationIntentInvalid    NodeDeactivationIntent = original.NodeDeactivationIntentInvalid
	NodeDeactivationIntentPause      NodeDeactivationIntent = original.NodeDeactivationIntentPause
	NodeDeactivationIntentRemoveData NodeDeactivationIntent = original.NodeDeactivationIntentRemoveData
	NodeDeactivationIntentRemoveNode NodeDeactivationIntent = original.NodeDeactivationIntentRemoveNode
	NodeDeactivationIntentRestart    NodeDeactivationIntent = original.NodeDeactivationIntentRestart
)

type NodeDeactivationStatus = original.NodeDeactivationStatus

const (
	NodeDeactivationStatusCompleted             NodeDeactivationStatus = original.NodeDeactivationStatusCompleted
	NodeDeactivationStatusNone                  NodeDeactivationStatus = original.NodeDeactivationStatusNone
	NodeDeactivationStatusSafetyCheckComplete   NodeDeactivationStatus = original.NodeDeactivationStatusSafetyCheckComplete
	NodeDeactivationStatusSafetyCheckInProgress NodeDeactivationStatus = original.NodeDeactivationStatusSafetyCheckInProgress
)

type NodeDeactivationTaskType = original.NodeDeactivationTaskType

const (
	NodeDeactivationTaskTypeClient         NodeDeactivationTaskType = original.NodeDeactivationTaskTypeClient
	NodeDeactivationTaskTypeInfrastructure NodeDeactivationTaskType = original.NodeDeactivationTaskTypeInfrastructure
	NodeDeactivationTaskTypeInvalid        NodeDeactivationTaskType = original.NodeDeactivationTaskTypeInvalid
	NodeDeactivationTaskTypeRepair         NodeDeactivationTaskType = original.NodeDeactivationTaskTypeRepair
)

type NodeStatus = original.NodeStatus

const (
	NodeStatusDisabled  NodeStatus = original.NodeStatusDisabled
	NodeStatusDisabling NodeStatus = original.NodeStatusDisabling
	NodeStatusDown      NodeStatus = original.NodeStatusDown
	NodeStatusEnabling  NodeStatus = original.NodeStatusEnabling
	NodeStatusInvalid   NodeStatus = original.NodeStatusInvalid
	NodeStatusRemoved   NodeStatus = original.NodeStatusRemoved
	NodeStatusUnknown   NodeStatus = original.NodeStatusUnknown
	NodeStatusUp        NodeStatus = original.NodeStatusUp
)

type NodeStatusFilterOptionalQueryParam = original.NodeStatusFilterOptionalQueryParam

const (
	All       NodeStatusFilterOptionalQueryParam = original.All
	Default   NodeStatusFilterOptionalQueryParam = original.Default
	Disabled  NodeStatusFilterOptionalQueryParam = original.Disabled
	Disabling NodeStatusFilterOptionalQueryParam = original.Disabling
	Down      NodeStatusFilterOptionalQueryParam = original.Down
	Enabling  NodeStatusFilterOptionalQueryParam = original.Enabling
	Removed   NodeStatusFilterOptionalQueryParam = original.Removed
	Unknown   NodeStatusFilterOptionalQueryParam = original.Unknown
	Up        NodeStatusFilterOptionalQueryParam = original.Up
)

type NodeTransitionTypeRequiredQueryParam = original.NodeTransitionTypeRequiredQueryParam

const (
	NodeTransitionTypeRequiredQueryParamInvalid NodeTransitionTypeRequiredQueryParam = original.NodeTransitionTypeRequiredQueryParamInvalid
	NodeTransitionTypeRequiredQueryParamStart   NodeTransitionTypeRequiredQueryParam = original.NodeTransitionTypeRequiredQueryParamStart
	NodeTransitionTypeRequiredQueryParamStop    NodeTransitionTypeRequiredQueryParam = original.NodeTransitionTypeRequiredQueryParamStop
)

type NodeUpgradePhase = original.NodeUpgradePhase

const (
	NodeUpgradePhaseInvalid                NodeUpgradePhase = original.NodeUpgradePhaseInvalid
	NodeUpgradePhasePostUpgradeSafetyCheck NodeUpgradePhase = original.NodeUpgradePhasePostUpgradeSafetyCheck
	NodeUpgradePhasePreUpgradeSafetyCheck  NodeUpgradePhase = original.NodeUpgradePhasePreUpgradeSafetyCheck
	NodeUpgradePhaseUpgrading              NodeUpgradePhase = original.NodeUpgradePhaseUpgrading
)

type OperationState = original.OperationState

const (
	OperationStateCancelled      OperationState = original.OperationStateCancelled
	OperationStateCompleted      OperationState = original.OperationStateCompleted
	OperationStateFaulted        OperationState = original.OperationStateFaulted
	OperationStateForceCancelled OperationState = original.OperationStateForceCancelled
	OperationStateInvalid        OperationState = original.OperationStateInvalid
	OperationStateRollingBack    OperationState = original.OperationStateRollingBack
	OperationStateRunning        OperationState = original.OperationStateRunning
)

type OperationType = original.OperationType

const (
	OperationTypeInvalid             OperationType = original.OperationTypeInvalid
	OperationTypeNodeTransition      OperationType = original.OperationTypeNodeTransition
	OperationTypePartitionDataLoss   OperationType = original.OperationTypePartitionDataLoss
	OperationTypePartitionQuorumLoss OperationType = original.OperationTypePartitionQuorumLoss
	OperationTypePartitionRestart    OperationType = original.OperationTypePartitionRestart
)

type PackageSharingPolicyScope = original.PackageSharingPolicyScope

const (
	PackageSharingPolicyScopeAll    PackageSharingPolicyScope = original.PackageSharingPolicyScopeAll
	PackageSharingPolicyScopeCode   PackageSharingPolicyScope = original.PackageSharingPolicyScopeCode
	PackageSharingPolicyScopeConfig PackageSharingPolicyScope = original.PackageSharingPolicyScopeConfig
	PackageSharingPolicyScopeData   PackageSharingPolicyScope = original.PackageSharingPolicyScopeData
	PackageSharingPolicyScopeNone   PackageSharingPolicyScope = original.PackageSharingPolicyScopeNone
)

type PartitionAccessStatus = original.PartitionAccessStatus

const (
	PartitionAccessStatusGranted                PartitionAccessStatus = original.PartitionAccessStatusGranted
	PartitionAccessStatusInvalid                PartitionAccessStatus = original.PartitionAccessStatusInvalid
	PartitionAccessStatusNotPrimary             PartitionAccessStatus = original.PartitionAccessStatusNotPrimary
	PartitionAccessStatusNoWriteQuorum          PartitionAccessStatus = original.PartitionAccessStatusNoWriteQuorum
	PartitionAccessStatusReconfigurationPending PartitionAccessStatus = original.PartitionAccessStatusReconfigurationPending
)

type PartitionScheme = original.PartitionScheme

const (
	PartitionSchemeInvalid           PartitionScheme = original.PartitionSchemeInvalid
	PartitionSchemeNamed             PartitionScheme = original.PartitionSchemeNamed
	PartitionSchemeSingleton         PartitionScheme = original.PartitionSchemeSingleton
	PartitionSchemeUniformInt64Range PartitionScheme = original.PartitionSchemeUniformInt64Range
)

type PartitionSchemeBasicPartitionSchemeDescription = original.PartitionSchemeBasicPartitionSchemeDescription

const (
	PartitionSchemeNamed1                     PartitionSchemeBasicPartitionSchemeDescription = original.PartitionSchemeNamed1
	PartitionSchemePartitionSchemeDescription PartitionSchemeBasicPartitionSchemeDescription = original.PartitionSchemePartitionSchemeDescription
	PartitionSchemeSingleton1                 PartitionSchemeBasicPartitionSchemeDescription = original.PartitionSchemeSingleton1
	PartitionSchemeUniformInt64Range1         PartitionSchemeBasicPartitionSchemeDescription = original.PartitionSchemeUniformInt64Range1
)

type PropertyBatchInfoKind = original.PropertyBatchInfoKind

const (
	PropertyBatchInfoKindFailed     PropertyBatchInfoKind = original.PropertyBatchInfoKindFailed
	PropertyBatchInfoKindInvalid    PropertyBatchInfoKind = original.PropertyBatchInfoKindInvalid
	PropertyBatchInfoKindSuccessful PropertyBatchInfoKind = original.PropertyBatchInfoKindSuccessful
)

type PropertyBatchOperationKind = original.PropertyBatchOperationKind

const (
	PropertyBatchOperationKindCheckExists   PropertyBatchOperationKind = original.PropertyBatchOperationKindCheckExists
	PropertyBatchOperationKindCheckSequence PropertyBatchOperationKind = original.PropertyBatchOperationKindCheckSequence
	PropertyBatchOperationKindCheckValue    PropertyBatchOperationKind = original.PropertyBatchOperationKindCheckValue
	PropertyBatchOperationKindDelete        PropertyBatchOperationKind = original.PropertyBatchOperationKindDelete
	PropertyBatchOperationKindGet           PropertyBatchOperationKind = original.PropertyBatchOperationKindGet
	PropertyBatchOperationKindInvalid       PropertyBatchOperationKind = original.PropertyBatchOperationKindInvalid
	PropertyBatchOperationKindPut           PropertyBatchOperationKind = original.PropertyBatchOperationKindPut
)

type PropertyValueKind = original.PropertyValueKind

const (
	PropertyValueKindBinary  PropertyValueKind = original.PropertyValueKindBinary
	PropertyValueKindDouble  PropertyValueKind = original.PropertyValueKindDouble
	PropertyValueKindGUID    PropertyValueKind = original.PropertyValueKindGUID
	PropertyValueKindInt64   PropertyValueKind = original.PropertyValueKindInt64
	PropertyValueKindInvalid PropertyValueKind = original.PropertyValueKindInvalid
	PropertyValueKindString  PropertyValueKind = original.PropertyValueKindString
)

type ProvisionApplicationTypeKind = original.ProvisionApplicationTypeKind

const (
	ProvisionApplicationTypeKindExternalStore  ProvisionApplicationTypeKind = original.ProvisionApplicationTypeKindExternalStore
	ProvisionApplicationTypeKindImageStorePath ProvisionApplicationTypeKind = original.ProvisionApplicationTypeKindImageStorePath
	ProvisionApplicationTypeKindInvalid        ProvisionApplicationTypeKind = original.ProvisionApplicationTypeKindInvalid
)

type QuorumLossModeRequiredQueryParam = original.QuorumLossModeRequiredQueryParam

const (
	QuorumLossModeRequiredQueryParamAllReplicas    QuorumLossModeRequiredQueryParam = original.QuorumLossModeRequiredQueryParamAllReplicas
	QuorumLossModeRequiredQueryParamInvalid        QuorumLossModeRequiredQueryParam = original.QuorumLossModeRequiredQueryParamInvalid
	QuorumLossModeRequiredQueryParamQuorumReplicas QuorumLossModeRequiredQueryParam = original.QuorumLossModeRequiredQueryParamQuorumReplicas
)

type ReconfigurationPhase = original.ReconfigurationPhase

const (
	ReconfigurationPhaseAbortPhaseZero ReconfigurationPhase = original.ReconfigurationPhaseAbortPhaseZero
	ReconfigurationPhaseNone           ReconfigurationPhase = original.ReconfigurationPhaseNone
	ReconfigurationPhasePhase0         ReconfigurationPhase = original.ReconfigurationPhasePhase0
	ReconfigurationPhasePhase1         ReconfigurationPhase = original.ReconfigurationPhasePhase1
	ReconfigurationPhasePhase2         ReconfigurationPhase = original.ReconfigurationPhasePhase2
	ReconfigurationPhasePhase3         ReconfigurationPhase = original.ReconfigurationPhasePhase3
	ReconfigurationPhasePhase4         ReconfigurationPhase = original.ReconfigurationPhasePhase4
	ReconfigurationPhaseUnknown        ReconfigurationPhase = original.ReconfigurationPhaseUnknown
)

type ReconfigurationType = original.ReconfigurationType

const (
	ReconfigurationTypeFailover    ReconfigurationType = original.ReconfigurationTypeFailover
	ReconfigurationTypeOther       ReconfigurationType = original.ReconfigurationTypeOther
	ReconfigurationTypeSwapPrimary ReconfigurationType = original.ReconfigurationTypeSwapPrimary
	ReconfigurationTypeUnknown     ReconfigurationType = original.ReconfigurationTypeUnknown
)

type RepairImpactKind = original.RepairImpactKind

const (
	RepairImpactKindInvalid RepairImpactKind = original.RepairImpactKindInvalid
	RepairImpactKindNode    RepairImpactKind = original.RepairImpactKindNode
)

type RepairTargetKind = original.RepairTargetKind

const (
	RepairTargetKindInvalid RepairTargetKind = original.RepairTargetKindInvalid
	RepairTargetKindNode    RepairTargetKind = original.RepairTargetKindNode
)

type RepairTaskHealthCheckState = original.RepairTaskHealthCheckState

const (
	InProgress RepairTaskHealthCheckState = original.InProgress
	NotStarted RepairTaskHealthCheckState = original.NotStarted
	Skipped    RepairTaskHealthCheckState = original.Skipped
	Succeeded  RepairTaskHealthCheckState = original.Succeeded
	TimedOut   RepairTaskHealthCheckState = original.TimedOut
)

type ReplicaHealthReportServiceKindRequiredQueryParam = original.ReplicaHealthReportServiceKindRequiredQueryParam

const (
	Stateful  ReplicaHealthReportServiceKindRequiredQueryParam = original.Stateful
	Stateless ReplicaHealthReportServiceKindRequiredQueryParam = original.Stateless
)

type ReplicaKind = original.ReplicaKind

const (
	ReplicaKindInvalid       ReplicaKind = original.ReplicaKindInvalid
	ReplicaKindKeyValueStore ReplicaKind = original.ReplicaKindKeyValueStore
)

type ReplicaRole = original.ReplicaRole

const (
	ReplicaRoleActiveSecondary ReplicaRole = original.ReplicaRoleActiveSecondary
	ReplicaRoleIdleSecondary   ReplicaRole = original.ReplicaRoleIdleSecondary
	ReplicaRoleNone            ReplicaRole = original.ReplicaRoleNone
	ReplicaRolePrimary         ReplicaRole = original.ReplicaRolePrimary
	ReplicaRoleUnknown         ReplicaRole = original.ReplicaRoleUnknown
)

type ReplicaStatus = original.ReplicaStatus

const (
	ReplicaStatusDown    ReplicaStatus = original.ReplicaStatusDown
	ReplicaStatusDropped ReplicaStatus = original.ReplicaStatusDropped
	ReplicaStatusInBuild ReplicaStatus = original.ReplicaStatusInBuild
	ReplicaStatusInvalid ReplicaStatus = original.ReplicaStatusInvalid
	ReplicaStatusReady   ReplicaStatus = original.ReplicaStatusReady
	ReplicaStatusStandby ReplicaStatus = original.ReplicaStatusStandby
)

type ReplicaStatus1 = original.ReplicaStatus1

const (
	ReplicaStatus1Down    ReplicaStatus1 = original.ReplicaStatus1Down
	ReplicaStatus1Dropped ReplicaStatus1 = original.ReplicaStatus1Dropped
	ReplicaStatus1InBuild ReplicaStatus1 = original.ReplicaStatus1InBuild
	ReplicaStatus1Invalid ReplicaStatus1 = original.ReplicaStatus1Invalid
	ReplicaStatus1Ready   ReplicaStatus1 = original.ReplicaStatus1Ready
	ReplicaStatus1Standby ReplicaStatus1 = original.ReplicaStatus1Standby
)

type ReplicatorOperationName = original.ReplicatorOperationName

const (
	ReplicatorOperationNameAbort          ReplicatorOperationName = original.ReplicatorOperationNameAbort
	ReplicatorOperationNameBuild          ReplicatorOperationName = original.ReplicatorOperationNameBuild
	ReplicatorOperationNameChangeRole     ReplicatorOperationName = original.ReplicatorOperationNameChangeRole
	ReplicatorOperationNameClose          ReplicatorOperationName = original.ReplicatorOperationNameClose
	ReplicatorOperationNameInvalid        ReplicatorOperationName = original.ReplicatorOperationNameInvalid
	ReplicatorOperationNameNone           ReplicatorOperationName = original.ReplicatorOperationNameNone
	ReplicatorOperationNameOnDataLoss     ReplicatorOperationName = original.ReplicatorOperationNameOnDataLoss
	ReplicatorOperationNameOpen           ReplicatorOperationName = original.ReplicatorOperationNameOpen
	ReplicatorOperationNameUpdateEpoch    ReplicatorOperationName = original.ReplicatorOperationNameUpdateEpoch
	ReplicatorOperationNameWaitForCatchup ReplicatorOperationName = original.ReplicatorOperationNameWaitForCatchup
)

type RestartPartitionModeRequiredQueryParam = original.RestartPartitionModeRequiredQueryParam

const (
	RestartPartitionModeRequiredQueryParamAllReplicasOrInstances RestartPartitionModeRequiredQueryParam = original.RestartPartitionModeRequiredQueryParamAllReplicasOrInstances
	RestartPartitionModeRequiredQueryParamInvalid                RestartPartitionModeRequiredQueryParam = original.RestartPartitionModeRequiredQueryParamInvalid
	RestartPartitionModeRequiredQueryParamOnlyActiveSecondaries  RestartPartitionModeRequiredQueryParam = original.RestartPartitionModeRequiredQueryParamOnlyActiveSecondaries
)

type ResultStatus = original.ResultStatus

const (
	ResultStatusCancelled   ResultStatus = original.ResultStatusCancelled
	ResultStatusFailed      ResultStatus = original.ResultStatusFailed
	ResultStatusInterrupted ResultStatus = original.ResultStatusInterrupted
	ResultStatusInvalid     ResultStatus = original.ResultStatusInvalid
	ResultStatusPending     ResultStatus = original.ResultStatusPending
	ResultStatusSucceeded   ResultStatus = original.ResultStatusSucceeded
)

type SafetyCheckKind = original.SafetyCheckKind

const (
	SafetyCheckKindEnsureAvailability      SafetyCheckKind = original.SafetyCheckKindEnsureAvailability
	SafetyCheckKindEnsurePartitionQuorum   SafetyCheckKind = original.SafetyCheckKindEnsurePartitionQuorum
	SafetyCheckKindEnsureSeedNodeQuorum    SafetyCheckKind = original.SafetyCheckKindEnsureSeedNodeQuorum
	SafetyCheckKindInvalid                 SafetyCheckKind = original.SafetyCheckKindInvalid
	SafetyCheckKindWaitForInbuildReplica   SafetyCheckKind = original.SafetyCheckKindWaitForInbuildReplica
	SafetyCheckKindWaitForPrimaryPlacement SafetyCheckKind = original.SafetyCheckKindWaitForPrimaryPlacement
	SafetyCheckKindWaitForPrimarySwap      SafetyCheckKind = original.SafetyCheckKindWaitForPrimarySwap
	SafetyCheckKindWaitForReconfiguration  SafetyCheckKind = original.SafetyCheckKindWaitForReconfiguration
)

type ServiceCorrelationScheme = original.ServiceCorrelationScheme

const (
	ServiceCorrelationSchemeAffinity           ServiceCorrelationScheme = original.ServiceCorrelationSchemeAffinity
	ServiceCorrelationSchemeAlignedAffinity    ServiceCorrelationScheme = original.ServiceCorrelationSchemeAlignedAffinity
	ServiceCorrelationSchemeInvalid            ServiceCorrelationScheme = original.ServiceCorrelationSchemeInvalid
	ServiceCorrelationSchemeNonAlignedAffinity ServiceCorrelationScheme = original.ServiceCorrelationSchemeNonAlignedAffinity
)

type ServiceEndpointRole = original.ServiceEndpointRole

const (
	ServiceEndpointRoleInvalid           ServiceEndpointRole = original.ServiceEndpointRoleInvalid
	ServiceEndpointRoleStatefulPrimary   ServiceEndpointRole = original.ServiceEndpointRoleStatefulPrimary
	ServiceEndpointRoleStatefulSecondary ServiceEndpointRole = original.ServiceEndpointRoleStatefulSecondary
	ServiceEndpointRoleStateless         ServiceEndpointRole = original.ServiceEndpointRoleStateless
)

type ServiceKind = original.ServiceKind

const (
	ServiceKindInvalid   ServiceKind = original.ServiceKindInvalid
	ServiceKindStateful  ServiceKind = original.ServiceKindStateful
	ServiceKindStateless ServiceKind = original.ServiceKindStateless
)

type ServiceKindBasicDeployedServiceReplicaDetailInfo = original.ServiceKindBasicDeployedServiceReplicaDetailInfo

const (
	ServiceKindDeployedServiceReplicaDetailInfo ServiceKindBasicDeployedServiceReplicaDetailInfo = original.ServiceKindDeployedServiceReplicaDetailInfo
	ServiceKindStateful1                        ServiceKindBasicDeployedServiceReplicaDetailInfo = original.ServiceKindStateful1
	ServiceKindStateless1                       ServiceKindBasicDeployedServiceReplicaDetailInfo = original.ServiceKindStateless1
)

type ServiceKindBasicDeployedServiceReplicaInfo = original.ServiceKindBasicDeployedServiceReplicaInfo

const (
	ServiceKindBasicDeployedServiceReplicaInfoServiceKindDeployedServiceReplicaInfo ServiceKindBasicDeployedServiceReplicaInfo = original.ServiceKindBasicDeployedServiceReplicaInfoServiceKindDeployedServiceReplicaInfo
	ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateful                   ServiceKindBasicDeployedServiceReplicaInfo = original.ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateful
	ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateless                  ServiceKindBasicDeployedServiceReplicaInfo = original.ServiceKindBasicDeployedServiceReplicaInfoServiceKindStateless
)

type ServiceKindBasicReplicaHealth = original.ServiceKindBasicReplicaHealth

const (
	ServiceKindBasicReplicaHealthServiceKindReplicaHealth ServiceKindBasicReplicaHealth = original.ServiceKindBasicReplicaHealthServiceKindReplicaHealth
	ServiceKindBasicReplicaHealthServiceKindStateful      ServiceKindBasicReplicaHealth = original.ServiceKindBasicReplicaHealthServiceKindStateful
	ServiceKindBasicReplicaHealthServiceKindStateless     ServiceKindBasicReplicaHealth = original.ServiceKindBasicReplicaHealthServiceKindStateless
)

type ServiceKindBasicReplicaHealthState = original.ServiceKindBasicReplicaHealthState

const (
	ServiceKindBasicReplicaHealthStateServiceKindReplicaHealthState ServiceKindBasicReplicaHealthState = original.ServiceKindBasicReplicaHealthStateServiceKindReplicaHealthState
	ServiceKindBasicReplicaHealthStateServiceKindStateful           ServiceKindBasicReplicaHealthState = original.ServiceKindBasicReplicaHealthStateServiceKindStateful
	ServiceKindBasicReplicaHealthStateServiceKindStateless          ServiceKindBasicReplicaHealthState = original.ServiceKindBasicReplicaHealthStateServiceKindStateless
)

type ServiceKindBasicReplicaInfo = original.ServiceKindBasicReplicaInfo

const (
	ServiceKindBasicReplicaInfoServiceKindReplicaInfo ServiceKindBasicReplicaInfo = original.ServiceKindBasicReplicaInfoServiceKindReplicaInfo
	ServiceKindBasicReplicaInfoServiceKindStateful    ServiceKindBasicReplicaInfo = original.ServiceKindBasicReplicaInfoServiceKindStateful
	ServiceKindBasicReplicaInfoServiceKindStateless   ServiceKindBasicReplicaInfo = original.ServiceKindBasicReplicaInfoServiceKindStateless
)

type ServiceKindBasicServiceDescription = original.ServiceKindBasicServiceDescription

const (
	ServiceKindBasicServiceDescriptionServiceKindServiceDescription ServiceKindBasicServiceDescription = original.ServiceKindBasicServiceDescriptionServiceKindServiceDescription
	ServiceKindBasicServiceDescriptionServiceKindStateful           ServiceKindBasicServiceDescription = original.ServiceKindBasicServiceDescriptionServiceKindStateful
	ServiceKindBasicServiceDescriptionServiceKindStateless          ServiceKindBasicServiceDescription = original.ServiceKindBasicServiceDescriptionServiceKindStateless
)

type ServiceKindBasicServiceInfo = original.ServiceKindBasicServiceInfo

const (
	ServiceKindBasicServiceInfoServiceKindServiceInfo ServiceKindBasicServiceInfo = original.ServiceKindBasicServiceInfoServiceKindServiceInfo
	ServiceKindBasicServiceInfoServiceKindStateful    ServiceKindBasicServiceInfo = original.ServiceKindBasicServiceInfoServiceKindStateful
	ServiceKindBasicServiceInfoServiceKindStateless   ServiceKindBasicServiceInfo = original.ServiceKindBasicServiceInfoServiceKindStateless
)

type ServiceKindBasicServicePartitionInfo = original.ServiceKindBasicServicePartitionInfo

const (
	ServiceKindBasicServicePartitionInfoServiceKindServicePartitionInfo ServiceKindBasicServicePartitionInfo = original.ServiceKindBasicServicePartitionInfoServiceKindServicePartitionInfo
	ServiceKindBasicServicePartitionInfoServiceKindStateful             ServiceKindBasicServicePartitionInfo = original.ServiceKindBasicServicePartitionInfoServiceKindStateful
	ServiceKindBasicServicePartitionInfoServiceKindStateless            ServiceKindBasicServicePartitionInfo = original.ServiceKindBasicServicePartitionInfoServiceKindStateless
)

type ServiceKindBasicServiceUpdateDescription = original.ServiceKindBasicServiceUpdateDescription

const (
	ServiceKindBasicServiceUpdateDescriptionServiceKindServiceUpdateDescription ServiceKindBasicServiceUpdateDescription = original.ServiceKindBasicServiceUpdateDescriptionServiceKindServiceUpdateDescription
	ServiceKindBasicServiceUpdateDescriptionServiceKindStateful                 ServiceKindBasicServiceUpdateDescription = original.ServiceKindBasicServiceUpdateDescriptionServiceKindStateful
	ServiceKindBasicServiceUpdateDescriptionServiceKindStateless                ServiceKindBasicServiceUpdateDescription = original.ServiceKindBasicServiceUpdateDescriptionServiceKindStateless
)

type ServiceLoadMetricWeight = original.ServiceLoadMetricWeight

const (
	ServiceLoadMetricWeightHigh   ServiceLoadMetricWeight = original.ServiceLoadMetricWeightHigh
	ServiceLoadMetricWeightLow    ServiceLoadMetricWeight = original.ServiceLoadMetricWeightLow
	ServiceLoadMetricWeightMedium ServiceLoadMetricWeight = original.ServiceLoadMetricWeightMedium
	ServiceLoadMetricWeightZero   ServiceLoadMetricWeight = original.ServiceLoadMetricWeightZero
)

type ServiceOperationName = original.ServiceOperationName

const (
	ServiceOperationNameAbort      ServiceOperationName = original.ServiceOperationNameAbort
	ServiceOperationNameChangeRole ServiceOperationName = original.ServiceOperationNameChangeRole
	ServiceOperationNameClose      ServiceOperationName = original.ServiceOperationNameClose
	ServiceOperationNameNone       ServiceOperationName = original.ServiceOperationNameNone
	ServiceOperationNameOpen       ServiceOperationName = original.ServiceOperationNameOpen
	ServiceOperationNameUnknown    ServiceOperationName = original.ServiceOperationNameUnknown
)

type ServicePackageActivationMode = original.ServicePackageActivationMode

const (
	ExclusiveProcess ServicePackageActivationMode = original.ExclusiveProcess
	SharedProcess    ServicePackageActivationMode = original.SharedProcess
)

type ServicePartitionKind = original.ServicePartitionKind

const (
	ServicePartitionKindInt64Range           ServicePartitionKind = original.ServicePartitionKindInt64Range
	ServicePartitionKindNamed                ServicePartitionKind = original.ServicePartitionKindNamed
	ServicePartitionKindPartitionInformation ServicePartitionKind = original.ServicePartitionKindPartitionInformation
	ServicePartitionKindSingleton            ServicePartitionKind = original.ServicePartitionKindSingleton
)

type ServicePartitionStatus = original.ServicePartitionStatus

const (
	ServicePartitionStatusDeleting      ServicePartitionStatus = original.ServicePartitionStatusDeleting
	ServicePartitionStatusInQuorumLoss  ServicePartitionStatus = original.ServicePartitionStatusInQuorumLoss
	ServicePartitionStatusInvalid       ServicePartitionStatus = original.ServicePartitionStatusInvalid
	ServicePartitionStatusNotReady      ServicePartitionStatus = original.ServicePartitionStatusNotReady
	ServicePartitionStatusReady         ServicePartitionStatus = original.ServicePartitionStatusReady
	ServicePartitionStatusReconfiguring ServicePartitionStatus = original.ServicePartitionStatusReconfiguring
)

type ServicePlacementPolicyType = original.ServicePlacementPolicyType

const (
	ServicePlacementPolicyTypeInvalid                    ServicePlacementPolicyType = original.ServicePlacementPolicyTypeInvalid
	ServicePlacementPolicyTypeInvalidDomain              ServicePlacementPolicyType = original.ServicePlacementPolicyTypeInvalidDomain
	ServicePlacementPolicyTypeNonPartiallyPlaceService   ServicePlacementPolicyType = original.ServicePlacementPolicyTypeNonPartiallyPlaceService
	ServicePlacementPolicyTypePreferredPrimaryDomain     ServicePlacementPolicyType = original.ServicePlacementPolicyTypePreferredPrimaryDomain
	ServicePlacementPolicyTypeRequiredDomain             ServicePlacementPolicyType = original.ServicePlacementPolicyTypeRequiredDomain
	ServicePlacementPolicyTypeRequiredDomainDistribution ServicePlacementPolicyType = original.ServicePlacementPolicyTypeRequiredDomainDistribution
)

type ServiceStatus = original.ServiceStatus

const (
	ServiceStatusActive    ServiceStatus = original.ServiceStatusActive
	ServiceStatusCreating  ServiceStatus = original.ServiceStatusCreating
	ServiceStatusDeleting  ServiceStatus = original.ServiceStatusDeleting
	ServiceStatusFailed    ServiceStatus = original.ServiceStatusFailed
	ServiceStatusUnknown   ServiceStatus = original.ServiceStatusUnknown
	ServiceStatusUpgrading ServiceStatus = original.ServiceStatusUpgrading
)

type ServiceTypeRegistrationStatus = original.ServiceTypeRegistrationStatus

const (
	ServiceTypeRegistrationStatusDisabled   ServiceTypeRegistrationStatus = original.ServiceTypeRegistrationStatusDisabled
	ServiceTypeRegistrationStatusEnabled    ServiceTypeRegistrationStatus = original.ServiceTypeRegistrationStatusEnabled
	ServiceTypeRegistrationStatusInvalid    ServiceTypeRegistrationStatus = original.ServiceTypeRegistrationStatusInvalid
	ServiceTypeRegistrationStatusRegistered ServiceTypeRegistrationStatus = original.ServiceTypeRegistrationStatusRegistered
)

type State = original.State

const (
	StateApproved  State = original.StateApproved
	StateClaimed   State = original.StateClaimed
	StateCompleted State = original.StateCompleted
	StateCreated   State = original.StateCreated
	StateExecuting State = original.StateExecuting
	StateInvalid   State = original.StateInvalid
	StatePreparing State = original.StatePreparing
	StateRestoring State = original.StateRestoring
)

type Status = original.Status

const (
	StatusInvalid Status = original.StatusInvalid
	StatusRunning Status = original.StatusRunning
	StatusStopped Status = original.StatusStopped
)

type Type = original.Type

const (
	TypeInvalidDomain                     Type = original.TypeInvalidDomain
	TypeNonPartiallyPlaceService          Type = original.TypeNonPartiallyPlaceService
	TypePreferPrimaryDomain               Type = original.TypePreferPrimaryDomain
	TypeRequireDomain                     Type = original.TypeRequireDomain
	TypeRequireDomainDistribution         Type = original.TypeRequireDomainDistribution
	TypeServicePlacementPolicyDescription Type = original.TypeServicePlacementPolicyDescription
)

type UpgradeDomainState = original.UpgradeDomainState

const (
	UpgradeDomainStateCompleted  UpgradeDomainState = original.UpgradeDomainStateCompleted
	UpgradeDomainStateInProgress UpgradeDomainState = original.UpgradeDomainStateInProgress
	UpgradeDomainStateInvalid    UpgradeDomainState = original.UpgradeDomainStateInvalid
	UpgradeDomainStatePending    UpgradeDomainState = original.UpgradeDomainStatePending
)

type UpgradeKind = original.UpgradeKind

const (
	UpgradeKindInvalid UpgradeKind = original.UpgradeKindInvalid
	UpgradeKindRolling UpgradeKind = original.UpgradeKindRolling
)

type UpgradeMode = original.UpgradeMode

const (
	UpgradeModeInvalid           UpgradeMode = original.UpgradeModeInvalid
	UpgradeModeMonitored         UpgradeMode = original.UpgradeModeMonitored
	UpgradeModeUnmonitoredAuto   UpgradeMode = original.UpgradeModeUnmonitoredAuto
	UpgradeModeUnmonitoredManual UpgradeMode = original.UpgradeModeUnmonitoredManual
)

type UpgradeState = original.UpgradeState

const (
	UpgradeStateFailed                   UpgradeState = original.UpgradeStateFailed
	UpgradeStateInvalid                  UpgradeState = original.UpgradeStateInvalid
	UpgradeStateRollingBackCompleted     UpgradeState = original.UpgradeStateRollingBackCompleted
	UpgradeStateRollingBackInProgress    UpgradeState = original.UpgradeStateRollingBackInProgress
	UpgradeStateRollingForwardCompleted  UpgradeState = original.UpgradeStateRollingForwardCompleted
	UpgradeStateRollingForwardInProgress UpgradeState = original.UpgradeStateRollingForwardInProgress
	UpgradeStateRollingForwardPending    UpgradeState = original.UpgradeStateRollingForwardPending
)

type UpgradeType = original.UpgradeType

const (
	UpgradeTypeInvalid             UpgradeType = original.UpgradeTypeInvalid
	UpgradeTypeRolling             UpgradeType = original.UpgradeTypeRolling
	UpgradeTypeRollingForceRestart UpgradeType = original.UpgradeTypeRollingForceRestart
)

type AadMetadata = original.AadMetadata
type AadMetadataObject = original.AadMetadataObject
type ApplicationCapacityDescription = original.ApplicationCapacityDescription
type ApplicationDescription = original.ApplicationDescription
type ApplicationHealth = original.ApplicationHealth
type ApplicationHealthEvaluation = original.ApplicationHealthEvaluation
type ApplicationHealthPolicies = original.ApplicationHealthPolicies
type ApplicationHealthPolicy = original.ApplicationHealthPolicy
type ApplicationHealthPolicyMapItem = original.ApplicationHealthPolicyMapItem
type ApplicationHealthState = original.ApplicationHealthState
type ApplicationHealthStateChunk = original.ApplicationHealthStateChunk
type ApplicationHealthStateChunkList = original.ApplicationHealthStateChunkList
type ApplicationHealthStateFilter = original.ApplicationHealthStateFilter
type ApplicationInfo = original.ApplicationInfo
type ApplicationLoadInfo = original.ApplicationLoadInfo
type ApplicationMetricDescription = original.ApplicationMetricDescription
type ApplicationNameInfo = original.ApplicationNameInfo
type ApplicationParameter = original.ApplicationParameter
type ApplicationsHealthEvaluation = original.ApplicationsHealthEvaluation
type ApplicationTypeApplicationsHealthEvaluation = original.ApplicationTypeApplicationsHealthEvaluation
type ApplicationTypeHealthPolicyMapItem = original.ApplicationTypeHealthPolicyMapItem
type ApplicationTypeImageStorePath = original.ApplicationTypeImageStorePath
type ApplicationTypeInfo = original.ApplicationTypeInfo
type ApplicationTypeManifest = original.ApplicationTypeManifest
type ApplicationUpgradeDescription = original.ApplicationUpgradeDescription
type ApplicationUpgradeProgressInfo = original.ApplicationUpgradeProgressInfo
type ApplicationUpgradeUpdateDescription = original.ApplicationUpgradeUpdateDescription
type BinaryPropertyValue = original.BinaryPropertyValue
type ChaosContext = original.ChaosContext
type ChaosContextMapItem = original.ChaosContextMapItem
type BasicChaosEvent = original.BasicChaosEvent
type ChaosEvent = original.ChaosEvent
type ChaosEventWrapper = original.ChaosEventWrapper
type ChaosParameters = original.ChaosParameters
type ChaosReport = original.ChaosReport
type ChaosTargetFilter = original.ChaosTargetFilter
type CheckExistsPropertyBatchOperation = original.CheckExistsPropertyBatchOperation
type CheckSequencePropertyBatchOperation = original.CheckSequencePropertyBatchOperation
type CheckValuePropertyBatchOperation = original.CheckValuePropertyBatchOperation
type ClusterConfiguration = original.ClusterConfiguration
type ClusterConfigurationUpgradeDescription = original.ClusterConfigurationUpgradeDescription
type ClusterConfigurationUpgradeStatusInfo = original.ClusterConfigurationUpgradeStatusInfo
type ClusterHealth = original.ClusterHealth
type ClusterHealthChunk = original.ClusterHealthChunk
type ClusterHealthChunkQueryDescription = original.ClusterHealthChunkQueryDescription
type ClusterHealthPolicies = original.ClusterHealthPolicies
type ClusterHealthPolicy = original.ClusterHealthPolicy
type ClusterManifest = original.ClusterManifest
type ClusterUpgradeDescriptionObject = original.ClusterUpgradeDescriptionObject
type ClusterUpgradeHealthPolicyObject = original.ClusterUpgradeHealthPolicyObject
type ClusterUpgradeProgressObject = original.ClusterUpgradeProgressObject
type CodePackageEntryPoint = original.CodePackageEntryPoint
type CodePackageEntryPointStatistics = original.CodePackageEntryPointStatistics
type ComposeDeploymentStatusInfo = original.ComposeDeploymentStatusInfo
type ComposeDeploymentUpgradeDescription = original.ComposeDeploymentUpgradeDescription
type ComposeDeploymentUpgradeProgressInfo = original.ComposeDeploymentUpgradeProgressInfo
type ContainerLogs = original.ContainerLogs
type CreateComposeDeploymentDescription = original.CreateComposeDeploymentDescription
type CurrentUpgradeDomainProgressInfo = original.CurrentUpgradeDomainProgressInfo
type DeactivationIntentDescription = original.DeactivationIntentDescription
type DeletePropertyBatchOperation = original.DeletePropertyBatchOperation
type DeltaNodesCheckHealthEvaluation = original.DeltaNodesCheckHealthEvaluation
type DeployedApplicationHealth = original.DeployedApplicationHealth
type DeployedApplicationHealthEvaluation = original.DeployedApplicationHealthEvaluation
type DeployedApplicationHealthState = original.DeployedApplicationHealthState
type DeployedApplicationHealthStateChunk = original.DeployedApplicationHealthStateChunk
type DeployedApplicationHealthStateChunkList = original.DeployedApplicationHealthStateChunkList
type DeployedApplicationHealthStateFilter = original.DeployedApplicationHealthStateFilter
type DeployedApplicationInfo = original.DeployedApplicationInfo
type DeployedApplicationsHealthEvaluation = original.DeployedApplicationsHealthEvaluation
type DeployedCodePackageInfo = original.DeployedCodePackageInfo
type DeployedServicePackageHealth = original.DeployedServicePackageHealth
type DeployedServicePackageHealthEvaluation = original.DeployedServicePackageHealthEvaluation
type DeployedServicePackageHealthState = original.DeployedServicePackageHealthState
type DeployedServicePackageHealthStateChunk = original.DeployedServicePackageHealthStateChunk
type DeployedServicePackageHealthStateChunkList = original.DeployedServicePackageHealthStateChunkList
type DeployedServicePackageHealthStateFilter = original.DeployedServicePackageHealthStateFilter
type DeployedServicePackageInfo = original.DeployedServicePackageInfo
type DeployedServicePackagesHealthEvaluation = original.DeployedServicePackagesHealthEvaluation
type BasicDeployedServiceReplicaDetailInfo = original.BasicDeployedServiceReplicaDetailInfo
type DeployedServiceReplicaDetailInfo = original.DeployedServiceReplicaDetailInfo
type DeployedServiceReplicaDetailInfoModel = original.DeployedServiceReplicaDetailInfoModel
type BasicDeployedServiceReplicaInfo = original.BasicDeployedServiceReplicaInfo
type DeployedServiceReplicaInfo = original.DeployedServiceReplicaInfo
type DeployedServiceTypeInfo = original.DeployedServiceTypeInfo
type DeployedStatefulServiceReplicaDetailInfo = original.DeployedStatefulServiceReplicaDetailInfo
type DeployedStatefulServiceReplicaInfo = original.DeployedStatefulServiceReplicaInfo
type DeployedStatelessServiceInstanceDetailInfo = original.DeployedStatelessServiceInstanceDetailInfo
type DeployedStatelessServiceInstanceInfo = original.DeployedStatelessServiceInstanceInfo
type DeployServicePackageToNodeDescription = original.DeployServicePackageToNodeDescription
type DoublePropertyValue = original.DoublePropertyValue
type EnsureAvailabilitySafetyCheck = original.EnsureAvailabilitySafetyCheck
type EnsurePartitionQurumSafetyCheck = original.EnsurePartitionQurumSafetyCheck
type EntityHealth = original.EntityHealth
type EntityHealthState = original.EntityHealthState
type EntityHealthStateChunk = original.EntityHealthStateChunk
type EntityHealthStateChunkList = original.EntityHealthStateChunkList
type EntityKindHealthStateCount = original.EntityKindHealthStateCount
type Epoch = original.Epoch
type EventHealthEvaluation = original.EventHealthEvaluation
type ExecutingFaultsChaosEvent = original.ExecutingFaultsChaosEvent
type ExternalStoreProvisionApplicationTypeDescription = original.ExternalStoreProvisionApplicationTypeDescription
type FabricCodeVersionInfo = original.FabricCodeVersionInfo
type FabricConfigVersionInfo = original.FabricConfigVersionInfo
type FabricError = original.FabricError
type FabricErrorError = original.FabricErrorError
type FailedPropertyBatchInfo = original.FailedPropertyBatchInfo
type FailedUpgradeDomainProgressObject = original.FailedUpgradeDomainProgressObject
type FailureUpgradeDomainProgressInfo = original.FailureUpgradeDomainProgressInfo
type FileInfo = original.FileInfo
type FileVersion = original.FileVersion
type FolderInfo = original.FolderInfo
type GetPropertyBatchOperation = original.GetPropertyBatchOperation
type GUIDPropertyValue = original.GUIDPropertyValue
type BasicHealthEvaluation = original.BasicHealthEvaluation
type HealthEvaluation = original.HealthEvaluation
type HealthEvaluationWrapper = original.HealthEvaluationWrapper
type HealthEvent = original.HealthEvent
type HealthInformation = original.HealthInformation
type HealthStateCount = original.HealthStateCount
type HealthStatistics = original.HealthStatistics
type ImageStoreContent = original.ImageStoreContent
type ImageStoreCopyDescription = original.ImageStoreCopyDescription
type Int64PropertyValue = original.Int64PropertyValue
type Int64RangePartitionInformation = original.Int64RangePartitionInformation
type InvokeDataLossResult = original.InvokeDataLossResult
type InvokeQuorumLossResult = original.InvokeQuorumLossResult
type KeyValueStoreReplicaStatus = original.KeyValueStoreReplicaStatus
type ListDeployedCodePackageInfo = original.ListDeployedCodePackageInfo
type ListDeployedServicePackageInfo = original.ListDeployedServicePackageInfo
type ListDeployedServiceReplicaInfo = original.ListDeployedServiceReplicaInfo
type ListDeployedServiceTypeInfo = original.ListDeployedServiceTypeInfo
type ListFabricCodeVersionInfo = original.ListFabricCodeVersionInfo
type ListFabricConfigVersionInfo = original.ListFabricConfigVersionInfo
type ListOperationStatus = original.ListOperationStatus
type ListRepairTask = original.ListRepairTask
type ListServiceTypeInfo = original.ListServiceTypeInfo
type LoadMetricReport = original.LoadMetricReport
type LoadMetricReportInfo = original.LoadMetricReportInfo
type MonitoringPolicyDescription = original.MonitoringPolicyDescription
type NameDescription = original.NameDescription
type NamedPartitionInformation = original.NamedPartitionInformation
type NamedPartitionSchemeDescription = original.NamedPartitionSchemeDescription
type NodeDeactivationInfo = original.NodeDeactivationInfo
type NodeDeactivationTask = original.NodeDeactivationTask
type NodeDeactivationTaskID = original.NodeDeactivationTaskID
type NodeHealth = original.NodeHealth
type NodeHealthEvaluation = original.NodeHealthEvaluation
type NodeHealthState = original.NodeHealthState
type NodeHealthStateChunk = original.NodeHealthStateChunk
type NodeHealthStateChunkList = original.NodeHealthStateChunkList
type NodeHealthStateFilter = original.NodeHealthStateFilter
type NodeID = original.NodeID
type NodeImpact = original.NodeImpact
type NodeInfo = original.NodeInfo
type NodeLoadInfo = original.NodeLoadInfo
type NodeLoadMetricInformation = original.NodeLoadMetricInformation
type NodeRepairImpactDescription = original.NodeRepairImpactDescription
type NodeRepairTargetDescription = original.NodeRepairTargetDescription
type NodeResult = original.NodeResult
type NodesHealthEvaluation = original.NodesHealthEvaluation
type NodeTransitionProgress = original.NodeTransitionProgress
type NodeTransitionResult = original.NodeTransitionResult
type NodeUpgradeProgressInfo = original.NodeUpgradeProgressInfo
type OperationStatus = original.OperationStatus
type PackageSharingPolicyInfo = original.PackageSharingPolicyInfo
type PagedApplicationInfoList = original.PagedApplicationInfoList
type PagedApplicationTypeInfoList = original.PagedApplicationTypeInfoList
type PagedComposeDeploymentStatusInfoList = original.PagedComposeDeploymentStatusInfoList
type PagedDeployedApplicationInfoList = original.PagedDeployedApplicationInfoList
type PagedNodeInfoList = original.PagedNodeInfoList
type PagedPropertyInfoList = original.PagedPropertyInfoList
type PagedReplicaInfoList = original.PagedReplicaInfoList
type PagedServiceInfoList = original.PagedServiceInfoList
type PagedServicePartitionInfoList = original.PagedServicePartitionInfoList
type PagedSubNameInfoList = original.PagedSubNameInfoList
type PartitionDataLossProgress = original.PartitionDataLossProgress
type PartitionHealth = original.PartitionHealth
type PartitionHealthEvaluation = original.PartitionHealthEvaluation
type PartitionHealthState = original.PartitionHealthState
type PartitionHealthStateChunk = original.PartitionHealthStateChunk
type PartitionHealthStateChunkList = original.PartitionHealthStateChunkList
type PartitionHealthStateFilter = original.PartitionHealthStateFilter
type BasicPartitionInformation = original.BasicPartitionInformation
type PartitionInformation = original.PartitionInformation
type PartitionLoadInformation = original.PartitionLoadInformation
type PartitionQuorumLossProgress = original.PartitionQuorumLossProgress
type PartitionRestartProgress = original.PartitionRestartProgress
type BasicPartitionSafetyCheck = original.BasicPartitionSafetyCheck
type PartitionSafetyCheck = original.PartitionSafetyCheck
type BasicPartitionSchemeDescription = original.BasicPartitionSchemeDescription
type PartitionSchemeDescription = original.PartitionSchemeDescription
type PartitionsHealthEvaluation = original.PartitionsHealthEvaluation
type PrimaryReplicatorStatus = original.PrimaryReplicatorStatus
type PropertyBatchDescriptionList = original.PropertyBatchDescriptionList
type BasicPropertyBatchInfo = original.BasicPropertyBatchInfo
type PropertyBatchInfo = original.PropertyBatchInfo
type PropertyBatchInfoModel = original.PropertyBatchInfoModel
type BasicPropertyBatchOperation = original.BasicPropertyBatchOperation
type PropertyBatchOperation = original.PropertyBatchOperation
type PropertyDescription = original.PropertyDescription
type PropertyInfo = original.PropertyInfo
type PropertyMetadata = original.PropertyMetadata
type BasicPropertyValue = original.BasicPropertyValue
type PropertyValue = original.PropertyValue
type ProvisionApplicationTypeDescription = original.ProvisionApplicationTypeDescription
type BasicProvisionApplicationTypeDescriptionBase = original.BasicProvisionApplicationTypeDescriptionBase
type ProvisionApplicationTypeDescriptionBase = original.ProvisionApplicationTypeDescriptionBase
type ProvisionFabricDescription = original.ProvisionFabricDescription
type PutPropertyBatchOperation = original.PutPropertyBatchOperation
type ReconfigurationInformation = original.ReconfigurationInformation
type RegistryCredential = original.RegistryCredential
type RemoteReplicatorAcknowledgementDetail = original.RemoteReplicatorAcknowledgementDetail
type RemoteReplicatorAcknowledgementStatus = original.RemoteReplicatorAcknowledgementStatus
type RemoteReplicatorStatus = original.RemoteReplicatorStatus
type BasicRepairImpactDescriptionBase = original.BasicRepairImpactDescriptionBase
type RepairImpactDescriptionBase = original.RepairImpactDescriptionBase
type BasicRepairTargetDescriptionBase = original.BasicRepairTargetDescriptionBase
type RepairTargetDescriptionBase = original.RepairTargetDescriptionBase
type RepairTask = original.RepairTask
type RepairTaskApproveDescription = original.RepairTaskApproveDescription
type RepairTaskCancelDescription = original.RepairTaskCancelDescription
type RepairTaskDeleteDescription = original.RepairTaskDeleteDescription
type RepairTaskHistory = original.RepairTaskHistory
type RepairTaskUpdateHealthPolicyDescription = original.RepairTaskUpdateHealthPolicyDescription
type RepairTaskUpdateInfo = original.RepairTaskUpdateInfo
type BasicReplicaHealth = original.BasicReplicaHealth
type ReplicaHealth = original.ReplicaHealth
type ReplicaHealthEvaluation = original.ReplicaHealthEvaluation
type ReplicaHealthModel = original.ReplicaHealthModel
type BasicReplicaHealthState = original.BasicReplicaHealthState
type ReplicaHealthState = original.ReplicaHealthState
type ReplicaHealthStateChunk = original.ReplicaHealthStateChunk
type ReplicaHealthStateChunkList = original.ReplicaHealthStateChunkList
type ReplicaHealthStateFilter = original.ReplicaHealthStateFilter
type BasicReplicaInfo = original.BasicReplicaInfo
type ReplicaInfo = original.ReplicaInfo
type ReplicaInfoModel = original.ReplicaInfoModel
type ReplicasHealthEvaluation = original.ReplicasHealthEvaluation
type BasicReplicaStatusBase = original.BasicReplicaStatusBase
type ReplicaStatusBase = original.ReplicaStatusBase
type ReplicatorQueueStatus = original.ReplicatorQueueStatus
type BasicReplicatorStatus = original.BasicReplicatorStatus
type ReplicatorStatus = original.ReplicatorStatus
type ResolvedServiceEndpoint = original.ResolvedServiceEndpoint
type ResolvedServicePartition = original.ResolvedServicePartition
type RestartDeployedCodePackageDescription = original.RestartDeployedCodePackageDescription
type RestartNodeDescription = original.RestartNodeDescription
type RestartPartitionResult = original.RestartPartitionResult
type ResumeApplicationUpgradeDescription = original.ResumeApplicationUpgradeDescription
type ResumeClusterUpgradeDescription = original.ResumeClusterUpgradeDescription
type RollingUpgradeUpdateDescription = original.RollingUpgradeUpdateDescription
type BasicSafetyCheck = original.BasicSafetyCheck
type SafetyCheck = original.SafetyCheck
type SafetyCheckWrapper = original.SafetyCheckWrapper
type SecondaryActiveReplicatorStatus = original.SecondaryActiveReplicatorStatus
type SecondaryIdleReplicatorStatus = original.SecondaryIdleReplicatorStatus
type BasicSecondaryReplicatorStatus = original.BasicSecondaryReplicatorStatus
type SecondaryReplicatorStatus = original.SecondaryReplicatorStatus
type SeedNodeSafetyCheck = original.SeedNodeSafetyCheck
type SelectedPartition = original.SelectedPartition
type ServiceCorrelationDescription = original.ServiceCorrelationDescription
type BasicServiceDescription = original.BasicServiceDescription
type ServiceDescription = original.ServiceDescription
type ServiceDescriptionModel = original.ServiceDescriptionModel
type ServiceFromTemplateDescription = original.ServiceFromTemplateDescription
type ServiceHealth = original.ServiceHealth
type ServiceHealthEvaluation = original.ServiceHealthEvaluation
type ServiceHealthState = original.ServiceHealthState
type ServiceHealthStateChunk = original.ServiceHealthStateChunk
type ServiceHealthStateChunkList = original.ServiceHealthStateChunkList
type ServiceHealthStateFilter = original.ServiceHealthStateFilter
type BasicServiceInfo = original.BasicServiceInfo
type ServiceInfo = original.ServiceInfo
type ServiceInfoModel = original.ServiceInfoModel
type ServiceLoadMetricDescription = original.ServiceLoadMetricDescription
type ServiceNameInfo = original.ServiceNameInfo
type BasicServicePartitionInfo = original.BasicServicePartitionInfo
type ServicePartitionInfo = original.ServicePartitionInfo
type ServicePartitionInfoModel = original.ServicePartitionInfoModel
type ServicePlacementInvalidDomainPolicyDescription = original.ServicePlacementInvalidDomainPolicyDescription
type ServicePlacementNonPartiallyPlaceServicePolicyDescription = original.ServicePlacementNonPartiallyPlaceServicePolicyDescription
type BasicServicePlacementPolicyDescription = original.BasicServicePlacementPolicyDescription
type ServicePlacementPolicyDescription = original.ServicePlacementPolicyDescription
type ServicePlacementPreferPrimaryDomainPolicyDescription = original.ServicePlacementPreferPrimaryDomainPolicyDescription
type ServicePlacementRequiredDomainPolicyDescription = original.ServicePlacementRequiredDomainPolicyDescription
type ServicePlacementRequireDomainDistributionPolicyDescription = original.ServicePlacementRequireDomainDistributionPolicyDescription
type ServicesHealthEvaluation = original.ServicesHealthEvaluation
type BasicServiceTypeDescription = original.BasicServiceTypeDescription
type ServiceTypeDescription = original.ServiceTypeDescription
type ServiceTypeExtensionDescription = original.ServiceTypeExtensionDescription
type ServiceTypeHealthPolicy = original.ServiceTypeHealthPolicy
type ServiceTypeHealthPolicyMapItem = original.ServiceTypeHealthPolicyMapItem
type ServiceTypeInfo = original.ServiceTypeInfo
type ServiceTypeManifest = original.ServiceTypeManifest
type BasicServiceUpdateDescription = original.BasicServiceUpdateDescription
type ServiceUpdateDescription = original.ServiceUpdateDescription
type SingletonPartitionInformation = original.SingletonPartitionInformation
type SingletonPartitionSchemeDescription = original.SingletonPartitionSchemeDescription
type StartClusterUpgradeDescription = original.StartClusterUpgradeDescription
type StartedChaosEvent = original.StartedChaosEvent
type StatefulServiceDescription = original.StatefulServiceDescription
type StatefulServiceInfo = original.StatefulServiceInfo
type StatefulServicePartitionInfo = original.StatefulServicePartitionInfo
type StatefulServiceReplicaHealth = original.StatefulServiceReplicaHealth
type StatefulServiceReplicaHealthState = original.StatefulServiceReplicaHealthState
type StatefulServiceReplicaInfo = original.StatefulServiceReplicaInfo
type StatefulServiceTypeDescription = original.StatefulServiceTypeDescription
type StatefulServiceUpdateDescription = original.StatefulServiceUpdateDescription
type StatelessServiceDescription = original.StatelessServiceDescription
type StatelessServiceInfo = original.StatelessServiceInfo
type StatelessServiceInstanceHealth = original.StatelessServiceInstanceHealth
type StatelessServiceInstanceHealthState = original.StatelessServiceInstanceHealthState
type StatelessServiceInstanceInfo = original.StatelessServiceInstanceInfo
type StatelessServicePartitionInfo = original.StatelessServicePartitionInfo
type StatelessServiceTypeDescription = original.StatelessServiceTypeDescription
type StatelessServiceUpdateDescription = original.StatelessServiceUpdateDescription
type StoppedChaosEvent = original.StoppedChaosEvent
type String = original.String
type StringPropertyValue = original.StringPropertyValue
type SuccessfulPropertyBatchInfo = original.SuccessfulPropertyBatchInfo
type SystemApplicationHealthEvaluation = original.SystemApplicationHealthEvaluation
type TestErrorChaosEvent = original.TestErrorChaosEvent
type UniformInt64RangePartitionSchemeDescription = original.UniformInt64RangePartitionSchemeDescription
type UnprovisionApplicationTypeDescriptionInfo = original.UnprovisionApplicationTypeDescriptionInfo
type UnprovisionFabricDescription = original.UnprovisionFabricDescription
type UpdateClusterUpgradeDescription = original.UpdateClusterUpgradeDescription
type UpgradeDomainDeltaNodesCheckHealthEvaluation = original.UpgradeDomainDeltaNodesCheckHealthEvaluation
type UpgradeDomainInfo = original.UpgradeDomainInfo
type UpgradeDomainNodesHealthEvaluation = original.UpgradeDomainNodesHealthEvaluation
type UpgradeOrchestrationServiceState = original.UpgradeOrchestrationServiceState
type UpgradeOrchestrationServiceStateSummary = original.UpgradeOrchestrationServiceStateSummary
type UploadChunkRange = original.UploadChunkRange
type UploadSession = original.UploadSession
type UploadSessionInfo = original.UploadSessionInfo
type ValidationFailedChaosEvent = original.ValidationFailedChaosEvent
type WaitForInbuildReplicaSafetyCheck = original.WaitForInbuildReplicaSafetyCheck
type WaitForPrimaryPlacementSafetyCheck = original.WaitForPrimaryPlacementSafetyCheck
type WaitForPrimarySwapSafetyCheck = original.WaitForPrimarySwapSafetyCheck
type WaitForReconfigurationSafetyCheck = original.WaitForReconfigurationSafetyCheck
type WaitingChaosEvent = original.WaitingChaosEvent

func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
