// +build go1.9

// Copyright 2018 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package management

import original "github.com/Azure/azure-sdk-for-go/services/resources/mgmt/2017-11-01-preview/management"

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient

func New() BaseClient {
	return original.New()
}
func NewWithBaseURI(baseURI string) BaseClient {
	return original.NewWithBaseURI(baseURI)
}

type GroupsClient = original.GroupsClient

func NewGroupsClient() GroupsClient {
	return original.NewGroupsClient()
}
func NewGroupsClientWithBaseURI(baseURI string) GroupsClient {
	return original.NewGroupsClientWithBaseURI(baseURI)
}

type GroupSubscriptionsClient = original.GroupSubscriptionsClient

func NewGroupSubscriptionsClient() GroupSubscriptionsClient {
	return original.NewGroupSubscriptionsClient()
}
func NewGroupSubscriptionsClientWithBaseURI(baseURI string) GroupSubscriptionsClient {
	return original.NewGroupSubscriptionsClientWithBaseURI(baseURI)
}

type ChildType = original.ChildType

const (
	ManagementGroup ChildType = original.ManagementGroup
	Subscription    ChildType = original.Subscription
)

type CreateManagementGroupRequest = original.CreateManagementGroupRequest
type ErrorDetails = original.ErrorDetails
type ErrorResponse = original.ErrorResponse
type Group = original.Group
type GroupChildInfo = original.GroupChildInfo
type GroupDetails = original.GroupDetails
type GroupInfo = original.GroupInfo
type GroupInfoProperties = original.GroupInfoProperties
type GroupListResult = original.GroupListResult
type GroupListResultIterator = original.GroupListResultIterator
type GroupListResultPage = original.GroupListResultPage
type GroupProperties = original.GroupProperties
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type ParentGroupInfo = original.ParentGroupInfo
type OperationsClient = original.OperationsClient

func NewOperationsClient() OperationsClient {
	return original.NewOperationsClient()
}
func NewOperationsClientWithBaseURI(baseURI string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
