// +build go1.9

// Copyright 2018 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package web

import original "github.com/Azure/azure-sdk-for-go/services/web/mgmt/2016-09-01/web"

type AppsClient = original.AppsClient

func NewAppsClient(subscriptionID string) AppsClient {
	return original.NewAppsClient(subscriptionID)
}
func NewAppsClientWithBaseURI(baseURI string, subscriptionID string) AppsClient {
	return original.NewAppsClientWithBaseURI(baseURI, subscriptionID)
}

type AppServiceCertificateOrdersClient = original.AppServiceCertificateOrdersClient

func NewAppServiceCertificateOrdersClient(subscriptionID string) AppServiceCertificateOrdersClient {
	return original.NewAppServiceCertificateOrdersClient(subscriptionID)
}
func NewAppServiceCertificateOrdersClientWithBaseURI(baseURI string, subscriptionID string) AppServiceCertificateOrdersClient {
	return original.NewAppServiceCertificateOrdersClientWithBaseURI(baseURI, subscriptionID)
}

type AppServiceEnvironmentsClient = original.AppServiceEnvironmentsClient

func NewAppServiceEnvironmentsClient(subscriptionID string) AppServiceEnvironmentsClient {
	return original.NewAppServiceEnvironmentsClient(subscriptionID)
}
func NewAppServiceEnvironmentsClientWithBaseURI(baseURI string, subscriptionID string) AppServiceEnvironmentsClient {
	return original.NewAppServiceEnvironmentsClientWithBaseURI(baseURI, subscriptionID)
}

type AppServicePlansClient = original.AppServicePlansClient

func NewAppServicePlansClient(subscriptionID string) AppServicePlansClient {
	return original.NewAppServicePlansClient(subscriptionID)
}
func NewAppServicePlansClientWithBaseURI(baseURI string, subscriptionID string) AppServicePlansClient {
	return original.NewAppServicePlansClientWithBaseURI(baseURI, subscriptionID)
}

type CertificateRegistrationProviderClient = original.CertificateRegistrationProviderClient

func NewCertificateRegistrationProviderClient(subscriptionID string) CertificateRegistrationProviderClient {
	return original.NewCertificateRegistrationProviderClient(subscriptionID)
}
func NewCertificateRegistrationProviderClientWithBaseURI(baseURI string, subscriptionID string) CertificateRegistrationProviderClient {
	return original.NewCertificateRegistrationProviderClientWithBaseURI(baseURI, subscriptionID)
}

type CertificatesClient = original.CertificatesClient

func NewCertificatesClient(subscriptionID string) CertificatesClient {
	return original.NewCertificatesClient(subscriptionID)
}
func NewCertificatesClientWithBaseURI(baseURI string, subscriptionID string) CertificatesClient {
	return original.NewCertificatesClientWithBaseURI(baseURI, subscriptionID)
}

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}

type DeletedWebAppsClient = original.DeletedWebAppsClient

func NewDeletedWebAppsClient(subscriptionID string) DeletedWebAppsClient {
	return original.NewDeletedWebAppsClient(subscriptionID)
}
func NewDeletedWebAppsClientWithBaseURI(baseURI string, subscriptionID string) DeletedWebAppsClient {
	return original.NewDeletedWebAppsClientWithBaseURI(baseURI, subscriptionID)
}

type DiagnosticsClient = original.DiagnosticsClient

func NewDiagnosticsClient(subscriptionID string) DiagnosticsClient {
	return original.NewDiagnosticsClient(subscriptionID)
}
func NewDiagnosticsClientWithBaseURI(baseURI string, subscriptionID string) DiagnosticsClient {
	return original.NewDiagnosticsClientWithBaseURI(baseURI, subscriptionID)
}

type DomainRegistrationProviderClient = original.DomainRegistrationProviderClient

func NewDomainRegistrationProviderClient(subscriptionID string) DomainRegistrationProviderClient {
	return original.NewDomainRegistrationProviderClient(subscriptionID)
}
func NewDomainRegistrationProviderClientWithBaseURI(baseURI string, subscriptionID string) DomainRegistrationProviderClient {
	return original.NewDomainRegistrationProviderClientWithBaseURI(baseURI, subscriptionID)
}

type DomainsClient = original.DomainsClient

func NewDomainsClient(subscriptionID string) DomainsClient {
	return original.NewDomainsClient(subscriptionID)
}
func NewDomainsClientWithBaseURI(baseURI string, subscriptionID string) DomainsClient {
	return original.NewDomainsClientWithBaseURI(baseURI, subscriptionID)
}

type AccessControlEntryAction = original.AccessControlEntryAction

const (
	Deny   AccessControlEntryAction = original.Deny
	Permit AccessControlEntryAction = original.Permit
)

type AppServicePlanRestrictions = original.AppServicePlanRestrictions

const (
	Basic    AppServicePlanRestrictions = original.Basic
	Free     AppServicePlanRestrictions = original.Free
	None     AppServicePlanRestrictions = original.None
	Premium  AppServicePlanRestrictions = original.Premium
	Shared   AppServicePlanRestrictions = original.Shared
	Standard AppServicePlanRestrictions = original.Standard
)

type AutoHealActionType = original.AutoHealActionType

const (
	CustomAction AutoHealActionType = original.CustomAction
	LogEvent     AutoHealActionType = original.LogEvent
	Recycle      AutoHealActionType = original.Recycle
)

type AzureResourceType = original.AzureResourceType

const (
	TrafficManager AzureResourceType = original.TrafficManager
	Website        AzureResourceType = original.Website
)

type BackupItemStatus = original.BackupItemStatus

const (
	Created            BackupItemStatus = original.Created
	Deleted            BackupItemStatus = original.Deleted
	DeleteFailed       BackupItemStatus = original.DeleteFailed
	DeleteInProgress   BackupItemStatus = original.DeleteInProgress
	Failed             BackupItemStatus = original.Failed
	InProgress         BackupItemStatus = original.InProgress
	PartiallySucceeded BackupItemStatus = original.PartiallySucceeded
	Skipped            BackupItemStatus = original.Skipped
	Succeeded          BackupItemStatus = original.Succeeded
	TimedOut           BackupItemStatus = original.TimedOut
)

type BackupRestoreOperationType = original.BackupRestoreOperationType

const (
	BackupRestoreOperationTypeClone      BackupRestoreOperationType = original.BackupRestoreOperationTypeClone
	BackupRestoreOperationTypeDefault    BackupRestoreOperationType = original.BackupRestoreOperationTypeDefault
	BackupRestoreOperationTypeRelocation BackupRestoreOperationType = original.BackupRestoreOperationTypeRelocation
	BackupRestoreOperationTypeSnapshot   BackupRestoreOperationType = original.BackupRestoreOperationTypeSnapshot
)

type BuiltInAuthenticationProvider = original.BuiltInAuthenticationProvider

const (
	AzureActiveDirectory BuiltInAuthenticationProvider = original.AzureActiveDirectory
	Facebook             BuiltInAuthenticationProvider = original.Facebook
	Google               BuiltInAuthenticationProvider = original.Google
	MicrosoftAccount     BuiltInAuthenticationProvider = original.MicrosoftAccount
	Twitter              BuiltInAuthenticationProvider = original.Twitter
)

type CertificateOrderActionType = original.CertificateOrderActionType

const (
	CertificateExpirationWarning CertificateOrderActionType = original.CertificateExpirationWarning
	CertificateExpired           CertificateOrderActionType = original.CertificateExpired
	CertificateIssued            CertificateOrderActionType = original.CertificateIssued
	CertificateOrderCanceled     CertificateOrderActionType = original.CertificateOrderCanceled
	CertificateOrderCreated      CertificateOrderActionType = original.CertificateOrderCreated
	CertificateRevoked           CertificateOrderActionType = original.CertificateRevoked
	DomainValidationComplete     CertificateOrderActionType = original.DomainValidationComplete
	FraudCleared                 CertificateOrderActionType = original.FraudCleared
	FraudDetected                CertificateOrderActionType = original.FraudDetected
	FraudDocumentationRequired   CertificateOrderActionType = original.FraudDocumentationRequired
	OrgNameChange                CertificateOrderActionType = original.OrgNameChange
	OrgValidationComplete        CertificateOrderActionType = original.OrgValidationComplete
	SanDrop                      CertificateOrderActionType = original.SanDrop
	Unknown                      CertificateOrderActionType = original.Unknown
)

type CertificateOrderStatus = original.CertificateOrderStatus

const (
	Canceled          CertificateOrderStatus = original.Canceled
	Denied            CertificateOrderStatus = original.Denied
	Expired           CertificateOrderStatus = original.Expired
	Issued            CertificateOrderStatus = original.Issued
	NotSubmitted      CertificateOrderStatus = original.NotSubmitted
	Pendingissuance   CertificateOrderStatus = original.Pendingissuance
	PendingRekey      CertificateOrderStatus = original.PendingRekey
	Pendingrevocation CertificateOrderStatus = original.Pendingrevocation
	Revoked           CertificateOrderStatus = original.Revoked
	Unused            CertificateOrderStatus = original.Unused
)

type CertificateProductType = original.CertificateProductType

const (
	StandardDomainValidatedSsl         CertificateProductType = original.StandardDomainValidatedSsl
	StandardDomainValidatedWildCardSsl CertificateProductType = original.StandardDomainValidatedWildCardSsl
)

type Channels = original.Channels

const (
	All          Channels = original.All
	API          Channels = original.API
	Email        Channels = original.Email
	Notification Channels = original.Notification
	Webhook      Channels = original.Webhook
)

type CheckNameResourceTypes = original.CheckNameResourceTypes

const (
	CheckNameResourceTypesHostingEnvironment              CheckNameResourceTypes = original.CheckNameResourceTypesHostingEnvironment
	CheckNameResourceTypesMicrosoftWebhostingEnvironments CheckNameResourceTypes = original.CheckNameResourceTypesMicrosoftWebhostingEnvironments
	CheckNameResourceTypesMicrosoftWebpublishingUsers     CheckNameResourceTypes = original.CheckNameResourceTypesMicrosoftWebpublishingUsers
	CheckNameResourceTypesMicrosoftWebsites               CheckNameResourceTypes = original.CheckNameResourceTypesMicrosoftWebsites
	CheckNameResourceTypesMicrosoftWebsitesslots          CheckNameResourceTypes = original.CheckNameResourceTypesMicrosoftWebsitesslots
	CheckNameResourceTypesPublishingUser                  CheckNameResourceTypes = original.CheckNameResourceTypesPublishingUser
	CheckNameResourceTypesSite                            CheckNameResourceTypes = original.CheckNameResourceTypesSite
	CheckNameResourceTypesSlot                            CheckNameResourceTypes = original.CheckNameResourceTypesSlot
)

type CloneAbilityResult = original.CloneAbilityResult

const (
	Cloneable          CloneAbilityResult = original.Cloneable
	NotCloneable       CloneAbilityResult = original.NotCloneable
	PartiallyCloneable CloneAbilityResult = original.PartiallyCloneable
)

type ComputeModeOptions = original.ComputeModeOptions

const (
	ComputeModeOptionsDedicated ComputeModeOptions = original.ComputeModeOptionsDedicated
	ComputeModeOptionsDynamic   ComputeModeOptions = original.ComputeModeOptionsDynamic
	ComputeModeOptionsShared    ComputeModeOptions = original.ComputeModeOptionsShared
)

type ConnectionStringType = original.ConnectionStringType

const (
	APIHub          ConnectionStringType = original.APIHub
	Custom          ConnectionStringType = original.Custom
	DocDb           ConnectionStringType = original.DocDb
	EventHub        ConnectionStringType = original.EventHub
	MySQL           ConnectionStringType = original.MySQL
	NotificationHub ConnectionStringType = original.NotificationHub
	PostgreSQL      ConnectionStringType = original.PostgreSQL
	RedisCache      ConnectionStringType = original.RedisCache
	ServiceBus      ConnectionStringType = original.ServiceBus
	SQLAzure        ConnectionStringType = original.SQLAzure
	SQLServer       ConnectionStringType = original.SQLServer
)

type ContinuousWebJobStatus = original.ContinuousWebJobStatus

const (
	Initializing   ContinuousWebJobStatus = original.Initializing
	PendingRestart ContinuousWebJobStatus = original.PendingRestart
	Running        ContinuousWebJobStatus = original.Running
	Starting       ContinuousWebJobStatus = original.Starting
	Stopped        ContinuousWebJobStatus = original.Stopped
)

type CustomHostNameDNSRecordType = original.CustomHostNameDNSRecordType

const (
	A     CustomHostNameDNSRecordType = original.A
	CName CustomHostNameDNSRecordType = original.CName
)

type DatabaseType = original.DatabaseType

const (
	DatabaseTypeLocalMySQL DatabaseType = original.DatabaseTypeLocalMySQL
	DatabaseTypeMySQL      DatabaseType = original.DatabaseTypeMySQL
	DatabaseTypePostgreSQL DatabaseType = original.DatabaseTypePostgreSQL
	DatabaseTypeSQLAzure   DatabaseType = original.DatabaseTypeSQLAzure
)

type DNSType = original.DNSType

const (
	AzureDNS                  DNSType = original.AzureDNS
	DefaultDomainRegistrarDNS DNSType = original.DefaultDomainRegistrarDNS
)

type DNSVerificationTestResult = original.DNSVerificationTestResult

const (
	DNSVerificationTestResultFailed  DNSVerificationTestResult = original.DNSVerificationTestResultFailed
	DNSVerificationTestResultPassed  DNSVerificationTestResult = original.DNSVerificationTestResultPassed
	DNSVerificationTestResultSkipped DNSVerificationTestResult = original.DNSVerificationTestResultSkipped
)

type DomainStatus = original.DomainStatus

const (
	DomainStatusActive              DomainStatus = original.DomainStatusActive
	DomainStatusAwaiting            DomainStatus = original.DomainStatusAwaiting
	DomainStatusCancelled           DomainStatus = original.DomainStatusCancelled
	DomainStatusConfiscated         DomainStatus = original.DomainStatusConfiscated
	DomainStatusDisabled            DomainStatus = original.DomainStatusDisabled
	DomainStatusExcluded            DomainStatus = original.DomainStatusExcluded
	DomainStatusExpired             DomainStatus = original.DomainStatusExpired
	DomainStatusFailed              DomainStatus = original.DomainStatusFailed
	DomainStatusHeld                DomainStatus = original.DomainStatusHeld
	DomainStatusJSONConverterFailed DomainStatus = original.DomainStatusJSONConverterFailed
	DomainStatusLocked              DomainStatus = original.DomainStatusLocked
	DomainStatusParked              DomainStatus = original.DomainStatusParked
	DomainStatusPending             DomainStatus = original.DomainStatusPending
	DomainStatusReserved            DomainStatus = original.DomainStatusReserved
	DomainStatusReverted            DomainStatus = original.DomainStatusReverted
	DomainStatusSuspended           DomainStatus = original.DomainStatusSuspended
	DomainStatusTransferred         DomainStatus = original.DomainStatusTransferred
	DomainStatusUnknown             DomainStatus = original.DomainStatusUnknown
	DomainStatusUnlocked            DomainStatus = original.DomainStatusUnlocked
	DomainStatusUnparked            DomainStatus = original.DomainStatusUnparked
	DomainStatusUpdated             DomainStatus = original.DomainStatusUpdated
)

type DomainType = original.DomainType

const (
	Regular     DomainType = original.Regular
	SoftDeleted DomainType = original.SoftDeleted
)

type FrequencyUnit = original.FrequencyUnit

const (
	Day  FrequencyUnit = original.Day
	Hour FrequencyUnit = original.Hour
)

type HostingEnvironmentStatus = original.HostingEnvironmentStatus

const (
	Deleting  HostingEnvironmentStatus = original.Deleting
	Preparing HostingEnvironmentStatus = original.Preparing
	Ready     HostingEnvironmentStatus = original.Ready
	Scaling   HostingEnvironmentStatus = original.Scaling
)

type HostNameType = original.HostNameType

const (
	Managed  HostNameType = original.Managed
	Verified HostNameType = original.Verified
)

type HostType = original.HostType

const (
	HostTypeRepository HostType = original.HostTypeRepository
	HostTypeStandard   HostType = original.HostTypeStandard
)

type InAvailabilityReasonType = original.InAvailabilityReasonType

const (
	AlreadyExists InAvailabilityReasonType = original.AlreadyExists
	Invalid       InAvailabilityReasonType = original.Invalid
)

type InternalLoadBalancingMode = original.InternalLoadBalancingMode

const (
	InternalLoadBalancingModeNone       InternalLoadBalancingMode = original.InternalLoadBalancingModeNone
	InternalLoadBalancingModePublishing InternalLoadBalancingMode = original.InternalLoadBalancingModePublishing
	InternalLoadBalancingModeWeb        InternalLoadBalancingMode = original.InternalLoadBalancingModeWeb
)

type IssueType = original.IssueType

const (
	AppCrash             IssueType = original.AppCrash
	AppDeployment        IssueType = original.AppDeployment
	AseDeployment        IssueType = original.AseDeployment
	Other                IssueType = original.Other
	PlatformIssue        IssueType = original.PlatformIssue
	RuntimeIssueDetected IssueType = original.RuntimeIssueDetected
	ServiceIncident      IssueType = original.ServiceIncident
	UserIssue            IssueType = original.UserIssue
)

type JobType = original.JobType

const (
	Continuous JobType = original.Continuous
	Triggered  JobType = original.Triggered
)

type KeyVaultSecretStatus = original.KeyVaultSecretStatus

const (
	KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault KeyVaultSecretStatus = original.KeyVaultSecretStatusAzureServiceUnauthorizedToAccessKeyVault
	KeyVaultSecretStatusCertificateOrderFailed                   KeyVaultSecretStatus = original.KeyVaultSecretStatusCertificateOrderFailed
	KeyVaultSecretStatusExternalPrivateKey                       KeyVaultSecretStatus = original.KeyVaultSecretStatusExternalPrivateKey
	KeyVaultSecretStatusInitialized                              KeyVaultSecretStatus = original.KeyVaultSecretStatusInitialized
	KeyVaultSecretStatusKeyVaultDoesNotExist                     KeyVaultSecretStatus = original.KeyVaultSecretStatusKeyVaultDoesNotExist
	KeyVaultSecretStatusKeyVaultSecretDoesNotExist               KeyVaultSecretStatus = original.KeyVaultSecretStatusKeyVaultSecretDoesNotExist
	KeyVaultSecretStatusOperationNotPermittedOnKeyVault          KeyVaultSecretStatus = original.KeyVaultSecretStatusOperationNotPermittedOnKeyVault
	KeyVaultSecretStatusSucceeded                                KeyVaultSecretStatus = original.KeyVaultSecretStatusSucceeded
	KeyVaultSecretStatusUnknown                                  KeyVaultSecretStatus = original.KeyVaultSecretStatusUnknown
	KeyVaultSecretStatusUnknownError                             KeyVaultSecretStatus = original.KeyVaultSecretStatusUnknownError
	KeyVaultSecretStatusWaitingOnCertificateOrder                KeyVaultSecretStatus = original.KeyVaultSecretStatusWaitingOnCertificateOrder
)

type LogLevel = original.LogLevel

const (
	Error       LogLevel = original.Error
	Information LogLevel = original.Information
	Off         LogLevel = original.Off
	Verbose     LogLevel = original.Verbose
	Warning     LogLevel = original.Warning
)

type ManagedPipelineMode = original.ManagedPipelineMode

const (
	Classic    ManagedPipelineMode = original.Classic
	Integrated ManagedPipelineMode = original.Integrated
)

type MSDeployLogEntryType = original.MSDeployLogEntryType

const (
	MSDeployLogEntryTypeError   MSDeployLogEntryType = original.MSDeployLogEntryTypeError
	MSDeployLogEntryTypeMessage MSDeployLogEntryType = original.MSDeployLogEntryTypeMessage
	MSDeployLogEntryTypeWarning MSDeployLogEntryType = original.MSDeployLogEntryTypeWarning
)

type MSDeployProvisioningState = original.MSDeployProvisioningState

const (
	MSDeployProvisioningStateAccepted  MSDeployProvisioningState = original.MSDeployProvisioningStateAccepted
	MSDeployProvisioningStateCanceled  MSDeployProvisioningState = original.MSDeployProvisioningStateCanceled
	MSDeployProvisioningStateFailed    MSDeployProvisioningState = original.MSDeployProvisioningStateFailed
	MSDeployProvisioningStateRunning   MSDeployProvisioningState = original.MSDeployProvisioningStateRunning
	MSDeployProvisioningStateSucceeded MSDeployProvisioningState = original.MSDeployProvisioningStateSucceeded
)

type MySQLMigrationType = original.MySQLMigrationType

const (
	LocalToRemote MySQLMigrationType = original.LocalToRemote
	RemoteToLocal MySQLMigrationType = original.RemoteToLocal
)

type NotificationLevel = original.NotificationLevel

const (
	NotificationLevelCritical            NotificationLevel = original.NotificationLevelCritical
	NotificationLevelInformation         NotificationLevel = original.NotificationLevelInformation
	NotificationLevelNonUrgentSuggestion NotificationLevel = original.NotificationLevelNonUrgentSuggestion
	NotificationLevelWarning             NotificationLevel = original.NotificationLevelWarning
)

type OperationStatus = original.OperationStatus

const (
	OperationStatusCreated    OperationStatus = original.OperationStatusCreated
	OperationStatusFailed     OperationStatus = original.OperationStatusFailed
	OperationStatusInProgress OperationStatus = original.OperationStatusInProgress
	OperationStatusSucceeded  OperationStatus = original.OperationStatusSucceeded
	OperationStatusTimedOut   OperationStatus = original.OperationStatusTimedOut
)

type ProvisioningState = original.ProvisioningState

const (
	ProvisioningStateCanceled   ProvisioningState = original.ProvisioningStateCanceled
	ProvisioningStateDeleting   ProvisioningState = original.ProvisioningStateDeleting
	ProvisioningStateFailed     ProvisioningState = original.ProvisioningStateFailed
	ProvisioningStateInProgress ProvisioningState = original.ProvisioningStateInProgress
	ProvisioningStateSucceeded  ProvisioningState = original.ProvisioningStateSucceeded
)

type PublicCertificateLocation = original.PublicCertificateLocation

const (
	PublicCertificateLocationCurrentUserMy  PublicCertificateLocation = original.PublicCertificateLocationCurrentUserMy
	PublicCertificateLocationLocalMachineMy PublicCertificateLocation = original.PublicCertificateLocationLocalMachineMy
	PublicCertificateLocationUnknown        PublicCertificateLocation = original.PublicCertificateLocationUnknown
)

type PublishingProfileFormat = original.PublishingProfileFormat

const (
	FileZilla3 PublishingProfileFormat = original.FileZilla3
	Ftp        PublishingProfileFormat = original.Ftp
	WebDeploy  PublishingProfileFormat = original.WebDeploy
)

type ResourceScopeType = original.ResourceScopeType

const (
	ServerFarm   ResourceScopeType = original.ServerFarm
	Subscription ResourceScopeType = original.Subscription
	WebSite      ResourceScopeType = original.WebSite
)

type RouteType = original.RouteType

const (
	DEFAULT   RouteType = original.DEFAULT
	INHERITED RouteType = original.INHERITED
	STATIC    RouteType = original.STATIC
)

type ScmType = original.ScmType

const (
	ScmTypeBitbucketGit ScmType = original.ScmTypeBitbucketGit
	ScmTypeBitbucketHg  ScmType = original.ScmTypeBitbucketHg
	ScmTypeCodePlexGit  ScmType = original.ScmTypeCodePlexGit
	ScmTypeCodePlexHg   ScmType = original.ScmTypeCodePlexHg
	ScmTypeDropbox      ScmType = original.ScmTypeDropbox
	ScmTypeExternalGit  ScmType = original.ScmTypeExternalGit
	ScmTypeExternalHg   ScmType = original.ScmTypeExternalHg
	ScmTypeGitHub       ScmType = original.ScmTypeGitHub
	ScmTypeLocalGit     ScmType = original.ScmTypeLocalGit
	ScmTypeNone         ScmType = original.ScmTypeNone
	ScmTypeOneDrive     ScmType = original.ScmTypeOneDrive
	ScmTypeTfs          ScmType = original.ScmTypeTfs
	ScmTypeVSO          ScmType = original.ScmTypeVSO
)

type SiteAvailabilityState = original.SiteAvailabilityState

const (
	DisasterRecoveryMode SiteAvailabilityState = original.DisasterRecoveryMode
	Limited              SiteAvailabilityState = original.Limited
	Normal               SiteAvailabilityState = original.Normal
)

type SiteExtensionType = original.SiteExtensionType

const (
	Gallery SiteExtensionType = original.Gallery
	WebRoot SiteExtensionType = original.WebRoot
)

type SiteLoadBalancing = original.SiteLoadBalancing

const (
	LeastRequests        SiteLoadBalancing = original.LeastRequests
	LeastResponseTime    SiteLoadBalancing = original.LeastResponseTime
	RequestHash          SiteLoadBalancing = original.RequestHash
	WeightedRoundRobin   SiteLoadBalancing = original.WeightedRoundRobin
	WeightedTotalTraffic SiteLoadBalancing = original.WeightedTotalTraffic
)

type SkuName = original.SkuName

const (
	SkuNameBasic     SkuName = original.SkuNameBasic
	SkuNameDynamic   SkuName = original.SkuNameDynamic
	SkuNameFree      SkuName = original.SkuNameFree
	SkuNameIsolated  SkuName = original.SkuNameIsolated
	SkuNamePremium   SkuName = original.SkuNamePremium
	SkuNamePremiumV2 SkuName = original.SkuNamePremiumV2
	SkuNameShared    SkuName = original.SkuNameShared
	SkuNameStandard  SkuName = original.SkuNameStandard
)

type SolutionType = original.SolutionType

const (
	BestPractices     SolutionType = original.BestPractices
	DeepInvestigation SolutionType = original.DeepInvestigation
	QuickSolution     SolutionType = original.QuickSolution
)

type SslState = original.SslState

const (
	Disabled       SslState = original.Disabled
	IPBasedEnabled SslState = original.IPBasedEnabled
	SniEnabled     SslState = original.SniEnabled
)

type StatusOptions = original.StatusOptions

const (
	StatusOptionsCreating StatusOptions = original.StatusOptionsCreating
	StatusOptionsPending  StatusOptions = original.StatusOptionsPending
	StatusOptionsReady    StatusOptions = original.StatusOptionsReady
)

type SupportedTLSVersions = original.SupportedTLSVersions

const (
	OneFullStopOne  SupportedTLSVersions = original.OneFullStopOne
	OneFullStopTwo  SupportedTLSVersions = original.OneFullStopTwo
	OneFullStopZero SupportedTLSVersions = original.OneFullStopZero
)

type TriggeredWebJobStatus = original.TriggeredWebJobStatus

const (
	TriggeredWebJobStatusError   TriggeredWebJobStatus = original.TriggeredWebJobStatusError
	TriggeredWebJobStatusFailed  TriggeredWebJobStatus = original.TriggeredWebJobStatusFailed
	TriggeredWebJobStatusSuccess TriggeredWebJobStatus = original.TriggeredWebJobStatusSuccess
)

type UnauthenticatedClientAction = original.UnauthenticatedClientAction

const (
	AllowAnonymous      UnauthenticatedClientAction = original.AllowAnonymous
	RedirectToLoginPage UnauthenticatedClientAction = original.RedirectToLoginPage
)

type UsageState = original.UsageState

const (
	UsageStateExceeded UsageState = original.UsageStateExceeded
	UsageStateNormal   UsageState = original.UsageStateNormal
)

type ValidateResourceTypes = original.ValidateResourceTypes

const (
	ValidateResourceTypesServerFarm ValidateResourceTypes = original.ValidateResourceTypesServerFarm
	ValidateResourceTypesSite       ValidateResourceTypes = original.ValidateResourceTypesSite
)

type WorkerSizeOptions = original.WorkerSizeOptions

const (
	D1      WorkerSizeOptions = original.D1
	D2      WorkerSizeOptions = original.D2
	D3      WorkerSizeOptions = original.D3
	Default WorkerSizeOptions = original.Default
	Large   WorkerSizeOptions = original.Large
	Medium  WorkerSizeOptions = original.Medium
	Small   WorkerSizeOptions = original.Small
)

type AbnormalTimePeriod = original.AbnormalTimePeriod
type Address = original.Address
type AddressResponse = original.AddressResponse
type AnalysisData = original.AnalysisData
type AnalysisDefinition = original.AnalysisDefinition
type AnalysisDefinitionProperties = original.AnalysisDefinitionProperties
type APIDefinitionInfo = original.APIDefinitionInfo
type AppCollection = original.AppCollection
type AppCollectionIterator = original.AppCollectionIterator
type AppCollectionPage = original.AppCollectionPage
type AppInstanceCollection = original.AppInstanceCollection
type AppInstanceCollectionIterator = original.AppInstanceCollectionIterator
type AppInstanceCollectionPage = original.AppInstanceCollectionPage
type ApplicationLogsConfig = original.ApplicationLogsConfig
type AppsCreateFunctionFuture = original.AppsCreateFunctionFuture
type AppsCreateInstanceFunctionSlotFuture = original.AppsCreateInstanceFunctionSlotFuture
type AppsCreateInstanceMSDeployOperationFuture = original.AppsCreateInstanceMSDeployOperationFuture
type AppsCreateInstanceMSDeployOperationSlotFuture = original.AppsCreateInstanceMSDeployOperationSlotFuture
type AppsCreateMSDeployOperationFuture = original.AppsCreateMSDeployOperationFuture
type AppsCreateMSDeployOperationSlotFuture = original.AppsCreateMSDeployOperationSlotFuture
type AppsCreateOrUpdateFuture = original.AppsCreateOrUpdateFuture
type AppsCreateOrUpdateSlotFuture = original.AppsCreateOrUpdateSlotFuture
type AppsCreateOrUpdateSourceControlFuture = original.AppsCreateOrUpdateSourceControlFuture
type AppsCreateOrUpdateSourceControlSlotFuture = original.AppsCreateOrUpdateSourceControlSlotFuture
type AppServiceCertificate = original.AppServiceCertificate
type AppServiceCertificateCollection = original.AppServiceCertificateCollection
type AppServiceCertificateCollectionIterator = original.AppServiceCertificateCollectionIterator
type AppServiceCertificateCollectionPage = original.AppServiceCertificateCollectionPage
type AppServiceCertificateOrder = original.AppServiceCertificateOrder
type AppServiceCertificateOrderCollection = original.AppServiceCertificateOrderCollection
type AppServiceCertificateOrderCollectionIterator = original.AppServiceCertificateOrderCollectionIterator
type AppServiceCertificateOrderCollectionPage = original.AppServiceCertificateOrderCollectionPage
type AppServiceCertificateOrderPatchResource = original.AppServiceCertificateOrderPatchResource
type AppServiceCertificateOrderPatchResourceProperties = original.AppServiceCertificateOrderPatchResourceProperties
type AppServiceCertificateOrderProperties = original.AppServiceCertificateOrderProperties
type AppServiceCertificateOrdersCreateOrUpdateCertificateFuture = original.AppServiceCertificateOrdersCreateOrUpdateCertificateFuture
type AppServiceCertificateOrdersCreateOrUpdateFuture = original.AppServiceCertificateOrdersCreateOrUpdateFuture
type AppServiceCertificatePatchResource = original.AppServiceCertificatePatchResource
type AppServiceCertificateResource = original.AppServiceCertificateResource
type AppServiceEnvironment = original.AppServiceEnvironment
type AppServiceEnvironmentCollection = original.AppServiceEnvironmentCollection
type AppServiceEnvironmentCollectionIterator = original.AppServiceEnvironmentCollectionIterator
type AppServiceEnvironmentCollectionPage = original.AppServiceEnvironmentCollectionPage
type AppServiceEnvironmentPatchResource = original.AppServiceEnvironmentPatchResource
type AppServiceEnvironmentResource = original.AppServiceEnvironmentResource
type AppServiceEnvironmentsCreateOrUpdateFuture = original.AppServiceEnvironmentsCreateOrUpdateFuture
type AppServiceEnvironmentsCreateOrUpdateMultiRolePoolFuture = original.AppServiceEnvironmentsCreateOrUpdateMultiRolePoolFuture
type AppServiceEnvironmentsCreateOrUpdateWorkerPoolFuture = original.AppServiceEnvironmentsCreateOrUpdateWorkerPoolFuture
type AppServiceEnvironmentsDeleteFuture = original.AppServiceEnvironmentsDeleteFuture
type AppServiceEnvironmentsResumeAllFuture = original.AppServiceEnvironmentsResumeAllFuture
type AppServiceEnvironmentsResumeFuture = original.AppServiceEnvironmentsResumeFuture
type AppServiceEnvironmentsSuspendAllFuture = original.AppServiceEnvironmentsSuspendAllFuture
type AppServiceEnvironmentsSuspendFuture = original.AppServiceEnvironmentsSuspendFuture
type AppServicePlan = original.AppServicePlan
type AppServicePlanCollection = original.AppServicePlanCollection
type AppServicePlanCollectionIterator = original.AppServicePlanCollectionIterator
type AppServicePlanCollectionPage = original.AppServicePlanCollectionPage
type AppServicePlanPatchResource = original.AppServicePlanPatchResource
type AppServicePlanPatchResourceProperties = original.AppServicePlanPatchResourceProperties
type AppServicePlanProperties = original.AppServicePlanProperties
type AppServicePlansCreateOrUpdateFuture = original.AppServicePlansCreateOrUpdateFuture
type AppsInstallSiteExtensionFuture = original.AppsInstallSiteExtensionFuture
type AppsInstallSiteExtensionSlotFuture = original.AppsInstallSiteExtensionSlotFuture
type AppsListPublishingCredentialsFuture = original.AppsListPublishingCredentialsFuture
type AppsListPublishingCredentialsSlotFuture = original.AppsListPublishingCredentialsSlotFuture
type AppsMigrateMySQLFuture = original.AppsMigrateMySQLFuture
type AppsMigrateStorageFuture = original.AppsMigrateStorageFuture
type AppsRecoverFuture = original.AppsRecoverFuture
type AppsRecoverSlotFuture = original.AppsRecoverSlotFuture
type AppsRestoreFuture = original.AppsRestoreFuture
type AppsRestoreSlotFuture = original.AppsRestoreSlotFuture
type AppsSwapSlotSlotFuture = original.AppsSwapSlotSlotFuture
type AppsSwapSlotWithProductionFuture = original.AppsSwapSlotWithProductionFuture
type AutoHealActions = original.AutoHealActions
type AutoHealCustomAction = original.AutoHealCustomAction
type AutoHealRules = original.AutoHealRules
type AutoHealTriggers = original.AutoHealTriggers
type AzureBlobStorageApplicationLogsConfig = original.AzureBlobStorageApplicationLogsConfig
type AzureBlobStorageHTTPLogsConfig = original.AzureBlobStorageHTTPLogsConfig
type AzureTableStorageApplicationLogsConfig = original.AzureTableStorageApplicationLogsConfig
type BackupItem = original.BackupItem
type BackupItemCollection = original.BackupItemCollection
type BackupItemCollectionIterator = original.BackupItemCollectionIterator
type BackupItemCollectionPage = original.BackupItemCollectionPage
type BackupItemProperties = original.BackupItemProperties
type BackupRequest = original.BackupRequest
type BackupRequestProperties = original.BackupRequestProperties
type BackupSchedule = original.BackupSchedule
type Capability = original.Capability
type Certificate = original.Certificate
type CertificateCollection = original.CertificateCollection
type CertificateCollectionIterator = original.CertificateCollectionIterator
type CertificateCollectionPage = original.CertificateCollectionPage
type CertificateDetails = original.CertificateDetails
type CertificateEmail = original.CertificateEmail
type CertificateEmailProperties = original.CertificateEmailProperties
type CertificateOrderAction = original.CertificateOrderAction
type CertificateOrderActionProperties = original.CertificateOrderActionProperties
type CertificatePatchResource = original.CertificatePatchResource
type CertificatePatchResourceProperties = original.CertificatePatchResourceProperties
type CertificateProperties = original.CertificateProperties
type CloningInfo = original.CloningInfo
type ConnectionStringDictionary = original.ConnectionStringDictionary
type ConnStringInfo = original.ConnStringInfo
type ConnStringValueTypePair = original.ConnStringValueTypePair
type Contact = original.Contact
type ContinuousWebJob = original.ContinuousWebJob
type ContinuousWebJobCollection = original.ContinuousWebJobCollection
type ContinuousWebJobCollectionIterator = original.ContinuousWebJobCollectionIterator
type ContinuousWebJobCollectionPage = original.ContinuousWebJobCollectionPage
type ContinuousWebJobProperties = original.ContinuousWebJobProperties
type CorsSettings = original.CorsSettings
type CsmMoveResourceEnvelope = original.CsmMoveResourceEnvelope
type CsmOperationCollection = original.CsmOperationCollection
type CsmOperationCollectionIterator = original.CsmOperationCollectionIterator
type CsmOperationCollectionPage = original.CsmOperationCollectionPage
type CsmOperationDescription = original.CsmOperationDescription
type CsmOperationDescriptionProperties = original.CsmOperationDescriptionProperties
type CsmOperationDisplay = original.CsmOperationDisplay
type CsmPublishingProfileOptions = original.CsmPublishingProfileOptions
type CsmSlotEntity = original.CsmSlotEntity
type CsmUsageQuota = original.CsmUsageQuota
type CsmUsageQuotaCollection = original.CsmUsageQuotaCollection
type CsmUsageQuotaCollectionIterator = original.CsmUsageQuotaCollectionIterator
type CsmUsageQuotaCollectionPage = original.CsmUsageQuotaCollectionPage
type CustomHostnameAnalysisResult = original.CustomHostnameAnalysisResult
type CustomHostnameAnalysisResultProperties = original.CustomHostnameAnalysisResultProperties
type DatabaseBackupSetting = original.DatabaseBackupSetting
type DataSource = original.DataSource
type DeletedSite = original.DeletedSite
type DeletedWebAppCollection = original.DeletedWebAppCollection
type DeletedWebAppCollectionIterator = original.DeletedWebAppCollectionIterator
type DeletedWebAppCollectionPage = original.DeletedWebAppCollectionPage
type Deployment = original.Deployment
type DeploymentCollection = original.DeploymentCollection
type DeploymentCollectionIterator = original.DeploymentCollectionIterator
type DeploymentCollectionPage = original.DeploymentCollectionPage
type DeploymentLocations = original.DeploymentLocations
type DeploymentProperties = original.DeploymentProperties
type DetectorAbnormalTimePeriod = original.DetectorAbnormalTimePeriod
type DetectorDefinition = original.DetectorDefinition
type DetectorDefinitionProperties = original.DetectorDefinitionProperties
type DiagnosticAnalysis = original.DiagnosticAnalysis
type DiagnosticAnalysisCollection = original.DiagnosticAnalysisCollection
type DiagnosticAnalysisCollectionIterator = original.DiagnosticAnalysisCollectionIterator
type DiagnosticAnalysisCollectionPage = original.DiagnosticAnalysisCollectionPage
type DiagnosticAnalysisProperties = original.DiagnosticAnalysisProperties
type DiagnosticCategory = original.DiagnosticCategory
type DiagnosticCategoryCollection = original.DiagnosticCategoryCollection
type DiagnosticCategoryCollectionIterator = original.DiagnosticCategoryCollectionIterator
type DiagnosticCategoryCollectionPage = original.DiagnosticCategoryCollectionPage
type DiagnosticCategoryProperties = original.DiagnosticCategoryProperties
type DiagnosticDetectorCollection = original.DiagnosticDetectorCollection
type DiagnosticDetectorCollectionIterator = original.DiagnosticDetectorCollectionIterator
type DiagnosticDetectorCollectionPage = original.DiagnosticDetectorCollectionPage
type DiagnosticDetectorResponse = original.DiagnosticDetectorResponse
type DiagnosticDetectorResponseProperties = original.DiagnosticDetectorResponseProperties
type DiagnosticMetricSample = original.DiagnosticMetricSample
type DiagnosticMetricSet = original.DiagnosticMetricSet
type Dimension = original.Dimension
type Domain = original.Domain
type DomainAvailablilityCheckResult = original.DomainAvailablilityCheckResult
type DomainCollection = original.DomainCollection
type DomainCollectionIterator = original.DomainCollectionIterator
type DomainCollectionPage = original.DomainCollectionPage
type DomainControlCenterSsoRequest = original.DomainControlCenterSsoRequest
type DomainOwnershipIdentifier = original.DomainOwnershipIdentifier
type DomainOwnershipIdentifierCollection = original.DomainOwnershipIdentifierCollection
type DomainOwnershipIdentifierCollectionIterator = original.DomainOwnershipIdentifierCollectionIterator
type DomainOwnershipIdentifierCollectionPage = original.DomainOwnershipIdentifierCollectionPage
type DomainOwnershipIdentifierProperties = original.DomainOwnershipIdentifierProperties
type DomainPatchResource = original.DomainPatchResource
type DomainPatchResourceProperties = original.DomainPatchResourceProperties
type DomainProperties = original.DomainProperties
type DomainPurchaseConsent = original.DomainPurchaseConsent
type DomainRecommendationSearchParameters = original.DomainRecommendationSearchParameters
type DomainsCreateOrUpdateFuture = original.DomainsCreateOrUpdateFuture
type EnabledConfig = original.EnabledConfig
type ErrorEntity = original.ErrorEntity
type ErrorResponse = original.ErrorResponse
type Experiments = original.Experiments
type FileSystemApplicationLogsConfig = original.FileSystemApplicationLogsConfig
type FileSystemHTTPLogsConfig = original.FileSystemHTTPLogsConfig
type FunctionEnvelope = original.FunctionEnvelope
type FunctionEnvelopeCollection = original.FunctionEnvelopeCollection
type FunctionEnvelopeCollectionIterator = original.FunctionEnvelopeCollectionIterator
type FunctionEnvelopeCollectionPage = original.FunctionEnvelopeCollectionPage
type FunctionEnvelopeProperties = original.FunctionEnvelopeProperties
type FunctionSecrets = original.FunctionSecrets
type FunctionSecretsProperties = original.FunctionSecretsProperties
type GeoRegion = original.GeoRegion
type GeoRegionCollection = original.GeoRegionCollection
type GeoRegionCollectionIterator = original.GeoRegionCollectionIterator
type GeoRegionCollectionPage = original.GeoRegionCollectionPage
type GeoRegionProperties = original.GeoRegionProperties
type GlobalCsmSkuDescription = original.GlobalCsmSkuDescription
type HandlerMapping = original.HandlerMapping
type HostingEnvironmentDeploymentInfo = original.HostingEnvironmentDeploymentInfo
type HostingEnvironmentDiagnostics = original.HostingEnvironmentDiagnostics
type HostingEnvironmentProfile = original.HostingEnvironmentProfile
type HostName = original.HostName
type HostNameBinding = original.HostNameBinding
type HostNameBindingCollection = original.HostNameBindingCollection
type HostNameBindingCollectionIterator = original.HostNameBindingCollectionIterator
type HostNameBindingCollectionPage = original.HostNameBindingCollectionPage
type HostNameBindingProperties = original.HostNameBindingProperties
type HostNameSslState = original.HostNameSslState
type HTTPLogsConfig = original.HTTPLogsConfig
type HybridConnection = original.HybridConnection
type HybridConnectionCollection = original.HybridConnectionCollection
type HybridConnectionCollectionIterator = original.HybridConnectionCollectionIterator
type HybridConnectionCollectionPage = original.HybridConnectionCollectionPage
type HybridConnectionKey = original.HybridConnectionKey
type HybridConnectionKeyProperties = original.HybridConnectionKeyProperties
type HybridConnectionLimits = original.HybridConnectionLimits
type HybridConnectionLimitsProperties = original.HybridConnectionLimitsProperties
type HybridConnectionProperties = original.HybridConnectionProperties
type Identifier = original.Identifier
type IdentifierCollection = original.IdentifierCollection
type IdentifierCollectionIterator = original.IdentifierCollectionIterator
type IdentifierCollectionPage = original.IdentifierCollectionPage
type IdentifierProperties = original.IdentifierProperties
type IPSecurityRestriction = original.IPSecurityRestriction
type Job = original.Job
type JobCollection = original.JobCollection
type JobCollectionIterator = original.JobCollectionIterator
type JobCollectionPage = original.JobCollectionPage
type JobProperties = original.JobProperties
type ListCapability = original.ListCapability
type ListCertificateEmail = original.ListCertificateEmail
type ListCertificateOrderAction = original.ListCertificateOrderAction
type ListHostingEnvironmentDiagnostics = original.ListHostingEnvironmentDiagnostics
type ListOperation = original.ListOperation
type ListRecommendation = original.ListRecommendation
type ListVnetInfo = original.ListVnetInfo
type ListVnetRoute = original.ListVnetRoute
type LocalizableString = original.LocalizableString
type ManagedServiceIdentity = original.ManagedServiceIdentity
type MetricAvailabilily = original.MetricAvailabilily
type MetricAvailability = original.MetricAvailability
type MetricDefinition = original.MetricDefinition
type MetricDefinitionProperties = original.MetricDefinitionProperties
type MetricSpecification = original.MetricSpecification
type MigrateMySQLRequest = original.MigrateMySQLRequest
type MigrateMySQLRequestProperties = original.MigrateMySQLRequestProperties
type MigrateMySQLStatus = original.MigrateMySQLStatus
type MigrateMySQLStatusProperties = original.MigrateMySQLStatusProperties
type MSDeploy = original.MSDeploy
type MSDeployCore = original.MSDeployCore
type MSDeployLog = original.MSDeployLog
type MSDeployLogEntry = original.MSDeployLogEntry
type MSDeployLogProperties = original.MSDeployLogProperties
type MSDeployStatus = original.MSDeployStatus
type MSDeployStatusProperties = original.MSDeployStatusProperties
type NameIdentifier = original.NameIdentifier
type NameIdentifierCollection = original.NameIdentifierCollection
type NameIdentifierCollectionIterator = original.NameIdentifierCollectionIterator
type NameIdentifierCollectionPage = original.NameIdentifierCollectionPage
type NameValuePair = original.NameValuePair
type NetworkAccessControlEntry = original.NetworkAccessControlEntry
type NetworkFeatures = original.NetworkFeatures
type NetworkFeaturesProperties = original.NetworkFeaturesProperties
type Operation = original.Operation
type PerfMonCounterCollection = original.PerfMonCounterCollection
type PerfMonCounterCollectionIterator = original.PerfMonCounterCollectionIterator
type PerfMonCounterCollectionPage = original.PerfMonCounterCollectionPage
type PerfMonResponse = original.PerfMonResponse
type PerfMonSample = original.PerfMonSample
type PerfMonSet = original.PerfMonSet
type PremierAddOn = original.PremierAddOn
type PremierAddOnOffer = original.PremierAddOnOffer
type PremierAddOnOfferCollection = original.PremierAddOnOfferCollection
type PremierAddOnOfferCollectionIterator = original.PremierAddOnOfferCollectionIterator
type PremierAddOnOfferCollectionPage = original.PremierAddOnOfferCollectionPage
type PremierAddOnOfferProperties = original.PremierAddOnOfferProperties
type PremierAddOnProperties = original.PremierAddOnProperties
type ProcessInfo = original.ProcessInfo
type ProcessInfoCollection = original.ProcessInfoCollection
type ProcessInfoCollectionIterator = original.ProcessInfoCollectionIterator
type ProcessInfoCollectionPage = original.ProcessInfoCollectionPage
type ProcessInfoProperties = original.ProcessInfoProperties
type ProcessModuleInfo = original.ProcessModuleInfo
type ProcessModuleInfoCollection = original.ProcessModuleInfoCollection
type ProcessModuleInfoCollectionIterator = original.ProcessModuleInfoCollectionIterator
type ProcessModuleInfoCollectionPage = original.ProcessModuleInfoCollectionPage
type ProcessModuleInfoProperties = original.ProcessModuleInfoProperties
type ProcessThreadInfo = original.ProcessThreadInfo
type ProcessThreadInfoCollection = original.ProcessThreadInfoCollection
type ProcessThreadInfoCollectionIterator = original.ProcessThreadInfoCollectionIterator
type ProcessThreadInfoCollectionPage = original.ProcessThreadInfoCollectionPage
type ProcessThreadInfoProperties = original.ProcessThreadInfoProperties
type ProxyOnlyResource = original.ProxyOnlyResource
type PublicCertificate = original.PublicCertificate
type PublicCertificateCollection = original.PublicCertificateCollection
type PublicCertificateCollectionIterator = original.PublicCertificateCollectionIterator
type PublicCertificateCollectionPage = original.PublicCertificateCollectionPage
type PublicCertificateProperties = original.PublicCertificateProperties
type PushSettings = original.PushSettings
type PushSettingsProperties = original.PushSettingsProperties
type RampUpRule = original.RampUpRule
type ReadCloser = original.ReadCloser
type Recommendation = original.Recommendation
type RecommendationRule = original.RecommendationRule
type ReissueCertificateOrderRequest = original.ReissueCertificateOrderRequest
type ReissueCertificateOrderRequestProperties = original.ReissueCertificateOrderRequestProperties
type RelayServiceConnectionEntity = original.RelayServiceConnectionEntity
type RelayServiceConnectionEntityProperties = original.RelayServiceConnectionEntityProperties
type RenewCertificateOrderRequest = original.RenewCertificateOrderRequest
type RenewCertificateOrderRequestProperties = original.RenewCertificateOrderRequestProperties
type RequestsBasedTrigger = original.RequestsBasedTrigger
type Resource = original.Resource
type ResourceCollection = original.ResourceCollection
type ResourceCollectionIterator = original.ResourceCollectionIterator
type ResourceCollectionPage = original.ResourceCollectionPage
type ResourceMetric = original.ResourceMetric
type ResourceMetricAvailability = original.ResourceMetricAvailability
type ResourceMetricCollection = original.ResourceMetricCollection
type ResourceMetricCollectionIterator = original.ResourceMetricCollectionIterator
type ResourceMetricCollectionPage = original.ResourceMetricCollectionPage
type ResourceMetricDefinition = original.ResourceMetricDefinition
type ResourceMetricDefinitionCollection = original.ResourceMetricDefinitionCollection
type ResourceMetricDefinitionCollectionIterator = original.ResourceMetricDefinitionCollectionIterator
type ResourceMetricDefinitionCollectionPage = original.ResourceMetricDefinitionCollectionPage
type ResourceMetricDefinitionProperties = original.ResourceMetricDefinitionProperties
type ResourceMetricName = original.ResourceMetricName
type ResourceMetricProperty = original.ResourceMetricProperty
type ResourceMetricValue = original.ResourceMetricValue
type ResourceNameAvailability = original.ResourceNameAvailability
type ResourceNameAvailabilityRequest = original.ResourceNameAvailabilityRequest
type ResponseMetaData = original.ResponseMetaData
type RestoreRequest = original.RestoreRequest
type RestoreRequestProperties = original.RestoreRequestProperties
type RestoreResponse = original.RestoreResponse
type RestoreResponseProperties = original.RestoreResponseProperties
type ServiceSpecification = original.ServiceSpecification
type SetObject = original.SetObject
type Site = original.Site
type SiteAuthSettings = original.SiteAuthSettings
type SiteAuthSettingsProperties = original.SiteAuthSettingsProperties
type SiteCloneability = original.SiteCloneability
type SiteCloneabilityCriterion = original.SiteCloneabilityCriterion
type SiteConfig = original.SiteConfig
type SiteConfigResource = original.SiteConfigResource
type SiteConfigResourceCollection = original.SiteConfigResourceCollection
type SiteConfigResourceCollectionIterator = original.SiteConfigResourceCollectionIterator
type SiteConfigResourceCollectionPage = original.SiteConfigResourceCollectionPage
type SiteConfigurationSnapshotInfo = original.SiteConfigurationSnapshotInfo
type SiteConfigurationSnapshotInfoCollection = original.SiteConfigurationSnapshotInfoCollection
type SiteConfigurationSnapshotInfoCollectionIterator = original.SiteConfigurationSnapshotInfoCollectionIterator
type SiteConfigurationSnapshotInfoCollectionPage = original.SiteConfigurationSnapshotInfoCollectionPage
type SiteConfigurationSnapshotInfoProperties = original.SiteConfigurationSnapshotInfoProperties
type SiteExtensionInfo = original.SiteExtensionInfo
type SiteExtensionInfoCollection = original.SiteExtensionInfoCollection
type SiteExtensionInfoCollectionIterator = original.SiteExtensionInfoCollectionIterator
type SiteExtensionInfoCollectionPage = original.SiteExtensionInfoCollectionPage
type SiteExtensionInfoProperties = original.SiteExtensionInfoProperties
type SiteInstance = original.SiteInstance
type SiteInstanceProperties = original.SiteInstanceProperties
type SiteLimits = original.SiteLimits
type SiteLogsConfig = original.SiteLogsConfig
type SiteLogsConfigProperties = original.SiteLogsConfigProperties
type SiteMachineKey = original.SiteMachineKey
type SitePatchResource = original.SitePatchResource
type SitePatchResourceProperties = original.SitePatchResourceProperties
type SitePhpErrorLogFlag = original.SitePhpErrorLogFlag
type SitePhpErrorLogFlagProperties = original.SitePhpErrorLogFlagProperties
type SiteProperties = original.SiteProperties
type SiteSeal = original.SiteSeal
type SiteSealRequest = original.SiteSealRequest
type SiteSourceControl = original.SiteSourceControl
type SiteSourceControlProperties = original.SiteSourceControlProperties
type SkuCapacity = original.SkuCapacity
type SkuDescription = original.SkuDescription
type SkuInfo = original.SkuInfo
type SkuInfoCollection = original.SkuInfoCollection
type SkuInfoCollectionIterator = original.SkuInfoCollectionIterator
type SkuInfoCollectionPage = original.SkuInfoCollectionPage
type SkuInfos = original.SkuInfos
type SlotConfigNames = original.SlotConfigNames
type SlotConfigNamesResource = original.SlotConfigNamesResource
type SlotDifference = original.SlotDifference
type SlotDifferenceCollection = original.SlotDifferenceCollection
type SlotDifferenceCollectionIterator = original.SlotDifferenceCollectionIterator
type SlotDifferenceCollectionPage = original.SlotDifferenceCollectionPage
type SlotDifferenceProperties = original.SlotDifferenceProperties
type SlotSwapStatus = original.SlotSwapStatus
type SlowRequestsBasedTrigger = original.SlowRequestsBasedTrigger
type Snapshot = original.Snapshot
type SnapshotCollection = original.SnapshotCollection
type SnapshotCollectionIterator = original.SnapshotCollectionIterator
type SnapshotCollectionPage = original.SnapshotCollectionPage
type SnapshotProperties = original.SnapshotProperties
type SnapshotRecoveryRequest = original.SnapshotRecoveryRequest
type SnapshotRecoveryRequestProperties = original.SnapshotRecoveryRequestProperties
type SnapshotRecoveryTarget = original.SnapshotRecoveryTarget
type Solution = original.Solution
type SourceControl = original.SourceControl
type SourceControlCollection = original.SourceControlCollection
type SourceControlCollectionIterator = original.SourceControlCollectionIterator
type SourceControlCollectionPage = original.SourceControlCollectionPage
type SourceControlProperties = original.SourceControlProperties
type StampCapacity = original.StampCapacity
type StampCapacityCollection = original.StampCapacityCollection
type StampCapacityCollectionIterator = original.StampCapacityCollectionIterator
type StampCapacityCollectionPage = original.StampCapacityCollectionPage
type StatusCodesBasedTrigger = original.StatusCodesBasedTrigger
type StorageMigrationOptions = original.StorageMigrationOptions
type StorageMigrationOptionsProperties = original.StorageMigrationOptionsProperties
type StorageMigrationResponse = original.StorageMigrationResponse
type StorageMigrationResponseProperties = original.StorageMigrationResponseProperties
type String = original.String
type StringDictionary = original.StringDictionary
type TldLegalAgreement = original.TldLegalAgreement
type TldLegalAgreementCollection = original.TldLegalAgreementCollection
type TldLegalAgreementCollectionIterator = original.TldLegalAgreementCollectionIterator
type TldLegalAgreementCollectionPage = original.TldLegalAgreementCollectionPage
type TopLevelDomain = original.TopLevelDomain
type TopLevelDomainAgreementOption = original.TopLevelDomainAgreementOption
type TopLevelDomainCollection = original.TopLevelDomainCollection
type TopLevelDomainCollectionIterator = original.TopLevelDomainCollectionIterator
type TopLevelDomainCollectionPage = original.TopLevelDomainCollectionPage
type TopLevelDomainProperties = original.TopLevelDomainProperties
type TriggeredJobHistory = original.TriggeredJobHistory
type TriggeredJobHistoryCollection = original.TriggeredJobHistoryCollection
type TriggeredJobHistoryCollectionIterator = original.TriggeredJobHistoryCollectionIterator
type TriggeredJobHistoryCollectionPage = original.TriggeredJobHistoryCollectionPage
type TriggeredJobHistoryProperties = original.TriggeredJobHistoryProperties
type TriggeredJobRun = original.TriggeredJobRun
type TriggeredJobRunProperties = original.TriggeredJobRunProperties
type TriggeredWebJob = original.TriggeredWebJob
type TriggeredWebJobCollection = original.TriggeredWebJobCollection
type TriggeredWebJobCollectionIterator = original.TriggeredWebJobCollectionIterator
type TriggeredWebJobCollectionPage = original.TriggeredWebJobCollectionPage
type TriggeredWebJobProperties = original.TriggeredWebJobProperties
type Usage = original.Usage
type UsageCollection = original.UsageCollection
type UsageCollectionIterator = original.UsageCollectionIterator
type UsageCollectionPage = original.UsageCollectionPage
type UsageProperties = original.UsageProperties
type User = original.User
type UserProperties = original.UserProperties
type ValidateProperties = original.ValidateProperties
type ValidateRequest = original.ValidateRequest
type ValidateResponse = original.ValidateResponse
type ValidateResponseError = original.ValidateResponseError
type VirtualApplication = original.VirtualApplication
type VirtualDirectory = original.VirtualDirectory
type VirtualIPMapping = original.VirtualIPMapping
type VirtualNetworkProfile = original.VirtualNetworkProfile
type VnetGateway = original.VnetGateway
type VnetGatewayProperties = original.VnetGatewayProperties
type VnetInfo = original.VnetInfo
type VnetInfoProperties = original.VnetInfoProperties
type VnetParameters = original.VnetParameters
type VnetParametersProperties = original.VnetParametersProperties
type VnetRoute = original.VnetRoute
type VnetRouteProperties = original.VnetRouteProperties
type VnetValidationFailureDetails = original.VnetValidationFailureDetails
type VnetValidationFailureDetailsProperties = original.VnetValidationFailureDetailsProperties
type VnetValidationTestFailure = original.VnetValidationTestFailure
type VnetValidationTestFailureProperties = original.VnetValidationTestFailureProperties
type WorkerPool = original.WorkerPool
type WorkerPoolCollection = original.WorkerPoolCollection
type WorkerPoolCollectionIterator = original.WorkerPoolCollectionIterator
type WorkerPoolCollectionPage = original.WorkerPoolCollectionPage
type WorkerPoolResource = original.WorkerPoolResource
type ProviderClient = original.ProviderClient

func NewProviderClient(subscriptionID string) ProviderClient {
	return original.NewProviderClient(subscriptionID)
}
func NewProviderClientWithBaseURI(baseURI string, subscriptionID string) ProviderClient {
	return original.NewProviderClientWithBaseURI(baseURI, subscriptionID)
}

type RecommendationsClient = original.RecommendationsClient

func NewRecommendationsClient(subscriptionID string) RecommendationsClient {
	return original.NewRecommendationsClient(subscriptionID)
}
func NewRecommendationsClientWithBaseURI(baseURI string, subscriptionID string) RecommendationsClient {
	return original.NewRecommendationsClientWithBaseURI(baseURI, subscriptionID)
}

type TopLevelDomainsClient = original.TopLevelDomainsClient

func NewTopLevelDomainsClient(subscriptionID string) TopLevelDomainsClient {
	return original.NewTopLevelDomainsClient(subscriptionID)
}
func NewTopLevelDomainsClientWithBaseURI(baseURI string, subscriptionID string) TopLevelDomainsClient {
	return original.NewTopLevelDomainsClientWithBaseURI(baseURI, subscriptionID)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
