package router

// These certificates are example certificates generated by a fake cert authority.
// In order to regenerate these certificates (or create new ones) you will need to grab the demo CA key
// which can be found https://github.com/pweil-/hello-nginx-docker.  That repo contains all the keys found below, the
// CA configuration file used to sign the keys, and the CA keys themselves along with the CA database.
//
// The CA certificate/key was generated with:
// OPENSSL=ca.cnf openssl req -x509 -nodes -days 3650 -newkey rsa:2048 -out mypersonalca/certs/ca.pem -outform PEM -keyout ./mypersonalca/private/ca.key
//
// In order to create new certificates you must first make a certificate request and key using openssl.  You will be asked
// a series of questions.  The important one is the Common Name.  The certificates below marked Example* use www.example.com
// as the common name.  Example2* uses www.example2.com as the common name
//
// openssl req -newkey rsa:1024 -nodes -sha1 -keyout cert.key -keyform PEM -out cert.req -outform PEM
//
// Once you have the request you then need to generate the the certificate with the authority key
// OPENSSL_CONF=ca.cnf openssl ca -batch -notext -in cert.req -out cert.pem
//
// To view your certificate via the command line:
// openssl x509 -in cert.pem -noout -text

var ExampleCert = `-----BEGIN CERTIFICATE-----
MIIDIjCCAgqgAwIBAgIBBjANBgkqhkiG9w0BAQUFADCBoTELMAkGA1UEBhMCVVMx
CzAJBgNVBAgMAlNDMRUwEwYDVQQHDAxEZWZhdWx0IENpdHkxHDAaBgNVBAoME0Rl
ZmF1bHQgQ29tcGFueSBMdGQxEDAOBgNVBAsMB1Rlc3QgQ0ExGjAYBgNVBAMMEXd3
dy5leGFtcGxlY2EuY29tMSIwIAYJKoZIhvcNAQkBFhNleGFtcGxlQGV4YW1wbGUu
Y29tMB4XDTE2MDExMzE5NDA1N1oXDTI2MDExMDE5NDA1N1owfDEYMBYGA1UEAxMP
d3d3LmV4YW1wbGUuY29tMQswCQYDVQQIEwJTQzELMAkGA1UEBhMCVVMxIjAgBgkq
hkiG9w0BCQEWE2V4YW1wbGVAZXhhbXBsZS5jb20xEDAOBgNVBAoTB0V4YW1wbGUx
EDAOBgNVBAsTB0V4YW1wbGUwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAM0B
u++oHV1wcphWRbMLUft8fD7nPG95xs7UeLPphFZuShIhhdAQMpvcsFeg+Bg9PWCu
v3jZljmk06MLvuWLfwjYfo9q/V+qOZVfTVHHbaIO5RTXJMC2Nn+ACF0kHBmNcbth
OOgF8L854a/P8tjm1iPR++vHnkex0NH7lyosVc/vAgMBAAGjDTALMAkGA1UdEwQC
MAAwDQYJKoZIhvcNAQEFBQADggEBADjFm5AlNH3DNT1Uzx3m66fFjqqrHEs25geT
yA3rvBuynflEHQO95M/8wCxYVyuAx4Z1i4YDC7tx0vmOn/2GXZHY9MAj1I8KCnwt
Jik7E2r1/yY0MrkawljOAxisXs821kJ+Z/51Ud2t5uhGxS6hJypbGspMS7OtBbw7
8oThK7cWtCXOldNF6ruqY1agWnhRdAq5qSMnuBXuicOP0Kbtx51a1ugE3SnvQenJ
nZxdtYUXvEsHZC/6bAtTfNh+/SwgxQJuL2ZM+VG3X2JIKY8xTDui+il7uTh422lq
wED8uwKl+bOj6xFDyw4gWoBxRobsbFaME8pkykP1+GnKDberyAM=
-----END CERTIFICATE-----
`

var ExampleKey = `-----BEGIN RSA PRIVATE KEY-----
MIICWwIBAAKBgQDNAbvvqB1dcHKYVkWzC1H7fHw+5zxvecbO1Hiz6YRWbkoSIYXQ
EDKb3LBXoPgYPT1grr942ZY5pNOjC77li38I2H6Pav1fqjmVX01Rx22iDuUU1yTA
tjZ/gAhdJBwZjXG7YTjoBfC/OeGvz/LY5tYj0fvrx55HsdDR+5cqLFXP7wIDAQAB
AoGAfE7P4Zsj6zOzGPI/Izj7Bi5OvGnEeKfzyBiH9Dflue74VRQkqqwXs/DWsNv3
c+M2Y3iyu5ncgKmUduo5X8D9To2ymPRLGuCdfZTxnBMpIDKSJ0FTwVPkr6cYyyBk
5VCbc470pQPxTAAtl2eaO1sIrzR4PcgwqrSOjwBQQocsGAECQQD8QOra/mZmxPbt
bRh8U5lhgZmirImk5RY3QMPI/1/f4k+fyjkU5FRq/yqSyin75aSAXg8IupAFRgyZ
W7BT6zwBAkEA0A0ugAGorpCbuTa25SsIOMxkEzCiKYvh0O+GfGkzWG4lkSeJqGME
keuJGlXrZNKNoCYLluAKLPmnd72X2yTL7wJARM0kAXUP0wn324w8+HQIyqqBj/gF
Vt9Q7uMQQ3s72CGu3ANZDFS2nbRZFU5koxrggk6lRRk1fOq9NvrmHg10AQJABOea
pgfj+yGLmkUw8JwgGH6xCUbHO+WBUFSlPf+Y50fJeO+OrjqPXAVKeSV3ZCwWjKT4
9viXJNJJ4WfF0bO/XwJAOMB1wQnEOSZ4v+laMwNtMq6hre5K8woqteXICoGcIWe8
u3YLAbyW/lHhOCiZu2iAI8AbmXem9lW6Tr7p/97s0w==
-----END RSA PRIVATE KEY-----
`

var Example2Cert = `-----BEGIN CERTIFICATE-----
MIIDJzCCAg+gAwIBAgIBBzANBgkqhkiG9w0BAQUFADCBoTELMAkGA1UEBhMCVVMx
CzAJBgNVBAgMAlNDMRUwEwYDVQQHDAxEZWZhdWx0IENpdHkxHDAaBgNVBAoME0Rl
ZmF1bHQgQ29tcGFueSBMdGQxEDAOBgNVBAsMB1Rlc3QgQ0ExGjAYBgNVBAMMEXd3
dy5leGFtcGxlY2EuY29tMSIwIAYJKoZIhvcNAQkBFhNleGFtcGxlQGV4YW1wbGUu
Y29tMB4XDTE2MDExMzE5NDEwNloXDTI2MDExMDE5NDEwNlowgYAxGTAXBgNVBAMT
EHd3dy5leGFtcGxlMi5jb20xCzAJBgNVBAgTAlNDMQswCQYDVQQGEwJVUzEjMCEG
CSqGSIb3DQEJARYUZXhhbXBsZTJAZXhhbXBsZS5jb20xETAPBgNVBAoTCEV4YW1w
bGUyMREwDwYDVQQLEwhFeGFtcGxlMjCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkC
gYEAyNZ2LYb4rx9JPDSL2HV+Jn5x5dsxJXpOTsMnXCDt3thcU1XkdraJyameRGAN
eyQwMDmw9QIz7VQ8keYD8oj86pXxAlJAcAAlOJk7QVQPCI96rfCFh7mIJvSkZDp3
qLXPa+Eh6A6BdDnH+k66NaKPA2r9CmlFOjQRegX7OoCT0DMCAwEAAaMNMAswCQYD
VR0TBAIwADANBgkqhkiG9w0BAQUFAAOCAQEAjZyGYv/Z/L34dI/QNZnj+giEi01+
zaNxVMGvg0MR0+Y+neTtoXD422rVoIM5OmwxdwtrtUxgjrNKeSCGFytnHbn/sgob
L9pF5SbkS8nnbhahj1FEjjjIzRCng/TPp2pHlU13ccpHblffGrawyLzayBzQYFLB
SdGBb8Brj3/XvjGuwx889Pxk0du00gl94b3Q8LQ+veHpwTA5KmvT2OrKZr3zv3zY
o/WkbxE76DTRnXNHDD30BxhW5EMP9lpJKfOQjXd244S4ZxQ1sD/ecVQYt3I7TJfM
BlKIfRJfzFLrI4wD/3Xz4ZA596KAbNt6Eb3liRRM+qh5cNab88640SKFAg==
-----END CERTIFICATE-----
`

var Example2Key = `-----BEGIN RSA PRIVATE KEY-----
MIICXAIBAAKBgQDI1nYthvivH0k8NIvYdX4mfnHl2zElek5OwydcIO3e2FxTVeR2
tonJqZ5EYA17JDAwObD1AjPtVDyR5gPyiPzqlfECUkBwACU4mTtBVA8Ij3qt8IWH
uYgm9KRkOneotc9r4SHoDoF0Ocf6Tro1oo8Dav0KaUU6NBF6Bfs6gJPQMwIDAQAB
AoGASAsOZ3R0PrWVWsBqreIvt3VCPDbtoUkHUB+XPegeDANG0yoLgz4lnS54NITU
MSkhFBuNy8XXhLnj5F5DajwTpRwQCgWyTccXDPqkNRzV6O7cHXPiyIkGwlo42RmF
o3OFGfgrblo+zkGG9Pm4kNo3bt5yY/usU9x8ku4Z2ExFgYkCQQDquZyjVeG3BXVx
apRFHsCMVD0GpwTGbCCyRYYtYXtBYVej8myAUz27QioK7rZ0SgvwtMUU5irNh0ba
BlE4XM9/AkEA2wqNtHHMLU2r5iZVx2qdqQoac4q5OYc/qyseAv62ChaqBThib9zR
1uYt/mmPz7ECyD93q7kcLQcm2TA+VpoZTQJAQGdZYT+pRQyMYug5cpWzg02ByRd+
qer1NbT50e3TYecRovxbZQJyB7Vpz8Ib8eB3Uj5nbQqSZ/5cJGpjUrG0hQJBAKRt
xrR3XKuBjBJIIsqBOXtEz1h/Ac6yvdPTmULsTGFEZDto+VQ58vgccNh0C/YATjNe
mYo6enE+1iXiNlmycl0CQA6vrFco9urDauhebhyedEni0zO0pg7BxFSXgbIFwOp5
gFAC7mH098grGfJ401wCD/5/fnbD1bxMgjsn2BaeCa4=
-----END RSA PRIVATE KEY-----
`

var ExampleCACert = `-----BEGIN CERTIFICATE-----
MIIEFzCCAv+gAwIBAgIJALK1iUpF2VQLMA0GCSqGSIb3DQEBBQUAMIGhMQswCQYD
VQQGEwJVUzELMAkGA1UECAwCU0MxFTATBgNVBAcMDERlZmF1bHQgQ2l0eTEcMBoG
A1UECgwTRGVmYXVsdCBDb21wYW55IEx0ZDEQMA4GA1UECwwHVGVzdCBDQTEaMBgG
A1UEAwwRd3d3LmV4YW1wbGVjYS5jb20xIjAgBgkqhkiG9w0BCQEWE2V4YW1wbGVA
ZXhhbXBsZS5jb20wHhcNMTUwMTEyMTQxNTAxWhcNMjUwMTA5MTQxNTAxWjCBoTEL
MAkGA1UEBhMCVVMxCzAJBgNVBAgMAlNDMRUwEwYDVQQHDAxEZWZhdWx0IENpdHkx
HDAaBgNVBAoME0RlZmF1bHQgQ29tcGFueSBMdGQxEDAOBgNVBAsMB1Rlc3QgQ0Ex
GjAYBgNVBAMMEXd3dy5leGFtcGxlY2EuY29tMSIwIAYJKoZIhvcNAQkBFhNleGFt
cGxlQGV4YW1wbGUuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
w2rK1J2NMtQj0KDug7g7HRKl5jbf0QMkMKyTU1fBtZ0cCzvsF4CqV11LK4BSVWaK
rzkaXe99IVJnH8KdOlDl5Dh/+cJ3xdkClSyeUT4zgb6CCBqg78ePp+nN11JKuJlV
IG1qdJpB1J5O/kCLsGcTf7RS74MtqMFo96446Zvt7YaBhWPz6gDaO/TUzfrNcGLA
EfHVXkvVWqb3gqXUztZyVex/gtP9FXQ7gxTvJml7UkmT0VAFjtZnCqmFxpLZFZ15
+qP9O7Q2MpsGUO/4vDAuYrKBeg1ZdPSi8gwqUP2qWsGd9MIWRv3thI2903BczDc7
r8WaIbm37vYZAS9G56E4+wIDAQABo1AwTjAdBgNVHQ4EFgQUugLrSJshOBk5TSsU
ANs4+SmJUGwwHwYDVR0jBBgwFoAUugLrSJshOBk5TSsUANs4+SmJUGwwDAYDVR0T
BAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEAaMJ33zAMV4korHo5aPfayV3uHoYZ
1ChzP3eSsF+FjoscpoNSKs91ZXZF6LquzoNezbfiihK4PYqgwVD2+O0/Ty7UjN4S
qzFKVR4OS/6lCJ8YncxoFpTntbvjgojf1DEataKFUN196PAANc3yz8cWHF4uvjPv
WkgFqbIjb+7D1YgglNyovXkRDlRZl0LD1OQ0ZWhd4Ge1qx8mmmanoBeYZ9+DgpFC
j9tQAbS867yeOryNe7sEOIpXAAqK/DTu0hB6+ySsDfMo4piXCc2aA/eI2DCuw08e
w17Dz9WnupZjVdwTKzDhFgJZMLDqn37HQnT6EemLFqbcR0VPEnfyhDtZIQ==
-----END CERTIFICATE-----
`
