// +build !ignore_autogenerated_openshift

// Code generated by conversion-gen. DO NOT EDIT.

package v1

import (
	time "time"
	unsafe "unsafe"

	v1 "github.com/openshift/api/build/v1"
	build "github.com/openshift/origin/pkg/build/apis/build"
	api_core_v1 "k8s.io/api/core/v1"
	meta_v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	core "k8s.io/kubernetes/pkg/apis/core"
	core_v1 "k8s.io/kubernetes/pkg/apis/core/v1"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(scheme *runtime.Scheme) error {
	return scheme.AddGeneratedConversionFuncs(
		Convert_v1_BinaryBuildRequestOptions_To_build_BinaryBuildRequestOptions,
		Convert_build_BinaryBuildRequestOptions_To_v1_BinaryBuildRequestOptions,
		Convert_v1_BinaryBuildSource_To_build_BinaryBuildSource,
		Convert_build_BinaryBuildSource_To_v1_BinaryBuildSource,
		Convert_v1_BitbucketWebHookCause_To_build_BitbucketWebHookCause,
		Convert_build_BitbucketWebHookCause_To_v1_BitbucketWebHookCause,
		Convert_v1_Build_To_build_Build,
		Convert_build_Build_To_v1_Build,
		Convert_v1_BuildConfig_To_build_BuildConfig,
		Convert_build_BuildConfig_To_v1_BuildConfig,
		Convert_v1_BuildConfigList_To_build_BuildConfigList,
		Convert_build_BuildConfigList_To_v1_BuildConfigList,
		Convert_v1_BuildConfigSpec_To_build_BuildConfigSpec,
		Convert_build_BuildConfigSpec_To_v1_BuildConfigSpec,
		Convert_v1_BuildConfigStatus_To_build_BuildConfigStatus,
		Convert_build_BuildConfigStatus_To_v1_BuildConfigStatus,
		Convert_v1_BuildList_To_build_BuildList,
		Convert_build_BuildList_To_v1_BuildList,
		Convert_v1_BuildLog_To_build_BuildLog,
		Convert_build_BuildLog_To_v1_BuildLog,
		Convert_v1_BuildLogOptions_To_build_BuildLogOptions,
		Convert_build_BuildLogOptions_To_v1_BuildLogOptions,
		Convert_v1_BuildOutput_To_build_BuildOutput,
		Convert_build_BuildOutput_To_v1_BuildOutput,
		Convert_v1_BuildPostCommitSpec_To_build_BuildPostCommitSpec,
		Convert_build_BuildPostCommitSpec_To_v1_BuildPostCommitSpec,
		Convert_v1_BuildRequest_To_build_BuildRequest,
		Convert_build_BuildRequest_To_v1_BuildRequest,
		Convert_v1_BuildSource_To_build_BuildSource,
		Convert_build_BuildSource_To_v1_BuildSource,
		Convert_v1_BuildSpec_To_build_BuildSpec,
		Convert_build_BuildSpec_To_v1_BuildSpec,
		Convert_v1_BuildStatus_To_build_BuildStatus,
		Convert_build_BuildStatus_To_v1_BuildStatus,
		Convert_v1_BuildStatusOutput_To_build_BuildStatusOutput,
		Convert_build_BuildStatusOutput_To_v1_BuildStatusOutput,
		Convert_v1_BuildStatusOutputTo_To_build_BuildStatusOutputTo,
		Convert_build_BuildStatusOutputTo_To_v1_BuildStatusOutputTo,
		Convert_v1_BuildStrategy_To_build_BuildStrategy,
		Convert_build_BuildStrategy_To_v1_BuildStrategy,
		Convert_v1_BuildTriggerCause_To_build_BuildTriggerCause,
		Convert_build_BuildTriggerCause_To_v1_BuildTriggerCause,
		Convert_v1_BuildTriggerPolicy_To_build_BuildTriggerPolicy,
		Convert_build_BuildTriggerPolicy_To_v1_BuildTriggerPolicy,
		Convert_v1_CommonSpec_To_build_CommonSpec,
		Convert_build_CommonSpec_To_v1_CommonSpec,
		Convert_v1_CommonWebHookCause_To_build_CommonWebHookCause,
		Convert_build_CommonWebHookCause_To_v1_CommonWebHookCause,
		Convert_v1_ConfigMapBuildSource_To_build_ConfigMapBuildSource,
		Convert_build_ConfigMapBuildSource_To_v1_ConfigMapBuildSource,
		Convert_v1_CustomBuildStrategy_To_build_CustomBuildStrategy,
		Convert_build_CustomBuildStrategy_To_v1_CustomBuildStrategy,
		Convert_v1_DockerBuildStrategy_To_build_DockerBuildStrategy,
		Convert_build_DockerBuildStrategy_To_v1_DockerBuildStrategy,
		Convert_v1_DockerStrategyOptions_To_build_DockerStrategyOptions,
		Convert_build_DockerStrategyOptions_To_v1_DockerStrategyOptions,
		Convert_v1_GenericWebHookCause_To_build_GenericWebHookCause,
		Convert_build_GenericWebHookCause_To_v1_GenericWebHookCause,
		Convert_v1_GenericWebHookEvent_To_build_GenericWebHookEvent,
		Convert_build_GenericWebHookEvent_To_v1_GenericWebHookEvent,
		Convert_v1_GitBuildSource_To_build_GitBuildSource,
		Convert_build_GitBuildSource_To_v1_GitBuildSource,
		Convert_v1_GitHubWebHookCause_To_build_GitHubWebHookCause,
		Convert_build_GitHubWebHookCause_To_v1_GitHubWebHookCause,
		Convert_v1_GitInfo_To_build_GitInfo,
		Convert_build_GitInfo_To_v1_GitInfo,
		Convert_v1_GitLabWebHookCause_To_build_GitLabWebHookCause,
		Convert_build_GitLabWebHookCause_To_v1_GitLabWebHookCause,
		Convert_v1_GitRefInfo_To_build_GitRefInfo,
		Convert_build_GitRefInfo_To_v1_GitRefInfo,
		Convert_v1_GitSourceRevision_To_build_GitSourceRevision,
		Convert_build_GitSourceRevision_To_v1_GitSourceRevision,
		Convert_v1_ImageChangeCause_To_build_ImageChangeCause,
		Convert_build_ImageChangeCause_To_v1_ImageChangeCause,
		Convert_v1_ImageChangeTrigger_To_build_ImageChangeTrigger,
		Convert_build_ImageChangeTrigger_To_v1_ImageChangeTrigger,
		Convert_v1_ImageLabel_To_build_ImageLabel,
		Convert_build_ImageLabel_To_v1_ImageLabel,
		Convert_v1_ImageSource_To_build_ImageSource,
		Convert_build_ImageSource_To_v1_ImageSource,
		Convert_v1_ImageSourcePath_To_build_ImageSourcePath,
		Convert_build_ImageSourcePath_To_v1_ImageSourcePath,
		Convert_v1_JenkinsPipelineBuildStrategy_To_build_JenkinsPipelineBuildStrategy,
		Convert_build_JenkinsPipelineBuildStrategy_To_v1_JenkinsPipelineBuildStrategy,
		Convert_v1_ProxyConfig_To_build_ProxyConfig,
		Convert_build_ProxyConfig_To_v1_ProxyConfig,
		Convert_v1_SecretBuildSource_To_build_SecretBuildSource,
		Convert_build_SecretBuildSource_To_v1_SecretBuildSource,
		Convert_v1_SecretLocalReference_To_build_SecretLocalReference,
		Convert_build_SecretLocalReference_To_v1_SecretLocalReference,
		Convert_v1_SecretSpec_To_build_SecretSpec,
		Convert_build_SecretSpec_To_v1_SecretSpec,
		Convert_v1_SourceBuildStrategy_To_build_SourceBuildStrategy,
		Convert_build_SourceBuildStrategy_To_v1_SourceBuildStrategy,
		Convert_v1_SourceControlUser_To_build_SourceControlUser,
		Convert_build_SourceControlUser_To_v1_SourceControlUser,
		Convert_v1_SourceRevision_To_build_SourceRevision,
		Convert_build_SourceRevision_To_v1_SourceRevision,
		Convert_v1_SourceStrategyOptions_To_build_SourceStrategyOptions,
		Convert_build_SourceStrategyOptions_To_v1_SourceStrategyOptions,
		Convert_v1_StageInfo_To_build_StageInfo,
		Convert_build_StageInfo_To_v1_StageInfo,
		Convert_v1_StepInfo_To_build_StepInfo,
		Convert_build_StepInfo_To_v1_StepInfo,
		Convert_v1_WebHookTrigger_To_build_WebHookTrigger,
		Convert_build_WebHookTrigger_To_v1_WebHookTrigger,
	)
}

func autoConvert_v1_BinaryBuildRequestOptions_To_build_BinaryBuildRequestOptions(in *v1.BinaryBuildRequestOptions, out *build.BinaryBuildRequestOptions, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.AsFile = in.AsFile
	out.Commit = in.Commit
	out.Message = in.Message
	out.AuthorName = in.AuthorName
	out.AuthorEmail = in.AuthorEmail
	out.CommitterName = in.CommitterName
	out.CommitterEmail = in.CommitterEmail
	return nil
}

// Convert_v1_BinaryBuildRequestOptions_To_build_BinaryBuildRequestOptions is an autogenerated conversion function.
func Convert_v1_BinaryBuildRequestOptions_To_build_BinaryBuildRequestOptions(in *v1.BinaryBuildRequestOptions, out *build.BinaryBuildRequestOptions, s conversion.Scope) error {
	return autoConvert_v1_BinaryBuildRequestOptions_To_build_BinaryBuildRequestOptions(in, out, s)
}

func autoConvert_build_BinaryBuildRequestOptions_To_v1_BinaryBuildRequestOptions(in *build.BinaryBuildRequestOptions, out *v1.BinaryBuildRequestOptions, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	out.AsFile = in.AsFile
	out.Commit = in.Commit
	out.Message = in.Message
	out.AuthorName = in.AuthorName
	out.AuthorEmail = in.AuthorEmail
	out.CommitterName = in.CommitterName
	out.CommitterEmail = in.CommitterEmail
	return nil
}

// Convert_build_BinaryBuildRequestOptions_To_v1_BinaryBuildRequestOptions is an autogenerated conversion function.
func Convert_build_BinaryBuildRequestOptions_To_v1_BinaryBuildRequestOptions(in *build.BinaryBuildRequestOptions, out *v1.BinaryBuildRequestOptions, s conversion.Scope) error {
	return autoConvert_build_BinaryBuildRequestOptions_To_v1_BinaryBuildRequestOptions(in, out, s)
}

func autoConvert_v1_BinaryBuildSource_To_build_BinaryBuildSource(in *v1.BinaryBuildSource, out *build.BinaryBuildSource, s conversion.Scope) error {
	out.AsFile = in.AsFile
	return nil
}

// Convert_v1_BinaryBuildSource_To_build_BinaryBuildSource is an autogenerated conversion function.
func Convert_v1_BinaryBuildSource_To_build_BinaryBuildSource(in *v1.BinaryBuildSource, out *build.BinaryBuildSource, s conversion.Scope) error {
	return autoConvert_v1_BinaryBuildSource_To_build_BinaryBuildSource(in, out, s)
}

func autoConvert_build_BinaryBuildSource_To_v1_BinaryBuildSource(in *build.BinaryBuildSource, out *v1.BinaryBuildSource, s conversion.Scope) error {
	out.AsFile = in.AsFile
	return nil
}

// Convert_build_BinaryBuildSource_To_v1_BinaryBuildSource is an autogenerated conversion function.
func Convert_build_BinaryBuildSource_To_v1_BinaryBuildSource(in *build.BinaryBuildSource, out *v1.BinaryBuildSource, s conversion.Scope) error {
	return autoConvert_build_BinaryBuildSource_To_v1_BinaryBuildSource(in, out, s)
}

func autoConvert_v1_BitbucketWebHookCause_To_build_BitbucketWebHookCause(in *v1.BitbucketWebHookCause, out *build.BitbucketWebHookCause, s conversion.Scope) error {
	if err := Convert_v1_CommonWebHookCause_To_build_CommonWebHookCause(&in.CommonWebHookCause, &out.CommonWebHookCause, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_BitbucketWebHookCause_To_build_BitbucketWebHookCause is an autogenerated conversion function.
func Convert_v1_BitbucketWebHookCause_To_build_BitbucketWebHookCause(in *v1.BitbucketWebHookCause, out *build.BitbucketWebHookCause, s conversion.Scope) error {
	return autoConvert_v1_BitbucketWebHookCause_To_build_BitbucketWebHookCause(in, out, s)
}

func autoConvert_build_BitbucketWebHookCause_To_v1_BitbucketWebHookCause(in *build.BitbucketWebHookCause, out *v1.BitbucketWebHookCause, s conversion.Scope) error {
	if err := Convert_build_CommonWebHookCause_To_v1_CommonWebHookCause(&in.CommonWebHookCause, &out.CommonWebHookCause, s); err != nil {
		return err
	}
	return nil
}

// Convert_build_BitbucketWebHookCause_To_v1_BitbucketWebHookCause is an autogenerated conversion function.
func Convert_build_BitbucketWebHookCause_To_v1_BitbucketWebHookCause(in *build.BitbucketWebHookCause, out *v1.BitbucketWebHookCause, s conversion.Scope) error {
	return autoConvert_build_BitbucketWebHookCause_To_v1_BitbucketWebHookCause(in, out, s)
}

func autoConvert_v1_Build_To_build_Build(in *v1.Build, out *build.Build, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_BuildSpec_To_build_BuildSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_BuildStatus_To_build_BuildStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_Build_To_build_Build is an autogenerated conversion function.
func Convert_v1_Build_To_build_Build(in *v1.Build, out *build.Build, s conversion.Scope) error {
	return autoConvert_v1_Build_To_build_Build(in, out, s)
}

func autoConvert_build_Build_To_v1_Build(in *build.Build, out *v1.Build, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_build_BuildSpec_To_v1_BuildSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_build_BuildStatus_To_v1_BuildStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_build_Build_To_v1_Build is an autogenerated conversion function.
func Convert_build_Build_To_v1_Build(in *build.Build, out *v1.Build, s conversion.Scope) error {
	return autoConvert_build_Build_To_v1_Build(in, out, s)
}

func autoConvert_v1_BuildConfig_To_build_BuildConfig(in *v1.BuildConfig, out *build.BuildConfig, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_BuildConfigSpec_To_build_BuildConfigSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_BuildConfigStatus_To_build_BuildConfigStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

func autoConvert_build_BuildConfig_To_v1_BuildConfig(in *build.BuildConfig, out *v1.BuildConfig, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_build_BuildConfigSpec_To_v1_BuildConfigSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_build_BuildConfigStatus_To_v1_BuildConfigStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_build_BuildConfig_To_v1_BuildConfig is an autogenerated conversion function.
func Convert_build_BuildConfig_To_v1_BuildConfig(in *build.BuildConfig, out *v1.BuildConfig, s conversion.Scope) error {
	return autoConvert_build_BuildConfig_To_v1_BuildConfig(in, out, s)
}

func autoConvert_v1_BuildConfigList_To_build_BuildConfigList(in *v1.BuildConfigList, out *build.BuildConfigList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]build.BuildConfig, len(*in))
		for i := range *in {
			if err := Convert_v1_BuildConfig_To_build_BuildConfig(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_BuildConfigList_To_build_BuildConfigList is an autogenerated conversion function.
func Convert_v1_BuildConfigList_To_build_BuildConfigList(in *v1.BuildConfigList, out *build.BuildConfigList, s conversion.Scope) error {
	return autoConvert_v1_BuildConfigList_To_build_BuildConfigList(in, out, s)
}

func autoConvert_build_BuildConfigList_To_v1_BuildConfigList(in *build.BuildConfigList, out *v1.BuildConfigList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1.BuildConfig, len(*in))
		for i := range *in {
			if err := Convert_build_BuildConfig_To_v1_BuildConfig(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_build_BuildConfigList_To_v1_BuildConfigList is an autogenerated conversion function.
func Convert_build_BuildConfigList_To_v1_BuildConfigList(in *build.BuildConfigList, out *v1.BuildConfigList, s conversion.Scope) error {
	return autoConvert_build_BuildConfigList_To_v1_BuildConfigList(in, out, s)
}

func autoConvert_v1_BuildConfigSpec_To_build_BuildConfigSpec(in *v1.BuildConfigSpec, out *build.BuildConfigSpec, s conversion.Scope) error {
	if in.Triggers != nil {
		in, out := &in.Triggers, &out.Triggers
		*out = make([]build.BuildTriggerPolicy, len(*in))
		for i := range *in {
			if err := Convert_v1_BuildTriggerPolicy_To_build_BuildTriggerPolicy(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Triggers = nil
	}
	out.RunPolicy = build.BuildRunPolicy(in.RunPolicy)
	if err := Convert_v1_CommonSpec_To_build_CommonSpec(&in.CommonSpec, &out.CommonSpec, s); err != nil {
		return err
	}
	out.SuccessfulBuildsHistoryLimit = (*int32)(unsafe.Pointer(in.SuccessfulBuildsHistoryLimit))
	out.FailedBuildsHistoryLimit = (*int32)(unsafe.Pointer(in.FailedBuildsHistoryLimit))
	return nil
}

// Convert_v1_BuildConfigSpec_To_build_BuildConfigSpec is an autogenerated conversion function.
func Convert_v1_BuildConfigSpec_To_build_BuildConfigSpec(in *v1.BuildConfigSpec, out *build.BuildConfigSpec, s conversion.Scope) error {
	return autoConvert_v1_BuildConfigSpec_To_build_BuildConfigSpec(in, out, s)
}

func autoConvert_build_BuildConfigSpec_To_v1_BuildConfigSpec(in *build.BuildConfigSpec, out *v1.BuildConfigSpec, s conversion.Scope) error {
	if in.Triggers != nil {
		in, out := &in.Triggers, &out.Triggers
		*out = make([]v1.BuildTriggerPolicy, len(*in))
		for i := range *in {
			if err := Convert_build_BuildTriggerPolicy_To_v1_BuildTriggerPolicy(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Triggers = nil
	}
	out.RunPolicy = v1.BuildRunPolicy(in.RunPolicy)
	if err := Convert_build_CommonSpec_To_v1_CommonSpec(&in.CommonSpec, &out.CommonSpec, s); err != nil {
		return err
	}
	out.SuccessfulBuildsHistoryLimit = (*int32)(unsafe.Pointer(in.SuccessfulBuildsHistoryLimit))
	out.FailedBuildsHistoryLimit = (*int32)(unsafe.Pointer(in.FailedBuildsHistoryLimit))
	return nil
}

// Convert_build_BuildConfigSpec_To_v1_BuildConfigSpec is an autogenerated conversion function.
func Convert_build_BuildConfigSpec_To_v1_BuildConfigSpec(in *build.BuildConfigSpec, out *v1.BuildConfigSpec, s conversion.Scope) error {
	return autoConvert_build_BuildConfigSpec_To_v1_BuildConfigSpec(in, out, s)
}

func autoConvert_v1_BuildConfigStatus_To_build_BuildConfigStatus(in *v1.BuildConfigStatus, out *build.BuildConfigStatus, s conversion.Scope) error {
	out.LastVersion = in.LastVersion
	return nil
}

// Convert_v1_BuildConfigStatus_To_build_BuildConfigStatus is an autogenerated conversion function.
func Convert_v1_BuildConfigStatus_To_build_BuildConfigStatus(in *v1.BuildConfigStatus, out *build.BuildConfigStatus, s conversion.Scope) error {
	return autoConvert_v1_BuildConfigStatus_To_build_BuildConfigStatus(in, out, s)
}

func autoConvert_build_BuildConfigStatus_To_v1_BuildConfigStatus(in *build.BuildConfigStatus, out *v1.BuildConfigStatus, s conversion.Scope) error {
	out.LastVersion = in.LastVersion
	return nil
}

// Convert_build_BuildConfigStatus_To_v1_BuildConfigStatus is an autogenerated conversion function.
func Convert_build_BuildConfigStatus_To_v1_BuildConfigStatus(in *build.BuildConfigStatus, out *v1.BuildConfigStatus, s conversion.Scope) error {
	return autoConvert_build_BuildConfigStatus_To_v1_BuildConfigStatus(in, out, s)
}

func autoConvert_v1_BuildList_To_build_BuildList(in *v1.BuildList, out *build.BuildList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]build.Build, len(*in))
		for i := range *in {
			if err := Convert_v1_Build_To_build_Build(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_BuildList_To_build_BuildList is an autogenerated conversion function.
func Convert_v1_BuildList_To_build_BuildList(in *v1.BuildList, out *build.BuildList, s conversion.Scope) error {
	return autoConvert_v1_BuildList_To_build_BuildList(in, out, s)
}

func autoConvert_build_BuildList_To_v1_BuildList(in *build.BuildList, out *v1.BuildList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1.Build, len(*in))
		for i := range *in {
			if err := Convert_build_Build_To_v1_Build(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_build_BuildList_To_v1_BuildList is an autogenerated conversion function.
func Convert_build_BuildList_To_v1_BuildList(in *build.BuildList, out *v1.BuildList, s conversion.Scope) error {
	return autoConvert_build_BuildList_To_v1_BuildList(in, out, s)
}

func autoConvert_v1_BuildLog_To_build_BuildLog(in *v1.BuildLog, out *build.BuildLog, s conversion.Scope) error {
	return nil
}

// Convert_v1_BuildLog_To_build_BuildLog is an autogenerated conversion function.
func Convert_v1_BuildLog_To_build_BuildLog(in *v1.BuildLog, out *build.BuildLog, s conversion.Scope) error {
	return autoConvert_v1_BuildLog_To_build_BuildLog(in, out, s)
}

func autoConvert_build_BuildLog_To_v1_BuildLog(in *build.BuildLog, out *v1.BuildLog, s conversion.Scope) error {
	return nil
}

// Convert_build_BuildLog_To_v1_BuildLog is an autogenerated conversion function.
func Convert_build_BuildLog_To_v1_BuildLog(in *build.BuildLog, out *v1.BuildLog, s conversion.Scope) error {
	return autoConvert_build_BuildLog_To_v1_BuildLog(in, out, s)
}

func autoConvert_v1_BuildLogOptions_To_build_BuildLogOptions(in *v1.BuildLogOptions, out *build.BuildLogOptions, s conversion.Scope) error {
	out.Container = in.Container
	out.Follow = in.Follow
	out.Previous = in.Previous
	out.SinceSeconds = (*int64)(unsafe.Pointer(in.SinceSeconds))
	out.SinceTime = (*meta_v1.Time)(unsafe.Pointer(in.SinceTime))
	out.Timestamps = in.Timestamps
	out.TailLines = (*int64)(unsafe.Pointer(in.TailLines))
	out.LimitBytes = (*int64)(unsafe.Pointer(in.LimitBytes))
	out.NoWait = in.NoWait
	out.Version = (*int64)(unsafe.Pointer(in.Version))
	return nil
}

// Convert_v1_BuildLogOptions_To_build_BuildLogOptions is an autogenerated conversion function.
func Convert_v1_BuildLogOptions_To_build_BuildLogOptions(in *v1.BuildLogOptions, out *build.BuildLogOptions, s conversion.Scope) error {
	return autoConvert_v1_BuildLogOptions_To_build_BuildLogOptions(in, out, s)
}

func autoConvert_build_BuildLogOptions_To_v1_BuildLogOptions(in *build.BuildLogOptions, out *v1.BuildLogOptions, s conversion.Scope) error {
	out.Container = in.Container
	out.Follow = in.Follow
	out.Previous = in.Previous
	out.SinceSeconds = (*int64)(unsafe.Pointer(in.SinceSeconds))
	out.SinceTime = (*meta_v1.Time)(unsafe.Pointer(in.SinceTime))
	out.Timestamps = in.Timestamps
	out.TailLines = (*int64)(unsafe.Pointer(in.TailLines))
	out.LimitBytes = (*int64)(unsafe.Pointer(in.LimitBytes))
	out.NoWait = in.NoWait
	out.Version = (*int64)(unsafe.Pointer(in.Version))
	return nil
}

// Convert_build_BuildLogOptions_To_v1_BuildLogOptions is an autogenerated conversion function.
func Convert_build_BuildLogOptions_To_v1_BuildLogOptions(in *build.BuildLogOptions, out *v1.BuildLogOptions, s conversion.Scope) error {
	return autoConvert_build_BuildLogOptions_To_v1_BuildLogOptions(in, out, s)
}

func autoConvert_v1_BuildOutput_To_build_BuildOutput(in *v1.BuildOutput, out *build.BuildOutput, s conversion.Scope) error {
	if in.To != nil {
		in, out := &in.To, &out.To
		*out = new(core.ObjectReference)
		if err := core_v1.Convert_v1_ObjectReference_To_core_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.To = nil
	}
	if in.PushSecret != nil {
		in, out := &in.PushSecret, &out.PushSecret
		*out = new(core.LocalObjectReference)
		if err := core_v1.Convert_v1_LocalObjectReference_To_core_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PushSecret = nil
	}
	out.ImageLabels = *(*[]build.ImageLabel)(unsafe.Pointer(&in.ImageLabels))
	return nil
}

func autoConvert_build_BuildOutput_To_v1_BuildOutput(in *build.BuildOutput, out *v1.BuildOutput, s conversion.Scope) error {
	if in.To != nil {
		in, out := &in.To, &out.To
		*out = new(api_core_v1.ObjectReference)
		if err := core_v1.Convert_core_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.To = nil
	}
	if in.PushSecret != nil {
		in, out := &in.PushSecret, &out.PushSecret
		*out = new(api_core_v1.LocalObjectReference)
		if err := core_v1.Convert_core_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PushSecret = nil
	}
	out.ImageLabels = *(*[]v1.ImageLabel)(unsafe.Pointer(&in.ImageLabels))
	return nil
}

// Convert_build_BuildOutput_To_v1_BuildOutput is an autogenerated conversion function.
func Convert_build_BuildOutput_To_v1_BuildOutput(in *build.BuildOutput, out *v1.BuildOutput, s conversion.Scope) error {
	return autoConvert_build_BuildOutput_To_v1_BuildOutput(in, out, s)
}

func autoConvert_v1_BuildPostCommitSpec_To_build_BuildPostCommitSpec(in *v1.BuildPostCommitSpec, out *build.BuildPostCommitSpec, s conversion.Scope) error {
	out.Command = *(*[]string)(unsafe.Pointer(&in.Command))
	out.Args = *(*[]string)(unsafe.Pointer(&in.Args))
	out.Script = in.Script
	return nil
}

// Convert_v1_BuildPostCommitSpec_To_build_BuildPostCommitSpec is an autogenerated conversion function.
func Convert_v1_BuildPostCommitSpec_To_build_BuildPostCommitSpec(in *v1.BuildPostCommitSpec, out *build.BuildPostCommitSpec, s conversion.Scope) error {
	return autoConvert_v1_BuildPostCommitSpec_To_build_BuildPostCommitSpec(in, out, s)
}

func autoConvert_build_BuildPostCommitSpec_To_v1_BuildPostCommitSpec(in *build.BuildPostCommitSpec, out *v1.BuildPostCommitSpec, s conversion.Scope) error {
	out.Command = *(*[]string)(unsafe.Pointer(&in.Command))
	out.Args = *(*[]string)(unsafe.Pointer(&in.Args))
	out.Script = in.Script
	return nil
}

// Convert_build_BuildPostCommitSpec_To_v1_BuildPostCommitSpec is an autogenerated conversion function.
func Convert_build_BuildPostCommitSpec_To_v1_BuildPostCommitSpec(in *build.BuildPostCommitSpec, out *v1.BuildPostCommitSpec, s conversion.Scope) error {
	return autoConvert_build_BuildPostCommitSpec_To_v1_BuildPostCommitSpec(in, out, s)
}

func autoConvert_v1_BuildRequest_To_build_BuildRequest(in *v1.BuildRequest, out *build.BuildRequest, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(build.SourceRevision)
		if err := Convert_v1_SourceRevision_To_build_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	if in.TriggeredByImage != nil {
		in, out := &in.TriggeredByImage, &out.TriggeredByImage
		*out = new(core.ObjectReference)
		if err := core_v1.Convert_v1_ObjectReference_To_core_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.TriggeredByImage = nil
	}
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(core.ObjectReference)
		if err := core_v1.Convert_v1_ObjectReference_To_core_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	out.Binary = (*build.BinaryBuildSource)(unsafe.Pointer(in.Binary))
	out.LastVersion = (*int64)(unsafe.Pointer(in.LastVersion))
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]core.EnvVar, len(*in))
		for i := range *in {
			if err := core_v1.Convert_v1_EnvVar_To_core_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	if in.TriggeredBy != nil {
		in, out := &in.TriggeredBy, &out.TriggeredBy
		*out = make([]build.BuildTriggerCause, len(*in))
		for i := range *in {
			if err := Convert_v1_BuildTriggerCause_To_build_BuildTriggerCause(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.TriggeredBy = nil
	}
	if in.DockerStrategyOptions != nil {
		in, out := &in.DockerStrategyOptions, &out.DockerStrategyOptions
		*out = new(build.DockerStrategyOptions)
		if err := Convert_v1_DockerStrategyOptions_To_build_DockerStrategyOptions(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DockerStrategyOptions = nil
	}
	out.SourceStrategyOptions = (*build.SourceStrategyOptions)(unsafe.Pointer(in.SourceStrategyOptions))
	return nil
}

// Convert_v1_BuildRequest_To_build_BuildRequest is an autogenerated conversion function.
func Convert_v1_BuildRequest_To_build_BuildRequest(in *v1.BuildRequest, out *build.BuildRequest, s conversion.Scope) error {
	return autoConvert_v1_BuildRequest_To_build_BuildRequest(in, out, s)
}

func autoConvert_build_BuildRequest_To_v1_BuildRequest(in *build.BuildRequest, out *v1.BuildRequest, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(v1.SourceRevision)
		if err := Convert_build_SourceRevision_To_v1_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	if in.TriggeredByImage != nil {
		in, out := &in.TriggeredByImage, &out.TriggeredByImage
		*out = new(api_core_v1.ObjectReference)
		if err := core_v1.Convert_core_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.TriggeredByImage = nil
	}
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api_core_v1.ObjectReference)
		if err := core_v1.Convert_core_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	out.Binary = (*v1.BinaryBuildSource)(unsafe.Pointer(in.Binary))
	out.LastVersion = (*int64)(unsafe.Pointer(in.LastVersion))
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_core_v1.EnvVar, len(*in))
		for i := range *in {
			if err := core_v1.Convert_core_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	if in.TriggeredBy != nil {
		in, out := &in.TriggeredBy, &out.TriggeredBy
		*out = make([]v1.BuildTriggerCause, len(*in))
		for i := range *in {
			if err := Convert_build_BuildTriggerCause_To_v1_BuildTriggerCause(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.TriggeredBy = nil
	}
	if in.DockerStrategyOptions != nil {
		in, out := &in.DockerStrategyOptions, &out.DockerStrategyOptions
		*out = new(v1.DockerStrategyOptions)
		if err := Convert_build_DockerStrategyOptions_To_v1_DockerStrategyOptions(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DockerStrategyOptions = nil
	}
	out.SourceStrategyOptions = (*v1.SourceStrategyOptions)(unsafe.Pointer(in.SourceStrategyOptions))
	return nil
}

// Convert_build_BuildRequest_To_v1_BuildRequest is an autogenerated conversion function.
func Convert_build_BuildRequest_To_v1_BuildRequest(in *build.BuildRequest, out *v1.BuildRequest, s conversion.Scope) error {
	return autoConvert_build_BuildRequest_To_v1_BuildRequest(in, out, s)
}

func autoConvert_v1_BuildSource_To_build_BuildSource(in *v1.BuildSource, out *build.BuildSource, s conversion.Scope) error {
	// INFO: in.Type opted out of conversion generation
	out.Binary = (*build.BinaryBuildSource)(unsafe.Pointer(in.Binary))
	out.Dockerfile = (*string)(unsafe.Pointer(in.Dockerfile))
	out.Git = (*build.GitBuildSource)(unsafe.Pointer(in.Git))
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]build.ImageSource, len(*in))
		for i := range *in {
			if err := Convert_v1_ImageSource_To_build_ImageSource(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	out.ContextDir = in.ContextDir
	if in.SourceSecret != nil {
		in, out := &in.SourceSecret, &out.SourceSecret
		*out = new(core.LocalObjectReference)
		if err := core_v1.Convert_v1_LocalObjectReference_To_core_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SourceSecret = nil
	}
	if in.Secrets != nil {
		in, out := &in.Secrets, &out.Secrets
		*out = make([]build.SecretBuildSource, len(*in))
		for i := range *in {
			if err := Convert_v1_SecretBuildSource_To_build_SecretBuildSource(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Secrets = nil
	}
	if in.ConfigMaps != nil {
		in, out := &in.ConfigMaps, &out.ConfigMaps
		*out = make([]build.ConfigMapBuildSource, len(*in))
		for i := range *in {
			if err := Convert_v1_ConfigMapBuildSource_To_build_ConfigMapBuildSource(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.ConfigMaps = nil
	}
	return nil
}

// Convert_v1_BuildSource_To_build_BuildSource is an autogenerated conversion function.
func Convert_v1_BuildSource_To_build_BuildSource(in *v1.BuildSource, out *build.BuildSource, s conversion.Scope) error {
	return autoConvert_v1_BuildSource_To_build_BuildSource(in, out, s)
}

func autoConvert_build_BuildSource_To_v1_BuildSource(in *build.BuildSource, out *v1.BuildSource, s conversion.Scope) error {
	out.Binary = (*v1.BinaryBuildSource)(unsafe.Pointer(in.Binary))
	out.Dockerfile = (*string)(unsafe.Pointer(in.Dockerfile))
	out.Git = (*v1.GitBuildSource)(unsafe.Pointer(in.Git))
	if in.Images != nil {
		in, out := &in.Images, &out.Images
		*out = make([]v1.ImageSource, len(*in))
		for i := range *in {
			if err := Convert_build_ImageSource_To_v1_ImageSource(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Images = nil
	}
	out.ContextDir = in.ContextDir
	if in.SourceSecret != nil {
		in, out := &in.SourceSecret, &out.SourceSecret
		*out = new(api_core_v1.LocalObjectReference)
		if err := core_v1.Convert_core_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SourceSecret = nil
	}
	if in.Secrets != nil {
		in, out := &in.Secrets, &out.Secrets
		*out = make([]v1.SecretBuildSource, len(*in))
		for i := range *in {
			if err := Convert_build_SecretBuildSource_To_v1_SecretBuildSource(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Secrets = nil
	}
	if in.ConfigMaps != nil {
		in, out := &in.ConfigMaps, &out.ConfigMaps
		*out = make([]v1.ConfigMapBuildSource, len(*in))
		for i := range *in {
			if err := Convert_build_ConfigMapBuildSource_To_v1_ConfigMapBuildSource(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.ConfigMaps = nil
	}
	return nil
}

func autoConvert_v1_BuildSpec_To_build_BuildSpec(in *v1.BuildSpec, out *build.BuildSpec, s conversion.Scope) error {
	if err := Convert_v1_CommonSpec_To_build_CommonSpec(&in.CommonSpec, &out.CommonSpec, s); err != nil {
		return err
	}
	if in.TriggeredBy != nil {
		in, out := &in.TriggeredBy, &out.TriggeredBy
		*out = make([]build.BuildTriggerCause, len(*in))
		for i := range *in {
			if err := Convert_v1_BuildTriggerCause_To_build_BuildTriggerCause(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.TriggeredBy = nil
	}
	return nil
}

// Convert_v1_BuildSpec_To_build_BuildSpec is an autogenerated conversion function.
func Convert_v1_BuildSpec_To_build_BuildSpec(in *v1.BuildSpec, out *build.BuildSpec, s conversion.Scope) error {
	return autoConvert_v1_BuildSpec_To_build_BuildSpec(in, out, s)
}

func autoConvert_build_BuildSpec_To_v1_BuildSpec(in *build.BuildSpec, out *v1.BuildSpec, s conversion.Scope) error {
	if err := Convert_build_CommonSpec_To_v1_CommonSpec(&in.CommonSpec, &out.CommonSpec, s); err != nil {
		return err
	}
	if in.TriggeredBy != nil {
		in, out := &in.TriggeredBy, &out.TriggeredBy
		*out = make([]v1.BuildTriggerCause, len(*in))
		for i := range *in {
			if err := Convert_build_BuildTriggerCause_To_v1_BuildTriggerCause(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.TriggeredBy = nil
	}
	return nil
}

// Convert_build_BuildSpec_To_v1_BuildSpec is an autogenerated conversion function.
func Convert_build_BuildSpec_To_v1_BuildSpec(in *build.BuildSpec, out *v1.BuildSpec, s conversion.Scope) error {
	return autoConvert_build_BuildSpec_To_v1_BuildSpec(in, out, s)
}

func autoConvert_v1_BuildStatus_To_build_BuildStatus(in *v1.BuildStatus, out *build.BuildStatus, s conversion.Scope) error {
	out.Phase = build.BuildPhase(in.Phase)
	out.Cancelled = in.Cancelled
	out.Reason = build.StatusReason(in.Reason)
	out.Message = in.Message
	out.StartTimestamp = (*meta_v1.Time)(unsafe.Pointer(in.StartTimestamp))
	out.CompletionTimestamp = (*meta_v1.Time)(unsafe.Pointer(in.CompletionTimestamp))
	out.Duration = time.Duration(in.Duration)
	out.OutputDockerImageReference = in.OutputDockerImageReference
	if in.Config != nil {
		in, out := &in.Config, &out.Config
		*out = new(core.ObjectReference)
		if err := core_v1.Convert_v1_ObjectReference_To_core_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Config = nil
	}
	if err := Convert_v1_BuildStatusOutput_To_build_BuildStatusOutput(&in.Output, &out.Output, s); err != nil {
		return err
	}
	out.Stages = *(*[]build.StageInfo)(unsafe.Pointer(&in.Stages))
	out.LogSnippet = in.LogSnippet
	return nil
}

// Convert_v1_BuildStatus_To_build_BuildStatus is an autogenerated conversion function.
func Convert_v1_BuildStatus_To_build_BuildStatus(in *v1.BuildStatus, out *build.BuildStatus, s conversion.Scope) error {
	return autoConvert_v1_BuildStatus_To_build_BuildStatus(in, out, s)
}

func autoConvert_build_BuildStatus_To_v1_BuildStatus(in *build.BuildStatus, out *v1.BuildStatus, s conversion.Scope) error {
	out.Phase = v1.BuildPhase(in.Phase)
	out.Cancelled = in.Cancelled
	out.Reason = v1.StatusReason(in.Reason)
	out.Message = in.Message
	out.StartTimestamp = (*meta_v1.Time)(unsafe.Pointer(in.StartTimestamp))
	out.CompletionTimestamp = (*meta_v1.Time)(unsafe.Pointer(in.CompletionTimestamp))
	out.Duration = time.Duration(in.Duration)
	out.OutputDockerImageReference = in.OutputDockerImageReference
	if in.Config != nil {
		in, out := &in.Config, &out.Config
		*out = new(api_core_v1.ObjectReference)
		if err := core_v1.Convert_core_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Config = nil
	}
	if err := Convert_build_BuildStatusOutput_To_v1_BuildStatusOutput(&in.Output, &out.Output, s); err != nil {
		return err
	}
	out.Stages = *(*[]v1.StageInfo)(unsafe.Pointer(&in.Stages))
	out.LogSnippet = in.LogSnippet
	return nil
}

// Convert_build_BuildStatus_To_v1_BuildStatus is an autogenerated conversion function.
func Convert_build_BuildStatus_To_v1_BuildStatus(in *build.BuildStatus, out *v1.BuildStatus, s conversion.Scope) error {
	return autoConvert_build_BuildStatus_To_v1_BuildStatus(in, out, s)
}

func autoConvert_v1_BuildStatusOutput_To_build_BuildStatusOutput(in *v1.BuildStatusOutput, out *build.BuildStatusOutput, s conversion.Scope) error {
	out.To = (*build.BuildStatusOutputTo)(unsafe.Pointer(in.To))
	return nil
}

// Convert_v1_BuildStatusOutput_To_build_BuildStatusOutput is an autogenerated conversion function.
func Convert_v1_BuildStatusOutput_To_build_BuildStatusOutput(in *v1.BuildStatusOutput, out *build.BuildStatusOutput, s conversion.Scope) error {
	return autoConvert_v1_BuildStatusOutput_To_build_BuildStatusOutput(in, out, s)
}

func autoConvert_build_BuildStatusOutput_To_v1_BuildStatusOutput(in *build.BuildStatusOutput, out *v1.BuildStatusOutput, s conversion.Scope) error {
	out.To = (*v1.BuildStatusOutputTo)(unsafe.Pointer(in.To))
	return nil
}

// Convert_build_BuildStatusOutput_To_v1_BuildStatusOutput is an autogenerated conversion function.
func Convert_build_BuildStatusOutput_To_v1_BuildStatusOutput(in *build.BuildStatusOutput, out *v1.BuildStatusOutput, s conversion.Scope) error {
	return autoConvert_build_BuildStatusOutput_To_v1_BuildStatusOutput(in, out, s)
}

func autoConvert_v1_BuildStatusOutputTo_To_build_BuildStatusOutputTo(in *v1.BuildStatusOutputTo, out *build.BuildStatusOutputTo, s conversion.Scope) error {
	out.ImageDigest = in.ImageDigest
	return nil
}

// Convert_v1_BuildStatusOutputTo_To_build_BuildStatusOutputTo is an autogenerated conversion function.
func Convert_v1_BuildStatusOutputTo_To_build_BuildStatusOutputTo(in *v1.BuildStatusOutputTo, out *build.BuildStatusOutputTo, s conversion.Scope) error {
	return autoConvert_v1_BuildStatusOutputTo_To_build_BuildStatusOutputTo(in, out, s)
}

func autoConvert_build_BuildStatusOutputTo_To_v1_BuildStatusOutputTo(in *build.BuildStatusOutputTo, out *v1.BuildStatusOutputTo, s conversion.Scope) error {
	out.ImageDigest = in.ImageDigest
	return nil
}

// Convert_build_BuildStatusOutputTo_To_v1_BuildStatusOutputTo is an autogenerated conversion function.
func Convert_build_BuildStatusOutputTo_To_v1_BuildStatusOutputTo(in *build.BuildStatusOutputTo, out *v1.BuildStatusOutputTo, s conversion.Scope) error {
	return autoConvert_build_BuildStatusOutputTo_To_v1_BuildStatusOutputTo(in, out, s)
}

func autoConvert_v1_BuildStrategy_To_build_BuildStrategy(in *v1.BuildStrategy, out *build.BuildStrategy, s conversion.Scope) error {
	// INFO: in.Type opted out of conversion generation
	if in.DockerStrategy != nil {
		in, out := &in.DockerStrategy, &out.DockerStrategy
		*out = new(build.DockerBuildStrategy)
		if err := Convert_v1_DockerBuildStrategy_To_build_DockerBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DockerStrategy = nil
	}
	if in.SourceStrategy != nil {
		in, out := &in.SourceStrategy, &out.SourceStrategy
		*out = new(build.SourceBuildStrategy)
		if err := Convert_v1_SourceBuildStrategy_To_build_SourceBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SourceStrategy = nil
	}
	if in.CustomStrategy != nil {
		in, out := &in.CustomStrategy, &out.CustomStrategy
		*out = new(build.CustomBuildStrategy)
		if err := Convert_v1_CustomBuildStrategy_To_build_CustomBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CustomStrategy = nil
	}
	if in.JenkinsPipelineStrategy != nil {
		in, out := &in.JenkinsPipelineStrategy, &out.JenkinsPipelineStrategy
		*out = new(build.JenkinsPipelineBuildStrategy)
		if err := Convert_v1_JenkinsPipelineBuildStrategy_To_build_JenkinsPipelineBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.JenkinsPipelineStrategy = nil
	}
	return nil
}

// Convert_v1_BuildStrategy_To_build_BuildStrategy is an autogenerated conversion function.
func Convert_v1_BuildStrategy_To_build_BuildStrategy(in *v1.BuildStrategy, out *build.BuildStrategy, s conversion.Scope) error {
	return autoConvert_v1_BuildStrategy_To_build_BuildStrategy(in, out, s)
}

func autoConvert_build_BuildStrategy_To_v1_BuildStrategy(in *build.BuildStrategy, out *v1.BuildStrategy, s conversion.Scope) error {
	if in.DockerStrategy != nil {
		in, out := &in.DockerStrategy, &out.DockerStrategy
		*out = new(v1.DockerBuildStrategy)
		if err := Convert_build_DockerBuildStrategy_To_v1_DockerBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DockerStrategy = nil
	}
	if in.SourceStrategy != nil {
		in, out := &in.SourceStrategy, &out.SourceStrategy
		*out = new(v1.SourceBuildStrategy)
		if err := Convert_build_SourceBuildStrategy_To_v1_SourceBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.SourceStrategy = nil
	}
	if in.CustomStrategy != nil {
		in, out := &in.CustomStrategy, &out.CustomStrategy
		*out = new(v1.CustomBuildStrategy)
		if err := Convert_build_CustomBuildStrategy_To_v1_CustomBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.CustomStrategy = nil
	}
	if in.JenkinsPipelineStrategy != nil {
		in, out := &in.JenkinsPipelineStrategy, &out.JenkinsPipelineStrategy
		*out = new(v1.JenkinsPipelineBuildStrategy)
		if err := Convert_build_JenkinsPipelineBuildStrategy_To_v1_JenkinsPipelineBuildStrategy(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.JenkinsPipelineStrategy = nil
	}
	return nil
}

func autoConvert_v1_BuildTriggerCause_To_build_BuildTriggerCause(in *v1.BuildTriggerCause, out *build.BuildTriggerCause, s conversion.Scope) error {
	out.Message = in.Message
	if in.GenericWebHook != nil {
		in, out := &in.GenericWebHook, &out.GenericWebHook
		*out = new(build.GenericWebHookCause)
		if err := Convert_v1_GenericWebHookCause_To_build_GenericWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GenericWebHook = nil
	}
	if in.GitHubWebHook != nil {
		in, out := &in.GitHubWebHook, &out.GitHubWebHook
		*out = new(build.GitHubWebHookCause)
		if err := Convert_v1_GitHubWebHookCause_To_build_GitHubWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GitHubWebHook = nil
	}
	if in.ImageChangeBuild != nil {
		in, out := &in.ImageChangeBuild, &out.ImageChangeBuild
		*out = new(build.ImageChangeCause)
		if err := Convert_v1_ImageChangeCause_To_build_ImageChangeCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ImageChangeBuild = nil
	}
	if in.GitLabWebHook != nil {
		in, out := &in.GitLabWebHook, &out.GitLabWebHook
		*out = new(build.GitLabWebHookCause)
		if err := Convert_v1_GitLabWebHookCause_To_build_GitLabWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GitLabWebHook = nil
	}
	if in.BitbucketWebHook != nil {
		in, out := &in.BitbucketWebHook, &out.BitbucketWebHook
		*out = new(build.BitbucketWebHookCause)
		if err := Convert_v1_BitbucketWebHookCause_To_build_BitbucketWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.BitbucketWebHook = nil
	}
	return nil
}

// Convert_v1_BuildTriggerCause_To_build_BuildTriggerCause is an autogenerated conversion function.
func Convert_v1_BuildTriggerCause_To_build_BuildTriggerCause(in *v1.BuildTriggerCause, out *build.BuildTriggerCause, s conversion.Scope) error {
	return autoConvert_v1_BuildTriggerCause_To_build_BuildTriggerCause(in, out, s)
}

func autoConvert_build_BuildTriggerCause_To_v1_BuildTriggerCause(in *build.BuildTriggerCause, out *v1.BuildTriggerCause, s conversion.Scope) error {
	out.Message = in.Message
	if in.GenericWebHook != nil {
		in, out := &in.GenericWebHook, &out.GenericWebHook
		*out = new(v1.GenericWebHookCause)
		if err := Convert_build_GenericWebHookCause_To_v1_GenericWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GenericWebHook = nil
	}
	if in.GitHubWebHook != nil {
		in, out := &in.GitHubWebHook, &out.GitHubWebHook
		*out = new(v1.GitHubWebHookCause)
		if err := Convert_build_GitHubWebHookCause_To_v1_GitHubWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GitHubWebHook = nil
	}
	if in.ImageChangeBuild != nil {
		in, out := &in.ImageChangeBuild, &out.ImageChangeBuild
		*out = new(v1.ImageChangeCause)
		if err := Convert_build_ImageChangeCause_To_v1_ImageChangeCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ImageChangeBuild = nil
	}
	if in.GitLabWebHook != nil {
		in, out := &in.GitLabWebHook, &out.GitLabWebHook
		*out = new(v1.GitLabWebHookCause)
		if err := Convert_build_GitLabWebHookCause_To_v1_GitLabWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.GitLabWebHook = nil
	}
	if in.BitbucketWebHook != nil {
		in, out := &in.BitbucketWebHook, &out.BitbucketWebHook
		*out = new(v1.BitbucketWebHookCause)
		if err := Convert_build_BitbucketWebHookCause_To_v1_BitbucketWebHookCause(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.BitbucketWebHook = nil
	}
	return nil
}

// Convert_build_BuildTriggerCause_To_v1_BuildTriggerCause is an autogenerated conversion function.
func Convert_build_BuildTriggerCause_To_v1_BuildTriggerCause(in *build.BuildTriggerCause, out *v1.BuildTriggerCause, s conversion.Scope) error {
	return autoConvert_build_BuildTriggerCause_To_v1_BuildTriggerCause(in, out, s)
}

func autoConvert_v1_BuildTriggerPolicy_To_build_BuildTriggerPolicy(in *v1.BuildTriggerPolicy, out *build.BuildTriggerPolicy, s conversion.Scope) error {
	out.Type = build.BuildTriggerType(in.Type)
	out.GitHubWebHook = (*build.WebHookTrigger)(unsafe.Pointer(in.GitHubWebHook))
	out.GenericWebHook = (*build.WebHookTrigger)(unsafe.Pointer(in.GenericWebHook))
	if in.ImageChange != nil {
		in, out := &in.ImageChange, &out.ImageChange
		*out = new(build.ImageChangeTrigger)
		if err := Convert_v1_ImageChangeTrigger_To_build_ImageChangeTrigger(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ImageChange = nil
	}
	out.GitLabWebHook = (*build.WebHookTrigger)(unsafe.Pointer(in.GitLabWebHook))
	out.BitbucketWebHook = (*build.WebHookTrigger)(unsafe.Pointer(in.BitbucketWebHook))
	return nil
}

func autoConvert_build_BuildTriggerPolicy_To_v1_BuildTriggerPolicy(in *build.BuildTriggerPolicy, out *v1.BuildTriggerPolicy, s conversion.Scope) error {
	out.Type = v1.BuildTriggerType(in.Type)
	out.GitHubWebHook = (*v1.WebHookTrigger)(unsafe.Pointer(in.GitHubWebHook))
	out.GenericWebHook = (*v1.WebHookTrigger)(unsafe.Pointer(in.GenericWebHook))
	if in.ImageChange != nil {
		in, out := &in.ImageChange, &out.ImageChange
		*out = new(v1.ImageChangeTrigger)
		if err := Convert_build_ImageChangeTrigger_To_v1_ImageChangeTrigger(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.ImageChange = nil
	}
	out.GitLabWebHook = (*v1.WebHookTrigger)(unsafe.Pointer(in.GitLabWebHook))
	out.BitbucketWebHook = (*v1.WebHookTrigger)(unsafe.Pointer(in.BitbucketWebHook))
	return nil
}

// Convert_build_BuildTriggerPolicy_To_v1_BuildTriggerPolicy is an autogenerated conversion function.
func Convert_build_BuildTriggerPolicy_To_v1_BuildTriggerPolicy(in *build.BuildTriggerPolicy, out *v1.BuildTriggerPolicy, s conversion.Scope) error {
	return autoConvert_build_BuildTriggerPolicy_To_v1_BuildTriggerPolicy(in, out, s)
}

func autoConvert_v1_CommonSpec_To_build_CommonSpec(in *v1.CommonSpec, out *build.CommonSpec, s conversion.Scope) error {
	out.ServiceAccount = in.ServiceAccount
	if err := Convert_v1_BuildSource_To_build_BuildSource(&in.Source, &out.Source, s); err != nil {
		return err
	}
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(build.SourceRevision)
		if err := Convert_v1_SourceRevision_To_build_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	if err := Convert_v1_BuildStrategy_To_build_BuildStrategy(&in.Strategy, &out.Strategy, s); err != nil {
		return err
	}
	if err := Convert_v1_BuildOutput_To_build_BuildOutput(&in.Output, &out.Output, s); err != nil {
		return err
	}
	if err := core_v1.Convert_v1_ResourceRequirements_To_core_ResourceRequirements(&in.Resources, &out.Resources, s); err != nil {
		return err
	}
	if err := Convert_v1_BuildPostCommitSpec_To_build_BuildPostCommitSpec(&in.PostCommit, &out.PostCommit, s); err != nil {
		return err
	}
	out.CompletionDeadlineSeconds = (*int64)(unsafe.Pointer(in.CompletionDeadlineSeconds))
	out.NodeSelector = *(*map[string]string)(unsafe.Pointer(&in.NodeSelector))
	return nil
}

// Convert_v1_CommonSpec_To_build_CommonSpec is an autogenerated conversion function.
func Convert_v1_CommonSpec_To_build_CommonSpec(in *v1.CommonSpec, out *build.CommonSpec, s conversion.Scope) error {
	return autoConvert_v1_CommonSpec_To_build_CommonSpec(in, out, s)
}

func autoConvert_build_CommonSpec_To_v1_CommonSpec(in *build.CommonSpec, out *v1.CommonSpec, s conversion.Scope) error {
	out.ServiceAccount = in.ServiceAccount
	if err := Convert_build_BuildSource_To_v1_BuildSource(&in.Source, &out.Source, s); err != nil {
		return err
	}
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(v1.SourceRevision)
		if err := Convert_build_SourceRevision_To_v1_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	if err := Convert_build_BuildStrategy_To_v1_BuildStrategy(&in.Strategy, &out.Strategy, s); err != nil {
		return err
	}
	if err := Convert_build_BuildOutput_To_v1_BuildOutput(&in.Output, &out.Output, s); err != nil {
		return err
	}
	if err := core_v1.Convert_core_ResourceRequirements_To_v1_ResourceRequirements(&in.Resources, &out.Resources, s); err != nil {
		return err
	}
	if err := Convert_build_BuildPostCommitSpec_To_v1_BuildPostCommitSpec(&in.PostCommit, &out.PostCommit, s); err != nil {
		return err
	}
	out.CompletionDeadlineSeconds = (*int64)(unsafe.Pointer(in.CompletionDeadlineSeconds))
	out.NodeSelector = *(*v1.OptionalNodeSelector)(unsafe.Pointer(&in.NodeSelector))
	return nil
}

// Convert_build_CommonSpec_To_v1_CommonSpec is an autogenerated conversion function.
func Convert_build_CommonSpec_To_v1_CommonSpec(in *build.CommonSpec, out *v1.CommonSpec, s conversion.Scope) error {
	return autoConvert_build_CommonSpec_To_v1_CommonSpec(in, out, s)
}

func autoConvert_v1_CommonWebHookCause_To_build_CommonWebHookCause(in *v1.CommonWebHookCause, out *build.CommonWebHookCause, s conversion.Scope) error {
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(build.SourceRevision)
		if err := Convert_v1_SourceRevision_To_build_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	out.Secret = in.Secret
	return nil
}

// Convert_v1_CommonWebHookCause_To_build_CommonWebHookCause is an autogenerated conversion function.
func Convert_v1_CommonWebHookCause_To_build_CommonWebHookCause(in *v1.CommonWebHookCause, out *build.CommonWebHookCause, s conversion.Scope) error {
	return autoConvert_v1_CommonWebHookCause_To_build_CommonWebHookCause(in, out, s)
}

func autoConvert_build_CommonWebHookCause_To_v1_CommonWebHookCause(in *build.CommonWebHookCause, out *v1.CommonWebHookCause, s conversion.Scope) error {
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(v1.SourceRevision)
		if err := Convert_build_SourceRevision_To_v1_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	out.Secret = in.Secret
	return nil
}

// Convert_build_CommonWebHookCause_To_v1_CommonWebHookCause is an autogenerated conversion function.
func Convert_build_CommonWebHookCause_To_v1_CommonWebHookCause(in *build.CommonWebHookCause, out *v1.CommonWebHookCause, s conversion.Scope) error {
	return autoConvert_build_CommonWebHookCause_To_v1_CommonWebHookCause(in, out, s)
}

func autoConvert_v1_ConfigMapBuildSource_To_build_ConfigMapBuildSource(in *v1.ConfigMapBuildSource, out *build.ConfigMapBuildSource, s conversion.Scope) error {
	if err := core_v1.Convert_v1_LocalObjectReference_To_core_LocalObjectReference(&in.ConfigMap, &out.ConfigMap, s); err != nil {
		return err
	}
	out.DestinationDir = in.DestinationDir
	return nil
}

// Convert_v1_ConfigMapBuildSource_To_build_ConfigMapBuildSource is an autogenerated conversion function.
func Convert_v1_ConfigMapBuildSource_To_build_ConfigMapBuildSource(in *v1.ConfigMapBuildSource, out *build.ConfigMapBuildSource, s conversion.Scope) error {
	return autoConvert_v1_ConfigMapBuildSource_To_build_ConfigMapBuildSource(in, out, s)
}

func autoConvert_build_ConfigMapBuildSource_To_v1_ConfigMapBuildSource(in *build.ConfigMapBuildSource, out *v1.ConfigMapBuildSource, s conversion.Scope) error {
	if err := core_v1.Convert_core_LocalObjectReference_To_v1_LocalObjectReference(&in.ConfigMap, &out.ConfigMap, s); err != nil {
		return err
	}
	out.DestinationDir = in.DestinationDir
	return nil
}

// Convert_build_ConfigMapBuildSource_To_v1_ConfigMapBuildSource is an autogenerated conversion function.
func Convert_build_ConfigMapBuildSource_To_v1_ConfigMapBuildSource(in *build.ConfigMapBuildSource, out *v1.ConfigMapBuildSource, s conversion.Scope) error {
	return autoConvert_build_ConfigMapBuildSource_To_v1_ConfigMapBuildSource(in, out, s)
}

func autoConvert_v1_CustomBuildStrategy_To_build_CustomBuildStrategy(in *v1.CustomBuildStrategy, out *build.CustomBuildStrategy, s conversion.Scope) error {
	if err := core_v1.Convert_v1_ObjectReference_To_core_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(core.LocalObjectReference)
		if err := core_v1.Convert_v1_LocalObjectReference_To_core_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]core.EnvVar, len(*in))
		for i := range *in {
			if err := core_v1.Convert_v1_EnvVar_To_core_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.ExposeDockerSocket = in.ExposeDockerSocket
	out.ForcePull = in.ForcePull
	if in.Secrets != nil {
		in, out := &in.Secrets, &out.Secrets
		*out = make([]build.SecretSpec, len(*in))
		for i := range *in {
			if err := Convert_v1_SecretSpec_To_build_SecretSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Secrets = nil
	}
	out.BuildAPIVersion = in.BuildAPIVersion
	return nil
}

func autoConvert_build_CustomBuildStrategy_To_v1_CustomBuildStrategy(in *build.CustomBuildStrategy, out *v1.CustomBuildStrategy, s conversion.Scope) error {
	if err := core_v1.Convert_core_ObjectReference_To_v1_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api_core_v1.LocalObjectReference)
		if err := core_v1.Convert_core_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_core_v1.EnvVar, len(*in))
		for i := range *in {
			if err := core_v1.Convert_core_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.ExposeDockerSocket = in.ExposeDockerSocket
	out.ForcePull = in.ForcePull
	if in.Secrets != nil {
		in, out := &in.Secrets, &out.Secrets
		*out = make([]v1.SecretSpec, len(*in))
		for i := range *in {
			if err := Convert_build_SecretSpec_To_v1_SecretSpec(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Secrets = nil
	}
	out.BuildAPIVersion = in.BuildAPIVersion
	return nil
}

// Convert_build_CustomBuildStrategy_To_v1_CustomBuildStrategy is an autogenerated conversion function.
func Convert_build_CustomBuildStrategy_To_v1_CustomBuildStrategy(in *build.CustomBuildStrategy, out *v1.CustomBuildStrategy, s conversion.Scope) error {
	return autoConvert_build_CustomBuildStrategy_To_v1_CustomBuildStrategy(in, out, s)
}

func autoConvert_v1_DockerBuildStrategy_To_build_DockerBuildStrategy(in *v1.DockerBuildStrategy, out *build.DockerBuildStrategy, s conversion.Scope) error {
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(core.ObjectReference)
		if err := core_v1.Convert_v1_ObjectReference_To_core_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(core.LocalObjectReference)
		if err := core_v1.Convert_v1_LocalObjectReference_To_core_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	out.NoCache = in.NoCache
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]core.EnvVar, len(*in))
		for i := range *in {
			if err := core_v1.Convert_v1_EnvVar_To_core_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.ForcePull = in.ForcePull
	out.DockerfilePath = in.DockerfilePath
	if in.BuildArgs != nil {
		in, out := &in.BuildArgs, &out.BuildArgs
		*out = make([]core.EnvVar, len(*in))
		for i := range *in {
			if err := core_v1.Convert_v1_EnvVar_To_core_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.BuildArgs = nil
	}
	out.ImageOptimizationPolicy = (*build.ImageOptimizationPolicy)(unsafe.Pointer(in.ImageOptimizationPolicy))
	return nil
}

func autoConvert_build_DockerBuildStrategy_To_v1_DockerBuildStrategy(in *build.DockerBuildStrategy, out *v1.DockerBuildStrategy, s conversion.Scope) error {
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api_core_v1.ObjectReference)
		if err := core_v1.Convert_core_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api_core_v1.LocalObjectReference)
		if err := core_v1.Convert_core_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	out.NoCache = in.NoCache
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_core_v1.EnvVar, len(*in))
		for i := range *in {
			if err := core_v1.Convert_core_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	if in.BuildArgs != nil {
		in, out := &in.BuildArgs, &out.BuildArgs
		*out = make([]api_core_v1.EnvVar, len(*in))
		for i := range *in {
			if err := core_v1.Convert_core_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.BuildArgs = nil
	}
	out.ForcePull = in.ForcePull
	out.DockerfilePath = in.DockerfilePath
	out.ImageOptimizationPolicy = (*v1.ImageOptimizationPolicy)(unsafe.Pointer(in.ImageOptimizationPolicy))
	return nil
}

// Convert_build_DockerBuildStrategy_To_v1_DockerBuildStrategy is an autogenerated conversion function.
func Convert_build_DockerBuildStrategy_To_v1_DockerBuildStrategy(in *build.DockerBuildStrategy, out *v1.DockerBuildStrategy, s conversion.Scope) error {
	return autoConvert_build_DockerBuildStrategy_To_v1_DockerBuildStrategy(in, out, s)
}

func autoConvert_v1_DockerStrategyOptions_To_build_DockerStrategyOptions(in *v1.DockerStrategyOptions, out *build.DockerStrategyOptions, s conversion.Scope) error {
	if in.BuildArgs != nil {
		in, out := &in.BuildArgs, &out.BuildArgs
		*out = make([]core.EnvVar, len(*in))
		for i := range *in {
			if err := core_v1.Convert_v1_EnvVar_To_core_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.BuildArgs = nil
	}
	out.NoCache = (*bool)(unsafe.Pointer(in.NoCache))
	return nil
}

// Convert_v1_DockerStrategyOptions_To_build_DockerStrategyOptions is an autogenerated conversion function.
func Convert_v1_DockerStrategyOptions_To_build_DockerStrategyOptions(in *v1.DockerStrategyOptions, out *build.DockerStrategyOptions, s conversion.Scope) error {
	return autoConvert_v1_DockerStrategyOptions_To_build_DockerStrategyOptions(in, out, s)
}

func autoConvert_build_DockerStrategyOptions_To_v1_DockerStrategyOptions(in *build.DockerStrategyOptions, out *v1.DockerStrategyOptions, s conversion.Scope) error {
	if in.BuildArgs != nil {
		in, out := &in.BuildArgs, &out.BuildArgs
		*out = make([]api_core_v1.EnvVar, len(*in))
		for i := range *in {
			if err := core_v1.Convert_core_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.BuildArgs = nil
	}
	out.NoCache = (*bool)(unsafe.Pointer(in.NoCache))
	return nil
}

// Convert_build_DockerStrategyOptions_To_v1_DockerStrategyOptions is an autogenerated conversion function.
func Convert_build_DockerStrategyOptions_To_v1_DockerStrategyOptions(in *build.DockerStrategyOptions, out *v1.DockerStrategyOptions, s conversion.Scope) error {
	return autoConvert_build_DockerStrategyOptions_To_v1_DockerStrategyOptions(in, out, s)
}

func autoConvert_v1_GenericWebHookCause_To_build_GenericWebHookCause(in *v1.GenericWebHookCause, out *build.GenericWebHookCause, s conversion.Scope) error {
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(build.SourceRevision)
		if err := Convert_v1_SourceRevision_To_build_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	out.Secret = in.Secret
	return nil
}

// Convert_v1_GenericWebHookCause_To_build_GenericWebHookCause is an autogenerated conversion function.
func Convert_v1_GenericWebHookCause_To_build_GenericWebHookCause(in *v1.GenericWebHookCause, out *build.GenericWebHookCause, s conversion.Scope) error {
	return autoConvert_v1_GenericWebHookCause_To_build_GenericWebHookCause(in, out, s)
}

func autoConvert_build_GenericWebHookCause_To_v1_GenericWebHookCause(in *build.GenericWebHookCause, out *v1.GenericWebHookCause, s conversion.Scope) error {
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(v1.SourceRevision)
		if err := Convert_build_SourceRevision_To_v1_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	out.Secret = in.Secret
	return nil
}

// Convert_build_GenericWebHookCause_To_v1_GenericWebHookCause is an autogenerated conversion function.
func Convert_build_GenericWebHookCause_To_v1_GenericWebHookCause(in *build.GenericWebHookCause, out *v1.GenericWebHookCause, s conversion.Scope) error {
	return autoConvert_build_GenericWebHookCause_To_v1_GenericWebHookCause(in, out, s)
}

func autoConvert_v1_GenericWebHookEvent_To_build_GenericWebHookEvent(in *v1.GenericWebHookEvent, out *build.GenericWebHookEvent, s conversion.Scope) error {
	// INFO: in.Type opted out of conversion generation
	out.Git = (*build.GitInfo)(unsafe.Pointer(in.Git))
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]core.EnvVar, len(*in))
		for i := range *in {
			if err := core_v1.Convert_v1_EnvVar_To_core_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	if in.DockerStrategyOptions != nil {
		in, out := &in.DockerStrategyOptions, &out.DockerStrategyOptions
		*out = new(build.DockerStrategyOptions)
		if err := Convert_v1_DockerStrategyOptions_To_build_DockerStrategyOptions(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DockerStrategyOptions = nil
	}
	return nil
}

// Convert_v1_GenericWebHookEvent_To_build_GenericWebHookEvent is an autogenerated conversion function.
func Convert_v1_GenericWebHookEvent_To_build_GenericWebHookEvent(in *v1.GenericWebHookEvent, out *build.GenericWebHookEvent, s conversion.Scope) error {
	return autoConvert_v1_GenericWebHookEvent_To_build_GenericWebHookEvent(in, out, s)
}

func autoConvert_build_GenericWebHookEvent_To_v1_GenericWebHookEvent(in *build.GenericWebHookEvent, out *v1.GenericWebHookEvent, s conversion.Scope) error {
	out.Git = (*v1.GitInfo)(unsafe.Pointer(in.Git))
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_core_v1.EnvVar, len(*in))
		for i := range *in {
			if err := core_v1.Convert_core_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	if in.DockerStrategyOptions != nil {
		in, out := &in.DockerStrategyOptions, &out.DockerStrategyOptions
		*out = new(v1.DockerStrategyOptions)
		if err := Convert_build_DockerStrategyOptions_To_v1_DockerStrategyOptions(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.DockerStrategyOptions = nil
	}
	return nil
}

// Convert_build_GenericWebHookEvent_To_v1_GenericWebHookEvent is an autogenerated conversion function.
func Convert_build_GenericWebHookEvent_To_v1_GenericWebHookEvent(in *build.GenericWebHookEvent, out *v1.GenericWebHookEvent, s conversion.Scope) error {
	return autoConvert_build_GenericWebHookEvent_To_v1_GenericWebHookEvent(in, out, s)
}

func autoConvert_v1_GitBuildSource_To_build_GitBuildSource(in *v1.GitBuildSource, out *build.GitBuildSource, s conversion.Scope) error {
	out.URI = in.URI
	out.Ref = in.Ref
	if err := Convert_v1_ProxyConfig_To_build_ProxyConfig(&in.ProxyConfig, &out.ProxyConfig, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_GitBuildSource_To_build_GitBuildSource is an autogenerated conversion function.
func Convert_v1_GitBuildSource_To_build_GitBuildSource(in *v1.GitBuildSource, out *build.GitBuildSource, s conversion.Scope) error {
	return autoConvert_v1_GitBuildSource_To_build_GitBuildSource(in, out, s)
}

func autoConvert_build_GitBuildSource_To_v1_GitBuildSource(in *build.GitBuildSource, out *v1.GitBuildSource, s conversion.Scope) error {
	out.URI = in.URI
	out.Ref = in.Ref
	if err := Convert_build_ProxyConfig_To_v1_ProxyConfig(&in.ProxyConfig, &out.ProxyConfig, s); err != nil {
		return err
	}
	return nil
}

// Convert_build_GitBuildSource_To_v1_GitBuildSource is an autogenerated conversion function.
func Convert_build_GitBuildSource_To_v1_GitBuildSource(in *build.GitBuildSource, out *v1.GitBuildSource, s conversion.Scope) error {
	return autoConvert_build_GitBuildSource_To_v1_GitBuildSource(in, out, s)
}

func autoConvert_v1_GitHubWebHookCause_To_build_GitHubWebHookCause(in *v1.GitHubWebHookCause, out *build.GitHubWebHookCause, s conversion.Scope) error {
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(build.SourceRevision)
		if err := Convert_v1_SourceRevision_To_build_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	out.Secret = in.Secret
	return nil
}

// Convert_v1_GitHubWebHookCause_To_build_GitHubWebHookCause is an autogenerated conversion function.
func Convert_v1_GitHubWebHookCause_To_build_GitHubWebHookCause(in *v1.GitHubWebHookCause, out *build.GitHubWebHookCause, s conversion.Scope) error {
	return autoConvert_v1_GitHubWebHookCause_To_build_GitHubWebHookCause(in, out, s)
}

func autoConvert_build_GitHubWebHookCause_To_v1_GitHubWebHookCause(in *build.GitHubWebHookCause, out *v1.GitHubWebHookCause, s conversion.Scope) error {
	if in.Revision != nil {
		in, out := &in.Revision, &out.Revision
		*out = new(v1.SourceRevision)
		if err := Convert_build_SourceRevision_To_v1_SourceRevision(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.Revision = nil
	}
	out.Secret = in.Secret
	return nil
}

// Convert_build_GitHubWebHookCause_To_v1_GitHubWebHookCause is an autogenerated conversion function.
func Convert_build_GitHubWebHookCause_To_v1_GitHubWebHookCause(in *build.GitHubWebHookCause, out *v1.GitHubWebHookCause, s conversion.Scope) error {
	return autoConvert_build_GitHubWebHookCause_To_v1_GitHubWebHookCause(in, out, s)
}

func autoConvert_v1_GitInfo_To_build_GitInfo(in *v1.GitInfo, out *build.GitInfo, s conversion.Scope) error {
	if err := Convert_v1_GitBuildSource_To_build_GitBuildSource(&in.GitBuildSource, &out.GitBuildSource, s); err != nil {
		return err
	}
	if err := Convert_v1_GitSourceRevision_To_build_GitSourceRevision(&in.GitSourceRevision, &out.GitSourceRevision, s); err != nil {
		return err
	}
	out.Refs = *(*[]build.GitRefInfo)(unsafe.Pointer(&in.Refs))
	return nil
}

// Convert_v1_GitInfo_To_build_GitInfo is an autogenerated conversion function.
func Convert_v1_GitInfo_To_build_GitInfo(in *v1.GitInfo, out *build.GitInfo, s conversion.Scope) error {
	return autoConvert_v1_GitInfo_To_build_GitInfo(in, out, s)
}

func autoConvert_build_GitInfo_To_v1_GitInfo(in *build.GitInfo, out *v1.GitInfo, s conversion.Scope) error {
	if err := Convert_build_GitBuildSource_To_v1_GitBuildSource(&in.GitBuildSource, &out.GitBuildSource, s); err != nil {
		return err
	}
	if err := Convert_build_GitSourceRevision_To_v1_GitSourceRevision(&in.GitSourceRevision, &out.GitSourceRevision, s); err != nil {
		return err
	}
	out.Refs = *(*[]v1.GitRefInfo)(unsafe.Pointer(&in.Refs))
	return nil
}

// Convert_build_GitInfo_To_v1_GitInfo is an autogenerated conversion function.
func Convert_build_GitInfo_To_v1_GitInfo(in *build.GitInfo, out *v1.GitInfo, s conversion.Scope) error {
	return autoConvert_build_GitInfo_To_v1_GitInfo(in, out, s)
}

func autoConvert_v1_GitLabWebHookCause_To_build_GitLabWebHookCause(in *v1.GitLabWebHookCause, out *build.GitLabWebHookCause, s conversion.Scope) error {
	if err := Convert_v1_CommonWebHookCause_To_build_CommonWebHookCause(&in.CommonWebHookCause, &out.CommonWebHookCause, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_GitLabWebHookCause_To_build_GitLabWebHookCause is an autogenerated conversion function.
func Convert_v1_GitLabWebHookCause_To_build_GitLabWebHookCause(in *v1.GitLabWebHookCause, out *build.GitLabWebHookCause, s conversion.Scope) error {
	return autoConvert_v1_GitLabWebHookCause_To_build_GitLabWebHookCause(in, out, s)
}

func autoConvert_build_GitLabWebHookCause_To_v1_GitLabWebHookCause(in *build.GitLabWebHookCause, out *v1.GitLabWebHookCause, s conversion.Scope) error {
	if err := Convert_build_CommonWebHookCause_To_v1_CommonWebHookCause(&in.CommonWebHookCause, &out.CommonWebHookCause, s); err != nil {
		return err
	}
	return nil
}

// Convert_build_GitLabWebHookCause_To_v1_GitLabWebHookCause is an autogenerated conversion function.
func Convert_build_GitLabWebHookCause_To_v1_GitLabWebHookCause(in *build.GitLabWebHookCause, out *v1.GitLabWebHookCause, s conversion.Scope) error {
	return autoConvert_build_GitLabWebHookCause_To_v1_GitLabWebHookCause(in, out, s)
}

func autoConvert_v1_GitRefInfo_To_build_GitRefInfo(in *v1.GitRefInfo, out *build.GitRefInfo, s conversion.Scope) error {
	if err := Convert_v1_GitBuildSource_To_build_GitBuildSource(&in.GitBuildSource, &out.GitBuildSource, s); err != nil {
		return err
	}
	if err := Convert_v1_GitSourceRevision_To_build_GitSourceRevision(&in.GitSourceRevision, &out.GitSourceRevision, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_GitRefInfo_To_build_GitRefInfo is an autogenerated conversion function.
func Convert_v1_GitRefInfo_To_build_GitRefInfo(in *v1.GitRefInfo, out *build.GitRefInfo, s conversion.Scope) error {
	return autoConvert_v1_GitRefInfo_To_build_GitRefInfo(in, out, s)
}

func autoConvert_build_GitRefInfo_To_v1_GitRefInfo(in *build.GitRefInfo, out *v1.GitRefInfo, s conversion.Scope) error {
	if err := Convert_build_GitBuildSource_To_v1_GitBuildSource(&in.GitBuildSource, &out.GitBuildSource, s); err != nil {
		return err
	}
	if err := Convert_build_GitSourceRevision_To_v1_GitSourceRevision(&in.GitSourceRevision, &out.GitSourceRevision, s); err != nil {
		return err
	}
	return nil
}

// Convert_build_GitRefInfo_To_v1_GitRefInfo is an autogenerated conversion function.
func Convert_build_GitRefInfo_To_v1_GitRefInfo(in *build.GitRefInfo, out *v1.GitRefInfo, s conversion.Scope) error {
	return autoConvert_build_GitRefInfo_To_v1_GitRefInfo(in, out, s)
}

func autoConvert_v1_GitSourceRevision_To_build_GitSourceRevision(in *v1.GitSourceRevision, out *build.GitSourceRevision, s conversion.Scope) error {
	out.Commit = in.Commit
	if err := Convert_v1_SourceControlUser_To_build_SourceControlUser(&in.Author, &out.Author, s); err != nil {
		return err
	}
	if err := Convert_v1_SourceControlUser_To_build_SourceControlUser(&in.Committer, &out.Committer, s); err != nil {
		return err
	}
	out.Message = in.Message
	return nil
}

// Convert_v1_GitSourceRevision_To_build_GitSourceRevision is an autogenerated conversion function.
func Convert_v1_GitSourceRevision_To_build_GitSourceRevision(in *v1.GitSourceRevision, out *build.GitSourceRevision, s conversion.Scope) error {
	return autoConvert_v1_GitSourceRevision_To_build_GitSourceRevision(in, out, s)
}

func autoConvert_build_GitSourceRevision_To_v1_GitSourceRevision(in *build.GitSourceRevision, out *v1.GitSourceRevision, s conversion.Scope) error {
	out.Commit = in.Commit
	if err := Convert_build_SourceControlUser_To_v1_SourceControlUser(&in.Author, &out.Author, s); err != nil {
		return err
	}
	if err := Convert_build_SourceControlUser_To_v1_SourceControlUser(&in.Committer, &out.Committer, s); err != nil {
		return err
	}
	out.Message = in.Message
	return nil
}

// Convert_build_GitSourceRevision_To_v1_GitSourceRevision is an autogenerated conversion function.
func Convert_build_GitSourceRevision_To_v1_GitSourceRevision(in *build.GitSourceRevision, out *v1.GitSourceRevision, s conversion.Scope) error {
	return autoConvert_build_GitSourceRevision_To_v1_GitSourceRevision(in, out, s)
}

func autoConvert_v1_ImageChangeCause_To_build_ImageChangeCause(in *v1.ImageChangeCause, out *build.ImageChangeCause, s conversion.Scope) error {
	out.ImageID = in.ImageID
	if in.FromRef != nil {
		in, out := &in.FromRef, &out.FromRef
		*out = new(core.ObjectReference)
		if err := core_v1.Convert_v1_ObjectReference_To_core_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.FromRef = nil
	}
	return nil
}

// Convert_v1_ImageChangeCause_To_build_ImageChangeCause is an autogenerated conversion function.
func Convert_v1_ImageChangeCause_To_build_ImageChangeCause(in *v1.ImageChangeCause, out *build.ImageChangeCause, s conversion.Scope) error {
	return autoConvert_v1_ImageChangeCause_To_build_ImageChangeCause(in, out, s)
}

func autoConvert_build_ImageChangeCause_To_v1_ImageChangeCause(in *build.ImageChangeCause, out *v1.ImageChangeCause, s conversion.Scope) error {
	out.ImageID = in.ImageID
	if in.FromRef != nil {
		in, out := &in.FromRef, &out.FromRef
		*out = new(api_core_v1.ObjectReference)
		if err := core_v1.Convert_core_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.FromRef = nil
	}
	return nil
}

// Convert_build_ImageChangeCause_To_v1_ImageChangeCause is an autogenerated conversion function.
func Convert_build_ImageChangeCause_To_v1_ImageChangeCause(in *build.ImageChangeCause, out *v1.ImageChangeCause, s conversion.Scope) error {
	return autoConvert_build_ImageChangeCause_To_v1_ImageChangeCause(in, out, s)
}

func autoConvert_v1_ImageChangeTrigger_To_build_ImageChangeTrigger(in *v1.ImageChangeTrigger, out *build.ImageChangeTrigger, s conversion.Scope) error {
	out.LastTriggeredImageID = in.LastTriggeredImageID
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(core.ObjectReference)
		if err := core_v1.Convert_v1_ObjectReference_To_core_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	out.Paused = in.Paused
	return nil
}

// Convert_v1_ImageChangeTrigger_To_build_ImageChangeTrigger is an autogenerated conversion function.
func Convert_v1_ImageChangeTrigger_To_build_ImageChangeTrigger(in *v1.ImageChangeTrigger, out *build.ImageChangeTrigger, s conversion.Scope) error {
	return autoConvert_v1_ImageChangeTrigger_To_build_ImageChangeTrigger(in, out, s)
}

func autoConvert_build_ImageChangeTrigger_To_v1_ImageChangeTrigger(in *build.ImageChangeTrigger, out *v1.ImageChangeTrigger, s conversion.Scope) error {
	out.LastTriggeredImageID = in.LastTriggeredImageID
	if in.From != nil {
		in, out := &in.From, &out.From
		*out = new(api_core_v1.ObjectReference)
		if err := core_v1.Convert_core_ObjectReference_To_v1_ObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.From = nil
	}
	out.Paused = in.Paused
	return nil
}

// Convert_build_ImageChangeTrigger_To_v1_ImageChangeTrigger is an autogenerated conversion function.
func Convert_build_ImageChangeTrigger_To_v1_ImageChangeTrigger(in *build.ImageChangeTrigger, out *v1.ImageChangeTrigger, s conversion.Scope) error {
	return autoConvert_build_ImageChangeTrigger_To_v1_ImageChangeTrigger(in, out, s)
}

func autoConvert_v1_ImageLabel_To_build_ImageLabel(in *v1.ImageLabel, out *build.ImageLabel, s conversion.Scope) error {
	out.Name = in.Name
	out.Value = in.Value
	return nil
}

// Convert_v1_ImageLabel_To_build_ImageLabel is an autogenerated conversion function.
func Convert_v1_ImageLabel_To_build_ImageLabel(in *v1.ImageLabel, out *build.ImageLabel, s conversion.Scope) error {
	return autoConvert_v1_ImageLabel_To_build_ImageLabel(in, out, s)
}

func autoConvert_build_ImageLabel_To_v1_ImageLabel(in *build.ImageLabel, out *v1.ImageLabel, s conversion.Scope) error {
	out.Name = in.Name
	out.Value = in.Value
	return nil
}

// Convert_build_ImageLabel_To_v1_ImageLabel is an autogenerated conversion function.
func Convert_build_ImageLabel_To_v1_ImageLabel(in *build.ImageLabel, out *v1.ImageLabel, s conversion.Scope) error {
	return autoConvert_build_ImageLabel_To_v1_ImageLabel(in, out, s)
}

func autoConvert_v1_ImageSource_To_build_ImageSource(in *v1.ImageSource, out *build.ImageSource, s conversion.Scope) error {
	if err := core_v1.Convert_v1_ObjectReference_To_core_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	out.As = *(*[]string)(unsafe.Pointer(&in.As))
	out.Paths = *(*[]build.ImageSourcePath)(unsafe.Pointer(&in.Paths))
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(core.LocalObjectReference)
		if err := core_v1.Convert_v1_LocalObjectReference_To_core_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	return nil
}

// Convert_v1_ImageSource_To_build_ImageSource is an autogenerated conversion function.
func Convert_v1_ImageSource_To_build_ImageSource(in *v1.ImageSource, out *build.ImageSource, s conversion.Scope) error {
	return autoConvert_v1_ImageSource_To_build_ImageSource(in, out, s)
}

func autoConvert_build_ImageSource_To_v1_ImageSource(in *build.ImageSource, out *v1.ImageSource, s conversion.Scope) error {
	if err := core_v1.Convert_core_ObjectReference_To_v1_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	out.As = *(*[]string)(unsafe.Pointer(&in.As))
	out.Paths = *(*[]v1.ImageSourcePath)(unsafe.Pointer(&in.Paths))
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api_core_v1.LocalObjectReference)
		if err := core_v1.Convert_core_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	return nil
}

// Convert_build_ImageSource_To_v1_ImageSource is an autogenerated conversion function.
func Convert_build_ImageSource_To_v1_ImageSource(in *build.ImageSource, out *v1.ImageSource, s conversion.Scope) error {
	return autoConvert_build_ImageSource_To_v1_ImageSource(in, out, s)
}

func autoConvert_v1_ImageSourcePath_To_build_ImageSourcePath(in *v1.ImageSourcePath, out *build.ImageSourcePath, s conversion.Scope) error {
	out.SourcePath = in.SourcePath
	out.DestinationDir = in.DestinationDir
	return nil
}

// Convert_v1_ImageSourcePath_To_build_ImageSourcePath is an autogenerated conversion function.
func Convert_v1_ImageSourcePath_To_build_ImageSourcePath(in *v1.ImageSourcePath, out *build.ImageSourcePath, s conversion.Scope) error {
	return autoConvert_v1_ImageSourcePath_To_build_ImageSourcePath(in, out, s)
}

func autoConvert_build_ImageSourcePath_To_v1_ImageSourcePath(in *build.ImageSourcePath, out *v1.ImageSourcePath, s conversion.Scope) error {
	out.SourcePath = in.SourcePath
	out.DestinationDir = in.DestinationDir
	return nil
}

// Convert_build_ImageSourcePath_To_v1_ImageSourcePath is an autogenerated conversion function.
func Convert_build_ImageSourcePath_To_v1_ImageSourcePath(in *build.ImageSourcePath, out *v1.ImageSourcePath, s conversion.Scope) error {
	return autoConvert_build_ImageSourcePath_To_v1_ImageSourcePath(in, out, s)
}

func autoConvert_v1_JenkinsPipelineBuildStrategy_To_build_JenkinsPipelineBuildStrategy(in *v1.JenkinsPipelineBuildStrategy, out *build.JenkinsPipelineBuildStrategy, s conversion.Scope) error {
	out.JenkinsfilePath = in.JenkinsfilePath
	out.Jenkinsfile = in.Jenkinsfile
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]core.EnvVar, len(*in))
		for i := range *in {
			if err := core_v1.Convert_v1_EnvVar_To_core_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	return nil
}

// Convert_v1_JenkinsPipelineBuildStrategy_To_build_JenkinsPipelineBuildStrategy is an autogenerated conversion function.
func Convert_v1_JenkinsPipelineBuildStrategy_To_build_JenkinsPipelineBuildStrategy(in *v1.JenkinsPipelineBuildStrategy, out *build.JenkinsPipelineBuildStrategy, s conversion.Scope) error {
	return autoConvert_v1_JenkinsPipelineBuildStrategy_To_build_JenkinsPipelineBuildStrategy(in, out, s)
}

func autoConvert_build_JenkinsPipelineBuildStrategy_To_v1_JenkinsPipelineBuildStrategy(in *build.JenkinsPipelineBuildStrategy, out *v1.JenkinsPipelineBuildStrategy, s conversion.Scope) error {
	out.JenkinsfilePath = in.JenkinsfilePath
	out.Jenkinsfile = in.Jenkinsfile
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_core_v1.EnvVar, len(*in))
		for i := range *in {
			if err := core_v1.Convert_core_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	return nil
}

// Convert_build_JenkinsPipelineBuildStrategy_To_v1_JenkinsPipelineBuildStrategy is an autogenerated conversion function.
func Convert_build_JenkinsPipelineBuildStrategy_To_v1_JenkinsPipelineBuildStrategy(in *build.JenkinsPipelineBuildStrategy, out *v1.JenkinsPipelineBuildStrategy, s conversion.Scope) error {
	return autoConvert_build_JenkinsPipelineBuildStrategy_To_v1_JenkinsPipelineBuildStrategy(in, out, s)
}

func autoConvert_v1_ProxyConfig_To_build_ProxyConfig(in *v1.ProxyConfig, out *build.ProxyConfig, s conversion.Scope) error {
	out.HTTPProxy = (*string)(unsafe.Pointer(in.HTTPProxy))
	out.HTTPSProxy = (*string)(unsafe.Pointer(in.HTTPSProxy))
	out.NoProxy = (*string)(unsafe.Pointer(in.NoProxy))
	return nil
}

// Convert_v1_ProxyConfig_To_build_ProxyConfig is an autogenerated conversion function.
func Convert_v1_ProxyConfig_To_build_ProxyConfig(in *v1.ProxyConfig, out *build.ProxyConfig, s conversion.Scope) error {
	return autoConvert_v1_ProxyConfig_To_build_ProxyConfig(in, out, s)
}

func autoConvert_build_ProxyConfig_To_v1_ProxyConfig(in *build.ProxyConfig, out *v1.ProxyConfig, s conversion.Scope) error {
	out.HTTPProxy = (*string)(unsafe.Pointer(in.HTTPProxy))
	out.HTTPSProxy = (*string)(unsafe.Pointer(in.HTTPSProxy))
	out.NoProxy = (*string)(unsafe.Pointer(in.NoProxy))
	return nil
}

// Convert_build_ProxyConfig_To_v1_ProxyConfig is an autogenerated conversion function.
func Convert_build_ProxyConfig_To_v1_ProxyConfig(in *build.ProxyConfig, out *v1.ProxyConfig, s conversion.Scope) error {
	return autoConvert_build_ProxyConfig_To_v1_ProxyConfig(in, out, s)
}

func autoConvert_v1_SecretBuildSource_To_build_SecretBuildSource(in *v1.SecretBuildSource, out *build.SecretBuildSource, s conversion.Scope) error {
	if err := core_v1.Convert_v1_LocalObjectReference_To_core_LocalObjectReference(&in.Secret, &out.Secret, s); err != nil {
		return err
	}
	out.DestinationDir = in.DestinationDir
	return nil
}

// Convert_v1_SecretBuildSource_To_build_SecretBuildSource is an autogenerated conversion function.
func Convert_v1_SecretBuildSource_To_build_SecretBuildSource(in *v1.SecretBuildSource, out *build.SecretBuildSource, s conversion.Scope) error {
	return autoConvert_v1_SecretBuildSource_To_build_SecretBuildSource(in, out, s)
}

func autoConvert_build_SecretBuildSource_To_v1_SecretBuildSource(in *build.SecretBuildSource, out *v1.SecretBuildSource, s conversion.Scope) error {
	if err := core_v1.Convert_core_LocalObjectReference_To_v1_LocalObjectReference(&in.Secret, &out.Secret, s); err != nil {
		return err
	}
	out.DestinationDir = in.DestinationDir
	return nil
}

// Convert_build_SecretBuildSource_To_v1_SecretBuildSource is an autogenerated conversion function.
func Convert_build_SecretBuildSource_To_v1_SecretBuildSource(in *build.SecretBuildSource, out *v1.SecretBuildSource, s conversion.Scope) error {
	return autoConvert_build_SecretBuildSource_To_v1_SecretBuildSource(in, out, s)
}

func autoConvert_v1_SecretLocalReference_To_build_SecretLocalReference(in *v1.SecretLocalReference, out *build.SecretLocalReference, s conversion.Scope) error {
	out.Name = in.Name
	return nil
}

// Convert_v1_SecretLocalReference_To_build_SecretLocalReference is an autogenerated conversion function.
func Convert_v1_SecretLocalReference_To_build_SecretLocalReference(in *v1.SecretLocalReference, out *build.SecretLocalReference, s conversion.Scope) error {
	return autoConvert_v1_SecretLocalReference_To_build_SecretLocalReference(in, out, s)
}

func autoConvert_build_SecretLocalReference_To_v1_SecretLocalReference(in *build.SecretLocalReference, out *v1.SecretLocalReference, s conversion.Scope) error {
	out.Name = in.Name
	return nil
}

// Convert_build_SecretLocalReference_To_v1_SecretLocalReference is an autogenerated conversion function.
func Convert_build_SecretLocalReference_To_v1_SecretLocalReference(in *build.SecretLocalReference, out *v1.SecretLocalReference, s conversion.Scope) error {
	return autoConvert_build_SecretLocalReference_To_v1_SecretLocalReference(in, out, s)
}

func autoConvert_v1_SecretSpec_To_build_SecretSpec(in *v1.SecretSpec, out *build.SecretSpec, s conversion.Scope) error {
	if err := core_v1.Convert_v1_LocalObjectReference_To_core_LocalObjectReference(&in.SecretSource, &out.SecretSource, s); err != nil {
		return err
	}
	out.MountPath = in.MountPath
	return nil
}

// Convert_v1_SecretSpec_To_build_SecretSpec is an autogenerated conversion function.
func Convert_v1_SecretSpec_To_build_SecretSpec(in *v1.SecretSpec, out *build.SecretSpec, s conversion.Scope) error {
	return autoConvert_v1_SecretSpec_To_build_SecretSpec(in, out, s)
}

func autoConvert_build_SecretSpec_To_v1_SecretSpec(in *build.SecretSpec, out *v1.SecretSpec, s conversion.Scope) error {
	if err := core_v1.Convert_core_LocalObjectReference_To_v1_LocalObjectReference(&in.SecretSource, &out.SecretSource, s); err != nil {
		return err
	}
	out.MountPath = in.MountPath
	return nil
}

// Convert_build_SecretSpec_To_v1_SecretSpec is an autogenerated conversion function.
func Convert_build_SecretSpec_To_v1_SecretSpec(in *build.SecretSpec, out *v1.SecretSpec, s conversion.Scope) error {
	return autoConvert_build_SecretSpec_To_v1_SecretSpec(in, out, s)
}

func autoConvert_v1_SourceBuildStrategy_To_build_SourceBuildStrategy(in *v1.SourceBuildStrategy, out *build.SourceBuildStrategy, s conversion.Scope) error {
	if err := core_v1.Convert_v1_ObjectReference_To_core_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(core.LocalObjectReference)
		if err := core_v1.Convert_v1_LocalObjectReference_To_core_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]core.EnvVar, len(*in))
		for i := range *in {
			if err := core_v1.Convert_v1_EnvVar_To_core_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.Scripts = in.Scripts
	out.Incremental = (*bool)(unsafe.Pointer(in.Incremental))
	out.ForcePull = in.ForcePull
	return nil
}

func autoConvert_build_SourceBuildStrategy_To_v1_SourceBuildStrategy(in *build.SourceBuildStrategy, out *v1.SourceBuildStrategy, s conversion.Scope) error {
	if err := core_v1.Convert_core_ObjectReference_To_v1_ObjectReference(&in.From, &out.From, s); err != nil {
		return err
	}
	if in.PullSecret != nil {
		in, out := &in.PullSecret, &out.PullSecret
		*out = new(api_core_v1.LocalObjectReference)
		if err := core_v1.Convert_core_LocalObjectReference_To_v1_LocalObjectReference(*in, *out, s); err != nil {
			return err
		}
	} else {
		out.PullSecret = nil
	}
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]api_core_v1.EnvVar, len(*in))
		for i := range *in {
			if err := core_v1.Convert_core_EnvVar_To_v1_EnvVar(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Env = nil
	}
	out.Scripts = in.Scripts
	out.Incremental = (*bool)(unsafe.Pointer(in.Incremental))
	out.ForcePull = in.ForcePull
	return nil
}

// Convert_build_SourceBuildStrategy_To_v1_SourceBuildStrategy is an autogenerated conversion function.
func Convert_build_SourceBuildStrategy_To_v1_SourceBuildStrategy(in *build.SourceBuildStrategy, out *v1.SourceBuildStrategy, s conversion.Scope) error {
	return autoConvert_build_SourceBuildStrategy_To_v1_SourceBuildStrategy(in, out, s)
}

func autoConvert_v1_SourceControlUser_To_build_SourceControlUser(in *v1.SourceControlUser, out *build.SourceControlUser, s conversion.Scope) error {
	out.Name = in.Name
	out.Email = in.Email
	return nil
}

// Convert_v1_SourceControlUser_To_build_SourceControlUser is an autogenerated conversion function.
func Convert_v1_SourceControlUser_To_build_SourceControlUser(in *v1.SourceControlUser, out *build.SourceControlUser, s conversion.Scope) error {
	return autoConvert_v1_SourceControlUser_To_build_SourceControlUser(in, out, s)
}

func autoConvert_build_SourceControlUser_To_v1_SourceControlUser(in *build.SourceControlUser, out *v1.SourceControlUser, s conversion.Scope) error {
	out.Name = in.Name
	out.Email = in.Email
	return nil
}

// Convert_build_SourceControlUser_To_v1_SourceControlUser is an autogenerated conversion function.
func Convert_build_SourceControlUser_To_v1_SourceControlUser(in *build.SourceControlUser, out *v1.SourceControlUser, s conversion.Scope) error {
	return autoConvert_build_SourceControlUser_To_v1_SourceControlUser(in, out, s)
}

func autoConvert_v1_SourceRevision_To_build_SourceRevision(in *v1.SourceRevision, out *build.SourceRevision, s conversion.Scope) error {
	// INFO: in.Type opted out of conversion generation
	out.Git = (*build.GitSourceRevision)(unsafe.Pointer(in.Git))
	return nil
}

// Convert_v1_SourceRevision_To_build_SourceRevision is an autogenerated conversion function.
func Convert_v1_SourceRevision_To_build_SourceRevision(in *v1.SourceRevision, out *build.SourceRevision, s conversion.Scope) error {
	return autoConvert_v1_SourceRevision_To_build_SourceRevision(in, out, s)
}

func autoConvert_build_SourceRevision_To_v1_SourceRevision(in *build.SourceRevision, out *v1.SourceRevision, s conversion.Scope) error {
	out.Git = (*v1.GitSourceRevision)(unsafe.Pointer(in.Git))
	return nil
}

func autoConvert_v1_SourceStrategyOptions_To_build_SourceStrategyOptions(in *v1.SourceStrategyOptions, out *build.SourceStrategyOptions, s conversion.Scope) error {
	out.Incremental = (*bool)(unsafe.Pointer(in.Incremental))
	return nil
}

// Convert_v1_SourceStrategyOptions_To_build_SourceStrategyOptions is an autogenerated conversion function.
func Convert_v1_SourceStrategyOptions_To_build_SourceStrategyOptions(in *v1.SourceStrategyOptions, out *build.SourceStrategyOptions, s conversion.Scope) error {
	return autoConvert_v1_SourceStrategyOptions_To_build_SourceStrategyOptions(in, out, s)
}

func autoConvert_build_SourceStrategyOptions_To_v1_SourceStrategyOptions(in *build.SourceStrategyOptions, out *v1.SourceStrategyOptions, s conversion.Scope) error {
	out.Incremental = (*bool)(unsafe.Pointer(in.Incremental))
	return nil
}

// Convert_build_SourceStrategyOptions_To_v1_SourceStrategyOptions is an autogenerated conversion function.
func Convert_build_SourceStrategyOptions_To_v1_SourceStrategyOptions(in *build.SourceStrategyOptions, out *v1.SourceStrategyOptions, s conversion.Scope) error {
	return autoConvert_build_SourceStrategyOptions_To_v1_SourceStrategyOptions(in, out, s)
}

func autoConvert_v1_StageInfo_To_build_StageInfo(in *v1.StageInfo, out *build.StageInfo, s conversion.Scope) error {
	out.Name = build.StageName(in.Name)
	out.StartTime = in.StartTime
	out.DurationMilliseconds = in.DurationMilliseconds
	out.Steps = *(*[]build.StepInfo)(unsafe.Pointer(&in.Steps))
	return nil
}

// Convert_v1_StageInfo_To_build_StageInfo is an autogenerated conversion function.
func Convert_v1_StageInfo_To_build_StageInfo(in *v1.StageInfo, out *build.StageInfo, s conversion.Scope) error {
	return autoConvert_v1_StageInfo_To_build_StageInfo(in, out, s)
}

func autoConvert_build_StageInfo_To_v1_StageInfo(in *build.StageInfo, out *v1.StageInfo, s conversion.Scope) error {
	out.Name = v1.StageName(in.Name)
	out.StartTime = in.StartTime
	out.DurationMilliseconds = in.DurationMilliseconds
	out.Steps = *(*[]v1.StepInfo)(unsafe.Pointer(&in.Steps))
	return nil
}

// Convert_build_StageInfo_To_v1_StageInfo is an autogenerated conversion function.
func Convert_build_StageInfo_To_v1_StageInfo(in *build.StageInfo, out *v1.StageInfo, s conversion.Scope) error {
	return autoConvert_build_StageInfo_To_v1_StageInfo(in, out, s)
}

func autoConvert_v1_StepInfo_To_build_StepInfo(in *v1.StepInfo, out *build.StepInfo, s conversion.Scope) error {
	out.Name = build.StepName(in.Name)
	out.StartTime = in.StartTime
	out.DurationMilliseconds = in.DurationMilliseconds
	return nil
}

// Convert_v1_StepInfo_To_build_StepInfo is an autogenerated conversion function.
func Convert_v1_StepInfo_To_build_StepInfo(in *v1.StepInfo, out *build.StepInfo, s conversion.Scope) error {
	return autoConvert_v1_StepInfo_To_build_StepInfo(in, out, s)
}

func autoConvert_build_StepInfo_To_v1_StepInfo(in *build.StepInfo, out *v1.StepInfo, s conversion.Scope) error {
	out.Name = v1.StepName(in.Name)
	out.StartTime = in.StartTime
	out.DurationMilliseconds = in.DurationMilliseconds
	return nil
}

// Convert_build_StepInfo_To_v1_StepInfo is an autogenerated conversion function.
func Convert_build_StepInfo_To_v1_StepInfo(in *build.StepInfo, out *v1.StepInfo, s conversion.Scope) error {
	return autoConvert_build_StepInfo_To_v1_StepInfo(in, out, s)
}

func autoConvert_v1_WebHookTrigger_To_build_WebHookTrigger(in *v1.WebHookTrigger, out *build.WebHookTrigger, s conversion.Scope) error {
	out.Secret = in.Secret
	out.AllowEnv = in.AllowEnv
	out.SecretReference = (*build.SecretLocalReference)(unsafe.Pointer(in.SecretReference))
	return nil
}

// Convert_v1_WebHookTrigger_To_build_WebHookTrigger is an autogenerated conversion function.
func Convert_v1_WebHookTrigger_To_build_WebHookTrigger(in *v1.WebHookTrigger, out *build.WebHookTrigger, s conversion.Scope) error {
	return autoConvert_v1_WebHookTrigger_To_build_WebHookTrigger(in, out, s)
}

func autoConvert_build_WebHookTrigger_To_v1_WebHookTrigger(in *build.WebHookTrigger, out *v1.WebHookTrigger, s conversion.Scope) error {
	out.Secret = in.Secret
	out.AllowEnv = in.AllowEnv
	out.SecretReference = (*v1.SecretLocalReference)(unsafe.Pointer(in.SecretReference))
	return nil
}

// Convert_build_WebHookTrigger_To_v1_WebHookTrigger is an autogenerated conversion function.
func Convert_build_WebHookTrigger_To_v1_WebHookTrigger(in *build.WebHookTrigger, out *v1.WebHookTrigger, s conversion.Scope) error {
	return autoConvert_build_WebHookTrigger_To_v1_WebHookTrigger(in, out, s)
}
