---
title: Testing Operator Deployment with OLM
linkTitle: Testing Deployment
weight: 30
---

This document discusses the behavior of `operator-sdk <run|cleanup>` subcommands related to OLM deployment,
and assumes you are familiar with [OLM][olm], related terminology,
and have read the SDK-OLM integration [design proposal][sdk-olm-design].

Only the package manifests format is supported by `<run|cleanup>` subcommands.

**Note:** before continuing, please read the [caveats](#caveats) section below.

## `operator-sdk <run|cleanup> packagemanifests` command overview

`operator-sdk <run|cleanup> packagemanifests` assumes OLM is already installed and running on your cluster,
and that your Operator has a valid [package manifests format][package-manifests].
See the [CLI overview][doc-cli-overview] for commands to work with an OLM installation and generate a package manifests format.

Let's look at the anatomy of the `run packagemanifests` (which is the same for `cleanup`) configuration model:

- **kubeconfig-path**: the local path to a kubeconfig.
  - This uses well-defined default loading rules to load the config if empty.
- **olm-namespace**: the namespace in which OLM is installed.
- **operator-namespace**: the cluster namespace in which Operator resources are created.
  - This namespace must already exist in the cluster or be defined in a manifest passed to **include-paths**.
- **manifests-dir**: a directory containing the Operator's package manifests.
- **operator-version**: the version of the Operator to deploy. It must be a semantic version, ex. 0.0.1.
  - This version must match the version of the CSV manifest found in **manifests-dir**,
    ex. `deploy/olm-catalog/<operator-name>/0.0.1` in an Operator SDK project.
- **install-mode**: specifies which supported [`installMode`][csv-install-modes] should be used to
  create an `OperatorGroup` by configuring its `spec.targetNamespaces` field.
  - The `InstallModeType` string passed must be marked as "supported" in the CSV being installed.
    The namespaces passed must exist or be created by passing a `Namespace` manifest to IncludePaths.
  - This option understands the following strings (assuming your CSV does as well):
      - `OwnNamespace`: the Operator will watch its own namespace (from **operator-namespace** or the kubeconfig default).
      This is the default.
      - `SingleNamespace="my-ns"`: the Operator will watch a namespace, not necessarily its own.
      - `AllNamespaces=""`: the Operator will watch all namespaces (cluster-scoped Operators).
- **include-paths**: a list of paths to manifests of Kubernetes resources that either
  supplement or supplant defaults generated by `run`, ex. RBAC kinds.
  - This option can be used if you have an existing set of manifests outside your versioned package
    (ex. catalog manifests like a `Subscription`, `CatalogSource`, and/or `OperatorGroup`)
    you wish to use instead of the corresponding defaults.
      - Paths supplied to this command will be created with the same behavior of `kubectl create -f <path>`.
  - Kinds that are overridden if supplied: `CatalogSource`, `Subscription`, `OperatorGroup`.
      - If a `Subscription` or `CatalogSource` are supplied, the other must be supplied
        since they are linked by field references.
- **timeout**: a time string dictating the maximum time that `run` can run. The command will
  return an error if the timeout is exceeded.

### Caveats

- `<run|cleanup> packagemanifests` are intended to be used for testing purposes only,
since this command creates a transient image registry that should not be used in production.
Typically a registry is deployed separately and a set of catalog manifests are created in the cluster
to inform OLM of that registry and which Operator versions it can deploy and where to deploy the Operator.
- `run packagemanifests` can only deploy one Operator and one version of that Operator at a time,
hence its intended purpose being testing only.


[olm]:https://github.com/operator-framework/operator-lifecycle-manager/
[sdk-olm-design]:https://github.com/operator-framework/operator-sdk/blob/master/proposals/sdk-integration-with-olm.md
[doc-cli-overview]:/docs/olm-integration/legacy/cli-overview
[package-manifests]:https://github.com/operator-framework/operator-registry/tree/v1.5.3#manifest-format
[csv-install-modes]:https://github.com/operator-framework/operator-lifecycle-manager/blob/master/doc/design/building-your-csv.md#operator-metadata
[cli-olm-install]:/docs/cli/operator-sdk_olm_install
[cli-olm-status]:/docs/cli/operator-sdk_olm_status
