/*
Copyright 2019 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package webhook

import (
	"path/filepath"

	"sigs.k8s.io/kubebuilder/pkg/model/file"
)

var _ file.Template = &Kustomization{}

// Kustomization scaffolds the Kustomization file in manager folder.
type Kustomization struct {
	file.TemplateMixin
}

// SetTemplateDefaults implements input.Template
func (f *Kustomization) SetTemplateDefaults() error {
	if f.Path == "" {
		f.Path = filepath.Join("config", "webhook", "kustomization.yaml")
	}

	f.TemplateBody = kustomizeWebhookTemplate

	f.IfExistsAction = file.Error

	return nil
}

const kustomizeWebhookTemplate = `resources:
- manifests.yaml
- service.yaml

configurations:
- kustomizeconfig.yaml
`
