// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package api

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// RegistryClient is the client API for Registry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type RegistryClient interface {
	ListPackages(ctx context.Context, in *ListPackageRequest, opts ...grpc.CallOption) (Registry_ListPackagesClient, error)
	GetPackage(ctx context.Context, in *GetPackageRequest, opts ...grpc.CallOption) (*Package, error)
	GetBundle(ctx context.Context, in *GetBundleRequest, opts ...grpc.CallOption) (*Bundle, error)
	GetBundleForChannel(ctx context.Context, in *GetBundleInChannelRequest, opts ...grpc.CallOption) (*Bundle, error)
	GetChannelEntriesThatReplace(ctx context.Context, in *GetAllReplacementsRequest, opts ...grpc.CallOption) (Registry_GetChannelEntriesThatReplaceClient, error)
	GetBundleThatReplaces(ctx context.Context, in *GetReplacementRequest, opts ...grpc.CallOption) (*Bundle, error)
	GetChannelEntriesThatProvide(ctx context.Context, in *GetAllProvidersRequest, opts ...grpc.CallOption) (Registry_GetChannelEntriesThatProvideClient, error)
	GetLatestChannelEntriesThatProvide(ctx context.Context, in *GetLatestProvidersRequest, opts ...grpc.CallOption) (Registry_GetLatestChannelEntriesThatProvideClient, error)
	GetDefaultBundleThatProvides(ctx context.Context, in *GetDefaultProviderRequest, opts ...grpc.CallOption) (*Bundle, error)
	ListBundles(ctx context.Context, in *ListBundlesRequest, opts ...grpc.CallOption) (Registry_ListBundlesClient, error)
}

type registryClient struct {
	cc grpc.ClientConnInterface
}

func NewRegistryClient(cc grpc.ClientConnInterface) RegistryClient {
	return &registryClient{cc}
}

func (c *registryClient) ListPackages(ctx context.Context, in *ListPackageRequest, opts ...grpc.CallOption) (Registry_ListPackagesClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Registry_serviceDesc.Streams[0], "/api.Registry/ListPackages", opts...)
	if err != nil {
		return nil, err
	}
	x := &registryListPackagesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Registry_ListPackagesClient interface {
	Recv() (*PackageName, error)
	grpc.ClientStream
}

type registryListPackagesClient struct {
	grpc.ClientStream
}

func (x *registryListPackagesClient) Recv() (*PackageName, error) {
	m := new(PackageName)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *registryClient) GetPackage(ctx context.Context, in *GetPackageRequest, opts ...grpc.CallOption) (*Package, error) {
	out := new(Package)
	err := c.cc.Invoke(ctx, "/api.Registry/GetPackage", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) GetBundle(ctx context.Context, in *GetBundleRequest, opts ...grpc.CallOption) (*Bundle, error) {
	out := new(Bundle)
	err := c.cc.Invoke(ctx, "/api.Registry/GetBundle", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) GetBundleForChannel(ctx context.Context, in *GetBundleInChannelRequest, opts ...grpc.CallOption) (*Bundle, error) {
	out := new(Bundle)
	err := c.cc.Invoke(ctx, "/api.Registry/GetBundleForChannel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) GetChannelEntriesThatReplace(ctx context.Context, in *GetAllReplacementsRequest, opts ...grpc.CallOption) (Registry_GetChannelEntriesThatReplaceClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Registry_serviceDesc.Streams[1], "/api.Registry/GetChannelEntriesThatReplace", opts...)
	if err != nil {
		return nil, err
	}
	x := &registryGetChannelEntriesThatReplaceClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Registry_GetChannelEntriesThatReplaceClient interface {
	Recv() (*ChannelEntry, error)
	grpc.ClientStream
}

type registryGetChannelEntriesThatReplaceClient struct {
	grpc.ClientStream
}

func (x *registryGetChannelEntriesThatReplaceClient) Recv() (*ChannelEntry, error) {
	m := new(ChannelEntry)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *registryClient) GetBundleThatReplaces(ctx context.Context, in *GetReplacementRequest, opts ...grpc.CallOption) (*Bundle, error) {
	out := new(Bundle)
	err := c.cc.Invoke(ctx, "/api.Registry/GetBundleThatReplaces", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) GetChannelEntriesThatProvide(ctx context.Context, in *GetAllProvidersRequest, opts ...grpc.CallOption) (Registry_GetChannelEntriesThatProvideClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Registry_serviceDesc.Streams[2], "/api.Registry/GetChannelEntriesThatProvide", opts...)
	if err != nil {
		return nil, err
	}
	x := &registryGetChannelEntriesThatProvideClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Registry_GetChannelEntriesThatProvideClient interface {
	Recv() (*ChannelEntry, error)
	grpc.ClientStream
}

type registryGetChannelEntriesThatProvideClient struct {
	grpc.ClientStream
}

func (x *registryGetChannelEntriesThatProvideClient) Recv() (*ChannelEntry, error) {
	m := new(ChannelEntry)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *registryClient) GetLatestChannelEntriesThatProvide(ctx context.Context, in *GetLatestProvidersRequest, opts ...grpc.CallOption) (Registry_GetLatestChannelEntriesThatProvideClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Registry_serviceDesc.Streams[3], "/api.Registry/GetLatestChannelEntriesThatProvide", opts...)
	if err != nil {
		return nil, err
	}
	x := &registryGetLatestChannelEntriesThatProvideClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Registry_GetLatestChannelEntriesThatProvideClient interface {
	Recv() (*ChannelEntry, error)
	grpc.ClientStream
}

type registryGetLatestChannelEntriesThatProvideClient struct {
	grpc.ClientStream
}

func (x *registryGetLatestChannelEntriesThatProvideClient) Recv() (*ChannelEntry, error) {
	m := new(ChannelEntry)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *registryClient) GetDefaultBundleThatProvides(ctx context.Context, in *GetDefaultProviderRequest, opts ...grpc.CallOption) (*Bundle, error) {
	out := new(Bundle)
	err := c.cc.Invoke(ctx, "/api.Registry/GetDefaultBundleThatProvides", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *registryClient) ListBundles(ctx context.Context, in *ListBundlesRequest, opts ...grpc.CallOption) (Registry_ListBundlesClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Registry_serviceDesc.Streams[4], "/api.Registry/ListBundles", opts...)
	if err != nil {
		return nil, err
	}
	x := &registryListBundlesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Registry_ListBundlesClient interface {
	Recv() (*Bundle, error)
	grpc.ClientStream
}

type registryListBundlesClient struct {
	grpc.ClientStream
}

func (x *registryListBundlesClient) Recv() (*Bundle, error) {
	m := new(Bundle)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// RegistryServer is the server API for Registry service.
// All implementations must embed UnimplementedRegistryServer
// for forward compatibility
type RegistryServer interface {
	ListPackages(*ListPackageRequest, Registry_ListPackagesServer) error
	GetPackage(context.Context, *GetPackageRequest) (*Package, error)
	GetBundle(context.Context, *GetBundleRequest) (*Bundle, error)
	GetBundleForChannel(context.Context, *GetBundleInChannelRequest) (*Bundle, error)
	GetChannelEntriesThatReplace(*GetAllReplacementsRequest, Registry_GetChannelEntriesThatReplaceServer) error
	GetBundleThatReplaces(context.Context, *GetReplacementRequest) (*Bundle, error)
	GetChannelEntriesThatProvide(*GetAllProvidersRequest, Registry_GetChannelEntriesThatProvideServer) error
	GetLatestChannelEntriesThatProvide(*GetLatestProvidersRequest, Registry_GetLatestChannelEntriesThatProvideServer) error
	GetDefaultBundleThatProvides(context.Context, *GetDefaultProviderRequest) (*Bundle, error)
	ListBundles(*ListBundlesRequest, Registry_ListBundlesServer) error
	mustEmbedUnimplementedRegistryServer()
}

// UnimplementedRegistryServer must be embedded to have forward compatible implementations.
type UnimplementedRegistryServer struct {
}

func (*UnimplementedRegistryServer) ListPackages(*ListPackageRequest, Registry_ListPackagesServer) error {
	return status.Errorf(codes.Unimplemented, "method ListPackages not implemented")
}
func (*UnimplementedRegistryServer) GetPackage(context.Context, *GetPackageRequest) (*Package, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPackage not implemented")
}
func (*UnimplementedRegistryServer) GetBundle(context.Context, *GetBundleRequest) (*Bundle, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBundle not implemented")
}
func (*UnimplementedRegistryServer) GetBundleForChannel(context.Context, *GetBundleInChannelRequest) (*Bundle, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBundleForChannel not implemented")
}
func (*UnimplementedRegistryServer) GetChannelEntriesThatReplace(*GetAllReplacementsRequest, Registry_GetChannelEntriesThatReplaceServer) error {
	return status.Errorf(codes.Unimplemented, "method GetChannelEntriesThatReplace not implemented")
}
func (*UnimplementedRegistryServer) GetBundleThatReplaces(context.Context, *GetReplacementRequest) (*Bundle, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBundleThatReplaces not implemented")
}
func (*UnimplementedRegistryServer) GetChannelEntriesThatProvide(*GetAllProvidersRequest, Registry_GetChannelEntriesThatProvideServer) error {
	return status.Errorf(codes.Unimplemented, "method GetChannelEntriesThatProvide not implemented")
}
func (*UnimplementedRegistryServer) GetLatestChannelEntriesThatProvide(*GetLatestProvidersRequest, Registry_GetLatestChannelEntriesThatProvideServer) error {
	return status.Errorf(codes.Unimplemented, "method GetLatestChannelEntriesThatProvide not implemented")
}
func (*UnimplementedRegistryServer) GetDefaultBundleThatProvides(context.Context, *GetDefaultProviderRequest) (*Bundle, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDefaultBundleThatProvides not implemented")
}
func (*UnimplementedRegistryServer) ListBundles(*ListBundlesRequest, Registry_ListBundlesServer) error {
	return status.Errorf(codes.Unimplemented, "method ListBundles not implemented")
}
func (*UnimplementedRegistryServer) mustEmbedUnimplementedRegistryServer() {}

func RegisterRegistryServer(s *grpc.Server, srv RegistryServer) {
	s.RegisterService(&_Registry_serviceDesc, srv)
}

func _Registry_ListPackages_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListPackageRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RegistryServer).ListPackages(m, &registryListPackagesServer{stream})
}

type Registry_ListPackagesServer interface {
	Send(*PackageName) error
	grpc.ServerStream
}

type registryListPackagesServer struct {
	grpc.ServerStream
}

func (x *registryListPackagesServer) Send(m *PackageName) error {
	return x.ServerStream.SendMsg(m)
}

func _Registry_GetPackage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPackageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).GetPackage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.Registry/GetPackage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).GetPackage(ctx, req.(*GetPackageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_GetBundle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBundleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).GetBundle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.Registry/GetBundle",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).GetBundle(ctx, req.(*GetBundleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_GetBundleForChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBundleInChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).GetBundleForChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.Registry/GetBundleForChannel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).GetBundleForChannel(ctx, req.(*GetBundleInChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_GetChannelEntriesThatReplace_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetAllReplacementsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RegistryServer).GetChannelEntriesThatReplace(m, &registryGetChannelEntriesThatReplaceServer{stream})
}

type Registry_GetChannelEntriesThatReplaceServer interface {
	Send(*ChannelEntry) error
	grpc.ServerStream
}

type registryGetChannelEntriesThatReplaceServer struct {
	grpc.ServerStream
}

func (x *registryGetChannelEntriesThatReplaceServer) Send(m *ChannelEntry) error {
	return x.ServerStream.SendMsg(m)
}

func _Registry_GetBundleThatReplaces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReplacementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).GetBundleThatReplaces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.Registry/GetBundleThatReplaces",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).GetBundleThatReplaces(ctx, req.(*GetReplacementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_GetChannelEntriesThatProvide_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetAllProvidersRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RegistryServer).GetChannelEntriesThatProvide(m, &registryGetChannelEntriesThatProvideServer{stream})
}

type Registry_GetChannelEntriesThatProvideServer interface {
	Send(*ChannelEntry) error
	grpc.ServerStream
}

type registryGetChannelEntriesThatProvideServer struct {
	grpc.ServerStream
}

func (x *registryGetChannelEntriesThatProvideServer) Send(m *ChannelEntry) error {
	return x.ServerStream.SendMsg(m)
}

func _Registry_GetLatestChannelEntriesThatProvide_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetLatestProvidersRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RegistryServer).GetLatestChannelEntriesThatProvide(m, &registryGetLatestChannelEntriesThatProvideServer{stream})
}

type Registry_GetLatestChannelEntriesThatProvideServer interface {
	Send(*ChannelEntry) error
	grpc.ServerStream
}

type registryGetLatestChannelEntriesThatProvideServer struct {
	grpc.ServerStream
}

func (x *registryGetLatestChannelEntriesThatProvideServer) Send(m *ChannelEntry) error {
	return x.ServerStream.SendMsg(m)
}

func _Registry_GetDefaultBundleThatProvides_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDefaultProviderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RegistryServer).GetDefaultBundleThatProvides(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.Registry/GetDefaultBundleThatProvides",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RegistryServer).GetDefaultBundleThatProvides(ctx, req.(*GetDefaultProviderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Registry_ListBundles_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListBundlesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RegistryServer).ListBundles(m, &registryListBundlesServer{stream})
}

type Registry_ListBundlesServer interface {
	Send(*Bundle) error
	grpc.ServerStream
}

type registryListBundlesServer struct {
	grpc.ServerStream
}

func (x *registryListBundlesServer) Send(m *Bundle) error {
	return x.ServerStream.SendMsg(m)
}

var _Registry_serviceDesc = grpc.ServiceDesc{
	ServiceName: "api.Registry",
	HandlerType: (*RegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetPackage",
			Handler:    _Registry_GetPackage_Handler,
		},
		{
			MethodName: "GetBundle",
			Handler:    _Registry_GetBundle_Handler,
		},
		{
			MethodName: "GetBundleForChannel",
			Handler:    _Registry_GetBundleForChannel_Handler,
		},
		{
			MethodName: "GetBundleThatReplaces",
			Handler:    _Registry_GetBundleThatReplaces_Handler,
		},
		{
			MethodName: "GetDefaultBundleThatProvides",
			Handler:    _Registry_GetDefaultBundleThatProvides_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ListPackages",
			Handler:       _Registry_ListPackages_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetChannelEntriesThatReplace",
			Handler:       _Registry_GetChannelEntriesThatReplace_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetChannelEntriesThatProvide",
			Handler:       _Registry_GetChannelEntriesThatProvide_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetLatestChannelEntriesThatProvide",
			Handler:       _Registry_GetLatestChannelEntriesThatProvide_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListBundles",
			Handler:       _Registry_ListBundles_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "registry.proto",
}
