package subscription

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// OfferType enumerates the values for offer type.
type OfferType string

const (
	// MSAZR0017P ...
	MSAZR0017P OfferType = "MS-AZR-0017P"
	// MSAZR0148P ...
	MSAZR0148P OfferType = "MS-AZR-0148P"
)

// PossibleOfferTypeValues returns an array of possible values for the OfferType const type.
func PossibleOfferTypeValues() []OfferType {
	return []OfferType{MSAZR0017P, MSAZR0148P}
}

// AdPrincipal active Directory Principal for subscription creation delegated permission
type AdPrincipal struct {
	// ObjectID - Object id of the Principal
	ObjectID *string `json:"objectId,omitempty"`
}

// CreationParameters subscription Creation Parameters required to create a new Azure subscription.
type CreationParameters struct {
	// DisplayName - The display name of the subscription.
	DisplayName *string `json:"displayName,omitempty"`
	// Owners - The list of principals that should be granted Owner access on the subscription. Principals should be of type User, Service Principal or Security Group.
	Owners *[]AdPrincipal `json:"owners,omitempty"`
	// OfferType - The offer type of the subscription. For example, MS-AZR-0017P (EnterpriseAgreement) and MS-AZR-0148P (EnterpriseAgreement devTest) are available. Only valid when creating a subscription in a enrollment account scope. Possible values include: 'MSAZR0017P', 'MSAZR0148P'
	OfferType OfferType `json:"offerType,omitempty"`
}

// CreationResult the created subscription object.
type CreationResult struct {
	autorest.Response `json:"-"`
	// SubscriptionLink - The link to the new subscription.
	SubscriptionLink *string `json:"subscriptionLink,omitempty"`
}

// ErrorResponse describes the format of Error response.
type ErrorResponse struct {
	// Code - Error code
	Code *string `json:"code,omitempty"`
	// Message - Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
}

// FactoryCreateSubscriptionInEnrollmentAccountFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type FactoryCreateSubscriptionInEnrollmentAccountFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future FactoryCreateSubscriptionInEnrollmentAccountFuture) Result(client FactoryClient) (cr CreationResult, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "subscription.FactoryCreateSubscriptionInEnrollmentAccountFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return cr, azure.NewAsyncOpIncompleteError("subscription.FactoryCreateSubscriptionInEnrollmentAccountFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		cr, err = client.CreateSubscriptionInEnrollmentAccountResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "subscription.FactoryCreateSubscriptionInEnrollmentAccountFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "subscription.FactoryCreateSubscriptionInEnrollmentAccountFuture", "Result", resp, "Failure sending request")
		return
	}
	cr, err = client.CreateSubscriptionInEnrollmentAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "subscription.FactoryCreateSubscriptionInEnrollmentAccountFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// Operation REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.Subscription
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result of the request to list operations. It contains a list of operations and a URL link to
// get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultType a list of pending subscription operations.
type OperationListResultType struct {
	autorest.Response `json:"-"`
	// Value - A list of pending SubscriptionOperations
	Value *[]OperationType `json:"value,omitempty"`
}

// OperationType status of the subscription POST operation.
type OperationType struct {
	// ID - The operation Id.
	ID *string `json:"id,omitempty"`
	// Status - Status of the pending subscription
	Status *string `json:"status,omitempty"`
	// StatusDetail - Status Detail of the pending subscription
	StatusDetail *string `json:"statusDetail,omitempty"`
}
