package mobileengagement

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// CampaignsClient is the microsoft Azure Mobile Engagement REST APIs.
type CampaignsClient struct {
	BaseClient
}

// NewCampaignsClient creates an instance of the CampaignsClient client.
func NewCampaignsClient(subscriptionID string) CampaignsClient {
	return NewCampaignsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewCampaignsClientWithBaseURI creates an instance of the CampaignsClient client.
func NewCampaignsClientWithBaseURI(baseURI string, subscriptionID string) CampaignsClient {
	return CampaignsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Activate activate a campaign previously created by a call to Create campaign.
//
// resourceGroupName is the name of the resource group. appCollection is application collection. appName is
// application resource name. kind is campaign kind. ID is campaign identifier.
func (client CampaignsClient) Activate(ctx context.Context, resourceGroupName string, appCollection string, appName string, kind CampaignKinds, ID int32) (result CampaignStateResult, err error) {
	req, err := client.ActivatePreparer(ctx, resourceGroupName, appCollection, appName, kind, ID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Activate", nil, "Failure preparing request")
		return
	}

	resp, err := client.ActivateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Activate", resp, "Failure sending request")
		return
	}

	result, err = client.ActivateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Activate", resp, "Failure responding to request")
	}

	return
}

// ActivatePreparer prepares the Activate request.
func (client CampaignsClient) ActivatePreparer(ctx context.Context, resourceGroupName string, appCollection string, appName string, kind CampaignKinds, ID int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"id":                autorest.Encode("path", ID),
		"kind":              autorest.Encode("path", kind),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}/{id}/activate", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ActivateSender sends the Activate request. The method will close the
// http.Response Body if it receives an error.
func (client CampaignsClient) ActivateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ActivateResponder handles the response to the Activate request. The method always
// closes the http.Response Body.
func (client CampaignsClient) ActivateResponder(resp *http.Response) (result CampaignStateResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Create create a push campaign (announcement, poll, data push or native push).
//
// resourceGroupName is the name of the resource group. appCollection is application collection. appName is
// application resource name. kind is campaign kind. parameters is parameters supplied to the Update Campaign
// operation.
func (client CampaignsClient) Create(ctx context.Context, resourceGroupName string, appCollection string, appName string, kind CampaignKinds, parameters Campaign) (result CampaignStateResult, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.Name", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.Name", Name: validation.MaxLength, Rule: 64, Chain: nil}}},
				{Target: "parameters.Category", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "parameters.Category", Name: validation.MaxLength, Rule: 64, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("mobileengagement.CampaignsClient", "Create", err.Error())
	}

	req, err := client.CreatePreparer(ctx, resourceGroupName, appCollection, appName, kind, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Create", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Create", resp, "Failure sending request")
		return
	}

	result, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Create", resp, "Failure responding to request")
	}

	return
}

// CreatePreparer prepares the Create request.
func (client CampaignsClient) CreatePreparer(ctx context.Context, resourceGroupName string, appCollection string, appName string, kind CampaignKinds, parameters Campaign) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"kind":              autorest.Encode("path", kind),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client CampaignsClient) CreateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client CampaignsClient) CreateResponder(resp *http.Response) (result CampaignStateResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete a campaign previously created by a call to Create campaign.
//
// kind is campaign kind. ID is campaign identifier. resourceGroupName is the name of the resource group.
// appCollection is application collection. appName is application resource name.
func (client CampaignsClient) Delete(ctx context.Context, kind CampaignKinds, ID int32, resourceGroupName string, appCollection string, appName string) (result autorest.Response, err error) {
	req, err := client.DeletePreparer(ctx, kind, ID, resourceGroupName, appCollection, appName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client CampaignsClient) DeletePreparer(ctx context.Context, kind CampaignKinds, ID int32, resourceGroupName string, appCollection string, appName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"id":                autorest.Encode("path", ID),
		"kind":              autorest.Encode("path", kind),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client CampaignsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client CampaignsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Finish finish a push campaign previously activated by a call to Activate campaign.
//
// resourceGroupName is the name of the resource group. appCollection is application collection. appName is
// application resource name. kind is campaign kind. ID is campaign identifier.
func (client CampaignsClient) Finish(ctx context.Context, resourceGroupName string, appCollection string, appName string, kind CampaignKinds, ID int32) (result CampaignStateResult, err error) {
	req, err := client.FinishPreparer(ctx, resourceGroupName, appCollection, appName, kind, ID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Finish", nil, "Failure preparing request")
		return
	}

	resp, err := client.FinishSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Finish", resp, "Failure sending request")
		return
	}

	result, err = client.FinishResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Finish", resp, "Failure responding to request")
	}

	return
}

// FinishPreparer prepares the Finish request.
func (client CampaignsClient) FinishPreparer(ctx context.Context, resourceGroupName string, appCollection string, appName string, kind CampaignKinds, ID int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"id":                autorest.Encode("path", ID),
		"kind":              autorest.Encode("path", kind),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}/{id}/finish", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// FinishSender sends the Finish request. The method will close the
// http.Response Body if it receives an error.
func (client CampaignsClient) FinishSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// FinishResponder handles the response to the Finish request. The method always
// closes the http.Response Body.
func (client CampaignsClient) FinishResponder(resp *http.Response) (result CampaignStateResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get the Get campaign operation retrieves information about a previously created campaign.
//
// kind is campaign kind. ID is campaign identifier. resourceGroupName is the name of the resource group.
// appCollection is application collection. appName is application resource name.
func (client CampaignsClient) Get(ctx context.Context, kind CampaignKinds, ID int32, resourceGroupName string, appCollection string, appName string) (result CampaignResult, err error) {
	req, err := client.GetPreparer(ctx, kind, ID, resourceGroupName, appCollection, appName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client CampaignsClient) GetPreparer(ctx context.Context, kind CampaignKinds, ID int32, resourceGroupName string, appCollection string, appName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"id":                autorest.Encode("path", ID),
		"kind":              autorest.Encode("path", kind),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}/{id}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client CampaignsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client CampaignsClient) GetResponder(resp *http.Response) (result CampaignResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetByName the Get campaign operation retrieves information about a previously created campaign.
//
// resourceGroupName is the name of the resource group. appCollection is application collection. appName is
// application resource name. kind is campaign kind. name is campaign name.
func (client CampaignsClient) GetByName(ctx context.Context, resourceGroupName string, appCollection string, appName string, kind CampaignKinds, name string) (result CampaignResult, err error) {
	req, err := client.GetByNamePreparer(ctx, resourceGroupName, appCollection, appName, kind, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "GetByName", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetByNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "GetByName", resp, "Failure sending request")
		return
	}

	result, err = client.GetByNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "GetByName", resp, "Failure responding to request")
	}

	return
}

// GetByNamePreparer prepares the GetByName request.
func (client CampaignsClient) GetByNamePreparer(ctx context.Context, resourceGroupName string, appCollection string, appName string, kind CampaignKinds, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"kind":              autorest.Encode("path", kind),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaignsByName/{kind}/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetByNameSender sends the GetByName request. The method will close the
// http.Response Body if it receives an error.
func (client CampaignsClient) GetByNameSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetByNameResponder handles the response to the GetByName request. The method always
// closes the http.Response Body.
func (client CampaignsClient) GetByNameResponder(resp *http.Response) (result CampaignResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetStatistics get all the campaign statistics.
//
// kind is campaign kind. ID is campaign identifier. resourceGroupName is the name of the resource group.
// appCollection is application collection. appName is application resource name.
func (client CampaignsClient) GetStatistics(ctx context.Context, kind CampaignKinds, ID int32, resourceGroupName string, appCollection string, appName string) (result CampaignStatisticsResult, err error) {
	req, err := client.GetStatisticsPreparer(ctx, kind, ID, resourceGroupName, appCollection, appName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "GetStatistics", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetStatisticsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "GetStatistics", resp, "Failure sending request")
		return
	}

	result, err = client.GetStatisticsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "GetStatistics", resp, "Failure responding to request")
	}

	return
}

// GetStatisticsPreparer prepares the GetStatistics request.
func (client CampaignsClient) GetStatisticsPreparer(ctx context.Context, kind CampaignKinds, ID int32, resourceGroupName string, appCollection string, appName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"id":                autorest.Encode("path", ID),
		"kind":              autorest.Encode("path", kind),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}/{id}/statistics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetStatisticsSender sends the GetStatistics request. The method will close the
// http.Response Body if it receives an error.
func (client CampaignsClient) GetStatisticsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetStatisticsResponder handles the response to the GetStatistics request. The method always
// closes the http.Response Body.
func (client CampaignsClient) GetStatisticsResponder(resp *http.Response) (result CampaignStatisticsResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List get the list of campaigns.
//
// resourceGroupName is the name of the resource group. appCollection is application collection. appName is
// application resource name. kind is campaign kind. skip is control paging of campaigns, start results at the
// given offset, defaults to 0 (1st page of data). top is control paging of campaigns, number of campaigns to
// return with each call. It returns all campaigns by default. When specifying $top parameter, the response
// contains a `nextLink` property describing the path to get the next page if there are more results. filter is
// filter can be used to restrict the results to campaigns matching a specific state. The syntax is `$filter=state
// eq 'draft'`. Valid state values are: draft, scheduled, in-progress, and finished. Only the eq operator and the
// state property are supported. orderby is sort results by an expression which looks like `$orderby=id asc` (this
// example is actually the default behavior). The syntax is orderby={property} {direction} or just
// orderby={property}. The available sorting properties are id, name, state, activatedDate, and finishedDate. The
// available directions are asc (for ascending order) and desc (for descending order). When not specified the asc
// direction is used. Only one property at a time can be used for sorting. search is restrict results to campaigns
// matching the optional `search` expression. This currently performs the search based on the name on the campaign
// only, case insensitive. If the campaign contains the value of the `search` parameter anywhere in the name, it
// matches.
func (client CampaignsClient) List(ctx context.Context, resourceGroupName string, appCollection string, appName string, kind CampaignKinds, skip *int32, top *int32, filter string, orderby string, search string) (result CampaignsListResultPage, err error) {
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, resourceGroupName, appCollection, appName, kind, skip, top, filter, orderby, search)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.clr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "List", resp, "Failure sending request")
		return
	}

	result.clr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client CampaignsClient) ListPreparer(ctx context.Context, resourceGroupName string, appCollection string, appName string, kind CampaignKinds, skip *int32, top *int32, filter string, orderby string, search string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"kind":              autorest.Encode("path", kind),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if skip != nil {
		queryParameters["$skip"] = autorest.Encode("query", *skip)
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(orderby) > 0 {
		queryParameters["$orderby"] = autorest.Encode("query", orderby)
	}
	if len(search) > 0 {
		queryParameters["$search"] = autorest.Encode("query", search)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client CampaignsClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client CampaignsClient) ListResponder(resp *http.Response) (result CampaignsListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client CampaignsClient) listNextResults(lastResults CampaignsListResult) (result CampaignsListResult, err error) {
	req, err := lastResults.campaignsListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client CampaignsClient) ListComplete(ctx context.Context, resourceGroupName string, appCollection string, appName string, kind CampaignKinds, skip *int32, top *int32, filter string, orderby string, search string) (result CampaignsListResultIterator, err error) {
	result.page, err = client.List(ctx, resourceGroupName, appCollection, appName, kind, skip, top, filter, orderby, search)
	return
}

// Push push a previously saved campaign (created with Create campaign) to a set of devices.
//
// resourceGroupName is the name of the resource group. appCollection is application collection. appName is
// application resource name. kind is campaign kind. ID is campaign identifier. parameters is parameters supplied
// to the Push Campaign operation.
func (client CampaignsClient) Push(ctx context.Context, resourceGroupName string, appCollection string, appName string, kind CampaignKinds, ID int32, parameters CampaignPushParameters) (result CampaignPushResult, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.DeviceIds", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "parameters.Data", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "parameters.Data.Name", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "parameters.Data.Name", Name: validation.MaxLength, Rule: 64, Chain: nil}}},
						{Target: "parameters.Data.Category", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "parameters.Data.Category", Name: validation.MaxLength, Rule: 64, Chain: nil}}},
					}}}}}); err != nil {
		return result, validation.NewError("mobileengagement.CampaignsClient", "Push", err.Error())
	}

	req, err := client.PushPreparer(ctx, resourceGroupName, appCollection, appName, kind, ID, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Push", nil, "Failure preparing request")
		return
	}

	resp, err := client.PushSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Push", resp, "Failure sending request")
		return
	}

	result, err = client.PushResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Push", resp, "Failure responding to request")
	}

	return
}

// PushPreparer prepares the Push request.
func (client CampaignsClient) PushPreparer(ctx context.Context, resourceGroupName string, appCollection string, appName string, kind CampaignKinds, ID int32, parameters CampaignPushParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"id":                autorest.Encode("path", ID),
		"kind":              autorest.Encode("path", kind),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}/{id}/push", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PushSender sends the Push request. The method will close the
// http.Response Body if it receives an error.
func (client CampaignsClient) PushSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// PushResponder handles the response to the Push request. The method always
// closes the http.Response Body.
func (client CampaignsClient) PushResponder(resp *http.Response) (result CampaignPushResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Suspend suspend a push campaign previously activated by a call to Activate campaign.
//
// resourceGroupName is the name of the resource group. appCollection is application collection. appName is
// application resource name. kind is campaign kind. ID is campaign identifier.
func (client CampaignsClient) Suspend(ctx context.Context, resourceGroupName string, appCollection string, appName string, kind CampaignKinds, ID int32) (result CampaignStateResult, err error) {
	req, err := client.SuspendPreparer(ctx, resourceGroupName, appCollection, appName, kind, ID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Suspend", nil, "Failure preparing request")
		return
	}

	resp, err := client.SuspendSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Suspend", resp, "Failure sending request")
		return
	}

	result, err = client.SuspendResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Suspend", resp, "Failure responding to request")
	}

	return
}

// SuspendPreparer prepares the Suspend request.
func (client CampaignsClient) SuspendPreparer(ctx context.Context, resourceGroupName string, appCollection string, appName string, kind CampaignKinds, ID int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"id":                autorest.Encode("path", ID),
		"kind":              autorest.Encode("path", kind),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}/{id}/suspend", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SuspendSender sends the Suspend request. The method will close the
// http.Response Body if it receives an error.
func (client CampaignsClient) SuspendSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// SuspendResponder handles the response to the Suspend request. The method always
// closes the http.Response Body.
func (client CampaignsClient) SuspendResponder(resp *http.Response) (result CampaignStateResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// TestNew test a new campaign on a set of devices.
//
// resourceGroupName is the name of the resource group. appCollection is application collection. appName is
// application resource name. kind is campaign kind. parameters is parameters supplied to the Test Campaign
// operation.
func (client CampaignsClient) TestNew(ctx context.Context, resourceGroupName string, appCollection string, appName string, kind CampaignKinds, parameters CampaignTestNewParameters) (result CampaignState, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.Data", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "parameters.Data.Name", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "parameters.Data.Name", Name: validation.MaxLength, Rule: 64, Chain: nil}}},
					{Target: "parameters.Data.Category", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "parameters.Data.Category", Name: validation.MaxLength, Rule: 64, Chain: nil}}},
				}}}}}); err != nil {
		return result, validation.NewError("mobileengagement.CampaignsClient", "TestNew", err.Error())
	}

	req, err := client.TestNewPreparer(ctx, resourceGroupName, appCollection, appName, kind, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "TestNew", nil, "Failure preparing request")
		return
	}

	resp, err := client.TestNewSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "TestNew", resp, "Failure sending request")
		return
	}

	result, err = client.TestNewResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "TestNew", resp, "Failure responding to request")
	}

	return
}

// TestNewPreparer prepares the TestNew request.
func (client CampaignsClient) TestNewPreparer(ctx context.Context, resourceGroupName string, appCollection string, appName string, kind CampaignKinds, parameters CampaignTestNewParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"kind":              autorest.Encode("path", kind),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}/test", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// TestNewSender sends the TestNew request. The method will close the
// http.Response Body if it receives an error.
func (client CampaignsClient) TestNewSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// TestNewResponder handles the response to the TestNew request. The method always
// closes the http.Response Body.
func (client CampaignsClient) TestNewResponder(resp *http.Response) (result CampaignState, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// TestSaved test an existing campaign (created with Create campaign) on a set of devices.
//
// resourceGroupName is the name of the resource group. appCollection is application collection. appName is
// application resource name. kind is campaign kind. ID is campaign identifier. parameters is parameters supplied
// to the Test Campaign operation.
func (client CampaignsClient) TestSaved(ctx context.Context, resourceGroupName string, appCollection string, appName string, kind CampaignKinds, ID int32, parameters CampaignTestSavedParameters) (result CampaignStateResult, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.DeviceID", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("mobileengagement.CampaignsClient", "TestSaved", err.Error())
	}

	req, err := client.TestSavedPreparer(ctx, resourceGroupName, appCollection, appName, kind, ID, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "TestSaved", nil, "Failure preparing request")
		return
	}

	resp, err := client.TestSavedSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "TestSaved", resp, "Failure sending request")
		return
	}

	result, err = client.TestSavedResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "TestSaved", resp, "Failure responding to request")
	}

	return
}

// TestSavedPreparer prepares the TestSaved request.
func (client CampaignsClient) TestSavedPreparer(ctx context.Context, resourceGroupName string, appCollection string, appName string, kind CampaignKinds, ID int32, parameters CampaignTestSavedParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"id":                autorest.Encode("path", ID),
		"kind":              autorest.Encode("path", kind),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}/{id}/test", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// TestSavedSender sends the TestSaved request. The method will close the
// http.Response Body if it receives an error.
func (client CampaignsClient) TestSavedSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// TestSavedResponder handles the response to the TestSaved request. The method always
// closes the http.Response Body.
func (client CampaignsClient) TestSavedResponder(resp *http.Response) (result CampaignStateResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Update update an existing push campaign (announcement, poll, data push or native push).
//
// kind is campaign kind. ID is campaign identifier. parameters is parameters supplied to the Update Campaign
// operation. resourceGroupName is the name of the resource group. appCollection is application collection. appName
// is application resource name.
func (client CampaignsClient) Update(ctx context.Context, kind CampaignKinds, ID int32, parameters Campaign, resourceGroupName string, appCollection string, appName string) (result CampaignStateResult, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.Name", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.Name", Name: validation.MaxLength, Rule: 64, Chain: nil}}},
				{Target: "parameters.Category", Name: validation.Null, Rule: false,
					Chain: []validation.Constraint{{Target: "parameters.Category", Name: validation.MaxLength, Rule: 64, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("mobileengagement.CampaignsClient", "Update", err.Error())
	}

	req, err := client.UpdatePreparer(ctx, kind, ID, parameters, resourceGroupName, appCollection, appName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Update", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Update", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "mobileengagement.CampaignsClient", "Update", resp, "Failure responding to request")
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client CampaignsClient) UpdatePreparer(ctx context.Context, kind CampaignKinds, ID int32, parameters Campaign, resourceGroupName string, appCollection string, appName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"appCollection":     autorest.Encode("path", appCollection),
		"appName":           autorest.Encode("path", appName),
		"id":                autorest.Encode("path", ID),
		"kind":              autorest.Encode("path", kind),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2014-12-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MobileEngagement/appcollections/{appCollection}/apps/{appName}/campaigns/{kind}/{id}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client CampaignsClient) UpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client CampaignsClient) UpdateResponder(resp *http.Response) (result CampaignStateResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
