package contentmoderator

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"io"
	"net/http"
)

// ImageModerationClient is the you use the API to scan your content as it is generated. Content Moderator then
// processes your content and sends the results along with relevant information either back to your systems or to the
// built-in review tool. You can use this information to take decisions e.g. take it down, send to human judge, etc.
//
// When using the API, images need to have a minimum of 128 pixels and a maximum file size of 4MB.
// Text can be at most 1024 characters long.
// If the content passed to the text API or the image API exceeds the size limits, the API will return an error code
// that informs about the issue.
//
// This API is currently available in:
//
// * West US - westus.api.cognitive.microsoft.com
// * East US 2 - eastus2.api.cognitive.microsoft.com
// * West Central US - westcentralus.api.cognitive.microsoft.com
// * West Europe - westeurope.api.cognitive.microsoft.com
// * Southeast Asia - southeastasia.api.cognitive.microsoft.com .
type ImageModerationClient struct {
	BaseClient
}

// NewImageModerationClient creates an instance of the ImageModerationClient client.
func NewImageModerationClient(baseURL AzureRegionBaseURL) ImageModerationClient {
	return ImageModerationClient{New(baseURL)}
}

// EvaluateFileInput returns probabilities of the image containing racy or adult content.
//
// imageStream is the image file. imageStream will be closed upon successful return. Callers should ensure closure
// when receiving an error.cacheImage is whether to retain the submitted image for future use; defaults to false if
// omitted.
func (client ImageModerationClient) EvaluateFileInput(ctx context.Context, imageStream io.ReadCloser, cacheImage *bool) (result Evaluate, err error) {
	req, err := client.EvaluateFileInputPreparer(ctx, imageStream, cacheImage)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "EvaluateFileInput", nil, "Failure preparing request")
		return
	}

	resp, err := client.EvaluateFileInputSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "EvaluateFileInput", resp, "Failure sending request")
		return
	}

	result, err = client.EvaluateFileInputResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "EvaluateFileInput", resp, "Failure responding to request")
	}

	return
}

// EvaluateFileInputPreparer prepares the EvaluateFileInput request.
func (client ImageModerationClient) EvaluateFileInputPreparer(ctx context.Context, imageStream io.ReadCloser, cacheImage *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"baseUrl": client.BaseURL,
	}

	queryParameters := map[string]interface{}{}
	if cacheImage != nil {
		queryParameters["CacheImage"] = autorest.Encode("query", *cacheImage)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsOctetStream(),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{baseUrl}", urlParameters),
		autorest.WithPath("/contentmoderator/moderate/v1.0/ProcessImage/Evaluate"),
		autorest.WithFile(imageStream),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// EvaluateFileInputSender sends the EvaluateFileInput request. The method will close the
// http.Response Body if it receives an error.
func (client ImageModerationClient) EvaluateFileInputSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// EvaluateFileInputResponder handles the response to the EvaluateFileInput request. The method always
// closes the http.Response Body.
func (client ImageModerationClient) EvaluateFileInputResponder(resp *http.Response) (result Evaluate, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// EvaluateMethod returns probabilities of the image containing racy or adult content.
//
// cacheImage is whether to retain the submitted image for future use; defaults to false if omitted.
func (client ImageModerationClient) EvaluateMethod(ctx context.Context, cacheImage *bool) (result Evaluate, err error) {
	req, err := client.EvaluateMethodPreparer(ctx, cacheImage)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "EvaluateMethod", nil, "Failure preparing request")
		return
	}

	resp, err := client.EvaluateMethodSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "EvaluateMethod", resp, "Failure sending request")
		return
	}

	result, err = client.EvaluateMethodResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "EvaluateMethod", resp, "Failure responding to request")
	}

	return
}

// EvaluateMethodPreparer prepares the EvaluateMethod request.
func (client ImageModerationClient) EvaluateMethodPreparer(ctx context.Context, cacheImage *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"baseUrl": client.BaseURL,
	}

	queryParameters := map[string]interface{}{}
	if cacheImage != nil {
		queryParameters["CacheImage"] = autorest.Encode("query", *cacheImage)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{baseUrl}", urlParameters),
		autorest.WithPath("/contentmoderator/moderate/v1.0/ProcessImage/Evaluate"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// EvaluateMethodSender sends the EvaluateMethod request. The method will close the
// http.Response Body if it receives an error.
func (client ImageModerationClient) EvaluateMethodSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// EvaluateMethodResponder handles the response to the EvaluateMethod request. The method always
// closes the http.Response Body.
func (client ImageModerationClient) EvaluateMethodResponder(resp *http.Response) (result Evaluate, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// EvaluateURLInput returns probabilities of the image containing racy or adult content.
//
// contentType is the content type. imageURL is the image url. cacheImage is whether to retain the submitted image
// for future use; defaults to false if omitted.
func (client ImageModerationClient) EvaluateURLInput(ctx context.Context, contentType string, imageURL BodyModel, cacheImage *bool) (result Evaluate, err error) {
	req, err := client.EvaluateURLInputPreparer(ctx, contentType, imageURL, cacheImage)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "EvaluateURLInput", nil, "Failure preparing request")
		return
	}

	resp, err := client.EvaluateURLInputSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "EvaluateURLInput", resp, "Failure sending request")
		return
	}

	result, err = client.EvaluateURLInputResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "EvaluateURLInput", resp, "Failure responding to request")
	}

	return
}

// EvaluateURLInputPreparer prepares the EvaluateURLInput request.
func (client ImageModerationClient) EvaluateURLInputPreparer(ctx context.Context, contentType string, imageURL BodyModel, cacheImage *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"baseUrl": client.BaseURL,
	}

	queryParameters := map[string]interface{}{}
	if cacheImage != nil {
		queryParameters["CacheImage"] = autorest.Encode("query", *cacheImage)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{baseUrl}", urlParameters),
		autorest.WithPath("/contentmoderator/moderate/v1.0/ProcessImage/Evaluate"),
		autorest.WithJSON(imageURL),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Content-Type", autorest.String(contentType)))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// EvaluateURLInputSender sends the EvaluateURLInput request. The method will close the
// http.Response Body if it receives an error.
func (client ImageModerationClient) EvaluateURLInputSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// EvaluateURLInputResponder handles the response to the EvaluateURLInput request. The method always
// closes the http.Response Body.
func (client ImageModerationClient) EvaluateURLInputResponder(resp *http.Response) (result Evaluate, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// FindFaces returns the list of faces found.
//
// cacheImage is whether to retain the submitted image for future use; defaults to false if omitted.
func (client ImageModerationClient) FindFaces(ctx context.Context, cacheImage *bool) (result FoundFaces, err error) {
	req, err := client.FindFacesPreparer(ctx, cacheImage)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "FindFaces", nil, "Failure preparing request")
		return
	}

	resp, err := client.FindFacesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "FindFaces", resp, "Failure sending request")
		return
	}

	result, err = client.FindFacesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "FindFaces", resp, "Failure responding to request")
	}

	return
}

// FindFacesPreparer prepares the FindFaces request.
func (client ImageModerationClient) FindFacesPreparer(ctx context.Context, cacheImage *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"baseUrl": client.BaseURL,
	}

	queryParameters := map[string]interface{}{}
	if cacheImage != nil {
		queryParameters["CacheImage"] = autorest.Encode("query", *cacheImage)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{baseUrl}", urlParameters),
		autorest.WithPath("/contentmoderator/moderate/v1.0/ProcessImage/FindFaces"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// FindFacesSender sends the FindFaces request. The method will close the
// http.Response Body if it receives an error.
func (client ImageModerationClient) FindFacesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// FindFacesResponder handles the response to the FindFaces request. The method always
// closes the http.Response Body.
func (client ImageModerationClient) FindFacesResponder(resp *http.Response) (result FoundFaces, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// FindFacesFileInput returns the list of faces found.
//
// imageStream is the image file. imageStream will be closed upon successful return. Callers should ensure closure
// when receiving an error.cacheImage is whether to retain the submitted image for future use; defaults to false if
// omitted.
func (client ImageModerationClient) FindFacesFileInput(ctx context.Context, imageStream io.ReadCloser, cacheImage *bool) (result FoundFaces, err error) {
	req, err := client.FindFacesFileInputPreparer(ctx, imageStream, cacheImage)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "FindFacesFileInput", nil, "Failure preparing request")
		return
	}

	resp, err := client.FindFacesFileInputSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "FindFacesFileInput", resp, "Failure sending request")
		return
	}

	result, err = client.FindFacesFileInputResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "FindFacesFileInput", resp, "Failure responding to request")
	}

	return
}

// FindFacesFileInputPreparer prepares the FindFacesFileInput request.
func (client ImageModerationClient) FindFacesFileInputPreparer(ctx context.Context, imageStream io.ReadCloser, cacheImage *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"baseUrl": client.BaseURL,
	}

	queryParameters := map[string]interface{}{}
	if cacheImage != nil {
		queryParameters["CacheImage"] = autorest.Encode("query", *cacheImage)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsOctetStream(),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{baseUrl}", urlParameters),
		autorest.WithPath("/contentmoderator/moderate/v1.0/ProcessImage/FindFaces"),
		autorest.WithFile(imageStream),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// FindFacesFileInputSender sends the FindFacesFileInput request. The method will close the
// http.Response Body if it receives an error.
func (client ImageModerationClient) FindFacesFileInputSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// FindFacesFileInputResponder handles the response to the FindFacesFileInput request. The method always
// closes the http.Response Body.
func (client ImageModerationClient) FindFacesFileInputResponder(resp *http.Response) (result FoundFaces, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// FindFacesURLInput returns the list of faces found.
//
// contentType is the content type. imageURL is the image url. cacheImage is whether to retain the submitted image
// for future use; defaults to false if omitted.
func (client ImageModerationClient) FindFacesURLInput(ctx context.Context, contentType string, imageURL BodyModel, cacheImage *bool) (result FoundFaces, err error) {
	req, err := client.FindFacesURLInputPreparer(ctx, contentType, imageURL, cacheImage)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "FindFacesURLInput", nil, "Failure preparing request")
		return
	}

	resp, err := client.FindFacesURLInputSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "FindFacesURLInput", resp, "Failure sending request")
		return
	}

	result, err = client.FindFacesURLInputResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "FindFacesURLInput", resp, "Failure responding to request")
	}

	return
}

// FindFacesURLInputPreparer prepares the FindFacesURLInput request.
func (client ImageModerationClient) FindFacesURLInputPreparer(ctx context.Context, contentType string, imageURL BodyModel, cacheImage *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"baseUrl": client.BaseURL,
	}

	queryParameters := map[string]interface{}{}
	if cacheImage != nil {
		queryParameters["CacheImage"] = autorest.Encode("query", *cacheImage)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{baseUrl}", urlParameters),
		autorest.WithPath("/contentmoderator/moderate/v1.0/ProcessImage/FindFaces"),
		autorest.WithJSON(imageURL),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Content-Type", autorest.String(contentType)))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// FindFacesURLInputSender sends the FindFacesURLInput request. The method will close the
// http.Response Body if it receives an error.
func (client ImageModerationClient) FindFacesURLInputSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// FindFacesURLInputResponder handles the response to the FindFacesURLInput request. The method always
// closes the http.Response Body.
func (client ImageModerationClient) FindFacesURLInputResponder(resp *http.Response) (result FoundFaces, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// MatchFileInput fuzzily match an image against one of your custom Image Lists. You can create and manage your custom
// image lists using <a href="/docs/services/578ff44d2703741568569ab9/operations/578ff7b12703741568569abe">this</a>
// API.
//
// Returns ID and tags of matching image.<br/>
// <br/>
// Note: Refresh Index must be run on the corresponding Image List before additions and removals are reflected in the
// response.
//
// imageStream is the image file. imageStream will be closed upon successful return. Callers should ensure closure
// when receiving an error.listID is the list Id. cacheImage is whether to retain the submitted image for future
// use; defaults to false if omitted.
func (client ImageModerationClient) MatchFileInput(ctx context.Context, imageStream io.ReadCloser, listID string, cacheImage *bool) (result MatchResponse, err error) {
	req, err := client.MatchFileInputPreparer(ctx, imageStream, listID, cacheImage)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "MatchFileInput", nil, "Failure preparing request")
		return
	}

	resp, err := client.MatchFileInputSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "MatchFileInput", resp, "Failure sending request")
		return
	}

	result, err = client.MatchFileInputResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "MatchFileInput", resp, "Failure responding to request")
	}

	return
}

// MatchFileInputPreparer prepares the MatchFileInput request.
func (client ImageModerationClient) MatchFileInputPreparer(ctx context.Context, imageStream io.ReadCloser, listID string, cacheImage *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"baseUrl": client.BaseURL,
	}

	queryParameters := map[string]interface{}{}
	if len(listID) > 0 {
		queryParameters["listId"] = autorest.Encode("query", listID)
	}
	if cacheImage != nil {
		queryParameters["CacheImage"] = autorest.Encode("query", *cacheImage)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsOctetStream(),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{baseUrl}", urlParameters),
		autorest.WithPath("/contentmoderator/moderate/v1.0/ProcessImage/Match"),
		autorest.WithFile(imageStream),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// MatchFileInputSender sends the MatchFileInput request. The method will close the
// http.Response Body if it receives an error.
func (client ImageModerationClient) MatchFileInputSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// MatchFileInputResponder handles the response to the MatchFileInput request. The method always
// closes the http.Response Body.
func (client ImageModerationClient) MatchFileInputResponder(resp *http.Response) (result MatchResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// MatchMethod fuzzily match an image against one of your custom Image Lists. You can create and manage your custom
// image lists using <a href="/docs/services/578ff44d2703741568569ab9/operations/578ff7b12703741568569abe">this</a>
// API.
//
// Returns ID and tags of matching image.<br/>
// <br/>
// Note: Refresh Index must be run on the corresponding Image List before additions and removals are reflected in the
// response.
//
// listID is the list Id. cacheImage is whether to retain the submitted image for future use; defaults to false if
// omitted.
func (client ImageModerationClient) MatchMethod(ctx context.Context, listID string, cacheImage *bool) (result MatchResponse, err error) {
	req, err := client.MatchMethodPreparer(ctx, listID, cacheImage)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "MatchMethod", nil, "Failure preparing request")
		return
	}

	resp, err := client.MatchMethodSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "MatchMethod", resp, "Failure sending request")
		return
	}

	result, err = client.MatchMethodResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "MatchMethod", resp, "Failure responding to request")
	}

	return
}

// MatchMethodPreparer prepares the MatchMethod request.
func (client ImageModerationClient) MatchMethodPreparer(ctx context.Context, listID string, cacheImage *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"baseUrl": client.BaseURL,
	}

	queryParameters := map[string]interface{}{}
	if len(listID) > 0 {
		queryParameters["listId"] = autorest.Encode("query", listID)
	}
	if cacheImage != nil {
		queryParameters["CacheImage"] = autorest.Encode("query", *cacheImage)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{baseUrl}", urlParameters),
		autorest.WithPath("/contentmoderator/moderate/v1.0/ProcessImage/Match"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// MatchMethodSender sends the MatchMethod request. The method will close the
// http.Response Body if it receives an error.
func (client ImageModerationClient) MatchMethodSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// MatchMethodResponder handles the response to the MatchMethod request. The method always
// closes the http.Response Body.
func (client ImageModerationClient) MatchMethodResponder(resp *http.Response) (result MatchResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// MatchURLInput fuzzily match an image against one of your custom Image Lists. You can create and manage your custom
// image lists using <a href="/docs/services/578ff44d2703741568569ab9/operations/578ff7b12703741568569abe">this</a>
// API.
//
// Returns ID and tags of matching image.<br/>
// <br/>
// Note: Refresh Index must be run on the corresponding Image List before additions and removals are reflected in the
// response.
//
// contentType is the content type. imageURL is the image url. listID is the list Id. cacheImage is whether to
// retain the submitted image for future use; defaults to false if omitted.
func (client ImageModerationClient) MatchURLInput(ctx context.Context, contentType string, imageURL BodyModel, listID string, cacheImage *bool) (result MatchResponse, err error) {
	req, err := client.MatchURLInputPreparer(ctx, contentType, imageURL, listID, cacheImage)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "MatchURLInput", nil, "Failure preparing request")
		return
	}

	resp, err := client.MatchURLInputSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "MatchURLInput", resp, "Failure sending request")
		return
	}

	result, err = client.MatchURLInputResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "MatchURLInput", resp, "Failure responding to request")
	}

	return
}

// MatchURLInputPreparer prepares the MatchURLInput request.
func (client ImageModerationClient) MatchURLInputPreparer(ctx context.Context, contentType string, imageURL BodyModel, listID string, cacheImage *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"baseUrl": client.BaseURL,
	}

	queryParameters := map[string]interface{}{}
	if len(listID) > 0 {
		queryParameters["listId"] = autorest.Encode("query", listID)
	}
	if cacheImage != nil {
		queryParameters["CacheImage"] = autorest.Encode("query", *cacheImage)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{baseUrl}", urlParameters),
		autorest.WithPath("/contentmoderator/moderate/v1.0/ProcessImage/Match"),
		autorest.WithJSON(imageURL),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Content-Type", autorest.String(contentType)))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// MatchURLInputSender sends the MatchURLInput request. The method will close the
// http.Response Body if it receives an error.
func (client ImageModerationClient) MatchURLInputSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// MatchURLInputResponder handles the response to the MatchURLInput request. The method always
// closes the http.Response Body.
func (client ImageModerationClient) MatchURLInputResponder(resp *http.Response) (result MatchResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// OCRFileInput returns any text found in the image for the language specified. If no language is specified in input
// then the detection defaults to English.
//
// language is language of the terms. imageStream is the image file. imageStream will be closed upon successful
// return. Callers should ensure closure when receiving an error.cacheImage is whether to retain the submitted
// image for future use; defaults to false if omitted. enhanced is when set to True, the image goes through
// additional processing to come with additional candidates.
//
// image/tiff is not supported when enhanced is set to true
//
// Note: This impacts the response time.
func (client ImageModerationClient) OCRFileInput(ctx context.Context, language string, imageStream io.ReadCloser, cacheImage *bool, enhanced *bool) (result OCR, err error) {
	req, err := client.OCRFileInputPreparer(ctx, language, imageStream, cacheImage, enhanced)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "OCRFileInput", nil, "Failure preparing request")
		return
	}

	resp, err := client.OCRFileInputSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "OCRFileInput", resp, "Failure sending request")
		return
	}

	result, err = client.OCRFileInputResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "OCRFileInput", resp, "Failure responding to request")
	}

	return
}

// OCRFileInputPreparer prepares the OCRFileInput request.
func (client ImageModerationClient) OCRFileInputPreparer(ctx context.Context, language string, imageStream io.ReadCloser, cacheImage *bool, enhanced *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"baseUrl": client.BaseURL,
	}

	queryParameters := map[string]interface{}{
		"language": autorest.Encode("query", language),
	}
	if cacheImage != nil {
		queryParameters["CacheImage"] = autorest.Encode("query", *cacheImage)
	}
	if enhanced != nil {
		queryParameters["enhanced"] = autorest.Encode("query", *enhanced)
	} else {
		queryParameters["enhanced"] = autorest.Encode("query", false)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsOctetStream(),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{baseUrl}", urlParameters),
		autorest.WithPath("/contentmoderator/moderate/v1.0/ProcessImage/OCR"),
		autorest.WithFile(imageStream),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// OCRFileInputSender sends the OCRFileInput request. The method will close the
// http.Response Body if it receives an error.
func (client ImageModerationClient) OCRFileInputSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// OCRFileInputResponder handles the response to the OCRFileInput request. The method always
// closes the http.Response Body.
func (client ImageModerationClient) OCRFileInputResponder(resp *http.Response) (result OCR, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// OCRMethod returns any text found in the image for the language specified. If no language is specified in input then
// the detection defaults to English.
//
// language is language of the terms. cacheImage is whether to retain the submitted image for future use; defaults
// to false if omitted. enhanced is when set to True, the image goes through additional processing to come with
// additional candidates.
//
// image/tiff is not supported when enhanced is set to true
//
// Note: This impacts the response time.
func (client ImageModerationClient) OCRMethod(ctx context.Context, language string, cacheImage *bool, enhanced *bool) (result OCR, err error) {
	req, err := client.OCRMethodPreparer(ctx, language, cacheImage, enhanced)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "OCRMethod", nil, "Failure preparing request")
		return
	}

	resp, err := client.OCRMethodSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "OCRMethod", resp, "Failure sending request")
		return
	}

	result, err = client.OCRMethodResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "OCRMethod", resp, "Failure responding to request")
	}

	return
}

// OCRMethodPreparer prepares the OCRMethod request.
func (client ImageModerationClient) OCRMethodPreparer(ctx context.Context, language string, cacheImage *bool, enhanced *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"baseUrl": client.BaseURL,
	}

	queryParameters := map[string]interface{}{
		"language": autorest.Encode("query", language),
	}
	if cacheImage != nil {
		queryParameters["CacheImage"] = autorest.Encode("query", *cacheImage)
	}
	if enhanced != nil {
		queryParameters["enhanced"] = autorest.Encode("query", *enhanced)
	} else {
		queryParameters["enhanced"] = autorest.Encode("query", false)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{baseUrl}", urlParameters),
		autorest.WithPath("/contentmoderator/moderate/v1.0/ProcessImage/OCR"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// OCRMethodSender sends the OCRMethod request. The method will close the
// http.Response Body if it receives an error.
func (client ImageModerationClient) OCRMethodSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// OCRMethodResponder handles the response to the OCRMethod request. The method always
// closes the http.Response Body.
func (client ImageModerationClient) OCRMethodResponder(resp *http.Response) (result OCR, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// OCRURLInput returns any text found in the image for the language specified. If no language is specified in input
// then the detection defaults to English.
//
// language is language of the terms. contentType is the content type. imageURL is the image url. cacheImage is
// whether to retain the submitted image for future use; defaults to false if omitted. enhanced is when set to
// True, the image goes through additional processing to come with additional candidates.
//
// image/tiff is not supported when enhanced is set to true
//
// Note: This impacts the response time.
func (client ImageModerationClient) OCRURLInput(ctx context.Context, language string, contentType string, imageURL BodyModel, cacheImage *bool, enhanced *bool) (result OCR, err error) {
	req, err := client.OCRURLInputPreparer(ctx, language, contentType, imageURL, cacheImage, enhanced)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "OCRURLInput", nil, "Failure preparing request")
		return
	}

	resp, err := client.OCRURLInputSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "OCRURLInput", resp, "Failure sending request")
		return
	}

	result, err = client.OCRURLInputResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "contentmoderator.ImageModerationClient", "OCRURLInput", resp, "Failure responding to request")
	}

	return
}

// OCRURLInputPreparer prepares the OCRURLInput request.
func (client ImageModerationClient) OCRURLInputPreparer(ctx context.Context, language string, contentType string, imageURL BodyModel, cacheImage *bool, enhanced *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"baseUrl": client.BaseURL,
	}

	queryParameters := map[string]interface{}{
		"language": autorest.Encode("query", language),
	}
	if cacheImage != nil {
		queryParameters["CacheImage"] = autorest.Encode("query", *cacheImage)
	}
	if enhanced != nil {
		queryParameters["enhanced"] = autorest.Encode("query", *enhanced)
	} else {
		queryParameters["enhanced"] = autorest.Encode("query", false)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{baseUrl}", urlParameters),
		autorest.WithPath("/contentmoderator/moderate/v1.0/ProcessImage/OCR"),
		autorest.WithJSON(imageURL),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Content-Type", autorest.String(contentType)))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// OCRURLInputSender sends the OCRURLInput request. The method will close the
// http.Response Body if it receives an error.
func (client ImageModerationClient) OCRURLInputSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// OCRURLInputResponder handles the response to the OCRURLInput request. The method always
// closes the http.Response Body.
func (client ImageModerationClient) OCRURLInputResponder(resp *http.Response) (result OCR, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
