package commerce

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"net/http"
)

// SubscriberUsageAggregatesClient is the commerce Admin Client
type SubscriberUsageAggregatesClient struct {
	BaseClient
}

// NewSubscriberUsageAggregatesClient creates an instance of the SubscriberUsageAggregatesClient client.
func NewSubscriberUsageAggregatesClient(subscriptionID string) SubscriberUsageAggregatesClient {
	return NewSubscriberUsageAggregatesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewSubscriberUsageAggregatesClientWithBaseURI creates an instance of the SubscriberUsageAggregatesClient client.
func NewSubscriberUsageAggregatesClientWithBaseURI(baseURI string, subscriptionID string) SubscriberUsageAggregatesClient {
	return SubscriberUsageAggregatesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// List gets a collection of SubscriberUsageAggregates, which are UsageAggregates from direct tenants.
//
// reportedStartTime is the reported start time (inclusive). reportedEndTime is the reported end time (exclusive).
// aggregationGranularity is the aggregation granularity. subscriberID is the tenant subscription identifier.
// continuationToken is the continuation token.
func (client SubscriberUsageAggregatesClient) List(ctx context.Context, reportedStartTime date.Time, reportedEndTime date.Time, aggregationGranularity string, subscriberID string, continuationToken string) (result UsageAggregatePage, err error) {
	req, err := client.ListPreparer(ctx, reportedStartTime, reportedEndTime, aggregationGranularity, subscriberID, continuationToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "commerce.SubscriberUsageAggregatesClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "commerce.SubscriberUsageAggregatesClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "commerce.SubscriberUsageAggregatesClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client SubscriberUsageAggregatesClient) ListPreparer(ctx context.Context, reportedStartTime date.Time, reportedEndTime date.Time, aggregationGranularity string, subscriberID string, continuationToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-06-01-preview"
	queryParameters := map[string]interface{}{
		"api-version":       APIVersion,
		"reportedEndTime":   autorest.Encode("query", reportedEndTime),
		"reportedStartTime": autorest.Encode("query", reportedStartTime),
	}
	if len(aggregationGranularity) > 0 {
		queryParameters["aggregationGranularity"] = autorest.Encode("query", aggregationGranularity)
	}
	if len(subscriberID) > 0 {
		queryParameters["subscriberId"] = autorest.Encode("query", subscriberID)
	}
	if len(continuationToken) > 0 {
		queryParameters["continuationToken"] = autorest.Encode("query", continuationToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Commerce/subscriberUsageAggregates", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client SubscriberUsageAggregatesClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client SubscriberUsageAggregatesClient) ListResponder(resp *http.Response) (result UsageAggregatePage, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
