// Code generated by lister-gen. DO NOT EDIT.

package internalversion

import (
	authorization "github.com/openshift/origin/pkg/authorization/apis/authorization"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// RoleBindingRestrictionLister helps list RoleBindingRestrictions.
type RoleBindingRestrictionLister interface {
	// List lists all RoleBindingRestrictions in the indexer.
	List(selector labels.Selector) (ret []*authorization.RoleBindingRestriction, err error)
	// RoleBindingRestrictions returns an object that can list and get RoleBindingRestrictions.
	RoleBindingRestrictions(namespace string) RoleBindingRestrictionNamespaceLister
	RoleBindingRestrictionListerExpansion
}

// roleBindingRestrictionLister implements the RoleBindingRestrictionLister interface.
type roleBindingRestrictionLister struct {
	indexer cache.Indexer
}

// NewRoleBindingRestrictionLister returns a new RoleBindingRestrictionLister.
func NewRoleBindingRestrictionLister(indexer cache.Indexer) RoleBindingRestrictionLister {
	return &roleBindingRestrictionLister{indexer: indexer}
}

// List lists all RoleBindingRestrictions in the indexer.
func (s *roleBindingRestrictionLister) List(selector labels.Selector) (ret []*authorization.RoleBindingRestriction, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*authorization.RoleBindingRestriction))
	})
	return ret, err
}

// RoleBindingRestrictions returns an object that can list and get RoleBindingRestrictions.
func (s *roleBindingRestrictionLister) RoleBindingRestrictions(namespace string) RoleBindingRestrictionNamespaceLister {
	return roleBindingRestrictionNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// RoleBindingRestrictionNamespaceLister helps list and get RoleBindingRestrictions.
type RoleBindingRestrictionNamespaceLister interface {
	// List lists all RoleBindingRestrictions in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*authorization.RoleBindingRestriction, err error)
	// Get retrieves the RoleBindingRestriction from the indexer for a given namespace and name.
	Get(name string) (*authorization.RoleBindingRestriction, error)
	RoleBindingRestrictionNamespaceListerExpansion
}

// roleBindingRestrictionNamespaceLister implements the RoleBindingRestrictionNamespaceLister
// interface.
type roleBindingRestrictionNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all RoleBindingRestrictions in the indexer for a given namespace.
func (s roleBindingRestrictionNamespaceLister) List(selector labels.Selector) (ret []*authorization.RoleBindingRestriction, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*authorization.RoleBindingRestriction))
	})
	return ret, err
}

// Get retrieves the RoleBindingRestriction from the indexer for a given namespace and name.
func (s roleBindingRestrictionNamespaceLister) Get(name string) (*authorization.RoleBindingRestriction, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(authorization.Resource("rolebindingrestriction"), name)
	}
	return obj.(*authorization.RoleBindingRestriction), nil
}
