package management

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// ChildType enumerates the values for child type.
type ChildType string

const (
	// ManagementGroup ...
	ManagementGroup ChildType = "ManagementGroup"
	// Subscription ...
	Subscription ChildType = "Subscription"
)

// CreateManagementGroupRequest management group creation parameters.
type CreateManagementGroupRequest struct {
	// DisplayName - The friendly name of the management group.
	DisplayName *string `json:"displayName,omitempty"`
	// ParentID - (Optional) The fully qualified ID for the parent management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ParentID *string `json:"parentId,omitempty"`
}

// ErrorDetails the details of the error.
type ErrorDetails struct {
	// Code - One of a server-defined set of error codes.
	Code *string `json:"code,omitempty"`
	// Message - A human-readable representation of the error.
	Message *string `json:"message,omitempty"`
}

// ErrorResponse the error object.
type ErrorResponse struct {
	Error *ErrorDetails `json:"error,omitempty"`
}

// Group the management group details.
type Group struct {
	autorest.Response `json:"-"`
	// ID - The fully qualified ID for the management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ID *string `json:"id,omitempty"`
	// Type - The type of the resource.  For example, /providers/Microsoft.Management/managementGroups
	Type *string `json:"type,omitempty"`
	// Name - The name of the management group. For example, 00000000-0000-0000-0000-000000000000
	Name             *string `json:"name,omitempty"`
	*GroupProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for Group struct.
func (g *Group) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				g.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				g.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				g.Name = &name
			}
		case "properties":
			if v != nil {
				var groupProperties GroupProperties
				err = json.Unmarshal(*v, &groupProperties)
				if err != nil {
					return err
				}
				g.GroupProperties = &groupProperties
			}
		}
	}

	return nil
}

// GroupChildInfo the child information of a management group.
type GroupChildInfo struct {
	// ChildType - Possible values include: 'ManagementGroup', 'Subscription'
	ChildType ChildType `json:"childType,omitempty"`
	// ChildID - The fully qualified ID for the child resource (management group or subscription).  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ChildID *string `json:"childId,omitempty"`
	// DisplayName - The friendly name of the child resource.
	DisplayName *string `json:"displayName,omitempty"`
	// Children - The list of children.
	Children *[]GroupChildInfo `json:"children,omitempty"`
}

// GroupDetails the details of a management group.
type GroupDetails struct {
	// Version - The version number of the object.
	Version *float64 `json:"version,omitempty"`
	// UpdatedTime - The date and time when this object was last updated.
	UpdatedTime *date.Time `json:"updatedTime,omitempty"`
	// UpdatedBy - The identity of the principal or process that updated the object.
	UpdatedBy *string          `json:"updatedBy,omitempty"`
	Parent    *ParentGroupInfo `json:"parent,omitempty"`
}

// GroupInfo the management group resource.
type GroupInfo struct {
	// ID - The fully qualified ID for the management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ID *string `json:"id,omitempty"`
	// Type - The type of the resource. For example, /providers/Microsoft.Management/managementGroups
	Type *string `json:"type,omitempty"`
	// Name - The name of the management group. For example, 00000000-0000-0000-0000-000000000000
	Name                 *string `json:"name,omitempty"`
	*GroupInfoProperties `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for GroupInfo struct.
func (gi *GroupInfo) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				gi.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				gi.Type = &typeVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				gi.Name = &name
			}
		case "properties":
			if v != nil {
				var groupInfoProperties GroupInfoProperties
				err = json.Unmarshal(*v, &groupInfoProperties)
				if err != nil {
					return err
				}
				gi.GroupInfoProperties = &groupInfoProperties
			}
		}
	}

	return nil
}

// GroupInfoProperties the generic properties of a management group.
type GroupInfoProperties struct {
	// TenantID - The AAD Tenant ID associated with the management group. For example, 00000000-0000-0000-0000-000000000000
	TenantID *string `json:"tenantId,omitempty"`
	// DisplayName - The friendly name of the management group.
	DisplayName *string `json:"displayName,omitempty"`
}

// GroupListResult describes the result of the request to list management groups.
type GroupListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of management groups.
	Value *[]GroupInfo `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// GroupListResultIterator provides access to a complete listing of GroupInfo values.
type GroupListResultIterator struct {
	i    int
	page GroupListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GroupListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GroupListResultIterator) Response() GroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GroupListResultIterator) Value() GroupInfo {
	if !iter.page.NotDone() {
		return GroupInfo{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (glr GroupListResult) IsEmpty() bool {
	return glr.Value == nil || len(*glr.Value) == 0
}

// groupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (glr GroupListResult) groupListResultPreparer() (*http.Request, error) {
	if glr.NextLink == nil || len(to.String(glr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(glr.NextLink)))
}

// GroupListResultPage contains a page of GroupInfo values.
type GroupListResultPage struct {
	fn  func(GroupListResult) (GroupListResult, error)
	glr GroupListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GroupListResultPage) Next() error {
	next, err := page.fn(page.glr)
	if err != nil {
		return err
	}
	page.glr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GroupListResultPage) NotDone() bool {
	return !page.glr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GroupListResultPage) Response() GroupListResult {
	return page.glr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GroupListResultPage) Values() []GroupInfo {
	if page.glr.IsEmpty() {
		return nil
	}
	return *page.glr.Value
}

// GroupProperties the generic properties of a management group.
type GroupProperties struct {
	// TenantID - The AAD Tenant ID associated with the management group. For example, 00000000-0000-0000-0000-000000000000
	TenantID *string `json:"tenantId,omitempty"`
	// DisplayName - The friendly name of the management group.
	DisplayName *string       `json:"displayName,omitempty"`
	Details     *GroupDetails `json:"details,omitempty"`
	// Children - The list of children.
	Children *[]GroupChildInfo `json:"children,omitempty"`
}

// Operation operation supported by the Microsoft.Management resource provider.
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - The name of the provider.
	Provider *string `json:"provider,omitempty"`
	// Resource - The resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation that can be performed.
	Operation *string `json:"operation,omitempty"`
	// Description - Operation description.
	Description *string `json:"description,omitempty"`
}

// OperationListResult describes the result of the request to list Microsoft.Management operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of operations supported by the Microsoft.Management resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer() (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) Next() error {
	next, err := page.fn(page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// ParentGroupInfo (Optional) The ID of the parent management group.
type ParentGroupInfo struct {
	// ParentID - The fully qualified ID for the parent management group.  For example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000
	ParentID *string `json:"parentId,omitempty"`
	// DisplayName - The friendly name of the parent management group.
	DisplayName *string `json:"displayName,omitempty"`
}
