package hdinsight

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// AsyncOperationState enumerates the values for async operation state.
type AsyncOperationState string

const (
	// Failed ...
	Failed AsyncOperationState = "Failed"
	// InProgress ...
	InProgress AsyncOperationState = "InProgress"
	// Succeeded ...
	Succeeded AsyncOperationState = "Succeeded"
)

// ClusterProvisioningState enumerates the values for cluster provisioning state.
type ClusterProvisioningState string

const (
	// ClusterProvisioningStateCanceled ...
	ClusterProvisioningStateCanceled ClusterProvisioningState = "Canceled"
	// ClusterProvisioningStateDeleting ...
	ClusterProvisioningStateDeleting ClusterProvisioningState = "Deleting"
	// ClusterProvisioningStateFailed ...
	ClusterProvisioningStateFailed ClusterProvisioningState = "Failed"
	// ClusterProvisioningStateInProgress ...
	ClusterProvisioningStateInProgress ClusterProvisioningState = "InProgress"
	// ClusterProvisioningStateSucceeded ...
	ClusterProvisioningStateSucceeded ClusterProvisioningState = "Succeeded"
)

// DirectoryType enumerates the values for directory type.
type DirectoryType string

const (
	// ActiveDirectory ...
	ActiveDirectory DirectoryType = "ActiveDirectory"
)

// EnabledCredential enumerates the values for enabled credential.
type EnabledCredential string

const (
	// False ...
	False EnabledCredential = "false"
	// True ...
	True EnabledCredential = "true"
)

// OSType enumerates the values for os type.
type OSType string

const (
	// Linux ...
	Linux OSType = "Linux"
	// Windows ...
	Windows OSType = "Windows"
)

// Tier enumerates the values for tier.
type Tier string

const (
	// Premium ...
	Premium Tier = "Premium"
	// Standard ...
	Standard Tier = "Standard"
)

// Application the HDInsight cluster application
type Application struct {
	autorest.Response `json:"-"`
	// Etag - The ETag for the application
	Etag *string `json:"etag,omitempty"`
	// Tags - The tags for the application.
	Tags map[string]*string `json:"tags"`
	// Properties - The properties of the application.
	Properties *ApplicationGetProperties `json:"properties,omitempty"`
	// ID - Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Application.
func (a Application) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Etag != nil {
		objectMap["etag"] = a.Etag
	}
	if a.Tags != nil {
		objectMap["tags"] = a.Tags
	}
	if a.Properties != nil {
		objectMap["properties"] = a.Properties
	}
	if a.ID != nil {
		objectMap["id"] = a.ID
	}
	if a.Name != nil {
		objectMap["name"] = a.Name
	}
	if a.Type != nil {
		objectMap["type"] = a.Type
	}
	return json.Marshal(objectMap)
}

// ApplicationGetEndpoint gets the application SSH endpoint
type ApplicationGetEndpoint struct {
	// Location - The location of the endpoint.
	Location *string `json:"location,omitempty"`
	// DestinationPort - The destination port to connect to.
	DestinationPort *int32 `json:"destinationPort,omitempty"`
	// PublicPort - The public port to connect to.
	PublicPort *int32 `json:"publicPort,omitempty"`
}

// ApplicationGetHTTPSEndpoint gets the application HTTP endpoints.
type ApplicationGetHTTPSEndpoint struct {
	// AdditionalProperties - Unmatched properties from the message are deserialized this collection
	AdditionalProperties map[string]*string `json:""`
	// AccessModes - The list of access modes for the application.
	AccessModes *[]string `json:"accessModes,omitempty"`
	// Location - The location of the endpoint.
	Location *string `json:"location,omitempty"`
	// DestinationPort - The destination port to connect to.
	DestinationPort *int32 `json:"destinationPort,omitempty"`
	// PublicPort - The public port to connect to.
	PublicPort *int32 `json:"publicPort,omitempty"`
}

// MarshalJSON is the custom marshaler for ApplicationGetHTTPSEndpoint.
func (aghe ApplicationGetHTTPSEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aghe.AccessModes != nil {
		objectMap["accessModes"] = aghe.AccessModes
	}
	if aghe.Location != nil {
		objectMap["location"] = aghe.Location
	}
	if aghe.DestinationPort != nil {
		objectMap["destinationPort"] = aghe.DestinationPort
	}
	if aghe.PublicPort != nil {
		objectMap["publicPort"] = aghe.PublicPort
	}
	for k, v := range aghe.AdditionalProperties {
		objectMap[k] = v
	}
	return json.Marshal(objectMap)
}

// ApplicationGetProperties the HDInsight cluster application GET response.
type ApplicationGetProperties struct {
	// ComputeProfile - The list of roles in the cluster.
	ComputeProfile *ComputeProfile `json:"computeProfile,omitempty"`
	// InstallScriptActions - The list of install script actions.
	InstallScriptActions *[]RuntimeScriptAction `json:"installScriptActions,omitempty"`
	// UninstallScriptActions - The list of uninstall script actions.
	UninstallScriptActions *[]RuntimeScriptAction `json:"uninstallScriptActions,omitempty"`
	// HTTPSEndpoints - The list of application HTTPS endpoints.
	HTTPSEndpoints *[]ApplicationGetHTTPSEndpoint `json:"httpsEndpoints,omitempty"`
	// SSHEndpoints - The list of application SSH endpoints.
	SSHEndpoints *[]ApplicationGetEndpoint `json:"sshEndpoints,omitempty"`
	// ProvisioningState - The provisioning state of the application.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// ApplicationType - The application type.
	ApplicationType *string `json:"applicationType,omitempty"`
	// ApplicationState - The application state.
	ApplicationState *string `json:"applicationState,omitempty"`
	// Errors - The list of errors.
	Errors *[]Errors `json:"errors,omitempty"`
	// CreatedDate - The application create date time.
	CreatedDate *string `json:"createdDate,omitempty"`
	// MarketplaceIdentifier - The marketplace identifier.
	MarketplaceIdentifier *string `json:"marketplaceIdentifier,omitempty"`
	// AdditionalProperties - The additional properties for application.
	AdditionalProperties *string `json:"additionalProperties,omitempty"`
}

// ApplicationListResult result of the request to list cluster Applications. It contains a list of operations and a
// URL link to get the next set of results.
type ApplicationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of HDInsight applications installed on HDInsight cluster.
	Value *[]Application `json:"value,omitempty"`
	// NextLink - The URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ApplicationListResultIterator provides access to a complete listing of Application values.
type ApplicationListResultIterator struct {
	i    int
	page ApplicationListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ApplicationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ApplicationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ApplicationListResultIterator) Response() ApplicationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ApplicationListResultIterator) Value() Application {
	if !iter.page.NotDone() {
		return Application{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (alr ApplicationListResult) IsEmpty() bool {
	return alr.Value == nil || len(*alr.Value) == 0
}

// applicationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (alr ApplicationListResult) applicationListResultPreparer() (*http.Request, error) {
	if alr.NextLink == nil || len(to.String(alr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(alr.NextLink)))
}

// ApplicationListResultPage contains a page of Application values.
type ApplicationListResultPage struct {
	fn  func(ApplicationListResult) (ApplicationListResult, error)
	alr ApplicationListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ApplicationListResultPage) Next() error {
	next, err := page.fn(page.alr)
	if err != nil {
		return err
	}
	page.alr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ApplicationListResultPage) NotDone() bool {
	return !page.alr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ApplicationListResultPage) Response() ApplicationListResult {
	return page.alr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ApplicationListResultPage) Values() []Application {
	if page.alr.IsEmpty() {
		return nil
	}
	return *page.alr.Value
}

// ApplicationsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ApplicationsDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ApplicationsDeleteFuture) Result(client ApplicationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ApplicationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("hdinsight.ApplicationsDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "hdinsight.ApplicationsDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ApplicationsDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ApplicationsDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// CapabilitiesResult the Get Capabilities operation response.
type CapabilitiesResult struct {
	autorest.Response `json:"-"`
	// Versions - The version capability.
	Versions map[string]*VersionsCapability `json:"versions"`
	// Regions - The virtual machine size compatibilty features.
	Regions map[string]*RegionsCapability `json:"regions"`
	// VMSizes - The virtual machine sizes.
	VMSizes map[string]*VMSizesCapability `json:"vmSizes"`
	// VMSizeFilters - The virtual machine size compatibilty filters.
	VMSizeFilters *[]VMSizeCompatibilityFilter `json:"vmSize_filters,omitempty"`
	// Features - The capabilty features.
	Features *[]string `json:"features,omitempty"`
	// Quota - The quota capability.
	Quota *QuotaCapability `json:"quota,omitempty"`
}

// MarshalJSON is the custom marshaler for CapabilitiesResult.
func (cr CapabilitiesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cr.Versions != nil {
		objectMap["versions"] = cr.Versions
	}
	if cr.Regions != nil {
		objectMap["regions"] = cr.Regions
	}
	if cr.VMSizes != nil {
		objectMap["vmSizes"] = cr.VMSizes
	}
	if cr.VMSizeFilters != nil {
		objectMap["vmSize_filters"] = cr.VMSizeFilters
	}
	if cr.Features != nil {
		objectMap["features"] = cr.Features
	}
	if cr.Quota != nil {
		objectMap["quota"] = cr.Quota
	}
	return json.Marshal(objectMap)
}

// Cluster the HDInsight cluster.
type Cluster struct {
	autorest.Response `json:"-"`
	// Etag - The ETag for the resource
	Etag *string `json:"etag,omitempty"`
	// Properties - The properties of the cluster.
	Properties *ClusterGetProperties `json:"properties,omitempty"`
	// Location - The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.Etag != nil {
		objectMap["etag"] = c.Etag
	}
	if c.Properties != nil {
		objectMap["properties"] = c.Properties
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	if c.ID != nil {
		objectMap["id"] = c.ID
	}
	if c.Name != nil {
		objectMap["name"] = c.Name
	}
	if c.Type != nil {
		objectMap["type"] = c.Type
	}
	return json.Marshal(objectMap)
}

// ClusterCreateParametersExtended the CreateCluster request parameters.
type ClusterCreateParametersExtended struct {
	// Location - The location of the cluster.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
	// Properties - The cluster create parameters.
	Properties *ClusterCreateProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterCreateParametersExtended.
func (ccpe ClusterCreateParametersExtended) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ccpe.Location != nil {
		objectMap["location"] = ccpe.Location
	}
	if ccpe.Tags != nil {
		objectMap["tags"] = ccpe.Tags
	}
	if ccpe.Properties != nil {
		objectMap["properties"] = ccpe.Properties
	}
	return json.Marshal(objectMap)
}

// ClusterCreateProperties the cluster create parameters.
type ClusterCreateProperties struct {
	// ClusterVersion - The version of the cluster.
	ClusterVersion *string `json:"clusterVersion,omitempty"`
	// OsType - The type of operating system. Possible values include: 'Windows', 'Linux'
	OsType OSType `json:"osType,omitempty"`
	// Tier - The cluster tier. Possible values include: 'Standard', 'Premium'
	Tier Tier `json:"tier,omitempty"`
	// ClusterDefinition - The cluster definition.
	ClusterDefinition *ClusterDefinition `json:"clusterDefinition,omitempty"`
	// SecurityProfile - The security profile.
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`
	// ComputeProfile - The compute profile.
	ComputeProfile *ComputeProfile `json:"computeProfile,omitempty"`
	// StorageProfile - The storage profile.
	StorageProfile *StorageProfile `json:"storageProfile,omitempty"`
}

// ClusterDefinition the cluster definition.
type ClusterDefinition struct {
	// Blueprint - The link to the blueprint.
	Blueprint *string `json:"blueprint,omitempty"`
	// Kind - The type of cluster.
	Kind *string `json:"kind,omitempty"`
	// ComponentVersion - The versions of different services in the cluster.
	ComponentVersion map[string]*string `json:"componentVersion"`
	// Configurations - The cluster configurations.
	Configurations interface{} `json:"configurations,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterDefinition.
func (cd ClusterDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cd.Blueprint != nil {
		objectMap["blueprint"] = cd.Blueprint
	}
	if cd.Kind != nil {
		objectMap["kind"] = cd.Kind
	}
	if cd.ComponentVersion != nil {
		objectMap["componentVersion"] = cd.ComponentVersion
	}
	objectMap["configurations"] = cd.Configurations
	return json.Marshal(objectMap)
}

// ClusterGetProperties the properties of cluster.
type ClusterGetProperties struct {
	// ClusterVersion - The version of the cluster.
	ClusterVersion *string `json:"clusterVersion,omitempty"`
	// OsType - The type of operating system. Possible values include: 'Windows', 'Linux'
	OsType OSType `json:"osType,omitempty"`
	// Tier - The cluster tier. Possible values include: 'Standard', 'Premium'
	Tier Tier `json:"tier,omitempty"`
	// ClusterDefinition - The cluster definition.
	ClusterDefinition *ClusterDefinition `json:"clusterDefinition,omitempty"`
	// SecurityProfile - The security profile.
	SecurityProfile *SecurityProfile `json:"securityProfile,omitempty"`
	// ComputeProfile - The compute profile.
	ComputeProfile *ComputeProfile `json:"computeProfile,omitempty"`
	// ProvisioningState - The provisioning state, which only appears in the response. Possible values include: 'ClusterProvisioningStateInProgress', 'ClusterProvisioningStateFailed', 'ClusterProvisioningStateSucceeded', 'ClusterProvisioningStateCanceled', 'ClusterProvisioningStateDeleting'
	ProvisioningState ClusterProvisioningState `json:"provisioningState,omitempty"`
	// CreatedDate - The date on which the cluster was created.
	CreatedDate *string `json:"createdDate,omitempty"`
	// ClusterState - The state of the cluster.
	ClusterState *string `json:"clusterState,omitempty"`
	// QuotaInfo - The quota information.
	QuotaInfo *QuotaInfo `json:"quotaInfo,omitempty"`
	// Errors - The list of errors.
	Errors *[]Errors `json:"errors,omitempty"`
	// ConnectivityEndpoints - The list of connectivity endpoints.
	ConnectivityEndpoints *[]ConnectivityEndpoint `json:"connectivityEndpoints,omitempty"`
}

// ClusterListPersistedScriptActionsResult the ListPersistedScriptActions operation response.
type ClusterListPersistedScriptActionsResult struct {
	// Value - The list of Persisted Script Actions.
	Value *[]RuntimeScriptAction `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ClusterListResult the List Cluster operation response.
type ClusterListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of Clusters.
	Value *[]Cluster `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ClusterListResultIterator provides access to a complete listing of Cluster values.
type ClusterListResultIterator struct {
	i    int
	page ClusterListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClusterListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClusterListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClusterListResultIterator) Response() ClusterListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClusterListResultIterator) Value() Cluster {
	if !iter.page.NotDone() {
		return Cluster{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (clr ClusterListResult) IsEmpty() bool {
	return clr.Value == nil || len(*clr.Value) == 0
}

// clusterListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (clr ClusterListResult) clusterListResultPreparer() (*http.Request, error) {
	if clr.NextLink == nil || len(to.String(clr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(clr.NextLink)))
}

// ClusterListResultPage contains a page of Cluster values.
type ClusterListResultPage struct {
	fn  func(ClusterListResult) (ClusterListResult, error)
	clr ClusterListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClusterListResultPage) Next() error {
	next, err := page.fn(page.clr)
	if err != nil {
		return err
	}
	page.clr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClusterListResultPage) NotDone() bool {
	return !page.clr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClusterListResultPage) Response() ClusterListResult {
	return page.clr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClusterListResultPage) Values() []Cluster {
	if page.clr.IsEmpty() {
		return nil
	}
	return *page.clr.Value
}

// ClusterListRuntimeScriptActionDetailResult the list runtime script action detail response.
type ClusterListRuntimeScriptActionDetailResult struct {
	// Value - The list of persisted script action details for the cluster.
	Value *[]RuntimeScriptActionDetail `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ClusterMonitoringRequest the Operations Management Suite (OMS) parameters.
type ClusterMonitoringRequest struct {
	// WorkspaceID - The Operations Management Suite (OMS) workspace ID.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// PrimaryKey - The Operations Management Suite (OMS) workspace key.
	PrimaryKey *string `json:"primaryKey,omitempty"`
}

// ClusterMonitoringResponse the Operations Management Suite (OMS) status response
type ClusterMonitoringResponse struct {
	autorest.Response `json:"-"`
	// ClusterMonitoringEnabled - The status of the Operations Management Suite (OMS) on the HDInsight cluster.
	ClusterMonitoringEnabled *bool `json:"ClusterMonitoringEnabled,omitempty"`
	// WorkspaceID - The workspace ID of the Operations Management Suite (OMS) on the HDInsight cluster.
	WorkspaceID *string `json:"WorkspaceId,omitempty"`
}

// ClusterPatchParameters the PatchCluster request parameters
type ClusterPatchParameters struct {
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ClusterPatchParameters.
func (cpp ClusterPatchParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cpp.Tags != nil {
		objectMap["tags"] = cpp.Tags
	}
	return json.Marshal(objectMap)
}

// ClusterResizeParameters the Resize Cluster request parameters.
type ClusterResizeParameters struct {
	// TargetInstanceCount - The target instance count for the operation.
	TargetInstanceCount *int32 `json:"targetInstanceCount,omitempty"`
}

// ClustersCreateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ClustersCreateFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ClustersCreateFuture) Result(client ClustersClient) (c Cluster, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return c, azure.NewAsyncOpIncompleteError("hdinsight.ClustersCreateFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		c, err = client.CreateResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "hdinsight.ClustersCreateFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersCreateFuture", "Result", resp, "Failure sending request")
		return
	}
	c, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersCreateFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ClustersDeleteFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ClustersDeleteFuture) Result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("hdinsight.ClustersDeleteFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DeleteResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "hdinsight.ClustersDeleteFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersDeleteFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersDeleteFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ClustersExecuteScriptActionsFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersExecuteScriptActionsFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ClustersExecuteScriptActionsFuture) Result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersExecuteScriptActionsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("hdinsight.ClustersExecuteScriptActionsFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.ExecuteScriptActionsResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "hdinsight.ClustersExecuteScriptActionsFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersExecuteScriptActionsFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.ExecuteScriptActionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersExecuteScriptActionsFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ClustersResizeFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type ClustersResizeFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ClustersResizeFuture) Result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersResizeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("hdinsight.ClustersResizeFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.ResizeResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "hdinsight.ClustersResizeFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersResizeFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.ResizeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ClustersResizeFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ComputeProfile describes the compute profile.
type ComputeProfile struct {
	// Roles - The list of roles in the cluster.
	Roles *[]Role `json:"roles,omitempty"`
}

// ConfigurationsUpdateHTTPSettingsFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ConfigurationsUpdateHTTPSettingsFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ConfigurationsUpdateHTTPSettingsFuture) Result(client ConfigurationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ConfigurationsUpdateHTTPSettingsFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("hdinsight.ConfigurationsUpdateHTTPSettingsFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.UpdateHTTPSettingsResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "hdinsight.ConfigurationsUpdateHTTPSettingsFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ConfigurationsUpdateHTTPSettingsFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.UpdateHTTPSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ConfigurationsUpdateHTTPSettingsFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ConnectivityEndpoint the connectivity properties
type ConnectivityEndpoint struct {
	// Name - The name of the endpoint.
	Name *string `json:"name,omitempty"`
	// Protocol - The protocol of the endpoint.
	Protocol *string `json:"protocol,omitempty"`
	// Location - The location of the endpoint.
	Location *string `json:"location,omitempty"`
	// Port - The port to connect to.
	Port *int32 `json:"port,omitempty"`
}

// DataDisksGroups the data disks groups for the role.
type DataDisksGroups struct {
	// DisksPerNode - The number of disks per node.
	DisksPerNode *int32 `json:"disksPerNode,omitempty"`
	// StorageAccountType - ReadOnly. The storage account type. Do not set this value.
	StorageAccountType *string `json:"storageAccountType,omitempty"`
	// DiskSizeGB - ReadOnly. The DiskSize in GB. Do not set this value.
	DiskSizeGB *int32 `json:"diskSizeGB,omitempty"`
}

// Errors the error message associated with the cluster creation.
type Errors struct {
	// Code - The error code.
	Code *string `json:"code,omitempty"`
	// Message - The error message.
	Message *string `json:"message,omitempty"`
}

// ExecuteScriptActionParameters the parameters for the script actions to execute on a running cluster.
type ExecuteScriptActionParameters struct {
	// ScriptActions - The list of run time script actions.
	ScriptActions *[]RuntimeScriptAction `json:"scriptActions,omitempty"`
	// PersistOnSuccess - Gets or sets if the scripts needs to be persisted.
	PersistOnSuccess *bool `json:"persistOnSuccess,omitempty"`
}

// Extension cluster monitoring extensions
type Extension struct {
	autorest.Response `json:"-"`
	// WorkspaceID - The workspace ID for the cluster monitoring extension.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// PrimaryKey - The certificate for the cluster monitoring extensions.
	PrimaryKey *string `json:"primaryKey,omitempty"`
}

// ExtensionDisableMonitoringFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExtensionDisableMonitoringFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ExtensionDisableMonitoringFuture) Result(client ExtensionClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ExtensionDisableMonitoringFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("hdinsight.ExtensionDisableMonitoringFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.DisableMonitoringResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "hdinsight.ExtensionDisableMonitoringFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ExtensionDisableMonitoringFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.DisableMonitoringResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ExtensionDisableMonitoringFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// ExtensionEnableMonitoringFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExtensionEnableMonitoringFuture struct {
	azure.Future
	req *http.Request
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future ExtensionEnableMonitoringFuture) Result(client ExtensionClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ExtensionEnableMonitoringFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		return ar, azure.NewAsyncOpIncompleteError("hdinsight.ExtensionEnableMonitoringFuture")
	}
	if future.PollingMethod() == azure.PollingLocation {
		ar, err = client.EnableMonitoringResponder(future.Response())
		if err != nil {
			err = autorest.NewErrorWithError(err, "hdinsight.ExtensionEnableMonitoringFuture", "Result", future.Response(), "Failure responding to request")
		}
		return
	}
	var req *http.Request
	var resp *http.Response
	if future.PollingURL() != "" {
		req, err = http.NewRequest(http.MethodGet, future.PollingURL(), nil)
		if err != nil {
			return
		}
	} else {
		req = autorest.ChangeToGet(future.req)
	}
	resp, err = autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ExtensionEnableMonitoringFuture", "Result", resp, "Failure sending request")
		return
	}
	ar, err = client.EnableMonitoringResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ExtensionEnableMonitoringFuture", "Result", resp, "Failure responding to request")
	}
	return
}

// HardwareProfile the hardware profile.
type HardwareProfile struct {
	// VMSize - The size of the VM
	VMSize *string `json:"vmSize,omitempty"`
}

// HTTPConnectivitySettings the payload for a Configure HTTP settings request.
type HTTPConnectivitySettings struct {
	// EnabledCredential - Whether or not the HTTP based authorization is enabled. Possible values include: 'True', 'False'
	EnabledCredential EnabledCredential `json:"restAuthCredential.isEnabled,omitempty"`
	// Username - The HTTP username.
	Username *string `json:"restAuthCredential.username,omitempty"`
	// Password - The HTTP user password.
	Password *string `json:"restAuthCredential.password,omitempty"`
}

// LinuxOperatingSystemProfile the ssh username, password, and ssh public key.
type LinuxOperatingSystemProfile struct {
	// Username - The username.
	Username *string `json:"username,omitempty"`
	// Password - The password.
	Password *string `json:"password,omitempty"`
	// SSHProfile - The SSH profile.
	SSHProfile *SSHProfile `json:"sshProfile,omitempty"`
}

// Operation the HDInsight REST API operation.
type Operation struct {
	// Name - The operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - The service provider: Microsoft.HDInsight
	Provider *string `json:"provider,omitempty"`
	// Resource - The resource on which the operation is performed: Cluster, Capabilities, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation type: read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// OperationListResult result of the request to list HDInsight operations. It contains a list of operations and a
// URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of HDInsight operations supported by the HDInsight resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - The URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer() (*http.Request, error) {
	if olr.NextLink == nil || len(to.String(olr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) Next() error {
	next, err := page.fn(page.olr)
	if err != nil {
		return err
	}
	page.olr = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// OperationResource the azure async operation response.
type OperationResource struct {
	// Status - The async operation state. Possible values include: 'InProgress', 'Succeeded', 'Failed'
	Status AsyncOperationState `json:"status,omitempty"`
	// Error - The operation error information.
	Error *Errors `json:"error,omitempty"`
}

// OsProfile the Linux operation systems profile.
type OsProfile struct {
	// LinuxOperatingSystemProfile - The Linux OS profile.
	LinuxOperatingSystemProfile *LinuxOperatingSystemProfile `json:"linuxOperatingSystemProfile,omitempty"`
}

// ProxyResource the resource model definition for a ARM proxy resource. It will have everything other than
// required location and tags
type ProxyResource struct {
	// ID - Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
}

// QuotaCapability the regional quota capability.
type QuotaCapability struct {
	// RegionalQuotas - The list of region quota capabilities.
	RegionalQuotas *[]RegionalQuotaCapability `json:"regionalQuotas,omitempty"`
}

// QuotaInfo the quota properties for the cluster.
type QuotaInfo struct {
	// CoresUsed - The cores used by the cluster.
	CoresUsed *int32 `json:"coresUsed,omitempty"`
}

// RegionalQuotaCapability the regional quota capacity.
type RegionalQuotaCapability struct {
	// RegionName - The region name.
	RegionName *string `json:"region_name,omitempty"`
	// CoresUsed - The number of cores used in the region.
	CoresUsed *int64 `json:"cores_used,omitempty"`
	// CoresAvailable - The number of courses available in the region.
	CoresAvailable *int64 `json:"cores_available,omitempty"`
}

// RegionsCapability the regions capability.
type RegionsCapability struct {
	// Available - The list of region capabilities.
	Available *[]string `json:"available,omitempty"`
}

// Resource the core properties of ARM resources
type Resource struct {
	// ID - Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
}

// Role describes a role on the cluster.
type Role struct {
	// Name - The name of the role.
	Name *string `json:"name,omitempty"`
	// MinInstanceCount - The minimum instance count of the cluster.
	MinInstanceCount *int32 `json:"minInstanceCount,omitempty"`
	// TargetInstanceCount - The instance count of the cluster.
	TargetInstanceCount *int32 `json:"targetInstanceCount,omitempty"`
	// HardwareProfile - The hardware profile.
	HardwareProfile *HardwareProfile `json:"hardwareProfile,omitempty"`
	// OsProfile - The operating system profile.
	OsProfile *OsProfile `json:"osProfile,omitempty"`
	// VirtualNetworkProfile - The virtual network profile.
	VirtualNetworkProfile *VirtualNetworkProfile `json:"virtualNetworkProfile,omitempty"`
	// DataDisksGroups - The data disks groups for the role.
	DataDisksGroups *[]DataDisksGroups `json:"dataDisksGroups,omitempty"`
	// ScriptActions - The list of script actions on the role.
	ScriptActions *[]ScriptAction `json:"scriptActions,omitempty"`
}

// RuntimeScriptAction describes a script action on a running cluster.
type RuntimeScriptAction struct {
	// Name - The name of the script action.
	Name *string `json:"name,omitempty"`
	// URI - The URI to the script.
	URI *string `json:"uri,omitempty"`
	// Parameters - The parameters for the script
	Parameters *string `json:"parameters,omitempty"`
	// Roles - The list of roles where script will be executed.
	Roles *[]string `json:"roles,omitempty"`
	// ApplicationName - The application name of the script action, if any.
	ApplicationName *string `json:"applicationName,omitempty"`
}

// RuntimeScriptActionDetail the execution details of a script action.
type RuntimeScriptActionDetail struct {
	autorest.Response `json:"-"`
	// ScriptExecutionID - The execution id of the script action.
	ScriptExecutionID *int64 `json:"scriptExecutionId,omitempty"`
	// StartTime - The start time of script action execution.
	StartTime *string `json:"startTime,omitempty"`
	// EndTime - The end time of script action execution.
	EndTime *string `json:"endTime,omitempty"`
	// Status - The current execution status of the script action.
	Status *string `json:"status,omitempty"`
	// Operation - The reason why the script action was executed.
	Operation *string `json:"operation,omitempty"`
	// ExecutionSummary - The summary of script action execution result.
	ExecutionSummary *[]ScriptActionExecutionSummary `json:"executionSummary,omitempty"`
	// DebugInformation - The script action execution debug information.
	DebugInformation *string `json:"debugInformation,omitempty"`
	// Name - The name of the script action.
	Name *string `json:"name,omitempty"`
	// URI - The URI to the script.
	URI *string `json:"uri,omitempty"`
	// Parameters - The parameters for the script
	Parameters *string `json:"parameters,omitempty"`
	// Roles - The list of roles where script will be executed.
	Roles *[]string `json:"roles,omitempty"`
	// ApplicationName - The application name of the script action, if any.
	ApplicationName *string `json:"applicationName,omitempty"`
}

// ScriptAction describes a script action on role on the cluster.
type ScriptAction struct {
	// Name - The name of the script action.
	Name *string `json:"name,omitempty"`
	// URI - The URI to the script.
	URI *string `json:"uri,omitempty"`
	// Parameters - The parameters for the script provided.
	Parameters *string `json:"parameters,omitempty"`
}

// ScriptActionExecutionHistoryList the list script execution history response.
type ScriptActionExecutionHistoryList struct {
	autorest.Response `json:"-"`
	// Value - The list of persisted script action details for the cluster.
	Value *[]RuntimeScriptActionDetail `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ScriptActionExecutionHistoryListIterator provides access to a complete listing of RuntimeScriptActionDetail
// values.
type ScriptActionExecutionHistoryListIterator struct {
	i    int
	page ScriptActionExecutionHistoryListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ScriptActionExecutionHistoryListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ScriptActionExecutionHistoryListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ScriptActionExecutionHistoryListIterator) Response() ScriptActionExecutionHistoryList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ScriptActionExecutionHistoryListIterator) Value() RuntimeScriptActionDetail {
	if !iter.page.NotDone() {
		return RuntimeScriptActionDetail{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (saehl ScriptActionExecutionHistoryList) IsEmpty() bool {
	return saehl.Value == nil || len(*saehl.Value) == 0
}

// scriptActionExecutionHistoryListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (saehl ScriptActionExecutionHistoryList) scriptActionExecutionHistoryListPreparer() (*http.Request, error) {
	if saehl.NextLink == nil || len(to.String(saehl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(saehl.NextLink)))
}

// ScriptActionExecutionHistoryListPage contains a page of RuntimeScriptActionDetail values.
type ScriptActionExecutionHistoryListPage struct {
	fn    func(ScriptActionExecutionHistoryList) (ScriptActionExecutionHistoryList, error)
	saehl ScriptActionExecutionHistoryList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ScriptActionExecutionHistoryListPage) Next() error {
	next, err := page.fn(page.saehl)
	if err != nil {
		return err
	}
	page.saehl = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ScriptActionExecutionHistoryListPage) NotDone() bool {
	return !page.saehl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ScriptActionExecutionHistoryListPage) Response() ScriptActionExecutionHistoryList {
	return page.saehl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ScriptActionExecutionHistoryListPage) Values() []RuntimeScriptActionDetail {
	if page.saehl.IsEmpty() {
		return nil
	}
	return *page.saehl.Value
}

// ScriptActionExecutionSummary the execution summary of a script action.
type ScriptActionExecutionSummary struct {
	// Status - The status of script action execution.
	Status *string `json:"status,omitempty"`
	// InstanceCount - The instance count for a given script action execution status.
	InstanceCount *int32 `json:"instanceCount,omitempty"`
}

// ScriptActionPersistedGetResponseSpec the persisted script action for cluster.
type ScriptActionPersistedGetResponseSpec struct {
	// Name - The name of script action.
	Name *string `json:"name,omitempty"`
	// URI - The URI to the script.
	URI *string `json:"uri,omitempty"`
	// Parameters - The parameters for the script provided.
	Parameters *string `json:"parameters,omitempty"`
	// Roles - The list of roles where script will be executed.
	Roles *[]string `json:"roles,omitempty"`
	// ApplicationName - The application name for the script action.
	ApplicationName *string `json:"applicationName,omitempty"`
}

// ScriptActionsList the persisted script action for the cluster.
type ScriptActionsList struct {
	autorest.Response `json:"-"`
	// Value - The list of persisted script action details for the cluster.
	Value *[]RuntimeScriptActionDetail `json:"value,omitempty"`
	// NextLink - The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ScriptActionsListIterator provides access to a complete listing of RuntimeScriptActionDetail values.
type ScriptActionsListIterator struct {
	i    int
	page ScriptActionsListPage
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ScriptActionsListIterator) Next() error {
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err := iter.page.Next()
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ScriptActionsListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ScriptActionsListIterator) Response() ScriptActionsList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ScriptActionsListIterator) Value() RuntimeScriptActionDetail {
	if !iter.page.NotDone() {
		return RuntimeScriptActionDetail{}
	}
	return iter.page.Values()[iter.i]
}

// IsEmpty returns true if the ListResult contains no values.
func (sal ScriptActionsList) IsEmpty() bool {
	return sal.Value == nil || len(*sal.Value) == 0
}

// scriptActionsListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sal ScriptActionsList) scriptActionsListPreparer() (*http.Request, error) {
	if sal.NextLink == nil || len(to.String(sal.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sal.NextLink)))
}

// ScriptActionsListPage contains a page of RuntimeScriptActionDetail values.
type ScriptActionsListPage struct {
	fn  func(ScriptActionsList) (ScriptActionsList, error)
	sal ScriptActionsList
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ScriptActionsListPage) Next() error {
	next, err := page.fn(page.sal)
	if err != nil {
		return err
	}
	page.sal = next
	return nil
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ScriptActionsListPage) NotDone() bool {
	return !page.sal.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ScriptActionsListPage) Response() ScriptActionsList {
	return page.sal
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ScriptActionsListPage) Values() []RuntimeScriptActionDetail {
	if page.sal.IsEmpty() {
		return nil
	}
	return *page.sal.Value
}

// SecurityProfile the security profile which contains Ssh public key for the HDInsight cluster.
type SecurityProfile struct {
	// DirectoryType - The directory type. Possible values include: 'ActiveDirectory'
	DirectoryType DirectoryType `json:"directoryType,omitempty"`
	// Domain - The organization's active directory domain.
	Domain *string `json:"domain,omitempty"`
	// OrganizationalUnitDN - The organizational unit within the Active Directory to place the cluster and service accounts.
	OrganizationalUnitDN *string `json:"organizationalUnitDN,omitempty"`
	// LdapsUrls - The LDAPS protocol URLs to communicate with the Active Directory.
	LdapsUrls *[]string `json:"ldapsUrls,omitempty"`
	// DomainUsername - The domain user account that will have admin privileges on the cluster.
	DomainUsername *string `json:"domainUsername,omitempty"`
	// DomainUserPassword - The domain admin password.
	DomainUserPassword *string `json:"domainUserPassword,omitempty"`
	// ClusterUsersGroupDNS - Optional. The Distinguished Names for cluster user groups
	ClusterUsersGroupDNS *[]string `json:"clusterUsersGroupDNs,omitempty"`
}

// SetString ...
type SetString struct {
	autorest.Response `json:"-"`
	Value             map[string]*string `json:"value"`
}

// MarshalJSON is the custom marshaler for SetString.
func (ss SetString) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ss.Value != nil {
		objectMap["value"] = ss.Value
	}
	return json.Marshal(objectMap)
}

// SSHProfile the list of SSH public keys.
type SSHProfile struct {
	// PublicKeys - The list of SSH public keys.
	PublicKeys *[]SSHPublicKey `json:"publicKeys,omitempty"`
}

// SSHPublicKey the SSH public key for the cluster nodes.
type SSHPublicKey struct {
	// CertificateData - The certificate for SSH.
	CertificateData *string `json:"certificateData,omitempty"`
}

// StorageAccount the storage Account.
type StorageAccount struct {
	// Name - The name of the storage account.
	Name *string `json:"name,omitempty"`
	// IsDefault - Whether or not the storage account is the default storage account.
	IsDefault *bool `json:"isDefault,omitempty"`
	// Container - The container in the storage account.
	Container *string `json:"container,omitempty"`
	// Key - The storage account access key.
	Key *string `json:"key,omitempty"`
}

// StorageProfile the storage profile.
type StorageProfile struct {
	// Storageaccounts - The list of storage accounts in the cluster.
	Storageaccounts *[]StorageAccount `json:"storageaccounts,omitempty"`
}

// TrackedResource the resource model definition for a ARM tracked top level resource
type TrackedResource struct {
	// Location - The Azure Region where the resource lives
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ID - Fully qualified resource Id for the resource.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.ID != nil {
		objectMap["id"] = tr.ID
	}
	if tr.Name != nil {
		objectMap["name"] = tr.Name
	}
	if tr.Type != nil {
		objectMap["type"] = tr.Type
	}
	return json.Marshal(objectMap)
}

// VersionsCapability the version capability.
type VersionsCapability struct {
	// Available - The list of version capabilities.
	Available *[]VersionSpec `json:"available,omitempty"`
}

// VersionSpec the version properties.
type VersionSpec struct {
	// FriendlyName - The friendly name
	FriendlyName *string `json:"friendlyName,omitempty"`
	// DisplayName - The display name
	DisplayName *string `json:"displayName,omitempty"`
	// IsDefault - Whether or not the version is the default version.
	IsDefault *string `json:"isDefault,omitempty"`
	// ComponentVersions - The component version property.
	ComponentVersions map[string]*string `json:"componentVersions"`
}

// MarshalJSON is the custom marshaler for VersionSpec.
func (vs VersionSpec) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if vs.FriendlyName != nil {
		objectMap["friendlyName"] = vs.FriendlyName
	}
	if vs.DisplayName != nil {
		objectMap["displayName"] = vs.DisplayName
	}
	if vs.IsDefault != nil {
		objectMap["isDefault"] = vs.IsDefault
	}
	if vs.ComponentVersions != nil {
		objectMap["componentVersions"] = vs.ComponentVersions
	}
	return json.Marshal(objectMap)
}

// VirtualNetworkProfile the virtual network properties.
type VirtualNetworkProfile struct {
	// ID - The ID of the virtual network.
	ID *string `json:"id,omitempty"`
	// Subnet - The name of the subnet.
	Subnet *string `json:"subnet,omitempty"`
}

// VMSizeCompatibilityFilter the virtual machine type compatibility filter.
type VMSizeCompatibilityFilter struct {
	// FilterMode - The mode for the filter.
	FilterMode *string `json:"FilterMode,omitempty"`
	// Regions - The list of regions.
	Regions *[]string `json:"Regions,omitempty"`
	// ClusterFlavors - The list of cluster types available.
	ClusterFlavors *[]string `json:"ClusterFlavors,omitempty"`
	// NodeTypes - The list of node types.
	NodeTypes *[]string `json:"NodeTypes,omitempty"`
	// ClusterVersions - The list of cluster versions.
	ClusterVersions *[]string `json:"ClusterVersions,omitempty"`
	// Vmsizes - The list of virtual machine sizes.
	Vmsizes *[]string `json:"vmsizes,omitempty"`
}

// VMSizesCapability the virtual machine sizes capability.
type VMSizesCapability struct {
	// Available - The list of virtual machine size capabilities.
	Available *[]string `json:"available,omitempty"`
}
