// Code generated by lister-gen. DO NOT EDIT.

package internalversion

import (
	oauth "github.com/openshift/origin/pkg/oauth/apis/oauth"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// OAuthClientLister helps list OAuthClients.
type OAuthClientLister interface {
	// List lists all OAuthClients in the indexer.
	List(selector labels.Selector) (ret []*oauth.OAuthClient, err error)
	// Get retrieves the OAuthClient from the index for a given name.
	Get(name string) (*oauth.OAuthClient, error)
	OAuthClientListerExpansion
}

// oAuthClientLister implements the OAuthClientLister interface.
type oAuthClientLister struct {
	indexer cache.Indexer
}

// NewOAuthClientLister returns a new OAuthClientLister.
func NewOAuthClientLister(indexer cache.Indexer) OAuthClientLister {
	return &oAuthClientLister{indexer: indexer}
}

// List lists all OAuthClients in the indexer.
func (s *oAuthClientLister) List(selector labels.Selector) (ret []*oauth.OAuthClient, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*oauth.OAuthClient))
	})
	return ret, err
}

// Get retrieves the OAuthClient from the index for a given name.
func (s *oAuthClientLister) Get(name string) (*oauth.OAuthClient, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(oauth.Resource("oauthclient"), name)
	}
	return obj.(*oauth.OAuthClient), nil
}
