// Code generated by lister-gen. DO NOT EDIT.

package internalversion

import (
	network "github.com/openshift/origin/pkg/network/apis/network"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// HostSubnetLister helps list HostSubnets.
type HostSubnetLister interface {
	// List lists all HostSubnets in the indexer.
	List(selector labels.Selector) (ret []*network.HostSubnet, err error)
	// Get retrieves the HostSubnet from the index for a given name.
	Get(name string) (*network.HostSubnet, error)
	HostSubnetListerExpansion
}

// hostSubnetLister implements the HostSubnetLister interface.
type hostSubnetLister struct {
	indexer cache.Indexer
}

// NewHostSubnetLister returns a new HostSubnetLister.
func NewHostSubnetLister(indexer cache.Indexer) HostSubnetLister {
	return &hostSubnetLister{indexer: indexer}
}

// List lists all HostSubnets in the indexer.
func (s *hostSubnetLister) List(selector labels.Selector) (ret []*network.HostSubnet, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*network.HostSubnet))
	})
	return ret, err
}

// Get retrieves the HostSubnet from the index for a given name.
func (s *hostSubnetLister) Get(name string) (*network.HostSubnet, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(network.Resource("hostsubnet"), name)
	}
	return obj.(*network.HostSubnet), nil
}
