// +build !ignore_autogenerated_openshift

// Code generated by defaulter-gen. DO NOT EDIT.

package v1

import (
	runtime "k8s.io/apimachinery/pkg/runtime"
	core_v1 "k8s.io/kubernetes/pkg/apis/core/v1"
)

// RegisterDefaults adds defaulters functions to the given scheme.
// Public to allow building arbitrary schemes.
// All generated defaulters are covering - they call all nested defaulters.
func RegisterDefaults(scheme *runtime.Scheme) error {
	scheme.AddTypeDefaultingFunc(&BuildDefaultsConfig{}, func(obj interface{}) { SetObjectDefaults_BuildDefaultsConfig(obj.(*BuildDefaultsConfig)) })
	scheme.AddTypeDefaultingFunc(&MasterConfig{}, func(obj interface{}) { SetObjectDefaults_MasterConfig(obj.(*MasterConfig)) })
	scheme.AddTypeDefaultingFunc(&NodeConfig{}, func(obj interface{}) { SetObjectDefaults_NodeConfig(obj.(*NodeConfig)) })
	return nil
}

func SetObjectDefaults_BuildDefaultsConfig(in *BuildDefaultsConfig) {
	for i := range in.Env {
		a := &in.Env[i]
		if a.ValueFrom != nil {
			if a.ValueFrom.FieldRef != nil {
				core_v1.SetDefaults_ObjectFieldSelector(a.ValueFrom.FieldRef)
			}
		}
	}
	core_v1.SetDefaults_ResourceList(&in.Resources.Limits)
	core_v1.SetDefaults_ResourceList(&in.Resources.Requests)
}

func SetObjectDefaults_MasterConfig(in *MasterConfig) {
	SetDefaults_MasterConfig(in)
	SetDefaults_ServingInfo(&in.ServingInfo.ServingInfo)
	SetDefaults_EtcdStorageConfig(&in.EtcdStorageConfig)
	SetDefaults_KubernetesMasterConfig(&in.KubernetesMasterConfig)
	if in.EtcdConfig != nil {
		SetDefaults_ServingInfo(&in.EtcdConfig.ServingInfo)
		SetDefaults_ServingInfo(&in.EtcdConfig.PeerServingInfo)
	}
	if in.OAuthConfig != nil {
		for i := range in.OAuthConfig.IdentityProviders {
			a := &in.OAuthConfig.IdentityProviders[i]
			SetDefaults_IdentityProvider(a)
		}
		SetDefaults_GrantConfig(&in.OAuthConfig.GrantConfig)
	}
	if in.DNSConfig != nil {
		SetDefaults_DNSConfig(in.DNSConfig)
	}
	if in.MasterClients.OpenShiftLoopbackClientConnectionOverrides != nil {
		SetDefaults_ClientConnectionOverrides(in.MasterClients.OpenShiftLoopbackClientConnectionOverrides)
	}
	SetDefaults_ImagePolicyConfig(&in.ImagePolicyConfig)
	if in.ProjectConfig.SecurityAllocator != nil {
		SetDefaults_SecurityAllocator(in.ProjectConfig.SecurityAllocator)
	}
}

func SetObjectDefaults_NodeConfig(in *NodeConfig) {
	SetDefaults_NodeConfig(in)
	SetDefaults_ServingInfo(&in.ServingInfo)
	if in.MasterClientConnectionOverrides != nil {
		SetDefaults_ClientConnectionOverrides(in.MasterClientConnectionOverrides)
	}
	SetDefaults_DockerConfig(&in.DockerConfig)
}
