// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/videointelligence/v1p3beta1/video_intelligence.proto

package videointelligence // import "google.golang.org/genproto/googleapis/cloud/videointelligence/v1p3beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import duration "github.com/golang/protobuf/ptypes/duration"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import longrunning "google.golang.org/genproto/googleapis/longrunning"
import status "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Video annotation feature.
type Feature int32

const (
	// Unspecified.
	Feature_FEATURE_UNSPECIFIED Feature = 0
	// Label detection. Detect objects, such as dog or flower.
	Feature_LABEL_DETECTION Feature = 1
	// Shot change detection.
	Feature_SHOT_CHANGE_DETECTION Feature = 2
	// Explicit content detection.
	Feature_EXPLICIT_CONTENT_DETECTION Feature = 3
	// OCR text detection and tracking.
	Feature_TEXT_DETECTION Feature = 7
	// Object detection and tracking.
	Feature_OBJECT_TRACKING Feature = 9
)

var Feature_name = map[int32]string{
	0: "FEATURE_UNSPECIFIED",
	1: "LABEL_DETECTION",
	2: "SHOT_CHANGE_DETECTION",
	3: "EXPLICIT_CONTENT_DETECTION",
	7: "TEXT_DETECTION",
	9: "OBJECT_TRACKING",
}
var Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED":        0,
	"LABEL_DETECTION":            1,
	"SHOT_CHANGE_DETECTION":      2,
	"EXPLICIT_CONTENT_DETECTION": 3,
	"TEXT_DETECTION":             7,
	"OBJECT_TRACKING":            9,
}

func (x Feature) String() string {
	return proto.EnumName(Feature_name, int32(x))
}
func (Feature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{0}
}

// Label detection mode.
type LabelDetectionMode int32

const (
	// Unspecified.
	LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED LabelDetectionMode = 0
	// Detect shot-level labels.
	LabelDetectionMode_SHOT_MODE LabelDetectionMode = 1
	// Detect frame-level labels.
	LabelDetectionMode_FRAME_MODE LabelDetectionMode = 2
	// Detect both shot-level and frame-level labels.
	LabelDetectionMode_SHOT_AND_FRAME_MODE LabelDetectionMode = 3
)

var LabelDetectionMode_name = map[int32]string{
	0: "LABEL_DETECTION_MODE_UNSPECIFIED",
	1: "SHOT_MODE",
	2: "FRAME_MODE",
	3: "SHOT_AND_FRAME_MODE",
}
var LabelDetectionMode_value = map[string]int32{
	"LABEL_DETECTION_MODE_UNSPECIFIED": 0,
	"SHOT_MODE":                        1,
	"FRAME_MODE":                       2,
	"SHOT_AND_FRAME_MODE":              3,
}

func (x LabelDetectionMode) String() string {
	return proto.EnumName(LabelDetectionMode_name, int32(x))
}
func (LabelDetectionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{1}
}

// Bucketized representation of likelihood.
type Likelihood int32

const (
	// Unspecified likelihood.
	Likelihood_LIKELIHOOD_UNSPECIFIED Likelihood = 0
	// Very unlikely.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// Unlikely.
	Likelihood_UNLIKELY Likelihood = 2
	// Possible.
	Likelihood_POSSIBLE Likelihood = 3
	// Likely.
	Likelihood_LIKELY Likelihood = 4
	// Very likely.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "LIKELIHOOD_UNSPECIFIED",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}
var Likelihood_value = map[string]int32{
	"LIKELIHOOD_UNSPECIFIED": 0,
	"VERY_UNLIKELY":          1,
	"UNLIKELY":               2,
	"POSSIBLE":               3,
	"LIKELY":                 4,
	"VERY_LIKELY":            5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}
func (Likelihood) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{2}
}

// Streaming video annotation feature.
type StreamingFeature int32

const (
	// Unspecified.
	StreamingFeature_STREAMING_FEATURE_UNSPECIFIED StreamingFeature = 0
	// Label detection. Detect objects, such as dog or flower.
	StreamingFeature_STREAMING_LABEL_DETECTION StreamingFeature = 1
	// Shot change detection.
	StreamingFeature_STREAMING_SHOT_CHANGE_DETECTION StreamingFeature = 2
	// Explicit content detection.
	StreamingFeature_STREAMING_EXPLICIT_CONTENT_DETECTION StreamingFeature = 3
	// Object detection and tracking.
	StreamingFeature_STREAMING_OBJECT_TRACKING StreamingFeature = 4
)

var StreamingFeature_name = map[int32]string{
	0: "STREAMING_FEATURE_UNSPECIFIED",
	1: "STREAMING_LABEL_DETECTION",
	2: "STREAMING_SHOT_CHANGE_DETECTION",
	3: "STREAMING_EXPLICIT_CONTENT_DETECTION",
	4: "STREAMING_OBJECT_TRACKING",
}
var StreamingFeature_value = map[string]int32{
	"STREAMING_FEATURE_UNSPECIFIED":        0,
	"STREAMING_LABEL_DETECTION":            1,
	"STREAMING_SHOT_CHANGE_DETECTION":      2,
	"STREAMING_EXPLICIT_CONTENT_DETECTION": 3,
	"STREAMING_OBJECT_TRACKING":            4,
}

func (x StreamingFeature) String() string {
	return proto.EnumName(StreamingFeature_name, int32(x))
}
func (StreamingFeature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{3}
}

// Video annotation request.
type AnnotateVideoRequest struct {
	// Input video location. Currently, only
	// [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
	// supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
	// more information, see [Request URIs](/storage/docs/reference-uris). A video
	// URI may include wildcards in `object-id`, and thus identify multiple
	// videos. Supported wildcards: '*' to match 0 or more characters;
	// '?' to match 1 character. If unset, the input video should be embedded
	// in the request as `input_content`. If set, `input_content` should be unset.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// The video data bytes.
	// If unset, the input video(s) should be specified via `input_uri`.
	// If set, `input_uri` should be unset.
	InputContent []byte `protobuf:"bytes,6,opt,name=input_content,json=inputContent,proto3" json:"input_content,omitempty"`
	// Requested video annotation features.
	Features []Feature `protobuf:"varint,2,rep,packed,name=features,proto3,enum=google.cloud.videointelligence.v1p3beta1.Feature" json:"features,omitempty"`
	// Additional video context and/or feature-specific parameters.
	VideoContext *VideoContext `protobuf:"bytes,3,opt,name=video_context,json=videoContext,proto3" json:"video_context,omitempty"`
	// Optional location where the output (in JSON format) should be stored.
	// Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
	// URIs are supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For
	// more information, see [Request URIs](/storage/docs/reference-uris).
	OutputUri string `protobuf:"bytes,4,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Optional cloud region where annotation should take place. Supported cloud
	// regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
	// is specified, a region will be determined based on video file location.
	LocationId           string   `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AnnotateVideoRequest) Reset()         { *m = AnnotateVideoRequest{} }
func (m *AnnotateVideoRequest) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoRequest) ProtoMessage()    {}
func (*AnnotateVideoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{0}
}
func (m *AnnotateVideoRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoRequest.Unmarshal(m, b)
}
func (m *AnnotateVideoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoRequest.Marshal(b, m, deterministic)
}
func (dst *AnnotateVideoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoRequest.Merge(dst, src)
}
func (m *AnnotateVideoRequest) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoRequest.Size(m)
}
func (m *AnnotateVideoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoRequest proto.InternalMessageInfo

func (m *AnnotateVideoRequest) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetInputContent() []byte {
	if m != nil {
		return m.InputContent
	}
	return nil
}

func (m *AnnotateVideoRequest) GetFeatures() []Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateVideoRequest) GetVideoContext() *VideoContext {
	if m != nil {
		return m.VideoContext
	}
	return nil
}

func (m *AnnotateVideoRequest) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

// Video context and/or feature-specific parameters.
type VideoContext struct {
	// Video segments to annotate. The segments may overlap and are not required
	// to be contiguous or span the whole video. If unspecified, each video is
	// treated as a single segment.
	Segments []*VideoSegment `protobuf:"bytes,1,rep,name=segments,proto3" json:"segments,omitempty"`
	// Config for LABEL_DETECTION.
	LabelDetectionConfig *LabelDetectionConfig `protobuf:"bytes,2,opt,name=label_detection_config,json=labelDetectionConfig,proto3" json:"label_detection_config,omitempty"`
	// Config for SHOT_CHANGE_DETECTION.
	ShotChangeDetectionConfig *ShotChangeDetectionConfig `protobuf:"bytes,3,opt,name=shot_change_detection_config,json=shotChangeDetectionConfig,proto3" json:"shot_change_detection_config,omitempty"`
	// Config for EXPLICIT_CONTENT_DETECTION.
	ExplicitContentDetectionConfig *ExplicitContentDetectionConfig `protobuf:"bytes,4,opt,name=explicit_content_detection_config,json=explicitContentDetectionConfig,proto3" json:"explicit_content_detection_config,omitempty"`
	// Config for TEXT_DETECTION.
	TextDetectionConfig  *TextDetectionConfig `protobuf:"bytes,8,opt,name=text_detection_config,json=textDetectionConfig,proto3" json:"text_detection_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *VideoContext) Reset()         { *m = VideoContext{} }
func (m *VideoContext) String() string { return proto.CompactTextString(m) }
func (*VideoContext) ProtoMessage()    {}
func (*VideoContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{1}
}
func (m *VideoContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoContext.Unmarshal(m, b)
}
func (m *VideoContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoContext.Marshal(b, m, deterministic)
}
func (dst *VideoContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoContext.Merge(dst, src)
}
func (m *VideoContext) XXX_Size() int {
	return xxx_messageInfo_VideoContext.Size(m)
}
func (m *VideoContext) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoContext.DiscardUnknown(m)
}

var xxx_messageInfo_VideoContext proto.InternalMessageInfo

func (m *VideoContext) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *VideoContext) GetLabelDetectionConfig() *LabelDetectionConfig {
	if m != nil {
		return m.LabelDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetShotChangeDetectionConfig() *ShotChangeDetectionConfig {
	if m != nil {
		return m.ShotChangeDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetExplicitContentDetectionConfig() *ExplicitContentDetectionConfig {
	if m != nil {
		return m.ExplicitContentDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetTextDetectionConfig() *TextDetectionConfig {
	if m != nil {
		return m.TextDetectionConfig
	}
	return nil
}

// Config for LABEL_DETECTION.
type LabelDetectionConfig struct {
	// What labels should be detected with LABEL_DETECTION, in addition to
	// video-level labels or segment-level labels.
	// If unspecified, defaults to `SHOT_MODE`.
	LabelDetectionMode LabelDetectionMode `protobuf:"varint,1,opt,name=label_detection_mode,json=labelDetectionMode,proto3,enum=google.cloud.videointelligence.v1p3beta1.LabelDetectionMode" json:"label_detection_mode,omitempty"`
	// Whether the video has been shot from a stationary (i.e. non-moving) camera.
	// When set to true, might improve detection accuracy for moving objects.
	// Should be used with `SHOT_AND_FRAME_MODE` enabled.
	StationaryCamera bool `protobuf:"varint,2,opt,name=stationary_camera,json=stationaryCamera,proto3" json:"stationary_camera,omitempty"`
	// Model to use for label detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelDetectionConfig) Reset()         { *m = LabelDetectionConfig{} }
func (m *LabelDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*LabelDetectionConfig) ProtoMessage()    {}
func (*LabelDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{2}
}
func (m *LabelDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelDetectionConfig.Unmarshal(m, b)
}
func (m *LabelDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelDetectionConfig.Marshal(b, m, deterministic)
}
func (dst *LabelDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelDetectionConfig.Merge(dst, src)
}
func (m *LabelDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_LabelDetectionConfig.Size(m)
}
func (m *LabelDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_LabelDetectionConfig proto.InternalMessageInfo

func (m *LabelDetectionConfig) GetLabelDetectionMode() LabelDetectionMode {
	if m != nil {
		return m.LabelDetectionMode
	}
	return LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED
}

func (m *LabelDetectionConfig) GetStationaryCamera() bool {
	if m != nil {
		return m.StationaryCamera
	}
	return false
}

func (m *LabelDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for SHOT_CHANGE_DETECTION.
type ShotChangeDetectionConfig struct {
	// Model to use for shot change detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShotChangeDetectionConfig) Reset()         { *m = ShotChangeDetectionConfig{} }
func (m *ShotChangeDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ShotChangeDetectionConfig) ProtoMessage()    {}
func (*ShotChangeDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{3}
}
func (m *ShotChangeDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShotChangeDetectionConfig.Unmarshal(m, b)
}
func (m *ShotChangeDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShotChangeDetectionConfig.Marshal(b, m, deterministic)
}
func (dst *ShotChangeDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShotChangeDetectionConfig.Merge(dst, src)
}
func (m *ShotChangeDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ShotChangeDetectionConfig.Size(m)
}
func (m *ShotChangeDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ShotChangeDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ShotChangeDetectionConfig proto.InternalMessageInfo

func (m *ShotChangeDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for EXPLICIT_CONTENT_DETECTION.
type ExplicitContentDetectionConfig struct {
	// Model to use for explicit content detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExplicitContentDetectionConfig) Reset()         { *m = ExplicitContentDetectionConfig{} }
func (m *ExplicitContentDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentDetectionConfig) ProtoMessage()    {}
func (*ExplicitContentDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{4}
}
func (m *ExplicitContentDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Unmarshal(m, b)
}
func (m *ExplicitContentDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Marshal(b, m, deterministic)
}
func (dst *ExplicitContentDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentDetectionConfig.Merge(dst, src)
}
func (m *ExplicitContentDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Size(m)
}
func (m *ExplicitContentDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentDetectionConfig proto.InternalMessageInfo

func (m *ExplicitContentDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for TEXT_DETECTION.
type TextDetectionConfig struct {
	// Language hint can be specified if the language to be detected is known a
	// priori. It can increase the accuracy of the detection. Language hint must
	// be language code in BCP-47 format.
	//
	// Automatic language detection is performed if no hint is provided.
	LanguageHints        []string `protobuf:"bytes,1,rep,name=language_hints,json=languageHints,proto3" json:"language_hints,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TextDetectionConfig) Reset()         { *m = TextDetectionConfig{} }
func (m *TextDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*TextDetectionConfig) ProtoMessage()    {}
func (*TextDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{5}
}
func (m *TextDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextDetectionConfig.Unmarshal(m, b)
}
func (m *TextDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextDetectionConfig.Marshal(b, m, deterministic)
}
func (dst *TextDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextDetectionConfig.Merge(dst, src)
}
func (m *TextDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_TextDetectionConfig.Size(m)
}
func (m *TextDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_TextDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_TextDetectionConfig proto.InternalMessageInfo

func (m *TextDetectionConfig) GetLanguageHints() []string {
	if m != nil {
		return m.LanguageHints
	}
	return nil
}

// Video segment.
type VideoSegment struct {
	// Time-offset, relative to the beginning of the video,
	// corresponding to the start of the segment (inclusive).
	StartTimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the end of the segment (inclusive).
	EndTimeOffset        *duration.Duration `protobuf:"bytes,2,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *VideoSegment) Reset()         { *m = VideoSegment{} }
func (m *VideoSegment) String() string { return proto.CompactTextString(m) }
func (*VideoSegment) ProtoMessage()    {}
func (*VideoSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{6}
}
func (m *VideoSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoSegment.Unmarshal(m, b)
}
func (m *VideoSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoSegment.Marshal(b, m, deterministic)
}
func (dst *VideoSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoSegment.Merge(dst, src)
}
func (m *VideoSegment) XXX_Size() int {
	return xxx_messageInfo_VideoSegment.Size(m)
}
func (m *VideoSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoSegment.DiscardUnknown(m)
}

var xxx_messageInfo_VideoSegment proto.InternalMessageInfo

func (m *VideoSegment) GetStartTimeOffset() *duration.Duration {
	if m != nil {
		return m.StartTimeOffset
	}
	return nil
}

func (m *VideoSegment) GetEndTimeOffset() *duration.Duration {
	if m != nil {
		return m.EndTimeOffset
	}
	return nil
}

// Video segment level annotation results for label detection.
type LabelSegment struct {
	// Video segment where a label was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelSegment) Reset()         { *m = LabelSegment{} }
func (m *LabelSegment) String() string { return proto.CompactTextString(m) }
func (*LabelSegment) ProtoMessage()    {}
func (*LabelSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{7}
}
func (m *LabelSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelSegment.Unmarshal(m, b)
}
func (m *LabelSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelSegment.Marshal(b, m, deterministic)
}
func (dst *LabelSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelSegment.Merge(dst, src)
}
func (m *LabelSegment) XXX_Size() int {
	return xxx_messageInfo_LabelSegment.Size(m)
}
func (m *LabelSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelSegment.DiscardUnknown(m)
}

var xxx_messageInfo_LabelSegment proto.InternalMessageInfo

func (m *LabelSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *LabelSegment) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Video frame level annotation results for label detection.
type LabelFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelFrame) Reset()         { *m = LabelFrame{} }
func (m *LabelFrame) String() string { return proto.CompactTextString(m) }
func (*LabelFrame) ProtoMessage()    {}
func (*LabelFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{8}
}
func (m *LabelFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelFrame.Unmarshal(m, b)
}
func (m *LabelFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelFrame.Marshal(b, m, deterministic)
}
func (dst *LabelFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelFrame.Merge(dst, src)
}
func (m *LabelFrame) XXX_Size() int {
	return xxx_messageInfo_LabelFrame.Size(m)
}
func (m *LabelFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelFrame.DiscardUnknown(m)
}

var xxx_messageInfo_LabelFrame proto.InternalMessageInfo

func (m *LabelFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *LabelFrame) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Detected entity from video analysis.
type Entity struct {
	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search
	// API](https://developers.google.com/knowledge-graph/).
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// Textual description, e.g. `Fixed-gear bicycle`.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Language code for `description` in BCP-47 format.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Entity) Reset()         { *m = Entity{} }
func (m *Entity) String() string { return proto.CompactTextString(m) }
func (*Entity) ProtoMessage()    {}
func (*Entity) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{9}
}
func (m *Entity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Entity.Unmarshal(m, b)
}
func (m *Entity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Entity.Marshal(b, m, deterministic)
}
func (dst *Entity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Entity.Merge(dst, src)
}
func (m *Entity) XXX_Size() int {
	return xxx_messageInfo_Entity.Size(m)
}
func (m *Entity) XXX_DiscardUnknown() {
	xxx_messageInfo_Entity.DiscardUnknown(m)
}

var xxx_messageInfo_Entity proto.InternalMessageInfo

func (m *Entity) GetEntityId() string {
	if m != nil {
		return m.EntityId
	}
	return ""
}

func (m *Entity) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Entity) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Label annotation.
type LabelAnnotation struct {
	// Detected entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Common categories for the detected entity.
	// E.g. when the label is `Terrier` the category is likely `dog`. And in some
	// cases there might be more than one categories e.g. `Terrier` could also be
	// a `pet`.
	CategoryEntities []*Entity `protobuf:"bytes,2,rep,name=category_entities,json=categoryEntities,proto3" json:"category_entities,omitempty"`
	// All video segments where a label was detected.
	Segments []*LabelSegment `protobuf:"bytes,3,rep,name=segments,proto3" json:"segments,omitempty"`
	// All video frames where a label was detected.
	Frames               []*LabelFrame `protobuf:"bytes,4,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *LabelAnnotation) Reset()         { *m = LabelAnnotation{} }
func (m *LabelAnnotation) String() string { return proto.CompactTextString(m) }
func (*LabelAnnotation) ProtoMessage()    {}
func (*LabelAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{10}
}
func (m *LabelAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelAnnotation.Unmarshal(m, b)
}
func (m *LabelAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelAnnotation.Marshal(b, m, deterministic)
}
func (dst *LabelAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelAnnotation.Merge(dst, src)
}
func (m *LabelAnnotation) XXX_Size() int {
	return xxx_messageInfo_LabelAnnotation.Size(m)
}
func (m *LabelAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_LabelAnnotation proto.InternalMessageInfo

func (m *LabelAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *LabelAnnotation) GetCategoryEntities() []*Entity {
	if m != nil {
		return m.CategoryEntities
	}
	return nil
}

func (m *LabelAnnotation) GetSegments() []*LabelSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *LabelAnnotation) GetFrames() []*LabelFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Video frame level annotation results for explicit content.
type ExplicitContentFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Likelihood of the pornography content..
	PornographyLikelihood Likelihood `protobuf:"varint,2,opt,name=pornography_likelihood,json=pornographyLikelihood,proto3,enum=google.cloud.videointelligence.v1p3beta1.Likelihood" json:"pornography_likelihood,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}   `json:"-"`
	XXX_unrecognized      []byte     `json:"-"`
	XXX_sizecache         int32      `json:"-"`
}

func (m *ExplicitContentFrame) Reset()         { *m = ExplicitContentFrame{} }
func (m *ExplicitContentFrame) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentFrame) ProtoMessage()    {}
func (*ExplicitContentFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{11}
}
func (m *ExplicitContentFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentFrame.Unmarshal(m, b)
}
func (m *ExplicitContentFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentFrame.Marshal(b, m, deterministic)
}
func (dst *ExplicitContentFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentFrame.Merge(dst, src)
}
func (m *ExplicitContentFrame) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentFrame.Size(m)
}
func (m *ExplicitContentFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentFrame proto.InternalMessageInfo

func (m *ExplicitContentFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *ExplicitContentFrame) GetPornographyLikelihood() Likelihood {
	if m != nil {
		return m.PornographyLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

// Explicit content annotation (based on per-frame visual signals only).
// If no explicit content has been detected in a frame, no annotations are
// present for that frame.
type ExplicitContentAnnotation struct {
	// All video frames where explicit content was detected.
	Frames               []*ExplicitContentFrame `protobuf:"bytes,1,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ExplicitContentAnnotation) Reset()         { *m = ExplicitContentAnnotation{} }
func (m *ExplicitContentAnnotation) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentAnnotation) ProtoMessage()    {}
func (*ExplicitContentAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{12}
}
func (m *ExplicitContentAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentAnnotation.Unmarshal(m, b)
}
func (m *ExplicitContentAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentAnnotation.Marshal(b, m, deterministic)
}
func (dst *ExplicitContentAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentAnnotation.Merge(dst, src)
}
func (m *ExplicitContentAnnotation) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentAnnotation.Size(m)
}
func (m *ExplicitContentAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentAnnotation proto.InternalMessageInfo

func (m *ExplicitContentAnnotation) GetFrames() []*ExplicitContentFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Normalized bounding box.
// The normalized vertex coordinates are relative to the original image.
// Range: [0, 1].
type NormalizedBoundingBox struct {
	// Left X coordinate.
	Left float32 `protobuf:"fixed32,1,opt,name=left,proto3" json:"left,omitempty"`
	// Top Y coordinate.
	Top float32 `protobuf:"fixed32,2,opt,name=top,proto3" json:"top,omitempty"`
	// Right X coordinate.
	Right float32 `protobuf:"fixed32,3,opt,name=right,proto3" json:"right,omitempty"`
	// Bottom Y coordinate.
	Bottom               float32  `protobuf:"fixed32,4,opt,name=bottom,proto3" json:"bottom,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NormalizedBoundingBox) Reset()         { *m = NormalizedBoundingBox{} }
func (m *NormalizedBoundingBox) String() string { return proto.CompactTextString(m) }
func (*NormalizedBoundingBox) ProtoMessage()    {}
func (*NormalizedBoundingBox) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{13}
}
func (m *NormalizedBoundingBox) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedBoundingBox.Unmarshal(m, b)
}
func (m *NormalizedBoundingBox) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedBoundingBox.Marshal(b, m, deterministic)
}
func (dst *NormalizedBoundingBox) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedBoundingBox.Merge(dst, src)
}
func (m *NormalizedBoundingBox) XXX_Size() int {
	return xxx_messageInfo_NormalizedBoundingBox.Size(m)
}
func (m *NormalizedBoundingBox) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedBoundingBox.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedBoundingBox proto.InternalMessageInfo

func (m *NormalizedBoundingBox) GetLeft() float32 {
	if m != nil {
		return m.Left
	}
	return 0
}

func (m *NormalizedBoundingBox) GetTop() float32 {
	if m != nil {
		return m.Top
	}
	return 0
}

func (m *NormalizedBoundingBox) GetRight() float32 {
	if m != nil {
		return m.Right
	}
	return 0
}

func (m *NormalizedBoundingBox) GetBottom() float32 {
	if m != nil {
		return m.Bottom
	}
	return 0
}

// Annotation results for a single video.
type VideoAnnotationResults struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Label annotations on video level or user specified segment level.
	// There is exactly one element for each unique label.
	SegmentLabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=segment_label_annotations,json=segmentLabelAnnotations,proto3" json:"segment_label_annotations,omitempty"`
	// Label annotations on shot level.
	// There is exactly one element for each unique label.
	ShotLabelAnnotations []*LabelAnnotation `protobuf:"bytes,3,rep,name=shot_label_annotations,json=shotLabelAnnotations,proto3" json:"shot_label_annotations,omitempty"`
	// Label annotations on frame level.
	// There is exactly one element for each unique label.
	FrameLabelAnnotations []*LabelAnnotation `protobuf:"bytes,4,rep,name=frame_label_annotations,json=frameLabelAnnotations,proto3" json:"frame_label_annotations,omitempty"`
	// Shot annotations. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,6,rep,name=shot_annotations,json=shotAnnotations,proto3" json:"shot_annotations,omitempty"`
	// Explicit content annotation.
	ExplicitAnnotation *ExplicitContentAnnotation `protobuf:"bytes,7,opt,name=explicit_annotation,json=explicitAnnotation,proto3" json:"explicit_annotation,omitempty"`
	// OCR text detection and tracking.
	// Annotations for list of detected text snippets. Each will have list of
	// frame information associated with it.
	TextAnnotations []*TextAnnotation `protobuf:"bytes,12,rep,name=text_annotations,json=textAnnotations,proto3" json:"text_annotations,omitempty"`
	// Annotations for list of objects detected and tracked in video.
	ObjectAnnotations []*ObjectTrackingAnnotation `protobuf:"bytes,14,rep,name=object_annotations,json=objectAnnotations,proto3" json:"object_annotations,omitempty"`
	// If set, indicates an error. Note that for a single `AnnotateVideoRequest`
	// some videos may succeed and some may fail.
	Error                *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *VideoAnnotationResults) Reset()         { *m = VideoAnnotationResults{} }
func (m *VideoAnnotationResults) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationResults) ProtoMessage()    {}
func (*VideoAnnotationResults) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{14}
}
func (m *VideoAnnotationResults) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationResults.Unmarshal(m, b)
}
func (m *VideoAnnotationResults) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationResults.Marshal(b, m, deterministic)
}
func (dst *VideoAnnotationResults) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationResults.Merge(dst, src)
}
func (m *VideoAnnotationResults) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationResults.Size(m)
}
func (m *VideoAnnotationResults) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationResults.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationResults proto.InternalMessageInfo

func (m *VideoAnnotationResults) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationResults) GetSegmentLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.SegmentLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.ShotLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFrameLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.FrameLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if m != nil {
		return m.ShotAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetExplicitAnnotation() *ExplicitContentAnnotation {
	if m != nil {
		return m.ExplicitAnnotation
	}
	return nil
}

func (m *VideoAnnotationResults) GetTextAnnotations() []*TextAnnotation {
	if m != nil {
		return m.TextAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetObjectAnnotations() []*ObjectTrackingAnnotation {
	if m != nil {
		return m.ObjectAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// Video annotation response. Included in the `response`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoResponse struct {
	// Annotation results for all videos specified in `AnnotateVideoRequest`.
	AnnotationResults    []*VideoAnnotationResults `protobuf:"bytes,1,rep,name=annotation_results,json=annotationResults,proto3" json:"annotation_results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *AnnotateVideoResponse) Reset()         { *m = AnnotateVideoResponse{} }
func (m *AnnotateVideoResponse) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoResponse) ProtoMessage()    {}
func (*AnnotateVideoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{15}
}
func (m *AnnotateVideoResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoResponse.Unmarshal(m, b)
}
func (m *AnnotateVideoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoResponse.Marshal(b, m, deterministic)
}
func (dst *AnnotateVideoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoResponse.Merge(dst, src)
}
func (m *AnnotateVideoResponse) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoResponse.Size(m)
}
func (m *AnnotateVideoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoResponse proto.InternalMessageInfo

func (m *AnnotateVideoResponse) GetAnnotationResults() []*VideoAnnotationResults {
	if m != nil {
		return m.AnnotationResults
	}
	return nil
}

// Annotation progress for a single video.
type VideoAnnotationProgress struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Approximate percentage processed thus far. Guaranteed to be
	// 100 when fully processed.
	ProgressPercent int32 `protobuf:"varint,2,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Time when the request was received.
	StartTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time of the most recent update.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *VideoAnnotationProgress) Reset()         { *m = VideoAnnotationProgress{} }
func (m *VideoAnnotationProgress) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationProgress) ProtoMessage()    {}
func (*VideoAnnotationProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{16}
}
func (m *VideoAnnotationProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationProgress.Unmarshal(m, b)
}
func (m *VideoAnnotationProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationProgress.Marshal(b, m, deterministic)
}
func (dst *VideoAnnotationProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationProgress.Merge(dst, src)
}
func (m *VideoAnnotationProgress) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationProgress.Size(m)
}
func (m *VideoAnnotationProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationProgress.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationProgress proto.InternalMessageInfo

func (m *VideoAnnotationProgress) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationProgress) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *VideoAnnotationProgress) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *VideoAnnotationProgress) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// Video annotation progress. Included in the `metadata`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoProgress struct {
	// Progress metadata for all videos specified in `AnnotateVideoRequest`.
	AnnotationProgress   []*VideoAnnotationProgress `protobuf:"bytes,1,rep,name=annotation_progress,json=annotationProgress,proto3" json:"annotation_progress,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *AnnotateVideoProgress) Reset()         { *m = AnnotateVideoProgress{} }
func (m *AnnotateVideoProgress) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoProgress) ProtoMessage()    {}
func (*AnnotateVideoProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{17}
}
func (m *AnnotateVideoProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoProgress.Unmarshal(m, b)
}
func (m *AnnotateVideoProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoProgress.Marshal(b, m, deterministic)
}
func (dst *AnnotateVideoProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoProgress.Merge(dst, src)
}
func (m *AnnotateVideoProgress) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoProgress.Size(m)
}
func (m *AnnotateVideoProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoProgress.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoProgress proto.InternalMessageInfo

func (m *AnnotateVideoProgress) GetAnnotationProgress() []*VideoAnnotationProgress {
	if m != nil {
		return m.AnnotationProgress
	}
	return nil
}

// A vertex represents a 2D point in the image.
// NOTE: the normalized vertex coordinates are relative to the original image
// and range from 0 to 1.
type NormalizedVertex struct {
	// X coordinate.
	X float32 `protobuf:"fixed32,1,opt,name=x,proto3" json:"x,omitempty"`
	// Y coordinate.
	Y                    float32  `protobuf:"fixed32,2,opt,name=y,proto3" json:"y,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NormalizedVertex) Reset()         { *m = NormalizedVertex{} }
func (m *NormalizedVertex) String() string { return proto.CompactTextString(m) }
func (*NormalizedVertex) ProtoMessage()    {}
func (*NormalizedVertex) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{18}
}
func (m *NormalizedVertex) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedVertex.Unmarshal(m, b)
}
func (m *NormalizedVertex) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedVertex.Marshal(b, m, deterministic)
}
func (dst *NormalizedVertex) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedVertex.Merge(dst, src)
}
func (m *NormalizedVertex) XXX_Size() int {
	return xxx_messageInfo_NormalizedVertex.Size(m)
}
func (m *NormalizedVertex) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedVertex.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedVertex proto.InternalMessageInfo

func (m *NormalizedVertex) GetX() float32 {
	if m != nil {
		return m.X
	}
	return 0
}

func (m *NormalizedVertex) GetY() float32 {
	if m != nil {
		return m.Y
	}
	return 0
}

// Normalized bounding polygon for text (that might not be aligned with axis).
// Contains list of the corner points in clockwise order starting from
// top-left corner. For example, for a rectangular bounding box:
// When the text is horizontal it might look like:
//         0----1
//         |    |
//         3----2
//
// When it's clockwise rotated 180 degrees around the top-left corner it
// becomes:
//         2----3
//         |    |
//         1----0
//
// and the vertex order will still be (0, 1, 2, 3). Note that values can be less
// than 0, or greater than 1 due to trignometric calculations for location of
// the box.
type NormalizedBoundingPoly struct {
	// Normalized vertices of the bounding polygon.
	Vertices             []*NormalizedVertex `protobuf:"bytes,1,rep,name=vertices,proto3" json:"vertices,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *NormalizedBoundingPoly) Reset()         { *m = NormalizedBoundingPoly{} }
func (m *NormalizedBoundingPoly) String() string { return proto.CompactTextString(m) }
func (*NormalizedBoundingPoly) ProtoMessage()    {}
func (*NormalizedBoundingPoly) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{19}
}
func (m *NormalizedBoundingPoly) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedBoundingPoly.Unmarshal(m, b)
}
func (m *NormalizedBoundingPoly) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedBoundingPoly.Marshal(b, m, deterministic)
}
func (dst *NormalizedBoundingPoly) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedBoundingPoly.Merge(dst, src)
}
func (m *NormalizedBoundingPoly) XXX_Size() int {
	return xxx_messageInfo_NormalizedBoundingPoly.Size(m)
}
func (m *NormalizedBoundingPoly) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedBoundingPoly.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedBoundingPoly proto.InternalMessageInfo

func (m *NormalizedBoundingPoly) GetVertices() []*NormalizedVertex {
	if m != nil {
		return m.Vertices
	}
	return nil
}

// Video segment level annotation results for text detection.
type TextSegment struct {
	// Video segment where a text snippet was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// Confidence for the track of detected text. It is calculated as the highest
	// over all frames where OCR detected text appears.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Information related to the frames where OCR detected text appears.
	Frames               []*TextFrame `protobuf:"bytes,3,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *TextSegment) Reset()         { *m = TextSegment{} }
func (m *TextSegment) String() string { return proto.CompactTextString(m) }
func (*TextSegment) ProtoMessage()    {}
func (*TextSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{20}
}
func (m *TextSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextSegment.Unmarshal(m, b)
}
func (m *TextSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextSegment.Marshal(b, m, deterministic)
}
func (dst *TextSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextSegment.Merge(dst, src)
}
func (m *TextSegment) XXX_Size() int {
	return xxx_messageInfo_TextSegment.Size(m)
}
func (m *TextSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_TextSegment.DiscardUnknown(m)
}

var xxx_messageInfo_TextSegment proto.InternalMessageInfo

func (m *TextSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *TextSegment) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *TextSegment) GetFrames() []*TextFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Video frame level annotation results for text annotation (OCR).
// Contains information regarding timestamp and bounding box locations for the
// frames containing detected OCR text snippets.
type TextFrame struct {
	// Bounding polygon of the detected text for this frame.
	RotatedBoundingBox *NormalizedBoundingPoly `protobuf:"bytes,1,opt,name=rotated_bounding_box,json=rotatedBoundingBox,proto3" json:"rotated_bounding_box,omitempty"`
	// Timestamp of this frame.
	TimeOffset           *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *TextFrame) Reset()         { *m = TextFrame{} }
func (m *TextFrame) String() string { return proto.CompactTextString(m) }
func (*TextFrame) ProtoMessage()    {}
func (*TextFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{21}
}
func (m *TextFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextFrame.Unmarshal(m, b)
}
func (m *TextFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextFrame.Marshal(b, m, deterministic)
}
func (dst *TextFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextFrame.Merge(dst, src)
}
func (m *TextFrame) XXX_Size() int {
	return xxx_messageInfo_TextFrame.Size(m)
}
func (m *TextFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_TextFrame.DiscardUnknown(m)
}

var xxx_messageInfo_TextFrame proto.InternalMessageInfo

func (m *TextFrame) GetRotatedBoundingBox() *NormalizedBoundingPoly {
	if m != nil {
		return m.RotatedBoundingBox
	}
	return nil
}

func (m *TextFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

// Annotations related to one detected OCR text snippet. This will contain the
// corresponding text, confidence value, and frame level information for each
// detection.
type TextAnnotation struct {
	// The detected text.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// All video segments where OCR detected text appears.
	Segments             []*TextSegment `protobuf:"bytes,2,rep,name=segments,proto3" json:"segments,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *TextAnnotation) Reset()         { *m = TextAnnotation{} }
func (m *TextAnnotation) String() string { return proto.CompactTextString(m) }
func (*TextAnnotation) ProtoMessage()    {}
func (*TextAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{22}
}
func (m *TextAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextAnnotation.Unmarshal(m, b)
}
func (m *TextAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextAnnotation.Marshal(b, m, deterministic)
}
func (dst *TextAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextAnnotation.Merge(dst, src)
}
func (m *TextAnnotation) XXX_Size() int {
	return xxx_messageInfo_TextAnnotation.Size(m)
}
func (m *TextAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_TextAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_TextAnnotation proto.InternalMessageInfo

func (m *TextAnnotation) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *TextAnnotation) GetSegments() []*TextSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

// Video frame level annotations for object detection and tracking. This field
// stores per frame location, time offset, and confidence.
type ObjectTrackingFrame struct {
	// The normalized bounding box location of this object track for the frame.
	NormalizedBoundingBox *NormalizedBoundingBox `protobuf:"bytes,1,opt,name=normalized_bounding_box,json=normalizedBoundingBox,proto3" json:"normalized_bounding_box,omitempty"`
	// The timestamp of the frame in microseconds.
	TimeOffset           *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ObjectTrackingFrame) Reset()         { *m = ObjectTrackingFrame{} }
func (m *ObjectTrackingFrame) String() string { return proto.CompactTextString(m) }
func (*ObjectTrackingFrame) ProtoMessage()    {}
func (*ObjectTrackingFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{23}
}
func (m *ObjectTrackingFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectTrackingFrame.Unmarshal(m, b)
}
func (m *ObjectTrackingFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectTrackingFrame.Marshal(b, m, deterministic)
}
func (dst *ObjectTrackingFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectTrackingFrame.Merge(dst, src)
}
func (m *ObjectTrackingFrame) XXX_Size() int {
	return xxx_messageInfo_ObjectTrackingFrame.Size(m)
}
func (m *ObjectTrackingFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectTrackingFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectTrackingFrame proto.InternalMessageInfo

func (m *ObjectTrackingFrame) GetNormalizedBoundingBox() *NormalizedBoundingBox {
	if m != nil {
		return m.NormalizedBoundingBox
	}
	return nil
}

func (m *ObjectTrackingFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

// Annotations corresponding to one tracked object.
type ObjectTrackingAnnotation struct {
	// Entity to specify the object category that this track is labeled as.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Object category's labeling confidence of this track.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Information corresponding to all frames where this object track appears.
	// Non-streaming batch mode: it may be one or multiple ObjectTrackingFrame
	// messages in frames.
	// Streaming mode: it can only be one ObjectTrackingFrame message in frames.
	Frames []*ObjectTrackingFrame `protobuf:"bytes,2,rep,name=frames,proto3" json:"frames,omitempty"`
	// Different representation of tracking info in non-streaming batch
	// and streaming modes.
	//
	// Types that are valid to be assigned to TrackInfo:
	//	*ObjectTrackingAnnotation_Segment
	//	*ObjectTrackingAnnotation_TrackId
	TrackInfo            isObjectTrackingAnnotation_TrackInfo `protobuf_oneof:"track_info"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *ObjectTrackingAnnotation) Reset()         { *m = ObjectTrackingAnnotation{} }
func (m *ObjectTrackingAnnotation) String() string { return proto.CompactTextString(m) }
func (*ObjectTrackingAnnotation) ProtoMessage()    {}
func (*ObjectTrackingAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{24}
}
func (m *ObjectTrackingAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectTrackingAnnotation.Unmarshal(m, b)
}
func (m *ObjectTrackingAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectTrackingAnnotation.Marshal(b, m, deterministic)
}
func (dst *ObjectTrackingAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectTrackingAnnotation.Merge(dst, src)
}
func (m *ObjectTrackingAnnotation) XXX_Size() int {
	return xxx_messageInfo_ObjectTrackingAnnotation.Size(m)
}
func (m *ObjectTrackingAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectTrackingAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectTrackingAnnotation proto.InternalMessageInfo

func (m *ObjectTrackingAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *ObjectTrackingAnnotation) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *ObjectTrackingAnnotation) GetFrames() []*ObjectTrackingFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

type isObjectTrackingAnnotation_TrackInfo interface {
	isObjectTrackingAnnotation_TrackInfo()
}

type ObjectTrackingAnnotation_Segment struct {
	Segment *VideoSegment `protobuf:"bytes,3,opt,name=segment,proto3,oneof"`
}

type ObjectTrackingAnnotation_TrackId struct {
	TrackId int64 `protobuf:"varint,5,opt,name=track_id,json=trackId,proto3,oneof"`
}

func (*ObjectTrackingAnnotation_Segment) isObjectTrackingAnnotation_TrackInfo() {}

func (*ObjectTrackingAnnotation_TrackId) isObjectTrackingAnnotation_TrackInfo() {}

func (m *ObjectTrackingAnnotation) GetTrackInfo() isObjectTrackingAnnotation_TrackInfo {
	if m != nil {
		return m.TrackInfo
	}
	return nil
}

func (m *ObjectTrackingAnnotation) GetSegment() *VideoSegment {
	if x, ok := m.GetTrackInfo().(*ObjectTrackingAnnotation_Segment); ok {
		return x.Segment
	}
	return nil
}

func (m *ObjectTrackingAnnotation) GetTrackId() int64 {
	if x, ok := m.GetTrackInfo().(*ObjectTrackingAnnotation_TrackId); ok {
		return x.TrackId
	}
	return 0
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ObjectTrackingAnnotation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ObjectTrackingAnnotation_OneofMarshaler, _ObjectTrackingAnnotation_OneofUnmarshaler, _ObjectTrackingAnnotation_OneofSizer, []interface{}{
		(*ObjectTrackingAnnotation_Segment)(nil),
		(*ObjectTrackingAnnotation_TrackId)(nil),
	}
}

func _ObjectTrackingAnnotation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ObjectTrackingAnnotation)
	// track_info
	switch x := m.TrackInfo.(type) {
	case *ObjectTrackingAnnotation_Segment:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Segment); err != nil {
			return err
		}
	case *ObjectTrackingAnnotation_TrackId:
		b.EncodeVarint(5<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.TrackId))
	case nil:
	default:
		return fmt.Errorf("ObjectTrackingAnnotation.TrackInfo has unexpected type %T", x)
	}
	return nil
}

func _ObjectTrackingAnnotation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ObjectTrackingAnnotation)
	switch tag {
	case 3: // track_info.segment
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(VideoSegment)
		err := b.DecodeMessage(msg)
		m.TrackInfo = &ObjectTrackingAnnotation_Segment{msg}
		return true, err
	case 5: // track_info.track_id
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.TrackInfo = &ObjectTrackingAnnotation_TrackId{int64(x)}
		return true, err
	default:
		return false, nil
	}
}

func _ObjectTrackingAnnotation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ObjectTrackingAnnotation)
	// track_info
	switch x := m.TrackInfo.(type) {
	case *ObjectTrackingAnnotation_Segment:
		s := proto.Size(x.Segment)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ObjectTrackingAnnotation_TrackId:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.TrackId))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The top-level message sent by the client for the `StreamingAnnotateVideo`
// method. Multiple `StreamingAnnotateVideoRequest` messages are sent.
// The first message must only contain a `StreamingVideoConfig` message.
// All subsequent messages must only contain `input_content` data.
type StreamingAnnotateVideoRequest struct {
	// *Required* The streaming request, which is either a streaming config or
	// video content.
	//
	// Types that are valid to be assigned to StreamingRequest:
	//	*StreamingAnnotateVideoRequest_VideoConfig
	//	*StreamingAnnotateVideoRequest_InputContent
	StreamingRequest     isStreamingAnnotateVideoRequest_StreamingRequest `protobuf_oneof:"streaming_request"`
	XXX_NoUnkeyedLiteral struct{}                                         `json:"-"`
	XXX_unrecognized     []byte                                           `json:"-"`
	XXX_sizecache        int32                                            `json:"-"`
}

func (m *StreamingAnnotateVideoRequest) Reset()         { *m = StreamingAnnotateVideoRequest{} }
func (m *StreamingAnnotateVideoRequest) String() string { return proto.CompactTextString(m) }
func (*StreamingAnnotateVideoRequest) ProtoMessage()    {}
func (*StreamingAnnotateVideoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{25}
}
func (m *StreamingAnnotateVideoRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingAnnotateVideoRequest.Unmarshal(m, b)
}
func (m *StreamingAnnotateVideoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingAnnotateVideoRequest.Marshal(b, m, deterministic)
}
func (dst *StreamingAnnotateVideoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingAnnotateVideoRequest.Merge(dst, src)
}
func (m *StreamingAnnotateVideoRequest) XXX_Size() int {
	return xxx_messageInfo_StreamingAnnotateVideoRequest.Size(m)
}
func (m *StreamingAnnotateVideoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingAnnotateVideoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingAnnotateVideoRequest proto.InternalMessageInfo

type isStreamingAnnotateVideoRequest_StreamingRequest interface {
	isStreamingAnnotateVideoRequest_StreamingRequest()
}

type StreamingAnnotateVideoRequest_VideoConfig struct {
	VideoConfig *StreamingVideoConfig `protobuf:"bytes,1,opt,name=video_config,json=videoConfig,proto3,oneof"`
}

type StreamingAnnotateVideoRequest_InputContent struct {
	InputContent []byte `protobuf:"bytes,2,opt,name=input_content,json=inputContent,proto3,oneof"`
}

func (*StreamingAnnotateVideoRequest_VideoConfig) isStreamingAnnotateVideoRequest_StreamingRequest() {}

func (*StreamingAnnotateVideoRequest_InputContent) isStreamingAnnotateVideoRequest_StreamingRequest() {
}

func (m *StreamingAnnotateVideoRequest) GetStreamingRequest() isStreamingAnnotateVideoRequest_StreamingRequest {
	if m != nil {
		return m.StreamingRequest
	}
	return nil
}

func (m *StreamingAnnotateVideoRequest) GetVideoConfig() *StreamingVideoConfig {
	if x, ok := m.GetStreamingRequest().(*StreamingAnnotateVideoRequest_VideoConfig); ok {
		return x.VideoConfig
	}
	return nil
}

func (m *StreamingAnnotateVideoRequest) GetInputContent() []byte {
	if x, ok := m.GetStreamingRequest().(*StreamingAnnotateVideoRequest_InputContent); ok {
		return x.InputContent
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StreamingAnnotateVideoRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StreamingAnnotateVideoRequest_OneofMarshaler, _StreamingAnnotateVideoRequest_OneofUnmarshaler, _StreamingAnnotateVideoRequest_OneofSizer, []interface{}{
		(*StreamingAnnotateVideoRequest_VideoConfig)(nil),
		(*StreamingAnnotateVideoRequest_InputContent)(nil),
	}
}

func _StreamingAnnotateVideoRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StreamingAnnotateVideoRequest)
	// streaming_request
	switch x := m.StreamingRequest.(type) {
	case *StreamingAnnotateVideoRequest_VideoConfig:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.VideoConfig); err != nil {
			return err
		}
	case *StreamingAnnotateVideoRequest_InputContent:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.InputContent)
	case nil:
	default:
		return fmt.Errorf("StreamingAnnotateVideoRequest.StreamingRequest has unexpected type %T", x)
	}
	return nil
}

func _StreamingAnnotateVideoRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StreamingAnnotateVideoRequest)
	switch tag {
	case 1: // streaming_request.video_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StreamingVideoConfig)
		err := b.DecodeMessage(msg)
		m.StreamingRequest = &StreamingAnnotateVideoRequest_VideoConfig{msg}
		return true, err
	case 2: // streaming_request.input_content
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StreamingRequest = &StreamingAnnotateVideoRequest_InputContent{x}
		return true, err
	default:
		return false, nil
	}
}

func _StreamingAnnotateVideoRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StreamingAnnotateVideoRequest)
	// streaming_request
	switch x := m.StreamingRequest.(type) {
	case *StreamingAnnotateVideoRequest_VideoConfig:
		s := proto.Size(x.VideoConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StreamingAnnotateVideoRequest_InputContent:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.InputContent)))
		n += len(x.InputContent)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// `StreamingAnnotateVideoResponse` is the only message returned to the client
// by `StreamingAnnotateVideo`. A series of zero or more
// `StreamingAnnotateVideoResponse` messages are streamed back to the client.
type StreamingAnnotateVideoResponse struct {
	// If set, returns a [google.rpc.Status][] message that
	// specifies the error for the operation.
	Error *status.Status `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// Streaming annotation results.
	AnnotationResults *StreamingVideoAnnotationResults `protobuf:"bytes,2,opt,name=annotation_results,json=annotationResults,proto3" json:"annotation_results,omitempty"`
	// GCS URI that stores annotation results of one streaming session.
	// It is a directory that can hold multiple files in JSON format.
	// Example uri format:
	// gs://bucket_id/object_id/cloud_project_name-session_id
	AnnotationResultsUri string   `protobuf:"bytes,3,opt,name=annotation_results_uri,json=annotationResultsUri,proto3" json:"annotation_results_uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingAnnotateVideoResponse) Reset()         { *m = StreamingAnnotateVideoResponse{} }
func (m *StreamingAnnotateVideoResponse) String() string { return proto.CompactTextString(m) }
func (*StreamingAnnotateVideoResponse) ProtoMessage()    {}
func (*StreamingAnnotateVideoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{26}
}
func (m *StreamingAnnotateVideoResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingAnnotateVideoResponse.Unmarshal(m, b)
}
func (m *StreamingAnnotateVideoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingAnnotateVideoResponse.Marshal(b, m, deterministic)
}
func (dst *StreamingAnnotateVideoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingAnnotateVideoResponse.Merge(dst, src)
}
func (m *StreamingAnnotateVideoResponse) XXX_Size() int {
	return xxx_messageInfo_StreamingAnnotateVideoResponse.Size(m)
}
func (m *StreamingAnnotateVideoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingAnnotateVideoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingAnnotateVideoResponse proto.InternalMessageInfo

func (m *StreamingAnnotateVideoResponse) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *StreamingAnnotateVideoResponse) GetAnnotationResults() *StreamingVideoAnnotationResults {
	if m != nil {
		return m.AnnotationResults
	}
	return nil
}

func (m *StreamingAnnotateVideoResponse) GetAnnotationResultsUri() string {
	if m != nil {
		return m.AnnotationResultsUri
	}
	return ""
}

// Config for EXPLICIT_CONTENT_DETECTION in streaming mode.
type StreamingExplicitContentDetectionConfig struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingExplicitContentDetectionConfig) Reset() {
	*m = StreamingExplicitContentDetectionConfig{}
}
func (m *StreamingExplicitContentDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingExplicitContentDetectionConfig) ProtoMessage()    {}
func (*StreamingExplicitContentDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{27}
}
func (m *StreamingExplicitContentDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingExplicitContentDetectionConfig.Unmarshal(m, b)
}
func (m *StreamingExplicitContentDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingExplicitContentDetectionConfig.Marshal(b, m, deterministic)
}
func (dst *StreamingExplicitContentDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingExplicitContentDetectionConfig.Merge(dst, src)
}
func (m *StreamingExplicitContentDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingExplicitContentDetectionConfig.Size(m)
}
func (m *StreamingExplicitContentDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingExplicitContentDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingExplicitContentDetectionConfig proto.InternalMessageInfo

// Config for LABEL_DETECTION in streaming mode.
type StreamingLabelDetectionConfig struct {
	// Whether the video has been captured from a stationary (i.e. non-moving)
	// camera. When set to true, might improve detection accuracy for moving
	// objects. Default: false.
	StationaryCamera     bool     `protobuf:"varint,1,opt,name=stationary_camera,json=stationaryCamera,proto3" json:"stationary_camera,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingLabelDetectionConfig) Reset()         { *m = StreamingLabelDetectionConfig{} }
func (m *StreamingLabelDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingLabelDetectionConfig) ProtoMessage()    {}
func (*StreamingLabelDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{28}
}
func (m *StreamingLabelDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingLabelDetectionConfig.Unmarshal(m, b)
}
func (m *StreamingLabelDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingLabelDetectionConfig.Marshal(b, m, deterministic)
}
func (dst *StreamingLabelDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingLabelDetectionConfig.Merge(dst, src)
}
func (m *StreamingLabelDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingLabelDetectionConfig.Size(m)
}
func (m *StreamingLabelDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingLabelDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingLabelDetectionConfig proto.InternalMessageInfo

func (m *StreamingLabelDetectionConfig) GetStationaryCamera() bool {
	if m != nil {
		return m.StationaryCamera
	}
	return false
}

// Config for STREAMING_OBJECT_TRACKING.
type StreamingObjectTrackingConfig struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingObjectTrackingConfig) Reset()         { *m = StreamingObjectTrackingConfig{} }
func (m *StreamingObjectTrackingConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingObjectTrackingConfig) ProtoMessage()    {}
func (*StreamingObjectTrackingConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{29}
}
func (m *StreamingObjectTrackingConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingObjectTrackingConfig.Unmarshal(m, b)
}
func (m *StreamingObjectTrackingConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingObjectTrackingConfig.Marshal(b, m, deterministic)
}
func (dst *StreamingObjectTrackingConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingObjectTrackingConfig.Merge(dst, src)
}
func (m *StreamingObjectTrackingConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingObjectTrackingConfig.Size(m)
}
func (m *StreamingObjectTrackingConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingObjectTrackingConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingObjectTrackingConfig proto.InternalMessageInfo

// Config for SHOT_CHANGE_DETECTION in streaming mode.
type StreamingShotChangeDetectionConfig struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingShotChangeDetectionConfig) Reset()         { *m = StreamingShotChangeDetectionConfig{} }
func (m *StreamingShotChangeDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingShotChangeDetectionConfig) ProtoMessage()    {}
func (*StreamingShotChangeDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{30}
}
func (m *StreamingShotChangeDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingShotChangeDetectionConfig.Unmarshal(m, b)
}
func (m *StreamingShotChangeDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingShotChangeDetectionConfig.Marshal(b, m, deterministic)
}
func (dst *StreamingShotChangeDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingShotChangeDetectionConfig.Merge(dst, src)
}
func (m *StreamingShotChangeDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingShotChangeDetectionConfig.Size(m)
}
func (m *StreamingShotChangeDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingShotChangeDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingShotChangeDetectionConfig proto.InternalMessageInfo

// Config for streaming storage option.
type StreamingStorageConfig struct {
	// Enable streaming storage. Default: false.
	EnableStorageAnnotationResult bool `protobuf:"varint,1,opt,name=enable_storage_annotation_result,json=enableStorageAnnotationResult,proto3" json:"enable_storage_annotation_result,omitempty"`
	// GCS URI to store all annotation results for one client. Client should
	// specify this field as the top-level storage directory. Annotation results
	// of different sessions will be put into different sub-directories denoted
	// by project_name and session_id. All sub-directories will be auto generated
	// by program and will be made accessible to client in response proto.
	// URIs must be specified in the following format: `gs://bucket-id/object-id`
	// `bucket-id` should be a valid GCS bucket created by client and bucket
	// permission shall also be configured properly. `object-id` can be arbitrary
	// string that make sense to client. Other URI formats will return error and
	// cause GCS write failure.
	AnnotationResultStorageDirectory string   `protobuf:"bytes,3,opt,name=annotation_result_storage_directory,json=annotationResultStorageDirectory,proto3" json:"annotation_result_storage_directory,omitempty"`
	XXX_NoUnkeyedLiteral             struct{} `json:"-"`
	XXX_unrecognized                 []byte   `json:"-"`
	XXX_sizecache                    int32    `json:"-"`
}

func (m *StreamingStorageConfig) Reset()         { *m = StreamingStorageConfig{} }
func (m *StreamingStorageConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingStorageConfig) ProtoMessage()    {}
func (*StreamingStorageConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{31}
}
func (m *StreamingStorageConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingStorageConfig.Unmarshal(m, b)
}
func (m *StreamingStorageConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingStorageConfig.Marshal(b, m, deterministic)
}
func (dst *StreamingStorageConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingStorageConfig.Merge(dst, src)
}
func (m *StreamingStorageConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingStorageConfig.Size(m)
}
func (m *StreamingStorageConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingStorageConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingStorageConfig proto.InternalMessageInfo

func (m *StreamingStorageConfig) GetEnableStorageAnnotationResult() bool {
	if m != nil {
		return m.EnableStorageAnnotationResult
	}
	return false
}

func (m *StreamingStorageConfig) GetAnnotationResultStorageDirectory() string {
	if m != nil {
		return m.AnnotationResultStorageDirectory
	}
	return ""
}

// Streaming annotation results corresponding to a portion of the video
// that is currently being processed.
type StreamingVideoAnnotationResults struct {
	// Shot annotation results. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,1,rep,name=shot_annotations,json=shotAnnotations,proto3" json:"shot_annotations,omitempty"`
	// Label annotation results.
	LabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=label_annotations,json=labelAnnotations,proto3" json:"label_annotations,omitempty"`
	// Explicit content detection results.
	ExplicitAnnotation *ExplicitContentAnnotation `protobuf:"bytes,3,opt,name=explicit_annotation,json=explicitAnnotation,proto3" json:"explicit_annotation,omitempty"`
	// Object tracking results.
	ObjectAnnotations    []*ObjectTrackingAnnotation `protobuf:"bytes,4,rep,name=object_annotations,json=objectAnnotations,proto3" json:"object_annotations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *StreamingVideoAnnotationResults) Reset()         { *m = StreamingVideoAnnotationResults{} }
func (m *StreamingVideoAnnotationResults) String() string { return proto.CompactTextString(m) }
func (*StreamingVideoAnnotationResults) ProtoMessage()    {}
func (*StreamingVideoAnnotationResults) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{32}
}
func (m *StreamingVideoAnnotationResults) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingVideoAnnotationResults.Unmarshal(m, b)
}
func (m *StreamingVideoAnnotationResults) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingVideoAnnotationResults.Marshal(b, m, deterministic)
}
func (dst *StreamingVideoAnnotationResults) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingVideoAnnotationResults.Merge(dst, src)
}
func (m *StreamingVideoAnnotationResults) XXX_Size() int {
	return xxx_messageInfo_StreamingVideoAnnotationResults.Size(m)
}
func (m *StreamingVideoAnnotationResults) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingVideoAnnotationResults.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingVideoAnnotationResults proto.InternalMessageInfo

func (m *StreamingVideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if m != nil {
		return m.ShotAnnotations
	}
	return nil
}

func (m *StreamingVideoAnnotationResults) GetLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.LabelAnnotations
	}
	return nil
}

func (m *StreamingVideoAnnotationResults) GetExplicitAnnotation() *ExplicitContentAnnotation {
	if m != nil {
		return m.ExplicitAnnotation
	}
	return nil
}

func (m *StreamingVideoAnnotationResults) GetObjectAnnotations() []*ObjectTrackingAnnotation {
	if m != nil {
		return m.ObjectAnnotations
	}
	return nil
}

// Provides information to the annotator that specifies how to process the
// request.
type StreamingVideoConfig struct {
	// Requested annotation feature.
	Feature StreamingFeature `protobuf:"varint,1,opt,name=feature,proto3,enum=google.cloud.videointelligence.v1p3beta1.StreamingFeature" json:"feature,omitempty"`
	// Config for requested annotation feature.
	//
	// Types that are valid to be assigned to StreamingConfig:
	//	*StreamingVideoConfig_ShotChangeDetectionConfig
	//	*StreamingVideoConfig_LabelDetectionConfig
	//	*StreamingVideoConfig_ExplicitContentDetectionConfig
	//	*StreamingVideoConfig_ObjectTrackingConfig
	StreamingConfig isStreamingVideoConfig_StreamingConfig `protobuf_oneof:"streaming_config"`
	// Streaming storage option. By default: storage is disabled.
	StorageConfig        *StreamingStorageConfig `protobuf:"bytes,30,opt,name=storage_config,json=storageConfig,proto3" json:"storage_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *StreamingVideoConfig) Reset()         { *m = StreamingVideoConfig{} }
func (m *StreamingVideoConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingVideoConfig) ProtoMessage()    {}
func (*StreamingVideoConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_8d71f55b0eb40d35, []int{33}
}
func (m *StreamingVideoConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingVideoConfig.Unmarshal(m, b)
}
func (m *StreamingVideoConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingVideoConfig.Marshal(b, m, deterministic)
}
func (dst *StreamingVideoConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingVideoConfig.Merge(dst, src)
}
func (m *StreamingVideoConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingVideoConfig.Size(m)
}
func (m *StreamingVideoConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingVideoConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingVideoConfig proto.InternalMessageInfo

func (m *StreamingVideoConfig) GetFeature() StreamingFeature {
	if m != nil {
		return m.Feature
	}
	return StreamingFeature_STREAMING_FEATURE_UNSPECIFIED
}

type isStreamingVideoConfig_StreamingConfig interface {
	isStreamingVideoConfig_StreamingConfig()
}

type StreamingVideoConfig_ShotChangeDetectionConfig struct {
	ShotChangeDetectionConfig *StreamingShotChangeDetectionConfig `protobuf:"bytes,2,opt,name=shot_change_detection_config,json=shotChangeDetectionConfig,proto3,oneof"`
}

type StreamingVideoConfig_LabelDetectionConfig struct {
	LabelDetectionConfig *StreamingLabelDetectionConfig `protobuf:"bytes,3,opt,name=label_detection_config,json=labelDetectionConfig,proto3,oneof"`
}

type StreamingVideoConfig_ExplicitContentDetectionConfig struct {
	ExplicitContentDetectionConfig *StreamingExplicitContentDetectionConfig `protobuf:"bytes,4,opt,name=explicit_content_detection_config,json=explicitContentDetectionConfig,proto3,oneof"`
}

type StreamingVideoConfig_ObjectTrackingConfig struct {
	ObjectTrackingConfig *StreamingObjectTrackingConfig `protobuf:"bytes,5,opt,name=object_tracking_config,json=objectTrackingConfig,proto3,oneof"`
}

func (*StreamingVideoConfig_ShotChangeDetectionConfig) isStreamingVideoConfig_StreamingConfig() {}

func (*StreamingVideoConfig_LabelDetectionConfig) isStreamingVideoConfig_StreamingConfig() {}

func (*StreamingVideoConfig_ExplicitContentDetectionConfig) isStreamingVideoConfig_StreamingConfig() {}

func (*StreamingVideoConfig_ObjectTrackingConfig) isStreamingVideoConfig_StreamingConfig() {}

func (m *StreamingVideoConfig) GetStreamingConfig() isStreamingVideoConfig_StreamingConfig {
	if m != nil {
		return m.StreamingConfig
	}
	return nil
}

func (m *StreamingVideoConfig) GetShotChangeDetectionConfig() *StreamingShotChangeDetectionConfig {
	if x, ok := m.GetStreamingConfig().(*StreamingVideoConfig_ShotChangeDetectionConfig); ok {
		return x.ShotChangeDetectionConfig
	}
	return nil
}

func (m *StreamingVideoConfig) GetLabelDetectionConfig() *StreamingLabelDetectionConfig {
	if x, ok := m.GetStreamingConfig().(*StreamingVideoConfig_LabelDetectionConfig); ok {
		return x.LabelDetectionConfig
	}
	return nil
}

func (m *StreamingVideoConfig) GetExplicitContentDetectionConfig() *StreamingExplicitContentDetectionConfig {
	if x, ok := m.GetStreamingConfig().(*StreamingVideoConfig_ExplicitContentDetectionConfig); ok {
		return x.ExplicitContentDetectionConfig
	}
	return nil
}

func (m *StreamingVideoConfig) GetObjectTrackingConfig() *StreamingObjectTrackingConfig {
	if x, ok := m.GetStreamingConfig().(*StreamingVideoConfig_ObjectTrackingConfig); ok {
		return x.ObjectTrackingConfig
	}
	return nil
}

func (m *StreamingVideoConfig) GetStorageConfig() *StreamingStorageConfig {
	if m != nil {
		return m.StorageConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StreamingVideoConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StreamingVideoConfig_OneofMarshaler, _StreamingVideoConfig_OneofUnmarshaler, _StreamingVideoConfig_OneofSizer, []interface{}{
		(*StreamingVideoConfig_ShotChangeDetectionConfig)(nil),
		(*StreamingVideoConfig_LabelDetectionConfig)(nil),
		(*StreamingVideoConfig_ExplicitContentDetectionConfig)(nil),
		(*StreamingVideoConfig_ObjectTrackingConfig)(nil),
	}
}

func _StreamingVideoConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StreamingVideoConfig)
	// streaming_config
	switch x := m.StreamingConfig.(type) {
	case *StreamingVideoConfig_ShotChangeDetectionConfig:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ShotChangeDetectionConfig); err != nil {
			return err
		}
	case *StreamingVideoConfig_LabelDetectionConfig:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LabelDetectionConfig); err != nil {
			return err
		}
	case *StreamingVideoConfig_ExplicitContentDetectionConfig:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ExplicitContentDetectionConfig); err != nil {
			return err
		}
	case *StreamingVideoConfig_ObjectTrackingConfig:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ObjectTrackingConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("StreamingVideoConfig.StreamingConfig has unexpected type %T", x)
	}
	return nil
}

func _StreamingVideoConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StreamingVideoConfig)
	switch tag {
	case 2: // streaming_config.shot_change_detection_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StreamingShotChangeDetectionConfig)
		err := b.DecodeMessage(msg)
		m.StreamingConfig = &StreamingVideoConfig_ShotChangeDetectionConfig{msg}
		return true, err
	case 3: // streaming_config.label_detection_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StreamingLabelDetectionConfig)
		err := b.DecodeMessage(msg)
		m.StreamingConfig = &StreamingVideoConfig_LabelDetectionConfig{msg}
		return true, err
	case 4: // streaming_config.explicit_content_detection_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StreamingExplicitContentDetectionConfig)
		err := b.DecodeMessage(msg)
		m.StreamingConfig = &StreamingVideoConfig_ExplicitContentDetectionConfig{msg}
		return true, err
	case 5: // streaming_config.object_tracking_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StreamingObjectTrackingConfig)
		err := b.DecodeMessage(msg)
		m.StreamingConfig = &StreamingVideoConfig_ObjectTrackingConfig{msg}
		return true, err
	default:
		return false, nil
	}
}

func _StreamingVideoConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StreamingVideoConfig)
	// streaming_config
	switch x := m.StreamingConfig.(type) {
	case *StreamingVideoConfig_ShotChangeDetectionConfig:
		s := proto.Size(x.ShotChangeDetectionConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StreamingVideoConfig_LabelDetectionConfig:
		s := proto.Size(x.LabelDetectionConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StreamingVideoConfig_ExplicitContentDetectionConfig:
		s := proto.Size(x.ExplicitContentDetectionConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StreamingVideoConfig_ObjectTrackingConfig:
		s := proto.Size(x.ObjectTrackingConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*AnnotateVideoRequest)(nil), "google.cloud.videointelligence.v1p3beta1.AnnotateVideoRequest")
	proto.RegisterType((*VideoContext)(nil), "google.cloud.videointelligence.v1p3beta1.VideoContext")
	proto.RegisterType((*LabelDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.LabelDetectionConfig")
	proto.RegisterType((*ShotChangeDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.ShotChangeDetectionConfig")
	proto.RegisterType((*ExplicitContentDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.ExplicitContentDetectionConfig")
	proto.RegisterType((*TextDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.TextDetectionConfig")
	proto.RegisterType((*VideoSegment)(nil), "google.cloud.videointelligence.v1p3beta1.VideoSegment")
	proto.RegisterType((*LabelSegment)(nil), "google.cloud.videointelligence.v1p3beta1.LabelSegment")
	proto.RegisterType((*LabelFrame)(nil), "google.cloud.videointelligence.v1p3beta1.LabelFrame")
	proto.RegisterType((*Entity)(nil), "google.cloud.videointelligence.v1p3beta1.Entity")
	proto.RegisterType((*LabelAnnotation)(nil), "google.cloud.videointelligence.v1p3beta1.LabelAnnotation")
	proto.RegisterType((*ExplicitContentFrame)(nil), "google.cloud.videointelligence.v1p3beta1.ExplicitContentFrame")
	proto.RegisterType((*ExplicitContentAnnotation)(nil), "google.cloud.videointelligence.v1p3beta1.ExplicitContentAnnotation")
	proto.RegisterType((*NormalizedBoundingBox)(nil), "google.cloud.videointelligence.v1p3beta1.NormalizedBoundingBox")
	proto.RegisterType((*VideoAnnotationResults)(nil), "google.cloud.videointelligence.v1p3beta1.VideoAnnotationResults")
	proto.RegisterType((*AnnotateVideoResponse)(nil), "google.cloud.videointelligence.v1p3beta1.AnnotateVideoResponse")
	proto.RegisterType((*VideoAnnotationProgress)(nil), "google.cloud.videointelligence.v1p3beta1.VideoAnnotationProgress")
	proto.RegisterType((*AnnotateVideoProgress)(nil), "google.cloud.videointelligence.v1p3beta1.AnnotateVideoProgress")
	proto.RegisterType((*NormalizedVertex)(nil), "google.cloud.videointelligence.v1p3beta1.NormalizedVertex")
	proto.RegisterType((*NormalizedBoundingPoly)(nil), "google.cloud.videointelligence.v1p3beta1.NormalizedBoundingPoly")
	proto.RegisterType((*TextSegment)(nil), "google.cloud.videointelligence.v1p3beta1.TextSegment")
	proto.RegisterType((*TextFrame)(nil), "google.cloud.videointelligence.v1p3beta1.TextFrame")
	proto.RegisterType((*TextAnnotation)(nil), "google.cloud.videointelligence.v1p3beta1.TextAnnotation")
	proto.RegisterType((*ObjectTrackingFrame)(nil), "google.cloud.videointelligence.v1p3beta1.ObjectTrackingFrame")
	proto.RegisterType((*ObjectTrackingAnnotation)(nil), "google.cloud.videointelligence.v1p3beta1.ObjectTrackingAnnotation")
	proto.RegisterType((*StreamingAnnotateVideoRequest)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingAnnotateVideoRequest")
	proto.RegisterType((*StreamingAnnotateVideoResponse)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingAnnotateVideoResponse")
	proto.RegisterType((*StreamingExplicitContentDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingExplicitContentDetectionConfig")
	proto.RegisterType((*StreamingLabelDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingLabelDetectionConfig")
	proto.RegisterType((*StreamingObjectTrackingConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingObjectTrackingConfig")
	proto.RegisterType((*StreamingShotChangeDetectionConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingShotChangeDetectionConfig")
	proto.RegisterType((*StreamingStorageConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingStorageConfig")
	proto.RegisterType((*StreamingVideoAnnotationResults)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingVideoAnnotationResults")
	proto.RegisterType((*StreamingVideoConfig)(nil), "google.cloud.videointelligence.v1p3beta1.StreamingVideoConfig")
	proto.RegisterEnum("google.cloud.videointelligence.v1p3beta1.Feature", Feature_name, Feature_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1p3beta1.LabelDetectionMode", LabelDetectionMode_name, LabelDetectionMode_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1p3beta1.Likelihood", Likelihood_name, Likelihood_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1p3beta1.StreamingFeature", StreamingFeature_name, StreamingFeature_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// VideoIntelligenceServiceClient is the client API for VideoIntelligenceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VideoIntelligenceServiceClient interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type videoIntelligenceServiceClient struct {
	cc *grpc.ClientConn
}

func NewVideoIntelligenceServiceClient(cc *grpc.ClientConn) VideoIntelligenceServiceClient {
	return &videoIntelligenceServiceClient{cc}
}

func (c *videoIntelligenceServiceClient) AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.videointelligence.v1p3beta1.VideoIntelligenceService/AnnotateVideo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VideoIntelligenceServiceServer is the server API for VideoIntelligenceService service.
type VideoIntelligenceServiceServer interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(context.Context, *AnnotateVideoRequest) (*longrunning.Operation, error)
}

func RegisterVideoIntelligenceServiceServer(s *grpc.Server, srv VideoIntelligenceServiceServer) {
	s.RegisterService(&_VideoIntelligenceService_serviceDesc, srv)
}

func _VideoIntelligenceService_AnnotateVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.videointelligence.v1p3beta1.VideoIntelligenceService/AnnotateVideo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, req.(*AnnotateVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1p3beta1.VideoIntelligenceService",
	HandlerType: (*VideoIntelligenceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnnotateVideo",
			Handler:    _VideoIntelligenceService_AnnotateVideo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/videointelligence/v1p3beta1/video_intelligence.proto",
}

// StreamingVideoIntelligenceServiceClient is the client API for StreamingVideoIntelligenceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type StreamingVideoIntelligenceServiceClient interface {
	// Performs video annotation with bidirectional streaming: emitting results
	// while sending video/audio bytes.
	// This method is only available via the gRPC API (not REST).
	StreamingAnnotateVideo(ctx context.Context, opts ...grpc.CallOption) (StreamingVideoIntelligenceService_StreamingAnnotateVideoClient, error)
}

type streamingVideoIntelligenceServiceClient struct {
	cc *grpc.ClientConn
}

func NewStreamingVideoIntelligenceServiceClient(cc *grpc.ClientConn) StreamingVideoIntelligenceServiceClient {
	return &streamingVideoIntelligenceServiceClient{cc}
}

func (c *streamingVideoIntelligenceServiceClient) StreamingAnnotateVideo(ctx context.Context, opts ...grpc.CallOption) (StreamingVideoIntelligenceService_StreamingAnnotateVideoClient, error) {
	stream, err := c.cc.NewStream(ctx, &_StreamingVideoIntelligenceService_serviceDesc.Streams[0], "/google.cloud.videointelligence.v1p3beta1.StreamingVideoIntelligenceService/StreamingAnnotateVideo", opts...)
	if err != nil {
		return nil, err
	}
	x := &streamingVideoIntelligenceServiceStreamingAnnotateVideoClient{stream}
	return x, nil
}

type StreamingVideoIntelligenceService_StreamingAnnotateVideoClient interface {
	Send(*StreamingAnnotateVideoRequest) error
	Recv() (*StreamingAnnotateVideoResponse, error)
	grpc.ClientStream
}

type streamingVideoIntelligenceServiceStreamingAnnotateVideoClient struct {
	grpc.ClientStream
}

func (x *streamingVideoIntelligenceServiceStreamingAnnotateVideoClient) Send(m *StreamingAnnotateVideoRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *streamingVideoIntelligenceServiceStreamingAnnotateVideoClient) Recv() (*StreamingAnnotateVideoResponse, error) {
	m := new(StreamingAnnotateVideoResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// StreamingVideoIntelligenceServiceServer is the server API for StreamingVideoIntelligenceService service.
type StreamingVideoIntelligenceServiceServer interface {
	// Performs video annotation with bidirectional streaming: emitting results
	// while sending video/audio bytes.
	// This method is only available via the gRPC API (not REST).
	StreamingAnnotateVideo(StreamingVideoIntelligenceService_StreamingAnnotateVideoServer) error
}

func RegisterStreamingVideoIntelligenceServiceServer(s *grpc.Server, srv StreamingVideoIntelligenceServiceServer) {
	s.RegisterService(&_StreamingVideoIntelligenceService_serviceDesc, srv)
}

func _StreamingVideoIntelligenceService_StreamingAnnotateVideo_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(StreamingVideoIntelligenceServiceServer).StreamingAnnotateVideo(&streamingVideoIntelligenceServiceStreamingAnnotateVideoServer{stream})
}

type StreamingVideoIntelligenceService_StreamingAnnotateVideoServer interface {
	Send(*StreamingAnnotateVideoResponse) error
	Recv() (*StreamingAnnotateVideoRequest, error)
	grpc.ServerStream
}

type streamingVideoIntelligenceServiceStreamingAnnotateVideoServer struct {
	grpc.ServerStream
}

func (x *streamingVideoIntelligenceServiceStreamingAnnotateVideoServer) Send(m *StreamingAnnotateVideoResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *streamingVideoIntelligenceServiceStreamingAnnotateVideoServer) Recv() (*StreamingAnnotateVideoRequest, error) {
	m := new(StreamingAnnotateVideoRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _StreamingVideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1p3beta1.StreamingVideoIntelligenceService",
	HandlerType: (*StreamingVideoIntelligenceServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingAnnotateVideo",
			Handler:       _StreamingVideoIntelligenceService_StreamingAnnotateVideo_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/videointelligence/v1p3beta1/video_intelligence.proto",
}

func init() {
	proto.RegisterFile("google/cloud/videointelligence/v1p3beta1/video_intelligence.proto", fileDescriptor_video_intelligence_8d71f55b0eb40d35)
}

var fileDescriptor_video_intelligence_8d71f55b0eb40d35 = []byte{
	// 2371 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x5a, 0xcf, 0x6f, 0xe3, 0xc6,
	0xf5, 0x37, 0x25, 0xdb, 0x6b, 0x3d, 0xcb, 0xb6, 0x3c, 0xfe, 0x25, 0x3b, 0xf1, 0x8f, 0x70, 0xb3,
	0xf8, 0x3a, 0xfb, 0x2d, 0xe4, 0xac, 0x37, 0x0d, 0x9a, 0xcd, 0x8f, 0x46, 0x92, 0xb5, 0x96, 0xba,
	0xb6, 0xe5, 0xd0, 0xb2, 0x91, 0x6d, 0xb7, 0x20, 0x68, 0x6a, 0x44, 0xb3, 0x4b, 0x71, 0xb4, 0xe4,
	0xc8, 0xb1, 0x7b, 0x49, 0x50, 0xf4, 0x50, 0xa0, 0x87, 0x1e, 0x82, 0x02, 0x05, 0x0a, 0xe4, 0x0f,
	0xe8, 0xa5, 0x45, 0xaf, 0x3d, 0xb4, 0x28, 0x7a, 0x69, 0xd0, 0x5b, 0x91, 0x43, 0x8b, 0x1e, 0x7b,
	0x28, 0xd0, 0xff, 0xa0, 0xa7, 0x82, 0x33, 0x43, 0x8a, 0x22, 0x25, 0xdb, 0x92, 0xb3, 0xe8, 0x4d,
	0xf3, 0x66, 0xe6, 0xf3, 0x7e, 0xce, 0x7b, 0x6f, 0x86, 0x82, 0xbc, 0x41, 0x88, 0x61, 0xe1, 0x2d,
	0xdd, 0x22, 0xed, 0xfa, 0xd6, 0xb9, 0x59, 0xc7, 0xc4, 0xb4, 0x29, 0xb6, 0x2c, 0xd3, 0xc0, 0xb6,
	0x8e, 0xb7, 0xce, 0x1f, 0xb4, 0x1e, 0x9e, 0x62, 0xaa, 0x3d, 0xe0, 0x73, 0x6a, 0x78, 0x32, 0xd7,
	0x72, 0x08, 0x25, 0x68, 0x93, 0x43, 0xe4, 0x18, 0x44, 0x2e, 0x06, 0x91, 0x0b, 0x20, 0x56, 0x5e,
	0x15, 0xcc, 0xb4, 0x96, 0xb9, 0xa5, 0xd9, 0x36, 0xa1, 0x1a, 0x35, 0x89, 0xed, 0x72, 0x9c, 0x95,
	0xbb, 0x62, 0xd6, 0x22, 0xb6, 0xe1, 0xb4, 0x6d, 0xdb, 0xb4, 0x8d, 0x2d, 0xd2, 0xc2, 0x4e, 0xd7,
	0xa2, 0x35, 0xb1, 0x88, 0x8d, 0x4e, 0xdb, 0x8d, 0xad, 0x7a, 0x9b, 0x2f, 0x10, 0xf3, 0xeb, 0xd1,
	0x79, 0x6a, 0x36, 0xb1, 0x4b, 0xb5, 0x66, 0x4b, 0x2c, 0x58, 0x12, 0x0b, 0x9c, 0x96, 0xbe, 0xe5,
	0x52, 0x8d, 0xb6, 0x05, 0xb2, 0xfc, 0xa7, 0x04, 0xcc, 0xe7, 0xb9, 0x50, 0xf8, 0xc4, 0x53, 0x42,
	0xc1, 0x2f, 0xda, 0xd8, 0xa5, 0xe8, 0x15, 0x48, 0x99, 0x76, 0xab, 0x4d, 0xd5, 0xb6, 0x63, 0x66,
	0xa5, 0x0d, 0x69, 0x33, 0xa5, 0x4c, 0x30, 0xc2, 0xb1, 0x63, 0xa2, 0xbb, 0x30, 0xc5, 0x27, 0x75,
	0x62, 0x53, 0x6c, 0xd3, 0xec, 0xf8, 0x86, 0xb4, 0x99, 0x56, 0xd2, 0x8c, 0x58, 0xe4, 0x34, 0xb4,
	0x0f, 0x13, 0x0d, 0xac, 0xd1, 0xb6, 0x83, 0xdd, 0x6c, 0x62, 0x23, 0xb9, 0x39, 0xbd, 0xfd, 0x20,
	0x77, 0x53, 0xa3, 0xe5, 0x1e, 0xf3, 0x9d, 0x4a, 0x00, 0x81, 0xbe, 0x07, 0x53, 0xdc, 0x19, 0x8c,
	0xe7, 0x05, 0xcd, 0x26, 0x37, 0xa4, 0xcd, 0xc9, 0xed, 0xb7, 0x6f, 0x8e, 0xc9, 0xf4, 0x2b, 0xf2,
	0xdd, 0x4a, 0xfa, 0x3c, 0x34, 0x42, 0xab, 0x00, 0xa4, 0x4d, 0x7d, 0x75, 0x47, 0x99, 0xba, 0x29,
	0x4e, 0xf1, 0xf4, 0x5d, 0x87, 0x49, 0x8b, 0xe8, 0xcc, 0xe2, 0xaa, 0x59, 0xcf, 0x8e, 0xb1, 0x79,
	0xf0, 0x49, 0x95, 0xba, 0xfc, 0xaf, 0x51, 0x48, 0x87, 0xe1, 0x91, 0x02, 0x13, 0x2e, 0x36, 0x9a,
	0xd8, 0xa6, 0x6e, 0x56, 0xda, 0x48, 0x0e, 0x21, 0xe8, 0x11, 0xdf, 0xae, 0x04, 0x38, 0x88, 0xc2,
	0xa2, 0xa5, 0x9d, 0x62, 0x4b, 0xad, 0x63, 0x8a, 0x75, 0x26, 0x8c, 0x4e, 0xec, 0x86, 0x69, 0x64,
	0x13, 0xcc, 0x14, 0x1f, 0xdc, 0x9c, 0xc3, 0x9e, 0x87, 0xb3, 0xe3, 0xc3, 0x14, 0x19, 0x8a, 0x32,
	0x6f, 0xf5, 0xa0, 0xa2, 0x1f, 0x4b, 0xf0, 0xaa, 0x7b, 0x46, 0xa8, 0xaa, 0x9f, 0x69, 0xb6, 0x81,
	0xe3, 0xcc, 0xb9, 0x1f, 0x8a, 0x37, 0x67, 0x7e, 0x74, 0x46, 0x68, 0x91, 0x81, 0x45, 0x25, 0x58,
	0x76, 0xfb, 0x4d, 0xa1, 0xcf, 0x25, 0x78, 0x0d, 0x5f, 0xb4, 0x2c, 0x53, 0x37, 0x83, 0xb0, 0x8b,
	0xcb, 0x32, 0xca, 0x64, 0x29, 0xdf, 0x5c, 0x96, 0x92, 0x80, 0x14, 0x41, 0x1b, 0x15, 0x68, 0x0d,
	0x5f, 0x39, 0x8f, 0x5e, 0xc0, 0x82, 0xe7, 0xee, 0xb8, 0x20, 0x13, 0x4c, 0x90, 0xf7, 0x6f, 0x2e,
	0x48, 0x0d, 0x5f, 0xc4, 0xb8, 0xcf, 0xd1, 0x38, 0x51, 0xfe, 0xb3, 0x04, 0xf3, 0xbd, 0xdc, 0x87,
	0x6c, 0x98, 0x8f, 0x86, 0x47, 0x93, 0xd4, 0x31, 0x3b, 0xbc, 0xd3, 0xdb, 0xef, 0x0d, 0x1b, 0x1c,
	0xfb, 0xa4, 0x8e, 0x15, 0x64, 0xc5, 0x68, 0xe8, 0xff, 0x61, 0xd6, 0xe5, 0xb9, 0x4c, 0x73, 0x2e,
	0x55, 0x5d, 0x6b, 0x62, 0x47, 0x63, 0x91, 0x38, 0xa1, 0x64, 0x3a, 0x13, 0x45, 0x46, 0x47, 0xf3,
	0x30, 0xe6, 0x09, 0x63, 0xb1, 0x68, 0x49, 0x29, 0x7c, 0x20, 0x3f, 0x80, 0xe5, 0xbe, 0xc1, 0xd0,
	0xd9, 0x22, 0x85, 0xb7, 0xbc, 0x0d, 0x6b, 0x57, 0xfb, 0xac, 0xcf, 0xbe, 0xf7, 0x60, 0xae, 0x87,
	0x89, 0xd1, 0x3d, 0x98, 0xb6, 0x34, 0xdb, 0x68, 0x6b, 0x06, 0x56, 0xcf, 0x4c, 0xff, 0xb4, 0xa6,
	0x94, 0x29, 0x9f, 0x5a, 0xf6, 0x88, 0xf2, 0x2f, 0x24, 0x71, 0xbe, 0xc5, 0xa9, 0x44, 0x25, 0xa6,
	0xbc, 0x43, 0x55, 0x2f, 0xd3, 0xaa, 0xa4, 0xd1, 0x70, 0x31, 0x65, 0x0c, 0x27, 0xb7, 0x97, 0x7d,
	0x4b, 0xfb, 0xd9, 0x38, 0xb7, 0x23, 0xb2, 0xb5, 0x32, 0xc3, 0xf6, 0xd4, 0xcc, 0x26, 0xae, 0xb2,
	0x1d, 0x28, 0x0f, 0x33, 0xd8, 0xae, 0x77, 0x81, 0x24, 0xae, 0x03, 0x99, 0xc2, 0x76, 0xbd, 0x03,
	0x21, 0x7f, 0x26, 0x41, 0x9a, 0x79, 0xcc, 0x17, 0xed, 0x10, 0xee, 0x88, 0x94, 0x21, 0x04, 0x1a,
	0x36, 0xf3, 0xf8, 0x30, 0x68, 0x0d, 0x80, 0x85, 0x75, 0xdd, 0x5b, 0xcd, 0x04, 0x4c, 0x28, 0x21,
	0x8a, 0x7c, 0x06, 0xc0, 0x24, 0x78, 0xec, 0x68, 0x4d, 0x8c, 0x1e, 0xc1, 0xe4, 0x40, 0x46, 0x01,
	0xda, 0xb1, 0xc7, 0x75, 0x9c, 0x2c, 0x18, 0x2f, 0xd9, 0xd4, 0xa4, 0x97, 0x5e, 0x7d, 0xc2, 0xec,
	0x97, 0x97, 0x90, 0x45, 0x7d, 0xe2, 0x84, 0x4a, 0x1d, 0x6d, 0xc0, 0x64, 0x1d, 0xbb, 0xba, 0x63,
	0xb6, 0x3c, 0x0e, 0x0c, 0x27, 0xa5, 0x84, 0x49, 0x5e, 0x05, 0x0b, 0xfc, 0xae, 0x7b, 0xa7, 0x84,
	0xc7, 0x65, 0xda, 0x27, 0x16, 0x49, 0x1d, 0xcb, 0xff, 0x48, 0xc0, 0x0c, 0x53, 0x2c, 0x1f, 0x94,
	0x6d, 0x54, 0x86, 0x71, 0xce, 0x46, 0x28, 0xf6, 0xe6, 0x00, 0xb9, 0x86, 0xed, 0x53, 0xc4, 0x7e,
	0xf4, 0x7d, 0x98, 0xd5, 0x35, 0x8a, 0x0d, 0xe2, 0x5c, 0xaa, 0x8c, 0x64, 0x8a, 0x42, 0x39, 0x0c,
	0x68, 0xc6, 0x87, 0x2a, 0x09, 0xa4, 0xae, 0x0a, 0x94, 0x1c, 0xb4, 0x02, 0x85, 0x03, 0x2a, 0x54,
	0x81, 0xf6, 0x60, 0xbc, 0xe1, 0xf9, 0xd8, 0xcd, 0x8e, 0x32, 0xc4, 0xb7, 0x06, 0x44, 0x64, 0x01,
	0xa2, 0x08, 0x0c, 0xf9, 0xf7, 0x12, 0xcc, 0x47, 0xce, 0xf2, 0xed, 0x23, 0xe8, 0x39, 0x2c, 0xb6,
	0x88, 0x63, 0x13, 0xc3, 0xd1, 0x5a, 0x67, 0x97, 0xaa, 0x65, 0x3e, 0xc7, 0x96, 0x79, 0x46, 0x48,
	0x9d, 0x45, 0xc1, 0xf4, 0x40, 0x22, 0x07, 0x7b, 0x95, 0x85, 0x10, 0x66, 0x87, 0x2c, 0xbb, 0xb0,
	0x1c, 0x51, 0x20, 0x14, 0x29, 0x27, 0x81, 0xb1, 0x78, 0x03, 0xf0, 0xc1, 0xd0, 0x55, 0xa9, 0xdb,
	0x6c, 0xcf, 0x61, 0xe1, 0x80, 0x38, 0x4d, 0xcd, 0x32, 0x7f, 0x88, 0xeb, 0x05, 0xd2, 0xb6, 0xeb,
	0xa6, 0x6d, 0x14, 0xc8, 0x05, 0x42, 0x30, 0x6a, 0xe1, 0x06, 0xb7, 0x57, 0x42, 0x61, 0xbf, 0x51,
	0x06, 0x92, 0x94, 0xb4, 0xc4, 0x49, 0xf2, 0x7e, 0x7a, 0xe9, 0xd1, 0x31, 0x8d, 0x33, 0xde, 0x3f,
	0x25, 0x14, 0x3e, 0x40, 0x8b, 0x30, 0x7e, 0x4a, 0x28, 0x25, 0x4d, 0x56, 0x42, 0x13, 0x8a, 0x18,
	0xc9, 0xff, 0x1e, 0x87, 0x45, 0x96, 0x14, 0x3a, 0x8a, 0x29, 0xd8, 0x6d, 0x5b, 0xd4, 0xbd, 0xba,
	0x43, 0x6c, 0xc3, 0xb2, 0x88, 0x1a, 0x95, 0x17, 0xa5, 0x50, 0xe7, 0x2b, 0x82, 0xfc, 0x9d, 0x01,
	0x83, 0x27, 0x24, 0xc1, 0x92, 0xc0, 0x8e, 0xd0, 0x5d, 0x44, 0x60, 0x91, 0xf5, 0x2a, 0x71, 0x9e,
	0xc9, 0xdb, 0xf2, 0x9c, 0xf7, 0x80, 0x63, 0x0c, 0x5f, 0xc0, 0x12, 0x73, 0x4b, 0x0f, 0x8e, 0xa3,
	0xb7, 0xe5, 0xb8, 0xc0, 0x90, 0x63, 0x2c, 0x35, 0xc8, 0x30, 0x1d, 0xc3, 0xbc, 0xc6, 0x6f, 0xd5,
	0x62, 0xce, 0x78, 0x78, 0x61, 0x16, 0x14, 0xe6, 0x82, 0x5e, 0xab, 0xc3, 0x26, 0x7b, 0x67, 0xd0,
	0x4e, 0xaf, 0xef, 0xe1, 0x50, 0x90, 0x8f, 0x1f, 0x3a, 0x30, 0x3a, 0x64, 0x58, 0x33, 0x15, 0x56,
	0x2c, 0xcd, 0x14, 0xfb, 0xd6, 0x60, 0x7d, 0x54, 0x88, 0xcf, 0x0c, 0xed, 0x1a, 0x7b, 0x0e, 0x43,
	0xe4, 0xf4, 0x07, 0x58, 0xef, 0x66, 0x33, 0xcd, 0xd8, 0x14, 0x6e, 0xce, 0xa6, 0xca, 0x30, 0x6a,
	0x8e, 0xa6, 0x3f, 0x37, 0x6d, 0x23, 0xc4, 0x70, 0x96, 0xa3, 0x87, 0x59, 0x6e, 0xc2, 0x18, 0x76,
	0x1c, 0xe2, 0x64, 0x53, 0xcc, 0x7e, 0xc8, 0xe7, 0xe2, 0xb4, 0xf4, 0xdc, 0x11, 0xbb, 0x8c, 0x29,
	0x7c, 0x81, 0xfc, 0x13, 0x09, 0x16, 0x22, 0xb7, 0x31, 0xb7, 0x45, 0x6c, 0x17, 0x23, 0x02, 0xa8,
	0x23, 0xaf, 0xea, 0xf0, 0x23, 0x28, 0x12, 0xcb, 0x87, 0x03, 0xba, 0x3d, 0x76, 0x94, 0x95, 0x59,
	0x2d, 0x4a, 0x92, 0xff, 0x26, 0xc1, 0x52, 0x64, 0xf5, 0xa1, 0x43, 0x0c, 0x07, 0xbb, 0xd7, 0x9c,
	0xfc, 0x37, 0x20, 0xd3, 0x12, 0x0b, 0xd5, 0x16, 0x76, 0x74, 0xaf, 0x0f, 0xf1, 0xd2, 0xcf, 0x98,
	0x32, 0xe3, 0xd3, 0x0f, 0x39, 0x19, 0xbd, 0x03, 0xd0, 0x69, 0xa2, 0xc4, 0x3d, 0x62, 0x25, 0x96,
	0xe6, 0x6b, 0xfe, 0x5d, 0x56, 0x49, 0x05, 0xed, 0x13, 0x7a, 0x17, 0x26, 0xdb, 0xad, 0xba, 0x46,
	0x31, 0xdf, 0x3b, 0x7a, 0xed, 0x5e, 0xe0, 0xcb, 0x3d, 0x82, 0xfc, 0xd3, 0xa8, 0x99, 0x03, 0xcd,
	0x1c, 0x98, 0x0b, 0x99, 0xd9, 0x97, 0x57, 0xd8, 0x39, 0x3f, 0xb4, 0x9d, 0x7d, 0x7c, 0x25, 0xe4,
	0x44, 0x9f, 0x26, 0xe7, 0x20, 0xd3, 0xc9, 0xe7, 0x27, 0xd8, 0xa1, 0xf8, 0x02, 0xa5, 0x41, 0xba,
	0x10, 0x79, 0x5c, 0x62, 0xa3, 0x4b, 0x91, 0xc2, 0xa5, 0x4b, 0xb9, 0x05, 0x8b, 0xf1, 0xfc, 0x7f,
	0x48, 0xac, 0x4b, 0x74, 0x02, 0x13, 0xe7, 0xd8, 0xa1, 0xa6, 0x1e, 0xd4, 0x9c, 0x47, 0x37, 0x17,
	0x39, 0x2a, 0x83, 0x12, 0x60, 0xc9, 0x7f, 0x91, 0x60, 0xd2, 0x3b, 0x57, 0xff, 0xb3, 0x0e, 0x13,
	0x3d, 0x09, 0x6a, 0x29, 0xcf, 0xe3, 0x0f, 0x07, 0x4b, 0x08, 0xdd, 0x05, 0xf4, 0x77, 0x12, 0xa4,
	0x02, 0x2a, 0x72, 0x60, 0xde, 0x61, 0x91, 0x50, 0x57, 0x4f, 0x85, 0x31, 0xd5, 0x53, 0x72, 0x21,
	0x34, 0xfb, 0x70, 0x18, 0x03, 0x86, 0x9d, 0xa2, 0x20, 0x81, 0x1e, 0xae, 0xd4, 0x91, 0x06, 0x27,
	0x31, 0x40, 0x83, 0x23, 0x7f, 0x02, 0xd3, 0xdd, 0x39, 0xce, 0xab, 0xfb, 0xec, 0x41, 0x84, 0x9f,
	0x44, 0xf6, 0x1b, 0x7d, 0x14, 0xea, 0xfe, 0x78, 0xb9, 0xfd, 0xe6, 0x60, 0x26, 0x8b, 0x35, 0x7f,
	0xf2, 0x97, 0x12, 0xcc, 0x75, 0xa7, 0x3d, 0x6e, 0xc0, 0x4f, 0x60, 0xc9, 0x0e, 0x54, 0xef, 0x65,
	0xc3, 0x6f, 0xdf, 0xc6, 0x86, 0x05, 0x72, 0xa1, 0x2c, 0xd8, 0x3d, 0xfb, 0x9d, 0xdb, 0x58, 0xf1,
	0xef, 0x09, 0xc8, 0xf6, 0xcb, 0xe1, 0x5f, 0x63, 0x8f, 0xdf, 0x1d, 0xd7, 0xa3, 0xb1, 0xb8, 0x3e,
	0x0e, 0xe2, 0x9a, 0x3b, 0xe9, 0xfd, 0x61, 0x2b, 0x50, 0x57, 0x84, 0x23, 0xa5, 0x73, 0x40, 0x93,
	0xb7, 0x39, 0xa0, 0xe5, 0x91, 0xce, 0x11, 0x7d, 0x05, 0x26, 0xa8, 0xc7, 0xcc, 0x7f, 0x00, 0x4b,
	0x7a, 0x93, 0x8c, 0x52, 0xa9, 0x17, 0xd2, 0x00, 0x62, 0xd2, 0x6e, 0x10, 0xf9, 0x0f, 0x12, 0xac,
	0x1e, 0x51, 0x07, 0x6b, 0xcd, 0x8e, 0x5d, 0xbb, 0x5f, 0x17, 0x75, 0x48, 0x07, 0x8f, 0x79, 0x0d,
	0xd3, 0x10, 0x76, 0x1e, 0xa0, 0x43, 0x0e, 0xe0, 0xfd, 0x57, 0xb7, 0x86, 0x69, 0x94, 0x47, 0x94,
	0xc9, 0xf3, 0xce, 0x10, 0xdd, 0x8b, 0xbe, 0x52, 0x7a, 0x11, 0x92, 0x2e, 0x8f, 0x74, 0xbf, 0x53,
	0x16, 0xe6, 0xbc, 0xab, 0xbc, 0x40, 0x53, 0x1d, 0x2e, 0xa0, 0xfc, 0x1f, 0x09, 0xd6, 0xfa, 0xa9,
	0x20, 0x4a, 0x72, 0x50, 0xd6, 0xa5, 0x6b, 0xca, 0x3a, 0xba, 0xe8, 0x59, 0xbc, 0x79, 0xbc, 0x56,
	0x86, 0xd5, 0xf9, 0x26, 0x55, 0x1c, 0xbd, 0x05, 0x8b, 0x71, 0xce, 0xac, 0x6c, 0xf3, 0xfb, 0xee,
	0x7c, 0x6c, 0xcb, 0xb1, 0x63, 0xca, 0x6f, 0xc0, 0xff, 0x05, 0xbc, 0xae, 0x7e, 0x6c, 0x91, 0xf7,
	0x42, 0x9e, 0xee, 0xf9, 0x2a, 0xd5, 0xf3, 0x95, 0x48, 0xea, 0xfd, 0x4a, 0x24, 0xaf, 0x87, 0xd0,
	0xba, 0xe3, 0x5b, 0xb0, 0x7b, 0x1d, 0xe4, 0x60, 0x41, 0xdf, 0x97, 0x23, 0xf9, 0x37, 0x12, 0x2c,
	0x76, 0x96, 0x51, 0xe2, 0xb0, 0x0b, 0x3d, 0x13, 0x67, 0x17, 0x36, 0xb0, 0xad, 0x9d, 0x5a, 0x58,
	0x75, 0x39, 0x5d, 0x8d, 0xd9, 0x47, 0x48, 0xb7, 0xca, 0xd7, 0x89, 0xed, 0x51, 0x6b, 0xa3, 0x7d,
	0xb8, 0x1b, 0xdb, 0x19, 0x60, 0xd6, 0x4d, 0x07, 0xeb, 0x94, 0x38, 0x97, 0xc2, 0xcc, 0x1b, 0x51,
	0x33, 0x0b, 0xd4, 0x1d, 0x7f, 0x9d, 0xfc, 0x55, 0x12, 0xd6, 0xaf, 0xf1, 0x6f, 0xcf, 0xc6, 0x5f,
	0xfa, 0x7a, 0x1b, 0xff, 0x06, 0xcc, 0xbe, 0x84, 0xeb, 0x5a, 0xc6, 0x8a, 0xde, 0x61, 0xfa, 0x5c,
	0x30, 0x92, 0x2f, 0xf7, 0x82, 0xd1, 0xbb, 0xf7, 0x1f, 0x7d, 0x89, 0xbd, 0xbf, 0xfc, 0xc5, 0x38,
	0xcc, 0xf7, 0xca, 0x55, 0xa8, 0x06, 0x77, 0xc4, 0xa7, 0x0d, 0xf1, 0x40, 0xfb, 0x68, 0x88, 0x44,
	0xe0, 0x7f, 0x25, 0xf1, 0xa1, 0xd0, 0xcf, 0xae, 0x7b, 0xac, 0xe7, 0x49, 0x67, 0x6f, 0x08, 0x5e,
	0x7d, 0x8f, 0x5b, 0x79, 0xe4, 0xaa, 0x77, 0xfb, 0x4f, 0xfb, 0x7e, 0xb4, 0xe0, 0xce, 0xde, 0x1d,
	0x42, 0x94, 0x5e, 0x89, 0xa6, 0x3c, 0xd2, 0xe7, 0xfb, 0xc5, 0x17, 0x03, 0x7c, 0x38, 0xf8, 0x68,
	0x08, 0x61, 0xae, 0x4e, 0x90, 0xe5, 0x91, 0x6b, 0xbf, 0x21, 0x7c, 0x0a, 0x8b, 0x22, 0x2a, 0xa9,
	0x08, 0x29, 0x5f, 0xa8, 0xb1, 0xa1, 0x2d, 0xd4, 0x2b, 0x79, 0x7a, 0x16, 0x22, 0x3d, 0xe8, 0xc8,
	0x80, 0x69, 0x3f, 0x71, 0x09, 0xc6, 0x6b, 0x83, 0xf6, 0xbe, 0xbd, 0xb3, 0xad, 0x32, 0xe5, 0x86,
	0x87, 0x05, 0x04, 0x99, 0x4e, 0xa5, 0xe5, 0xac, 0xee, 0xff, 0x52, 0x82, 0x3b, 0x22, 0x8c, 0xd1,
	0x12, 0xcc, 0x3d, 0x2e, 0xe5, 0x6b, 0xc7, 0x4a, 0x49, 0x3d, 0x3e, 0x38, 0x3a, 0x2c, 0x15, 0x2b,
	0x8f, 0x2b, 0xa5, 0x9d, 0xcc, 0x08, 0x9a, 0x83, 0x99, 0xbd, 0x7c, 0xa1, 0xb4, 0xa7, 0xee, 0x94,
	0x6a, 0xa5, 0x62, 0xad, 0x52, 0x3d, 0xc8, 0x48, 0x68, 0x19, 0x16, 0x8e, 0xca, 0xd5, 0x9a, 0x5a,
	0x2c, 0xe7, 0x0f, 0x76, 0x4b, 0xa1, 0xa9, 0x04, 0x5a, 0x83, 0x95, 0xd2, 0xc7, 0x87, 0x7b, 0x95,
	0x62, 0xa5, 0xa6, 0x16, 0xab, 0x07, 0xb5, 0xd2, 0x41, 0x2d, 0x34, 0x9f, 0x44, 0x08, 0xa6, 0x6b,
	0xa5, 0x8f, 0xc3, 0xb4, 0x3b, 0x1e, 0x8f, 0x6a, 0xe1, 0x3b, 0xa5, 0x62, 0x4d, 0xad, 0x29, 0xf9,
	0xe2, 0x93, 0xca, 0xc1, 0x6e, 0x26, 0x75, 0xdf, 0x01, 0x14, 0xff, 0x1a, 0x82, 0x5e, 0x87, 0x8d,
	0x88, 0x38, 0xea, 0x7e, 0x75, 0x27, 0x2a, 0xf4, 0x14, 0xa4, 0x98, 0x7c, 0xde, 0x54, 0x46, 0x42,
	0xd3, 0x00, 0x8f, 0x95, 0xfc, 0x7e, 0x89, 0x8f, 0x13, 0x9e, 0xb2, 0x6c, 0x3a, 0x7f, 0xb0, 0xa3,
	0x86, 0x26, 0x92, 0xf7, 0x29, 0x40, 0xe7, 0x89, 0x11, 0xad, 0xc0, 0xe2, 0x5e, 0xe5, 0x49, 0x69,
	0xaf, 0x52, 0xae, 0x56, 0x77, 0x22, 0x1c, 0x66, 0x61, 0xea, 0xa4, 0xa4, 0x3c, 0x55, 0x8f, 0x0f,
	0xd8, 0x92, 0xa7, 0x19, 0x09, 0xa5, 0x61, 0x22, 0x18, 0x25, 0xbc, 0xd1, 0x61, 0xf5, 0xe8, 0xa8,
	0x52, 0xd8, 0x2b, 0x65, 0x92, 0x08, 0x60, 0x5c, 0xcc, 0x8c, 0xa2, 0x19, 0x98, 0x64, 0x5b, 0x05,
	0x61, 0xec, 0xfe, 0x1f, 0x25, 0xc8, 0x44, 0xf3, 0x0a, 0x7a, 0x0d, 0x56, 0x8f, 0x6a, 0x4a, 0x29,
	0xbf, 0x5f, 0x39, 0xd8, 0x55, 0x7b, 0xbb, 0x66, 0x15, 0x96, 0x3b, 0x4b, 0xe2, 0x4e, 0xba, 0x0b,
	0xeb, 0x9d, 0xe9, 0x7e, 0xee, 0xda, 0x84, 0xd7, 0x3b, 0x8b, 0xae, 0x74, 0x5c, 0x17, 0xb7, 0xa8,
	0xbb, 0x46, 0xb7, 0x7f, 0x2b, 0x41, 0x96, 0x25, 0xd9, 0x4a, 0x28, 0x4c, 0x8f, 0xb0, 0x73, 0x6e,
	0xea, 0x18, 0xfd, 0x5c, 0x82, 0xa9, 0xae, 0x4e, 0x0e, 0x0d, 0xd0, 0x6f, 0xf6, 0xea, 0x62, 0x57,
	0x56, 0xfd, 0xfd, 0xa1, 0x8f, 0xf7, 0xb9, 0xaa, 0xff, 0xf1, 0x5e, 0xbe, 0xf7, 0xa3, 0xbf, 0xfe,
	0xf3, 0xf3, 0xc4, 0xba, 0xbc, 0x12, 0xfd, 0x3f, 0x81, 0xfb, 0x48, 0xd4, 0x1f, 0xfc, 0x48, 0xba,
	0xbf, 0xfd, 0x95, 0x04, 0xaf, 0x75, 0x97, 0x88, 0x5e, 0xd2, 0xff, 0x3a, 0xdc, 0xd3, 0x74, 0xab,
	0x31, 0x4c, 0x82, 0xe8, 0xa9, 0x4f, 0xf9, 0xf6, 0x40, 0xbc, 0x37, 0xde, 0x94, 0xde, 0x94, 0x0a,
	0x9f, 0x25, 0xe0, 0x1b, 0x3a, 0x69, 0xde, 0x18, 0xb3, 0xb0, 0xda, 0x4f, 0xf9, 0x43, 0xef, 0x2a,
	0x77, 0x28, 0x7d, 0xf7, 0xa9, 0x80, 0x32, 0x88, 0xa5, 0xd9, 0x46, 0x8e, 0x38, 0xc6, 0x96, 0x81,
	0x6d, 0x76, 0xd1, 0xdb, 0xe2, 0x53, 0x5a, 0xcb, 0x74, 0xaf, 0xff, 0x57, 0xc7, 0xbb, 0xb1, 0xb9,
	0x5f, 0x25, 0x36, 0x77, 0x39, 0x76, 0x91, 0x89, 0x19, 0x93, 0x24, 0x77, 0xf2, 0xe0, 0xf0, 0x61,
	0xc1, 0xdb, 0xfc, 0xa5, 0xbf, 0xf4, 0x19, 0x5b, 0xfa, 0x2c, 0xb6, 0xf4, 0xd9, 0x89, 0xcf, 0xe7,
	0x74, 0x9c, 0xc9, 0xf6, 0xf0, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x6b, 0xcb, 0x43, 0xd9, 0x70,
	0x22, 0x00, 0x00,
}
