// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/bigquery/v2/model.proto

package bigquery // import "google.golang.org/genproto/googleapis/cloud/bigquery/v2"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import empty "github.com/golang/protobuf/ptypes/empty"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import _ "google.golang.org/genproto/googleapis/api/annotations"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Indicates the type of the Model.
type Model_ModelType int32

const (
	Model_MODEL_TYPE_UNSPECIFIED Model_ModelType = 0
	// Linear regression model.
	Model_LINEAR_REGRESSION Model_ModelType = 1
	// Logistic regression model.
	Model_LOGISTIC_REGRESSION Model_ModelType = 2
	// [Beta] K-means clustering model.
	Model_KMEANS Model_ModelType = 3
)

var Model_ModelType_name = map[int32]string{
	0: "MODEL_TYPE_UNSPECIFIED",
	1: "LINEAR_REGRESSION",
	2: "LOGISTIC_REGRESSION",
	3: "KMEANS",
}
var Model_ModelType_value = map[string]int32{
	"MODEL_TYPE_UNSPECIFIED": 0,
	"LINEAR_REGRESSION":      1,
	"LOGISTIC_REGRESSION":    2,
	"KMEANS":                 3,
}

func (x Model_ModelType) String() string {
	return proto.EnumName(Model_ModelType_name, int32(x))
}
func (Model_ModelType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{0, 0}
}

// Loss metric to evaluate model training performance.
type Model_LossType int32

const (
	Model_LOSS_TYPE_UNSPECIFIED Model_LossType = 0
	// Mean squared loss, used for linear regression.
	Model_MEAN_SQUARED_LOSS Model_LossType = 1
	// Mean log loss, used for logistic regression.
	Model_MEAN_LOG_LOSS Model_LossType = 2
)

var Model_LossType_name = map[int32]string{
	0: "LOSS_TYPE_UNSPECIFIED",
	1: "MEAN_SQUARED_LOSS",
	2: "MEAN_LOG_LOSS",
}
var Model_LossType_value = map[string]int32{
	"LOSS_TYPE_UNSPECIFIED": 0,
	"MEAN_SQUARED_LOSS":     1,
	"MEAN_LOG_LOSS":         2,
}

func (x Model_LossType) String() string {
	return proto.EnumName(Model_LossType_name, int32(x))
}
func (Model_LossType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{0, 1}
}

// Distance metric used to compute the distance between two points.
type Model_DistanceType int32

const (
	Model_DISTANCE_TYPE_UNSPECIFIED Model_DistanceType = 0
	// Eculidean distance.
	Model_EUCLIDEAN Model_DistanceType = 1
	// Cosine distance.
	Model_COSINE Model_DistanceType = 2
)

var Model_DistanceType_name = map[int32]string{
	0: "DISTANCE_TYPE_UNSPECIFIED",
	1: "EUCLIDEAN",
	2: "COSINE",
}
var Model_DistanceType_value = map[string]int32{
	"DISTANCE_TYPE_UNSPECIFIED": 0,
	"EUCLIDEAN":                 1,
	"COSINE":                    2,
}

func (x Model_DistanceType) String() string {
	return proto.EnumName(Model_DistanceType_name, int32(x))
}
func (Model_DistanceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{0, 2}
}

// Indicates the method to split input data into multiple tables.
type Model_DataSplitMethod int32

const (
	Model_DATA_SPLIT_METHOD_UNSPECIFIED Model_DataSplitMethod = 0
	// Splits data randomly.
	Model_RANDOM Model_DataSplitMethod = 1
	// Splits data with the user provided tags.
	Model_CUSTOM Model_DataSplitMethod = 2
	// Splits data sequentially.
	Model_SEQUENTIAL Model_DataSplitMethod = 3
	// Data split will be skipped.
	Model_NO_SPLIT Model_DataSplitMethod = 4
	// Splits data automatically: Uses NO_SPLIT if the data size is small.
	// Otherwise uses RANDOM.
	Model_AUTO_SPLIT Model_DataSplitMethod = 5
)

var Model_DataSplitMethod_name = map[int32]string{
	0: "DATA_SPLIT_METHOD_UNSPECIFIED",
	1: "RANDOM",
	2: "CUSTOM",
	3: "SEQUENTIAL",
	4: "NO_SPLIT",
	5: "AUTO_SPLIT",
}
var Model_DataSplitMethod_value = map[string]int32{
	"DATA_SPLIT_METHOD_UNSPECIFIED": 0,
	"RANDOM":                        1,
	"CUSTOM":                        2,
	"SEQUENTIAL":                    3,
	"NO_SPLIT":                      4,
	"AUTO_SPLIT":                    5,
}

func (x Model_DataSplitMethod) String() string {
	return proto.EnumName(Model_DataSplitMethod_name, int32(x))
}
func (Model_DataSplitMethod) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{0, 3}
}

// Indicates the learning rate optimization strategy to use.
type Model_LearnRateStrategy int32

const (
	Model_LEARN_RATE_STRATEGY_UNSPECIFIED Model_LearnRateStrategy = 0
	// Use line search to determine learning rate.
	Model_LINE_SEARCH Model_LearnRateStrategy = 1
	// Use a constant learning rate.
	Model_CONSTANT Model_LearnRateStrategy = 2
)

var Model_LearnRateStrategy_name = map[int32]string{
	0: "LEARN_RATE_STRATEGY_UNSPECIFIED",
	1: "LINE_SEARCH",
	2: "CONSTANT",
}
var Model_LearnRateStrategy_value = map[string]int32{
	"LEARN_RATE_STRATEGY_UNSPECIFIED": 0,
	"LINE_SEARCH":                     1,
	"CONSTANT":                        2,
}

func (x Model_LearnRateStrategy) String() string {
	return proto.EnumName(Model_LearnRateStrategy_name, int32(x))
}
func (Model_LearnRateStrategy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{0, 4}
}

type Model struct {
	// Output only. A hash of this resource.
	Etag string `protobuf:"bytes,1,opt,name=etag,proto3" json:"etag,omitempty"`
	// Required. Unique identifier for this model.
	ModelReference *ModelReference `protobuf:"bytes,2,opt,name=model_reference,json=modelReference,proto3" json:"model_reference,omitempty"`
	// Output only. The time when this model was created, in millisecs since the
	// epoch.
	CreationTime int64 `protobuf:"varint,5,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	// Output only. The time when this model was last modified, in millisecs
	// since the epoch.
	LastModifiedTime int64 `protobuf:"varint,6,opt,name=last_modified_time,json=lastModifiedTime,proto3" json:"last_modified_time,omitempty"`
	// [Optional] A user-friendly description of this model.
	// @mutable bigquery.models.patch
	Description string `protobuf:"bytes,12,opt,name=description,proto3" json:"description,omitempty"`
	// [Optional] A descriptive name for this model.
	// @mutable bigquery.models.patch
	FriendlyName string `protobuf:"bytes,14,opt,name=friendly_name,json=friendlyName,proto3" json:"friendly_name,omitempty"`
	// [Optional] The labels associated with this model. You can use these to
	// organize and group your models. Label keys and values can be no longer
	// than 63 characters, can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	// Label values are optional. Label keys must start with a letter and each
	// label in the list must have a different key.
	// @mutable bigquery.models.patch
	Labels map[string]string `protobuf:"bytes,15,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// [Optional] The time when this model expires, in milliseconds since the
	// epoch. If not present, the model will persist indefinitely. Expired models
	// will be deleted and their storage reclaimed.  The defaultTableExpirationMs
	// property of the encapsulating dataset can be used to set a default
	// expirationTime on newly created models.
	// @mutable bigquery.models.patch
	ExpirationTime int64 `protobuf:"varint,16,opt,name=expiration_time,json=expirationTime,proto3" json:"expiration_time,omitempty"`
	// Output only. The geographic location where the model resides. This value
	// is inherited from the dataset.
	Location string `protobuf:"bytes,13,opt,name=location,proto3" json:"location,omitempty"`
	// Output only. Type of the model resource.
	ModelType Model_ModelType `protobuf:"varint,7,opt,name=model_type,json=modelType,proto3,enum=google.cloud.bigquery.v2.Model_ModelType" json:"model_type,omitempty"`
	// Output only. Information for all training runs in increasing order of
	// start_time.
	TrainingRuns []*Model_TrainingRun `protobuf:"bytes,9,rep,name=training_runs,json=trainingRuns,proto3" json:"training_runs,omitempty"`
	// Output only. Input feature columns that were used to train this model.
	FeatureColumns []*StandardSqlField `protobuf:"bytes,10,rep,name=feature_columns,json=featureColumns,proto3" json:"feature_columns,omitempty"`
	// Output only. Label columns that were used to train this model.
	// The output of the model will have a “predicted_” prefix to these columns.
	LabelColumns         []*StandardSqlField `protobuf:"bytes,11,rep,name=label_columns,json=labelColumns,proto3" json:"label_columns,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Model) Reset()         { *m = Model{} }
func (m *Model) String() string { return proto.CompactTextString(m) }
func (*Model) ProtoMessage()    {}
func (*Model) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{0}
}
func (m *Model) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Model.Unmarshal(m, b)
}
func (m *Model) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Model.Marshal(b, m, deterministic)
}
func (dst *Model) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Model.Merge(dst, src)
}
func (m *Model) XXX_Size() int {
	return xxx_messageInfo_Model.Size(m)
}
func (m *Model) XXX_DiscardUnknown() {
	xxx_messageInfo_Model.DiscardUnknown(m)
}

var xxx_messageInfo_Model proto.InternalMessageInfo

func (m *Model) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

func (m *Model) GetModelReference() *ModelReference {
	if m != nil {
		return m.ModelReference
	}
	return nil
}

func (m *Model) GetCreationTime() int64 {
	if m != nil {
		return m.CreationTime
	}
	return 0
}

func (m *Model) GetLastModifiedTime() int64 {
	if m != nil {
		return m.LastModifiedTime
	}
	return 0
}

func (m *Model) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Model) GetFriendlyName() string {
	if m != nil {
		return m.FriendlyName
	}
	return ""
}

func (m *Model) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Model) GetExpirationTime() int64 {
	if m != nil {
		return m.ExpirationTime
	}
	return 0
}

func (m *Model) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *Model) GetModelType() Model_ModelType {
	if m != nil {
		return m.ModelType
	}
	return Model_MODEL_TYPE_UNSPECIFIED
}

func (m *Model) GetTrainingRuns() []*Model_TrainingRun {
	if m != nil {
		return m.TrainingRuns
	}
	return nil
}

func (m *Model) GetFeatureColumns() []*StandardSqlField {
	if m != nil {
		return m.FeatureColumns
	}
	return nil
}

func (m *Model) GetLabelColumns() []*StandardSqlField {
	if m != nil {
		return m.LabelColumns
	}
	return nil
}

// Evaluation metrics for regression models.
type Model_RegressionMetrics struct {
	// Mean absolute error.
	MeanAbsoluteError *wrappers.DoubleValue `protobuf:"bytes,1,opt,name=mean_absolute_error,json=meanAbsoluteError,proto3" json:"mean_absolute_error,omitempty"`
	// Mean squared error.
	MeanSquaredError *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=mean_squared_error,json=meanSquaredError,proto3" json:"mean_squared_error,omitempty"`
	// Mean squared log error.
	MeanSquaredLogError *wrappers.DoubleValue `protobuf:"bytes,3,opt,name=mean_squared_log_error,json=meanSquaredLogError,proto3" json:"mean_squared_log_error,omitempty"`
	// Median absolute error.
	MedianAbsoluteError *wrappers.DoubleValue `protobuf:"bytes,4,opt,name=median_absolute_error,json=medianAbsoluteError,proto3" json:"median_absolute_error,omitempty"`
	// R^2 score.
	RSquared             *wrappers.DoubleValue `protobuf:"bytes,5,opt,name=r_squared,json=rSquared,proto3" json:"r_squared,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Model_RegressionMetrics) Reset()         { *m = Model_RegressionMetrics{} }
func (m *Model_RegressionMetrics) String() string { return proto.CompactTextString(m) }
func (*Model_RegressionMetrics) ProtoMessage()    {}
func (*Model_RegressionMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{0, 0}
}
func (m *Model_RegressionMetrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Model_RegressionMetrics.Unmarshal(m, b)
}
func (m *Model_RegressionMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Model_RegressionMetrics.Marshal(b, m, deterministic)
}
func (dst *Model_RegressionMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Model_RegressionMetrics.Merge(dst, src)
}
func (m *Model_RegressionMetrics) XXX_Size() int {
	return xxx_messageInfo_Model_RegressionMetrics.Size(m)
}
func (m *Model_RegressionMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_Model_RegressionMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_Model_RegressionMetrics proto.InternalMessageInfo

func (m *Model_RegressionMetrics) GetMeanAbsoluteError() *wrappers.DoubleValue {
	if m != nil {
		return m.MeanAbsoluteError
	}
	return nil
}

func (m *Model_RegressionMetrics) GetMeanSquaredError() *wrappers.DoubleValue {
	if m != nil {
		return m.MeanSquaredError
	}
	return nil
}

func (m *Model_RegressionMetrics) GetMeanSquaredLogError() *wrappers.DoubleValue {
	if m != nil {
		return m.MeanSquaredLogError
	}
	return nil
}

func (m *Model_RegressionMetrics) GetMedianAbsoluteError() *wrappers.DoubleValue {
	if m != nil {
		return m.MedianAbsoluteError
	}
	return nil
}

func (m *Model_RegressionMetrics) GetRSquared() *wrappers.DoubleValue {
	if m != nil {
		return m.RSquared
	}
	return nil
}

// Aggregate metrics for classification models. For multi-class models,
// the metrics are either macro-averaged: metrics are calculated for each
// label and then an unweighted average is taken of those values or
// micro-averaged: the metric is calculated globally by counting the total
// number of correctly predicted rows.
type Model_AggregateClassificationMetrics struct {
	// Precision is the fraction of actual positive predictions that had
	// positive actual labels. For multiclass this is a macro-averaged
	// metric treating each class as a binary classifier.
	Precision *wrappers.DoubleValue `protobuf:"bytes,1,opt,name=precision,proto3" json:"precision,omitempty"`
	// Recall is the fraction of actual positive labels that were given a
	// positive prediction. For multiclass this is a macro-averaged metric.
	Recall *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=recall,proto3" json:"recall,omitempty"`
	// Accuracy is the fraction of predictions given the correct label. For
	// multiclass this is a micro-averaged metric.
	Accuracy *wrappers.DoubleValue `protobuf:"bytes,3,opt,name=accuracy,proto3" json:"accuracy,omitempty"`
	// Threshold at which the metrics are computed. For binary
	// classification models this is the positive class threshold.
	// For multi-class classfication models this is the confidence
	// threshold.
	Threshold *wrappers.DoubleValue `protobuf:"bytes,4,opt,name=threshold,proto3" json:"threshold,omitempty"`
	// The F1 score is an average of recall and precision. For multiclass
	// this is a macro-averaged metric.
	F1Score *wrappers.DoubleValue `protobuf:"bytes,5,opt,name=f1_score,json=f1Score,proto3" json:"f1_score,omitempty"`
	// Logarithmic Loss. For multiclass this is a macro-averaged metric.
	LogLoss *wrappers.DoubleValue `protobuf:"bytes,6,opt,name=log_loss,json=logLoss,proto3" json:"log_loss,omitempty"`
	// Area Under a ROC Curve. For multiclass this is a macro-averaged
	// metric.
	RocAuc               *wrappers.DoubleValue `protobuf:"bytes,7,opt,name=roc_auc,json=rocAuc,proto3" json:"roc_auc,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Model_AggregateClassificationMetrics) Reset()         { *m = Model_AggregateClassificationMetrics{} }
func (m *Model_AggregateClassificationMetrics) String() string { return proto.CompactTextString(m) }
func (*Model_AggregateClassificationMetrics) ProtoMessage()    {}
func (*Model_AggregateClassificationMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{0, 1}
}
func (m *Model_AggregateClassificationMetrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Model_AggregateClassificationMetrics.Unmarshal(m, b)
}
func (m *Model_AggregateClassificationMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Model_AggregateClassificationMetrics.Marshal(b, m, deterministic)
}
func (dst *Model_AggregateClassificationMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Model_AggregateClassificationMetrics.Merge(dst, src)
}
func (m *Model_AggregateClassificationMetrics) XXX_Size() int {
	return xxx_messageInfo_Model_AggregateClassificationMetrics.Size(m)
}
func (m *Model_AggregateClassificationMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_Model_AggregateClassificationMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_Model_AggregateClassificationMetrics proto.InternalMessageInfo

func (m *Model_AggregateClassificationMetrics) GetPrecision() *wrappers.DoubleValue {
	if m != nil {
		return m.Precision
	}
	return nil
}

func (m *Model_AggregateClassificationMetrics) GetRecall() *wrappers.DoubleValue {
	if m != nil {
		return m.Recall
	}
	return nil
}

func (m *Model_AggregateClassificationMetrics) GetAccuracy() *wrappers.DoubleValue {
	if m != nil {
		return m.Accuracy
	}
	return nil
}

func (m *Model_AggregateClassificationMetrics) GetThreshold() *wrappers.DoubleValue {
	if m != nil {
		return m.Threshold
	}
	return nil
}

func (m *Model_AggregateClassificationMetrics) GetF1Score() *wrappers.DoubleValue {
	if m != nil {
		return m.F1Score
	}
	return nil
}

func (m *Model_AggregateClassificationMetrics) GetLogLoss() *wrappers.DoubleValue {
	if m != nil {
		return m.LogLoss
	}
	return nil
}

func (m *Model_AggregateClassificationMetrics) GetRocAuc() *wrappers.DoubleValue {
	if m != nil {
		return m.RocAuc
	}
	return nil
}

// Evaluation metrics for binary classification models.
type Model_BinaryClassificationMetrics struct {
	// Aggregate classification metrics.
	AggregateClassificationMetrics *Model_AggregateClassificationMetrics `protobuf:"bytes,1,opt,name=aggregate_classification_metrics,json=aggregateClassificationMetrics,proto3" json:"aggregate_classification_metrics,omitempty"`
	// Binary confusion matrix at multiple thresholds.
	BinaryConfusionMatrixList []*Model_BinaryClassificationMetrics_BinaryConfusionMatrix `protobuf:"bytes,2,rep,name=binary_confusion_matrix_list,json=binaryConfusionMatrixList,proto3" json:"binary_confusion_matrix_list,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}                                                   `json:"-"`
	XXX_unrecognized          []byte                                                     `json:"-"`
	XXX_sizecache             int32                                                      `json:"-"`
}

func (m *Model_BinaryClassificationMetrics) Reset()         { *m = Model_BinaryClassificationMetrics{} }
func (m *Model_BinaryClassificationMetrics) String() string { return proto.CompactTextString(m) }
func (*Model_BinaryClassificationMetrics) ProtoMessage()    {}
func (*Model_BinaryClassificationMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{0, 2}
}
func (m *Model_BinaryClassificationMetrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Model_BinaryClassificationMetrics.Unmarshal(m, b)
}
func (m *Model_BinaryClassificationMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Model_BinaryClassificationMetrics.Marshal(b, m, deterministic)
}
func (dst *Model_BinaryClassificationMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Model_BinaryClassificationMetrics.Merge(dst, src)
}
func (m *Model_BinaryClassificationMetrics) XXX_Size() int {
	return xxx_messageInfo_Model_BinaryClassificationMetrics.Size(m)
}
func (m *Model_BinaryClassificationMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_Model_BinaryClassificationMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_Model_BinaryClassificationMetrics proto.InternalMessageInfo

func (m *Model_BinaryClassificationMetrics) GetAggregateClassificationMetrics() *Model_AggregateClassificationMetrics {
	if m != nil {
		return m.AggregateClassificationMetrics
	}
	return nil
}

func (m *Model_BinaryClassificationMetrics) GetBinaryConfusionMatrixList() []*Model_BinaryClassificationMetrics_BinaryConfusionMatrix {
	if m != nil {
		return m.BinaryConfusionMatrixList
	}
	return nil
}

// Confusion matrix for binary classification models.
type Model_BinaryClassificationMetrics_BinaryConfusionMatrix struct {
	// Threshold value used when computing each of the following metric.
	PositiveClassThreshold *wrappers.DoubleValue `protobuf:"bytes,1,opt,name=positive_class_threshold,json=positiveClassThreshold,proto3" json:"positive_class_threshold,omitempty"`
	// Number of true samples predicted as true.
	TruePositives *wrappers.Int64Value `protobuf:"bytes,2,opt,name=true_positives,json=truePositives,proto3" json:"true_positives,omitempty"`
	// Number of false samples predicted as true.
	FalsePositives *wrappers.Int64Value `protobuf:"bytes,3,opt,name=false_positives,json=falsePositives,proto3" json:"false_positives,omitempty"`
	// Number of true samples predicted as false.
	TrueNegatives *wrappers.Int64Value `protobuf:"bytes,4,opt,name=true_negatives,json=trueNegatives,proto3" json:"true_negatives,omitempty"`
	// Number of false samples predicted as false.
	FalseNegatives *wrappers.Int64Value `protobuf:"bytes,5,opt,name=false_negatives,json=falseNegatives,proto3" json:"false_negatives,omitempty"`
	// Aggregate precision.
	Precision *wrappers.DoubleValue `protobuf:"bytes,6,opt,name=precision,proto3" json:"precision,omitempty"`
	// Aggregate recall.
	Recall               *wrappers.DoubleValue `protobuf:"bytes,7,opt,name=recall,proto3" json:"recall,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) Reset() {
	*m = Model_BinaryClassificationMetrics_BinaryConfusionMatrix{}
}
func (m *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) String() string {
	return proto.CompactTextString(m)
}
func (*Model_BinaryClassificationMetrics_BinaryConfusionMatrix) ProtoMessage() {}
func (*Model_BinaryClassificationMetrics_BinaryConfusionMatrix) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{0, 2, 0}
}
func (m *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Model_BinaryClassificationMetrics_BinaryConfusionMatrix.Unmarshal(m, b)
}
func (m *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Model_BinaryClassificationMetrics_BinaryConfusionMatrix.Marshal(b, m, deterministic)
}
func (dst *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Model_BinaryClassificationMetrics_BinaryConfusionMatrix.Merge(dst, src)
}
func (m *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) XXX_Size() int {
	return xxx_messageInfo_Model_BinaryClassificationMetrics_BinaryConfusionMatrix.Size(m)
}
func (m *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) XXX_DiscardUnknown() {
	xxx_messageInfo_Model_BinaryClassificationMetrics_BinaryConfusionMatrix.DiscardUnknown(m)
}

var xxx_messageInfo_Model_BinaryClassificationMetrics_BinaryConfusionMatrix proto.InternalMessageInfo

func (m *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetPositiveClassThreshold() *wrappers.DoubleValue {
	if m != nil {
		return m.PositiveClassThreshold
	}
	return nil
}

func (m *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetTruePositives() *wrappers.Int64Value {
	if m != nil {
		return m.TruePositives
	}
	return nil
}

func (m *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetFalsePositives() *wrappers.Int64Value {
	if m != nil {
		return m.FalsePositives
	}
	return nil
}

func (m *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetTrueNegatives() *wrappers.Int64Value {
	if m != nil {
		return m.TrueNegatives
	}
	return nil
}

func (m *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetFalseNegatives() *wrappers.Int64Value {
	if m != nil {
		return m.FalseNegatives
	}
	return nil
}

func (m *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetPrecision() *wrappers.DoubleValue {
	if m != nil {
		return m.Precision
	}
	return nil
}

func (m *Model_BinaryClassificationMetrics_BinaryConfusionMatrix) GetRecall() *wrappers.DoubleValue {
	if m != nil {
		return m.Recall
	}
	return nil
}

// Evaluation metrics for multi-class classification models.
type Model_MultiClassClassificationMetrics struct {
	// Aggregate classification metrics.
	AggregateClassificationMetrics *Model_AggregateClassificationMetrics `protobuf:"bytes,1,opt,name=aggregate_classification_metrics,json=aggregateClassificationMetrics,proto3" json:"aggregate_classification_metrics,omitempty"`
	// Confusion matrix at different thresholds.
	ConfusionMatrixList  []*Model_MultiClassClassificationMetrics_ConfusionMatrix `protobuf:"bytes,2,rep,name=confusion_matrix_list,json=confusionMatrixList,proto3" json:"confusion_matrix_list,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                 `json:"-"`
	XXX_unrecognized     []byte                                                   `json:"-"`
	XXX_sizecache        int32                                                    `json:"-"`
}

func (m *Model_MultiClassClassificationMetrics) Reset()         { *m = Model_MultiClassClassificationMetrics{} }
func (m *Model_MultiClassClassificationMetrics) String() string { return proto.CompactTextString(m) }
func (*Model_MultiClassClassificationMetrics) ProtoMessage()    {}
func (*Model_MultiClassClassificationMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{0, 3}
}
func (m *Model_MultiClassClassificationMetrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Model_MultiClassClassificationMetrics.Unmarshal(m, b)
}
func (m *Model_MultiClassClassificationMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Model_MultiClassClassificationMetrics.Marshal(b, m, deterministic)
}
func (dst *Model_MultiClassClassificationMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Model_MultiClassClassificationMetrics.Merge(dst, src)
}
func (m *Model_MultiClassClassificationMetrics) XXX_Size() int {
	return xxx_messageInfo_Model_MultiClassClassificationMetrics.Size(m)
}
func (m *Model_MultiClassClassificationMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_Model_MultiClassClassificationMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_Model_MultiClassClassificationMetrics proto.InternalMessageInfo

func (m *Model_MultiClassClassificationMetrics) GetAggregateClassificationMetrics() *Model_AggregateClassificationMetrics {
	if m != nil {
		return m.AggregateClassificationMetrics
	}
	return nil
}

func (m *Model_MultiClassClassificationMetrics) GetConfusionMatrixList() []*Model_MultiClassClassificationMetrics_ConfusionMatrix {
	if m != nil {
		return m.ConfusionMatrixList
	}
	return nil
}

// Confusion matrix for multi-class classification models.
type Model_MultiClassClassificationMetrics_ConfusionMatrix struct {
	// Confidence threshold used when computing the entries of the
	// confusion matrix.
	ConfidenceThreshold *wrappers.DoubleValue `protobuf:"bytes,1,opt,name=confidence_threshold,json=confidenceThreshold,proto3" json:"confidence_threshold,omitempty"`
	// One row per actual label.
	Rows                 []*Model_MultiClassClassificationMetrics_ConfusionMatrix_Row `protobuf:"bytes,2,rep,name=rows,proto3" json:"rows,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                     `json:"-"`
	XXX_unrecognized     []byte                                                       `json:"-"`
	XXX_sizecache        int32                                                        `json:"-"`
}

func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix) Reset() {
	*m = Model_MultiClassClassificationMetrics_ConfusionMatrix{}
}
func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix) String() string {
	return proto.CompactTextString(m)
}
func (*Model_MultiClassClassificationMetrics_ConfusionMatrix) ProtoMessage() {}
func (*Model_MultiClassClassificationMetrics_ConfusionMatrix) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{0, 3, 0}
}
func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Model_MultiClassClassificationMetrics_ConfusionMatrix.Unmarshal(m, b)
}
func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Model_MultiClassClassificationMetrics_ConfusionMatrix.Marshal(b, m, deterministic)
}
func (dst *Model_MultiClassClassificationMetrics_ConfusionMatrix) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Model_MultiClassClassificationMetrics_ConfusionMatrix.Merge(dst, src)
}
func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix) XXX_Size() int {
	return xxx_messageInfo_Model_MultiClassClassificationMetrics_ConfusionMatrix.Size(m)
}
func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix) XXX_DiscardUnknown() {
	xxx_messageInfo_Model_MultiClassClassificationMetrics_ConfusionMatrix.DiscardUnknown(m)
}

var xxx_messageInfo_Model_MultiClassClassificationMetrics_ConfusionMatrix proto.InternalMessageInfo

func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix) GetConfidenceThreshold() *wrappers.DoubleValue {
	if m != nil {
		return m.ConfidenceThreshold
	}
	return nil
}

func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix) GetRows() []*Model_MultiClassClassificationMetrics_ConfusionMatrix_Row {
	if m != nil {
		return m.Rows
	}
	return nil
}

// A single entry in the confusion matrix.
type Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry struct {
	// The predicted label. For confidence_threshold > 0, we will
	// also add an entry indicating the number of items under the
	// confidence threshold.
	PredictedLabel string `protobuf:"bytes,1,opt,name=predicted_label,json=predictedLabel,proto3" json:"predicted_label,omitempty"`
	// Number of items being predicted as this label.
	ItemCount            *wrappers.Int64Value `protobuf:"bytes,2,opt,name=item_count,json=itemCount,proto3" json:"item_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) Reset() {
	*m = Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry{}
}
func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) String() string {
	return proto.CompactTextString(m)
}
func (*Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) ProtoMessage() {}
func (*Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{0, 3, 0, 0}
}
func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry.Unmarshal(m, b)
}
func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry.Marshal(b, m, deterministic)
}
func (dst *Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry.Merge(dst, src)
}
func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) XXX_Size() int {
	return xxx_messageInfo_Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry.Size(m)
}
func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) XXX_DiscardUnknown() {
	xxx_messageInfo_Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry.DiscardUnknown(m)
}

var xxx_messageInfo_Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry proto.InternalMessageInfo

func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) GetPredictedLabel() string {
	if m != nil {
		return m.PredictedLabel
	}
	return ""
}

func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry) GetItemCount() *wrappers.Int64Value {
	if m != nil {
		return m.ItemCount
	}
	return nil
}

// A single row in the confusion matrix.
type Model_MultiClassClassificationMetrics_ConfusionMatrix_Row struct {
	// The original label of this row.
	ActualLabel string `protobuf:"bytes,1,opt,name=actual_label,json=actualLabel,proto3" json:"actual_label,omitempty"`
	// Info describing predicted label distribution.
	Entries              []*Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry `protobuf:"bytes,2,rep,name=entries,proto3" json:"entries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                       `json:"-"`
	XXX_unrecognized     []byte                                                         `json:"-"`
	XXX_sizecache        int32                                                          `json:"-"`
}

func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) Reset() {
	*m = Model_MultiClassClassificationMetrics_ConfusionMatrix_Row{}
}
func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) String() string {
	return proto.CompactTextString(m)
}
func (*Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) ProtoMessage() {}
func (*Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{0, 3, 0, 1}
}
func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Model_MultiClassClassificationMetrics_ConfusionMatrix_Row.Unmarshal(m, b)
}
func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Model_MultiClassClassificationMetrics_ConfusionMatrix_Row.Marshal(b, m, deterministic)
}
func (dst *Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Model_MultiClassClassificationMetrics_ConfusionMatrix_Row.Merge(dst, src)
}
func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) XXX_Size() int {
	return xxx_messageInfo_Model_MultiClassClassificationMetrics_ConfusionMatrix_Row.Size(m)
}
func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) XXX_DiscardUnknown() {
	xxx_messageInfo_Model_MultiClassClassificationMetrics_ConfusionMatrix_Row.DiscardUnknown(m)
}

var xxx_messageInfo_Model_MultiClassClassificationMetrics_ConfusionMatrix_Row proto.InternalMessageInfo

func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) GetActualLabel() string {
	if m != nil {
		return m.ActualLabel
	}
	return ""
}

func (m *Model_MultiClassClassificationMetrics_ConfusionMatrix_Row) GetEntries() []*Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry {
	if m != nil {
		return m.Entries
	}
	return nil
}

// Evaluation metrics for clustering models.
type Model_ClusteringMetrics struct {
	// Davies-Bouldin index.
	DaviesBouldinIndex *wrappers.DoubleValue `protobuf:"bytes,1,opt,name=davies_bouldin_index,json=daviesBouldinIndex,proto3" json:"davies_bouldin_index,omitempty"`
	// Mean of squared distances between each sample to its cluster centroid.
	MeanSquaredDistance  *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=mean_squared_distance,json=meanSquaredDistance,proto3" json:"mean_squared_distance,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Model_ClusteringMetrics) Reset()         { *m = Model_ClusteringMetrics{} }
func (m *Model_ClusteringMetrics) String() string { return proto.CompactTextString(m) }
func (*Model_ClusteringMetrics) ProtoMessage()    {}
func (*Model_ClusteringMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{0, 4}
}
func (m *Model_ClusteringMetrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Model_ClusteringMetrics.Unmarshal(m, b)
}
func (m *Model_ClusteringMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Model_ClusteringMetrics.Marshal(b, m, deterministic)
}
func (dst *Model_ClusteringMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Model_ClusteringMetrics.Merge(dst, src)
}
func (m *Model_ClusteringMetrics) XXX_Size() int {
	return xxx_messageInfo_Model_ClusteringMetrics.Size(m)
}
func (m *Model_ClusteringMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_Model_ClusteringMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_Model_ClusteringMetrics proto.InternalMessageInfo

func (m *Model_ClusteringMetrics) GetDaviesBouldinIndex() *wrappers.DoubleValue {
	if m != nil {
		return m.DaviesBouldinIndex
	}
	return nil
}

func (m *Model_ClusteringMetrics) GetMeanSquaredDistance() *wrappers.DoubleValue {
	if m != nil {
		return m.MeanSquaredDistance
	}
	return nil
}

// Evaluation metrics of a model. These are either computed on all
// training data or just the eval data based on whether eval data was used
// during training.
type Model_EvaluationMetrics struct {
	// Types that are valid to be assigned to Metrics:
	//	*Model_EvaluationMetrics_RegressionMetrics
	//	*Model_EvaluationMetrics_BinaryClassificationMetrics
	//	*Model_EvaluationMetrics_MultiClassClassificationMetrics
	//	*Model_EvaluationMetrics_ClusteringMetrics
	Metrics              isModel_EvaluationMetrics_Metrics `protobuf_oneof:"metrics"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *Model_EvaluationMetrics) Reset()         { *m = Model_EvaluationMetrics{} }
func (m *Model_EvaluationMetrics) String() string { return proto.CompactTextString(m) }
func (*Model_EvaluationMetrics) ProtoMessage()    {}
func (*Model_EvaluationMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{0, 5}
}
func (m *Model_EvaluationMetrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Model_EvaluationMetrics.Unmarshal(m, b)
}
func (m *Model_EvaluationMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Model_EvaluationMetrics.Marshal(b, m, deterministic)
}
func (dst *Model_EvaluationMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Model_EvaluationMetrics.Merge(dst, src)
}
func (m *Model_EvaluationMetrics) XXX_Size() int {
	return xxx_messageInfo_Model_EvaluationMetrics.Size(m)
}
func (m *Model_EvaluationMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_Model_EvaluationMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_Model_EvaluationMetrics proto.InternalMessageInfo

type isModel_EvaluationMetrics_Metrics interface {
	isModel_EvaluationMetrics_Metrics()
}

type Model_EvaluationMetrics_RegressionMetrics struct {
	RegressionMetrics *Model_RegressionMetrics `protobuf:"bytes,1,opt,name=regression_metrics,json=regressionMetrics,proto3,oneof"`
}

type Model_EvaluationMetrics_BinaryClassificationMetrics struct {
	BinaryClassificationMetrics *Model_BinaryClassificationMetrics `protobuf:"bytes,2,opt,name=binary_classification_metrics,json=binaryClassificationMetrics,proto3,oneof"`
}

type Model_EvaluationMetrics_MultiClassClassificationMetrics struct {
	MultiClassClassificationMetrics *Model_MultiClassClassificationMetrics `protobuf:"bytes,3,opt,name=multi_class_classification_metrics,json=multiClassClassificationMetrics,proto3,oneof"`
}

type Model_EvaluationMetrics_ClusteringMetrics struct {
	ClusteringMetrics *Model_ClusteringMetrics `protobuf:"bytes,4,opt,name=clustering_metrics,json=clusteringMetrics,proto3,oneof"`
}

func (*Model_EvaluationMetrics_RegressionMetrics) isModel_EvaluationMetrics_Metrics() {}

func (*Model_EvaluationMetrics_BinaryClassificationMetrics) isModel_EvaluationMetrics_Metrics() {}

func (*Model_EvaluationMetrics_MultiClassClassificationMetrics) isModel_EvaluationMetrics_Metrics() {}

func (*Model_EvaluationMetrics_ClusteringMetrics) isModel_EvaluationMetrics_Metrics() {}

func (m *Model_EvaluationMetrics) GetMetrics() isModel_EvaluationMetrics_Metrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *Model_EvaluationMetrics) GetRegressionMetrics() *Model_RegressionMetrics {
	if x, ok := m.GetMetrics().(*Model_EvaluationMetrics_RegressionMetrics); ok {
		return x.RegressionMetrics
	}
	return nil
}

func (m *Model_EvaluationMetrics) GetBinaryClassificationMetrics() *Model_BinaryClassificationMetrics {
	if x, ok := m.GetMetrics().(*Model_EvaluationMetrics_BinaryClassificationMetrics); ok {
		return x.BinaryClassificationMetrics
	}
	return nil
}

func (m *Model_EvaluationMetrics) GetMultiClassClassificationMetrics() *Model_MultiClassClassificationMetrics {
	if x, ok := m.GetMetrics().(*Model_EvaluationMetrics_MultiClassClassificationMetrics); ok {
		return x.MultiClassClassificationMetrics
	}
	return nil
}

func (m *Model_EvaluationMetrics) GetClusteringMetrics() *Model_ClusteringMetrics {
	if x, ok := m.GetMetrics().(*Model_EvaluationMetrics_ClusteringMetrics); ok {
		return x.ClusteringMetrics
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Model_EvaluationMetrics) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Model_EvaluationMetrics_OneofMarshaler, _Model_EvaluationMetrics_OneofUnmarshaler, _Model_EvaluationMetrics_OneofSizer, []interface{}{
		(*Model_EvaluationMetrics_RegressionMetrics)(nil),
		(*Model_EvaluationMetrics_BinaryClassificationMetrics)(nil),
		(*Model_EvaluationMetrics_MultiClassClassificationMetrics)(nil),
		(*Model_EvaluationMetrics_ClusteringMetrics)(nil),
	}
}

func _Model_EvaluationMetrics_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Model_EvaluationMetrics)
	// metrics
	switch x := m.Metrics.(type) {
	case *Model_EvaluationMetrics_RegressionMetrics:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RegressionMetrics); err != nil {
			return err
		}
	case *Model_EvaluationMetrics_BinaryClassificationMetrics:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BinaryClassificationMetrics); err != nil {
			return err
		}
	case *Model_EvaluationMetrics_MultiClassClassificationMetrics:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MultiClassClassificationMetrics); err != nil {
			return err
		}
	case *Model_EvaluationMetrics_ClusteringMetrics:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ClusteringMetrics); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Model_EvaluationMetrics.Metrics has unexpected type %T", x)
	}
	return nil
}

func _Model_EvaluationMetrics_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Model_EvaluationMetrics)
	switch tag {
	case 1: // metrics.regression_metrics
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Model_RegressionMetrics)
		err := b.DecodeMessage(msg)
		m.Metrics = &Model_EvaluationMetrics_RegressionMetrics{msg}
		return true, err
	case 2: // metrics.binary_classification_metrics
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Model_BinaryClassificationMetrics)
		err := b.DecodeMessage(msg)
		m.Metrics = &Model_EvaluationMetrics_BinaryClassificationMetrics{msg}
		return true, err
	case 3: // metrics.multi_class_classification_metrics
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Model_MultiClassClassificationMetrics)
		err := b.DecodeMessage(msg)
		m.Metrics = &Model_EvaluationMetrics_MultiClassClassificationMetrics{msg}
		return true, err
	case 4: // metrics.clustering_metrics
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Model_ClusteringMetrics)
		err := b.DecodeMessage(msg)
		m.Metrics = &Model_EvaluationMetrics_ClusteringMetrics{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Model_EvaluationMetrics_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Model_EvaluationMetrics)
	// metrics
	switch x := m.Metrics.(type) {
	case *Model_EvaluationMetrics_RegressionMetrics:
		s := proto.Size(x.RegressionMetrics)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Model_EvaluationMetrics_BinaryClassificationMetrics:
		s := proto.Size(x.BinaryClassificationMetrics)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Model_EvaluationMetrics_MultiClassClassificationMetrics:
		s := proto.Size(x.MultiClassClassificationMetrics)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Model_EvaluationMetrics_ClusteringMetrics:
		s := proto.Size(x.ClusteringMetrics)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Information about a single training query run for the model.
type Model_TrainingRun struct {
	// Options that were used for this training run, includes
	// user specified and default options that were used.
	TrainingOptions *Model_TrainingRun_TrainingOptions `protobuf:"bytes,1,opt,name=training_options,json=trainingOptions,proto3" json:"training_options,omitempty"`
	// The start time of this training run.
	StartTime *timestamp.Timestamp `protobuf:"bytes,8,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output of each iteration run, results.size() <= max_iterations.
	Results []*Model_TrainingRun_IterationResult `protobuf:"bytes,6,rep,name=results,proto3" json:"results,omitempty"`
	// The evaluation metrics over training/eval data that were computed at the
	// end of training.
	EvaluationMetrics    *Model_EvaluationMetrics `protobuf:"bytes,7,opt,name=evaluation_metrics,json=evaluationMetrics,proto3" json:"evaluation_metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Model_TrainingRun) Reset()         { *m = Model_TrainingRun{} }
func (m *Model_TrainingRun) String() string { return proto.CompactTextString(m) }
func (*Model_TrainingRun) ProtoMessage()    {}
func (*Model_TrainingRun) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{0, 6}
}
func (m *Model_TrainingRun) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Model_TrainingRun.Unmarshal(m, b)
}
func (m *Model_TrainingRun) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Model_TrainingRun.Marshal(b, m, deterministic)
}
func (dst *Model_TrainingRun) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Model_TrainingRun.Merge(dst, src)
}
func (m *Model_TrainingRun) XXX_Size() int {
	return xxx_messageInfo_Model_TrainingRun.Size(m)
}
func (m *Model_TrainingRun) XXX_DiscardUnknown() {
	xxx_messageInfo_Model_TrainingRun.DiscardUnknown(m)
}

var xxx_messageInfo_Model_TrainingRun proto.InternalMessageInfo

func (m *Model_TrainingRun) GetTrainingOptions() *Model_TrainingRun_TrainingOptions {
	if m != nil {
		return m.TrainingOptions
	}
	return nil
}

func (m *Model_TrainingRun) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *Model_TrainingRun) GetResults() []*Model_TrainingRun_IterationResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *Model_TrainingRun) GetEvaluationMetrics() *Model_EvaluationMetrics {
	if m != nil {
		return m.EvaluationMetrics
	}
	return nil
}

type Model_TrainingRun_TrainingOptions struct {
	// The maximum number of iterations in training.
	MaxIterations int64 `protobuf:"varint,1,opt,name=max_iterations,json=maxIterations,proto3" json:"max_iterations,omitempty"`
	// Type of loss function used during training run.
	LossType Model_LossType `protobuf:"varint,2,opt,name=loss_type,json=lossType,proto3,enum=google.cloud.bigquery.v2.Model_LossType" json:"loss_type,omitempty"`
	// Learning rate in training.
	LearnRate float64 `protobuf:"fixed64,3,opt,name=learn_rate,json=learnRate,proto3" json:"learn_rate,omitempty"`
	// L1 regularization coefficient.
	L1Regularization *wrappers.DoubleValue `protobuf:"bytes,4,opt,name=l1_regularization,json=l1Regularization,proto3" json:"l1_regularization,omitempty"`
	// L2 regularization coefficient.
	L2Regularization *wrappers.DoubleValue `protobuf:"bytes,5,opt,name=l2_regularization,json=l2Regularization,proto3" json:"l2_regularization,omitempty"`
	// When early_stop is true, stops training when accuracy improvement is
	// less than 'min_relative_progress'.
	MinRelativeProgress *wrappers.DoubleValue `protobuf:"bytes,6,opt,name=min_relative_progress,json=minRelativeProgress,proto3" json:"min_relative_progress,omitempty"`
	// Whether to train a model from the last checkpoint.
	WarmStart *wrappers.BoolValue `protobuf:"bytes,7,opt,name=warm_start,json=warmStart,proto3" json:"warm_start,omitempty"`
	// Whether to stop early when the loss doesn't improve significantly
	// any more (compared to min_relative_progress).
	EarlyStop *wrappers.BoolValue `protobuf:"bytes,8,opt,name=early_stop,json=earlyStop,proto3" json:"early_stop,omitempty"`
	// Name of input label columns in training data.
	InputLabelColumns []string `protobuf:"bytes,9,rep,name=input_label_columns,json=inputLabelColumns,proto3" json:"input_label_columns,omitempty"`
	// The data split type for training and evaluation, e.g. RANDOM.
	DataSplitMethod Model_DataSplitMethod `protobuf:"varint,10,opt,name=data_split_method,json=dataSplitMethod,proto3,enum=google.cloud.bigquery.v2.Model_DataSplitMethod" json:"data_split_method,omitempty"`
	// The fraction of evaluation data over the whole input data. The rest
	// of data will be used as training data. The format should be double.
	// Accurate to two decimal places.
	// Default value is 0.2.
	DataSplitEvalFraction float64 `protobuf:"fixed64,11,opt,name=data_split_eval_fraction,json=dataSplitEvalFraction,proto3" json:"data_split_eval_fraction,omitempty"`
	// The column to split data with. This column won't be used as a
	// feature.
	// 1. When data_split_method is CUSTOM, the corresponding column should
	// be boolean. The rows with true value tag are eval data, and the false
	// are training data.
	// 2. When data_split_method is SEQ, the first DATA_SPLIT_EVAL_FRACTION
	// rows (from smallest to largest) in the corresponding column are used
	// as training data, and the rest are eval data. It respects the order
	// in Orderable data types:
	// https://cloud.google.com/bigquery/docs/reference/standard-sql/data-types#data-type-properties
	DataSplitColumn string `protobuf:"bytes,12,opt,name=data_split_column,json=dataSplitColumn,proto3" json:"data_split_column,omitempty"`
	// The strategy to determine learning rate.
	LearnRateStrategy Model_LearnRateStrategy `protobuf:"varint,13,opt,name=learn_rate_strategy,json=learnRateStrategy,proto3,enum=google.cloud.bigquery.v2.Model_LearnRateStrategy" json:"learn_rate_strategy,omitempty"`
	// Specifies the initial learning rate for line search to start at.
	InitialLearnRate float64 `protobuf:"fixed64,16,opt,name=initial_learn_rate,json=initialLearnRate,proto3" json:"initial_learn_rate,omitempty"`
	// Weights associated with each label class, for rebalancing the
	// training data.
	LabelClassWeights map[string]float64 `protobuf:"bytes,17,rep,name=label_class_weights,json=labelClassWeights,proto3" json:"label_class_weights,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"fixed64,2,opt,name=value,proto3"`
	// [Beta] Distance type for clustering models.
	DistanceType Model_DistanceType `protobuf:"varint,20,opt,name=distance_type,json=distanceType,proto3,enum=google.cloud.bigquery.v2.Model_DistanceType" json:"distance_type,omitempty"`
	// [Beta] Number of clusters for clustering models.
	NumClusters          int64    `protobuf:"varint,21,opt,name=num_clusters,json=numClusters,proto3" json:"num_clusters,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Model_TrainingRun_TrainingOptions) Reset()         { *m = Model_TrainingRun_TrainingOptions{} }
func (m *Model_TrainingRun_TrainingOptions) String() string { return proto.CompactTextString(m) }
func (*Model_TrainingRun_TrainingOptions) ProtoMessage()    {}
func (*Model_TrainingRun_TrainingOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{0, 6, 0}
}
func (m *Model_TrainingRun_TrainingOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Model_TrainingRun_TrainingOptions.Unmarshal(m, b)
}
func (m *Model_TrainingRun_TrainingOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Model_TrainingRun_TrainingOptions.Marshal(b, m, deterministic)
}
func (dst *Model_TrainingRun_TrainingOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Model_TrainingRun_TrainingOptions.Merge(dst, src)
}
func (m *Model_TrainingRun_TrainingOptions) XXX_Size() int {
	return xxx_messageInfo_Model_TrainingRun_TrainingOptions.Size(m)
}
func (m *Model_TrainingRun_TrainingOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_Model_TrainingRun_TrainingOptions.DiscardUnknown(m)
}

var xxx_messageInfo_Model_TrainingRun_TrainingOptions proto.InternalMessageInfo

func (m *Model_TrainingRun_TrainingOptions) GetMaxIterations() int64 {
	if m != nil {
		return m.MaxIterations
	}
	return 0
}

func (m *Model_TrainingRun_TrainingOptions) GetLossType() Model_LossType {
	if m != nil {
		return m.LossType
	}
	return Model_LOSS_TYPE_UNSPECIFIED
}

func (m *Model_TrainingRun_TrainingOptions) GetLearnRate() float64 {
	if m != nil {
		return m.LearnRate
	}
	return 0
}

func (m *Model_TrainingRun_TrainingOptions) GetL1Regularization() *wrappers.DoubleValue {
	if m != nil {
		return m.L1Regularization
	}
	return nil
}

func (m *Model_TrainingRun_TrainingOptions) GetL2Regularization() *wrappers.DoubleValue {
	if m != nil {
		return m.L2Regularization
	}
	return nil
}

func (m *Model_TrainingRun_TrainingOptions) GetMinRelativeProgress() *wrappers.DoubleValue {
	if m != nil {
		return m.MinRelativeProgress
	}
	return nil
}

func (m *Model_TrainingRun_TrainingOptions) GetWarmStart() *wrappers.BoolValue {
	if m != nil {
		return m.WarmStart
	}
	return nil
}

func (m *Model_TrainingRun_TrainingOptions) GetEarlyStop() *wrappers.BoolValue {
	if m != nil {
		return m.EarlyStop
	}
	return nil
}

func (m *Model_TrainingRun_TrainingOptions) GetInputLabelColumns() []string {
	if m != nil {
		return m.InputLabelColumns
	}
	return nil
}

func (m *Model_TrainingRun_TrainingOptions) GetDataSplitMethod() Model_DataSplitMethod {
	if m != nil {
		return m.DataSplitMethod
	}
	return Model_DATA_SPLIT_METHOD_UNSPECIFIED
}

func (m *Model_TrainingRun_TrainingOptions) GetDataSplitEvalFraction() float64 {
	if m != nil {
		return m.DataSplitEvalFraction
	}
	return 0
}

func (m *Model_TrainingRun_TrainingOptions) GetDataSplitColumn() string {
	if m != nil {
		return m.DataSplitColumn
	}
	return ""
}

func (m *Model_TrainingRun_TrainingOptions) GetLearnRateStrategy() Model_LearnRateStrategy {
	if m != nil {
		return m.LearnRateStrategy
	}
	return Model_LEARN_RATE_STRATEGY_UNSPECIFIED
}

func (m *Model_TrainingRun_TrainingOptions) GetInitialLearnRate() float64 {
	if m != nil {
		return m.InitialLearnRate
	}
	return 0
}

func (m *Model_TrainingRun_TrainingOptions) GetLabelClassWeights() map[string]float64 {
	if m != nil {
		return m.LabelClassWeights
	}
	return nil
}

func (m *Model_TrainingRun_TrainingOptions) GetDistanceType() Model_DistanceType {
	if m != nil {
		return m.DistanceType
	}
	return Model_DISTANCE_TYPE_UNSPECIFIED
}

func (m *Model_TrainingRun_TrainingOptions) GetNumClusters() int64 {
	if m != nil {
		return m.NumClusters
	}
	return 0
}

// Information about a single iteration of the training run.
type Model_TrainingRun_IterationResult struct {
	// Index of the iteration, 0 based.
	Index *wrappers.Int32Value `protobuf:"bytes,1,opt,name=index,proto3" json:"index,omitempty"`
	// Time taken to run the iteration in milliseconds.
	DurationMs *wrappers.Int64Value `protobuf:"bytes,4,opt,name=duration_ms,json=durationMs,proto3" json:"duration_ms,omitempty"`
	// Loss computed on the training data at the end of iteration.
	TrainingLoss *wrappers.DoubleValue `protobuf:"bytes,5,opt,name=training_loss,json=trainingLoss,proto3" json:"training_loss,omitempty"`
	// Loss computed on the eval data at the end of iteration.
	EvalLoss *wrappers.DoubleValue `protobuf:"bytes,6,opt,name=eval_loss,json=evalLoss,proto3" json:"eval_loss,omitempty"`
	// Learn rate used for this iteration.
	LearnRate float64 `protobuf:"fixed64,7,opt,name=learn_rate,json=learnRate,proto3" json:"learn_rate,omitempty"`
	// [Beta] Information about top clusters for clustering models.
	ClusterInfos         []*Model_TrainingRun_IterationResult_ClusterInfo `protobuf:"bytes,8,rep,name=cluster_infos,json=clusterInfos,proto3" json:"cluster_infos,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                         `json:"-"`
	XXX_unrecognized     []byte                                           `json:"-"`
	XXX_sizecache        int32                                            `json:"-"`
}

func (m *Model_TrainingRun_IterationResult) Reset()         { *m = Model_TrainingRun_IterationResult{} }
func (m *Model_TrainingRun_IterationResult) String() string { return proto.CompactTextString(m) }
func (*Model_TrainingRun_IterationResult) ProtoMessage()    {}
func (*Model_TrainingRun_IterationResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{0, 6, 1}
}
func (m *Model_TrainingRun_IterationResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Model_TrainingRun_IterationResult.Unmarshal(m, b)
}
func (m *Model_TrainingRun_IterationResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Model_TrainingRun_IterationResult.Marshal(b, m, deterministic)
}
func (dst *Model_TrainingRun_IterationResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Model_TrainingRun_IterationResult.Merge(dst, src)
}
func (m *Model_TrainingRun_IterationResult) XXX_Size() int {
	return xxx_messageInfo_Model_TrainingRun_IterationResult.Size(m)
}
func (m *Model_TrainingRun_IterationResult) XXX_DiscardUnknown() {
	xxx_messageInfo_Model_TrainingRun_IterationResult.DiscardUnknown(m)
}

var xxx_messageInfo_Model_TrainingRun_IterationResult proto.InternalMessageInfo

func (m *Model_TrainingRun_IterationResult) GetIndex() *wrappers.Int32Value {
	if m != nil {
		return m.Index
	}
	return nil
}

func (m *Model_TrainingRun_IterationResult) GetDurationMs() *wrappers.Int64Value {
	if m != nil {
		return m.DurationMs
	}
	return nil
}

func (m *Model_TrainingRun_IterationResult) GetTrainingLoss() *wrappers.DoubleValue {
	if m != nil {
		return m.TrainingLoss
	}
	return nil
}

func (m *Model_TrainingRun_IterationResult) GetEvalLoss() *wrappers.DoubleValue {
	if m != nil {
		return m.EvalLoss
	}
	return nil
}

func (m *Model_TrainingRun_IterationResult) GetLearnRate() float64 {
	if m != nil {
		return m.LearnRate
	}
	return 0
}

func (m *Model_TrainingRun_IterationResult) GetClusterInfos() []*Model_TrainingRun_IterationResult_ClusterInfo {
	if m != nil {
		return m.ClusterInfos
	}
	return nil
}

// Information about a single cluster for clustering model.
type Model_TrainingRun_IterationResult_ClusterInfo struct {
	// Centroid id.
	CentroidId int64 `protobuf:"varint,1,opt,name=centroid_id,json=centroidId,proto3" json:"centroid_id,omitempty"`
	// Cluster radius, the average distance from centroid
	// to each point assigned to the cluster.
	ClusterRadius *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=cluster_radius,json=clusterRadius,proto3" json:"cluster_radius,omitempty"`
	// Cluster size, the total number of points assigned to the cluster.
	ClusterSize          *wrappers.Int64Value `protobuf:"bytes,3,opt,name=cluster_size,json=clusterSize,proto3" json:"cluster_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Model_TrainingRun_IterationResult_ClusterInfo) Reset() {
	*m = Model_TrainingRun_IterationResult_ClusterInfo{}
}
func (m *Model_TrainingRun_IterationResult_ClusterInfo) String() string {
	return proto.CompactTextString(m)
}
func (*Model_TrainingRun_IterationResult_ClusterInfo) ProtoMessage() {}
func (*Model_TrainingRun_IterationResult_ClusterInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{0, 6, 1, 0}
}
func (m *Model_TrainingRun_IterationResult_ClusterInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Model_TrainingRun_IterationResult_ClusterInfo.Unmarshal(m, b)
}
func (m *Model_TrainingRun_IterationResult_ClusterInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Model_TrainingRun_IterationResult_ClusterInfo.Marshal(b, m, deterministic)
}
func (dst *Model_TrainingRun_IterationResult_ClusterInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Model_TrainingRun_IterationResult_ClusterInfo.Merge(dst, src)
}
func (m *Model_TrainingRun_IterationResult_ClusterInfo) XXX_Size() int {
	return xxx_messageInfo_Model_TrainingRun_IterationResult_ClusterInfo.Size(m)
}
func (m *Model_TrainingRun_IterationResult_ClusterInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_Model_TrainingRun_IterationResult_ClusterInfo.DiscardUnknown(m)
}

var xxx_messageInfo_Model_TrainingRun_IterationResult_ClusterInfo proto.InternalMessageInfo

func (m *Model_TrainingRun_IterationResult_ClusterInfo) GetCentroidId() int64 {
	if m != nil {
		return m.CentroidId
	}
	return 0
}

func (m *Model_TrainingRun_IterationResult_ClusterInfo) GetClusterRadius() *wrappers.DoubleValue {
	if m != nil {
		return m.ClusterRadius
	}
	return nil
}

func (m *Model_TrainingRun_IterationResult_ClusterInfo) GetClusterSize() *wrappers.Int64Value {
	if m != nil {
		return m.ClusterSize
	}
	return nil
}

type GetModelRequest struct {
	// Project ID of the requested model.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Dataset ID of the requested model.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Model ID of the requested model.
	ModelId              string   `protobuf:"bytes,3,opt,name=model_id,json=modelId,proto3" json:"model_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetModelRequest) Reset()         { *m = GetModelRequest{} }
func (m *GetModelRequest) String() string { return proto.CompactTextString(m) }
func (*GetModelRequest) ProtoMessage()    {}
func (*GetModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{1}
}
func (m *GetModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetModelRequest.Unmarshal(m, b)
}
func (m *GetModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetModelRequest.Marshal(b, m, deterministic)
}
func (dst *GetModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetModelRequest.Merge(dst, src)
}
func (m *GetModelRequest) XXX_Size() int {
	return xxx_messageInfo_GetModelRequest.Size(m)
}
func (m *GetModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetModelRequest proto.InternalMessageInfo

func (m *GetModelRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetModelRequest) GetDatasetId() string {
	if m != nil {
		return m.DatasetId
	}
	return ""
}

func (m *GetModelRequest) GetModelId() string {
	if m != nil {
		return m.ModelId
	}
	return ""
}

type PatchModelRequest struct {
	// Project ID of the model to patch.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Dataset ID of the model to patch.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Model ID of the model to patch.
	ModelId string `protobuf:"bytes,3,opt,name=model_id,json=modelId,proto3" json:"model_id,omitempty"`
	// Patched model.
	// Follows patch semantics. Missing fields are not updated. To clear a field,
	// explicitly set to default value.
	Model                *Model   `protobuf:"bytes,4,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PatchModelRequest) Reset()         { *m = PatchModelRequest{} }
func (m *PatchModelRequest) String() string { return proto.CompactTextString(m) }
func (*PatchModelRequest) ProtoMessage()    {}
func (*PatchModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{2}
}
func (m *PatchModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PatchModelRequest.Unmarshal(m, b)
}
func (m *PatchModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PatchModelRequest.Marshal(b, m, deterministic)
}
func (dst *PatchModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PatchModelRequest.Merge(dst, src)
}
func (m *PatchModelRequest) XXX_Size() int {
	return xxx_messageInfo_PatchModelRequest.Size(m)
}
func (m *PatchModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PatchModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PatchModelRequest proto.InternalMessageInfo

func (m *PatchModelRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *PatchModelRequest) GetDatasetId() string {
	if m != nil {
		return m.DatasetId
	}
	return ""
}

func (m *PatchModelRequest) GetModelId() string {
	if m != nil {
		return m.ModelId
	}
	return ""
}

func (m *PatchModelRequest) GetModel() *Model {
	if m != nil {
		return m.Model
	}
	return nil
}

type DeleteModelRequest struct {
	// Project ID of the model to delete.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Dataset ID of the model to delete.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Model ID of the model to delete.
	ModelId              string   `protobuf:"bytes,3,opt,name=model_id,json=modelId,proto3" json:"model_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteModelRequest) Reset()         { *m = DeleteModelRequest{} }
func (m *DeleteModelRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteModelRequest) ProtoMessage()    {}
func (*DeleteModelRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{3}
}
func (m *DeleteModelRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteModelRequest.Unmarshal(m, b)
}
func (m *DeleteModelRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteModelRequest.Marshal(b, m, deterministic)
}
func (dst *DeleteModelRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteModelRequest.Merge(dst, src)
}
func (m *DeleteModelRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteModelRequest.Size(m)
}
func (m *DeleteModelRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteModelRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteModelRequest proto.InternalMessageInfo

func (m *DeleteModelRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DeleteModelRequest) GetDatasetId() string {
	if m != nil {
		return m.DatasetId
	}
	return ""
}

func (m *DeleteModelRequest) GetModelId() string {
	if m != nil {
		return m.ModelId
	}
	return ""
}

type ListModelsRequest struct {
	// Project ID of the models to list.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Dataset ID of the models to list.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// The maximum number of results per page.
	MaxResults *wrappers.UInt32Value `protobuf:"bytes,3,opt,name=max_results,json=maxResults,proto3" json:"max_results,omitempty"`
	// Page token, returned by a previous call to request the next page of
	// results
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListModelsRequest) Reset()         { *m = ListModelsRequest{} }
func (m *ListModelsRequest) String() string { return proto.CompactTextString(m) }
func (*ListModelsRequest) ProtoMessage()    {}
func (*ListModelsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{4}
}
func (m *ListModelsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListModelsRequest.Unmarshal(m, b)
}
func (m *ListModelsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListModelsRequest.Marshal(b, m, deterministic)
}
func (dst *ListModelsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListModelsRequest.Merge(dst, src)
}
func (m *ListModelsRequest) XXX_Size() int {
	return xxx_messageInfo_ListModelsRequest.Size(m)
}
func (m *ListModelsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListModelsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListModelsRequest proto.InternalMessageInfo

func (m *ListModelsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListModelsRequest) GetDatasetId() string {
	if m != nil {
		return m.DatasetId
	}
	return ""
}

func (m *ListModelsRequest) GetMaxResults() *wrappers.UInt32Value {
	if m != nil {
		return m.MaxResults
	}
	return nil
}

func (m *ListModelsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

type ListModelsResponse struct {
	// Models in the requested dataset. Only the following fields are populated:
	// model_reference, model_type, creation_time, last_modified_time and
	// labels.
	Models []*Model `protobuf:"bytes,1,rep,name=models,proto3" json:"models,omitempty"`
	// A token to request the next page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListModelsResponse) Reset()         { *m = ListModelsResponse{} }
func (m *ListModelsResponse) String() string { return proto.CompactTextString(m) }
func (*ListModelsResponse) ProtoMessage()    {}
func (*ListModelsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_model_a27f597ae55804ce, []int{5}
}
func (m *ListModelsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListModelsResponse.Unmarshal(m, b)
}
func (m *ListModelsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListModelsResponse.Marshal(b, m, deterministic)
}
func (dst *ListModelsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListModelsResponse.Merge(dst, src)
}
func (m *ListModelsResponse) XXX_Size() int {
	return xxx_messageInfo_ListModelsResponse.Size(m)
}
func (m *ListModelsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListModelsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListModelsResponse proto.InternalMessageInfo

func (m *ListModelsResponse) GetModels() []*Model {
	if m != nil {
		return m.Models
	}
	return nil
}

func (m *ListModelsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func init() {
	proto.RegisterType((*Model)(nil), "google.cloud.bigquery.v2.Model")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.bigquery.v2.Model.LabelsEntry")
	proto.RegisterType((*Model_RegressionMetrics)(nil), "google.cloud.bigquery.v2.Model.RegressionMetrics")
	proto.RegisterType((*Model_AggregateClassificationMetrics)(nil), "google.cloud.bigquery.v2.Model.AggregateClassificationMetrics")
	proto.RegisterType((*Model_BinaryClassificationMetrics)(nil), "google.cloud.bigquery.v2.Model.BinaryClassificationMetrics")
	proto.RegisterType((*Model_BinaryClassificationMetrics_BinaryConfusionMatrix)(nil), "google.cloud.bigquery.v2.Model.BinaryClassificationMetrics.BinaryConfusionMatrix")
	proto.RegisterType((*Model_MultiClassClassificationMetrics)(nil), "google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics")
	proto.RegisterType((*Model_MultiClassClassificationMetrics_ConfusionMatrix)(nil), "google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix")
	proto.RegisterType((*Model_MultiClassClassificationMetrics_ConfusionMatrix_Entry)(nil), "google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix.Entry")
	proto.RegisterType((*Model_MultiClassClassificationMetrics_ConfusionMatrix_Row)(nil), "google.cloud.bigquery.v2.Model.MultiClassClassificationMetrics.ConfusionMatrix.Row")
	proto.RegisterType((*Model_ClusteringMetrics)(nil), "google.cloud.bigquery.v2.Model.ClusteringMetrics")
	proto.RegisterType((*Model_EvaluationMetrics)(nil), "google.cloud.bigquery.v2.Model.EvaluationMetrics")
	proto.RegisterType((*Model_TrainingRun)(nil), "google.cloud.bigquery.v2.Model.TrainingRun")
	proto.RegisterType((*Model_TrainingRun_TrainingOptions)(nil), "google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions")
	proto.RegisterMapType((map[string]float64)(nil), "google.cloud.bigquery.v2.Model.TrainingRun.TrainingOptions.LabelClassWeightsEntry")
	proto.RegisterType((*Model_TrainingRun_IterationResult)(nil), "google.cloud.bigquery.v2.Model.TrainingRun.IterationResult")
	proto.RegisterType((*Model_TrainingRun_IterationResult_ClusterInfo)(nil), "google.cloud.bigquery.v2.Model.TrainingRun.IterationResult.ClusterInfo")
	proto.RegisterType((*GetModelRequest)(nil), "google.cloud.bigquery.v2.GetModelRequest")
	proto.RegisterType((*PatchModelRequest)(nil), "google.cloud.bigquery.v2.PatchModelRequest")
	proto.RegisterType((*DeleteModelRequest)(nil), "google.cloud.bigquery.v2.DeleteModelRequest")
	proto.RegisterType((*ListModelsRequest)(nil), "google.cloud.bigquery.v2.ListModelsRequest")
	proto.RegisterType((*ListModelsResponse)(nil), "google.cloud.bigquery.v2.ListModelsResponse")
	proto.RegisterEnum("google.cloud.bigquery.v2.Model_ModelType", Model_ModelType_name, Model_ModelType_value)
	proto.RegisterEnum("google.cloud.bigquery.v2.Model_LossType", Model_LossType_name, Model_LossType_value)
	proto.RegisterEnum("google.cloud.bigquery.v2.Model_DistanceType", Model_DistanceType_name, Model_DistanceType_value)
	proto.RegisterEnum("google.cloud.bigquery.v2.Model_DataSplitMethod", Model_DataSplitMethod_name, Model_DataSplitMethod_value)
	proto.RegisterEnum("google.cloud.bigquery.v2.Model_LearnRateStrategy", Model_LearnRateStrategy_name, Model_LearnRateStrategy_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ModelServiceClient is the client API for ModelService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ModelServiceClient interface {
	// Gets the specified model resource by model ID.
	GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Lists all models in the specified dataset. Requires the READER dataset
	// role.
	ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error)
	// Patch specific fields in the specified model.
	PatchModel(ctx context.Context, in *PatchModelRequest, opts ...grpc.CallOption) (*Model, error)
	// Deletes the model specified by modelId from the dataset.
	DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type modelServiceClient struct {
	cc *grpc.ClientConn
}

func NewModelServiceClient(cc *grpc.ClientConn) ModelServiceClient {
	return &modelServiceClient{cc}
}

func (c *modelServiceClient) GetModel(ctx context.Context, in *GetModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.v2.ModelService/GetModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) ListModels(ctx context.Context, in *ListModelsRequest, opts ...grpc.CallOption) (*ListModelsResponse, error) {
	out := new(ListModelsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.v2.ModelService/ListModels", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) PatchModel(ctx context.Context, in *PatchModelRequest, opts ...grpc.CallOption) (*Model, error) {
	out := new(Model)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.v2.ModelService/PatchModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelServiceClient) DeleteModel(ctx context.Context, in *DeleteModelRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.v2.ModelService/DeleteModel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ModelServiceServer is the server API for ModelService service.
type ModelServiceServer interface {
	// Gets the specified model resource by model ID.
	GetModel(context.Context, *GetModelRequest) (*Model, error)
	// Lists all models in the specified dataset. Requires the READER dataset
	// role.
	ListModels(context.Context, *ListModelsRequest) (*ListModelsResponse, error)
	// Patch specific fields in the specified model.
	PatchModel(context.Context, *PatchModelRequest) (*Model, error)
	// Deletes the model specified by modelId from the dataset.
	DeleteModel(context.Context, *DeleteModelRequest) (*empty.Empty, error)
}

func RegisterModelServiceServer(s *grpc.Server, srv ModelServiceServer) {
	s.RegisterService(&_ModelService_serviceDesc, srv)
}

func _ModelService_GetModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).GetModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.v2.ModelService/GetModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).GetModel(ctx, req.(*GetModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_ListModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).ListModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.v2.ModelService/ListModels",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).ListModels(ctx, req.(*ListModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_PatchModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).PatchModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.v2.ModelService/PatchModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).PatchModel(ctx, req.(*PatchModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelService_DeleteModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelServiceServer).DeleteModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.v2.ModelService/DeleteModel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelServiceServer).DeleteModel(ctx, req.(*DeleteModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ModelService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.v2.ModelService",
	HandlerType: (*ModelServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetModel",
			Handler:    _ModelService_GetModel_Handler,
		},
		{
			MethodName: "ListModels",
			Handler:    _ModelService_ListModels_Handler,
		},
		{
			MethodName: "PatchModel",
			Handler:    _ModelService_PatchModel_Handler,
		},
		{
			MethodName: "DeleteModel",
			Handler:    _ModelService_DeleteModel_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/v2/model.proto",
}

func init() {
	proto.RegisterFile("google/cloud/bigquery/v2/model.proto", fileDescriptor_model_a27f597ae55804ce)
}

var fileDescriptor_model_a27f597ae55804ce = []byte{
	// 2541 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x59, 0xdd, 0x73, 0x23, 0x47,
	0x11, 0xb7, 0x2c, 0x7f, 0xa9, 0x65, 0x5b, 0xd2, 0xf8, 0x7c, 0xe8, 0x74, 0x77, 0x39, 0x47, 0xe1,
	0xc3, 0x24, 0x57, 0x72, 0x9d, 0x93, 0x90, 0x5c, 0x02, 0x01, 0x59, 0x52, 0xce, 0x02, 0x59, 0xf2,
	0xed, 0xca, 0x09, 0x01, 0xaa, 0x96, 0xf1, 0xee, 0x48, 0x37, 0xc9, 0x7e, 0xe8, 0x66, 0x66, 0xcf,
	0xf6, 0xbd, 0x01, 0x2f, 0x29, 0xaa, 0xe0, 0x81, 0x27, 0x78, 0xe6, 0x0f, 0xa0, 0x28, 0x2a, 0xef,
	0x54, 0xf1, 0x37, 0xf0, 0x8f, 0x50, 0xc5, 0x13, 0x2f, 0xd4, 0xcc, 0xce, 0xea, 0xd3, 0xb6, 0xf6,
	0xb8, 0xab, 0x14, 0x2f, 0xf6, 0x4e, 0x4f, 0xf7, 0x6f, 0xba, 0x7b, 0xba, 0x7b, 0x7a, 0x46, 0xf0,
	0xcd, 0x7e, 0x10, 0xf4, 0x5d, 0xb2, 0x67, 0xbb, 0x41, 0xe8, 0xec, 0x9d, 0xd2, 0xfe, 0xd3, 0x90,
	0xb0, 0x8b, 0xbd, 0x67, 0xfb, 0x7b, 0x5e, 0xe0, 0x10, 0xb7, 0x32, 0x60, 0x81, 0x08, 0x50, 0x31,
	0xe2, 0xaa, 0x28, 0xae, 0x4a, 0xcc, 0x55, 0x79, 0xb6, 0x5f, 0xaa, 0x5c, 0x2f, 0x6f, 0x31, 0xd2,
	0x23, 0x8c, 0xf8, 0x36, 0x89, 0x90, 0x4a, 0x6f, 0x5d, 0xc9, 0xcf, 0x05, 0xf6, 0x1d, 0xcc, 0x1c,
	0x8b, 0x3f, 0xd5, 0xcb, 0x96, 0x6e, 0x6b, 0x66, 0x35, 0x3a, 0x0d, 0x7b, 0x7b, 0xc4, 0x1b, 0x88,
	0x0b, 0x3d, 0x79, 0x6f, 0x7a, 0x52, 0x50, 0x8f, 0x70, 0x81, 0xbd, 0x81, 0x66, 0x78, 0x6d, 0x9a,
	0xe1, 0x8c, 0xe1, 0xc1, 0x80, 0x30, 0xae, 0xe7, 0xef, 0xe8, 0x79, 0x3c, 0xa0, 0x7b, 0xd8, 0xf7,
	0x03, 0x81, 0x05, 0x0d, 0x7c, 0x3d, 0x5b, 0xfe, 0xe3, 0xdb, 0xb0, 0x7c, 0x24, 0x4d, 0x40, 0x08,
	0x96, 0x88, 0xc0, 0xfd, 0x62, 0x6a, 0x27, 0xb5, 0x9b, 0x31, 0xd4, 0x37, 0x7a, 0x0c, 0xb9, 0x29,
	0xfb, 0x8a, 0x8b, 0x3b, 0xa9, 0xdd, 0xec, 0xfe, 0x6e, 0xe5, 0x2a, 0x57, 0x55, 0x14, 0x9a, 0x11,
	0xf3, 0x1b, 0x9b, 0xde, 0xc4, 0x18, 0xbd, 0x01, 0x1b, 0x36, 0x23, 0x4a, 0x07, 0x4b, 0x9a, 0x52,
	0x5c, 0xde, 0x49, 0xed, 0xa6, 0x8d, 0xf5, 0x98, 0xd8, 0xa5, 0x1e, 0x41, 0xf7, 0x01, 0xb9, 0x98,
	0x0b, 0xcb, 0x0b, 0x1c, 0xda, 0xa3, 0xc4, 0x89, 0x38, 0x57, 0x14, 0x67, 0x5e, 0xce, 0x1c, 0xe9,
	0x09, 0xc5, 0xbd, 0x03, 0x59, 0x87, 0x70, 0x9b, 0xd1, 0x81, 0x04, 0x28, 0xae, 0x2b, 0x03, 0xc6,
	0x49, 0x72, 0xd1, 0x1e, 0xa3, 0xc4, 0x77, 0xdc, 0x0b, 0xcb, 0xc7, 0x1e, 0x29, 0x6e, 0x2a, 0x9e,
	0xf5, 0x98, 0xd8, 0xc6, 0x1e, 0x41, 0x35, 0x58, 0x71, 0xf1, 0x29, 0x71, 0x79, 0x31, 0xb7, 0x93,
	0xde, 0xcd, 0xee, 0xbf, 0x35, 0xc7, 0xc6, 0x4a, 0x4b, 0x71, 0x37, 0x7c, 0xc1, 0x2e, 0x0c, 0x2d,
	0x8a, 0xbe, 0x03, 0x39, 0x72, 0x3e, 0xa0, 0x6c, 0xcc, 0xc0, 0xbc, 0x52, 0x7b, 0x73, 0x44, 0x56,
	0x4a, 0x97, 0x60, 0xcd, 0x0d, 0x6c, 0x35, 0x2e, 0x6e, 0x28, 0x6d, 0x86, 0x63, 0x74, 0x08, 0x10,
	0xb9, 0x5d, 0x5c, 0x0c, 0x48, 0x71, 0x75, 0x27, 0xb5, 0xbb, 0xb9, 0xff, 0xdd, 0x79, 0xda, 0xa8,
	0xbf, 0xdd, 0x8b, 0x01, 0x31, 0x32, 0x5e, 0xfc, 0x89, 0x8e, 0x61, 0x43, 0x30, 0x4c, 0x7d, 0xea,
	0xf7, 0x2d, 0x16, 0xfa, 0xbc, 0x98, 0x49, 0x66, 0x5a, 0x57, 0x0b, 0x19, 0xa1, 0x6f, 0xac, 0x8b,
	0xd1, 0x80, 0x23, 0x13, 0x72, 0x3d, 0x82, 0x45, 0xc8, 0x88, 0x65, 0x07, 0x6e, 0xe8, 0xf9, 0xbc,
	0x08, 0x0a, 0xf3, 0xcd, 0xab, 0x31, 0x4d, 0x1d, 0xf3, 0xe6, 0x53, 0xf7, 0x63, 0x4a, 0x5c, 0xc7,
	0xd8, 0xd4, 0x10, 0xb5, 0x08, 0x01, 0x75, 0x60, 0x43, 0xf9, 0x6f, 0x08, 0x99, 0x7d, 0x61, 0xc8,
	0x75, 0x05, 0xa0, 0x01, 0x4b, 0xbf, 0x4b, 0x43, 0xc1, 0x20, 0x7d, 0x46, 0x38, 0xa7, 0x81, 0x7f,
	0x44, 0x04, 0xa3, 0x36, 0x47, 0x2d, 0xd8, 0xf2, 0x08, 0xf6, 0x2d, 0x7c, 0xca, 0x03, 0x37, 0x14,
	0xc4, 0x22, 0x8c, 0x05, 0x4c, 0x45, 0x7c, 0x76, 0xff, 0x4e, 0xbc, 0x58, 0x9c, 0x48, 0x95, 0x7a,
	0x10, 0x9e, 0xba, 0xe4, 0x13, 0xec, 0x86, 0xc4, 0x28, 0x48, 0xc1, 0xaa, 0x96, 0x6b, 0x48, 0x31,
	0xf4, 0x63, 0x40, 0x0a, 0x8d, 0x3f, 0x0d, 0x31, 0x23, 0x8e, 0x06, 0x5b, 0x4c, 0x00, 0x96, 0x97,
	0x72, 0x66, 0x24, 0x16, 0x61, 0x3d, 0x86, 0x9b, 0x13, 0x58, 0x6e, 0xd0, 0xd7, 0x78, 0xe9, 0x04,
	0x78, 0x5b, 0x63, 0x78, 0xad, 0xa0, 0x1f, 0x41, 0x1e, 0xc3, 0xb6, 0x47, 0x1c, 0x3a, 0x6b, 0xee,
	0x52, 0x32, 0x44, 0x29, 0x3a, 0x69, 0xf0, 0x43, 0xc8, 0xb0, 0x58, 0x43, 0x95, 0xb6, 0xf3, 0x50,
	0xd6, 0x98, 0x56, 0xaa, 0xf4, 0xd7, 0x34, 0xbc, 0x56, 0xed, 0xf7, 0x19, 0xe9, 0x63, 0x41, 0x6a,
	0x2e, 0xe6, 0x9c, 0xf6, 0x68, 0x14, 0xed, 0xf1, 0xe6, 0x7c, 0x00, 0x99, 0x01, 0x23, 0x36, 0x95,
	0x1b, 0x96, 0x68, 0x4b, 0x46, 0xec, 0xe8, 0x1d, 0x58, 0x61, 0xc4, 0xc6, 0xae, 0x9b, 0xc8, 0xfd,
	0x9a, 0x17, 0xbd, 0x0f, 0x6b, 0xd8, 0xb6, 0x43, 0x86, 0xed, 0x8b, 0x44, 0x6e, 0x1e, 0x72, 0x4b,
	0x5d, 0xc5, 0x13, 0x46, 0xf8, 0x93, 0xc0, 0x75, 0x12, 0xf9, 0x73, 0xc4, 0x8e, 0xde, 0x83, 0xb5,
	0xde, 0x03, 0x8b, 0xdb, 0x01, 0x23, 0x89, 0x9c, 0xb8, 0xda, 0x7b, 0x60, 0x4a, 0x66, 0x29, 0x28,
	0xc3, 0xc2, 0x0d, 0x38, 0x57, 0xa5, 0x70, 0xae, 0xa0, 0x1b, 0xf4, 0x5b, 0x01, 0xe7, 0xe8, 0x5d,
	0x58, 0x65, 0x81, 0x6d, 0xe1, 0xd0, 0x56, 0xb5, 0x64, 0xbe, 0x7b, 0x02, 0xbb, 0x1a, 0xda, 0xa5,
	0xaf, 0x56, 0xe0, 0xf6, 0x01, 0xf5, 0x31, 0xbb, 0xb8, 0x7c, 0xc3, 0xbe, 0x4c, 0xc1, 0x0e, 0x8e,
	0xf7, 0xd4, 0xb2, 0x27, 0x78, 0x2c, 0x2f, 0x62, 0xd2, 0x1b, 0xf9, 0xd1, 0xbc, 0x7a, 0x73, 0x7d,
	0x6c, 0x18, 0xaf, 0xe1, 0xeb, 0x63, 0xe7, 0x0f, 0x29, 0xb8, 0x73, 0xaa, 0x54, 0xb5, 0xec, 0xc0,
	0xef, 0x85, 0x5c, 0xa9, 0x80, 0x05, 0xa3, 0xe7, 0x96, 0x4b, 0xb9, 0x28, 0x2e, 0xaa, 0x7a, 0xf2,
	0x78, 0x9e, 0x1a, 0xd7, 0x98, 0x1b, 0xcf, 0xc5, 0xf0, 0x47, 0x0a, 0xdd, 0xb8, 0x75, 0x7a, 0x19,
	0xb9, 0x45, 0xb9, 0x28, 0xfd, 0x3b, 0x0d, 0xdb, 0x97, 0x0a, 0xa1, 0x4f, 0xa0, 0x38, 0x08, 0x38,
	0x15, 0xf4, 0x99, 0xf6, 0x9b, 0x35, 0x8a, 0xa6, 0x24, 0x91, 0x7f, 0x33, 0x96, 0x56, 0x9a, 0x76,
	0x87, 0xa1, 0x75, 0x00, 0x9b, 0x82, 0x85, 0xc4, 0x8a, 0xa7, 0xb9, 0x4e, 0x87, 0xdb, 0x33, 0x68,
	0x4d, 0x5f, 0x7c, 0xef, 0x9d, 0x08, 0x6c, 0x43, 0x8a, 0x1c, 0xc7, 0x12, 0xa8, 0x0e, 0xb9, 0x1e,
	0x76, 0xf9, 0x38, 0x48, 0x7a, 0x3e, 0xc8, 0xa6, 0x92, 0x19, 0xa1, 0xc4, 0x9a, 0xf8, 0x72, 0xd3,
	0x14, 0xc8, 0x52, 0x42, 0x4d, 0xda, 0xb1, 0xc4, 0x48, 0x93, 0x11, 0xc8, 0x72, 0x52, 0x4d, 0x46,
	0x28, 0x13, 0x65, 0x65, 0xe5, 0x7f, 0x2d, 0x2b, 0xab, 0xc9, 0xcb, 0x4a, 0xe9, 0xb7, 0x2b, 0x70,
	0xef, 0x28, 0x74, 0x05, 0x55, 0xbb, 0xf3, 0x7f, 0x9f, 0x3b, 0xbf, 0x49, 0xc1, 0xf6, 0x75, 0x49,
	0xd3, 0x99, 0xdb, 0x78, 0x5c, 0x6f, 0x6b, 0x65, 0x3a, 0x65, 0xb6, 0xec, 0x4b, 0x92, 0xe5, 0x9f,
	0x69, 0xc8, 0x4d, 0xa7, 0x49, 0x07, 0x6e, 0x48, 0x56, 0xea, 0xc8, 0xc6, 0xf1, 0x05, 0x53, 0x64,
	0x6b, 0x24, 0x39, 0xca, 0x8f, 0x3e, 0x2c, 0xb1, 0xe0, 0x8c, 0x6b, 0xc3, 0xcc, 0x57, 0x6c, 0x58,
	0xc5, 0x08, 0xce, 0x0c, 0xb5, 0x40, 0xc9, 0x85, 0x65, 0xd5, 0x16, 0xca, 0x76, 0x70, 0xc0, 0x88,
	0x43, 0x6d, 0x21, 0x0f, 0x75, 0xd9, 0xa1, 0xe8, 0xfe, 0x7a, 0x73, 0x48, 0x56, 0x5d, 0x24, 0xfa,
	0x00, 0x80, 0x0a, 0xe2, 0x59, 0x76, 0x10, 0xfa, 0x22, 0x49, 0xda, 0x66, 0x24, 0x7b, 0x4d, 0x72,
	0x97, 0xfe, 0x94, 0x82, 0xb4, 0x11, 0x9c, 0xa1, 0xd7, 0x61, 0x1d, 0xdb, 0x22, 0xc4, 0xee, 0xc4,
	0x4a, 0xd9, 0x88, 0x16, 0x2d, 0x13, 0xc0, 0x2a, 0xf1, 0x05, 0xa3, 0x24, 0x76, 0xc2, 0xc9, 0xab,
	0x76, 0x42, 0xd4, 0x0e, 0xc7, 0xab, 0x94, 0xbe, 0x4a, 0x41, 0xa1, 0xe6, 0x86, 0x5c, 0x10, 0x46,
	0xfd, 0x7e, 0x1c, 0x73, 0x6d, 0xb8, 0xe1, 0xe0, 0x67, 0x94, 0x70, 0xeb, 0x34, 0x08, 0x5d, 0x87,
	0xfa, 0x16, 0xf5, 0x1d, 0x72, 0x9e, 0x68, 0x67, 0x51, 0x24, 0x79, 0x10, 0x09, 0x36, 0xa5, 0x5c,
	0xd4, 0xeb, 0x8c, 0xb5, 0x4f, 0x0e, 0x95, 0xd7, 0xac, 0xe1, 0x6d, 0x25, 0x79, 0xf7, 0x54, 0xd7,
	0x82, 0xa5, 0xff, 0xa4, 0xa1, 0xd0, 0x78, 0x86, 0xdd, 0x70, 0x22, 0x57, 0x4e, 0x01, 0xb1, 0x61,
	0x57, 0x39, 0x95, 0xa7, 0x0f, 0xe6, 0x79, 0x72, 0xa6, 0x1f, 0x3d, 0x5c, 0x30, 0x0a, 0x6c, 0xa6,
	0x49, 0xfd, 0x55, 0x0a, 0xee, 0xc6, 0x67, 0xd9, 0xe5, 0x75, 0x21, 0x32, 0xea, 0xc3, 0x97, 0x38,
	0xcc, 0x0e, 0x17, 0x8c, 0xdb, 0xa7, 0xd7, 0x1c, 0xed, 0xbf, 0x4f, 0x41, 0xd9, 0x93, 0x1b, 0xaf,
	0x8f, 0xa7, 0x2b, 0x14, 0x89, 0x0e, 0x86, 0x1f, 0xbe, 0x64, 0x08, 0x1d, 0x2e, 0x18, 0xf7, 0xbc,
	0x39, 0xf5, 0xf2, 0x14, 0x90, 0x3d, 0x8c, 0xa2, 0xe1, 0xfa, 0x4b, 0xc9, 0x1c, 0x3f, 0x13, 0x7f,
	0xd2, 0xf1, 0xf6, 0x34, 0xf1, 0x20, 0x03, 0xab, 0x1a, 0xb8, 0xf4, 0xaf, 0x3c, 0x64, 0xc7, 0xae,
	0x40, 0xa8, 0x07, 0xf9, 0xe1, 0x35, 0x2a, 0x50, 0x57, 0xca, 0x78, 0xd7, 0x3f, 0x7c, 0x81, 0x9b,
	0xd4, 0xf0, 0xbb, 0x13, 0x41, 0x18, 0x39, 0x31, 0x49, 0x40, 0x0f, 0x01, 0xb8, 0xc0, 0x4c, 0x44,
	0x17, 0xc7, 0x35, 0xb5, 0x42, 0x69, 0x26, 0x78, 0xbb, 0xf1, 0x0b, 0x80, 0x91, 0x51, 0xdc, 0xea,
	0x3e, 0x79, 0x02, 0xab, 0x8c, 0xf0, 0xd0, 0x15, 0xb2, 0x39, 0x4c, 0xbf, 0xa8, 0x66, 0x4d, 0x41,
	0xa2, 0xbb, 0xa9, 0xa1, 0x30, 0x8c, 0x18, 0x0b, 0xfd, 0x12, 0x10, 0x19, 0xa6, 0xc1, 0xd0, 0xf1,
	0xab, 0xc9, 0x1c, 0x3f, 0x93, 0x40, 0x46, 0x81, 0x4c, 0x93, 0x4a, 0x7f, 0xcf, 0x40, 0x6e, 0xca,
	0x31, 0xe8, 0x5b, 0xb0, 0xe9, 0xe1, 0x73, 0x8b, 0xc6, 0x5a, 0x45, 0xde, 0x4e, 0x1b, 0x1b, 0x1e,
	0x3e, 0x1f, 0xaa, 0xca, 0x51, 0x03, 0x32, 0xb2, 0x1b, 0x8e, 0xae, 0xc9, 0x8b, 0xea, 0x9a, 0xbc,
	0x3b, 0xf7, 0xd2, 0x1e, 0x70, 0xae, 0x6e, 0xc9, 0x6b, 0xae, 0xfe, 0x42, 0x77, 0x01, 0x5c, 0x82,
	0x99, 0x6f, 0x31, 0x2c, 0x88, 0x0a, 0xea, 0x94, 0x91, 0x51, 0x14, 0x03, 0x0b, 0x82, 0x9a, 0x50,
	0x70, 0x1f, 0x58, 0x8c, 0xf4, 0x43, 0x17, 0x33, 0xfa, 0x3c, 0xba, 0xb2, 0x27, 0x69, 0xfa, 0xf3,
	0xee, 0x03, 0x63, 0x42, 0x4a, 0x41, 0xed, 0x4f, 0x43, 0x2d, 0x27, 0x82, 0xda, 0x9f, 0x82, 0x92,
	0x25, 0x8f, 0xfa, 0x16, 0x23, 0xae, 0x6a, 0x74, 0xac, 0x01, 0x0b, 0x54, 0x25, 0x49, 0xd4, 0xe3,
	0x6c, 0x79, 0xd4, 0x37, 0xb4, 0xe4, 0xb1, 0x16, 0x94, 0xc1, 0x77, 0x86, 0x99, 0x67, 0xa9, 0x98,
	0xd2, 0x5b, 0x3c, 0x1b, 0x7c, 0x07, 0x41, 0xe0, 0xea, 0x13, 0x48, 0x72, 0x9b, 0x92, 0x59, 0x8a,
	0x12, 0xcc, 0xdc, 0x0b, 0x8b, 0x8b, 0x60, 0x70, 0x65, 0xdc, 0x8e, 0x89, 0x2a, 0x6e, 0x53, 0x04,
	0x03, 0x54, 0x81, 0x2d, 0xea, 0x0f, 0x42, 0x61, 0x4d, 0x3e, 0x00, 0x64, 0x76, 0xd2, 0xbb, 0x19,
	0xa3, 0xa0, 0xa6, 0x5a, 0x63, 0x37, 0x7b, 0xf4, 0x73, 0x28, 0x38, 0x58, 0x60, 0x8b, 0x0f, 0x5c,
	0x2a, 0x64, 0x40, 0x3e, 0x09, 0x9c, 0x22, 0xa8, 0xbd, 0xdf, 0x9b, 0xb7, 0xf7, 0x75, 0x2c, 0xb0,
	0x29, 0xe5, 0x8e, 0x94, 0x98, 0x91, 0x73, 0x26, 0x09, 0xe8, 0x3d, 0x28, 0x8e, 0x81, 0xcb, 0x58,
	0xb5, 0x7a, 0x0c, 0xdb, 0x6a, 0x9b, 0xb2, 0x2a, 0x2e, 0xb6, 0x87, 0x22, 0x32, 0xb8, 0x3f, 0xd6,
	0x93, 0xe8, 0xcd, 0x09, 0xad, 0x22, 0x23, 0xf4, 0x43, 0xd4, 0x68, 0x91, 0xc8, 0x04, 0x84, 0x61,
	0x6b, 0x14, 0x6e, 0x16, 0x17, 0xf2, 0x5f, 0xff, 0x42, 0x3d, 0x02, 0x6d, 0xce, 0xcf, 0xa9, 0x56,
	0x1c, 0x97, 0xa6, 0x16, 0x34, 0x0a, 0xee, 0x34, 0x09, 0xdd, 0x07, 0x44, 0x7d, 0x2a, 0xa8, 0x6c,
	0x05, 0x46, 0x91, 0x9d, 0x57, 0x16, 0xe4, 0xf5, 0xcc, 0x10, 0x08, 0xfd, 0x3a, 0x05, 0x5b, 0xda,
	0xfb, 0xaa, 0xda, 0x9f, 0x11, 0xda, 0x7f, 0x22, 0x78, 0xb1, 0xa0, 0xea, 0x88, 0xf1, 0x12, 0x15,
	0x2e, 0x7a, 0x22, 0x53, 0x25, 0xfd, 0xd3, 0x08, 0x34, 0x6a, 0x0f, 0x0a, 0xee, 0x34, 0x1d, 0x3d,
	0x86, 0x8d, 0xf8, 0xd4, 0x8e, 0xf2, 0xf9, 0x86, 0xf2, 0xc7, 0xfd, 0xb9, 0x7b, 0xaa, 0x85, 0x54,
	0x4e, 0xaf, 0x3b, 0x63, 0x23, 0xd9, 0x0f, 0xf9, 0xa1, 0x67, 0xe9, 0x4a, 0xcf, 0x8b, 0xdb, 0xaa,
	0x86, 0x64, 0xfd, 0xd0, 0xd3, 0x27, 0x02, 0x2f, 0xd5, 0xe1, 0xe6, 0xe5, 0x2a, 0xa2, 0x3c, 0xa4,
	0xbf, 0x20, 0x17, 0xba, 0x87, 0x92, 0x9f, 0xe8, 0x06, 0x2c, 0xcb, 0xe2, 0x15, 0x55, 0x9a, 0x94,
	0x11, 0x0d, 0x3e, 0x58, 0x7c, 0x3f, 0x55, 0xfa, 0xc7, 0x12, 0xe4, 0xa6, 0x2a, 0x28, 0x7a, 0x00,
	0xcb, 0xe3, 0x3d, 0xcd, 0xa5, 0xbd, 0xdc, 0xdb, 0xfb, 0x51, 0x3a, 0x44, 0x9c, 0xe8, 0xfb, 0x90,
	0x75, 0x42, 0xfd, 0x72, 0xe8, 0x25, 0xba, 0x31, 0x41, 0xcc, 0x7f, 0xc4, 0x51, 0x75, 0xec, 0xa9,
	0x4f, 0xbd, 0x11, 0x24, 0xa9, 0x2b, 0xc3, 0xb7, 0x3d, 0xf5, 0x50, 0xf0, 0x10, 0x32, 0x2a, 0xe6,
	0x13, 0x3f, 0x31, 0xac, 0x49, 0x76, 0x25, 0x3a, 0x59, 0x43, 0x57, 0xa7, 0x6b, 0xa8, 0x0b, 0x1b,
	0x7a, 0x1b, 0x2c, 0xea, 0xf7, 0x02, 0x5e, 0x5c, 0x53, 0xb1, 0xf5, 0xe8, 0x25, 0xce, 0xa8, 0xf8,
	0x58, 0x6f, 0xfa, 0xbd, 0xc0, 0x58, 0xb7, 0x47, 0x03, 0x5e, 0xfa, 0x5b, 0x0a, 0xb2, 0x63, 0xb3,
	0xe8, 0x1e, 0x64, 0x6d, 0xd9, 0x90, 0x06, 0xd4, 0xb1, 0xa8, 0xa3, 0xcf, 0x12, 0x88, 0x49, 0x4d,
	0x07, 0xd5, 0x60, 0x33, 0x56, 0x8f, 0x61, 0x87, 0x86, 0x3c, 0x51, 0xe3, 0x18, 0x9b, 0x64, 0x28,
	0x11, 0xf4, 0x11, 0xc4, 0x5a, 0x58, 0x9c, 0x3e, 0x27, 0x49, 0xae, 0xcd, 0x59, 0x2d, 0x60, 0xd2,
	0xe7, 0xa4, 0xf4, 0x10, 0xb2, 0x63, 0x2f, 0xca, 0xf3, 0x02, 0x30, 0x33, 0x16, 0x80, 0x65, 0x1b,
	0x32, 0xc3, 0xe7, 0x5f, 0x54, 0x82, 0x9b, 0x47, 0x9d, 0x7a, 0xa3, 0x65, 0x75, 0x3f, 0x3b, 0x6e,
	0x58, 0x27, 0x6d, 0xf3, 0xb8, 0x51, 0x6b, 0x7e, 0xdc, 0x6c, 0xd4, 0xf3, 0x0b, 0x68, 0x1b, 0x0a,
	0xad, 0x66, 0xbb, 0x51, 0x35, 0x2c, 0xa3, 0xf1, 0xc8, 0x68, 0x98, 0x66, 0xb3, 0xd3, 0xce, 0xa7,
	0xd0, 0x37, 0x60, 0xab, 0xd5, 0x79, 0xd4, 0x34, 0xbb, 0xcd, 0xda, 0xf8, 0xc4, 0x22, 0x02, 0x58,
	0xf9, 0xc9, 0x51, 0xa3, 0xda, 0x36, 0xf3, 0xe9, 0x72, 0x07, 0xd6, 0xe2, 0xc3, 0x13, 0xdd, 0x82,
	0xed, 0x56, 0xc7, 0x34, 0xaf, 0x58, 0x42, 0x4a, 0x58, 0xe6, 0xe3, 0x93, 0xaa, 0xd1, 0xa8, 0x5b,
	0x92, 0x2f, 0x9f, 0x42, 0x05, 0xd8, 0x50, 0xe4, 0x56, 0xe7, 0x51, 0x44, 0x5a, 0x2c, 0x1f, 0xc2,
	0xfa, 0x78, 0xf6, 0xa2, 0xbb, 0x70, 0xab, 0xde, 0x34, 0xbb, 0xd5, 0x76, 0xad, 0x71, 0x19, 0xf0,
	0x06, 0x64, 0x1a, 0x27, 0xb5, 0x56, 0xb3, 0xde, 0xa8, 0x4a, 0x9d, 0x01, 0x56, 0x6a, 0x1d, 0xb3,
	0xd9, 0x6e, 0xe4, 0x17, 0xcb, 0xcf, 0x21, 0x37, 0x55, 0xdb, 0xd1, 0xeb, 0x70, 0xb7, 0x5e, 0xed,
	0x56, 0x2d, 0xf3, 0xb8, 0xd5, 0xec, 0x5a, 0x47, 0x8d, 0xee, 0x61, 0xa7, 0x3e, 0x05, 0x08, 0xb0,
	0x62, 0x54, 0xdb, 0xf5, 0xce, 0x91, 0x46, 0x3b, 0x31, 0xbb, 0x9d, 0xa3, 0xfc, 0x22, 0xda, 0x04,
	0x30, 0x1b, 0x8f, 0x4f, 0x1a, 0xed, 0x6e, 0xb3, 0xda, 0xca, 0xa7, 0xd1, 0x3a, 0xac, 0xb5, 0x3b,
	0x11, 0x50, 0x7e, 0x49, 0xce, 0x56, 0x4f, 0xba, 0xf1, 0x78, 0xb9, 0xfc, 0x29, 0x14, 0x66, 0x6a,
	0x32, 0x7a, 0x03, 0xee, 0xb5, 0x1a, 0x55, 0xa3, 0x6d, 0x19, 0xd5, 0x6e, 0xc3, 0x32, 0xbb, 0xf2,
	0xdf, 0xa3, 0xcf, 0xa6, 0xd6, 0xcf, 0x41, 0x56, 0x6e, 0x86, 0x65, 0x36, 0xaa, 0x46, 0xed, 0x30,
	0x9f, 0x92, 0x0b, 0xd5, 0x3a, 0x6d, 0xe9, 0x81, 0x6e, 0x7e, 0xb1, 0xfc, 0x39, 0xe4, 0x1e, 0x11,
	0xa1, 0x7f, 0x4e, 0x79, 0x1a, 0x12, 0x2e, 0x64, 0x96, 0x0d, 0x58, 0xf0, 0x39, 0xb1, 0x45, 0x1c,
	0xc7, 0x19, 0x23, 0xa3, 0x29, 0x4d, 0x47, 0x4e, 0xcb, 0xc3, 0x86, 0x13, 0x35, 0x1d, 0x45, 0x49,
	0x46, 0x53, 0x9a, 0x0e, 0xba, 0x05, 0x6b, 0xd1, 0xcf, 0x0a, 0xd4, 0x51, 0xc1, 0x99, 0x31, 0x56,
	0xd5, 0xb8, 0xe9, 0x94, 0xff, 0x9c, 0x82, 0xc2, 0x31, 0x16, 0xf6, 0x93, 0xaf, 0x65, 0x39, 0xf4,
	0x2e, 0x2c, 0xab, 0x4f, 0x5d, 0xe3, 0xee, 0xcd, 0xfb, 0x35, 0x29, 0xe2, 0x2e, 0x7b, 0x80, 0xea,
	0xc4, 0x25, 0x82, 0x7c, 0x3d, 0x4e, 0xf9, 0x4b, 0x0a, 0x0a, 0x2d, 0xca, 0xa3, 0x2d, 0xe0, 0xaf,
	0x66, 0xb9, 0x1f, 0x40, 0x56, 0x76, 0xb6, 0x71, 0xab, 0x7e, 0xd5, 0xb3, 0xf3, 0xc9, 0xd8, 0xe9,
	0x00, 0x1e, 0x3e, 0x37, 0x74, 0x3b, 0x2e, 0x17, 0xc7, 0x7d, 0x62, 0x89, 0xe0, 0x0b, 0x12, 0x35,
	0xa1, 0x72, 0x71, 0xdc, 0x27, 0x5d, 0x49, 0x28, 0x87, 0x80, 0xc6, 0x15, 0xe6, 0x83, 0xc0, 0xe7,
	0x04, 0xbd, 0x07, 0x2b, 0xca, 0x24, 0xd9, 0x45, 0xa7, 0x93, 0xb8, 0x5b, 0xb3, 0xa3, 0x6f, 0x43,
	0xce, 0x27, 0xe7, 0xc2, 0x1a, 0x5b, 0x32, 0x32, 0x68, 0x43, 0x92, 0x8f, 0xe3, 0x65, 0xf7, 0xbf,
	0x4c, 0xc3, 0xba, 0x92, 0x34, 0x09, 0x7b, 0x46, 0x6d, 0x82, 0x7e, 0x0a, 0x6b, 0x71, 0xe8, 0xa2,
	0x6b, 0x7e, 0xb8, 0x9a, 0x0a, 0xef, 0xd2, 0x3c, 0xc5, 0xca, 0x0b, 0x88, 0x02, 0x8c, 0x2c, 0x44,
	0xd7, 0xfc, 0x8e, 0x35, 0xb3, 0x71, 0xa5, 0xfb, 0xc9, 0x98, 0x23, 0xa7, 0x95, 0x17, 0xd0, 0x2f,
	0x00, 0x46, 0x29, 0x71, 0xdd, 0x52, 0x33, 0x89, 0x93, 0xc4, 0x90, 0x13, 0xc8, 0x8e, 0xc5, 0x32,
	0xba, 0x46, 0xb9, 0xd9, 0x90, 0x2f, 0xdd, 0x9c, 0x09, 0x98, 0x86, 0x37, 0x10, 0x17, 0xe5, 0x85,
	0x03, 0x17, 0xee, 0xd8, 0x81, 0x77, 0x25, 0xd8, 0x01, 0x28, 0x9c, 0x63, 0x29, 0xf6, 0xb3, 0x1f,
	0x69, 0xae, 0x7e, 0xe0, 0x62, 0xbf, 0x5f, 0x09, 0x58, 0x7f, 0xaf, 0x4f, 0x7c, 0x05, 0xb9, 0x17,
	0x4d, 0xe1, 0x01, 0xe5, 0xb3, 0xbf, 0x61, 0x7f, 0x18, 0x7f, 0x9f, 0xae, 0x28, 0xe6, 0xb7, 0xff,
	0x1b, 0x00, 0x00, 0xff, 0xff, 0x3e, 0x46, 0x69, 0xef, 0x5f, 0x1f, 0x00, 0x00,
}
