// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/api/console/v1"
	scheme "github.com/openshift/client-go/console/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ConsoleLinksGetter has a method to return a ConsoleLinkInterface.
// A group's client should implement this interface.
type ConsoleLinksGetter interface {
	ConsoleLinks() ConsoleLinkInterface
}

// ConsoleLinkInterface has methods to work with ConsoleLink resources.
type ConsoleLinkInterface interface {
	Create(*v1.ConsoleLink) (*v1.ConsoleLink, error)
	Update(*v1.ConsoleLink) (*v1.ConsoleLink, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.ConsoleLink, error)
	List(opts metav1.ListOptions) (*v1.ConsoleLinkList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.ConsoleLink, err error)
	ConsoleLinkExpansion
}

// consoleLinks implements ConsoleLinkInterface
type consoleLinks struct {
	client rest.Interface
}

// newConsoleLinks returns a ConsoleLinks
func newConsoleLinks(c *ConsoleV1Client) *consoleLinks {
	return &consoleLinks{
		client: c.RESTClient(),
	}
}

// Get takes name of the consoleLink, and returns the corresponding consoleLink object, and an error if there is any.
func (c *consoleLinks) Get(name string, options metav1.GetOptions) (result *v1.ConsoleLink, err error) {
	result = &v1.ConsoleLink{}
	err = c.client.Get().
		Resource("consolelinks").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ConsoleLinks that match those selectors.
func (c *consoleLinks) List(opts metav1.ListOptions) (result *v1.ConsoleLinkList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ConsoleLinkList{}
	err = c.client.Get().
		Resource("consolelinks").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested consoleLinks.
func (c *consoleLinks) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("consolelinks").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a consoleLink and creates it.  Returns the server's representation of the consoleLink, and an error, if there is any.
func (c *consoleLinks) Create(consoleLink *v1.ConsoleLink) (result *v1.ConsoleLink, err error) {
	result = &v1.ConsoleLink{}
	err = c.client.Post().
		Resource("consolelinks").
		Body(consoleLink).
		Do().
		Into(result)
	return
}

// Update takes the representation of a consoleLink and updates it. Returns the server's representation of the consoleLink, and an error, if there is any.
func (c *consoleLinks) Update(consoleLink *v1.ConsoleLink) (result *v1.ConsoleLink, err error) {
	result = &v1.ConsoleLink{}
	err = c.client.Put().
		Resource("consolelinks").
		Name(consoleLink.Name).
		Body(consoleLink).
		Do().
		Into(result)
	return
}

// Delete takes name of the consoleLink and deletes it. Returns an error if one occurs.
func (c *consoleLinks) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("consolelinks").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *consoleLinks) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("consolelinks").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched consoleLink.
func (c *consoleLinks) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.ConsoleLink, err error) {
	result = &v1.ConsoleLink{}
	err = c.client.Patch(pt).
		Resource("consolelinks").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
