// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/api/operator/v1"
	scheme "github.com/openshift/client-go/operator/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// KubeStorageVersionMigratorsGetter has a method to return a KubeStorageVersionMigratorInterface.
// A group's client should implement this interface.
type KubeStorageVersionMigratorsGetter interface {
	KubeStorageVersionMigrators() KubeStorageVersionMigratorInterface
}

// KubeStorageVersionMigratorInterface has methods to work with KubeStorageVersionMigrator resources.
type KubeStorageVersionMigratorInterface interface {
	Create(*v1.KubeStorageVersionMigrator) (*v1.KubeStorageVersionMigrator, error)
	Update(*v1.KubeStorageVersionMigrator) (*v1.KubeStorageVersionMigrator, error)
	UpdateStatus(*v1.KubeStorageVersionMigrator) (*v1.KubeStorageVersionMigrator, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.KubeStorageVersionMigrator, error)
	List(opts metav1.ListOptions) (*v1.KubeStorageVersionMigratorList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.KubeStorageVersionMigrator, err error)
	KubeStorageVersionMigratorExpansion
}

// kubeStorageVersionMigrators implements KubeStorageVersionMigratorInterface
type kubeStorageVersionMigrators struct {
	client rest.Interface
}

// newKubeStorageVersionMigrators returns a KubeStorageVersionMigrators
func newKubeStorageVersionMigrators(c *OperatorV1Client) *kubeStorageVersionMigrators {
	return &kubeStorageVersionMigrators{
		client: c.RESTClient(),
	}
}

// Get takes name of the kubeStorageVersionMigrator, and returns the corresponding kubeStorageVersionMigrator object, and an error if there is any.
func (c *kubeStorageVersionMigrators) Get(name string, options metav1.GetOptions) (result *v1.KubeStorageVersionMigrator, err error) {
	result = &v1.KubeStorageVersionMigrator{}
	err = c.client.Get().
		Resource("kubestorageversionmigrators").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of KubeStorageVersionMigrators that match those selectors.
func (c *kubeStorageVersionMigrators) List(opts metav1.ListOptions) (result *v1.KubeStorageVersionMigratorList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.KubeStorageVersionMigratorList{}
	err = c.client.Get().
		Resource("kubestorageversionmigrators").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested kubeStorageVersionMigrators.
func (c *kubeStorageVersionMigrators) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("kubestorageversionmigrators").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a kubeStorageVersionMigrator and creates it.  Returns the server's representation of the kubeStorageVersionMigrator, and an error, if there is any.
func (c *kubeStorageVersionMigrators) Create(kubeStorageVersionMigrator *v1.KubeStorageVersionMigrator) (result *v1.KubeStorageVersionMigrator, err error) {
	result = &v1.KubeStorageVersionMigrator{}
	err = c.client.Post().
		Resource("kubestorageversionmigrators").
		Body(kubeStorageVersionMigrator).
		Do().
		Into(result)
	return
}

// Update takes the representation of a kubeStorageVersionMigrator and updates it. Returns the server's representation of the kubeStorageVersionMigrator, and an error, if there is any.
func (c *kubeStorageVersionMigrators) Update(kubeStorageVersionMigrator *v1.KubeStorageVersionMigrator) (result *v1.KubeStorageVersionMigrator, err error) {
	result = &v1.KubeStorageVersionMigrator{}
	err = c.client.Put().
		Resource("kubestorageversionmigrators").
		Name(kubeStorageVersionMigrator.Name).
		Body(kubeStorageVersionMigrator).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *kubeStorageVersionMigrators) UpdateStatus(kubeStorageVersionMigrator *v1.KubeStorageVersionMigrator) (result *v1.KubeStorageVersionMigrator, err error) {
	result = &v1.KubeStorageVersionMigrator{}
	err = c.client.Put().
		Resource("kubestorageversionmigrators").
		Name(kubeStorageVersionMigrator.Name).
		SubResource("status").
		Body(kubeStorageVersionMigrator).
		Do().
		Into(result)
	return
}

// Delete takes name of the kubeStorageVersionMigrator and deletes it. Returns an error if one occurs.
func (c *kubeStorageVersionMigrators) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("kubestorageversionmigrators").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *kubeStorageVersionMigrators) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("kubestorageversionmigrators").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched kubeStorageVersionMigrator.
func (c *kubeStorageVersionMigrators) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.KubeStorageVersionMigrator, err error) {
	result = &v1.KubeStorageVersionMigrator{}
	err = c.client.Patch(pt).
		Resource("kubestorageversionmigrators").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
