package infrastructureinsights

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// ResourceHealthsClient is the infrastructureInsights Admin Client
type ResourceHealthsClient struct {
	BaseClient
}

// NewResourceHealthsClient creates an instance of the ResourceHealthsClient client.
func NewResourceHealthsClient(subscriptionID string) ResourceHealthsClient {
	return NewResourceHealthsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewResourceHealthsClientWithBaseURI creates an instance of the ResourceHealthsClient client.
func NewResourceHealthsClientWithBaseURI(baseURI string, subscriptionID string) ResourceHealthsClient {
	return ResourceHealthsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get get health information about a resources.
//
// location is location name. serviceRegistrationID is service registration id. resourceRegistrationID is resource
// registration id. filter is oData filter parameter.
func (client ResourceHealthsClient) Get(ctx context.Context, location string, serviceRegistrationID string, resourceRegistrationID string, filter string) (result ResourceHealth, err error) {
	req, err := client.GetPreparer(ctx, location, serviceRegistrationID, resourceRegistrationID, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "infrastructureinsights.ResourceHealthsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "infrastructureinsights.ResourceHealthsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "infrastructureinsights.ResourceHealthsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ResourceHealthsClient) GetPreparer(ctx context.Context, location string, serviceRegistrationID string, resourceRegistrationID string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":               autorest.Encode("path", location),
		"resourceRegistrationId": autorest.Encode("path", resourceRegistrationID),
		"serviceRegistrationId":  autorest.Encode("path", serviceRegistrationID),
		"subscriptionId":         autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/System.{location}/providers/Microsoft.InfrastructureInsights.Admin/regionHealths/{location}/serviceHealths/{serviceRegistrationId}/resourceHealths/{resourceRegistrationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceHealthsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ResourceHealthsClient) GetResponder(resp *http.Response) (result ResourceHealth, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List get a list of resources?.
//
// location is location name. serviceRegistrationID is service registration id. filter is oData filter parameter.
func (client ResourceHealthsClient) List(ctx context.Context, location string, serviceRegistrationID string, filter string) (result ResourceHealthListPage, err error) {
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, location, serviceRegistrationID, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "infrastructureinsights.ResourceHealthsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.rhl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "infrastructureinsights.ResourceHealthsClient", "List", resp, "Failure sending request")
		return
	}

	result.rhl, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "infrastructureinsights.ResourceHealthsClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client ResourceHealthsClient) ListPreparer(ctx context.Context, location string, serviceRegistrationID string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":              autorest.Encode("path", location),
		"serviceRegistrationId": autorest.Encode("path", serviceRegistrationID),
		"subscriptionId":        autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/System.{location}/providers/Microsoft.InfrastructureInsights.Admin/regionHealths/{location}/serviceHealths/{serviceRegistrationId}/resourceHealths", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceHealthsClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client ResourceHealthsClient) ListResponder(resp *http.Response) (result ResourceHealthList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client ResourceHealthsClient) listNextResults(lastResults ResourceHealthList) (result ResourceHealthList, err error) {
	req, err := lastResults.resourceHealthListPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "infrastructureinsights.ResourceHealthsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "infrastructureinsights.ResourceHealthsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "infrastructureinsights.ResourceHealthsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client ResourceHealthsClient) ListComplete(ctx context.Context, location string, serviceRegistrationID string, filter string) (result ResourceHealthListIterator, err error) {
	result.page, err = client.List(ctx, location, serviceRegistrationID, filter)
	return
}
