package filesystem

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"io"
)

// AppendModeType enumerates the values for append mode type.
type AppendModeType string

const (
	// Autocreate ...
	Autocreate AppendModeType = "autocreate"
)

// Exception enumerates the values for exception.
type Exception string

const (
	// ExceptionAccessControlException ...
	ExceptionAccessControlException Exception = "AccessControlException"
	// ExceptionAdlsRemoteException ...
	ExceptionAdlsRemoteException Exception = "AdlsRemoteException"
	// ExceptionBadOffsetException ...
	ExceptionBadOffsetException Exception = "BadOffsetException"
	// ExceptionFileAlreadyExistsException ...
	ExceptionFileAlreadyExistsException Exception = "FileAlreadyExistsException"
	// ExceptionFileNotFoundException ...
	ExceptionFileNotFoundException Exception = "FileNotFoundException"
	// ExceptionIllegalArgumentException ...
	ExceptionIllegalArgumentException Exception = "IllegalArgumentException"
	// ExceptionIOException ...
	ExceptionIOException Exception = "IOException"
	// ExceptionRuntimeException ...
	ExceptionRuntimeException Exception = "RuntimeException"
	// ExceptionSecurityException ...
	ExceptionSecurityException Exception = "SecurityException"
	// ExceptionUnsupportedOperationException ...
	ExceptionUnsupportedOperationException Exception = "UnsupportedOperationException"
)

// ExpiryOptionType enumerates the values for expiry option type.
type ExpiryOptionType string

const (
	// Absolute ...
	Absolute ExpiryOptionType = "Absolute"
	// NeverExpire ...
	NeverExpire ExpiryOptionType = "NeverExpire"
	// RelativeToCreationDate ...
	RelativeToCreationDate ExpiryOptionType = "RelativeToCreationDate"
	// RelativeToNow ...
	RelativeToNow ExpiryOptionType = "RelativeToNow"
)

// FileType enumerates the values for file type.
type FileType string

const (
	// DIRECTORY ...
	DIRECTORY FileType = "DIRECTORY"
	// FILE ...
	FILE FileType = "FILE"
)

// ACLStatus data Lake Store file or directory Access Control List information.
type ACLStatus struct {
	// Entries - the list of ACLSpec entries on a file or directory.
	Entries *[]string `json:"entries,omitempty"`
	// Group - the group owner, an AAD Object ID.
	Group *string `json:"group,omitempty"`
	// Owner - the user owner, an AAD Object ID.
	Owner *string `json:"owner,omitempty"`
	// Permission - The octal representation of the unnamed user, mask and other permissions.
	Permission *int32 `json:"permission,omitempty"`
	// StickyBit - the indicator of whether the sticky bit is on or off.
	StickyBit *bool `json:"stickyBit,omitempty"`
}

// ACLStatusResult data Lake Store file or directory Access Control List information.
type ACLStatusResult struct {
	autorest.Response `json:"-"`
	// ACLStatus - the AclStatus object for a given file or directory.
	ACLStatus *ACLStatus `json:"AclStatus,omitempty"`
}

// AdlsAccessControlException a WebHDFS exception thrown indicating that access is denied due to insufficient
// permissions. Thrown when a 403 error response code is returned (forbidden).
type AdlsAccessControlException struct {
	// JavaClassName - the full class package name for the exception thrown, such as 'java.lang.IllegalArgumentException'.
	JavaClassName *string `json:"javaClassName,omitempty"`
	// Message - the message associated with the exception that was thrown, such as 'Invalid value for webhdfs parameter "permission":...'.
	Message *string `json:"message,omitempty"`
	// Exception - Possible values include: 'ExceptionAdlsRemoteException', 'ExceptionIllegalArgumentException', 'ExceptionUnsupportedOperationException', 'ExceptionSecurityException', 'ExceptionIOException', 'ExceptionFileNotFoundException', 'ExceptionFileAlreadyExistsException', 'ExceptionBadOffsetException', 'ExceptionRuntimeException', 'ExceptionAccessControlException'
	Exception Exception `json:"exception,omitempty"`
}

// MarshalJSON is the custom marshaler for AdlsAccessControlException.
func (aace AdlsAccessControlException) MarshalJSON() ([]byte, error) {
	aace.Exception = ExceptionAccessControlException
	objectMap := make(map[string]interface{})
	if aace.JavaClassName != nil {
		objectMap["javaClassName"] = aace.JavaClassName
	}
	if aace.Message != nil {
		objectMap["message"] = aace.Message
	}
	objectMap["exception"] = aace.Exception
	return json.Marshal(objectMap)
}

// AsAdlsIllegalArgumentException is the BasicAdlsRemoteException implementation for AdlsAccessControlException.
func (aace AdlsAccessControlException) AsAdlsIllegalArgumentException() (*AdlsIllegalArgumentException, bool) {
	return nil, false
}

// AsAdlsUnsupportedOperationException is the BasicAdlsRemoteException implementation for AdlsAccessControlException.
func (aace AdlsAccessControlException) AsAdlsUnsupportedOperationException() (*AdlsUnsupportedOperationException, bool) {
	return nil, false
}

// AsAdlsSecurityException is the BasicAdlsRemoteException implementation for AdlsAccessControlException.
func (aace AdlsAccessControlException) AsAdlsSecurityException() (*AdlsSecurityException, bool) {
	return nil, false
}

// AsAdlsIOException is the BasicAdlsRemoteException implementation for AdlsAccessControlException.
func (aace AdlsAccessControlException) AsAdlsIOException() (*AdlsIOException, bool) {
	return nil, false
}

// AsAdlsFileNotFoundException is the BasicAdlsRemoteException implementation for AdlsAccessControlException.
func (aace AdlsAccessControlException) AsAdlsFileNotFoundException() (*AdlsFileNotFoundException, bool) {
	return nil, false
}

// AsAdlsFileAlreadyExistsException is the BasicAdlsRemoteException implementation for AdlsAccessControlException.
func (aace AdlsAccessControlException) AsAdlsFileAlreadyExistsException() (*AdlsFileAlreadyExistsException, bool) {
	return nil, false
}

// AsAdlsBadOffsetException is the BasicAdlsRemoteException implementation for AdlsAccessControlException.
func (aace AdlsAccessControlException) AsAdlsBadOffsetException() (*AdlsBadOffsetException, bool) {
	return nil, false
}

// AsAdlsRuntimeException is the BasicAdlsRemoteException implementation for AdlsAccessControlException.
func (aace AdlsAccessControlException) AsAdlsRuntimeException() (*AdlsRuntimeException, bool) {
	return nil, false
}

// AsAdlsAccessControlException is the BasicAdlsRemoteException implementation for AdlsAccessControlException.
func (aace AdlsAccessControlException) AsAdlsAccessControlException() (*AdlsAccessControlException, bool) {
	return &aace, true
}

// AsAdlsRemoteException is the BasicAdlsRemoteException implementation for AdlsAccessControlException.
func (aace AdlsAccessControlException) AsAdlsRemoteException() (*AdlsRemoteException, bool) {
	return nil, false
}

// AsBasicAdlsRemoteException is the BasicAdlsRemoteException implementation for AdlsAccessControlException.
func (aace AdlsAccessControlException) AsBasicAdlsRemoteException() (BasicAdlsRemoteException, bool) {
	return &aace, true
}

// AdlsBadOffsetException a WebHDFS exception thrown indicating the append or read is from a bad offset. Thrown
// when a 400 error response code is returned for append and open operations (Bad request).
type AdlsBadOffsetException struct {
	// JavaClassName - the full class package name for the exception thrown, such as 'java.lang.IllegalArgumentException'.
	JavaClassName *string `json:"javaClassName,omitempty"`
	// Message - the message associated with the exception that was thrown, such as 'Invalid value for webhdfs parameter "permission":...'.
	Message *string `json:"message,omitempty"`
	// Exception - Possible values include: 'ExceptionAdlsRemoteException', 'ExceptionIllegalArgumentException', 'ExceptionUnsupportedOperationException', 'ExceptionSecurityException', 'ExceptionIOException', 'ExceptionFileNotFoundException', 'ExceptionFileAlreadyExistsException', 'ExceptionBadOffsetException', 'ExceptionRuntimeException', 'ExceptionAccessControlException'
	Exception Exception `json:"exception,omitempty"`
}

// MarshalJSON is the custom marshaler for AdlsBadOffsetException.
func (aboe AdlsBadOffsetException) MarshalJSON() ([]byte, error) {
	aboe.Exception = ExceptionBadOffsetException
	objectMap := make(map[string]interface{})
	if aboe.JavaClassName != nil {
		objectMap["javaClassName"] = aboe.JavaClassName
	}
	if aboe.Message != nil {
		objectMap["message"] = aboe.Message
	}
	objectMap["exception"] = aboe.Exception
	return json.Marshal(objectMap)
}

// AsAdlsIllegalArgumentException is the BasicAdlsRemoteException implementation for AdlsBadOffsetException.
func (aboe AdlsBadOffsetException) AsAdlsIllegalArgumentException() (*AdlsIllegalArgumentException, bool) {
	return nil, false
}

// AsAdlsUnsupportedOperationException is the BasicAdlsRemoteException implementation for AdlsBadOffsetException.
func (aboe AdlsBadOffsetException) AsAdlsUnsupportedOperationException() (*AdlsUnsupportedOperationException, bool) {
	return nil, false
}

// AsAdlsSecurityException is the BasicAdlsRemoteException implementation for AdlsBadOffsetException.
func (aboe AdlsBadOffsetException) AsAdlsSecurityException() (*AdlsSecurityException, bool) {
	return nil, false
}

// AsAdlsIOException is the BasicAdlsRemoteException implementation for AdlsBadOffsetException.
func (aboe AdlsBadOffsetException) AsAdlsIOException() (*AdlsIOException, bool) {
	return nil, false
}

// AsAdlsFileNotFoundException is the BasicAdlsRemoteException implementation for AdlsBadOffsetException.
func (aboe AdlsBadOffsetException) AsAdlsFileNotFoundException() (*AdlsFileNotFoundException, bool) {
	return nil, false
}

// AsAdlsFileAlreadyExistsException is the BasicAdlsRemoteException implementation for AdlsBadOffsetException.
func (aboe AdlsBadOffsetException) AsAdlsFileAlreadyExistsException() (*AdlsFileAlreadyExistsException, bool) {
	return nil, false
}

// AsAdlsBadOffsetException is the BasicAdlsRemoteException implementation for AdlsBadOffsetException.
func (aboe AdlsBadOffsetException) AsAdlsBadOffsetException() (*AdlsBadOffsetException, bool) {
	return &aboe, true
}

// AsAdlsRuntimeException is the BasicAdlsRemoteException implementation for AdlsBadOffsetException.
func (aboe AdlsBadOffsetException) AsAdlsRuntimeException() (*AdlsRuntimeException, bool) {
	return nil, false
}

// AsAdlsAccessControlException is the BasicAdlsRemoteException implementation for AdlsBadOffsetException.
func (aboe AdlsBadOffsetException) AsAdlsAccessControlException() (*AdlsAccessControlException, bool) {
	return nil, false
}

// AsAdlsRemoteException is the BasicAdlsRemoteException implementation for AdlsBadOffsetException.
func (aboe AdlsBadOffsetException) AsAdlsRemoteException() (*AdlsRemoteException, bool) {
	return nil, false
}

// AsBasicAdlsRemoteException is the BasicAdlsRemoteException implementation for AdlsBadOffsetException.
func (aboe AdlsBadOffsetException) AsBasicAdlsRemoteException() (BasicAdlsRemoteException, bool) {
	return &aboe, true
}

// AdlsError data Lake Store filesystem error containing a specific WebHDFS exception.
type AdlsError struct {
	// RemoteException - the object representing the actual WebHDFS exception being returned.
	RemoteException BasicAdlsRemoteException `json:"RemoteException,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for AdlsError struct.
func (ae *AdlsError) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "RemoteException":
			if v != nil {
				remoteException, err := unmarshalBasicAdlsRemoteException(*v)
				if err != nil {
					return err
				}
				ae.RemoteException = remoteException
			}
		}
	}

	return nil
}

// AdlsFileAlreadyExistsException a WebHDFS exception thrown indicating the file or folder already exists. Thrown
// when a 403 error response code is returned (forbidden).
type AdlsFileAlreadyExistsException struct {
	// JavaClassName - the full class package name for the exception thrown, such as 'java.lang.IllegalArgumentException'.
	JavaClassName *string `json:"javaClassName,omitempty"`
	// Message - the message associated with the exception that was thrown, such as 'Invalid value for webhdfs parameter "permission":...'.
	Message *string `json:"message,omitempty"`
	// Exception - Possible values include: 'ExceptionAdlsRemoteException', 'ExceptionIllegalArgumentException', 'ExceptionUnsupportedOperationException', 'ExceptionSecurityException', 'ExceptionIOException', 'ExceptionFileNotFoundException', 'ExceptionFileAlreadyExistsException', 'ExceptionBadOffsetException', 'ExceptionRuntimeException', 'ExceptionAccessControlException'
	Exception Exception `json:"exception,omitempty"`
}

// MarshalJSON is the custom marshaler for AdlsFileAlreadyExistsException.
func (afaee AdlsFileAlreadyExistsException) MarshalJSON() ([]byte, error) {
	afaee.Exception = ExceptionFileAlreadyExistsException
	objectMap := make(map[string]interface{})
	if afaee.JavaClassName != nil {
		objectMap["javaClassName"] = afaee.JavaClassName
	}
	if afaee.Message != nil {
		objectMap["message"] = afaee.Message
	}
	objectMap["exception"] = afaee.Exception
	return json.Marshal(objectMap)
}

// AsAdlsIllegalArgumentException is the BasicAdlsRemoteException implementation for AdlsFileAlreadyExistsException.
func (afaee AdlsFileAlreadyExistsException) AsAdlsIllegalArgumentException() (*AdlsIllegalArgumentException, bool) {
	return nil, false
}

// AsAdlsUnsupportedOperationException is the BasicAdlsRemoteException implementation for AdlsFileAlreadyExistsException.
func (afaee AdlsFileAlreadyExistsException) AsAdlsUnsupportedOperationException() (*AdlsUnsupportedOperationException, bool) {
	return nil, false
}

// AsAdlsSecurityException is the BasicAdlsRemoteException implementation for AdlsFileAlreadyExistsException.
func (afaee AdlsFileAlreadyExistsException) AsAdlsSecurityException() (*AdlsSecurityException, bool) {
	return nil, false
}

// AsAdlsIOException is the BasicAdlsRemoteException implementation for AdlsFileAlreadyExistsException.
func (afaee AdlsFileAlreadyExistsException) AsAdlsIOException() (*AdlsIOException, bool) {
	return nil, false
}

// AsAdlsFileNotFoundException is the BasicAdlsRemoteException implementation for AdlsFileAlreadyExistsException.
func (afaee AdlsFileAlreadyExistsException) AsAdlsFileNotFoundException() (*AdlsFileNotFoundException, bool) {
	return nil, false
}

// AsAdlsFileAlreadyExistsException is the BasicAdlsRemoteException implementation for AdlsFileAlreadyExistsException.
func (afaee AdlsFileAlreadyExistsException) AsAdlsFileAlreadyExistsException() (*AdlsFileAlreadyExistsException, bool) {
	return &afaee, true
}

// AsAdlsBadOffsetException is the BasicAdlsRemoteException implementation for AdlsFileAlreadyExistsException.
func (afaee AdlsFileAlreadyExistsException) AsAdlsBadOffsetException() (*AdlsBadOffsetException, bool) {
	return nil, false
}

// AsAdlsRuntimeException is the BasicAdlsRemoteException implementation for AdlsFileAlreadyExistsException.
func (afaee AdlsFileAlreadyExistsException) AsAdlsRuntimeException() (*AdlsRuntimeException, bool) {
	return nil, false
}

// AsAdlsAccessControlException is the BasicAdlsRemoteException implementation for AdlsFileAlreadyExistsException.
func (afaee AdlsFileAlreadyExistsException) AsAdlsAccessControlException() (*AdlsAccessControlException, bool) {
	return nil, false
}

// AsAdlsRemoteException is the BasicAdlsRemoteException implementation for AdlsFileAlreadyExistsException.
func (afaee AdlsFileAlreadyExistsException) AsAdlsRemoteException() (*AdlsRemoteException, bool) {
	return nil, false
}

// AsBasicAdlsRemoteException is the BasicAdlsRemoteException implementation for AdlsFileAlreadyExistsException.
func (afaee AdlsFileAlreadyExistsException) AsBasicAdlsRemoteException() (BasicAdlsRemoteException, bool) {
	return &afaee, true
}

// AdlsFileNotFoundException a WebHDFS exception thrown indicating the file or folder could not be found. Thrown
// when a 404 error response code is returned (not found).
type AdlsFileNotFoundException struct {
	// JavaClassName - the full class package name for the exception thrown, such as 'java.lang.IllegalArgumentException'.
	JavaClassName *string `json:"javaClassName,omitempty"`
	// Message - the message associated with the exception that was thrown, such as 'Invalid value for webhdfs parameter "permission":...'.
	Message *string `json:"message,omitempty"`
	// Exception - Possible values include: 'ExceptionAdlsRemoteException', 'ExceptionIllegalArgumentException', 'ExceptionUnsupportedOperationException', 'ExceptionSecurityException', 'ExceptionIOException', 'ExceptionFileNotFoundException', 'ExceptionFileAlreadyExistsException', 'ExceptionBadOffsetException', 'ExceptionRuntimeException', 'ExceptionAccessControlException'
	Exception Exception `json:"exception,omitempty"`
}

// MarshalJSON is the custom marshaler for AdlsFileNotFoundException.
func (afnfe AdlsFileNotFoundException) MarshalJSON() ([]byte, error) {
	afnfe.Exception = ExceptionFileNotFoundException
	objectMap := make(map[string]interface{})
	if afnfe.JavaClassName != nil {
		objectMap["javaClassName"] = afnfe.JavaClassName
	}
	if afnfe.Message != nil {
		objectMap["message"] = afnfe.Message
	}
	objectMap["exception"] = afnfe.Exception
	return json.Marshal(objectMap)
}

// AsAdlsIllegalArgumentException is the BasicAdlsRemoteException implementation for AdlsFileNotFoundException.
func (afnfe AdlsFileNotFoundException) AsAdlsIllegalArgumentException() (*AdlsIllegalArgumentException, bool) {
	return nil, false
}

// AsAdlsUnsupportedOperationException is the BasicAdlsRemoteException implementation for AdlsFileNotFoundException.
func (afnfe AdlsFileNotFoundException) AsAdlsUnsupportedOperationException() (*AdlsUnsupportedOperationException, bool) {
	return nil, false
}

// AsAdlsSecurityException is the BasicAdlsRemoteException implementation for AdlsFileNotFoundException.
func (afnfe AdlsFileNotFoundException) AsAdlsSecurityException() (*AdlsSecurityException, bool) {
	return nil, false
}

// AsAdlsIOException is the BasicAdlsRemoteException implementation for AdlsFileNotFoundException.
func (afnfe AdlsFileNotFoundException) AsAdlsIOException() (*AdlsIOException, bool) {
	return nil, false
}

// AsAdlsFileNotFoundException is the BasicAdlsRemoteException implementation for AdlsFileNotFoundException.
func (afnfe AdlsFileNotFoundException) AsAdlsFileNotFoundException() (*AdlsFileNotFoundException, bool) {
	return &afnfe, true
}

// AsAdlsFileAlreadyExistsException is the BasicAdlsRemoteException implementation for AdlsFileNotFoundException.
func (afnfe AdlsFileNotFoundException) AsAdlsFileAlreadyExistsException() (*AdlsFileAlreadyExistsException, bool) {
	return nil, false
}

// AsAdlsBadOffsetException is the BasicAdlsRemoteException implementation for AdlsFileNotFoundException.
func (afnfe AdlsFileNotFoundException) AsAdlsBadOffsetException() (*AdlsBadOffsetException, bool) {
	return nil, false
}

// AsAdlsRuntimeException is the BasicAdlsRemoteException implementation for AdlsFileNotFoundException.
func (afnfe AdlsFileNotFoundException) AsAdlsRuntimeException() (*AdlsRuntimeException, bool) {
	return nil, false
}

// AsAdlsAccessControlException is the BasicAdlsRemoteException implementation for AdlsFileNotFoundException.
func (afnfe AdlsFileNotFoundException) AsAdlsAccessControlException() (*AdlsAccessControlException, bool) {
	return nil, false
}

// AsAdlsRemoteException is the BasicAdlsRemoteException implementation for AdlsFileNotFoundException.
func (afnfe AdlsFileNotFoundException) AsAdlsRemoteException() (*AdlsRemoteException, bool) {
	return nil, false
}

// AsBasicAdlsRemoteException is the BasicAdlsRemoteException implementation for AdlsFileNotFoundException.
func (afnfe AdlsFileNotFoundException) AsBasicAdlsRemoteException() (BasicAdlsRemoteException, bool) {
	return &afnfe, true
}

// AdlsIllegalArgumentException a WebHDFS exception thrown indicating that one more arguments is incorrect. Thrown
// when a 400 error response code is returned (bad request).
type AdlsIllegalArgumentException struct {
	// JavaClassName - the full class package name for the exception thrown, such as 'java.lang.IllegalArgumentException'.
	JavaClassName *string `json:"javaClassName,omitempty"`
	// Message - the message associated with the exception that was thrown, such as 'Invalid value for webhdfs parameter "permission":...'.
	Message *string `json:"message,omitempty"`
	// Exception - Possible values include: 'ExceptionAdlsRemoteException', 'ExceptionIllegalArgumentException', 'ExceptionUnsupportedOperationException', 'ExceptionSecurityException', 'ExceptionIOException', 'ExceptionFileNotFoundException', 'ExceptionFileAlreadyExistsException', 'ExceptionBadOffsetException', 'ExceptionRuntimeException', 'ExceptionAccessControlException'
	Exception Exception `json:"exception,omitempty"`
}

// MarshalJSON is the custom marshaler for AdlsIllegalArgumentException.
func (aiae AdlsIllegalArgumentException) MarshalJSON() ([]byte, error) {
	aiae.Exception = ExceptionIllegalArgumentException
	objectMap := make(map[string]interface{})
	if aiae.JavaClassName != nil {
		objectMap["javaClassName"] = aiae.JavaClassName
	}
	if aiae.Message != nil {
		objectMap["message"] = aiae.Message
	}
	objectMap["exception"] = aiae.Exception
	return json.Marshal(objectMap)
}

// AsAdlsIllegalArgumentException is the BasicAdlsRemoteException implementation for AdlsIllegalArgumentException.
func (aiae AdlsIllegalArgumentException) AsAdlsIllegalArgumentException() (*AdlsIllegalArgumentException, bool) {
	return &aiae, true
}

// AsAdlsUnsupportedOperationException is the BasicAdlsRemoteException implementation for AdlsIllegalArgumentException.
func (aiae AdlsIllegalArgumentException) AsAdlsUnsupportedOperationException() (*AdlsUnsupportedOperationException, bool) {
	return nil, false
}

// AsAdlsSecurityException is the BasicAdlsRemoteException implementation for AdlsIllegalArgumentException.
func (aiae AdlsIllegalArgumentException) AsAdlsSecurityException() (*AdlsSecurityException, bool) {
	return nil, false
}

// AsAdlsIOException is the BasicAdlsRemoteException implementation for AdlsIllegalArgumentException.
func (aiae AdlsIllegalArgumentException) AsAdlsIOException() (*AdlsIOException, bool) {
	return nil, false
}

// AsAdlsFileNotFoundException is the BasicAdlsRemoteException implementation for AdlsIllegalArgumentException.
func (aiae AdlsIllegalArgumentException) AsAdlsFileNotFoundException() (*AdlsFileNotFoundException, bool) {
	return nil, false
}

// AsAdlsFileAlreadyExistsException is the BasicAdlsRemoteException implementation for AdlsIllegalArgumentException.
func (aiae AdlsIllegalArgumentException) AsAdlsFileAlreadyExistsException() (*AdlsFileAlreadyExistsException, bool) {
	return nil, false
}

// AsAdlsBadOffsetException is the BasicAdlsRemoteException implementation for AdlsIllegalArgumentException.
func (aiae AdlsIllegalArgumentException) AsAdlsBadOffsetException() (*AdlsBadOffsetException, bool) {
	return nil, false
}

// AsAdlsRuntimeException is the BasicAdlsRemoteException implementation for AdlsIllegalArgumentException.
func (aiae AdlsIllegalArgumentException) AsAdlsRuntimeException() (*AdlsRuntimeException, bool) {
	return nil, false
}

// AsAdlsAccessControlException is the BasicAdlsRemoteException implementation for AdlsIllegalArgumentException.
func (aiae AdlsIllegalArgumentException) AsAdlsAccessControlException() (*AdlsAccessControlException, bool) {
	return nil, false
}

// AsAdlsRemoteException is the BasicAdlsRemoteException implementation for AdlsIllegalArgumentException.
func (aiae AdlsIllegalArgumentException) AsAdlsRemoteException() (*AdlsRemoteException, bool) {
	return nil, false
}

// AsBasicAdlsRemoteException is the BasicAdlsRemoteException implementation for AdlsIllegalArgumentException.
func (aiae AdlsIllegalArgumentException) AsBasicAdlsRemoteException() (BasicAdlsRemoteException, bool) {
	return &aiae, true
}

// AdlsIOException a WebHDFS exception thrown indicating there was an IO (read or write) error. Thrown when a 403
// error response code is returned (forbidden).
type AdlsIOException struct {
	// JavaClassName - the full class package name for the exception thrown, such as 'java.lang.IllegalArgumentException'.
	JavaClassName *string `json:"javaClassName,omitempty"`
	// Message - the message associated with the exception that was thrown, such as 'Invalid value for webhdfs parameter "permission":...'.
	Message *string `json:"message,omitempty"`
	// Exception - Possible values include: 'ExceptionAdlsRemoteException', 'ExceptionIllegalArgumentException', 'ExceptionUnsupportedOperationException', 'ExceptionSecurityException', 'ExceptionIOException', 'ExceptionFileNotFoundException', 'ExceptionFileAlreadyExistsException', 'ExceptionBadOffsetException', 'ExceptionRuntimeException', 'ExceptionAccessControlException'
	Exception Exception `json:"exception,omitempty"`
}

// MarshalJSON is the custom marshaler for AdlsIOException.
func (aie AdlsIOException) MarshalJSON() ([]byte, error) {
	aie.Exception = ExceptionIOException
	objectMap := make(map[string]interface{})
	if aie.JavaClassName != nil {
		objectMap["javaClassName"] = aie.JavaClassName
	}
	if aie.Message != nil {
		objectMap["message"] = aie.Message
	}
	objectMap["exception"] = aie.Exception
	return json.Marshal(objectMap)
}

// AsAdlsIllegalArgumentException is the BasicAdlsRemoteException implementation for AdlsIOException.
func (aie AdlsIOException) AsAdlsIllegalArgumentException() (*AdlsIllegalArgumentException, bool) {
	return nil, false
}

// AsAdlsUnsupportedOperationException is the BasicAdlsRemoteException implementation for AdlsIOException.
func (aie AdlsIOException) AsAdlsUnsupportedOperationException() (*AdlsUnsupportedOperationException, bool) {
	return nil, false
}

// AsAdlsSecurityException is the BasicAdlsRemoteException implementation for AdlsIOException.
func (aie AdlsIOException) AsAdlsSecurityException() (*AdlsSecurityException, bool) {
	return nil, false
}

// AsAdlsIOException is the BasicAdlsRemoteException implementation for AdlsIOException.
func (aie AdlsIOException) AsAdlsIOException() (*AdlsIOException, bool) {
	return &aie, true
}

// AsAdlsFileNotFoundException is the BasicAdlsRemoteException implementation for AdlsIOException.
func (aie AdlsIOException) AsAdlsFileNotFoundException() (*AdlsFileNotFoundException, bool) {
	return nil, false
}

// AsAdlsFileAlreadyExistsException is the BasicAdlsRemoteException implementation for AdlsIOException.
func (aie AdlsIOException) AsAdlsFileAlreadyExistsException() (*AdlsFileAlreadyExistsException, bool) {
	return nil, false
}

// AsAdlsBadOffsetException is the BasicAdlsRemoteException implementation for AdlsIOException.
func (aie AdlsIOException) AsAdlsBadOffsetException() (*AdlsBadOffsetException, bool) {
	return nil, false
}

// AsAdlsRuntimeException is the BasicAdlsRemoteException implementation for AdlsIOException.
func (aie AdlsIOException) AsAdlsRuntimeException() (*AdlsRuntimeException, bool) {
	return nil, false
}

// AsAdlsAccessControlException is the BasicAdlsRemoteException implementation for AdlsIOException.
func (aie AdlsIOException) AsAdlsAccessControlException() (*AdlsAccessControlException, bool) {
	return nil, false
}

// AsAdlsRemoteException is the BasicAdlsRemoteException implementation for AdlsIOException.
func (aie AdlsIOException) AsAdlsRemoteException() (*AdlsRemoteException, bool) {
	return nil, false
}

// AsBasicAdlsRemoteException is the BasicAdlsRemoteException implementation for AdlsIOException.
func (aie AdlsIOException) AsBasicAdlsRemoteException() (BasicAdlsRemoteException, bool) {
	return &aie, true
}

// BasicAdlsRemoteException data Lake Store filesystem exception based on the WebHDFS definition for RemoteExceptions.
type BasicAdlsRemoteException interface {
	AsAdlsIllegalArgumentException() (*AdlsIllegalArgumentException, bool)
	AsAdlsUnsupportedOperationException() (*AdlsUnsupportedOperationException, bool)
	AsAdlsSecurityException() (*AdlsSecurityException, bool)
	AsAdlsIOException() (*AdlsIOException, bool)
	AsAdlsFileNotFoundException() (*AdlsFileNotFoundException, bool)
	AsAdlsFileAlreadyExistsException() (*AdlsFileAlreadyExistsException, bool)
	AsAdlsBadOffsetException() (*AdlsBadOffsetException, bool)
	AsAdlsRuntimeException() (*AdlsRuntimeException, bool)
	AsAdlsAccessControlException() (*AdlsAccessControlException, bool)
	AsAdlsRemoteException() (*AdlsRemoteException, bool)
}

// AdlsRemoteException data Lake Store filesystem exception based on the WebHDFS definition for RemoteExceptions.
type AdlsRemoteException struct {
	// JavaClassName - the full class package name for the exception thrown, such as 'java.lang.IllegalArgumentException'.
	JavaClassName *string `json:"javaClassName,omitempty"`
	// Message - the message associated with the exception that was thrown, such as 'Invalid value for webhdfs parameter "permission":...'.
	Message *string `json:"message,omitempty"`
	// Exception - Possible values include: 'ExceptionAdlsRemoteException', 'ExceptionIllegalArgumentException', 'ExceptionUnsupportedOperationException', 'ExceptionSecurityException', 'ExceptionIOException', 'ExceptionFileNotFoundException', 'ExceptionFileAlreadyExistsException', 'ExceptionBadOffsetException', 'ExceptionRuntimeException', 'ExceptionAccessControlException'
	Exception Exception `json:"exception,omitempty"`
}

func unmarshalBasicAdlsRemoteException(body []byte) (BasicAdlsRemoteException, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["exception"] {
	case string(ExceptionIllegalArgumentException):
		var aiae AdlsIllegalArgumentException
		err := json.Unmarshal(body, &aiae)
		return aiae, err
	case string(ExceptionUnsupportedOperationException):
		var auoe AdlsUnsupportedOperationException
		err := json.Unmarshal(body, &auoe)
		return auoe, err
	case string(ExceptionSecurityException):
		var ase AdlsSecurityException
		err := json.Unmarshal(body, &ase)
		return ase, err
	case string(ExceptionIOException):
		var aie AdlsIOException
		err := json.Unmarshal(body, &aie)
		return aie, err
	case string(ExceptionFileNotFoundException):
		var afnfe AdlsFileNotFoundException
		err := json.Unmarshal(body, &afnfe)
		return afnfe, err
	case string(ExceptionFileAlreadyExistsException):
		var afaee AdlsFileAlreadyExistsException
		err := json.Unmarshal(body, &afaee)
		return afaee, err
	case string(ExceptionBadOffsetException):
		var aboe AdlsBadOffsetException
		err := json.Unmarshal(body, &aboe)
		return aboe, err
	case string(ExceptionRuntimeException):
		var are AdlsRuntimeException
		err := json.Unmarshal(body, &are)
		return are, err
	case string(ExceptionAccessControlException):
		var aace AdlsAccessControlException
		err := json.Unmarshal(body, &aace)
		return aace, err
	default:
		var are AdlsRemoteException
		err := json.Unmarshal(body, &are)
		return are, err
	}
}
func unmarshalBasicAdlsRemoteExceptionArray(body []byte) ([]BasicAdlsRemoteException, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	areArray := make([]BasicAdlsRemoteException, len(rawMessages))

	for index, rawMessage := range rawMessages {
		are, err := unmarshalBasicAdlsRemoteException(*rawMessage)
		if err != nil {
			return nil, err
		}
		areArray[index] = are
	}
	return areArray, nil
}

// MarshalJSON is the custom marshaler for AdlsRemoteException.
func (are AdlsRemoteException) MarshalJSON() ([]byte, error) {
	are.Exception = ExceptionAdlsRemoteException
	objectMap := make(map[string]interface{})
	if are.JavaClassName != nil {
		objectMap["javaClassName"] = are.JavaClassName
	}
	if are.Message != nil {
		objectMap["message"] = are.Message
	}
	objectMap["exception"] = are.Exception
	return json.Marshal(objectMap)
}

// AsAdlsIllegalArgumentException is the BasicAdlsRemoteException implementation for AdlsRemoteException.
func (are AdlsRemoteException) AsAdlsIllegalArgumentException() (*AdlsIllegalArgumentException, bool) {
	return nil, false
}

// AsAdlsUnsupportedOperationException is the BasicAdlsRemoteException implementation for AdlsRemoteException.
func (are AdlsRemoteException) AsAdlsUnsupportedOperationException() (*AdlsUnsupportedOperationException, bool) {
	return nil, false
}

// AsAdlsSecurityException is the BasicAdlsRemoteException implementation for AdlsRemoteException.
func (are AdlsRemoteException) AsAdlsSecurityException() (*AdlsSecurityException, bool) {
	return nil, false
}

// AsAdlsIOException is the BasicAdlsRemoteException implementation for AdlsRemoteException.
func (are AdlsRemoteException) AsAdlsIOException() (*AdlsIOException, bool) {
	return nil, false
}

// AsAdlsFileNotFoundException is the BasicAdlsRemoteException implementation for AdlsRemoteException.
func (are AdlsRemoteException) AsAdlsFileNotFoundException() (*AdlsFileNotFoundException, bool) {
	return nil, false
}

// AsAdlsFileAlreadyExistsException is the BasicAdlsRemoteException implementation for AdlsRemoteException.
func (are AdlsRemoteException) AsAdlsFileAlreadyExistsException() (*AdlsFileAlreadyExistsException, bool) {
	return nil, false
}

// AsAdlsBadOffsetException is the BasicAdlsRemoteException implementation for AdlsRemoteException.
func (are AdlsRemoteException) AsAdlsBadOffsetException() (*AdlsBadOffsetException, bool) {
	return nil, false
}

// AsAdlsRuntimeException is the BasicAdlsRemoteException implementation for AdlsRemoteException.
func (are AdlsRemoteException) AsAdlsRuntimeException() (*AdlsRuntimeException, bool) {
	return nil, false
}

// AsAdlsAccessControlException is the BasicAdlsRemoteException implementation for AdlsRemoteException.
func (are AdlsRemoteException) AsAdlsAccessControlException() (*AdlsAccessControlException, bool) {
	return nil, false
}

// AsAdlsRemoteException is the BasicAdlsRemoteException implementation for AdlsRemoteException.
func (are AdlsRemoteException) AsAdlsRemoteException() (*AdlsRemoteException, bool) {
	return &are, true
}

// AsBasicAdlsRemoteException is the BasicAdlsRemoteException implementation for AdlsRemoteException.
func (are AdlsRemoteException) AsBasicAdlsRemoteException() (BasicAdlsRemoteException, bool) {
	return &are, true
}

// AdlsRuntimeException a WebHDFS exception thrown when an unexpected error occurs during an operation. Thrown when
// a 500 error response code is returned (Internal server error).
type AdlsRuntimeException struct {
	// JavaClassName - the full class package name for the exception thrown, such as 'java.lang.IllegalArgumentException'.
	JavaClassName *string `json:"javaClassName,omitempty"`
	// Message - the message associated with the exception that was thrown, such as 'Invalid value for webhdfs parameter "permission":...'.
	Message *string `json:"message,omitempty"`
	// Exception - Possible values include: 'ExceptionAdlsRemoteException', 'ExceptionIllegalArgumentException', 'ExceptionUnsupportedOperationException', 'ExceptionSecurityException', 'ExceptionIOException', 'ExceptionFileNotFoundException', 'ExceptionFileAlreadyExistsException', 'ExceptionBadOffsetException', 'ExceptionRuntimeException', 'ExceptionAccessControlException'
	Exception Exception `json:"exception,omitempty"`
}

// MarshalJSON is the custom marshaler for AdlsRuntimeException.
func (are AdlsRuntimeException) MarshalJSON() ([]byte, error) {
	are.Exception = ExceptionRuntimeException
	objectMap := make(map[string]interface{})
	if are.JavaClassName != nil {
		objectMap["javaClassName"] = are.JavaClassName
	}
	if are.Message != nil {
		objectMap["message"] = are.Message
	}
	objectMap["exception"] = are.Exception
	return json.Marshal(objectMap)
}

// AsAdlsIllegalArgumentException is the BasicAdlsRemoteException implementation for AdlsRuntimeException.
func (are AdlsRuntimeException) AsAdlsIllegalArgumentException() (*AdlsIllegalArgumentException, bool) {
	return nil, false
}

// AsAdlsUnsupportedOperationException is the BasicAdlsRemoteException implementation for AdlsRuntimeException.
func (are AdlsRuntimeException) AsAdlsUnsupportedOperationException() (*AdlsUnsupportedOperationException, bool) {
	return nil, false
}

// AsAdlsSecurityException is the BasicAdlsRemoteException implementation for AdlsRuntimeException.
func (are AdlsRuntimeException) AsAdlsSecurityException() (*AdlsSecurityException, bool) {
	return nil, false
}

// AsAdlsIOException is the BasicAdlsRemoteException implementation for AdlsRuntimeException.
func (are AdlsRuntimeException) AsAdlsIOException() (*AdlsIOException, bool) {
	return nil, false
}

// AsAdlsFileNotFoundException is the BasicAdlsRemoteException implementation for AdlsRuntimeException.
func (are AdlsRuntimeException) AsAdlsFileNotFoundException() (*AdlsFileNotFoundException, bool) {
	return nil, false
}

// AsAdlsFileAlreadyExistsException is the BasicAdlsRemoteException implementation for AdlsRuntimeException.
func (are AdlsRuntimeException) AsAdlsFileAlreadyExistsException() (*AdlsFileAlreadyExistsException, bool) {
	return nil, false
}

// AsAdlsBadOffsetException is the BasicAdlsRemoteException implementation for AdlsRuntimeException.
func (are AdlsRuntimeException) AsAdlsBadOffsetException() (*AdlsBadOffsetException, bool) {
	return nil, false
}

// AsAdlsRuntimeException is the BasicAdlsRemoteException implementation for AdlsRuntimeException.
func (are AdlsRuntimeException) AsAdlsRuntimeException() (*AdlsRuntimeException, bool) {
	return &are, true
}

// AsAdlsAccessControlException is the BasicAdlsRemoteException implementation for AdlsRuntimeException.
func (are AdlsRuntimeException) AsAdlsAccessControlException() (*AdlsAccessControlException, bool) {
	return nil, false
}

// AsAdlsRemoteException is the BasicAdlsRemoteException implementation for AdlsRuntimeException.
func (are AdlsRuntimeException) AsAdlsRemoteException() (*AdlsRemoteException, bool) {
	return nil, false
}

// AsBasicAdlsRemoteException is the BasicAdlsRemoteException implementation for AdlsRuntimeException.
func (are AdlsRuntimeException) AsBasicAdlsRemoteException() (BasicAdlsRemoteException, bool) {
	return &are, true
}

// AdlsSecurityException a WebHDFS exception thrown indicating that access is denied. Thrown when a 401 error
// response code is returned (Unauthorized).
type AdlsSecurityException struct {
	// JavaClassName - the full class package name for the exception thrown, such as 'java.lang.IllegalArgumentException'.
	JavaClassName *string `json:"javaClassName,omitempty"`
	// Message - the message associated with the exception that was thrown, such as 'Invalid value for webhdfs parameter "permission":...'.
	Message *string `json:"message,omitempty"`
	// Exception - Possible values include: 'ExceptionAdlsRemoteException', 'ExceptionIllegalArgumentException', 'ExceptionUnsupportedOperationException', 'ExceptionSecurityException', 'ExceptionIOException', 'ExceptionFileNotFoundException', 'ExceptionFileAlreadyExistsException', 'ExceptionBadOffsetException', 'ExceptionRuntimeException', 'ExceptionAccessControlException'
	Exception Exception `json:"exception,omitempty"`
}

// MarshalJSON is the custom marshaler for AdlsSecurityException.
func (ase AdlsSecurityException) MarshalJSON() ([]byte, error) {
	ase.Exception = ExceptionSecurityException
	objectMap := make(map[string]interface{})
	if ase.JavaClassName != nil {
		objectMap["javaClassName"] = ase.JavaClassName
	}
	if ase.Message != nil {
		objectMap["message"] = ase.Message
	}
	objectMap["exception"] = ase.Exception
	return json.Marshal(objectMap)
}

// AsAdlsIllegalArgumentException is the BasicAdlsRemoteException implementation for AdlsSecurityException.
func (ase AdlsSecurityException) AsAdlsIllegalArgumentException() (*AdlsIllegalArgumentException, bool) {
	return nil, false
}

// AsAdlsUnsupportedOperationException is the BasicAdlsRemoteException implementation for AdlsSecurityException.
func (ase AdlsSecurityException) AsAdlsUnsupportedOperationException() (*AdlsUnsupportedOperationException, bool) {
	return nil, false
}

// AsAdlsSecurityException is the BasicAdlsRemoteException implementation for AdlsSecurityException.
func (ase AdlsSecurityException) AsAdlsSecurityException() (*AdlsSecurityException, bool) {
	return &ase, true
}

// AsAdlsIOException is the BasicAdlsRemoteException implementation for AdlsSecurityException.
func (ase AdlsSecurityException) AsAdlsIOException() (*AdlsIOException, bool) {
	return nil, false
}

// AsAdlsFileNotFoundException is the BasicAdlsRemoteException implementation for AdlsSecurityException.
func (ase AdlsSecurityException) AsAdlsFileNotFoundException() (*AdlsFileNotFoundException, bool) {
	return nil, false
}

// AsAdlsFileAlreadyExistsException is the BasicAdlsRemoteException implementation for AdlsSecurityException.
func (ase AdlsSecurityException) AsAdlsFileAlreadyExistsException() (*AdlsFileAlreadyExistsException, bool) {
	return nil, false
}

// AsAdlsBadOffsetException is the BasicAdlsRemoteException implementation for AdlsSecurityException.
func (ase AdlsSecurityException) AsAdlsBadOffsetException() (*AdlsBadOffsetException, bool) {
	return nil, false
}

// AsAdlsRuntimeException is the BasicAdlsRemoteException implementation for AdlsSecurityException.
func (ase AdlsSecurityException) AsAdlsRuntimeException() (*AdlsRuntimeException, bool) {
	return nil, false
}

// AsAdlsAccessControlException is the BasicAdlsRemoteException implementation for AdlsSecurityException.
func (ase AdlsSecurityException) AsAdlsAccessControlException() (*AdlsAccessControlException, bool) {
	return nil, false
}

// AsAdlsRemoteException is the BasicAdlsRemoteException implementation for AdlsSecurityException.
func (ase AdlsSecurityException) AsAdlsRemoteException() (*AdlsRemoteException, bool) {
	return nil, false
}

// AsBasicAdlsRemoteException is the BasicAdlsRemoteException implementation for AdlsSecurityException.
func (ase AdlsSecurityException) AsBasicAdlsRemoteException() (BasicAdlsRemoteException, bool) {
	return &ase, true
}

// AdlsUnsupportedOperationException a WebHDFS exception thrown indicating that the requested operation is not
// supported. Thrown when a 400 error response code is returned (bad request).
type AdlsUnsupportedOperationException struct {
	// JavaClassName - the full class package name for the exception thrown, such as 'java.lang.IllegalArgumentException'.
	JavaClassName *string `json:"javaClassName,omitempty"`
	// Message - the message associated with the exception that was thrown, such as 'Invalid value for webhdfs parameter "permission":...'.
	Message *string `json:"message,omitempty"`
	// Exception - Possible values include: 'ExceptionAdlsRemoteException', 'ExceptionIllegalArgumentException', 'ExceptionUnsupportedOperationException', 'ExceptionSecurityException', 'ExceptionIOException', 'ExceptionFileNotFoundException', 'ExceptionFileAlreadyExistsException', 'ExceptionBadOffsetException', 'ExceptionRuntimeException', 'ExceptionAccessControlException'
	Exception Exception `json:"exception,omitempty"`
}

// MarshalJSON is the custom marshaler for AdlsUnsupportedOperationException.
func (auoe AdlsUnsupportedOperationException) MarshalJSON() ([]byte, error) {
	auoe.Exception = ExceptionUnsupportedOperationException
	objectMap := make(map[string]interface{})
	if auoe.JavaClassName != nil {
		objectMap["javaClassName"] = auoe.JavaClassName
	}
	if auoe.Message != nil {
		objectMap["message"] = auoe.Message
	}
	objectMap["exception"] = auoe.Exception
	return json.Marshal(objectMap)
}

// AsAdlsIllegalArgumentException is the BasicAdlsRemoteException implementation for AdlsUnsupportedOperationException.
func (auoe AdlsUnsupportedOperationException) AsAdlsIllegalArgumentException() (*AdlsIllegalArgumentException, bool) {
	return nil, false
}

// AsAdlsUnsupportedOperationException is the BasicAdlsRemoteException implementation for AdlsUnsupportedOperationException.
func (auoe AdlsUnsupportedOperationException) AsAdlsUnsupportedOperationException() (*AdlsUnsupportedOperationException, bool) {
	return &auoe, true
}

// AsAdlsSecurityException is the BasicAdlsRemoteException implementation for AdlsUnsupportedOperationException.
func (auoe AdlsUnsupportedOperationException) AsAdlsSecurityException() (*AdlsSecurityException, bool) {
	return nil, false
}

// AsAdlsIOException is the BasicAdlsRemoteException implementation for AdlsUnsupportedOperationException.
func (auoe AdlsUnsupportedOperationException) AsAdlsIOException() (*AdlsIOException, bool) {
	return nil, false
}

// AsAdlsFileNotFoundException is the BasicAdlsRemoteException implementation for AdlsUnsupportedOperationException.
func (auoe AdlsUnsupportedOperationException) AsAdlsFileNotFoundException() (*AdlsFileNotFoundException, bool) {
	return nil, false
}

// AsAdlsFileAlreadyExistsException is the BasicAdlsRemoteException implementation for AdlsUnsupportedOperationException.
func (auoe AdlsUnsupportedOperationException) AsAdlsFileAlreadyExistsException() (*AdlsFileAlreadyExistsException, bool) {
	return nil, false
}

// AsAdlsBadOffsetException is the BasicAdlsRemoteException implementation for AdlsUnsupportedOperationException.
func (auoe AdlsUnsupportedOperationException) AsAdlsBadOffsetException() (*AdlsBadOffsetException, bool) {
	return nil, false
}

// AsAdlsRuntimeException is the BasicAdlsRemoteException implementation for AdlsUnsupportedOperationException.
func (auoe AdlsUnsupportedOperationException) AsAdlsRuntimeException() (*AdlsRuntimeException, bool) {
	return nil, false
}

// AsAdlsAccessControlException is the BasicAdlsRemoteException implementation for AdlsUnsupportedOperationException.
func (auoe AdlsUnsupportedOperationException) AsAdlsAccessControlException() (*AdlsAccessControlException, bool) {
	return nil, false
}

// AsAdlsRemoteException is the BasicAdlsRemoteException implementation for AdlsUnsupportedOperationException.
func (auoe AdlsUnsupportedOperationException) AsAdlsRemoteException() (*AdlsRemoteException, bool) {
	return nil, false
}

// AsBasicAdlsRemoteException is the BasicAdlsRemoteException implementation for AdlsUnsupportedOperationException.
func (auoe AdlsUnsupportedOperationException) AsBasicAdlsRemoteException() (BasicAdlsRemoteException, bool) {
	return &auoe, true
}

// ContentSummary data Lake Store content summary information
type ContentSummary struct {
	// DirectoryCount - the number of directories.
	DirectoryCount *int64 `json:"directoryCount,omitempty"`
	// FileCount - the number of files.
	FileCount *int64 `json:"fileCount,omitempty"`
	// Length - the number of bytes used by the contet.
	Length *int64 `json:"length,omitempty"`
	// SpaceConsumed - the disk space consumed by the content.
	SpaceConsumed *int64 `json:"spaceConsumed,omitempty"`
}

// ContentSummaryResult data Lake Store filesystem content summary information response.
type ContentSummaryResult struct {
	autorest.Response `json:"-"`
	// ContentSummary - the content summary for the specified path
	ContentSummary *ContentSummary `json:"ContentSummary,omitempty"`
}

// FileOperationResult the result of the request or operation.
type FileOperationResult struct {
	autorest.Response `json:"-"`
	// OperationResult - the result of the operation or request.
	OperationResult *bool `json:"boolean,omitempty"`
}

// FileStatuses data Lake Store file status list information.
type FileStatuses struct {
	// FileStatus - the object containing the list of properties of the files.
	FileStatus *[]FileStatusProperties `json:"FileStatus,omitempty"`
}

// FileStatusesResult data Lake Store filesystem file status list information response.
type FileStatusesResult struct {
	autorest.Response `json:"-"`
	// FileStatuses - the object representing the list of file statuses.
	FileStatuses *FileStatuses `json:"FileStatuses,omitempty"`
}

// FileStatusProperties data Lake Store file or directory information.
type FileStatusProperties struct {
	// AccessTime - the last access time as ticks since the epoch.
	AccessTime *int64 `json:"accessTime,omitempty"`
	// BlockSize - the block size for the file.
	BlockSize *int64 `json:"blockSize,omitempty"`
	// ChildrenNum - the number of children in the directory.
	ChildrenNum *int64 `json:"childrenNum,omitempty"`
	// ExpirationTime - Gets the expiration time, if any, as ticks since the epoch. If this is set to 0 or DateTime.MaxValue there is no expiration.
	ExpirationTime *int64 `json:"expirationTime,omitempty"`
	// Group - the group owner.
	Group *string `json:"group,omitempty"`
	// Length - the number of bytes in a file.
	Length *int64 `json:"length,omitempty"`
	// ModificationTime - the modification time as ticks since the epoch.
	ModificationTime *int64 `json:"modificationTime,omitempty"`
	// Owner - the user who is the owner.
	Owner *string `json:"owner,omitempty"`
	// PathSuffix - the path suffix.
	PathSuffix *string `json:"pathSuffix,omitempty"`
	// Permission - the permission represented as an string.
	Permission *string `json:"permission,omitempty"`
	// Type - the type of the path object. Possible values include: 'FILE', 'DIRECTORY'
	Type FileType `json:"type,omitempty"`
}

// FileStatusResult data Lake Store filesystem file status information response.
type FileStatusResult struct {
	autorest.Response `json:"-"`
	// FileStatus - the file status object associated with the specified path.
	FileStatus *FileStatusProperties `json:"FileStatus,omitempty"`
}

// ReadCloser ...
type ReadCloser struct {
	autorest.Response `json:"-"`
	Value             *io.ReadCloser `json:"value,omitempty"`
}
