package prediction

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/satori/go.uuid"
)

// ImagePredictionResultModel result of an image prediction request
type ImagePredictionResultModel struct {
	autorest.Response `json:"-"`
	ID                *uuid.UUID                 `json:"Id,omitempty"`
	Project           *uuid.UUID                 `json:"Project,omitempty"`
	Iteration         *uuid.UUID                 `json:"Iteration,omitempty"`
	Created           *date.Time                 `json:"Created,omitempty"`
	Predictions       *[]ImageTagPredictionModel `json:"Predictions,omitempty"`
}

// ImageTagPredictionModel ...
type ImageTagPredictionModel struct {
	TagID       *uuid.UUID `json:"TagId,omitempty"`
	Tag         *string    `json:"Tag,omitempty"`
	Probability *float64   `json:"Probability,omitempty"`
}

// ImageURL ...
type ImageURL struct {
	URL *string `json:"Url,omitempty"`
}
