package commerce

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// Resource base Resource Object
type Resource struct {
	// ID - URI of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - Type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Location where resource is location.
	Location *string `json:"location,omitempty"`
	// Tags - List of key value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// UsageAggregate aggregate usage values for resource.
type UsageAggregate struct {
	// UsageAggregateModel - Properties for aggregate usage.
	*UsageAggregateModel `json:"properties,omitempty"`
	// ID - URI of the resource.
	ID *string `json:"id,omitempty"`
	// Name - Name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - Type of resource.
	Type *string `json:"type,omitempty"`
	// Location - Location where resource is location.
	Location *string `json:"location,omitempty"`
	// Tags - List of key value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for UsageAggregate.
func (ua UsageAggregate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ua.UsageAggregateModel != nil {
		objectMap["properties"] = ua.UsageAggregateModel
	}
	if ua.ID != nil {
		objectMap["id"] = ua.ID
	}
	if ua.Name != nil {
		objectMap["name"] = ua.Name
	}
	if ua.Type != nil {
		objectMap["type"] = ua.Type
	}
	if ua.Location != nil {
		objectMap["location"] = ua.Location
	}
	if ua.Tags != nil {
		objectMap["tags"] = ua.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for UsageAggregate struct.
func (ua *UsageAggregate) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var usageAggregateModel UsageAggregateModel
				err = json.Unmarshal(*v, &usageAggregateModel)
				if err != nil {
					return err
				}
				ua.UsageAggregateModel = &usageAggregateModel
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ua.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ua.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ua.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ua.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ua.Tags = tags
			}
		}
	}

	return nil
}

// UsageAggregateModel properties for aggregate usage.
type UsageAggregateModel struct {
	// SubscriptionID - Subscription id of tenant using plan.
	SubscriptionID *string `json:"subscriptionId,omitempty"`
	// UsageStartTime - UTC start time for the usage bucket to which this usage aggregate belongs.
	UsageStartTime *date.Time `json:"usageStartTime,omitempty"`
	// UsageEndTime - UTC end time for the usage bucket to which this usage aggregate belongs.
	UsageEndTime *date.Time `json:"usageEndTime,omitempty"`
	// InstanceData - Key-value pairs of instance details represented as a string.
	InstanceData *string `json:"instanceData,omitempty"`
	// Quantity - The amount of the resource consumption that occurred in this time frame.
	Quantity *string `json:"quantity,omitempty"`
	// MeterID - Unique ID for the resource that was consumed (aka ResourceID).
	MeterID *string `json:"meterId,omitempty"`
}

// UsageAggregatePage holds an array of usage aggregates and the continuation token.
type UsageAggregatePage struct {
	autorest.Response `json:"-"`
	// Value - Array of usage aggregates.
	Value *[]UsageAggregate `json:"value,omitempty"`
	// NextLink - Continuation token
	NextLink *string `json:"nextLink,omitempty"`
}
