// Code generated by informer-gen. DO NOT EDIT.

package internalversion

import (
	"fmt"

	network "github.com/openshift/origin/pkg/network/apis/network"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	cache "k8s.io/client-go/tools/cache"
)

// GenericInformer is type of SharedIndexInformer which will locate and delegate to other
// sharedInformers based on type
type GenericInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() cache.GenericLister
}

type genericInformer struct {
	informer cache.SharedIndexInformer
	resource schema.GroupResource
}

// Informer returns the SharedIndexInformer.
func (f *genericInformer) Informer() cache.SharedIndexInformer {
	return f.informer
}

// Lister returns the GenericLister.
func (f *genericInformer) Lister() cache.GenericLister {
	return cache.NewGenericLister(f.Informer().GetIndexer(), f.resource)
}

// ForResource gives generic access to a shared informer of the matching type
// TODO extend this to unknown resources with a client pool
func (f *sharedInformerFactory) ForResource(resource schema.GroupVersionResource) (GenericInformer, error) {
	switch resource {
	// Group=network.openshift.io, Version=internalVersion
	case network.SchemeGroupVersion.WithResource("clusternetworks"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Network().InternalVersion().ClusterNetworks().Informer()}, nil
	case network.SchemeGroupVersion.WithResource("egressnetworkpolicies"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Network().InternalVersion().EgressNetworkPolicies().Informer()}, nil
	case network.SchemeGroupVersion.WithResource("hostsubnets"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Network().InternalVersion().HostSubnets().Informer()}, nil
	case network.SchemeGroupVersion.WithResource("netnamespaces"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Network().InternalVersion().NetNamespaces().Informer()}, nil

	}

	return nil, fmt.Errorf("no informer found for %v", resource)
}
