// Code generated by lister-gen. DO NOT EDIT.

package internalversion

import (
	image "github.com/openshift/origin/pkg/image/apis/image"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ImageLister helps list Images.
type ImageLister interface {
	// List lists all Images in the indexer.
	List(selector labels.Selector) (ret []*image.Image, err error)
	// Get retrieves the Image from the index for a given name.
	Get(name string) (*image.Image, error)
	ImageListerExpansion
}

// imageLister implements the ImageLister interface.
type imageLister struct {
	indexer cache.Indexer
}

// NewImageLister returns a new ImageLister.
func NewImageLister(indexer cache.Indexer) ImageLister {
	return &imageLister{indexer: indexer}
}

// List lists all Images in the indexer.
func (s *imageLister) List(selector labels.Selector) (ret []*image.Image, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*image.Image))
	})
	return ret, err
}

// Get retrieves the Image from the index for a given name.
func (s *imageLister) Get(name string) (*image.Image, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(image.Resource("image"), name)
	}
	return obj.(*image.Image), nil
}
