// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/api/operator/v1"
	scheme "github.com/openshift/client-go/operator/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ServiceCatalogControllerManagersGetter has a method to return a ServiceCatalogControllerManagerInterface.
// A group's client should implement this interface.
type ServiceCatalogControllerManagersGetter interface {
	ServiceCatalogControllerManagers() ServiceCatalogControllerManagerInterface
}

// ServiceCatalogControllerManagerInterface has methods to work with ServiceCatalogControllerManager resources.
type ServiceCatalogControllerManagerInterface interface {
	Create(*v1.ServiceCatalogControllerManager) (*v1.ServiceCatalogControllerManager, error)
	Update(*v1.ServiceCatalogControllerManager) (*v1.ServiceCatalogControllerManager, error)
	UpdateStatus(*v1.ServiceCatalogControllerManager) (*v1.ServiceCatalogControllerManager, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.ServiceCatalogControllerManager, error)
	List(opts metav1.ListOptions) (*v1.ServiceCatalogControllerManagerList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.ServiceCatalogControllerManager, err error)
	ServiceCatalogControllerManagerExpansion
}

// serviceCatalogControllerManagers implements ServiceCatalogControllerManagerInterface
type serviceCatalogControllerManagers struct {
	client rest.Interface
}

// newServiceCatalogControllerManagers returns a ServiceCatalogControllerManagers
func newServiceCatalogControllerManagers(c *OperatorV1Client) *serviceCatalogControllerManagers {
	return &serviceCatalogControllerManagers{
		client: c.RESTClient(),
	}
}

// Get takes name of the serviceCatalogControllerManager, and returns the corresponding serviceCatalogControllerManager object, and an error if there is any.
func (c *serviceCatalogControllerManagers) Get(name string, options metav1.GetOptions) (result *v1.ServiceCatalogControllerManager, err error) {
	result = &v1.ServiceCatalogControllerManager{}
	err = c.client.Get().
		Resource("servicecatalogcontrollermanagers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ServiceCatalogControllerManagers that match those selectors.
func (c *serviceCatalogControllerManagers) List(opts metav1.ListOptions) (result *v1.ServiceCatalogControllerManagerList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ServiceCatalogControllerManagerList{}
	err = c.client.Get().
		Resource("servicecatalogcontrollermanagers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested serviceCatalogControllerManagers.
func (c *serviceCatalogControllerManagers) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("servicecatalogcontrollermanagers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a serviceCatalogControllerManager and creates it.  Returns the server's representation of the serviceCatalogControllerManager, and an error, if there is any.
func (c *serviceCatalogControllerManagers) Create(serviceCatalogControllerManager *v1.ServiceCatalogControllerManager) (result *v1.ServiceCatalogControllerManager, err error) {
	result = &v1.ServiceCatalogControllerManager{}
	err = c.client.Post().
		Resource("servicecatalogcontrollermanagers").
		Body(serviceCatalogControllerManager).
		Do().
		Into(result)
	return
}

// Update takes the representation of a serviceCatalogControllerManager and updates it. Returns the server's representation of the serviceCatalogControllerManager, and an error, if there is any.
func (c *serviceCatalogControllerManagers) Update(serviceCatalogControllerManager *v1.ServiceCatalogControllerManager) (result *v1.ServiceCatalogControllerManager, err error) {
	result = &v1.ServiceCatalogControllerManager{}
	err = c.client.Put().
		Resource("servicecatalogcontrollermanagers").
		Name(serviceCatalogControllerManager.Name).
		Body(serviceCatalogControllerManager).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *serviceCatalogControllerManagers) UpdateStatus(serviceCatalogControllerManager *v1.ServiceCatalogControllerManager) (result *v1.ServiceCatalogControllerManager, err error) {
	result = &v1.ServiceCatalogControllerManager{}
	err = c.client.Put().
		Resource("servicecatalogcontrollermanagers").
		Name(serviceCatalogControllerManager.Name).
		SubResource("status").
		Body(serviceCatalogControllerManager).
		Do().
		Into(result)
	return
}

// Delete takes name of the serviceCatalogControllerManager and deletes it. Returns an error if one occurs.
func (c *serviceCatalogControllerManagers) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("servicecatalogcontrollermanagers").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *serviceCatalogControllerManagers) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("servicecatalogcontrollermanagers").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched serviceCatalogControllerManager.
func (c *serviceCatalogControllerManagers) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.ServiceCatalogControllerManager, err error) {
	result = &v1.ServiceCatalogControllerManager{}
	err = c.client.Patch(pt).
		Resource("servicecatalogcontrollermanagers").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
