# This ruby script creates the dynamic configuration file
# needed for the fluentd-remote-syslog plugin.

@env_vars = Array.new

# Loops through environment variables for the remote-syslog plugin
def init_environment_vars()
  prefix = 'REMOTE_SYSLOG_'
  group  = prefix + "HOST"

  ENV.each_key.to_a.select { |s| s.start_with? group }.uniq.each do |k|
    # [0] = environment variable name
    # [1] = syslog plugin config name
    # [2] = default value, if any
    # [3] = allowed values, if any
    vars = [
      ['HOST', 'remote_syslog', nil, nil],
      ['PORT', 'port', "514", nil],
      ['HOSTNAME', 'hostname', ENV['HOSTNAME'], nil],
      ['REMOVE_TAG_PREFIX', 'remove_tag_prefix', nil, nil],
      ['TAG_KEY', 'tag_key', nil, nil],
      ['FACILITY', 'facility', "local0", nil],
      ['SEVERITY', 'severity', "debug", nil],
      ['USE_RECORD', 'use_record', nil, nil],
      ['PAYLOAD_KEY', 'payload_key', nil, nil],
      # TYPE must be vars[-1]
      ['TYPE', 'type', "syslog_buffered", ['syslog_buffered', 'syslog']]
    ]
    t = k.dup
    t.slice! group
    vars.each { |r|
      r[2] = if (r[3].nil? && ENV[prefix + r[0] + t]) || (!r[3].nil? && ENV[prefix + r[0] + t] && r[3].include?(ENV[prefix + r[0] + t])) then ENV[prefix + r[0] + t] else r[2] end
    }
    @env_vars.push(vars)
  end
end


def create_default_file()
  file_name = "/etc/fluent/configs.d/dynamic/output-remote-syslog.conf"
  c = '## This file was generated by generate-syslog-config.rb'

  # NOTE WELL: you cannot add an @id to this plugin easily like
  # @id remote-syslog-input
  # this gives an error with fluentd 1.x because the generated file is
  # included from two separate places (if ops logging is enabled), and
  # therefore there are two completely different plugin configs each
  # with the same id
  # We'll have to generate two completely separate files each with a
  # unique id e.g. remote-syslog-input-apps or -infra
  @env_vars.each do |r|
  type = r.pop
  c <<
"
<store>
@type #{type[2]}
"
     r.each { |v|  c << "#{v[1]} #{v[2]}\n" unless !v[2] }
  c <<
"</store>
"
  end

  File.open(file_name, 'w') { |f| f.write(c) }
end

init_environment_vars()
create_default_file()
