// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/api/config/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// InfrastructureLister helps list Infrastructures.
type InfrastructureLister interface {
	// List lists all Infrastructures in the indexer.
	List(selector labels.Selector) (ret []*v1.Infrastructure, err error)
	// Get retrieves the Infrastructure from the index for a given name.
	Get(name string) (*v1.Infrastructure, error)
	InfrastructureListerExpansion
}

// infrastructureLister implements the InfrastructureLister interface.
type infrastructureLister struct {
	indexer cache.Indexer
}

// NewInfrastructureLister returns a new InfrastructureLister.
func NewInfrastructureLister(indexer cache.Indexer) InfrastructureLister {
	return &infrastructureLister{indexer: indexer}
}

// List lists all Infrastructures in the indexer.
func (s *infrastructureLister) List(selector labels.Selector) (ret []*v1.Infrastructure, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.Infrastructure))
	})
	return ret, err
}

// Get retrieves the Infrastructure from the index for a given name.
func (s *infrastructureLister) Get(name string) (*v1.Infrastructure, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("infrastructure"), name)
	}
	return obj.(*v1.Infrastructure), nil
}
