// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/openshift/cluster-node-tuning-operator/pkg/apis/tuned/v1"
	scheme "github.com/openshift/cluster-node-tuning-operator/pkg/generated/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ProfilesGetter has a method to return a ProfileInterface.
// A group's client should implement this interface.
type ProfilesGetter interface {
	Profiles(namespace string) ProfileInterface
}

// ProfileInterface has methods to work with Profile resources.
type ProfileInterface interface {
	Create(ctx context.Context, profile *v1.Profile, opts metav1.CreateOptions) (*v1.Profile, error)
	Update(ctx context.Context, profile *v1.Profile, opts metav1.UpdateOptions) (*v1.Profile, error)
	UpdateStatus(ctx context.Context, profile *v1.Profile, opts metav1.UpdateOptions) (*v1.Profile, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.Profile, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.ProfileList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Profile, err error)
	ProfileExpansion
}

// profiles implements ProfileInterface
type profiles struct {
	client rest.Interface
	ns     string
}

// newProfiles returns a Profiles
func newProfiles(c *TunedV1Client, namespace string) *profiles {
	return &profiles{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the profile, and returns the corresponding profile object, and an error if there is any.
func (c *profiles) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.Profile, err error) {
	result = &v1.Profile{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("profiles").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Profiles that match those selectors.
func (c *profiles) List(ctx context.Context, opts metav1.ListOptions) (result *v1.ProfileList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ProfileList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("profiles").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested profiles.
func (c *profiles) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("profiles").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a profile and creates it.  Returns the server's representation of the profile, and an error, if there is any.
func (c *profiles) Create(ctx context.Context, profile *v1.Profile, opts metav1.CreateOptions) (result *v1.Profile, err error) {
	result = &v1.Profile{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("profiles").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(profile).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a profile and updates it. Returns the server's representation of the profile, and an error, if there is any.
func (c *profiles) Update(ctx context.Context, profile *v1.Profile, opts metav1.UpdateOptions) (result *v1.Profile, err error) {
	result = &v1.Profile{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("profiles").
		Name(profile.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(profile).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *profiles) UpdateStatus(ctx context.Context, profile *v1.Profile, opts metav1.UpdateOptions) (result *v1.Profile, err error) {
	result = &v1.Profile{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("profiles").
		Name(profile.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(profile).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the profile and deletes it. Returns an error if one occurs.
func (c *profiles) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("profiles").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *profiles) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("profiles").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched profile.
func (c *profiles) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Profile, err error) {
	result = &v1.Profile{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("profiles").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
