// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	v1 "github.com/openshift/cluster-node-tuning-operator/pkg/apis/tuned/v1"
	scheme "github.com/openshift/cluster-node-tuning-operator/pkg/generated/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// TunedsGetter has a method to return a TunedInterface.
// A group's client should implement this interface.
type TunedsGetter interface {
	Tuneds(namespace string) TunedInterface
}

// TunedInterface has methods to work with Tuned resources.
type TunedInterface interface {
	Create(ctx context.Context, tuned *v1.Tuned, opts metav1.CreateOptions) (*v1.Tuned, error)
	Update(ctx context.Context, tuned *v1.Tuned, opts metav1.UpdateOptions) (*v1.Tuned, error)
	UpdateStatus(ctx context.Context, tuned *v1.Tuned, opts metav1.UpdateOptions) (*v1.Tuned, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.Tuned, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.TunedList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Tuned, err error)
	TunedExpansion
}

// tuneds implements TunedInterface
type tuneds struct {
	client rest.Interface
	ns     string
}

// newTuneds returns a Tuneds
func newTuneds(c *TunedV1Client, namespace string) *tuneds {
	return &tuneds{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the tuned, and returns the corresponding tuned object, and an error if there is any.
func (c *tuneds) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.Tuned, err error) {
	result = &v1.Tuned{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("tuneds").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Tuneds that match those selectors.
func (c *tuneds) List(ctx context.Context, opts metav1.ListOptions) (result *v1.TunedList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.TunedList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("tuneds").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested tuneds.
func (c *tuneds) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("tuneds").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a tuned and creates it.  Returns the server's representation of the tuned, and an error, if there is any.
func (c *tuneds) Create(ctx context.Context, tuned *v1.Tuned, opts metav1.CreateOptions) (result *v1.Tuned, err error) {
	result = &v1.Tuned{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("tuneds").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tuned).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a tuned and updates it. Returns the server's representation of the tuned, and an error, if there is any.
func (c *tuneds) Update(ctx context.Context, tuned *v1.Tuned, opts metav1.UpdateOptions) (result *v1.Tuned, err error) {
	result = &v1.Tuned{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("tuneds").
		Name(tuned.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tuned).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *tuneds) UpdateStatus(ctx context.Context, tuned *v1.Tuned, opts metav1.UpdateOptions) (result *v1.Tuned, err error) {
	result = &v1.Tuned{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("tuneds").
		Name(tuned.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tuned).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the tuned and deletes it. Returns an error if one occurs.
func (c *tuneds) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("tuneds").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *tuneds) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("tuneds").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched tuned.
func (c *tuneds) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Tuned, err error) {
	result = &v1.Tuned{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("tuneds").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
