/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "k8s.io/api/auditregistration/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	scheme "k8s.io/client-go/kubernetes/scheme"
	rest "k8s.io/client-go/rest"
)

// AuditSinksGetter has a method to return a AuditSinkInterface.
// A group's client should implement this interface.
type AuditSinksGetter interface {
	AuditSinks() AuditSinkInterface
}

// AuditSinkInterface has methods to work with AuditSink resources.
type AuditSinkInterface interface {
	Create(ctx context.Context, auditSink *v1alpha1.AuditSink, opts v1.CreateOptions) (*v1alpha1.AuditSink, error)
	Update(ctx context.Context, auditSink *v1alpha1.AuditSink, opts v1.UpdateOptions) (*v1alpha1.AuditSink, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.AuditSink, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.AuditSinkList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.AuditSink, err error)
	AuditSinkExpansion
}

// auditSinks implements AuditSinkInterface
type auditSinks struct {
	client rest.Interface
}

// newAuditSinks returns a AuditSinks
func newAuditSinks(c *AuditregistrationV1alpha1Client) *auditSinks {
	return &auditSinks{
		client: c.RESTClient(),
	}
}

// Get takes name of the auditSink, and returns the corresponding auditSink object, and an error if there is any.
func (c *auditSinks) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.AuditSink, err error) {
	result = &v1alpha1.AuditSink{}
	err = c.client.Get().
		Resource("auditsinks").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of AuditSinks that match those selectors.
func (c *auditSinks) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.AuditSinkList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.AuditSinkList{}
	err = c.client.Get().
		Resource("auditsinks").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested auditSinks.
func (c *auditSinks) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("auditsinks").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a auditSink and creates it.  Returns the server's representation of the auditSink, and an error, if there is any.
func (c *auditSinks) Create(ctx context.Context, auditSink *v1alpha1.AuditSink, opts v1.CreateOptions) (result *v1alpha1.AuditSink, err error) {
	result = &v1alpha1.AuditSink{}
	err = c.client.Post().
		Resource("auditsinks").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(auditSink).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a auditSink and updates it. Returns the server's representation of the auditSink, and an error, if there is any.
func (c *auditSinks) Update(ctx context.Context, auditSink *v1alpha1.AuditSink, opts v1.UpdateOptions) (result *v1alpha1.AuditSink, err error) {
	result = &v1alpha1.AuditSink{}
	err = c.client.Put().
		Resource("auditsinks").
		Name(auditSink.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(auditSink).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the auditSink and deletes it. Returns an error if one occurs.
func (c *auditSinks) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("auditsinks").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *auditSinks) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("auditsinks").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched auditSink.
func (c *auditSinks) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.AuditSink, err error) {
	result = &v1alpha1.AuditSink{}
	err = c.client.Patch(pt).
		Resource("auditsinks").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
