// Code generated by main. DO NOT EDIT.

package fake

import (
	tunedv1 "github.com/openshift/cluster-node-tuning-operator/pkg/apis/tuned/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeTuneds implements TunedInterface
type FakeTuneds struct {
	Fake *FakeTunedV1
	ns   string
}

var tunedsResource = schema.GroupVersionResource{Group: "tuned.openshift.io", Version: "v1", Resource: "tuneds"}

var tunedsKind = schema.GroupVersionKind{Group: "tuned.openshift.io", Version: "v1", Kind: "Tuned"}

// Get takes name of the tuned, and returns the corresponding tuned object, and an error if there is any.
func (c *FakeTuneds) Get(name string, options v1.GetOptions) (result *tunedv1.Tuned, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(tunedsResource, c.ns, name), &tunedv1.Tuned{})

	if obj == nil {
		return nil, err
	}
	return obj.(*tunedv1.Tuned), err
}

// List takes label and field selectors, and returns the list of Tuneds that match those selectors.
func (c *FakeTuneds) List(opts v1.ListOptions) (result *tunedv1.TunedList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(tunedsResource, tunedsKind, c.ns, opts), &tunedv1.TunedList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &tunedv1.TunedList{ListMeta: obj.(*tunedv1.TunedList).ListMeta}
	for _, item := range obj.(*tunedv1.TunedList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested tuneds.
func (c *FakeTuneds) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(tunedsResource, c.ns, opts))

}

// Create takes the representation of a tuned and creates it.  Returns the server's representation of the tuned, and an error, if there is any.
func (c *FakeTuneds) Create(tuned *tunedv1.Tuned) (result *tunedv1.Tuned, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(tunedsResource, c.ns, tuned), &tunedv1.Tuned{})

	if obj == nil {
		return nil, err
	}
	return obj.(*tunedv1.Tuned), err
}

// Update takes the representation of a tuned and updates it. Returns the server's representation of the tuned, and an error, if there is any.
func (c *FakeTuneds) Update(tuned *tunedv1.Tuned) (result *tunedv1.Tuned, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(tunedsResource, c.ns, tuned), &tunedv1.Tuned{})

	if obj == nil {
		return nil, err
	}
	return obj.(*tunedv1.Tuned), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeTuneds) UpdateStatus(tuned *tunedv1.Tuned) (*tunedv1.Tuned, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(tunedsResource, "status", c.ns, tuned), &tunedv1.Tuned{})

	if obj == nil {
		return nil, err
	}
	return obj.(*tunedv1.Tuned), err
}

// Delete takes name of the tuned and deletes it. Returns an error if one occurs.
func (c *FakeTuneds) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(tunedsResource, c.ns, name), &tunedv1.Tuned{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeTuneds) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(tunedsResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &tunedv1.TunedList{})
	return err
}

// Patch applies the patch and returns the patched tuned.
func (c *FakeTuneds) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *tunedv1.Tuned, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(tunedsResource, c.ns, name, pt, data, subresources...), &tunedv1.Tuned{})

	if obj == nil {
		return nil, err
	}
	return obj.(*tunedv1.Tuned), err
}
