// Code generated by main. DO NOT EDIT.

package v1

import (
	time "time"

	tunedv1 "github.com/openshift/cluster-node-tuning-operator/pkg/apis/tuned/v1"
	versioned "github.com/openshift/cluster-node-tuning-operator/pkg/generated/clientset/versioned"
	internalinterfaces "github.com/openshift/cluster-node-tuning-operator/pkg/generated/informers/externalversions/internalinterfaces"
	v1 "github.com/openshift/cluster-node-tuning-operator/pkg/generated/listers/tuned/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// TunedInformer provides access to a shared informer and lister for
// Tuneds.
type TunedInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v1.TunedLister
}

type tunedInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewTunedInformer constructs a new informer for Tuned type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewTunedInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredTunedInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredTunedInformer constructs a new informer for Tuned type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredTunedInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options metav1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.TunedV1().Tuneds(namespace).List(options)
			},
			WatchFunc: func(options metav1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.TunedV1().Tuneds(namespace).Watch(options)
			},
		},
		&tunedv1.Tuned{},
		resyncPeriod,
		indexers,
	)
}

func (f *tunedInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredTunedInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *tunedInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&tunedv1.Tuned{}, f.defaultInformer)
}

func (f *tunedInformer) Lister() v1.TunedLister {
	return v1.NewTunedLister(f.Informer().GetIndexer())
}
