// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/resultstore/v2/action.proto

package resultstore

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Indicates how/where this Action was executed.
type ExecutionStrategy int32

const (
	// The action did not indicate how it was executed.
	ExecutionStrategy_EXECUTION_STRATEGY_UNSPECIFIED ExecutionStrategy = 0
	// The action was executed in some other form.
	ExecutionStrategy_OTHER_ENVIRONMENT ExecutionStrategy = 1
	// The action used a remote build service.
	ExecutionStrategy_REMOTE_SERVICE ExecutionStrategy = 2
	// The action was executed locally, in parallel with other actions.
	ExecutionStrategy_LOCAL_PARALLEL ExecutionStrategy = 3
	// The action was executed locally, without parallelism.
	ExecutionStrategy_LOCAL_SEQUENTIAL ExecutionStrategy = 4
)

var ExecutionStrategy_name = map[int32]string{
	0: "EXECUTION_STRATEGY_UNSPECIFIED",
	1: "OTHER_ENVIRONMENT",
	2: "REMOTE_SERVICE",
	3: "LOCAL_PARALLEL",
	4: "LOCAL_SEQUENTIAL",
}

var ExecutionStrategy_value = map[string]int32{
	"EXECUTION_STRATEGY_UNSPECIFIED": 0,
	"OTHER_ENVIRONMENT":              1,
	"REMOTE_SERVICE":                 2,
	"LOCAL_PARALLEL":                 3,
	"LOCAL_SEQUENTIAL":               4,
}

func (x ExecutionStrategy) String() string {
	return proto.EnumName(ExecutionStrategy_name, int32(x))
}

func (ExecutionStrategy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{0}
}

// Most build systems cache build results to speed up incremental builds.
// Some also cache test results too. This indicates whether the test results
// were found in a cache, and where that cache was located.
type TestCaching int32

const (
	// The implicit default enum value. Should never be set.
	TestCaching_TEST_CACHING_UNSPECIFIED TestCaching = 0
	// The test result was found in a local cache, so it wasn't run again.
	TestCaching_LOCAL_CACHE_HIT TestCaching = 1
	// The test result was found in a remote cache, so it wasn't run again.
	TestCaching_REMOTE_CACHE_HIT TestCaching = 2
	// The test result was not found in any cache, so it had to be run again.
	TestCaching_CACHE_MISS TestCaching = 3
)

var TestCaching_name = map[int32]string{
	0: "TEST_CACHING_UNSPECIFIED",
	1: "LOCAL_CACHE_HIT",
	2: "REMOTE_CACHE_HIT",
	3: "CACHE_MISS",
}

var TestCaching_value = map[string]int32{
	"TEST_CACHING_UNSPECIFIED": 0,
	"LOCAL_CACHE_HIT":          1,
	"REMOTE_CACHE_HIT":         2,
	"CACHE_MISS":               3,
}

func (x TestCaching) String() string {
	return proto.EnumName(TestCaching_name, int32(x))
}

func (TestCaching) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{1}
}

// Errors in file post-processing are categorized using this enum.
type FileProcessingErrorType int32

const (
	// Type unspecified or not listed here.
	FileProcessingErrorType_FILE_PROCESSING_ERROR_TYPE_UNSPECIFIED FileProcessingErrorType = 0
	// A read error occurred trying to read the file.
	FileProcessingErrorType_GENERIC_READ_ERROR FileProcessingErrorType = 1
	// There was an error trying to parse the file.
	FileProcessingErrorType_GENERIC_PARSE_ERROR FileProcessingErrorType = 2
	// File is exceeds size limit.
	FileProcessingErrorType_FILE_TOO_LARGE FileProcessingErrorType = 3
	// The result of parsing the file exceeded size limit.
	FileProcessingErrorType_OUTPUT_TOO_LARGE FileProcessingErrorType = 4
	// Read access to the file was denied by file system.
	FileProcessingErrorType_ACCESS_DENIED FileProcessingErrorType = 5
	// Deadline exceeded trying to read the file.
	FileProcessingErrorType_DEADLINE_EXCEEDED FileProcessingErrorType = 6
	// File not found.
	FileProcessingErrorType_NOT_FOUND FileProcessingErrorType = 7
)

var FileProcessingErrorType_name = map[int32]string{
	0: "FILE_PROCESSING_ERROR_TYPE_UNSPECIFIED",
	1: "GENERIC_READ_ERROR",
	2: "GENERIC_PARSE_ERROR",
	3: "FILE_TOO_LARGE",
	4: "OUTPUT_TOO_LARGE",
	5: "ACCESS_DENIED",
	6: "DEADLINE_EXCEEDED",
	7: "NOT_FOUND",
}

var FileProcessingErrorType_value = map[string]int32{
	"FILE_PROCESSING_ERROR_TYPE_UNSPECIFIED": 0,
	"GENERIC_READ_ERROR":                     1,
	"GENERIC_PARSE_ERROR":                    2,
	"FILE_TOO_LARGE":                         3,
	"OUTPUT_TOO_LARGE":                       4,
	"ACCESS_DENIED":                          5,
	"DEADLINE_EXCEEDED":                      6,
	"NOT_FOUND":                              7,
}

func (x FileProcessingErrorType) String() string {
	return proto.EnumName(FileProcessingErrorType_name, int32(x))
}

func (FileProcessingErrorType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{2}
}

// An action that happened as part of a configured target. This action could be
// a build, a test, or another type of action.
// Each parent ConfiguredTarget resource should have at least one Action as its
// child resource before the invocation is finalized. ResultStore is a tool to
// store build & test results. ConfiguredTarget proto by itself does not contain
// enough fields to fully represent such results. For a simple build, at least
// one build action is required to represent the build result.
type Action struct {
	// The resource name.  Its format must be:
	// invocations/${INVOCATION_ID}/targets/${TARGET_ID}/configuredTargets/${CONFIG_ID}/actions/${ACTION_ID}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource ID components that identify the Action. They must match the
	// resource name after proper encoding.
	Id *Action_Id `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// The status of the action.
	StatusAttributes *StatusAttributes `protobuf:"bytes,3,opt,name=status_attributes,json=statusAttributes,proto3" json:"status_attributes,omitempty"`
	// The timing of the whole action. For TestActions, the start time may be
	// before the test actually started, and the duration may last until after the
	// test actually finished.
	Timing *Timing `protobuf:"bytes,4,opt,name=timing,proto3" json:"timing,omitempty"`
	// The type of the action. The type of an action may not change over the
	// lifetime of the invocation. If one of these fields is to be set, it must be
	// set in the CreateAction method. It may be set to an empty message that is
	// populated in later methods or post-processing. A generic "untyped" action
	// can be created by not setting any of these fields. An untyped action will
	// be untyped for the lifetime of the invocation.
	//
	// Types that are valid to be assigned to ActionType:
	//	*Action_BuildAction
	//	*Action_TestAction
	ActionType isAction_ActionType `protobuf_oneof:"action_type"`
	// General attributes of the action.
	ActionAttributes *ActionAttributes `protobuf:"bytes,5,opt,name=action_attributes,json=actionAttributes,proto3" json:"action_attributes,omitempty"`
	// A list of resources that this action depended upon. May be used to provide
	// the cause of a build failure in the case of a failed build action.
	ActionDependencies []*Dependency `protobuf:"bytes,14,rep,name=action_dependencies,json=actionDependencies,proto3" json:"action_dependencies,omitempty"`
	// Arbitrary name-value pairs.
	// This is implemented as a multi-map. Multiple properties are allowed with
	// the same key. Properties will be returned in lexicographical order by key.
	Properties []*Property `protobuf:"bytes,7,rep,name=properties,proto3" json:"properties,omitempty"`
	// A list of file references for action level files.
	// The file IDs must be unique within this list. Duplicate file IDs will
	// result in an error. Files will be returned in lexicographical order by ID.
	// Files with the following reserved file IDs cause specific post-processing
	// or have special handling:
	//
	// For build actions:
	// stdout: The stdout of the action
	// stderr: The stderr of the action
	// baseline.lcov: Baseline coverage file to be parsed by the server. This
	//     uses a stripped down implementation of the LCOV standard.
	//     http://ltp.sourceforge.net/coverage/lcov/geninfo.1.php
	//
	// For test actions:
	// test.xml: The test suite / test case data in XML format.
	// test.log: The combined stdout and stderr of the test process.
	// test.lcov: Coverage file to be parsed by the server. This uses a stripped
	//     down implementation of the LCOV standard.
	//     http://ltp.sourceforge.net/coverage/lcov/geninfo.1.php
	Files []*File `protobuf:"bytes,8,rep,name=files,proto3" json:"files,omitempty"`
	// Coverage data was collected while running the build or test action. This
	// usually includes line coverage, and may also include branch coverage.
	// For test actions, this is usually only for the source files which were
	// actually executed by that particular action.
	// For build actions, this is the baseline coverage, which captures the
	// instrumented files and lines, without any lines being executed. This
	// ensures files that are never covered at all are included.
	Coverage *ActionCoverage `protobuf:"bytes,11,opt,name=coverage,proto3" json:"coverage,omitempty"`
	// ResultStore will read and parse Files with reserved IDs listed above. Read
	// and parse errors for all these Files are reported here.
	// This is implemented as a map, with one FileProcessingErrors for each file.
	// Typically produced when parsing Files, but may also be provided directly
	// by clients.
	FileProcessingErrors []*FileProcessingErrors `protobuf:"bytes,13,rep,name=file_processing_errors,json=fileProcessingErrors,proto3" json:"file_processing_errors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *Action) Reset()         { *m = Action{} }
func (m *Action) String() string { return proto.CompactTextString(m) }
func (*Action) ProtoMessage()    {}
func (*Action) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{0}
}

func (m *Action) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Action.Unmarshal(m, b)
}
func (m *Action) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Action.Marshal(b, m, deterministic)
}
func (m *Action) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Action.Merge(m, src)
}
func (m *Action) XXX_Size() int {
	return xxx_messageInfo_Action.Size(m)
}
func (m *Action) XXX_DiscardUnknown() {
	xxx_messageInfo_Action.DiscardUnknown(m)
}

var xxx_messageInfo_Action proto.InternalMessageInfo

func (m *Action) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Action) GetId() *Action_Id {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *Action) GetStatusAttributes() *StatusAttributes {
	if m != nil {
		return m.StatusAttributes
	}
	return nil
}

func (m *Action) GetTiming() *Timing {
	if m != nil {
		return m.Timing
	}
	return nil
}

type isAction_ActionType interface {
	isAction_ActionType()
}

type Action_BuildAction struct {
	BuildAction *BuildAction `protobuf:"bytes,9,opt,name=build_action,json=buildAction,proto3,oneof"`
}

type Action_TestAction struct {
	TestAction *TestAction `protobuf:"bytes,10,opt,name=test_action,json=testAction,proto3,oneof"`
}

func (*Action_BuildAction) isAction_ActionType() {}

func (*Action_TestAction) isAction_ActionType() {}

func (m *Action) GetActionType() isAction_ActionType {
	if m != nil {
		return m.ActionType
	}
	return nil
}

func (m *Action) GetBuildAction() *BuildAction {
	if x, ok := m.GetActionType().(*Action_BuildAction); ok {
		return x.BuildAction
	}
	return nil
}

func (m *Action) GetTestAction() *TestAction {
	if x, ok := m.GetActionType().(*Action_TestAction); ok {
		return x.TestAction
	}
	return nil
}

func (m *Action) GetActionAttributes() *ActionAttributes {
	if m != nil {
		return m.ActionAttributes
	}
	return nil
}

func (m *Action) GetActionDependencies() []*Dependency {
	if m != nil {
		return m.ActionDependencies
	}
	return nil
}

func (m *Action) GetProperties() []*Property {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *Action) GetFiles() []*File {
	if m != nil {
		return m.Files
	}
	return nil
}

func (m *Action) GetCoverage() *ActionCoverage {
	if m != nil {
		return m.Coverage
	}
	return nil
}

func (m *Action) GetFileProcessingErrors() []*FileProcessingErrors {
	if m != nil {
		return m.FileProcessingErrors
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Action) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Action_BuildAction)(nil),
		(*Action_TestAction)(nil),
	}
}

// The resource ID components that identify the Action.
type Action_Id struct {
	// The Invocation ID.
	InvocationId string `protobuf:"bytes,1,opt,name=invocation_id,json=invocationId,proto3" json:"invocation_id,omitempty"`
	// The Target ID.
	TargetId string `protobuf:"bytes,2,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// The Configuration ID.
	ConfigurationId string `protobuf:"bytes,3,opt,name=configuration_id,json=configurationId,proto3" json:"configuration_id,omitempty"`
	// The Action ID.
	ActionId             string   `protobuf:"bytes,4,opt,name=action_id,json=actionId,proto3" json:"action_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Action_Id) Reset()         { *m = Action_Id{} }
func (m *Action_Id) String() string { return proto.CompactTextString(m) }
func (*Action_Id) ProtoMessage()    {}
func (*Action_Id) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{0, 0}
}

func (m *Action_Id) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Action_Id.Unmarshal(m, b)
}
func (m *Action_Id) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Action_Id.Marshal(b, m, deterministic)
}
func (m *Action_Id) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Action_Id.Merge(m, src)
}
func (m *Action_Id) XXX_Size() int {
	return xxx_messageInfo_Action_Id.Size(m)
}
func (m *Action_Id) XXX_DiscardUnknown() {
	xxx_messageInfo_Action_Id.DiscardUnknown(m)
}

var xxx_messageInfo_Action_Id proto.InternalMessageInfo

func (m *Action_Id) GetInvocationId() string {
	if m != nil {
		return m.InvocationId
	}
	return ""
}

func (m *Action_Id) GetTargetId() string {
	if m != nil {
		return m.TargetId
	}
	return ""
}

func (m *Action_Id) GetConfigurationId() string {
	if m != nil {
		return m.ConfigurationId
	}
	return ""
}

func (m *Action_Id) GetActionId() string {
	if m != nil {
		return m.ActionId
	}
	return ""
}

// A build action, such as building a java library.
type BuildAction struct {
	// The type of the action.  This is intended to be a clue as to how the output
	// of the action should be parsed. For example "javac" for a Java compile
	// action.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// The "primary" input artifact processed by this action.  E.g., the .cc file
	// of a C++ compile action.  Empty string ("") if the action has no input
	// artifacts or no "primary" input artifact.
	PrimaryInputPath string `protobuf:"bytes,2,opt,name=primary_input_path,json=primaryInputPath,proto3" json:"primary_input_path,omitempty"`
	// The "primary" output artifact processed by this action.  E.g., the .o file
	// of a C++ compile action.  Empty string ("") if the action has no output
	// artifacts or no "primary" output artifact.
	PrimaryOutputPath    string   `protobuf:"bytes,3,opt,name=primary_output_path,json=primaryOutputPath,proto3" json:"primary_output_path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BuildAction) Reset()         { *m = BuildAction{} }
func (m *BuildAction) String() string { return proto.CompactTextString(m) }
func (*BuildAction) ProtoMessage()    {}
func (*BuildAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{1}
}

func (m *BuildAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BuildAction.Unmarshal(m, b)
}
func (m *BuildAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BuildAction.Marshal(b, m, deterministic)
}
func (m *BuildAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildAction.Merge(m, src)
}
func (m *BuildAction) XXX_Size() int {
	return xxx_messageInfo_BuildAction.Size(m)
}
func (m *BuildAction) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildAction.DiscardUnknown(m)
}

var xxx_messageInfo_BuildAction proto.InternalMessageInfo

func (m *BuildAction) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *BuildAction) GetPrimaryInputPath() string {
	if m != nil {
		return m.PrimaryInputPath
	}
	return ""
}

func (m *BuildAction) GetPrimaryOutputPath() string {
	if m != nil {
		return m.PrimaryOutputPath
	}
	return ""
}

// A test action, such as running a JUnit4 test binary.
type TestAction struct {
	// Timing data for execution of the test action.
	TestTiming *TestTiming `protobuf:"bytes,1,opt,name=test_timing,json=testTiming,proto3" json:"test_timing,omitempty"`
	// If the test is divided up into shards to improve performance, set this to
	// indicate which shard this test action is for. Value must be in interval
	// [0, total_shard_count). Defaults to 0, which is appropriate if all test
	// cases are run in the same process.
	ShardNumber int32 `protobuf:"varint,2,opt,name=shard_number,json=shardNumber,proto3" json:"shard_number,omitempty"`
	// If the user requested that every test be run multiple times, as is often
	// done to measure flakiness, set this to indicate which run this test action
	// is for. Value must be in interval [0, total_run_count). Defaults to 0,
	// which is appropriate if multiple runs were not requested.
	RunNumber int32 `protobuf:"varint,3,opt,name=run_number,json=runNumber,proto3" json:"run_number,omitempty"`
	// If flaky tests are automatically retried, set this to indicate which
	// attempt this test action is for. (e.g. 0 for the first attempt, 1 for
	// second, and so on). Defaults to 0, which is appropriate if this is only
	// attempt.
	AttemptNumber int32 `protobuf:"varint,4,opt,name=attempt_number,json=attemptNumber,proto3" json:"attempt_number,omitempty"`
	// A tree of test suites and test cases that were run by this test action.
	// Each test case has its own status information, including stack traces.
	// Typically produced by parsing an XML Log, but may also be provided directly
	// by clients.
	TestSuite *TestSuite `protobuf:"bytes,5,opt,name=test_suite,json=testSuite,proto3" json:"test_suite,omitempty"`
	// Warnings for this test action.
	Warnings []*TestWarning `protobuf:"bytes,8,rep,name=warnings,proto3" json:"warnings,omitempty"`
	// Estimated memory consumption of the test action, in bytes. A default value
	// of 0 means there is no memory consumption estimate specified.
	EstimatedMemoryBytes int64    `protobuf:"varint,10,opt,name=estimated_memory_bytes,json=estimatedMemoryBytes,proto3" json:"estimated_memory_bytes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestAction) Reset()         { *m = TestAction{} }
func (m *TestAction) String() string { return proto.CompactTextString(m) }
func (*TestAction) ProtoMessage()    {}
func (*TestAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{2}
}

func (m *TestAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestAction.Unmarshal(m, b)
}
func (m *TestAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestAction.Marshal(b, m, deterministic)
}
func (m *TestAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestAction.Merge(m, src)
}
func (m *TestAction) XXX_Size() int {
	return xxx_messageInfo_TestAction.Size(m)
}
func (m *TestAction) XXX_DiscardUnknown() {
	xxx_messageInfo_TestAction.DiscardUnknown(m)
}

var xxx_messageInfo_TestAction proto.InternalMessageInfo

func (m *TestAction) GetTestTiming() *TestTiming {
	if m != nil {
		return m.TestTiming
	}
	return nil
}

func (m *TestAction) GetShardNumber() int32 {
	if m != nil {
		return m.ShardNumber
	}
	return 0
}

func (m *TestAction) GetRunNumber() int32 {
	if m != nil {
		return m.RunNumber
	}
	return 0
}

func (m *TestAction) GetAttemptNumber() int32 {
	if m != nil {
		return m.AttemptNumber
	}
	return 0
}

func (m *TestAction) GetTestSuite() *TestSuite {
	if m != nil {
		return m.TestSuite
	}
	return nil
}

func (m *TestAction) GetWarnings() []*TestWarning {
	if m != nil {
		return m.Warnings
	}
	return nil
}

func (m *TestAction) GetEstimatedMemoryBytes() int64 {
	if m != nil {
		return m.EstimatedMemoryBytes
	}
	return 0
}

// General attributes of an action
type ActionAttributes struct {
	// Strategy used for executing the action.
	ExecutionStrategy ExecutionStrategy `protobuf:"varint,1,opt,name=execution_strategy,json=executionStrategy,proto3,enum=google.devtools.resultstore.v2.ExecutionStrategy" json:"execution_strategy,omitempty"`
	// Exit code of the process that ran the action. A non-zero value means
	// failure.
	ExitCode int32 `protobuf:"varint,2,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
	// Where the action was run.
	Hostname string `protobuf:"bytes,3,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Information about the input files used in all actions under this configured
	// target.
	InputFileInfo        *InputFileInfo `protobuf:"bytes,4,opt,name=input_file_info,json=inputFileInfo,proto3" json:"input_file_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ActionAttributes) Reset()         { *m = ActionAttributes{} }
func (m *ActionAttributes) String() string { return proto.CompactTextString(m) }
func (*ActionAttributes) ProtoMessage()    {}
func (*ActionAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{3}
}

func (m *ActionAttributes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ActionAttributes.Unmarshal(m, b)
}
func (m *ActionAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ActionAttributes.Marshal(b, m, deterministic)
}
func (m *ActionAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ActionAttributes.Merge(m, src)
}
func (m *ActionAttributes) XXX_Size() int {
	return xxx_messageInfo_ActionAttributes.Size(m)
}
func (m *ActionAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_ActionAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_ActionAttributes proto.InternalMessageInfo

func (m *ActionAttributes) GetExecutionStrategy() ExecutionStrategy {
	if m != nil {
		return m.ExecutionStrategy
	}
	return ExecutionStrategy_EXECUTION_STRATEGY_UNSPECIFIED
}

func (m *ActionAttributes) GetExitCode() int32 {
	if m != nil {
		return m.ExitCode
	}
	return 0
}

func (m *ActionAttributes) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

func (m *ActionAttributes) GetInputFileInfo() *InputFileInfo {
	if m != nil {
		return m.InputFileInfo
	}
	return nil
}

// File count and size information for the input files to a configured target.
type InputFileInfo struct {
	// The number of input files (counting every file, even if a duplicate).
	Count int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// The number of distinct input files.
	DistinctCount int64 `protobuf:"varint,2,opt,name=distinct_count,json=distinctCount,proto3" json:"distinct_count,omitempty"`
	// The max number of input files allowed by the build system (counting every
	// file, even if a duplicate).
	CountLimit int64 `protobuf:"varint,3,opt,name=count_limit,json=countLimit,proto3" json:"count_limit,omitempty"`
	// The total size of the distinct input files.
	DistinctBytes int64 `protobuf:"varint,4,opt,name=distinct_bytes,json=distinctBytes,proto3" json:"distinct_bytes,omitempty"`
	// The max allowed total size of the distinct input files.
	DistinctByteLimit    int64    `protobuf:"varint,5,opt,name=distinct_byte_limit,json=distinctByteLimit,proto3" json:"distinct_byte_limit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InputFileInfo) Reset()         { *m = InputFileInfo{} }
func (m *InputFileInfo) String() string { return proto.CompactTextString(m) }
func (*InputFileInfo) ProtoMessage()    {}
func (*InputFileInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{4}
}

func (m *InputFileInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InputFileInfo.Unmarshal(m, b)
}
func (m *InputFileInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InputFileInfo.Marshal(b, m, deterministic)
}
func (m *InputFileInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InputFileInfo.Merge(m, src)
}
func (m *InputFileInfo) XXX_Size() int {
	return xxx_messageInfo_InputFileInfo.Size(m)
}
func (m *InputFileInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_InputFileInfo.DiscardUnknown(m)
}

var xxx_messageInfo_InputFileInfo proto.InternalMessageInfo

func (m *InputFileInfo) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *InputFileInfo) GetDistinctCount() int64 {
	if m != nil {
		return m.DistinctCount
	}
	return 0
}

func (m *InputFileInfo) GetCountLimit() int64 {
	if m != nil {
		return m.CountLimit
	}
	return 0
}

func (m *InputFileInfo) GetDistinctBytes() int64 {
	if m != nil {
		return m.DistinctBytes
	}
	return 0
}

func (m *InputFileInfo) GetDistinctByteLimit() int64 {
	if m != nil {
		return m.DistinctByteLimit
	}
	return 0
}

// Timing data for tests executed locally on the machine running the build.
type LocalTestTiming struct {
	// Time taken by the test process, typically surrounded by a small wrapper
	// script.
	TestProcessDuration  *duration.Duration `protobuf:"bytes,1,opt,name=test_process_duration,json=testProcessDuration,proto3" json:"test_process_duration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *LocalTestTiming) Reset()         { *m = LocalTestTiming{} }
func (m *LocalTestTiming) String() string { return proto.CompactTextString(m) }
func (*LocalTestTiming) ProtoMessage()    {}
func (*LocalTestTiming) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{5}
}

func (m *LocalTestTiming) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocalTestTiming.Unmarshal(m, b)
}
func (m *LocalTestTiming) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocalTestTiming.Marshal(b, m, deterministic)
}
func (m *LocalTestTiming) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocalTestTiming.Merge(m, src)
}
func (m *LocalTestTiming) XXX_Size() int {
	return xxx_messageInfo_LocalTestTiming.Size(m)
}
func (m *LocalTestTiming) XXX_DiscardUnknown() {
	xxx_messageInfo_LocalTestTiming.DiscardUnknown(m)
}

var xxx_messageInfo_LocalTestTiming proto.InternalMessageInfo

func (m *LocalTestTiming) GetTestProcessDuration() *duration.Duration {
	if m != nil {
		return m.TestProcessDuration
	}
	return nil
}

// Timing data for one attempt to execute a test action remotely.
type RemoteTestAttemptTiming struct {
	// Idle period before the test process is invoked on the remote machine.
	QueueDuration *duration.Duration `protobuf:"bytes,1,opt,name=queue_duration,json=queueDuration,proto3" json:"queue_duration,omitempty"`
	// Time to upload data dependencies from the local machine to the remote
	// machine running the test, or to the distributed cache.
	UploadDuration *duration.Duration `protobuf:"bytes,2,opt,name=upload_duration,json=uploadDuration,proto3" json:"upload_duration,omitempty"`
	// Time to set up the remote machine.
	// Not to be confused with setup time in
	// xUnit test frameworks, which falls within the test_process_time.
	MachineSetupDuration *duration.Duration `protobuf:"bytes,3,opt,name=machine_setup_duration,json=machineSetupDuration,proto3" json:"machine_setup_duration,omitempty"`
	// Time taken by the test process, typically surrounded by a small wrapper
	// script.
	// For Java tests, this includes JVM setup, flag parsing, class path setup,
	// parsing files to setup the suite, and finally running your test methods.
	// In many cases, only a small fraction of the test process time is spent
	// running the test methods.
	TestProcessDuration *duration.Duration `protobuf:"bytes,4,opt,name=test_process_duration,json=testProcessDuration,proto3" json:"test_process_duration,omitempty"`
	// Time spent retrieving test logs and any other test outputs, back to the
	// local machine.
	DownloadDuration     *duration.Duration `protobuf:"bytes,5,opt,name=download_duration,json=downloadDuration,proto3" json:"download_duration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *RemoteTestAttemptTiming) Reset()         { *m = RemoteTestAttemptTiming{} }
func (m *RemoteTestAttemptTiming) String() string { return proto.CompactTextString(m) }
func (*RemoteTestAttemptTiming) ProtoMessage()    {}
func (*RemoteTestAttemptTiming) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{6}
}

func (m *RemoteTestAttemptTiming) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoteTestAttemptTiming.Unmarshal(m, b)
}
func (m *RemoteTestAttemptTiming) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoteTestAttemptTiming.Marshal(b, m, deterministic)
}
func (m *RemoteTestAttemptTiming) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoteTestAttemptTiming.Merge(m, src)
}
func (m *RemoteTestAttemptTiming) XXX_Size() int {
	return xxx_messageInfo_RemoteTestAttemptTiming.Size(m)
}
func (m *RemoteTestAttemptTiming) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoteTestAttemptTiming.DiscardUnknown(m)
}

var xxx_messageInfo_RemoteTestAttemptTiming proto.InternalMessageInfo

func (m *RemoteTestAttemptTiming) GetQueueDuration() *duration.Duration {
	if m != nil {
		return m.QueueDuration
	}
	return nil
}

func (m *RemoteTestAttemptTiming) GetUploadDuration() *duration.Duration {
	if m != nil {
		return m.UploadDuration
	}
	return nil
}

func (m *RemoteTestAttemptTiming) GetMachineSetupDuration() *duration.Duration {
	if m != nil {
		return m.MachineSetupDuration
	}
	return nil
}

func (m *RemoteTestAttemptTiming) GetTestProcessDuration() *duration.Duration {
	if m != nil {
		return m.TestProcessDuration
	}
	return nil
}

func (m *RemoteTestAttemptTiming) GetDownloadDuration() *duration.Duration {
	if m != nil {
		return m.DownloadDuration
	}
	return nil
}

// Timing data for the part of the test execution that is done remotely.
type RemoteTestTiming struct {
	// Time taken locally to determine what to do.
	LocalAnalysisDuration *duration.Duration `protobuf:"bytes,1,opt,name=local_analysis_duration,json=localAnalysisDuration,proto3" json:"local_analysis_duration,omitempty"`
	// Normally there is only one attempt, but the system may retry on internal
	// errors, leading to multiple attempts.
	Attempts             []*RemoteTestAttemptTiming `protobuf:"bytes,2,rep,name=attempts,proto3" json:"attempts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *RemoteTestTiming) Reset()         { *m = RemoteTestTiming{} }
func (m *RemoteTestTiming) String() string { return proto.CompactTextString(m) }
func (*RemoteTestTiming) ProtoMessage()    {}
func (*RemoteTestTiming) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{7}
}

func (m *RemoteTestTiming) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoteTestTiming.Unmarshal(m, b)
}
func (m *RemoteTestTiming) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoteTestTiming.Marshal(b, m, deterministic)
}
func (m *RemoteTestTiming) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoteTestTiming.Merge(m, src)
}
func (m *RemoteTestTiming) XXX_Size() int {
	return xxx_messageInfo_RemoteTestTiming.Size(m)
}
func (m *RemoteTestTiming) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoteTestTiming.DiscardUnknown(m)
}

var xxx_messageInfo_RemoteTestTiming proto.InternalMessageInfo

func (m *RemoteTestTiming) GetLocalAnalysisDuration() *duration.Duration {
	if m != nil {
		return m.LocalAnalysisDuration
	}
	return nil
}

func (m *RemoteTestTiming) GetAttempts() []*RemoteTestAttemptTiming {
	if m != nil {
		return m.Attempts
	}
	return nil
}

// Timing data for execution of a test action. The action may be performed
// locally, on the machine running the build, or remotely.
type TestTiming struct {
	// Test timing for either a local or remote execution.
	//
	// Types that are valid to be assigned to Location:
	//	*TestTiming_Local
	//	*TestTiming_Remote
	Location isTestTiming_Location `protobuf_oneof:"location"`
	// The amount of CPU time spent by the test process executing system calls
	// within the kernel, as opposed to library code. Time the test process spent
	// blocked does not count towards this figure.
	SystemTimeDuration *duration.Duration `protobuf:"bytes,3,opt,name=system_time_duration,json=systemTimeDuration,proto3" json:"system_time_duration,omitempty"`
	// The amount of CPU time spent by the test process executing user-mode code
	// outside the kernel, as opposed to library code. Time the test process
	// spent blocked does not count towards this figure. You can add user_time to
	// system_time to get total CPU time taken by the test process.
	UserTimeDuration *duration.Duration `protobuf:"bytes,4,opt,name=user_time_duration,json=userTimeDuration,proto3" json:"user_time_duration,omitempty"`
	// Most build systems cache build results to speed up incremental builds.
	// Some also cache test results too. This indicates whether the test results
	// were found in a cache, and where that cache was located.
	TestCaching          TestCaching `protobuf:"varint,5,opt,name=test_caching,json=testCaching,proto3,enum=google.devtools.resultstore.v2.TestCaching" json:"test_caching,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *TestTiming) Reset()         { *m = TestTiming{} }
func (m *TestTiming) String() string { return proto.CompactTextString(m) }
func (*TestTiming) ProtoMessage()    {}
func (*TestTiming) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{8}
}

func (m *TestTiming) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestTiming.Unmarshal(m, b)
}
func (m *TestTiming) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestTiming.Marshal(b, m, deterministic)
}
func (m *TestTiming) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestTiming.Merge(m, src)
}
func (m *TestTiming) XXX_Size() int {
	return xxx_messageInfo_TestTiming.Size(m)
}
func (m *TestTiming) XXX_DiscardUnknown() {
	xxx_messageInfo_TestTiming.DiscardUnknown(m)
}

var xxx_messageInfo_TestTiming proto.InternalMessageInfo

type isTestTiming_Location interface {
	isTestTiming_Location()
}

type TestTiming_Local struct {
	Local *LocalTestTiming `protobuf:"bytes,1,opt,name=local,proto3,oneof"`
}

type TestTiming_Remote struct {
	Remote *RemoteTestTiming `protobuf:"bytes,2,opt,name=remote,proto3,oneof"`
}

func (*TestTiming_Local) isTestTiming_Location() {}

func (*TestTiming_Remote) isTestTiming_Location() {}

func (m *TestTiming) GetLocation() isTestTiming_Location {
	if m != nil {
		return m.Location
	}
	return nil
}

func (m *TestTiming) GetLocal() *LocalTestTiming {
	if x, ok := m.GetLocation().(*TestTiming_Local); ok {
		return x.Local
	}
	return nil
}

func (m *TestTiming) GetRemote() *RemoteTestTiming {
	if x, ok := m.GetLocation().(*TestTiming_Remote); ok {
		return x.Remote
	}
	return nil
}

func (m *TestTiming) GetSystemTimeDuration() *duration.Duration {
	if m != nil {
		return m.SystemTimeDuration
	}
	return nil
}

func (m *TestTiming) GetUserTimeDuration() *duration.Duration {
	if m != nil {
		return m.UserTimeDuration
	}
	return nil
}

func (m *TestTiming) GetTestCaching() TestCaching {
	if m != nil {
		return m.TestCaching
	}
	return TestCaching_TEST_CACHING_UNSPECIFIED
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*TestTiming) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*TestTiming_Local)(nil),
		(*TestTiming_Remote)(nil),
	}
}

// A warning from a test execution.
type TestWarning struct {
	// Contains the message detailing the warning.
	WarningMessage       string   `protobuf:"bytes,1,opt,name=warning_message,json=warningMessage,proto3" json:"warning_message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestWarning) Reset()         { *m = TestWarning{} }
func (m *TestWarning) String() string { return proto.CompactTextString(m) }
func (*TestWarning) ProtoMessage()    {}
func (*TestWarning) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{9}
}

func (m *TestWarning) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestWarning.Unmarshal(m, b)
}
func (m *TestWarning) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestWarning.Marshal(b, m, deterministic)
}
func (m *TestWarning) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestWarning.Merge(m, src)
}
func (m *TestWarning) XXX_Size() int {
	return xxx_messageInfo_TestWarning.Size(m)
}
func (m *TestWarning) XXX_DiscardUnknown() {
	xxx_messageInfo_TestWarning.DiscardUnknown(m)
}

var xxx_messageInfo_TestWarning proto.InternalMessageInfo

func (m *TestWarning) GetWarningMessage() string {
	if m != nil {
		return m.WarningMessage
	}
	return ""
}

// Stores errors reading or parsing a file during post-processing.
type FileProcessingErrors struct {
	// The uid of the File being read or parsed.
	FileUid string `protobuf:"bytes,1,opt,name=file_uid,json=fileUid,proto3" json:"file_uid,omitempty"`
	// What went wrong.
	FileProcessingErrors []*FileProcessingError `protobuf:"bytes,3,rep,name=file_processing_errors,json=fileProcessingErrors,proto3" json:"file_processing_errors,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *FileProcessingErrors) Reset()         { *m = FileProcessingErrors{} }
func (m *FileProcessingErrors) String() string { return proto.CompactTextString(m) }
func (*FileProcessingErrors) ProtoMessage()    {}
func (*FileProcessingErrors) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{10}
}

func (m *FileProcessingErrors) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FileProcessingErrors.Unmarshal(m, b)
}
func (m *FileProcessingErrors) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FileProcessingErrors.Marshal(b, m, deterministic)
}
func (m *FileProcessingErrors) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FileProcessingErrors.Merge(m, src)
}
func (m *FileProcessingErrors) XXX_Size() int {
	return xxx_messageInfo_FileProcessingErrors.Size(m)
}
func (m *FileProcessingErrors) XXX_DiscardUnknown() {
	xxx_messageInfo_FileProcessingErrors.DiscardUnknown(m)
}

var xxx_messageInfo_FileProcessingErrors proto.InternalMessageInfo

func (m *FileProcessingErrors) GetFileUid() string {
	if m != nil {
		return m.FileUid
	}
	return ""
}

func (m *FileProcessingErrors) GetFileProcessingErrors() []*FileProcessingError {
	if m != nil {
		return m.FileProcessingErrors
	}
	return nil
}

// Stores an error reading or parsing a file during post-processing.
type FileProcessingError struct {
	// The type of error that occurred.
	Type FileProcessingErrorType `protobuf:"varint,1,opt,name=type,proto3,enum=google.devtools.resultstore.v2.FileProcessingErrorType" json:"type,omitempty"`
	// Error message describing the problem.
	Message              string   `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FileProcessingError) Reset()         { *m = FileProcessingError{} }
func (m *FileProcessingError) String() string { return proto.CompactTextString(m) }
func (*FileProcessingError) ProtoMessage()    {}
func (*FileProcessingError) Descriptor() ([]byte, []int) {
	return fileDescriptor_e98e32542f2d3836, []int{11}
}

func (m *FileProcessingError) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FileProcessingError.Unmarshal(m, b)
}
func (m *FileProcessingError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FileProcessingError.Marshal(b, m, deterministic)
}
func (m *FileProcessingError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FileProcessingError.Merge(m, src)
}
func (m *FileProcessingError) XXX_Size() int {
	return xxx_messageInfo_FileProcessingError.Size(m)
}
func (m *FileProcessingError) XXX_DiscardUnknown() {
	xxx_messageInfo_FileProcessingError.DiscardUnknown(m)
}

var xxx_messageInfo_FileProcessingError proto.InternalMessageInfo

func (m *FileProcessingError) GetType() FileProcessingErrorType {
	if m != nil {
		return m.Type
	}
	return FileProcessingErrorType_FILE_PROCESSING_ERROR_TYPE_UNSPECIFIED
}

func (m *FileProcessingError) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.devtools.resultstore.v2.ExecutionStrategy", ExecutionStrategy_name, ExecutionStrategy_value)
	proto.RegisterEnum("google.devtools.resultstore.v2.TestCaching", TestCaching_name, TestCaching_value)
	proto.RegisterEnum("google.devtools.resultstore.v2.FileProcessingErrorType", FileProcessingErrorType_name, FileProcessingErrorType_value)
	proto.RegisterType((*Action)(nil), "google.devtools.resultstore.v2.Action")
	proto.RegisterType((*Action_Id)(nil), "google.devtools.resultstore.v2.Action.Id")
	proto.RegisterType((*BuildAction)(nil), "google.devtools.resultstore.v2.BuildAction")
	proto.RegisterType((*TestAction)(nil), "google.devtools.resultstore.v2.TestAction")
	proto.RegisterType((*ActionAttributes)(nil), "google.devtools.resultstore.v2.ActionAttributes")
	proto.RegisterType((*InputFileInfo)(nil), "google.devtools.resultstore.v2.InputFileInfo")
	proto.RegisterType((*LocalTestTiming)(nil), "google.devtools.resultstore.v2.LocalTestTiming")
	proto.RegisterType((*RemoteTestAttemptTiming)(nil), "google.devtools.resultstore.v2.RemoteTestAttemptTiming")
	proto.RegisterType((*RemoteTestTiming)(nil), "google.devtools.resultstore.v2.RemoteTestTiming")
	proto.RegisterType((*TestTiming)(nil), "google.devtools.resultstore.v2.TestTiming")
	proto.RegisterType((*TestWarning)(nil), "google.devtools.resultstore.v2.TestWarning")
	proto.RegisterType((*FileProcessingErrors)(nil), "google.devtools.resultstore.v2.FileProcessingErrors")
	proto.RegisterType((*FileProcessingError)(nil), "google.devtools.resultstore.v2.FileProcessingError")
}

func init() {
	proto.RegisterFile("google/devtools/resultstore/v2/action.proto", fileDescriptor_e98e32542f2d3836)
}

var fileDescriptor_e98e32542f2d3836 = []byte{
	// 1620 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x58, 0x5f, 0x73, 0x23, 0x47,
	0x11, 0x3f, 0x49, 0xb6, 0x4f, 0x6e, 0x9d, 0xe4, 0xf5, 0xd8, 0x77, 0xa7, 0x1c, 0x10, 0x0e, 0x01,
	0xe1, 0xce, 0x47, 0xa4, 0xe0, 0xa4, 0xa0, 0x80, 0x2a, 0x0a, 0x59, 0x1a, 0xdb, 0x9b, 0x93, 0x25,
	0x65, 0xb4, 0x0a, 0x09, 0x14, 0x35, 0x59, 0x6b, 0xc7, 0xf2, 0x50, 0xda, 0x5d, 0x65, 0x77, 0xd6,
	0x89, 0xaa, 0xa8, 0xe2, 0x85, 0x2a, 0x1e, 0xa0, 0x78, 0xe1, 0x95, 0x2f, 0xc1, 0x2b, 0xcf, 0x7c,
	0x09, 0xbe, 0x0d, 0x35, 0x7f, 0x76, 0x25, 0x0b, 0x3b, 0xab, 0xbb, 0x37, 0x4d, 0xf7, 0xef, 0xf7,
	0x9b, 0xde, 0x9e, 0xee, 0x99, 0x2e, 0xc1, 0xab, 0x69, 0x18, 0x4e, 0x67, 0xac, 0xe5, 0xb1, 0x1b,
	0x11, 0x86, 0xb3, 0xb8, 0x15, 0xb1, 0x38, 0x99, 0x89, 0x58, 0x84, 0x11, 0x6b, 0xdd, 0x1c, 0xb7,
	0xdc, 0x89, 0xe0, 0x61, 0xd0, 0x9c, 0x47, 0xa1, 0x08, 0xd1, 0xbb, 0x1a, 0xdc, 0x4c, 0xc1, 0xcd,
	0x15, 0x70, 0xf3, 0xe6, 0xf8, 0x59, 0x9e, 0xd8, 0x24, 0xf4, 0xfd, 0x54, 0xec, 0xd9, 0xfb, 0xb9,
	0xe0, 0x1b, 0x16, 0xb9, 0x53, 0x66, 0xe0, 0x2f, 0x73, 0xe0, 0x57, 0x7c, 0x96, 0x42, 0x5b, 0x39,
	0x50, 0xc1, 0x62, 0x41, 0xe3, 0x84, 0x8b, 0x94, 0x60, 0xbe, 0xab, 0xa5, 0x56, 0x97, 0xc9, 0x55,
	0xcb, 0x4b, 0x22, 0x77, 0xf9, 0xdd, 0x8d, 0x7f, 0x95, 0x61, 0xa7, 0xad, 0x12, 0x81, 0x10, 0x6c,
	0x05, 0xae, 0xcf, 0xea, 0x85, 0xe7, 0x85, 0x17, 0xbb, 0x44, 0xfd, 0x46, 0x3f, 0x87, 0x22, 0xf7,
	0xea, 0xc5, 0xe7, 0x85, 0x17, 0x95, 0xe3, 0x97, 0xcd, 0x6f, 0xce, 0x51, 0x53, 0xeb, 0x34, 0x6d,
	0x8f, 0x14, 0xb9, 0x87, 0x7e, 0x0f, 0xfb, 0xb1, 0x70, 0x45, 0x12, 0x53, 0x57, 0x88, 0x88, 0x5f,
	0x26, 0x82, 0xc5, 0xf5, 0x92, 0x52, 0xfa, 0x20, 0x4f, 0x69, 0xa4, 0x88, 0xed, 0x8c, 0x47, 0xac,
	0x78, 0xcd, 0x82, 0x7e, 0x05, 0x3b, 0x82, 0xfb, 0x3c, 0x98, 0xd6, 0xb7, 0x94, 0xe6, 0x7b, 0x79,
	0x9a, 0x8e, 0x42, 0x13, 0xc3, 0x42, 0x43, 0x78, 0x74, 0x99, 0xf0, 0x99, 0x47, 0x75, 0x19, 0xd4,
	0x77, 0x95, 0xca, 0xab, 0x3c, 0x95, 0x13, 0xc9, 0xd1, 0x1f, 0x7a, 0xfe, 0x80, 0x54, 0x2e, 0x97,
	0x4b, 0x74, 0x01, 0x15, 0x95, 0x7e, 0x23, 0x08, 0x4a, 0xf0, 0x28, 0x37, 0x2c, 0x16, 0x8b, 0x4c,
	0x0f, 0x44, 0xb6, 0x92, 0xf9, 0xd3, 0x4a, 0xab, 0xf9, 0xdb, 0xde, 0x2c, 0x7f, 0x5a, 0x62, 0x35,
	0x7f, 0xee, 0x9a, 0x05, 0xfd, 0x0e, 0x0e, 0x8c, 0xbc, 0xc7, 0xe6, 0x2c, 0xf0, 0x58, 0x30, 0xe1,
	0x2c, 0xae, 0xd7, 0x9e, 0x97, 0x36, 0x89, 0xba, 0x9b, 0x72, 0x16, 0x04, 0x69, 0x99, 0xee, 0x8a,
	0x0a, 0x3a, 0x07, 0x98, 0x47, 0xe1, 0x9c, 0x45, 0x42, 0x6a, 0x3e, 0x54, 0x9a, 0x2f, 0xf2, 0x34,
	0x87, 0x9a, 0xb1, 0x20, 0x2b, 0x5c, 0xf4, 0x0b, 0xd8, 0x96, 0xe5, 0x1f, 0xd7, 0xcb, 0x4a, 0xe4,
	0x07, 0x79, 0x22, 0xa7, 0x7c, 0xc6, 0x88, 0xa6, 0xa0, 0x8f, 0xa1, 0x9c, 0x76, 0x5a, 0xbd, 0xa2,
	0x12, 0xd7, 0xdc, 0x2c, 0x71, 0x1d, 0xc3, 0x22, 0x19, 0x1f, 0xfd, 0x01, 0x9e, 0x48, 0x51, 0x3a,
	0x8f, 0xc2, 0x09, 0x8b, 0x63, 0x1e, 0x4c, 0x29, 0x8b, 0xa2, 0x30, 0x8a, 0xeb, 0x55, 0x15, 0xd8,
	0x47, 0x9b, 0x04, 0x36, 0xcc, 0xc8, 0x58, 0x71, 0xc9, 0xe1, 0xd5, 0x1d, 0xd6, 0x67, 0x7f, 0x2f,
	0x40, 0xd1, 0xf6, 0xd0, 0xf7, 0xa1, 0xca, 0x83, 0x9b, 0x70, 0xa2, 0xda, 0x95, 0x72, 0xcf, 0x34,
	0xe6, 0xa3, 0xa5, 0xd1, 0xf6, 0xd0, 0xb7, 0x60, 0x57, 0xb8, 0xd1, 0x94, 0x09, 0x6a, 0xfa, 0x74,
	0x97, 0x94, 0xb5, 0xc1, 0xf6, 0xd0, 0x4b, 0xb0, 0x26, 0x61, 0x70, 0xc5, 0xa7, 0xa6, 0xe7, 0x25,
	0xa6, 0xa4, 0x30, 0x7b, 0xb7, 0xec, 0x5a, 0xc7, 0x94, 0x03, 0xf7, 0x54, 0x47, 0xed, 0x92, 0xb2,
	0x36, 0xd8, 0xde, 0x49, 0x15, 0x2a, 0xc6, 0x29, 0x16, 0x73, 0xd6, 0xf8, 0x13, 0x54, 0x56, 0xda,
	0x40, 0xde, 0x1b, 0xd2, 0x9c, 0xde, 0x1b, 0xf2, 0x37, 0xfa, 0x31, 0xa0, 0x79, 0xc4, 0x7d, 0x37,
	0x5a, 0x50, 0x1e, 0xcc, 0x13, 0x41, 0xe7, 0xae, 0xb8, 0x36, 0xf1, 0x59, 0xc6, 0x63, 0x4b, 0xc7,
	0xd0, 0x15, 0xd7, 0xa8, 0x09, 0x07, 0x29, 0x3a, 0x4c, 0x44, 0x06, 0xd7, 0xa1, 0xee, 0x1b, 0xd7,
	0x40, 0x79, 0x24, 0xbe, 0xf1, 0xd7, 0x12, 0xc0, 0xb2, 0x6f, 0xd0, 0x6b, 0xd3, 0x78, 0xe6, 0x3e,
	0x28, 0x6c, 0xde, 0x78, 0xe6, 0x4e, 0x50, 0x6d, 0xa7, 0x7f, 0xa3, 0xef, 0xc1, 0xa3, 0xf8, 0xda,
	0x8d, 0x3c, 0x1a, 0x24, 0xfe, 0x25, 0x8b, 0x54, 0xcc, 0xdb, 0xa4, 0xa2, 0x6c, 0x7d, 0x65, 0x42,
	0xdf, 0x01, 0x88, 0x92, 0x20, 0x05, 0x94, 0x14, 0x60, 0x37, 0x4a, 0x02, 0xe3, 0xfe, 0x21, 0xd4,
	0x5c, 0x21, 0x98, 0x3f, 0x17, 0x29, 0x64, 0x4b, 0x41, 0xaa, 0xc6, 0x6a, 0x60, 0xe7, 0x00, 0xcb,
	0xdb, 0xda, 0x34, 0xf6, 0xcb, 0x4d, 0x82, 0x1e, 0x49, 0x02, 0xd9, 0x15, 0xe9, 0x4f, 0x74, 0x06,
	0xe5, 0xaf, 0xdc, 0x28, 0xe0, 0xc1, 0x34, 0x6d, 0x93, 0x57, 0x9b, 0xe8, 0xfc, 0x46, 0x73, 0x48,
	0x46, 0x46, 0x1f, 0xc1, 0x13, 0x16, 0x0b, 0xee, 0xbb, 0x82, 0x79, 0xd4, 0x67, 0x7e, 0x18, 0x2d,
	0xe8, 0xe5, 0x42, 0xde, 0x3b, 0xf2, 0x32, 0x2b, 0x91, 0xc3, 0xcc, 0x7b, 0xa1, 0x9c, 0x27, 0xd2,
	0xd7, 0xf8, 0x73, 0x11, 0xac, 0xf5, 0x0b, 0x07, 0x7d, 0x01, 0x88, 0x7d, 0xcd, 0x26, 0x89, 0xaa,
	0x9a, 0x58, 0x44, 0xae, 0x60, 0xd3, 0x85, 0x3a, 0x9a, 0xda, 0xf1, 0x4f, 0xf2, 0xa2, 0xc3, 0x29,
	0x73, 0x64, 0x88, 0x64, 0x9f, 0xad, 0x9b, 0x64, 0xc5, 0xb2, 0xaf, 0xb9, 0xa0, 0x93, 0xd0, 0x63,
	0xe6, 0x94, 0xca, 0xd2, 0xd0, 0x09, 0x3d, 0x86, 0x9e, 0x41, 0xf9, 0x3a, 0x8c, 0x85, 0x7a, 0xcf,
	0x74, 0x19, 0x65, 0x6b, 0x34, 0x86, 0x3d, 0x5d, 0x93, 0xaa, 0xa1, 0x79, 0x70, 0x15, 0x9a, 0x27,
	0xe4, 0xfd, 0xbc, 0xb8, 0x54, 0xc5, 0xca, 0x46, 0xb6, 0x83, 0xab, 0x90, 0x54, 0xf9, 0xea, 0xb2,
	0xf1, 0x9f, 0x02, 0x54, 0x6f, 0x01, 0xd0, 0x21, 0x6c, 0x4f, 0xc2, 0x24, 0x10, 0xea, 0xb3, 0x4b,
	0x44, 0x2f, 0x64, 0x79, 0x78, 0x3c, 0x16, 0x3c, 0x98, 0xc8, 0xd8, 0xa5, 0xbb, 0xa8, 0xdc, 0xd5,
	0xd4, 0xda, 0x51, 0xb0, 0xef, 0x42, 0x45, 0x79, 0xe9, 0x8c, 0xfb, 0x5c, 0xa8, 0x8f, 0x28, 0x11,
	0x50, 0xa6, 0x9e, 0xb4, 0xdc, 0xd2, 0xd1, 0x87, 0xb4, 0x75, 0x5b, 0x47, 0x9d, 0x8e, 0xec, 0xad,
	0x5b, 0x30, 0xa3, 0xb7, 0xad, 0xb0, 0xfb, 0xab, 0x58, 0x25, 0xdb, 0xf8, 0x02, 0xf6, 0x7a, 0xe1,
	0xc4, 0x9d, 0x2d, 0xdb, 0x03, 0x5d, 0xc0, 0x63, 0x55, 0xa9, 0xe6, 0xee, 0xa3, 0xe9, 0x08, 0x61,
	0x3a, 0xed, 0x9d, 0x34, 0x6d, 0xe9, 0x8c, 0xd1, 0xec, 0x1a, 0x00, 0x39, 0x90, 0x3c, 0x73, 0xbf,
	0xa5, 0xc6, 0xc6, 0x5f, 0x4a, 0xf0, 0x94, 0x30, 0x3f, 0x14, 0x4c, 0xf5, 0xb0, 0x6e, 0x0a, 0xb3,
	0xd5, 0xaf, 0xa1, 0xf6, 0x65, 0xc2, 0x12, 0xf6, 0x06, 0x7b, 0x54, 0x15, 0x21, 0x5d, 0xa2, 0x13,
	0xd8, 0x4b, 0xe6, 0xb3, 0xd0, 0xf5, 0x96, 0x12, 0xc5, 0x3c, 0x89, 0x9a, 0x66, 0x64, 0x1a, 0x03,
	0x78, 0xe2, 0xbb, 0x93, 0x6b, 0x1e, 0x30, 0x1a, 0x33, 0x91, 0xcc, 0x97, 0x52, 0xa5, 0x3c, 0xa9,
	0x43, 0x43, 0x1c, 0x49, 0x5e, 0x26, 0x78, 0x6f, 0x06, 0xb7, 0xde, 0x26, 0x83, 0xe8, 0x14, 0xf6,
	0xbd, 0xf0, 0xab, 0xe0, 0xf6, 0x57, 0x6e, 0xe7, 0x49, 0x59, 0x29, 0x27, 0x3b, 0x89, 0x7f, 0x17,
	0xc0, 0x5a, 0x9e, 0x84, 0x39, 0x82, 0x4f, 0xe0, 0xe9, 0x4c, 0x16, 0x00, 0x75, 0x03, 0x77, 0xb6,
	0x88, 0xf9, 0x9b, 0x9c, 0xf7, 0x63, 0xc5, 0x6c, 0x1b, 0x62, 0x16, 0xef, 0x08, 0xca, 0xe6, 0xee,
	0x8b, 0xeb, 0x45, 0x75, 0x41, 0xfd, 0x2c, 0xaf, 0xd5, 0xee, 0x29, 0x10, 0x92, 0x09, 0x35, 0xfe,
	0x61, 0x1e, 0x01, 0x13, 0xf6, 0x19, 0x6c, 0xab, 0xcd, 0x4d, 0x90, 0xad, 0xbc, 0x0d, 0xd6, 0x8a,
	0xfc, 0xfc, 0x01, 0xd1, 0x7c, 0xf4, 0x31, 0xec, 0x44, 0x6a, 0x73, 0x53, 0x37, 0x1f, 0x6c, 0x1e,
	0x6a, 0x26, 0x65, 0x14, 0xd0, 0x6b, 0x38, 0x8c, 0x17, 0xb1, 0x60, 0xbe, 0x7c, 0x9b, 0xd8, 0x1b,
	0x94, 0x11, 0xd2, 0x34, 0x87, 0xfb, 0xcb, 0xca, 0x3e, 0x03, 0x94, 0xc4, 0x2c, 0x5a, 0x93, 0xca,
	0xad, 0x20, 0x4b, 0x92, 0x6e, 0x09, 0xf5, 0xe1, 0x91, 0xaa, 0xc6, 0x89, 0x2a, 0xd5, 0xa9, 0xaa,
	0x9c, 0xda, 0x66, 0x6f, 0x46, 0x47, 0x53, 0x88, 0x7a, 0x70, 0xcd, 0xe2, 0x04, 0xa0, 0x3c, 0x33,
	0x13, 0x49, 0xe3, 0xa7, 0x50, 0x59, 0x79, 0x5b, 0xd0, 0x8f, 0x60, 0xcf, 0xbc, 0x2e, 0xd4, 0x67,
	0x71, 0x2c, 0x27, 0x31, 0x3d, 0x26, 0xd4, 0x8c, 0xf9, 0x42, 0x5b, 0x1b, 0xff, 0x2c, 0xc0, 0xe1,
	0x5d, 0x23, 0x12, 0x7a, 0x07, 0xca, 0xea, 0x9e, 0x4e, 0xb2, 0x01, 0xe8, 0xa1, 0x5c, 0x8f, 0xb9,
	0x87, 0xf8, 0xbd, 0x33, 0x59, 0x49, 0x15, 0xd9, 0x87, 0x6f, 0x31, 0x93, 0xdd, 0x3d, 0x92, 0x35,
	0xfe, 0x08, 0x07, 0x77, 0x80, 0xd1, 0xeb, 0x95, 0xd1, 0xa7, 0x96, 0x5f, 0xd4, 0x77, 0x48, 0x38,
	0x8b, 0x39, 0x33, 0x33, 0x53, 0x1d, 0x1e, 0xa6, 0x39, 0xd2, 0x83, 0x52, 0xba, 0x3c, 0xfa, 0x5b,
	0x01, 0xf6, 0xff, 0xef, 0x4d, 0x44, 0x0d, 0x78, 0x17, 0x7f, 0x86, 0x3b, 0x63, 0xc7, 0x1e, 0xf4,
	0xe9, 0xc8, 0x21, 0x6d, 0x07, 0x9f, 0x7d, 0x4e, 0xc7, 0xfd, 0xd1, 0x10, 0x77, 0xec, 0x53, 0x1b,
	0x77, 0xad, 0x07, 0xe8, 0x31, 0xec, 0x0f, 0x9c, 0x73, 0x4c, 0x28, 0xee, 0x7f, 0x6a, 0x93, 0x41,
	0xff, 0x02, 0xf7, 0x1d, 0xab, 0x80, 0x10, 0xd4, 0x08, 0xbe, 0x18, 0x38, 0x98, 0x8e, 0x30, 0xf9,
	0xd4, 0xee, 0x60, 0xab, 0x28, 0x6d, 0xbd, 0x41, 0xa7, 0xdd, 0xa3, 0xc3, 0x36, 0x69, 0xf7, 0x7a,
	0xb8, 0x67, 0x95, 0xd0, 0x21, 0x58, 0xda, 0x36, 0xc2, 0x9f, 0x8c, 0x71, 0xdf, 0xb1, 0xdb, 0x3d,
	0x6b, 0xeb, 0xe8, 0x4a, 0x9f, 0xb1, 0x39, 0x7e, 0xf4, 0x6d, 0xa8, 0x3b, 0x78, 0xe4, 0xd0, 0x4e,
	0xbb, 0x73, 0x6e, 0xf7, 0xcf, 0xd6, 0x22, 0x38, 0x80, 0x3d, 0x2d, 0x21, 0xdd, 0x98, 0x9e, 0xdb,
	0x72, 0xff, 0x43, 0xb0, 0xcc, 0xfe, 0x4b, 0x6b, 0x11, 0xd5, 0x00, 0xf4, 0xf2, 0xc2, 0x1e, 0x8d,
	0xac, 0xd2, 0xd1, 0x7f, 0x0b, 0xf0, 0xf4, 0x9e, 0x94, 0xa1, 0x23, 0x78, 0xef, 0xd4, 0xee, 0x61,
	0x3a, 0x24, 0x83, 0x0e, 0x1e, 0x8d, 0xe4, 0xbe, 0x98, 0x90, 0x01, 0xa1, 0xce, 0xe7, 0x43, 0xbc,
	0x16, 0xc2, 0x13, 0x40, 0x67, 0xb8, 0x8f, 0x89, 0xdd, 0xa1, 0x04, 0xb7, 0xbb, 0x1a, 0x68, 0x15,
	0xd0, 0x53, 0x38, 0x48, 0xed, 0xc3, 0x36, 0x19, 0x61, 0xe3, 0x50, 0xa9, 0x50, 0xe2, 0xce, 0x60,
	0x40, 0x7b, 0x6d, 0x72, 0x86, 0x75, 0x2a, 0x06, 0x63, 0x67, 0x38, 0x76, 0x56, 0xac, 0x5b, 0x68,
	0x1f, 0xaa, 0xed, 0x8e, 0x0c, 0x80, 0x76, 0x71, 0x5f, 0xee, 0xb6, 0x2d, 0x53, 0xde, 0xc5, 0xed,
	0x6e, 0xcf, 0xee, 0x63, 0x8a, 0x3f, 0xeb, 0x60, 0xdc, 0xc5, 0x5d, 0x6b, 0x07, 0x55, 0x61, 0xb7,
	0x3f, 0x70, 0xe8, 0xe9, 0x60, 0xdc, 0xef, 0x5a, 0x0f, 0x4f, 0xbe, 0x84, 0xc6, 0x24, 0xf4, 0x73,
	0x0a, 0x66, 0x58, 0xf8, 0xad, 0x6d, 0x10, 0xd3, 0x70, 0xe6, 0x06, 0xd3, 0x66, 0x18, 0x4d, 0x5b,
	0x53, 0x16, 0xa8, 0x2e, 0x37, 0xff, 0x05, 0xb8, 0x73, 0x1e, 0xdf, 0xf7, 0x7f, 0xc0, 0x2f, 0x57,
	0x96, 0x97, 0x3b, 0x8a, 0xf5, 0xe1, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0x09, 0xc6, 0x5f, 0x39,
	0x18, 0x11, 0x00, 0x00,
}
