# Managing Kubernetes Infrastructure with the Cluster API

* [Introduction](README.md)

## Getting Started

* [Existing Providers](getting_started/existing_providers.md)

## Common Code

* [Architecture](common_code/architecture.md)
* [Repository Layout](common_code/repository_layout.md)
* [Cluster Controller](common_code/cluster_controller.md)
* [Machine Controller](common_code/machine_controller.md)
* [MachineSet Controller](common_code/machineset_controller.md)
* [MachineDeployment Controller](common_code/machinedeployment_controller.md)
* [Node Controller](common_code/node_controller.md)

## Creating a New Provider

* [Overview](provider_implementations/overview.md)
* [Naming](provider_implementations/naming.md)
* [Generate CRDs](provider_implementations/generate_crds.md)
* [Register Schemes](provider_implementations/register_schemes.md)
* [Create Actuators](provider_implementations/create_actuators.md)
* [Register Controllers](provider_implementations/register_controllers.md)
* [Building, Running, and Testing](provider_implementations/building_running_and_testing.md)

## Appendices

* [Cluster API KEP](appendices/keps/0003-cluster-api.md)

