/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v2alpha1

import (
	time "time"

	brokerv2alpha1 "github.com/artemiscloud/activemq-artemis-operator/pkg/apis/broker/v2alpha1"
	versioned "github.com/artemiscloud/activemq-artemis-operator/pkg/client/clientset/versioned"
	internalinterfaces "github.com/artemiscloud/activemq-artemis-operator/pkg/client/informers/externalversions/internalinterfaces"
	v2alpha1 "github.com/artemiscloud/activemq-artemis-operator/pkg/client/listers/broker/v2alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	watch "k8s.io/apimachinery/pkg/watch"
	cache "k8s.io/client-go/tools/cache"
)

// ActiveMQArtemisAddressInformer provides access to a shared informer and lister for
// ActiveMQArtemisAddresses.
type ActiveMQArtemisAddressInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() v2alpha1.ActiveMQArtemisAddressLister
}

type activeMQArtemisAddressInformer struct {
	factory          internalinterfaces.SharedInformerFactory
	tweakListOptions internalinterfaces.TweakListOptionsFunc
	namespace        string
}

// NewActiveMQArtemisAddressInformer constructs a new informer for ActiveMQArtemisAddress type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewActiveMQArtemisAddressInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers) cache.SharedIndexInformer {
	return NewFilteredActiveMQArtemisAddressInformer(client, namespace, resyncPeriod, indexers, nil)
}

// NewFilteredActiveMQArtemisAddressInformer constructs a new informer for ActiveMQArtemisAddress type.
// Always prefer using an informer factory to get a shared informer instead of getting an independent
// one. This reduces memory footprint and number of connections to the server.
func NewFilteredActiveMQArtemisAddressInformer(client versioned.Interface, namespace string, resyncPeriod time.Duration, indexers cache.Indexers, tweakListOptions internalinterfaces.TweakListOptionsFunc) cache.SharedIndexInformer {
	return cache.NewSharedIndexInformer(
		&cache.ListWatch{
			ListFunc: func(options v1.ListOptions) (runtime.Object, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.BrokerV2alpha1().ActiveMQArtemisAddresses(namespace).List(options)
			},
			WatchFunc: func(options v1.ListOptions) (watch.Interface, error) {
				if tweakListOptions != nil {
					tweakListOptions(&options)
				}
				return client.BrokerV2alpha1().ActiveMQArtemisAddresses(namespace).Watch(options)
			},
		},
		&brokerv2alpha1.ActiveMQArtemisAddress{},
		resyncPeriod,
		indexers,
	)
}

func (f *activeMQArtemisAddressInformer) defaultInformer(client versioned.Interface, resyncPeriod time.Duration) cache.SharedIndexInformer {
	return NewFilteredActiveMQArtemisAddressInformer(client, f.namespace, resyncPeriod, cache.Indexers{cache.NamespaceIndex: cache.MetaNamespaceIndexFunc}, f.tweakListOptions)
}

func (f *activeMQArtemisAddressInformer) Informer() cache.SharedIndexInformer {
	return f.factory.InformerFor(&brokerv2alpha1.ActiveMQArtemisAddress{}, f.defaultInformer)
}

func (f *activeMQArtemisAddressInformer) Lister() v2alpha1.ActiveMQArtemisAddressLister {
	return v2alpha1.NewActiveMQArtemisAddressLister(f.Informer().GetIndexer())
}
