// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package outposts

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListOutpostsInput struct {
	_ struct{} `type:"structure"`

	// The maximum page size.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListOutpostsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOutpostsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListOutpostsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListOutpostsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListOutpostsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `min:"1" type:"string"`

	// Information about the Outposts.
	Outposts []Outpost `type:"list"`
}

// String returns the string representation
func (s ListOutpostsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListOutpostsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Outposts != nil {
		v := s.Outposts

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Outposts", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListOutposts = "ListOutposts"

// ListOutpostsRequest returns a request value for making API operation for
// AWS Outposts.
//
// List the Outposts for your AWS account.
//
//    // Example sending a request using ListOutpostsRequest.
//    req := client.ListOutpostsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListOutposts
func (c *Client) ListOutpostsRequest(input *ListOutpostsInput) ListOutpostsRequest {
	op := &aws.Operation{
		Name:       opListOutposts,
		HTTPMethod: "GET",
		HTTPPath:   "/outposts",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOutpostsInput{}
	}

	req := c.newRequest(op, input, &ListOutpostsOutput{})
	return ListOutpostsRequest{Request: req, Input: input, Copy: c.ListOutpostsRequest}
}

// ListOutpostsRequest is the request type for the
// ListOutposts API operation.
type ListOutpostsRequest struct {
	*aws.Request
	Input *ListOutpostsInput
	Copy  func(*ListOutpostsInput) ListOutpostsRequest
}

// Send marshals and sends the ListOutposts API request.
func (r ListOutpostsRequest) Send(ctx context.Context) (*ListOutpostsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListOutpostsResponse{
		ListOutpostsOutput: r.Request.Data.(*ListOutpostsOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListOutpostsRequestPaginator returns a paginator for ListOutposts.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListOutpostsRequest(input)
//   p := outposts.NewListOutpostsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListOutpostsPaginator(req ListOutpostsRequest) ListOutpostsPaginator {
	return ListOutpostsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListOutpostsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListOutpostsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListOutpostsPaginator struct {
	aws.Pager
}

func (p *ListOutpostsPaginator) CurrentPage() *ListOutpostsOutput {
	return p.Pager.CurrentPage().(*ListOutpostsOutput)
}

// ListOutpostsResponse is the response type for the
// ListOutposts API operation.
type ListOutpostsResponse struct {
	*ListOutpostsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListOutposts request.
func (r *ListOutpostsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
