// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListAuditMitigationActionsTasksInput struct {
	_ struct{} `type:"structure"`

	// Specify this filter to limit results to tasks that were applied to results
	// for a specific audit.
	AuditTaskId *string `location:"querystring" locationName:"auditTaskId" min:"1" type:"string"`

	// Specify this filter to limit results to tasks that were completed or canceled
	// on or before a specific date and time.
	//
	// EndTime is a required field
	EndTime *time.Time `location:"querystring" locationName:"endTime" type:"timestamp" required:"true"`

	// Specify this filter to limit results to tasks that were applied to a specific
	// audit finding.
	FindingId *string `location:"querystring" locationName:"findingId" min:"1" type:"string"`

	// The maximum number of results to return at one time. The default is 25.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// Specify this filter to limit results to tasks that began on or after a specific
	// date and time.
	//
	// StartTime is a required field
	StartTime *time.Time `location:"querystring" locationName:"startTime" type:"timestamp" required:"true"`

	// Specify this filter to limit results to tasks that are in a specific state.
	TaskStatus AuditMitigationActionsTaskStatus `location:"querystring" locationName:"taskStatus" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListAuditMitigationActionsTasksInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAuditMitigationActionsTasksInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAuditMitigationActionsTasksInput"}
	if s.AuditTaskId != nil && len(*s.AuditTaskId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AuditTaskId", 1))
	}

	if s.EndTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndTime"))
	}
	if s.FindingId != nil && len(*s.FindingId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FindingId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.StartTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListAuditMitigationActionsTasksInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AuditTaskId != nil {
		v := *s.AuditTaskId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "auditTaskId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "endTime",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	if s.FindingId != nil {
		v := *s.FindingId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "findingId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "startTime",
			protocol.TimeValue{V: v, Format: protocol.ISO8601TimeFormatName, QuotedFormatTime: false}, metadata)
	}
	if len(s.TaskStatus) > 0 {
		v := s.TaskStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "taskStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

type ListAuditMitigationActionsTasksOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The collection of audit mitigation tasks that matched the filter criteria.
	Tasks []AuditMitigationActionsTaskMetadata `locationName:"tasks" type:"list"`
}

// String returns the string representation
func (s ListAuditMitigationActionsTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListAuditMitigationActionsTasksOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tasks != nil {
		v := s.Tasks

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "tasks", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListAuditMitigationActionsTasks = "ListAuditMitigationActionsTasks"

// ListAuditMitigationActionsTasksRequest returns a request value for making API operation for
// AWS IoT.
//
// Gets a list of audit mitigation action tasks that match the specified filters.
//
//    // Example sending a request using ListAuditMitigationActionsTasksRequest.
//    req := client.ListAuditMitigationActionsTasksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListAuditMitigationActionsTasksRequest(input *ListAuditMitigationActionsTasksInput) ListAuditMitigationActionsTasksRequest {
	op := &aws.Operation{
		Name:       opListAuditMitigationActionsTasks,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/mitigationactions/tasks",
	}

	if input == nil {
		input = &ListAuditMitigationActionsTasksInput{}
	}

	req := c.newRequest(op, input, &ListAuditMitigationActionsTasksOutput{})
	return ListAuditMitigationActionsTasksRequest{Request: req, Input: input, Copy: c.ListAuditMitigationActionsTasksRequest}
}

// ListAuditMitigationActionsTasksRequest is the request type for the
// ListAuditMitigationActionsTasks API operation.
type ListAuditMitigationActionsTasksRequest struct {
	*aws.Request
	Input *ListAuditMitigationActionsTasksInput
	Copy  func(*ListAuditMitigationActionsTasksInput) ListAuditMitigationActionsTasksRequest
}

// Send marshals and sends the ListAuditMitigationActionsTasks API request.
func (r ListAuditMitigationActionsTasksRequest) Send(ctx context.Context) (*ListAuditMitigationActionsTasksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAuditMitigationActionsTasksResponse{
		ListAuditMitigationActionsTasksOutput: r.Request.Data.(*ListAuditMitigationActionsTasksOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListAuditMitigationActionsTasksResponse is the response type for the
// ListAuditMitigationActionsTasks API operation.
type ListAuditMitigationActionsTasksResponse struct {
	*ListAuditMitigationActionsTasksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAuditMitigationActionsTasks request.
func (r *ListAuditMitigationActionsTasksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
