// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteSecurityProfileInput struct {
	_ struct{} `type:"structure"`

	// The expected version of the security profile. A new version is generated
	// whenever the security profile is updated. If you specify a value that is
	// different from the actual version, a VersionConflictException is thrown.
	ExpectedVersion *int64 `location:"querystring" locationName:"expectedVersion" type:"long"`

	// The name of the security profile to be deleted.
	//
	// SecurityProfileName is a required field
	SecurityProfileName *string `location:"uri" locationName:"securityProfileName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSecurityProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSecurityProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteSecurityProfileInput"}

	if s.SecurityProfileName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecurityProfileName"))
	}
	if s.SecurityProfileName != nil && len(*s.SecurityProfileName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecurityProfileName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteSecurityProfileInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.SecurityProfileName != nil {
		v := *s.SecurityProfileName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "securityProfileName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ExpectedVersion != nil {
		v := *s.ExpectedVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "expectedVersion", protocol.Int64Value(v), metadata)
	}
	return nil
}

type DeleteSecurityProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSecurityProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteSecurityProfileOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteSecurityProfile = "DeleteSecurityProfile"

// DeleteSecurityProfileRequest returns a request value for making API operation for
// AWS IoT.
//
// Deletes a Device Defender security profile.
//
//    // Example sending a request using DeleteSecurityProfileRequest.
//    req := client.DeleteSecurityProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteSecurityProfileRequest(input *DeleteSecurityProfileInput) DeleteSecurityProfileRequest {
	op := &aws.Operation{
		Name:       opDeleteSecurityProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/security-profiles/{securityProfileName}",
	}

	if input == nil {
		input = &DeleteSecurityProfileInput{}
	}

	req := c.newRequest(op, input, &DeleteSecurityProfileOutput{})
	return DeleteSecurityProfileRequest{Request: req, Input: input, Copy: c.DeleteSecurityProfileRequest}
}

// DeleteSecurityProfileRequest is the request type for the
// DeleteSecurityProfile API operation.
type DeleteSecurityProfileRequest struct {
	*aws.Request
	Input *DeleteSecurityProfileInput
	Copy  func(*DeleteSecurityProfileInput) DeleteSecurityProfileRequest
}

// Send marshals and sends the DeleteSecurityProfile API request.
func (r DeleteSecurityProfileRequest) Send(ctx context.Context) (*DeleteSecurityProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteSecurityProfileResponse{
		DeleteSecurityProfileOutput: r.Request.Data.(*DeleteSecurityProfileOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteSecurityProfileResponse is the response type for the
// DeleteSecurityProfile API operation.
type DeleteSecurityProfileResponse struct {
	*DeleteSecurityProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteSecurityProfile request.
func (r *DeleteSecurityProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
