// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package applicationdiscoveryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeContinuousExportsInput struct {
	_ struct{} `type:"structure"`

	// The unique IDs assigned to the exports.
	ExportIds []string `locationName:"exportIds" type:"list"`

	// A number between 1 and 100 specifying the maximum number of continuous export
	// descriptions returned.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token from the previous call to DescribeExportTasks.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeContinuousExportsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeContinuousExportsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeContinuousExportsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeContinuousExportsOutput struct {
	_ struct{} `type:"structure"`

	// A list of continuous export descriptions.
	Descriptions []ContinuousExportDescription `locationName:"descriptions" type:"list"`

	// The token from the previous call to DescribeExportTasks.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeContinuousExportsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeContinuousExports = "DescribeContinuousExports"

// DescribeContinuousExportsRequest returns a request value for making API operation for
// AWS Application Discovery Service.
//
// Lists exports as specified by ID. All continuous exports associated with
// your user account can be listed if you call DescribeContinuousExports as
// is without passing any parameters.
//
//    // Example sending a request using DescribeContinuousExportsRequest.
//    req := client.DescribeContinuousExportsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/discovery-2015-11-01/DescribeContinuousExports
func (c *Client) DescribeContinuousExportsRequest(input *DescribeContinuousExportsInput) DescribeContinuousExportsRequest {
	op := &aws.Operation{
		Name:       opDescribeContinuousExports,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeContinuousExportsInput{}
	}

	req := c.newRequest(op, input, &DescribeContinuousExportsOutput{})
	return DescribeContinuousExportsRequest{Request: req, Input: input, Copy: c.DescribeContinuousExportsRequest}
}

// DescribeContinuousExportsRequest is the request type for the
// DescribeContinuousExports API operation.
type DescribeContinuousExportsRequest struct {
	*aws.Request
	Input *DescribeContinuousExportsInput
	Copy  func(*DescribeContinuousExportsInput) DescribeContinuousExportsRequest
}

// Send marshals and sends the DescribeContinuousExports API request.
func (r DescribeContinuousExportsRequest) Send(ctx context.Context) (*DescribeContinuousExportsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeContinuousExportsResponse{
		DescribeContinuousExportsOutput: r.Request.Data.(*DescribeContinuousExportsOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeContinuousExportsRequestPaginator returns a paginator for DescribeContinuousExports.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeContinuousExportsRequest(input)
//   p := applicationdiscoveryservice.NewDescribeContinuousExportsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeContinuousExportsPaginator(req DescribeContinuousExportsRequest) DescribeContinuousExportsPaginator {
	return DescribeContinuousExportsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeContinuousExportsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeContinuousExportsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeContinuousExportsPaginator struct {
	aws.Pager
}

func (p *DescribeContinuousExportsPaginator) CurrentPage() *DescribeContinuousExportsOutput {
	return p.Pager.CurrentPage().(*DescribeContinuousExportsOutput)
}

// DescribeContinuousExportsResponse is the response type for the
// DescribeContinuousExports API operation.
type DescribeContinuousExportsResponse struct {
	*DescribeContinuousExportsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeContinuousExports request.
func (r *DescribeContinuousExportsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
