package logic

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// IntegrationAccountAgreementsClient is the REST API for Azure Logic Apps.
type IntegrationAccountAgreementsClient struct {
	BaseClient
}

// NewIntegrationAccountAgreementsClient creates an instance of the IntegrationAccountAgreementsClient client.
func NewIntegrationAccountAgreementsClient(subscriptionID string) IntegrationAccountAgreementsClient {
	return NewIntegrationAccountAgreementsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewIntegrationAccountAgreementsClientWithBaseURI creates an instance of the IntegrationAccountAgreementsClient
// client using a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI
// (sovereign clouds, Azure stack).
func NewIntegrationAccountAgreementsClientWithBaseURI(baseURI string, subscriptionID string) IntegrationAccountAgreementsClient {
	return IntegrationAccountAgreementsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate creates or updates an integration account agreement.
// Parameters:
// resourceGroupName - the resource group name.
// integrationAccountName - the integration account name.
// agreementName - the integration account agreement name.
// agreement - the integration account agreement.
func (client IntegrationAccountAgreementsClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, integrationAccountName string, agreementName string, agreement IntegrationAccountAgreement) (result IntegrationAccountAgreement, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountAgreementsClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: agreement,
			Constraints: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.HostPartner", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "agreement.IntegrationAccountAgreementProperties.GuestPartner", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "agreement.IntegrationAccountAgreementProperties.HostIdentity", Name: validation.Null, Rule: true,
						Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.HostIdentity.Qualifier", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "agreement.IntegrationAccountAgreementProperties.HostIdentity.Value", Name: validation.Null, Rule: true, Chain: nil},
						}},
					{Target: "agreement.IntegrationAccountAgreementProperties.GuestIdentity", Name: validation.Null, Rule: true,
						Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.GuestIdentity.Qualifier", Name: validation.Null, Rule: true, Chain: nil},
							{Target: "agreement.IntegrationAccountAgreementProperties.GuestIdentity.Value", Name: validation.Null, Rule: true, Chain: nil},
						}},
					{Target: "agreement.IntegrationAccountAgreementProperties.Content", Name: validation.Null, Rule: true,
						Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2", Name: validation.Null, Rule: false,
							Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement", Name: validation.Null, Rule: true,
								Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.SenderBusinessIdentity", Name: validation.Null, Rule: true,
									Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.SenderBusinessIdentity.Qualifier", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.SenderBusinessIdentity.Value", Name: validation.Null, Rule: true, Chain: nil},
									}},
									{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ReceiverBusinessIdentity", Name: validation.Null, Rule: true,
										Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ReceiverBusinessIdentity.Qualifier", Name: validation.Null, Rule: true, Chain: nil},
											{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ReceiverBusinessIdentity.Value", Name: validation.Null, Rule: true, Chain: nil},
										}},
									{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings", Name: validation.Null, Rule: true,
										Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.MessageConnectionSettings", Name: validation.Null, Rule: true,
											Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.MessageConnectionSettings.IgnoreCertificateNameMismatch", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.MessageConnectionSettings.SupportHTTPStatusCodeContinue", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.MessageConnectionSettings.KeepHTTPConnectionAlive", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.MessageConnectionSettings.UnfoldHTTPHeaders", Name: validation.Null, Rule: true, Chain: nil},
											}},
											{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.AcknowledgementConnectionSettings", Name: validation.Null, Rule: true,
												Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.AcknowledgementConnectionSettings.IgnoreCertificateNameMismatch", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.AcknowledgementConnectionSettings.SupportHTTPStatusCodeContinue", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.AcknowledgementConnectionSettings.KeepHTTPConnectionAlive", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.AcknowledgementConnectionSettings.UnfoldHTTPHeaders", Name: validation.Null, Rule: true, Chain: nil},
												}},
											{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.MdnSettings", Name: validation.Null, Rule: true,
												Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.MdnSettings.NeedMDN", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.MdnSettings.SignMDN", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.MdnSettings.SendMDNAsynchronously", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.MdnSettings.SignOutboundMDNIfOptional", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.MdnSettings.SendInboundMDNToMessageBox", Name: validation.Null, Rule: true, Chain: nil},
												}},
											{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.SecuritySettings", Name: validation.Null, Rule: true,
												Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.SecuritySettings.OverrideGroupSigningCertificate", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.SecuritySettings.EnableNRRForInboundEncodedMessages", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.SecuritySettings.EnableNRRForInboundDecodedMessages", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.SecuritySettings.EnableNRRForOutboundMDN", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.SecuritySettings.EnableNRRForOutboundEncodedMessages", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.SecuritySettings.EnableNRRForOutboundDecodedMessages", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.SecuritySettings.EnableNRRForInboundMDN", Name: validation.Null, Rule: true, Chain: nil},
												}},
											{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.ValidationSettings", Name: validation.Null, Rule: true,
												Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.ValidationSettings.OverrideMessageProperties", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.ValidationSettings.EncryptMessage", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.ValidationSettings.SignMessage", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.ValidationSettings.CompressMessage", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.ValidationSettings.CheckDuplicateMessage", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.ValidationSettings.InterchangeDuplicatesValidityDays", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.ValidationSettings.CheckCertificateRevocationListOnSend", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.ValidationSettings.CheckCertificateRevocationListOnReceive", Name: validation.Null, Rule: true, Chain: nil},
												}},
											{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.EnvelopeSettings", Name: validation.Null, Rule: true,
												Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.MessageContentType", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.TransmitFileNameInMimeHeader", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.FileNameTemplate", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.SuspendMessageOnFileNameGenerationError", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.AutogenerateFileName", Name: validation.Null, Rule: true, Chain: nil},
												}},
											{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.ErrorSettings", Name: validation.Null, Rule: true,
												Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.ErrorSettings.SuspendDuplicateMessage", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.ReceiveAgreement.ProtocolSettings.ErrorSettings.ResendIfMDNNotReceived", Name: validation.Null, Rule: true, Chain: nil},
												}},
										}},
								}},
								{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement", Name: validation.Null, Rule: true,
									Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.SenderBusinessIdentity", Name: validation.Null, Rule: true,
										Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.SenderBusinessIdentity.Qualifier", Name: validation.Null, Rule: true, Chain: nil},
											{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.SenderBusinessIdentity.Value", Name: validation.Null, Rule: true, Chain: nil},
										}},
										{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ReceiverBusinessIdentity", Name: validation.Null, Rule: true,
											Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ReceiverBusinessIdentity.Qualifier", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ReceiverBusinessIdentity.Value", Name: validation.Null, Rule: true, Chain: nil},
											}},
										{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings", Name: validation.Null, Rule: true,
											Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.MessageConnectionSettings", Name: validation.Null, Rule: true,
												Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.MessageConnectionSettings.IgnoreCertificateNameMismatch", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.MessageConnectionSettings.SupportHTTPStatusCodeContinue", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.MessageConnectionSettings.KeepHTTPConnectionAlive", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.MessageConnectionSettings.UnfoldHTTPHeaders", Name: validation.Null, Rule: true, Chain: nil},
												}},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.AcknowledgementConnectionSettings", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.AcknowledgementConnectionSettings.IgnoreCertificateNameMismatch", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.AcknowledgementConnectionSettings.SupportHTTPStatusCodeContinue", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.AcknowledgementConnectionSettings.KeepHTTPConnectionAlive", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.AcknowledgementConnectionSettings.UnfoldHTTPHeaders", Name: validation.Null, Rule: true, Chain: nil},
													}},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.MdnSettings", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.MdnSettings.NeedMDN", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.MdnSettings.SignMDN", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.MdnSettings.SendMDNAsynchronously", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.MdnSettings.SignOutboundMDNIfOptional", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.MdnSettings.SendInboundMDNToMessageBox", Name: validation.Null, Rule: true, Chain: nil},
													}},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.SecuritySettings", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.SecuritySettings.OverrideGroupSigningCertificate", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.SecuritySettings.EnableNRRForInboundEncodedMessages", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.SecuritySettings.EnableNRRForInboundDecodedMessages", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.SecuritySettings.EnableNRRForOutboundMDN", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.SecuritySettings.EnableNRRForOutboundEncodedMessages", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.SecuritySettings.EnableNRRForOutboundDecodedMessages", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.SecuritySettings.EnableNRRForInboundMDN", Name: validation.Null, Rule: true, Chain: nil},
													}},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.ValidationSettings", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.ValidationSettings.OverrideMessageProperties", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.ValidationSettings.EncryptMessage", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.ValidationSettings.SignMessage", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.ValidationSettings.CompressMessage", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.ValidationSettings.CheckDuplicateMessage", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.ValidationSettings.InterchangeDuplicatesValidityDays", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.ValidationSettings.CheckCertificateRevocationListOnSend", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.ValidationSettings.CheckCertificateRevocationListOnReceive", Name: validation.Null, Rule: true, Chain: nil},
													}},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.EnvelopeSettings", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.EnvelopeSettings.MessageContentType", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.EnvelopeSettings.TransmitFileNameInMimeHeader", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.EnvelopeSettings.FileNameTemplate", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.EnvelopeSettings.SuspendMessageOnFileNameGenerationError", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.EnvelopeSettings.AutogenerateFileName", Name: validation.Null, Rule: true, Chain: nil},
													}},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.ErrorSettings", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.ErrorSettings.SuspendDuplicateMessage", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.AS2.SendAgreement.ProtocolSettings.ErrorSettings.ResendIfMDNNotReceived", Name: validation.Null, Rule: true, Chain: nil},
													}},
											}},
									}},
							}},
							{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement", Name: validation.Null, Rule: true,
									Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.SenderBusinessIdentity", Name: validation.Null, Rule: true,
										Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.SenderBusinessIdentity.Qualifier", Name: validation.Null, Rule: true, Chain: nil},
											{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.SenderBusinessIdentity.Value", Name: validation.Null, Rule: true, Chain: nil},
										}},
										{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ReceiverBusinessIdentity", Name: validation.Null, Rule: true,
											Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ReceiverBusinessIdentity.Qualifier", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ReceiverBusinessIdentity.Value", Name: validation.Null, Rule: true, Chain: nil},
											}},
										{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings", Name: validation.Null, Rule: true,
											Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.ValidationSettings", Name: validation.Null, Rule: true,
												Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.ValidationSettings.ValidateCharacterSet", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.ValidationSettings.CheckDuplicateInterchangeControlNumber", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.ValidationSettings.InterchangeControlNumberValidityDays", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.ValidationSettings.CheckDuplicateGroupControlNumber", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.ValidationSettings.CheckDuplicateTransactionSetControlNumber", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.ValidationSettings.ValidateEDITypes", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.ValidationSettings.ValidateXSDTypes", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.ValidationSettings.AllowLeadingAndTrailingSpacesAndZeroes", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.ValidationSettings.TrimLeadingAndTrailingSpacesAndZeroes", Name: validation.Null, Rule: true, Chain: nil},
												}},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.FramingSettings", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.FramingSettings.DataElementSeparator", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.FramingSettings.ComponentSeparator", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.FramingSettings.ReplaceSeparatorsInPayload", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.FramingSettings.ReplaceCharacter", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.FramingSettings.SegmentTerminator", Name: validation.Null, Rule: true, Chain: nil},
													}},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.EnvelopeSettings", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.ControlStandardsID", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.UseControlStandardsIDAsRepetitionCharacter", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.SenderApplicationID", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.ReceiverApplicationID", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.ControlVersionNumber", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.InterchangeControlNumberLowerBound", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.InterchangeControlNumberUpperBound", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.RolloverInterchangeControlNumber", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.EnableDefaultGroupHeaders", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.GroupControlNumberLowerBound", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.GroupControlNumberUpperBound", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.RolloverGroupControlNumber", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.GroupHeaderAgencyCode", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.GroupHeaderVersion", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.TransactionSetControlNumberLowerBound", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.TransactionSetControlNumberUpperBound", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.RolloverTransactionSetControlNumber", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.OverwriteExistingTransactionSetControlNumber", Name: validation.Null, Rule: true, Chain: nil},
													}},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings.NeedTechnicalAcknowledgement", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings.BatchTechnicalAcknowledgements", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings.NeedFunctionalAcknowledgement", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings.BatchFunctionalAcknowledgements", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings.NeedImplementationAcknowledgement", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings.BatchImplementationAcknowledgements", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings.NeedLoopForValidMessages", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings.SendSynchronousAcknowledgement", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings.AcknowledgementControlNumberLowerBound", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings.AcknowledgementControlNumberUpperBound", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings.RolloverAcknowledgementControlNumber", Name: validation.Null, Rule: true, Chain: nil},
													}},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.MessageFilter", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.SecuritySettings", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.SecuritySettings.AuthorizationQualifier", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.SecuritySettings.SecurityQualifier", Name: validation.Null, Rule: true, Chain: nil},
													}},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.ProcessingSettings", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.ProcessingSettings.MaskSecurityInfo", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.ProcessingSettings.ConvertImpliedDecimal", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.ProcessingSettings.PreserveInterchange", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.ProcessingSettings.SuspendInterchangeOnError", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.ProcessingSettings.CreateEmptyXMLTagsForTrailingSeparators", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.ProcessingSettings.UseDotAsDecimalSeparator", Name: validation.Null, Rule: true, Chain: nil},
													}},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.ReceiveAgreement.ProtocolSettings.SchemaReferences", Name: validation.Null, Rule: true, Chain: nil},
											}},
									}},
									{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement", Name: validation.Null, Rule: true,
										Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.SenderBusinessIdentity", Name: validation.Null, Rule: true,
											Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.SenderBusinessIdentity.Qualifier", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.SenderBusinessIdentity.Value", Name: validation.Null, Rule: true, Chain: nil},
											}},
											{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ReceiverBusinessIdentity", Name: validation.Null, Rule: true,
												Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ReceiverBusinessIdentity.Qualifier", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ReceiverBusinessIdentity.Value", Name: validation.Null, Rule: true, Chain: nil},
												}},
											{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings", Name: validation.Null, Rule: true,
												Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.ValidationSettings", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.ValidationSettings.ValidateCharacterSet", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.ValidationSettings.CheckDuplicateInterchangeControlNumber", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.ValidationSettings.InterchangeControlNumberValidityDays", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.ValidationSettings.CheckDuplicateGroupControlNumber", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.ValidationSettings.CheckDuplicateTransactionSetControlNumber", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.ValidationSettings.ValidateEDITypes", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.ValidationSettings.ValidateXSDTypes", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.ValidationSettings.AllowLeadingAndTrailingSpacesAndZeroes", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.ValidationSettings.TrimLeadingAndTrailingSpacesAndZeroes", Name: validation.Null, Rule: true, Chain: nil},
													}},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.FramingSettings", Name: validation.Null, Rule: true,
														Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.FramingSettings.DataElementSeparator", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.FramingSettings.ComponentSeparator", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.FramingSettings.ReplaceSeparatorsInPayload", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.FramingSettings.ReplaceCharacter", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.FramingSettings.SegmentTerminator", Name: validation.Null, Rule: true, Chain: nil},
														}},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.EnvelopeSettings", Name: validation.Null, Rule: true,
														Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.EnvelopeSettings.ControlStandardsID", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.EnvelopeSettings.UseControlStandardsIDAsRepetitionCharacter", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.EnvelopeSettings.SenderApplicationID", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.EnvelopeSettings.ReceiverApplicationID", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.EnvelopeSettings.ControlVersionNumber", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.EnvelopeSettings.InterchangeControlNumberLowerBound", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.EnvelopeSettings.InterchangeControlNumberUpperBound", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.EnvelopeSettings.RolloverInterchangeControlNumber", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.EnvelopeSettings.EnableDefaultGroupHeaders", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.EnvelopeSettings.GroupControlNumberLowerBound", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.EnvelopeSettings.GroupControlNumberUpperBound", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.EnvelopeSettings.RolloverGroupControlNumber", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.EnvelopeSettings.GroupHeaderAgencyCode", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.EnvelopeSettings.GroupHeaderVersion", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.EnvelopeSettings.TransactionSetControlNumberLowerBound", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.EnvelopeSettings.TransactionSetControlNumberUpperBound", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.EnvelopeSettings.RolloverTransactionSetControlNumber", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.EnvelopeSettings.OverwriteExistingTransactionSetControlNumber", Name: validation.Null, Rule: true, Chain: nil},
														}},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.AcknowledgementSettings", Name: validation.Null, Rule: true,
														Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.AcknowledgementSettings.NeedTechnicalAcknowledgement", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.AcknowledgementSettings.BatchTechnicalAcknowledgements", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.AcknowledgementSettings.NeedFunctionalAcknowledgement", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.AcknowledgementSettings.BatchFunctionalAcknowledgements", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.AcknowledgementSettings.NeedImplementationAcknowledgement", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.AcknowledgementSettings.BatchImplementationAcknowledgements", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.AcknowledgementSettings.NeedLoopForValidMessages", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.AcknowledgementSettings.SendSynchronousAcknowledgement", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.AcknowledgementSettings.AcknowledgementControlNumberLowerBound", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.AcknowledgementSettings.AcknowledgementControlNumberUpperBound", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.AcknowledgementSettings.RolloverAcknowledgementControlNumber", Name: validation.Null, Rule: true, Chain: nil},
														}},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.MessageFilter", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.SecuritySettings", Name: validation.Null, Rule: true,
														Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.SecuritySettings.AuthorizationQualifier", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.SecuritySettings.SecurityQualifier", Name: validation.Null, Rule: true, Chain: nil},
														}},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.ProcessingSettings", Name: validation.Null, Rule: true,
														Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.ProcessingSettings.MaskSecurityInfo", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.ProcessingSettings.ConvertImpliedDecimal", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.ProcessingSettings.PreserveInterchange", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.ProcessingSettings.SuspendInterchangeOnError", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.ProcessingSettings.CreateEmptyXMLTagsForTrailingSeparators", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.ProcessingSettings.UseDotAsDecimalSeparator", Name: validation.Null, Rule: true, Chain: nil},
														}},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.X12.SendAgreement.ProtocolSettings.SchemaReferences", Name: validation.Null, Rule: true, Chain: nil},
												}},
										}},
								}},
							{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact", Name: validation.Null, Rule: false,
								Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement", Name: validation.Null, Rule: true,
									Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.SenderBusinessIdentity", Name: validation.Null, Rule: true,
										Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.SenderBusinessIdentity.Qualifier", Name: validation.Null, Rule: true, Chain: nil},
											{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.SenderBusinessIdentity.Value", Name: validation.Null, Rule: true, Chain: nil},
										}},
										{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ReceiverBusinessIdentity", Name: validation.Null, Rule: true,
											Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ReceiverBusinessIdentity.Qualifier", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ReceiverBusinessIdentity.Value", Name: validation.Null, Rule: true, Chain: nil},
											}},
										{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings", Name: validation.Null, Rule: true,
											Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.ValidationSettings", Name: validation.Null, Rule: true,
												Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.ValidationSettings.ValidateCharacterSet", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.ValidationSettings.CheckDuplicateInterchangeControlNumber", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.ValidationSettings.InterchangeControlNumberValidityDays", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.ValidationSettings.CheckDuplicateGroupControlNumber", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.ValidationSettings.CheckDuplicateTransactionSetControlNumber", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.ValidationSettings.ValidateEDITypes", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.ValidationSettings.ValidateXSDTypes", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.ValidationSettings.AllowLeadingAndTrailingSpacesAndZeroes", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.ValidationSettings.TrimLeadingAndTrailingSpacesAndZeroes", Name: validation.Null, Rule: true, Chain: nil},
												}},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.FramingSettings", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.FramingSettings.ProtocolVersion", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.FramingSettings.DataElementSeparator", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.FramingSettings.ComponentSeparator", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.FramingSettings.SegmentTerminator", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.FramingSettings.ReleaseIndicator", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.FramingSettings.RepetitionSeparator", Name: validation.Null, Rule: true, Chain: nil},
													}},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.EnvelopeSettings", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.ApplyDelimiterStringAdvice", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.CreateGroupingSegments", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.EnableDefaultGroupHeaders", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.InterchangeControlNumberLowerBound", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.InterchangeControlNumberUpperBound", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.RolloverInterchangeControlNumber", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.GroupControlNumberLowerBound", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.GroupControlNumberUpperBound", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.RolloverGroupControlNumber", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.OverwriteExistingTransactionSetControlNumber", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.TransactionSetControlNumberLowerBound", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.TransactionSetControlNumberUpperBound", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.RolloverTransactionSetControlNumber", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.EnvelopeSettings.IsTestInterchange", Name: validation.Null, Rule: true, Chain: nil},
													}},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings.NeedTechnicalAcknowledgement", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings.BatchTechnicalAcknowledgements", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings.NeedFunctionalAcknowledgement", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings.BatchFunctionalAcknowledgements", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings.NeedLoopForValidMessages", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings.SendSynchronousAcknowledgement", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings.AcknowledgementControlNumberLowerBound", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings.AcknowledgementControlNumberUpperBound", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.AcknowledgementSettings.RolloverAcknowledgementControlNumber", Name: validation.Null, Rule: true, Chain: nil},
													}},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.MessageFilter", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.ProcessingSettings", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.ProcessingSettings.MaskSecurityInfo", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.ProcessingSettings.PreserveInterchange", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.ProcessingSettings.SuspendInterchangeOnError", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.ProcessingSettings.CreateEmptyXMLTagsForTrailingSeparators", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.ProcessingSettings.UseDotAsDecimalSeparator", Name: validation.Null, Rule: true, Chain: nil},
													}},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.ReceiveAgreement.ProtocolSettings.SchemaReferences", Name: validation.Null, Rule: true, Chain: nil},
											}},
									}},
									{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement", Name: validation.Null, Rule: true,
										Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.SenderBusinessIdentity", Name: validation.Null, Rule: true,
											Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.SenderBusinessIdentity.Qualifier", Name: validation.Null, Rule: true, Chain: nil},
												{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.SenderBusinessIdentity.Value", Name: validation.Null, Rule: true, Chain: nil},
											}},
											{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ReceiverBusinessIdentity", Name: validation.Null, Rule: true,
												Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ReceiverBusinessIdentity.Qualifier", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ReceiverBusinessIdentity.Value", Name: validation.Null, Rule: true, Chain: nil},
												}},
											{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings", Name: validation.Null, Rule: true,
												Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.ValidationSettings", Name: validation.Null, Rule: true,
													Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.ValidationSettings.ValidateCharacterSet", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.ValidationSettings.CheckDuplicateInterchangeControlNumber", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.ValidationSettings.InterchangeControlNumberValidityDays", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.ValidationSettings.CheckDuplicateGroupControlNumber", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.ValidationSettings.CheckDuplicateTransactionSetControlNumber", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.ValidationSettings.ValidateEDITypes", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.ValidationSettings.ValidateXSDTypes", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.ValidationSettings.AllowLeadingAndTrailingSpacesAndZeroes", Name: validation.Null, Rule: true, Chain: nil},
														{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.ValidationSettings.TrimLeadingAndTrailingSpacesAndZeroes", Name: validation.Null, Rule: true, Chain: nil},
													}},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.FramingSettings", Name: validation.Null, Rule: true,
														Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.FramingSettings.ProtocolVersion", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.FramingSettings.DataElementSeparator", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.FramingSettings.ComponentSeparator", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.FramingSettings.SegmentTerminator", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.FramingSettings.ReleaseIndicator", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.FramingSettings.RepetitionSeparator", Name: validation.Null, Rule: true, Chain: nil},
														}},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.EnvelopeSettings", Name: validation.Null, Rule: true,
														Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.EnvelopeSettings.ApplyDelimiterStringAdvice", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.EnvelopeSettings.CreateGroupingSegments", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.EnvelopeSettings.EnableDefaultGroupHeaders", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.EnvelopeSettings.InterchangeControlNumberLowerBound", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.EnvelopeSettings.InterchangeControlNumberUpperBound", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.EnvelopeSettings.RolloverInterchangeControlNumber", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.EnvelopeSettings.GroupControlNumberLowerBound", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.EnvelopeSettings.GroupControlNumberUpperBound", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.EnvelopeSettings.RolloverGroupControlNumber", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.EnvelopeSettings.OverwriteExistingTransactionSetControlNumber", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.EnvelopeSettings.TransactionSetControlNumberLowerBound", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.EnvelopeSettings.TransactionSetControlNumberUpperBound", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.EnvelopeSettings.RolloverTransactionSetControlNumber", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.EnvelopeSettings.IsTestInterchange", Name: validation.Null, Rule: true, Chain: nil},
														}},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.AcknowledgementSettings", Name: validation.Null, Rule: true,
														Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.AcknowledgementSettings.NeedTechnicalAcknowledgement", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.AcknowledgementSettings.BatchTechnicalAcknowledgements", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.AcknowledgementSettings.NeedFunctionalAcknowledgement", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.AcknowledgementSettings.BatchFunctionalAcknowledgements", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.AcknowledgementSettings.NeedLoopForValidMessages", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.AcknowledgementSettings.SendSynchronousAcknowledgement", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.AcknowledgementSettings.AcknowledgementControlNumberLowerBound", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.AcknowledgementSettings.AcknowledgementControlNumberUpperBound", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.AcknowledgementSettings.RolloverAcknowledgementControlNumber", Name: validation.Null, Rule: true, Chain: nil},
														}},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.MessageFilter", Name: validation.Null, Rule: true, Chain: nil},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.ProcessingSettings", Name: validation.Null, Rule: true,
														Chain: []validation.Constraint{{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.ProcessingSettings.MaskSecurityInfo", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.ProcessingSettings.PreserveInterchange", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.ProcessingSettings.SuspendInterchangeOnError", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.ProcessingSettings.CreateEmptyXMLTagsForTrailingSeparators", Name: validation.Null, Rule: true, Chain: nil},
															{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.ProcessingSettings.UseDotAsDecimalSeparator", Name: validation.Null, Rule: true, Chain: nil},
														}},
													{Target: "agreement.IntegrationAccountAgreementProperties.Content.Edifact.SendAgreement.ProtocolSettings.SchemaReferences", Name: validation.Null, Rule: true, Chain: nil},
												}},
										}},
								}},
						}},
				}}}}}); err != nil {
		return result, validation.NewError("logic.IntegrationAccountAgreementsClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, integrationAccountName, agreementName, agreement)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logic.IntegrationAccountAgreementsClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "logic.IntegrationAccountAgreementsClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logic.IntegrationAccountAgreementsClient", "CreateOrUpdate", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client IntegrationAccountAgreementsClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, integrationAccountName string, agreementName string, agreement IntegrationAccountAgreement) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"agreementName":          autorest.Encode("path", agreementName),
		"integrationAccountName": autorest.Encode("path", integrationAccountName),
		"resourceGroupName":      autorest.Encode("path", resourceGroupName),
		"subscriptionId":         autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements/{agreementName}", pathParameters),
		autorest.WithJSON(agreement),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client IntegrationAccountAgreementsClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client IntegrationAccountAgreementsClient) CreateOrUpdateResponder(resp *http.Response) (result IntegrationAccountAgreement, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes an integration account agreement.
// Parameters:
// resourceGroupName - the resource group name.
// integrationAccountName - the integration account name.
// agreementName - the integration account agreement name.
func (client IntegrationAccountAgreementsClient) Delete(ctx context.Context, resourceGroupName string, integrationAccountName string, agreementName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountAgreementsClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, resourceGroupName, integrationAccountName, agreementName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logic.IntegrationAccountAgreementsClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "logic.IntegrationAccountAgreementsClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logic.IntegrationAccountAgreementsClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client IntegrationAccountAgreementsClient) DeletePreparer(ctx context.Context, resourceGroupName string, integrationAccountName string, agreementName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"agreementName":          autorest.Encode("path", agreementName),
		"integrationAccountName": autorest.Encode("path", integrationAccountName),
		"resourceGroupName":      autorest.Encode("path", resourceGroupName),
		"subscriptionId":         autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements/{agreementName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client IntegrationAccountAgreementsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client IntegrationAccountAgreementsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets an integration account agreement.
// Parameters:
// resourceGroupName - the resource group name.
// integrationAccountName - the integration account name.
// agreementName - the integration account agreement name.
func (client IntegrationAccountAgreementsClient) Get(ctx context.Context, resourceGroupName string, integrationAccountName string, agreementName string) (result IntegrationAccountAgreement, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountAgreementsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, resourceGroupName, integrationAccountName, agreementName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logic.IntegrationAccountAgreementsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "logic.IntegrationAccountAgreementsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logic.IntegrationAccountAgreementsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client IntegrationAccountAgreementsClient) GetPreparer(ctx context.Context, resourceGroupName string, integrationAccountName string, agreementName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"agreementName":          autorest.Encode("path", agreementName),
		"integrationAccountName": autorest.Encode("path", integrationAccountName),
		"resourceGroupName":      autorest.Encode("path", resourceGroupName),
		"subscriptionId":         autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements/{agreementName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client IntegrationAccountAgreementsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client IntegrationAccountAgreementsClient) GetResponder(resp *http.Response) (result IntegrationAccountAgreement, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List gets a list of integration account agreements.
// Parameters:
// resourceGroupName - the resource group name.
// integrationAccountName - the integration account name.
// top - the number of items to be included in the result.
// filter - the filter to apply on the operation. Options for filters include: AgreementType.
func (client IntegrationAccountAgreementsClient) List(ctx context.Context, resourceGroupName string, integrationAccountName string, top *int32, filter string) (result IntegrationAccountAgreementListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountAgreementsClient.List")
		defer func() {
			sc := -1
			if result.iaalr.Response.Response != nil {
				sc = result.iaalr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, resourceGroupName, integrationAccountName, top, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logic.IntegrationAccountAgreementsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.iaalr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "logic.IntegrationAccountAgreementsClient", "List", resp, "Failure sending request")
		return
	}

	result.iaalr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logic.IntegrationAccountAgreementsClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client IntegrationAccountAgreementsClient) ListPreparer(ctx context.Context, resourceGroupName string, integrationAccountName string, top *int32, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"integrationAccountName": autorest.Encode("path", integrationAccountName),
		"resourceGroupName":      autorest.Encode("path", resourceGroupName),
		"subscriptionId":         autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if top != nil {
		queryParameters["$top"] = autorest.Encode("query", *top)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client IntegrationAccountAgreementsClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client IntegrationAccountAgreementsClient) ListResponder(resp *http.Response) (result IntegrationAccountAgreementListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client IntegrationAccountAgreementsClient) listNextResults(ctx context.Context, lastResults IntegrationAccountAgreementListResult) (result IntegrationAccountAgreementListResult, err error) {
	req, err := lastResults.integrationAccountAgreementListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "logic.IntegrationAccountAgreementsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "logic.IntegrationAccountAgreementsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logic.IntegrationAccountAgreementsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client IntegrationAccountAgreementsClient) ListComplete(ctx context.Context, resourceGroupName string, integrationAccountName string, top *int32, filter string) (result IntegrationAccountAgreementListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountAgreementsClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, resourceGroupName, integrationAccountName, top, filter)
	return
}

// ListContentCallbackURL get the content callback url.
// Parameters:
// resourceGroupName - the resource group name.
// integrationAccountName - the integration account name.
// agreementName - the integration account agreement name.
func (client IntegrationAccountAgreementsClient) ListContentCallbackURL(ctx context.Context, resourceGroupName string, integrationAccountName string, agreementName string, listContentCallbackURL GetCallbackURLParameters) (result WorkflowTriggerCallbackURL, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/IntegrationAccountAgreementsClient.ListContentCallbackURL")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListContentCallbackURLPreparer(ctx, resourceGroupName, integrationAccountName, agreementName, listContentCallbackURL)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logic.IntegrationAccountAgreementsClient", "ListContentCallbackURL", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListContentCallbackURLSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "logic.IntegrationAccountAgreementsClient", "ListContentCallbackURL", resp, "Failure sending request")
		return
	}

	result, err = client.ListContentCallbackURLResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "logic.IntegrationAccountAgreementsClient", "ListContentCallbackURL", resp, "Failure responding to request")
	}

	return
}

// ListContentCallbackURLPreparer prepares the ListContentCallbackURL request.
func (client IntegrationAccountAgreementsClient) ListContentCallbackURLPreparer(ctx context.Context, resourceGroupName string, integrationAccountName string, agreementName string, listContentCallbackURL GetCallbackURLParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"agreementName":          autorest.Encode("path", agreementName),
		"integrationAccountName": autorest.Encode("path", integrationAccountName),
		"resourceGroupName":      autorest.Encode("path", resourceGroupName),
		"subscriptionId":         autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Logic/integrationAccounts/{integrationAccountName}/agreements/{agreementName}/listContentCallbackUrl", pathParameters),
		autorest.WithJSON(listContentCallbackURL),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListContentCallbackURLSender sends the ListContentCallbackURL request. The method will close the
// http.Response Body if it receives an error.
func (client IntegrationAccountAgreementsClient) ListContentCallbackURLSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListContentCallbackURLResponder handles the response to the ListContentCallbackURL request. The method always
// closes the http.Response Body.
func (client IntegrationAccountAgreementsClient) ListContentCallbackURLResponder(resp *http.Response) (result WorkflowTriggerCallbackURL, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
